%--------------------------------------------------------------------------
% File     : SYN014=Quant2-1 : TPTP v1.2.1. Released v1.0.0.
% Domain   : Syntactic
% Problem  : A problem in quantification theory
% Version  : [Wang, 1965] axioms.
% English  : 

% Refs     : Wang H. (1965), Formalization & Automatic Theorem Proving, 
%            Proceedings of the IFIP Congress 1965, 51-58.
%          : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
% Source   : [McCharen, et al., 1976]
% Names    : ExQ2 [Wang, 1965]
%          : EXQ2 [McCharen, et al., 1976]
%          : exq2.ver1.in [ANL]
%          : exq2.ver2.in [ANL]

% Status   : unsatisfiable
% Syntax   : Number of clauses    :   24 (  14 non-Horn;   2 unit;  21 RR)
%            Number of literals   :   71 (  44 equality)
%            Maximal clause size  :    6
%            Number of predicates :    2 (   0 propositional; 2-2 arity)
%            Number of functors   :    6 (   4 constant; 0-1 arity)
%            Number of variables  :   33 (   0 singleton)
%            Maximal term depth   :    2

% Comments : 
%--------------------------------------------------------------------------
%----Include equality axioms 
%include('Axioms/EQU001-0.ax').
include('EQU001-0.ax').
%--------------------------------------------------------------------------
input_clause(c_1,conjecture,
    [--equal(m,n)]).

input_clause(c_2,conjecture,
    [++equal(n,k),
     ++equal(m,k)]).

input_clause(c_3,conjecture,
    [++equal(Y,j),
     --equal(Y,k),
     ++element(Y,j)]).

input_clause(c_4,conjecture,
    [++equal(Y,j),
     ++equal(Y,k),
     --element(Y,j)]).

input_clause(c_5,conjecture,
    [++equal(Y,m),
     --element(Y,m),
     --equal(f(Y),m)]).

input_clause(c_6,conjecture,
    [++equal(Y,m),
     --element(Y,m),
     --equal(f(Y),Y)]).

input_clause(c_7,conjecture,
    [++equal(Y,m),
     --element(Y,m),
     ++element(Y,f(Y))]).

input_clause(c_8,conjecture,
    [++equal(Y,m),
     --element(Y,m),
     ++element(f(Y),Y)]).

input_clause(c_9,conjecture,
    [++equal(Y,m),
     ++element(Y,m),
     ++equal(V1,m),
     ++equal(V1,Y),
     --element(Y,V1),
     --element(V1,Y)]).

input_clause(c_10,conjecture,
    [++equal(Y,n),
     ++element(Y,n),
     --equal(g(Y),n)]).

input_clause(c_11,conjecture,
    [++equal(Y,n),
     ++element(Y,n),
     --equal(g(Y),Y)]).

input_clause(c_12,conjecture,
    [++equal(Y,n),
     ++element(Y,n),
     ++element(Y,g(Y))]).

input_clause(c_13,conjecture,
    [++equal(Y,n),
     ++element(Y,n),
     ++element(g(Y),Y)]).

input_clause(c_14,conjecture,
    [++equal(Y,n),
     --element(Y,n),
     ++equal(V,n),
     ++equal(V,Y),
     --element(Y,V),
     --element(V,Y)]).

input_clause(c_15,conjecture,
    [++equal(Y,k),
     --equal(Y,m),
     ++element(Y,k)]).

input_clause(c_16,conjecture,
    [++equal(Y,k),
     --equal(Y,n),
     ++element(Y,k)]).

input_clause(c_17,conjecture,
    [++equal(Y,k),
     ++equal(Y,m),
     ++equal(Y,n),
     --element(Y,k)]).

input_clause(element_substitution1,axiom,
    [--equal(X,Y),
     --element(X,Z),
     ++element(Y,Z)]).

input_clause(element_substitution2,axiom,
    [--equal(X,Y),
     --element(Z,X),
     ++element(Z,Y)]).

input_clause(f_substitution1,axiom,
    [--equal(X,Y),
     ++equal(f(X),f(Y))]).

input_clause(g_substitution1,axiom,
    [--equal(X,Y),
     ++equal(g(X),g(Y))]).
%--------------------------------------------------------------------------
