/* 
 *  $B#3#D2hA|D:E@Cj=P%W%m%0%i%`(B
 *  Copyright (c) 1997  Fumio Mizoguchi
 */

class VERT{

    double x[][] = new double[9][8];
    double y[][] = new double[9][8];
    double z[][] = new double[9][8];

    double b,w,s,e,p,r;

/* base component */
    double bx = 7;
    double by = 8;
    double bz = 20;
    double by_adj = -4.5;

/* waist component */
    double wx = 10;
    double wy = 12;
    double wz = 10;
    double wy_adj = 4.5;

/* sholder component */
    double sx = 5;
    double sy = 4;
    double sz = 25;

/* elbor component */
    double ex = 3.5;
    double ey = 3.5;
    double ez = 16;

/* pitch component */
    double px = 3.5;
    double py = 2;
    double pz = 7;
    double px_plus,py_plus,pz_plus;

/* hand component */
    double hx = 3.5;
    double hy = 2;
    double hz = 7;

    double base_x_b,base_y_b;
    double base_x,base_y,base_z;

    int block[] = new int[100];
    double block_x[][] = new double[100][8];
    double block_y[][] = new double[100][8];
    double block_z[][] = new double[100][8];
    int block_num = 0;
    int box[] = new int[100];
    double box_x[][] = new double[100][8];
    double box_y[][] = new double[100][8];
    double box_z[][] = new double[100][8];
    int box_num = 0;

    double sizeBlock[][] = new double[100][3];
    double sizeBox[] = new double[100];


    VERT(){}

/* home position vertices */
    VERT(double x, double y, double b){
	this.b = b*3.141592/180;
	base_x_b = x;
	base_y_b = y;
	w = 0;
	s = 1.5707963;
//	s = 0.8;
	e = -1.5707963;
	p = -1.5707963;
	r = 0;
	change0(this.b);
	change1(w);
	change2(s);
	change3(e);
	change4(p);
	change4(r);
    }

    public void Change_L(double x, double y, double b){
	this.b = b*3.141592/180;
	base_x_b = x;
	base_y_b = y;
	w = 0;
	s = 1.5707963;
	e = -1.5707963;
	p = -1.5707963;
	r = 0;
	change0(this.b);
	change1(w);
	change2(s);
	change3(e);
	change4(p);
	change4(r);
    }

/* base vertices */
    void change0(double b){
	this.b = b;
	double br[] = new double[4];
	br[0] = Math.atan(by/bx);
	br[1] = 3.14159265 - br[0];
	br[2] = -1 * br[1];
	br[3] = -1 * br[0];
	double bl = Math.sqrt(bx*bx+by*by);
	for(int i=0;i<4;i++){
	    x[0][i] = x[0][i+4] = bl * Math.cos(br[i]-b) + base_x_b;
	    y[0][i] = y[0][i+4] = bl * Math.sin(br[i]-b) + base_y_b;
	    z[0][i] = 0;
	    z[0][i+4] = bz;
	}
    }
/* waist vertices */
    void change1(double w){
	this.w = w + b;
	base_x = base_x_b;
	base_y = base_y_b + by_adj;
	base_z = bz;
	double wr[] = new double[4];
	double wy1 = wy - by_adj;
	wr[0] = Math.atan(wy1/wx);
	wr[1] = 3.14159265 - wr[0];
	wr[2] = -1 * wr[1];
	wr[3] = -1 * wr[0];
	double wl = Math.sqrt(wx*wx+wy1*wy1);
	for(int i=0;i<4;i++){
	    x[1][i] = x[1][i+4] = wl * Math.cos(wr[i]-this.w) + base_x;
	    y[1][i] = y[1][i+4] = wl * Math.sin(wr[i]-this.w) + base_y_b;
	    z[1][i] = base_z;
	    z[1][i+4] = base_z + wz;
	}
	for(int i=0;i<2;i++){
	    x[1][i] = x[1][i+4] += by_adj * 2 * Math.sin(this.w);
	    y[1][i] = y[1][i+4] += by_adj * 2 * Math.cos(this.w);
	}
    }
/* sholder vertices */
    void change2(double s){
	this.s = s;
	s = 1.5707963 -s;
//	base_x += wx;
//	base_y += wy + wy_adj;
//  mondai //
	base_y += wy_adj;
	base_z += wz;
	double sz_d = sy * Math.sin(s);
	if(this.s>0){
	    z[2][0] = z[2][1] = base_z - sz_d;
	    z[2][2] = z[2][3] = base_z + sz_d;
	} else {
	    z[2][0] = z[2][1] = base_z + sz_d;
	    z[2][2] = z[2][3] = base_z - sz_d;
	}
	double sl = Math.sqrt(sx*sx+sy*sy);
	double sl1 = Math.sqrt(sl*sl - sz_d*sz_d);
	double sy_d = Math.sqrt(sl1*sl1 - sx*sx);
	double sr[] = new double[4];
	sr[0] = Math.atan(sy_d/sx);
	sr[1] = 3.14159265 - sr[0];
	sr[2] = -1 * sr[1];
	sr[3] = -1 * sr[0];
//	sr[0] = Math.atan(sy_d/sx);
//	sr[1] = 3.14159265 - sr[0];
//	sr[2] = Math.atan((-1*sy_d)/sx);
//	sr[3] = -3.14159265 - sr[3];
	for(int i=0;i<4;i++){
	    x[2][i] = sl1 * Math.cos(sr[i]-w) + base_x;
	    y[2][i] = sl1 * Math.sin(sr[i]-w) + base_y;
	}
	double sz_plus = sz * Math.cos(s);
	double sxy_plus = sz * Math.sin(s);
//	double sxy_plus1 = Math.sqrt(sxy_plus*sxy_plus - sx*sx);
	double sx_plus = sxy_plus * Math.sin(w);
	double sy_plus = sxy_plus * Math.cos(w);
	for(int i=0;i<4;i++){
	    x[2][i+4] = x[2][i] + sx_plus;
	    y[2][i+4] = y[2][i] + sy_plus;
	    z[2][i+4] = z[2][i] + sz_plus;
	}
    }
/* elbor vertices */
    void change3(double e){
	this.e = e;
	e = 1.5707963 - s - e;
	double base_xy = sz * Math.cos(s);
	base_x -= base_xy * Math.cos(w+1.5707963);
	base_y += base_xy * Math.sin(w+1.5707963);
	base_z += sz * Math.sin(s);
	double ez_d = ey * Math.sin(e);
	if(this.e+s>0){
	    z[3][0] = z[3][1] = base_z - ez_d;
	    z[3][2] = z[3][3] = base_z + ez_d;
	} else {
	    z[3][0] = z[3][1] = base_z + ez_d;
	    z[3][2] = z[3][3] = base_z - ez_d;
	}
	double el = Math.sqrt(ex*ex+ey*ey);
	double el1 = Math.sqrt(el*el - ez_d*ez_d);
	double ey_d = Math.sqrt(el1*el1 - ex*ex);
	double er[] = new double[4];
        er[0] = Math.atan(ey_d/ex);
        er[1] = 3.14159265 - er[0];
        er[2] = -1 * er[1];
        er[3] = -1 * er[0];
//	er[0] = Math.atan(ey_d/ex);
//	er[1] = 3.14159265 - er[0];
//	er[3] = Math.atan((-1*ey_d)/ex);
//	er[2] = -3.14159265 - er[3];
	for(int i=0;i<4;i++){
	    x[3][i] = el1 * Math.cos(er[i]-w) + base_x;
	    y[3][i] = el1 * Math.sin(er[i]-w) + base_y;
	}
	double ez_plus = ez * Math.cos(e);
	double exy_plus = ez * Math.sin(e);
//	double exy_plus1 = Math.sqrt(exy_plus*exy_plus - ex*ex);
	double ex_plus = exy_plus * Math.sin(w);
	double ey_plus = exy_plus * Math.cos(w);
	for(int i=0;i<4;i++){
	    x[3][i+4] = x[3][i] + ex_plus;
	    y[3][i+4] = y[3][i] + ey_plus;
	    z[3][i+4] = z[3][i] + ez_plus;
	}
    }
/* pitch vertices */
    void change4(double p){
	this.p = p;
	p = 1.5707963 - s - e - p;
	double base_xy = ez * Math.cos(s+e);
	base_x -= base_xy * Math.cos(w+1.5707963);
	base_y += base_xy * Math.sin(w+1.5707963);
	base_z += ez * Math.sin(s+e);
	double pz_d = py * Math.sin(p);
	if(this.p+s+e>0){
	    z[4][0] = z[4][1] = base_z - pz_d;
	    z[4][2] = z[4][3] = base_z + pz_d;
	} else {
	    z[4][0] = z[4][1] = base_z + pz_d;
	    z[4][2] = z[4][3] = base_z - pz_d;
	}
	double pl = Math.sqrt(px*px+py*py);
	double pl1 = Math.sqrt(pl*pl - pz_d*pz_d);
	double py_d = Math.sqrt(pl1*pl1 - px*px);
	double pr[] = new double[4];
        pr[0] = Math.atan(py_d/px);
        pr[1] = 3.14159265 - pr[0];
        pr[2] = -1 * pr[1];
        pr[3] = -1 * pr[0];
//	pr[0] = Math.atan(py_d/px);
//	pr[1] = 3.14159265 - pr[0];
//	pr[3] = Math.atan((-1*py_d)/px);
//	pr[2] = -3.14159265 - pr[3];
	for(int i=0;i<4;i++){
	    x[4][i] = pl1 * Math.cos(pr[i]-w) + base_x;
	    y[4][i] = pl1 * Math.sin(pr[i]-w) + base_y;
	}
	pz_plus = Math.cos(p);
	double pxy_plus = Math.sin(p);
//	double pxy_plus1 = Math.sqrt(pl1*pl1 - px*px);
	px_plus = pxy_plus * Math.sin(w);
	py_plus = pxy_plus * Math.cos(w);
	for(int i=0;i<4;i++){
	    x[4][i+4] = x[4][i] + pz * px_plus;
	    y[4][i+4] = y[4][i] + pz * py_plus;
	    z[4][i+4] = z[4][i] + pz * pz_plus;
	}
    }
/* hand vertices */
    void change5(double r){
	this.r = r;
	base_x += pz * px_plus;
	base_y += pz * py_plus;
	base_z += pz * pz_plus;
	double hr[] = new double[4];
	hr[0] = Math.atan(hy/hx);
	hr[1] = 3.14159265 - hr[0];
	hr[2] = -1 * hr[1];
	hr[3] = -1 * hr[0];
	double hl = Math.sqrt(hx*hx+hy*hy);
	for(int i=0;i<4;i++){
	    x[5][i] = hl * Math.cos(hr[i]-r);
	    y[5][i] = hl * Math.sin(hr[i]-r);
	}
//	for(int i=0;i<4;i++)
//	    System.out.println(""+x[5][i]+","+y[5][i]+","+z[5][i]);
	double hp = 1.5707963 - s - e - p;

	double hz_d[] = new double[4];
        for(int i=0;i<4;i++){
	    hz_d[i] = y[5][i] * Math.sin(hp);
	    y[5][i] = y[5][i] * Math.cos(hp);
        }

	z[5][2] = base_z - hz_d[0];
	z[5][1] = base_z - hz_d[1];
	z[5][0] = base_z - hz_d[2];
	z[5][3] = base_z - hz_d[3];
//	for(int i=0;i<4;i++)
//	    System.out.println(""+x[5][i]+","+y[5][i]+","+z[5][i]);

	double hl1[] = new double[4];
	hl1[0] = Math.sqrt(hl*hl - hz_d[0]*hz_d[0]);
	hl1[1] = Math.sqrt(hl*hl - hz_d[1]*hz_d[1]);
	hl1[2] = Math.sqrt(hl*hl - hz_d[2]*hz_d[2]);
	hl1[3] = Math.sqrt(hl*hl - hz_d[3]*hz_d[3]);
//	double hy_d = Math.sqrt(hl1*hl1 - x[5][0]*x[5][0]);
//      hr[0] = Math.atan(hy_d/x[5][0]);
//        hr[3] = Math.atan(hy_d/x[5][1]);
//	hy_d = Math.sqrt(hl1*hl1 - x[5][1]*x[5][1]);
/*	if(x[5][0]*y[5][0]*x[5][1]*y[5][1]<0){
	    if(x[5][1]*y[5][1]<0){
		hr[1] = hr[3];
		hr[3] += 3.14159265;
		hr[2] = - 3.14159265 + hr[0];
	    } else{
		hr[1] = 3.14159265 + hr[3];
		hr[2] = hr[0];
		hr[0] -= 3.14159265;
	    }
        } else {
	    hr[1] = 3.14159265 + hr[3];
	    hr[2] = - 3.14159265 + hr[0];
	}*/
        hr[0] = Math.atan(y[5][0]/x[5][0]);
        hr[3] = Math.atan(y[5][1]/x[5][1]);
	if(x[5][0]>0){
	    hr[2] = hr[0];
	    hr[0] -= 3.14159265;
	} else hr[2] = - 3.14159265 + hr[0];
	if(x[5][1]>0){
	    hr[1] = hr[3];
	    hr[3] += 3.14159265;
	} else hr[1] = 3.14159265 + hr[3];

/*	double zzz;
	zzz = hr[0];
	hr[0] = hr[1];
	hr[1] = zzz;
	zzz = hr[2];
	hr[2] = hr[3];
	hr[3] = zzz;*/

	for(int i=0;i<4;i++){
	    x[5][i] = hl1[i] * Math.cos(hr[i]-w) + base_x;
	    y[5][i] = hl1[i] * Math.sin(hr[i]-w) + base_y;
	}
//	for(int i=0;i<4;i++)
//	  System.out.println(""+x[5][i]+","+y[5][i]+","+z[5][i]);
//	System.out.println("");
	for(int i=0;i<4;i++){
	    x[5][i+4] = x[5][i] + hz * px_plus;
	    y[5][i+4] = y[5][i] + hz * py_plus;
	    z[5][i+4] = z[5][i] + hz * pz_plus;
	}

	x[6][0] = x[5][4];
	y[6][0] = y[5][4];
	z[6][0] = z[5][4];
	x[6][1] = x[5][5];
	y[6][1] = y[5][5];
	z[6][1] = z[5][5];
	x[6][2] = (3*x[5][5]+x[5][6])/4;
	y[6][2] = (3*y[5][5]+y[5][6])/4;
	z[6][2] = (3*z[5][5]+z[5][6])/4;
	x[6][3] = (3*x[5][4]+x[5][7])/4;
	y[6][3] = (3*y[5][4]+y[5][7])/4;
	z[6][3] = (3*z[5][4]+z[5][7])/4;
	for(int i=0;i<4;i++){
	    x[6][i+4] = x[6][i] + px_plus*4;
	    y[6][i+4] = y[6][i] + py_plus*4;
	    z[6][i+4] = z[6][i] + pz_plus*4;
	}
	x[7][0] = x[5][6];
	y[7][0] = y[5][6];
	z[7][0] = z[5][6];
	x[7][1] = x[5][7];
	y[7][1] = y[5][7];
	z[7][1] = z[5][7];
	x[7][2] = (3*x[5][7]+x[5][4])/4;
	y[7][2] = (3*y[5][7]+y[5][4])/4;
	z[7][2] = (3*z[5][7]+z[5][4])/4;
	x[7][3] = (3*x[5][6]+x[5][5])/4;
	y[7][3] = (3*y[5][6]+y[5][5])/4;
	z[7][3] = (3*z[5][6]+z[5][5])/4;
	for(int i=0;i<4;i++){
	    x[7][i+4] = x[7][i] + px_plus*4;
	    y[7][i+4] = y[7][i] + py_plus*4;
	    z[7][i+4] = z[7][i] + pz_plus*4;
	}
    }
/* block vertices on table */
    void block(double x, double y, double k, double cl){
	if(cl == 1){
	    sizeBlock[block_num][0] = 2.8284271;
	    sizeBlock[block_num][1] = 2.8284371;
	    sizeBlock[block_num][2] = 4.0;
	}
	else if(cl == 3){
	    sizeBlock[block_num][0] = (2.8284271 * 3) / 4;
	    sizeBlock[block_num][1] = (2.8284371 * 3) / 4;
	    sizeBlock[block_num][2] = (4.0 * 3) / 4;
	}

	k = k*3.141592/180;
	//double k1 = Math.atan(x/y);
	double k1 = 0;
	double blr[] = {0.78539816,2.3561945,-2.3561945,-0.78539816};
	for(int i=0;i<4;i++){
	    block_x[block_num][i] = block_x[block_num][i+4] = 
	      sizeBlock[block_num][0]* Math.cos(blr[i]-k1-k) + base_x_b + x;
	    block_y[block_num][i] = block_y[block_num][i+4] = 
	      sizeBlock[block_num][1]* Math.sin(blr[i]-k1-k) + base_y_b + y;
	    block_z[block_num][i] = 0;
	    block_z[block_num][i+4] = sizeBlock[block_num][2];
	}
	++block_num;
    }

    void change_block(int num, double x, double y, double k){
	k = k*3.141592/180;
	//double k1 = Math.atan(x/y);
	double k1 = 0;
	double blr[] = {0.78539816,2.3561945,-2.3561945,-0.78539816};
	for(int i=0;i<4;i++){
	    block_x[num][i] = block_x[num][i+4] = 
	      sizeBlock[num][0]* Math.cos(blr[i]-k1-k) + base_x_b + x;
	    block_y[num][i] = block_y[num][i+4] = 
	      sizeBlock[num][1] * Math.sin(blr[i]-k1-k) + base_y_b + y;
	    block_z[num][i] = 0;
	    block_z[num][i+4] = sizeBlock[num][0];
	}
    }


/* block vertices holding */
    void block(int block_num,VERT vt){
	block_x[block_num][0] = vt.x[6][2];
	block_y[block_num][0] = vt.y[6][2];
	block_z[block_num][0] = vt.z[6][2];
	block_x[block_num][1] = vt.x[6][3];
	block_y[block_num][1] = vt.y[6][3];
	block_z[block_num][1] = vt.z[6][3];
	block_x[block_num][2] = vt.x[7][3];
	block_y[block_num][2] = vt.y[7][3];
	block_z[block_num][2] = vt.z[7][3];
	block_x[block_num][3] = vt.x[7][2];
	block_y[block_num][3] = vt.y[7][2];
	block_z[block_num][3] = vt.z[7][2];
	for(int i=0;i<4;i++){
	    block_x[block_num][i] += vt.px_plus;
	    block_y[block_num][i] += vt.py_plus;
	    block_z[block_num][i] += vt.pz_plus;
	}
	for(int i=0;i<4;i++){
	    block_x[block_num][i+4] = block_x[block_num][i] + vt.px_plus*4;
	    block_y[block_num][i+4] = block_y[block_num][i] + vt.py_plus*4;
	    block_z[block_num][i+4] = block_z[block_num][i] + vt.pz_plus*4;
	}
    }
/* block vertices in drop */
    void db(double drop, int block_num, VERT vt, double point[]){
	if( drop == 0 ){
	    double br[] = {0.78539816,2.3561945,-2.3561945,-0.78539816};
            double bl = Math.sqrt(bx*bx+by*by);
            double rand1,rand2,rand3;

	    rand1 = 0; rand2 = 0; rand3 = 0;
            for(int i=0;i<4;i++){
		block_x[block_num][i] = block_x[block_num][i+4] 
		  = sizeBlock[block_num][0] * 
		    Math.cos(br[i]-point[4]+rand3) + base_x_b
		    + point[0]/10 + rand1;
		block_y[block_num][i] = block_y[block_num][i+4] 
		  = sizeBlock[block_num][1] * 
		    Math.sin(br[i]-point[4]+rand3) + base_y_b
		    + point[1]/10 + rand2;
		
                block_z[block_num][i] = (float)0;
                block_z[block_num][i+4] = block_z[block_num][i] + 
		  sizeBlock[block_num][2];
            }
        }
        else{
	    
	    for(int i=0;i<8;i++){
		block_z[block_num][i] -= drop;
	    }
	}
    }
/* box vertices */
    void box(double x, double y, double k, double bc){
	if(bc == 0)
	  sizeBox[box_num] = 8;
	else if(bc == 2)
	  sizeBox[box_num] = 5;

	double blr[] = {0.78539816,2.3561945,-2.3561945,-0.78539816};

	for(int i=0;i<4;i++){
	    box_x[box_num][i] = box_x[box_num][i+4] = 
	      sizeBox[box_num] * Math.cos(blr[i]-b) + base_x_b + x;
	    box_y[box_num][i] = box_y[box_num][i+4] = 
	      sizeBox[box_num] * Math.sin(blr[i]-b) + base_y_b + y;
	    box_z[box_num][i] = 0;
	    box_z[box_num][i+4] = sizeBox[box_num];
	}
	++box_num;
    }

    void change_box(int num, double x, double y, double k){
	double blr[] = {0.78539816,2.3561945,-2.3561945,-0.78539816};

	for(int i=0;i<4;i++){
	    box_x[num][i] = box_x[num][i+4] = 
	      sizeBox[num] * Math.cos(blr[i]-b) + base_x_b + x;
	    box_y[num][i] = box_y[num][i+4] = 
	      sizeBox[num] * Math.sin(blr[i]-b) + base_y_b + y;
	    box_z[num][i] = 0;
	    box_z[num][i+4] = sizeBox[num];
	}
    }
}

