/* 
 *  KLIC$B%7%9%F%`4F;k%W%m%0%i%`(B
 *  Copyright (c) 1997  Fumio Mizoguchi
 */

import java.applet.Applet;
import java.net.URL;
import java.io.*;
import java.net.*;
import java.awt.*;
import java.lang.*;

public class KL1Monitor implements Runnable{
    Thread thread = null;
    PVS1 pvs;
    KL1Robot kl1Robot;
    int me, mode;
    boolean real;
    SocketConnect klic1, klic2, robot;
    int robNum;

    KL1Monitor(KL1Chat kl1Chat) {
	this.me = kl1Chat.me;
	this.kl1Robot = kl1Chat.kl1Robot;
	this.pvs = kl1Robot.pvs;
	mode = pvs.mode;
	klic1 = kl1Chat.klic1;
	klic2 = kl1Chat.klic2;
	robot = kl1Chat.robot;
	robNum = kl1Chat.robNum;
	thread_start();
    }

    public void thread_start() {
	if(thread == null) {
	    thread = new Thread(this);
	    thread.start();
	}
    }

    public void thread_stop() {
	if(thread != null) {
	    thread.stop();
	    thread = null;
	    System.out.println("KL1Monitor Thread Stop");
	}
    }

    public void closeSystem(){
	thread_stop();
	klic1.Close();
	klic2.Close();
    }

    public synchronized void run(){
	boolean connect = true;
	boolean connect2 = true;
	while(connect && connect2) {
	    boolean real = kl1Robot.real;

	    String S = klic1.ReadKLIC();
		
	    System.out.println("Read "+me+" : " + S);
	    if(S == null) connect = false;

	    if(S != null && S.length() >= 2){
		if(real) pvs.realCommand(true, robNum, S);
		kl1Robot.CommandRead(me, S);
		pvs.sendCommand(robNum, mode, S, pvs.LR[mode][robNum][3]);

		if(real){
		    String retS = null;
		    boolean ret = false;
		    while( ret == false){
			/* $B>pJs$N<u$1$H$j(B */
			retS = pvs.so_com[mode][robNum].receive();
			//System.out.println(retS);
			//System.out.println(retS.substring(0,2));
			/* $B>pJs$N>H9g(B */
			if ("o".equals(retS.substring(0,1))) ret = true; 
			else retS = null;
		    }
		    if(pvs.n[mode][robNum].running){
			pvs.robotAnimaStop(robNum, mode); 
		    }
		    if(pvs.wd[mode].calib){
			if(pvs.n[mode][robNum].old_point[2] > 350) {
			    pvs.wd[mode].dataSend();
			}
		    }
		}
		else {
		    try{Thread.sleep(100);}
		    catch(InterruptedException e){}
		    while(pvs.n[mode][robNum].running){
			try{Thread.sleep(100);}
			catch(InterruptedException e){}
		    }
		}
		connect2 = klic2.SendKLIC("ok\0");
		kl1Robot.CommandEnd(me);
	    }
	    else {
		System.out.println("Miss Data");
		connect2 = klic2.SendKLIC("no\0");
	    }
	}
	klic1.Close();
	klic2.Close();
    }
}


