/**********************************************************************/
/*                                                                    */
/*      vp_util.c                                                     */
/*      Program of Vision Process utility (Hiraishi version)          */
/*                                                                    */
/*        Copyright (c) 1997  Fumio Mizoguchi                         */
/*                                                                    */
/**********************************************************************/
#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>

#define NO     0
#define YES    1
#define BLACK  1
#define WHITE  255
#define OK     6
#define BO     3
#define SI     2

struct Process_Area {
    int min_x, max_x, min_y, max_y;
};

struct Line_Atrribute {
    int num;
    int min;
    int max; 
};

typedef struct Process_Area   PAREA;
typedef struct Line_Atrribute PLINE;


/***** FUNCTION PROTOTYPE ******/
void change_xy(int xy[320][240], unsigned char*, int, int, int, int);
void filtering(int xy[320][240], unsigned char*, int, int, int, int);
int  filter(int, int, int, int, int xy[320][240]);
int  get_process_area(int*,int*,int*,int*,int xy[320][240],int,int);
int  possible_area(int*, int*, int xy[320][240], int, int);
int  possible_x_line(PLINE*, int*, int xy[320][240], int, int);
int  possible_y_line(PLINE*, int*, int xy[320][240], int, int);
void dispaly_p_area(int, int, int, int, unsigned char*, int, int, int);
int  itostr(char*, int);
void read_socket(int, char*);
void write_socket(int, char*);

/**** EXTERNALDATA *****/
extern Display *xdisplay;


/***** CHANGE_XY FUNCTION *********************************************/
void change_xy(int xy[320][240], unsigned char *image_data, 
               int image_width, int image_height, int thres, int Mode)
{
    /***** INTERNALDATA *****/
    int i;
        
    /***** PROCESS *****/
    if(Mode == YES){
        for(i=0; i<image_width*image_height; i++){
            if(*(image_data+i)<thres){
                *(image_data +i) = BlackPixel(xdisplay, 0);
                xy[i%image_width][i/image_width] = 1;
            }
            else{
                *(image_data +i) = WhitePixel(xdisplay, 0);
                xy[i%image_width][i/image_width] = 0;
            }
        }
    }
    else{
        for(i=0; i<image_width*image_height; i++){
            if(*(image_data+i)<thres){
                xy[i%image_width][i/image_width] = 1;
            }
            else{
                xy[i%image_width][i/image_width] = 0;
            }
        }
    }
    filtering(xy,image_data,image_width,image_height,thres,Mode);
}
/***** END OF CHANGE_XY FUNCTION **************************************/


/***** FILTERLING FUNCTION ********************************************/
void filtering(int xy[320][240], unsigned char *image_data, 
	       int image_width, int image_height, int thres, int Mode)
{
    /***** INTERNALDATA *****/
    int i, j, xy_data[320][240];
    
    /***** PROCESS *****/
    if(Mode == YES){
	for(j=0; j<image_height; j++){
	    for(i=0; i<image_width; i++){
		xy_data[i][j]=filter(i,j,image_width,image_height,xy);
		if(xy_data[i][j] == 0){
		    *(image_data+i+image_width*j)
		      = WhitePixel(xdisplay, 0);
		}
		else{
		    *(image_data+i+image_width*j)
		      = BlackPixel(xdisplay, 0);
		}
	    }
	}
    }
    else{
	for(j=0; j<image_height; j++){
	    for(i=0; i<image_width; i++){
		xy_data[i][j]=filter(i,j,image_width,image_height,xy);
	    }
	}
    }
    memcpy(xy, xy_data, image_width*image_height);
}
/***** END OF FILTERLING FUNCTION *************************************/


/***** FILTER FUNCTION ************************************************/
int filter(int x, int y, 
	   int image_width, int image_height, int xy[320][240])
{
    /***** INTERNALDATA *****/
    int black;

    /***** PROCESS *****/
    black = 0;

    if(x != 0 && y != 0 && x != image_width-1 && y != image_height-1){
	black = xy[x-1][y-1]+xy[x][y-1]+xy[x+1][y-1]
	       +xy[x-1][y]             +xy[x+1][y]
	       +xy[x-1][y+1]+xy[x][y+1]+xy[x+1][y+1];
	if(black >= 4){
	    return 1;
	}
	else{
	    return 0;
	}
    }
    else if(x == 0 && y != 0 && y != image_height-1){
	black = xy[x][y-1]+xy[x+1][y-1]
	                  +xy[x+1][y]
	       +xy[x][y+1]+xy[x+1][y+1];
	if(black >= 3){
	    return 1;
	}
	else{
	    return 0;
	}
    }
    else if(x != 0 && x != image_width-1 && y == 0){
	black = xy[x-1][y]             +xy[x+1][y]
	       +xy[x-1][y+1]+xy[x][y+1]+xy[x+1][y+1];
	if(black >= 3){
	    return 1;
	}
	else{
	    return 0;
	}
    }
    else if(y != 0 && y != image_height-1 && x == image_width-1){
	black = xy[x-1][y-1]+xy[x][y-1]
	       +xy[x-1][y]
	       +xy[x-1][y+1]+xy[x][y+1];
	if(black >= 3){
	    return 1;
	}
	else{
	    return 0;
	}
    }
    else if(x != 0 && x != image_width-1 && y == image_height-1){
	black = xy[x-1][y-1]+xy[x][y-1]+xy[x+1][y-1]
	       +xy[x-1][y]             +xy[x+1][y];
	if(black >= 3){
	    return 1;
	}
	else{
	    return 0;
	}
    }
    else if(x == 0 && y == 0){ 
	black =            xy[x+1][y]
	       +xy[x][y+1]+xy[x+1][y+1];
	if(black >= 2){
	    return 1;
	}
	else{
	    return 0;
	}
    }
    else if(x == image_width-1 && y == image_height-1){
	black = xy[x-1][y-1]+xy[x][y-1]
               +xy[x-1][y];
	if(black >= 2){
	    return 1;
	}
	else{
	    return 0;
	}
    }
    else if(x == 0 && y == image_height-1){
	black = xy[x][y-1]+xy[x+1][y-1]
                          +xy[x+1][y];
	if(black >= 2){
	    return 1;
	}
	else{
	    return 0;
	}
    }
    else if(x == image_width-1 && y == 0){
    	black = xy[x-1][y]
               +xy[x-1][y+1]+xy[x][y+1];
	if(black >= 4){
	    return 1;
	}
	else{
	    return 0;
	}
    }    
}
/***** FILTER FUNCTION ************************************************/


/***** GET_PROCESS_AREA FUNCTION **************************************/
int get_process_area(int *p_min_x, int *p_max_x, 
                     int *p_min_y, int *p_max_y, int xy[320][240], 
		     int image_width, int image_height)
{
    /***** INTERNALDATA *****/
    int   x_num,  y_num, p_num;
    PLINE x[240], y[320];
    PAREA p_area[120];
    int   up, left, down, right, try;
    int   max_x, flg, i;
        
    /***** PROCESS *****/
    x_num = y_num = p_num = 0;
    
    if(!possible_x_line(x, &x_num, xy, image_width, image_height)){
	return 0;
    }
    if(!possible_y_line(y, &y_num, xy, image_width, image_height)){
	return 0;
    }
    
    for(up=0; up<x_num; up++){
	p_area[p_num].min_x = x[up].min;
	p_area[p_num].max_x = x[up].max;
	flg = 0;
	for(try=up+1; try<up+OK; try++){
	    if(x[try-1].num != x[try].num-1){
		flg = 1;
		break;
	    }
	    if(x[try].min > p_area[p_num].min_x){
		p_area[p_num].min_x = x[try].min;
	    }
	    if(x[try].max < p_area[p_num].max_x){
		p_area[p_num].max_x = x[try].max;
	    }
	}
	if(flg == 1 || p_area[p_num].max_x-p_area[p_num].min_x 
	   < image_width/BO-OK){
	    continue;
	}
	
	max_x = p_area[p_num].max_x;
	p_area[p_num].min_y = x[up].num;
	
	for(left=0; left<y_num; left++){
	    if(y[left].num >= p_area[p_num].min_x &&
	       p_area[p_num].min_y >= y[left].min){
		p_area[p_num].max_y = y[left].max;
		flg = 0;
		for(try=left+1; try<left+OK; try++){
		    if(y[try-1].num != y[try].num-1 ||
		       p_area[p_num].min_y < y[try].min){
			flg = 1;
			break;
		    }
		    if(y[try].max < p_area[p_num].max_y){
			p_area[p_num].max_y = y[try].max;
		    }
		}
		if(flg == 0){
		    break;
		}
	    }
	}
	if(flg == 1 || p_area[p_num].max_y-p_area[p_num].min_y 
	   < image_height/BO-OK){
	    continue;
	}
	
	p_area[p_num].min_x = y[left].num;
	
	for(down=x_num-1; down>=0; down--){
	    if(x[down].num <= p_area[p_num].max_y &&
	       p_area[p_num].min_x >= x[down].min){
		p_area[p_num].max_x = x[down].max;
		flg = 0;
		for(try=down-1; try>down-OK; try--){
		    if(x[try+1].num != x[try].num+1 ||
		       p_area[p_num].min_x < x[try].min){
			flg = 1;
			break;
		    }
		    if(x[try].max < p_area[p_num].max_x){
			p_area[p_num].max_x = x[try].max;
		    }
		}
		if(flg == 0){
		    break;
		}
	    }
	}
	if(flg == 1 || p_area[p_num].max_x-p_area[p_num].min_x 
	   < image_width/BO-OK){
	    continue;
	}
	
	p_area[p_num].max_y = x[down].num;
		
	if(max_x < p_area[p_num].max_x){
	    p_area[p_num].max_x = max_x;
	}
	for(right=y_num-1; right>=0; right--){
	    if(y[right].num <= p_area[p_num].max_x &&
	       y[right].min <= p_area[p_num].min_y && 
	       p_area[p_num].max_y <= y[right].max){
		flg = 0;
		for(try=right-1; try>right-OK; try--){
		    if(y[try+1].num != y[try].num+1 &&
		       y[try].min > p_area[p_num].min_y && 
		       p_area[p_num].max_y > y[try].max){
			flg = 1;
			break;
		    }
		}
		if(flg == 0){
		    break;
		}
	    }
	}
	if(flg == 1){
	    continue;
	}
	
	p_area[p_num].max_x = y[right].num;
	p_num++;
    }
    
    if(p_num == 0){
	return 0;
    }
    
    *p_min_x = p_area[0].min_x;
    *p_max_x = p_area[0].max_x;
    *p_min_y = p_area[0].min_y;
    *p_max_y = p_area[0].max_y;

    for(i=1; i<p_num; i++){
	if((*p_max_x - *p_min_x) * (*p_max_y - *p_min_y) <
	   (p_area[i].max_x-p_area[i].min_x)*
	   (p_area[i].max_y-p_area[i].min_y)){
	    *p_min_x = p_area[i].min_x;

	    *p_max_x = p_area[i].max_x;
	    *p_min_y = p_area[i].min_y;
	    *p_max_y = p_area[i].max_y;
	}
    }
    
    return 1;
}
/***** END OF GET_PROCESS_AREA FUNCTION *******************************/


/***** POSSIBLE_X_LINE FUNCTION ***************************************/
int possible_x_line(PLINE x[240], int *x_num, int xy[320][240], 
		    int image_width, int image_height)
{
    /***** INTERNALDATA *****/
    int i, j, flg, up;
    
    /***** PROCESS *****/
    
    for(j=0; j<image_height; j++){
	for(i=0; i<image_width*SI/BO; i++){
	    if(xy[i][j] == 0){
		x[*x_num].num = j;
		x[*x_num].min = i;
		
		flg = 0;
		for(i++; i<image_width; i++){
		    if(xy[i][j] == 1){
			if(i-1-x[*x_num].min > image_width/BO){
			    break;
			}
			else{
			    flg = 1;
			    break;
			}
		    }
		}
		if(flg == 1){
		    if(i > image_width*SI/BO){
			break;
		    }
		}
		else{
		    x[*x_num].max = i-1;
		    (*x_num)++;
		    break;
		}
	    }
	}
    }
        
    if(*x_num < image_height/BO){
	return 0;
    }
    else{
	return 1;
    }
}
/***** END OF POSSIBLE_X_LINE FUNCTION ********************************/


/***** POSSIBLE_Y_LINE FUNCTION ***************************************/
int possible_y_line(PLINE y[320], int *y_num, int xy[320][240], 
		    int image_width, int image_height)
{
    /***** INTERNALDATA *****/
    int i, j, flg, left;
    
    /***** PROCESS *****/
    
    for(i=0; i<image_width; i++){
	for(j=0; j<image_height*SI/BO; j++){
	    if(xy[i][j] == 0){
		y[*y_num].num = i;
		y[*y_num].min = j;
		flg = 0;
		for(j++; j<image_height; j++){
		    if(xy[i][j] == 1){
			if(j-1-y[*y_num].min > image_height/BO){
			    break;
			}
			else{
			    flg = 1;
			    break;
			}
		    }
		}
		if(flg == 1){
		    if(j > image_height*SI/BO){
			break;
		    }
		}
		else{
		    y[*y_num].max = j-1;
		    (*y_num)++;
		    break;
		}

	    }
	}
    }
    
    if(*y_num < image_width/BO){
	return 0;
    }
    else{
	return 1;
    }
}
/***** END OF POSSIBLE_Y_LINE FUNCTION ********************************/


/***** DISPLAY_P_AREA FUNCTION ****************************************/
void dispaly_p_area(int p_min_x, int p_max_x, int p_min_y, int p_max_y,
		    unsigned char *image_data, 
		    int image_width, int image_height, int Mode)
{
    /***** INTERNALDATA *****/
    int i,j;
    
    /***** PROCESS *****/
    if(Mode == YES){
	for(j=0; j<image_height; j++){
	    for(i=0; i<image_width; i++){
		if(p_min_x <= i && i<=p_max_x &&
		   p_min_y <= j && j<=p_max_y){
		    *(image_data+image_width*j+i) = 
		      WhitePixel(xdisplay, 0);
		}
		else{
		    *(image_data+image_width*j+i) = 
		      BlackPixel(xdisplay, 0);
		}
	    }
	}
    }
    else{
	return;
    }
}
/***** END OF DISPLAY_P_AREA FUNCTION *********************************/


/***** ITOSTR FUNCTION ************************************************/
int itostr(char *data, int num)
{
    /***** INTERNALDATA *****/
    int i,h1,h2,h3,h4,h5;
    
    
    /***** PROCESS *****/
    i = 0;
    if(num < 0){
        *(data+i) = '-';
        i++;
        num = -1*num;
    }
    
    h5 = num/10000;
    h4 = (num-10000*h5)/1000;
    h3 = (num-10000*h5-1000*h4)/100;
    h2 = (num-10000*h5-1000*h4-100*h3)/10;
    h1 = (num-10000*h5-1000*h4-100*h3-10*h2);

    if(h5 == 0){
        if(h4 == 0){
            if(h3 == 0){
                if(h2 == 0){
                    *(data+i) = (char)(h1+0x30);
                    i++;
                }else{
                    *(data+i) = (char)(h2+0x30);
                    i++;
                    *(data+i) = (char)(h1+0x30);
                    i++;
                }
            }
            else{
                *(data+i) = (char)(h3+0x30);
                i++;
                *(data+i) = (char)(h2+0x30);
                i++;
                *(data+i) = (char)(h1+0x30);
                i++;
            }
        }
        else{
            *(data+i) = (char)(h4+0x30);
            i++;
            *(data+i) = (char)(h3+0x30);
            i++;
            *(data+i) = (char)(h2+0x30);
            i++;
            *(data+i) = (char)(h1+0x30);
            i++;
        }
    }
    else{
        *(data+i) = (char)(h5+0x30);
        i++;
        *(data+i) = (char)(h4+0x30);
        i++;
        *(data+i) = (char)(h3+0x30);
        i++;
        *(data+i) = (char)(h2+0x30);
        i++;
        *(data+i) = (char)(h1+0x30);
        i++;
    }
    *(data+i) = (char)NULL;
    
    return i;
}
/***** END OF ITOSTR FUNCTION *****************************************/




/***** READ_SOCKET FUNCTION *******************************************/
void read_socket(int s, char data[50])
{
    /***** INTERNALDATA *****/
    FILE *fp;
    int i;
    char c;

    /***** PROCESS *****/
    fp = fdopen(s,"r");
    
    i=0;
    while((data[i]=getc(fp)) != EOF){
	if(data[i] == '.'){
	    data[i] = '\0';
	    break;
	}
	i++;
    }
    fclose(fp);
    printf("%s\n",data);
}
/***** END OF READ_SOCKET FUNCTION ************************************/


/***** WRITE_SOCKET FUNCTION ******************************************/
void write_socket(int s, char data[50])
{
    /***** INTERNALDATA *****/
    int i;
    FILE *fp;
    
    /***** PROCESS *****/
    strcat(data, ".");
    
    fp = fdopen(s,"a");
    
    for(i=0; i<100; i++){
	putc(data[i], fp);
	if(data[i] == '.'){
	    break;
	}
    }
    fclose(fp);
}
/***** END OF WRITE_SOCKET FUNCTION ***********************************/

