/**********************************************************************/
/*                                                                    */
/*      program of Vserver.c                                          */
/*      Main program of vision system Server Side (For Soralis)       */
/*                                                                    */
/*        Copyright (c) 1997  Fumio Mizoguchi                         */
/*                                                                    */
/**********************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <sys/times.h>
#include <sys/time.h>
#include <sys/stat.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <xil/xil.h>

#define SINGLE      'g'
#define PARA        'p'
#define LANDMARK    '1'
#define BARCODE     '2'
#define POINT       '3'
#define UNIX_LOOK   '4'
#define STOP_VP     's'
#define END_VP      'e'
#define DATA        'd'             /* for data                       */
#define CONT        'c'             /* for control                    */
#define DATA_SIZE   20              /* data size                      */
#define HOSTNAME    20              /* hostname size                  */
#define VPFLG       5               /* vp_flg size                    */
#define Yes         -2
#define No          -3
#define NO          0
#define YES         1
#define ERR         5
#define NON_DATA    "nodata"



/***** FUNCTION PROTOTYPE *****/
void main(int,char**);
int  init_vision(int, char**);
void setup_hware(void);
void binary(unsigned char*);
void no_image(void);
void set_threshold(char*);   
int  vs_menu(void);
void vision_process(char*);   
void done(void);
int connect_server(int);

/***** EXTERNAL DATA *****/

/*
 * For SunVideo.
 */
XilSystemState state;
XilImage rtvc_image, rtvc_luma, display;
XilImage rescaled_image, scaled_image, single_band;
unsigned int width, height, nbands;
char *devname = "/dev/rtvc0";
XilMemoryStorage storage;
int socketN;
int java_vision_port = 12401; 
 
int doscale = 2;                    /* Vision Scale                   */
int port = 1;
int max_buffers = -1;
float scale_factor;

int image_skip = 0;


/*
 * For Window. 
 */
Display *xdisplay;
Window  xwindow;

/*
 * For Image.
 */
int             Thres, Mode=YES, ok=0, B_flg = 0;
int             Argc;
char            **Argv;


/* 
 * For Vision Processing.
 */
int             l_thres;            /* Threshold for LandMark         */
int             b_thres;            /* Threshold for BarCode          */
int             p_thres;            /* Threshold for Point Follow     */
int             r_thres;            /* Threshold for UNIX_Look           */


struct timeval t0, t1;
/*
 * For Socket Communication.
 */
int                c_s, c_ns;       /* control socket                 */
struct sockaddr_in c_sin,c_fsin;
int                c_fromlen;
int                d_s      ;       /* data socket                    */
struct sockaddr_in d_sin;
char            hostname[HOSTNAME]; /* client hostname                */
struct timeval  tv;
double          t;

int frames = 0;    
int counter = 0;

char Level  = SINGLE;               /* Current Level                  */
char Vp     = STOP_VP;              /* Current VP                     */


/***** MAIN FUNCTION **************************************************/
void main(int argc, char **argv)
{
    /***** INTERNALDATA *****/
    char vp_flg[10], data[100];                
    XEvent event;
    int fd;
    printf("clear data\n");
    
    /***** PROCESS *****/
    strcpy(vp_flg, "4");         /* UNIX_Look Process                 */
    Vp = UNIX_LOOK;

    init_vision(argc, argv);        /* Initialize Video System        */

    printf("\nWell Come to Vision Processing Server !!\n");

    socketN = connect_server(java_vision_port);

    
    XMapWindow(xdisplay, xwindow);
    XFlush(xdisplay);
    
    /* set_threshold(vp_flg); */          /* Set threshold by vp flg        */

    printf("\nIf you don't need Picture,\n");
    printf("     You should push Mouse Button in the Picture\n");
    printf("\nAnd you want to exit VServer, Type ``end''\n");


    while(1){
	if(frames == 0){
	    gettimeofday(&t0, NULL);
	} 
	
	frames++;

	if(XPending(xdisplay) == 0){
	    vision_process(data);

	    vs_menu();
	    continue;
	}
	else{
	    XNextEvent(xdisplay, &event);
	    if(event.type == ButtonPress){
		switch(event.xbutton.button){
		case 1:
		    no_image();
		    break;
		case 2:
		    no_image();
		    break;
		case 3:
		    no_image();
		    break;
		default:
		    ;
		}
	    }
	}
    }
}
/***** END OF MAIN FUNCTION *******************************************/


/***** CONNECT_SERVER FUNCTION ****************************************/
int connect_server(int port)
{
    int fromlen;
    int s,sn;
    struct sockaddr_in   sin,from;
    struct servent *sp;

    s = socket(AF_INET, SOCK_STREAM, 0);
    if(s < 0){
        fprintf(stderr, "rwriteed: socket\n");
        exit(1);
    }
    sin.sin_family = AF_INET;
    sin.sin_port = port;       /*       */
    sin.sin_addr.s_addr = INADDR_ANY;/*{133.31.108.183};*/
    while(bind(s, (caddr_t)&sin, sizeof(sin)) < 0){
        fprintf(stderr, "rwrited: bind\n");
        sleep(5);
    }
    if(listen(s,5) < 0){
        fprintf(stderr, "rwrited: listen\n");
        exit(1);
    }

    fromlen = sizeof(from);
    sn = accept(s, &from, &fromlen);
    if(sn < 0){
        /* fprintf(stderr, "rwrited: accept\n"); */
        sleep(5);
        exit(-1);
    }
    close(s);
    printf("Connect Socket !!!\n");

    return sn;
}
/***** END OF CONNECT_SERVER FUNCTION **********************************/


/***** INIT_VISION FUNCTION *******************************************/
int init_vision(int argc,char **argv)
{
    /***** INTERNAL DATA *****/
    XilLookup grayramp;
    int num_entries = 256;
    int i;
    Xil_unsigned8 *graydata = malloc(3 * num_entries);

    /***** PROCESS *****/
    setup_hware();                  /* setup hardware                 */
    
    xdisplay = XOpenDisplay(NULL);  /* connect Xserver                */
    if (!xdisplay) {
	fprintf(stderr, "Unable to connect to server\n");
	xil_close(state);
	exit(1);
    }

    xwindow = XCreateSimpleWindow(xdisplay,
				  DefaultRootWindow(xdisplay),
				  100, 100, width, height, 
				  0, 0, 0);
    if (!xwindow) {
	fprintf(stderr, "Unable to create window\n");
	xil_close(state);
	exit(1);
    }

    XStoreName(xdisplay, xwindow, "Vision Processing System");


    XSelectInput(xdisplay, xwindow, 
		 ExposureMask | ButtonPressMask | KeyPressMask);
    
    for (i = 0; i < num_entries; i++) {
	graydata[i * 3 + 2] = graydata[i * 3 + 1] 
	  = graydata[i * 3] = i;
    }
    
    grayramp = xil_lookup_create(state, XIL_BYTE, XIL_BYTE,
				 3, num_entries, 0,
				 graydata);

    init_cmap(grayramp, xdisplay, xwindow , 0);

    display = xil_create_from_window(state, xdisplay, xwindow);
}
/***** END OF INIT_VISION FUNCTION ************************************/




/***** SETUP_HWARE FUNCTION *******************************************/
void setup_hware(void)
{
    /***** INTERNALDATA *****/
    XilDevice device;
    int format;
    XilDataType datatype;

    /***** PROCESS *****/
    state = xil_open();
    if (state == NULL) {
	fprintf(stderr, "unable to open xil library\n");
	exit(1);
    }
    
    if (!(device = xil_device_create(state, "SUNWrtvc"))) {
	fprintf(stderr, "Unable to create a device object\n");
	xil_close(state);
	exit(1);
    }
    
    xil_device_set_value(device, "DEVICE_NAME", (void *) devname);
    xil_device_set_value(device, "PORT_V", (void *) port);
    
    if (image_skip){
	xil_device_set_value(device, "IMAGE_SKIP", (void *) image_skip);
    }
    
    if (max_buffers >= 0){
	xil_device_set_value(device, "MAX_BUFFERS", 
			     (void *) max_buffers);
    }
    
    if (!(rtvc_image = xil_create_from_device(state, "SUNWrtvc",
					      device))) {
	fprintf(stderr, "failed to open SUNWrtvc device\n");
	xil_close(state);
	exit(1);
    }
    xil_device_destroy(device);
    
    xil_get_device_attribute(rtvc_image, "FORMAT_V", 
			     (void **) &format);
    if (format == 0) {
	fprintf(stderr, "Unknown video format, exiting.\n");
	xil_close(state);
	exit(1);
    }
    
    xil_get_info(rtvc_image, &width, &height, &nbands, &datatype);
    rtvc_luma = xil_create_child(rtvc_image, 0, 0, width, height, 0, 1);
    
    scale_factor = 1.0 / doscale;
    width = (int) (((float) width * scale_factor) + 0.5);
    height = (int) (((float) height * scale_factor) + 0.5);
    
    single_band = xil_create(state, width, height, 1, XIL_BYTE);

    if(XIL_FAILURE == xil_export(single_band)){
	fprintf(stderr, "xil_export error\n, exiting.\n");
	exit(1);
    }
    
    if(0 == xil_get_exported(single_band) || 
       -1 == xil_get_exported(single_band)){
	fprintf(stderr, "xil_get_export error\n, exiting.\n");
	exit(1);
    }
}
/***** END OF SETUP_HWARE FUNCTION ************************************/


/***** BINARY_PROCESS FUNCTION ****************************************/
void binary(unsigned char *image_data)
{
    /***** INTERNAL DATA *****/
    long   howmuch;
    int    i;

    /***** PROCESS *****/
    for(i=0; i<width*height; i++){
	if(*(image_data+i)<Thres){
	    *(image_data +i) = BlackPixel(xdisplay, 0);
	}
	else{
	    *(image_data +i) = WhitePixel(xdisplay, 0);
	}
    }
}
/***** END OF BINARY_PROCESS FUNCTION *********************************/


/***** NO_IMAGE FUNCTION **********************************************/
void no_image(void)
{
    /***** INTERNALDATA *****/

    /***** PROCESS *****/
    Mode = NO;
    XUnmapWindow(xdisplay, xwindow);
}
/***** END OF NO_IMAGE FUNCTION ***************************************/



/***** VS_MENU FUNCTION ***********************************************/
int vs_menu(void)
{
    /***** INTERNALDATA *****/
    int n,nfds;
    char buf[32];
    fd_set readfds;


    /***** PROCESS *****/
    FD_ZERO(&readfds);
    FD_SET(0,&readfds);

    nfds = select(1,&readfds,NULL,NULL,&tv);
    
    if(nfds == 0){
	return -1;
    }
    else{
        if(FD_ISSET(0,&readfds)){
            n = read(0,buf,sizeof(buf));
            buf[n-1] = NULL;
        }
    }
    
    if(!strcmp(buf, "end")){
	xil_destroy(display);
	XCloseDisplay(xdisplay);
	xil_close(state);
	printf("\nSee You Again !!\n\n");
	close(d_s);
	close(c_s);
	done();
	exit(0);
    }
    
    if(!strcmp(buf, "yes")){
	return Yes;
    }
    if(!strcmp(buf, "no")){
	return No;
    }

    return atoi(buf);
}
/***** END OF VS_MENU FUNCTION ****************************************/


/***** VISION_PROCESS FUNCTION ****************************************/
void vision_process(char *data)   
{
    /***** INTERNALDATA *****/
    int  data_flg = NO;

    /***** PROCESS *****/
    xil_scale(rtvc_luma, single_band, "nearest",
	      scale_factor, scale_factor);
    xil_get_memory_storage(single_band, &storage);
                                    /* Get vision data                */

    switch(Vp){
    case UNIX_LOOK:                    /* UNIX_Look process                 */
	UNIX_Look(storage.byte.data , width, height, socketN);
	break;
    default:
	;
    }
    
/*    if(data_flg == YES){
	if(Level == PARA){
	    if((d_s = socket(AF_INET,SOCK_STREAM,0))<0){
		perror("data: socket");
		return;
	    }
	    if(connect(d_s,&d_sin,sizeof(d_sin)) < 0){
		perror("data: connect");
		return;
	    }
	    write(d_s, data, DATA_SIZE);
	    close(d_s);
	    }
    }
    else{
	strcpy(data, NON_DATA);
    }
*/    
    if(Mode == YES){
	xil_set_memory_storage(single_band, &storage);
	xil_copy(single_band, display);
	/*mizo-spa xil_scale(single_band, display, "nearest",1,1);*/
    }
}
/***** END OF VISION_PROCESS FUNCTION *********************************/


void done()
{
    gettimeofday(&t1, NULL);
    t = (t1.tv_sec - t0.tv_sec) + (t1.tv_usec - t0.tv_usec) * 1e-6;
    printf("%d frames in %g seconds, %g frames/second\n",
           frames - 1, t, (frames - 1) / t);
}

/*
 * Change Point : send_data     function
 *                set_threshold function
 *                change_vp     function
 */


