/**********************************************************************/
/*                                                                    */
/*    PROGRAM OF UNIX_Look.C                                          */
/*                                                                    */
/*      Copyright (c) 1997  Fumio Mizoguchi                           */
/*                                                                    */
/**********************************************************************/
#include <stdio.h> 
#include <stdlib.h>
#include <math.h>
#include <time.h>

#define NUMBER 4
#define PAI 3.141592

/***** FUNCTION PROTOTYPE *****/
void UNIX_Look(unsigned char*, int, int, int);
void putint(char data[],int da); 
void change_image_data(unsigned char r[][], unsigned char*, int, int);
void neo_insight(char data[], int sn);
void setup();

/***** EXTERNALDATA *****/
int add = 0;
char old_insight_data[1024];
char catch_insight_data[1024];


/*****  UNIX_Look FUNCTION ************************************************/
void UNIX_Look(unsigned char *image_data, 
	    int image_width, int image_height, int sn)
{
    /***** INTERNALDATA *****/
    FILE *fp;
    int fd;
    int err;

    unsigned char data[1024],send_data[1024];
    unsigned char rr[image_height][image_width];

    int r[image_height][image_width];

    int q[2][1024];           
    int s[1024];
    int as[100];
    int label = 0;
    int neolabel = 0;
    int i,j,k,l;
    int ki = 130;
    int ni = 200;
    int hyouji = 50;
    int kakusa;
    int sho,swh;
    int start,end;
    typedef long clock_t;

    int xx , hit;
    int tester;

    
    int obj[NUMBER];          /* Object Size  */
    int objn[NUMBER];         /* Object Number  */
    int objl[NUMBER][20];     /* Object Label    */
    int objx[NUMBER][20];     /* Object X */
    int objy[NUMBER][20];     /* Object Y */
    int objk[NUMBER][20];     /* Object Degree */
    int dx[50][2][2];         /* Object domain X */
    int dy[50][2][2];         /* Object domain Y */
    int tanx,tany;
    double objtan;
    double gx,gy;
    int VX, VY;
    double ermin,ermax;
    int sx1,sx2,sx3,sx4;
    
    /***** PROCESS *****/
    VX = image_width;
    VY = image_height;
    
    memcpy(rr, image_data, image_width*image_height);

    /********  set up *********/
    gx =  500.0/(103.0 ) * 300/276;  
    gy =  500.0/(103.0 ) * 300/273;
    
    obj[0] = 3000/4;  /* Size of Box */
    obj[1] = 380/4;  /* Size of Block */
    obj[2] = 270;  /* Size of Block2 */
    obj[3] = 50;  /* Size of Block2 */

    for(i=0; i<NUMBER; i++)
      objn[i] = 0;

    label = 0;
    neolabel = 0;
    
    for(j=0;j<VY;j++){
	for(i=0;i<VX;i++){
	    
	    if(rr[j][i] < ki+1) r[j][i] = 0;
	    else r[j][i] = ni;
	    rr[j][i] = 0;
	}   
    }

    /***** Clear noisu *****/

    /*
    for(j=0;j<VY;j++){
	for(i=0;i<VX;i++){
	    if(r[j][i] == 0){
		if(j>0 && r[j-1][i] > ki) r[j-1][i] = 10;
		if(i>0 && r[j][i-1] > ki) r[j][i-1] = 10;
		if(j<VY-1 && r[j+1][i] > ki) r[j+1][i] = 10;
		if(i<VX-1 && r[j][i+1] > ki) r[j][i+1] = 10;
		if(j>0 && i>0 && r[j-1][i-1] > ki) r[j-1][i-1] = 10;
		if(j>0 && i<VX-1 && r[j-1][i+1] > ki) r[j-1][i+1] = 10;
		if(j<VY-1 && i>0 && r[j+1][i-1] > ki) r[j+1][i-1] = 10;
		if(j<VY-1 && i<VX-1 && r[j+1][i+1] > ki) r[j+1][i+1] = 10;
	    }
	}
    }
    for(j=0;j<VY;j++){
	for(i=0;i<VX;i++){
	    if(r[j][i] == ni){
		if(j>0 && r[j-1][i] < ki+1) r[j-1][i] = ni-1;
		if(i>0 && r[j][i-1] < ki+1) r[j][i-1] = ni-1;
		if(j<VY-1 && r[j+1][i] < ki+1) r[j+1][i] = ni-1;
		if(i<VX-1 && r[j][i+1] < ki+1) r[j][i+1] = ni-1;
		if(j>0 && i>0 && r[j-1][i-1] < ki+1) r[j-1][i-1] = ni-1;
		if(j>0 && i<VX-1 && r[j-1][i+1] < ki+1) r[j-1][i+1] = ni-1;
		if(j<VY-1 && i>0 && r[j+1][i-1] < ki+1) r[j+1][i-1] = ni-1;
		if(j<VY-1 && i<VX-1 && r[j+1][i+1] < ki+1) r[j+1][i+1] = ni-1;
	    }
	}
    }  
    */

    /***** Mark Label *****/

    for(j=0; j<VY; j++){
	for(i=0; i<VX; i++){
	    
	    if (r[j][i] > ki) {
		if((i>0) && (r[j][i-1] > 0)) {
		    r[j][i] = r[j][i-1];
		    s[r[j][i-1]] ++;
		    if((j>0) && (r[j-1][i] > 0) && (r[j-1][i] != r[j][i])){  

			tester = q[0][r[j][i]];
			for (xx=1; xx <= label; xx++) {
			    if(q[0][xx] == tester){
				q[0][xx] = q[0][r[j-1][i]];
			    }
			} 
			if(q[0][r[j][i]] != q[0][r[j-1][i]]){
			    printf("Not enough %d , %d\n",
				  q[0][r[j][i]],q[0][r[j-1][i]] );
			    q[0][r[j][i]] = q[0][r[j-1][i]];    
			}
		    }
		}
		else{
		    if((j>0) && (r[j-1][i] > 0)){
			r[j][i] = r[j-1][i];
		       s[r[j-1][i]] ++;
		    }
		    else{
			if(
			   (
			    (VX-1 > i  && r[j][i+1] > ki) &&
			    (VX-2 > i  && r[j][i+2] > ki) &&
			    (VX-3 > i  && r[j][i+3] > ki) &&
			    (VX-4 > i  && r[j][i+4] > ki) &&
			    (VX-5 > i  && r[j][i+5] > ki) /* &&
			    (VX-6 > i  && r[j][i+6] > ki) &&
			    (VX-7 > i  && r[j][i+7] > ki) &&
			    (VX-8 > i  && r[j][i+8] > ki) */
			    ) ||
			   (
			    (VY-1 > j  && r[j+1][i] > ki) &&
			    (VY-2 > j  && r[j+2][i] > ki) &&
			    (VY-3 > j  && r[j+3][i] > ki) &&
			    (VY-4 > j  && r[j+4][i] > ki) &&
			    (VY-5 > j  && r[j+5][i] > ki) /* &&
			    (VY-6 > j  && r[j+6][i] > ki) &&
			    (VY-7 > j  && r[j+7][i] > ki) &&
			    (VY-8 > j  && r[j+8][i] > ki) */
			    )
			   ) {
			    label ++;
			    r[j][i] = label;
			    q[0][label] = label;
			    s[label] = 1;
			}
			else r[j][i] = 0;
		    }
		}
	    }
	    else r[j][i] = 0;
	}
    }

    
    /***** Check Label *****/
    for(i=1; i<label+1; i++){
	/* printf("q[0][%d] = %d : S = %d\n",i,q[0][i],s[i]);  */
	if(q[0][i] == i){  
	    /* printf(" Get q[0][%d] = %d : S = %d         %d\n",
		   i,q[0][i],s[i],neolabel + 1); */
	    neolabel++;
	    as[neolabel] = s[i];
	    q[1][i] = neolabel;
	}
    }
    for(i=1; i<label+1; i++){
	if(q[0][i] != i){
	    q[1][i] = q[1][q[0][i]];
	    if(q[1][i] > neolabel) 
	       printf("Error !!!  q[0][%d] = %d, q[1][%d] = %d, neolabel = %d\n", i,q[0][i],i, q[1][i], neolabel); 
	    as[q[1][i]] += s[i];
	}
    }

    /*
    for(i = 1; i<neolabel+1; i++) {
	printf("q[1][%d] = %d : S = %d\n",i,q[1][i],as[i]);
    }
    */

    /*
    printf(" Label = %d\n",label);
    printf("Neo Label = %d\n\n",neolabel);
    */

    for(i=1; i<neolabel+1; i++){
	dx[i][0][0] = 9999;
	dx[i][1][0] = 0;
	dy[i][0][1] = 9999;
	dy[i][1][1] = 0;
    }
    for(j=0; j<VY; j++){
	for(i=0; i<VX; i++){
	    if(r[j][i] != 0){
		r[j][i] = q[1][r[j][i]];
		rr[j][i] = q[1][r[j][i]];
		if(dx[r[j][i]][0][0] > i) 
		  dx[r[j][i]][0][0] = i, dx[r[j][i]][0][1] = j;
		if(dx[r[j][i]][1][0] < i) 
		  dx[r[j][i]][1][0] = i, dx[r[j][i]][1][1] = j;
		if(dy[r[j][i]][0][1] > j) 
		  dy[r[j][i]][0][0] = i, dy[r[j][i]][0][1] = j;
		if(dy[r[j][i]][1][1] < j) 
		  dy[r[j][i]][1][0] = i, dy[r[j][i]][1][1] = j;
	    }
	}
    }
    
    /***** SEARCH Box & Block size *****/
    for(i=1; i<neolabel+1; i++){
	if(obj[0]*0.7 < as[i] && as[i] < obj[0]*1.3){
	    objl[0][objn[0]] = i;
	    objn[0] ++;
	    /* printf("size box %d\n",as[i]);   */

	}
	else if(obj[1]*0.6 < as[i] && as[i] < obj[1]*1.7){
	    objl[1][objn[1]] = i;
	    objn[1] ++;
	    
	    /* printf("size block %d, num = %d,  NeoLabel = %d\n",
		   as[i],objl[1][objn[1]-1], neolabel); */
	}
	else if(obj[2]*0.7 < as[i] && as[i] < obj[2]*1.3){
            objl[2][objn[2]] = i;
            objn[2] ++;

	    /* printf("size box2 %d, num = %d\n",as[i],objl[1][objn[1]-1]);*/
        }
        else if(obj[3]*0.8 < as[i] && as[i] < obj[3]*1.3){
            objl[3][objn[3]] = i;
            objn[3] ++;

	    /* printf("size block2 %d, num = %d\n",as[i],objl[1][objn[1]-1]);*/
        }
	else as[i] = 0;
    }
    
    
    for(k=0; k<NUMBER; k++){
	for(l=0; l<objn[k]; l++){
	    sho = (int)(((sqrt((double)(obj[k])))/2.6)*
	      ((sqrt((double)(obj[k])))/2.6));

	    /* printf("sho = %d\n",sho); */

	    
	    if((dx[objl[k][l]][0][0]-dy[objl[k][l]][0][0])*
	       (dx[objl[k][l]][0][0]-dy[objl[k][l]][0][0])+
	       (dx[objl[k][l]][0][1]-dy[objl[k][l]][0][1])*
	       (dx[objl[k][l]][0][1]-dy[objl[k][l]][0][1])<=sho||
	       (dx[objl[k][l]][0][0]-dy[objl[k][l]][1][0])*
	       (dx[objl[k][l]][0][0]-dy[objl[k][l]][1][0])+
	       (dx[objl[k][l]][0][1]-dy[objl[k][l]][1][1])*
	       (dx[objl[k][l]][0][1]-dy[objl[k][l]][1][1])<=sho||
	       (dx[objl[k][l]][1][0]-dy[objl[k][l]][0][0])*
	       (dx[objl[k][l]][1][0]-dy[objl[k][l]][0][0])+
	       (dx[objl[k][l]][1][1]-dy[objl[k][l]][0][1])*
	       (dx[objl[k][l]][1][1]-dy[objl[k][l]][0][1])<=sho||
	       (dx[objl[k][l]][1][0]-dy[objl[k][l]][1][0])*
	       (dx[objl[k][l]][1][0]-dy[objl[k][l]][1][0])+
	       (dx[objl[k][l]][1][1]-dy[objl[k][l]][1][1])*
	       (dx[objl[k][l]][1][1]-dy[objl[k][l]][1][1])<=sho){
		dx[objl[k][l]][0][1]=dy[objl[k][l]][0][1];   
		dx[objl[k][l]][1][1]=dy[objl[k][l]][1][1];
		dy[objl[k][l]][0][0]=dx[objl[k][l]][1][0];
		dy[objl[k][l]][1][0]=dx[objl[k][l]][0][0];
	    }
	    objx[k][l] = (int)((double)(dy[objl[k][l]][0][0]+
					dy[objl[k][l]][1][0])*gx/2.0);
	    objy[k][l] = (int)((double)(dx[objl[k][l]][0][1]+
					dx[objl[k][l]][1][1])*gy/2.0);
	    if((tanx = dx[objl[k][l]][1][0]-dy[objl[k][l]][1][0]) != 0){
		tany =  dy[objl[k][l]][1][1]-dx[objl[k][l]][1][1];  
		objtan = ((double)(tany)*gy)/((double)(tanx)*gx);
		objk[k][l] = (int)((atan(objtan)*180)/PAI);
	    }
	    else objk[k][l] = 0;
	}
    }   
    data[0] = '\0';
    
    for(k=0; k<NUMBER; k++){
	if(k == 1 || k == 3) {
	    ermax = 1.6; ermin = 0.05;
	}
	else {
	    ermax = 1.8; ermin = 0.05;
	}
	for(l=0; l<objn[k]; l++){

	    /*
	    printf("(%d, %d)\n",dx[objl[k][l]][0][0],dx[objl[k][l]][0][1]);
	    printf("(%d, %d)\n",dx[objl[k][l]][1][0],dx[objl[k][l]][1][1]);
	    printf("(%d, %d)\n",dy[objl[k][l]][0][0],dy[objl[k][l]][0][1]);
	    printf("(%d, %d)\n",dy[objl[k][l]][1][0],dy[objl[k][l]][1][1]);
	    */

	    if((dx[objl[k][l]][0][0] == 0) ||
		(dx[objl[k][l]][1][0] == VX-1) ||
		 (dy[objl[k][l]][0][1] == 0) ||
	       (dy[objl[k][l]][1][1] == VY-1)) {
		/* printf("Cut Data \n"); */
		continue;
	    }

	    sx1 = (dx[objl[k][l]][0][0]-dy[objl[k][l]][0][0])*
	      (dx[objl[k][l]][0][0]-dy[objl[k][l]][0][0])+
                (dx[objl[k][l]][0][1]-dy[objl[k][l]][0][1])*
		  (dx[objl[k][l]][0][1]-dy[objl[k][l]][0][1]);

	    /* printf("%d, %d , sx1 = %d,   \n",k,l,sx1); */


	    sx2 = (dx[objl[k][l]][1][0]-dy[objl[k][l]][0][0])*
	      (dx[objl[k][l]][1][0]-dy[objl[k][l]][0][0])+
                (dx[objl[k][l]][1][1]-dy[objl[k][l]][0][1])*
		  (dx[objl[k][l]][1][1]-dy[objl[k][l]][0][1]);

	    /* printf("%d, %d , sx2 = %d,   \n",k,l,sx2); */


	    sx3 = (dx[objl[k][l]][0][0]-dy[objl[k][l]][1][0])*
	      (dx[objl[k][l]][0][0]-dy[objl[k][l]][1][0])+
                (dx[objl[k][l]][0][1]-dy[objl[k][l]][1][1])*
		  (dx[objl[k][l]][0][1]-dy[objl[k][l]][1][1]);

	    /* printf("%d, %d , sx3 = %d,   \n",k,l,sx3); */


	    sx4 = (dx[objl[k][l]][1][0]-dy[objl[k][l]][1][0])*
	      (dx[objl[k][l]][1][0]-dy[objl[k][l]][1][0])+
                (dx[objl[k][l]][1][1]-dy[objl[k][l]][1][1])*
		  (dx[objl[k][l]][1][1]-dy[objl[k][l]][1][1]);

	    /* printf("%d, %d , sx4 = %d,   \n",k,l,sx4); */
 

	    /*if ((dx[objl[k][l]][0][0]-dy[objl[k][l]][0][0])*
		(dx[objl[k][l]][0][0]-dy[objl[k][l]][0][0])+
		(dx[objl[k][l]][0][1]-dy[objl[k][l]][0][1])*
		(dx[objl[k][l]][0][1]-dy[objl[k][l]][0][1]) > obj[k]*ermin &&
		(dx[objl[k][l]][0][0]-dy[objl[k][l]][0][0])*
		(dx[objl[k][l]][0][0]-dy[objl[k][l]][0][0])+
		(dx[objl[k][l]][0][1]-dy[objl[k][l]][0][1])*
		(dx[objl[k][l]][0][1]-dy[objl[k][l]][0][1]) < obj[k]*ermax){*/
	    
	    if(sx1 > obj[k]*ermin && sx2 > obj[k]*ermin &&
	       sx3 > obj[k]*ermin && sx4 > obj[k]*ermin &&
	       sx1 < obj[k]*ermax && sx2 < obj[k]*ermax &&
	       sx3 < obj[k]*ermax && sx4 < obj[k]*ermax){
		putint(data,k);                
		putint(data,objx[k][l]);                
		putint(data,objy[k][l]*-1);                
		putint(data,objk[k][l]);                
		/*
		   printf("b&b=%d,num=%d,x=%d,y=%d,katamuki=%d\n", 
		   k,objl[k][l],objx[k][l],objy[k][l],objk[k][l]);
		   */
	    }
	}
    }
 
    send_data[0] = '\0';
    if(data[0] != '\0'){ 
	strcat(send_data,data);
    
	send_data[strlen(send_data)-1] = ':';
	strcat(send_data,"\n\0");

	/* write(sn,send_data,strlen(send_data)); */
	
	/* printf("Check data :%s\n",send_data);  */
    } 
    else {
	strcat(send_data, ":\n\0");
    }
    neo_insight(send_data, sn);
    
    memcpy(image_data, rr, image_width*image_height);
}
/***** END OF UNIX_Look FUNCTION *****************************************/


/***** NEO_INSIGHT FUNCTION ********************************************/
void neo_insight(char new_insight_data[], int sn)
{
    int old_data[500],new_data[500],catch_data[500];
    int nega;
    char new_catch_data[1024];
    char send_data[1024];
    int changeData = 0;
    
    int i, j, k,l,n,checker, dx, dy;

    if(add == 0) {
	setup();
	add = 1;
    }
    
    if(catch_insight_data[0] == ':') nega = 1;
    else nega = 0;

    atoi_data(0,new_insight_data,new_data);
    atoi_data(0,old_insight_data,old_data);
    atoi_data(0,catch_insight_data,catch_data);

    new_catch_data[0] = '\0';
    for (i = 1 ; i < new_data[0] ; i=i+4){
	for (j = 1; j < old_data[0] ; j=j+4){
                    
	    /* $B@E;_J*BNG'<1(B */ 
	    dx = new_data[i+1]-old_data[j+1];
	    dy = new_data[i+2]-old_data[j+2];
                      
	    if(dx * dx + dy * dy  <  400) {
		checker = 0;
		for(l = 1; l <catch_data[0]; l=l+4){
		    if((new_data[i+1]-catch_data[l+1])*
		       (new_data[i+1]-catch_data[l+1])+
		       (new_data[i+2]-catch_data[l+2])*
		       (new_data[i+2]-catch_data[l+2]) < 400) 
		      checker =1;
		}
		
		if(checker == 0){
		    for (k = i ; k < i + 4 ; k++){
			put_int_data(new_catch_data,new_data[k]);
			changeData ++;
		    }
		}
		
	    }
	}
    }
    catch_insight_data[0] = '\0';
            
    for (i = 1 ; i < catch_data[0] ; i=i+4){
	checker = 0;
	for (j = 1; j < new_data[0] && catch_data[i] <= 3 ; j=j+4){
	    
	    /* $B8=M-J*BNG'<1(B */ 
	    
	    if((catch_data[i+1]-new_data[j+1])*
	       (catch_data[i+1]-new_data[j+1])+
	       (catch_data[i+2]-new_data[j+2])*
	       (catch_data[i+2]-new_data[j+2]) < 400) {
		for (k = i ; k < i + 4 ; k++){
		    put_int_data(catch_insight_data,catch_data[k]);
		    checker = 1;
		}
	    }
	    /* else {
	       put_int_data(catch_insight_data,catch_data[i]+2);
	       for (k = i+1 ; k < i + 4 ; k++){
	       put_int_data(catch_insight_data,catch_data[k]);
	       }
	       } */
	}
	if(checker == 0){
	    changeData ++;
	    printf("change data\n");
	}

    }

    strcat(catch_insight_data,new_catch_data);
    
    if(strlen(catch_insight_data) != 0){
	catch_insight_data[strlen(catch_insight_data)-1] = ':';
	strcat(catch_insight_data,"\0");
    }
    else strcat(catch_insight_data,":\0");

    if(catch_insight_data[0] == ':' && nega == 1) {
	/* printf(" Wait Data "); */
    }
    else if(changeData > 0){
	send_data[0] = '\0';
	strcat(send_data, catch_insight_data);
	strcat(send_data,"\0");
	write(sn, send_data, strlen(send_data));
	printf("Catch Now Data %s \n",send_data);
    }

    copy(old_insight_data, new_insight_data);
}
/***** END OF NEO_INSIGHT FUNCTION *************************************/






/***** PUTINT FUNCTION ************************************************/
void putint(char data[],int da)
{
    char atom[10];
   
    itostr(atom,da);
    strcat(data,atom);
    strcat(data,",");
}
/***** END OF PUTINT FUNCTION *****************************************/


/***** CHANGE_IMAGE_DATA FUNCTION *************************************/
void change_image_data(unsigned char r[][], unsigned char *image_data,
		       int image_width, int image_height)

{
    /***** INTERNALDATA *****/

    /***** PROCESS *****/
    memcpy(r,image_data, image_width*image_height);
}
/***** END OF CHANGE_IMAGE_DATA FUNCTION ******************************/


copy(to, from)
char to[],from[];
{
    int i;
    i = 0;
    while((to[i]=from[i]) !='\0')
      ++i;
}

/*  change integer to atom  */

itoa(n,s)
int n;
char s[];
{
    int i,sign;
    
    
    if ((sign = n) < 0)
      n = -n;
    i=0;
    do{
        s[i++] = n % 10 + '0';
    }while ((n /= 10) > 0);
    if (sign < 0)
      s[i++] = '-';
    s[i] = '\0';
    reverse(s);
}

reverse(s)
char s[];
{
    int c,i,j;
    
    for (i = 0, j= strlen(s)-1; i < j;i++, j--){
        c = s[i];
        s[i] = s[j];
        s[j] = c;
    }
}

atoi_data(n,buf,i_data)
int  n,i_data[];
char buf[];
{
    int c,p,num;
    char atom[20];

    c = 1;
    num = 1;
    p = 0;

    while(c){

        switch(buf[n]){
        case ':':
            if(p != 0){
                atom[p] = '\0';
                i_data[num] = atoi(atom);
                num ++;
            }
            i_data[0] = num - 1;
            c = 0;
            break;
        case ',':
            atom[p] = '\0';
            i_data[num] = atoi(atom);
            num ++;
            n ++;
            p = 0;
            break;
        default:
            atom[p] = buf[n];
            n ++;
            p ++;
            break;
        }
    }
}
put_int_data(atom_data, int_data)
char atom_data[];
int int_data;
{
    char atom[10];

    itoa(int_data, atom);
    strcat(atom_data,atom);
    strcat(atom_data,",");
}


int get_one_data(atom_data, one_data, n)
char atom_data[], one_data[];
int n;
{
    int c,p;

    p = 0;
    c = 1;
    while(c) {
        switch(atom_data[n]){
        case ',':
            one_data[p] = '\0';
            c = 0;
            n ++;
            break;
        case ':':
            one_data[p] = '\0';
            c = 0;
            break;
        default:
            one_data[p] = atom_data[n];
            n ++;
            p ++;
            break;
        }
    }
    return n;
}

void setup(){
    old_insight_data[0] = ':';
    old_insight_data[1] = '\0';
    catch_insight_data[0] = ':';
    catch_insight_data[1] = '\0';
}



