/* Copyright (C) 1998 Kazumasa Yokota */
/*                                    */
package java_qxt;
import java.lang.*;
import java.awt.*;

public class print  {

public static
void print_atom (MQ_Atom atom,TextArea text)
{
 	int quote = 0,n = 0;
	char c[];
  	String name,str;

  	c = new char[1];
  	if ((name = atom.name) != null)
    	{
      		name.getChars(n,n+1,c,0);
		if (Character.isDigit(c[0]) ||
		    Character.isLowerCase(c[0]) ||
		    Character.digit(c[0],0) == 0x80 ||
		    Character.digit(c[0],0) == 0x26)
			while(true)
			{
				n++;
				name.getChars(n,n+1,c,0);
				if(c[0] != 0 &&
				   !(Character.isUpperCase(c[0]) ||
				     Character.isLowerCase(c[0]) ||
				     Character.isDigit(c[0]) ||
				     Character.digit(c[0],0) == 0x5f ||
				     Character.digit(c[0],0) == 0x80))
				{
					quote = 1;
					break;
				}
				else
					break;
			}
		else
			quote = 1;
		if (quote != 0)
			text.appendText( "%" + atom.name + "%" );
		else
			text.appendText( atom.name );
	}
	else
		text.appendText( "&nil\n" );
}


public static 
void print_name_var ( MQ_VTerm name_var,TextArea text )
{
	// $BJQ?t$K3d$jEv$F$i$l$?HV9f$rI=<($9$k$@$1!#(B
	if (name_var.number != 0)
		text.appendText( "_V"+ name_var.number );
	else
		text.appendText( name_var.name );
}


public static
void print_obj (MQ_VTerm obj,TextArea text)
{
	int i;

	print_atom(obj.atom,text);
	if(obj.arity != 0)
	{
		text.appendText( " [ " );
		i = 0;
		while(true)
		{
			print_atom(((MQ_Attr)obj.attr.elementAt(i)).label,text);
			text.appendText( " = " );
			print_vterm (((MQ_Attr)obj.attr.elementAt(i)).vterm.vterm,text);
			if(++i >= obj.arity)
				break;
			text.appendText( " , " );
		}
		text.appendText( " ]\n" );
	}
}


public static
void print_var (MQ_VTerm var,TextArea text)
{
	MQ_VTerm name_var;

	if (var.value !=null)
	{
		print_vterm (var.value.vterm, text);
		return;
	}
	name_var = MQ_VTerm.make_name_var (++var_number, null);
// $B$3$N(Bbind$B$G$OJQ?t$N>WFM$,5/$3$i$J$$$h$&$K!"%F!<%V%k$+2?$+$r;H$C$F4IM}$7$F$$$k$H$3$m$G$"$m$&!#$G$-$l$P!"0JA0$KI=<($7$?JQ?t$HF1$8$b$N$G$"$l$PF1$8HV9f$,$3$3$G$bI=<($5$l$k$h$&$K!"(Bnumber$B$rJQ99$7$?$$$H$3$m!#IU$12C$($k$J$i$PFbItI=8=$5$l$?JQ?t$+$i9=J8LZ$rC5$7$@$7!"$=$3$K3JG<$5$l$F$$$kJQ?tL>$r(BNameVar.string$B$KF~$l$F$d$k$H$H$F$bJ,$+$j$d$9$$$,!"8=:_$N$H$3$m$=$l$OL5M}!#(B
//	bind (var, name_var);
	print_name_var (name_var,text);
}


public static
void print_vterm (MQ_VTerm vterm,TextArea text)
{
	switch (vterm.type)
	{
	case TermType.TT_Obj:
		print_obj (vterm,text);
		break;
	case TermType.TT_Var:
		print_var (vterm,text);
		break;
	case TermType.TT_NameVar:
		print_name_var (vterm,text);
		break;
	default:
		MQ_Error.mq_fatal ("something wrong in print_vterm\n");
		break;
	}
}


//public static
//void bind()


public static
void print_term (MQ_VTerm vterm,TextArea text)
{
	switch (vterm.type)
	{
	case TermType.TT_NameVar:
		print_name_var (vterm,text);
		break;
	case TermType.TT_Obj:
		print_obj (vterm,text);
		break;
	case TermType.TT_Var:
		print_var (vterm,text);
		break;
	case TermType.TT_Dot:
		print_dot (vterm,text);
		break;
	default:
		MQ_Error.mq_fatal ("print_term\n");
		break;
	}
}


public static
void print_dot (MQ_VTerm dot,TextArea text)
{
	print_vterm (dot.vterm.vterm, text);
	text.appendText( "." );
	print_atom (dot.label,text);
}


public static
void print_vterm_list (MQ_VTermList vtl,TextArea text)
{
	if (vtl == null)
		return;
	print_vterm_list (vtl.next,text);
	if (vtl.next!=null)
		text.appendText(", ");
	print_vterm (vtl.vterm.vterm, text);
}


public static
void print_constraint (MQ_Constraint cnstr,TextArea text)
{
	switch (cnstr.rel)
	{
	case Rel.Subsumes:
	case Rel.SubsumesVarVar:
	case Rel.SubsumesVarObj:
	case Rel.SubsumesObjVar:
		print_term (cnstr.term.vterm, text);
		text.appendText(" >= ");
		print_vterm (cnstr.vterm.vterm, text);
		break;

	case Rel.DotCongruent:
	case Rel.DotCongruentVar:
	case Rel.DotCongruentObj:
	case Rel.Congruent:
		print_term (cnstr.term.vterm, text);
		text.appendText(" == ");
		print_vterm (cnstr.vterm.vterm, text);
		break;

	case Rel.ExternalCnstr:
		print_vterm (((MQ_Attr)(cnstr.vterm.vterm).attr.elementAt(0)).vterm.vterm,text);
		text.appendText(" #*# "); //$B$A$g$C$H>J$$$?!#(B+(cnstr.vterm.vterm).atom.name);
		print_vterm (((MQ_Attr)(cnstr.vterm.vterm).attr.elementAt(1)).vterm.vterm,text);
		break;

	case Rel.ExternalExpr:
		print_term (cnstr.term.vterm,text);
		text.appendText(" ## ");
		print_vterm (cnstr.vterm.vterm,text);
		break;

	default:
		MQ_Error.mq_fatal ("print_constraint\n");
		break;
	}
}


public static 
void print_constraints_internal (MQ_Constraints cnstrs,TextArea text)
{
	if (cnstrs == Extern_h.mQ_void_cnstrs)
		return;
	print_constraints_internal (cnstrs.next,text);
	if (cnstrs.next != Extern_h.mQ_void_cnstrs)
		text.appendText("   ,   ");

	print_constraint (cnstrs.cnstr,text);
}


public static
void print_constraints (MQ_Constraints cnstrs,int condition,TextArea text)
{
	String exec_obj;

	if (cnstrs == Extern_h.mQ_void_cnstrs)
		return;

	var_number = 0;
	up_print = Extern_h.up;

	if (condition !=0)
		text.appendText(" if ");
	text.appendText(" { ");
	print_constraints_internal (cnstrs,text);
	text.appendText(" }\n");
//	unwind_variables (up_print);
}


public static
void print_rule (MQ_Rule rule,TextArea text)
{
	MQ_VarList vl;

	for (vl=rule.var_list; vl!=null; vl = vl.next)
		vl.var.vterm_addr_list = null;
	print_vterm (rule.head.vterm,text);
	if (rule.head_cnstrs != Extern_h.mQ_void_cnstrs)
	{
		text.appendText(" | { ");
		print_constraints_internal (rule.head_cnstrs,text);
		text.appendText(" }");
	}

	if (rule.body!=null)
	{
		text.appendText(" <= ");
		print_vterm_list (rule.body,text);

		if (rule.body_cnstrs != Extern_h.mQ_void_cnstrs)
		{
			text.appendText(" || { ");
			print_constraints_internal (rule.body_cnstrs,text);
			text.appendText(" }");
		}
	}

	text.appendText(";;\n");
}


public static
void print_all_subrel_sub (MQ_SubRel sl,TextArea text)
{
	if (sl == null)
		return;
	print_all_subrel_sub (sl.next,text);
	print_atom (sl.a1,text);
	text.appendText(" >= ");
	print_atom (sl.a2,text);
	text.appendText(";;\n");
}


public static
void print_all_subrel (TextArea text)
{
	print_all_subrel_sub (MQ_SubRel.subrel_list,text);
}


public static
void print_all_rules_sub (MQ_RuleList rl,TextArea text)
{
	while (rl!=null)
	{
		print_rule (rl.rule,text);
		rl = rl.next;
	}
}


public static
void print_all_rules (TextArea text)
{

	up_print = Extern_h.up;
	var_number = 0;
	print_all_rules_sub (Extern_h.rule_list,text);
//	unwind_variables (up_print);
}


public static
void print_var_name_list (MQ_VarNameList vnl,TextArea text)
{
	if (vnl == null)
		return;

	print_var_name_list (vnl.next,text);
	if (vnl.next!=null)
		text.appendText(", ");

	print_name_var (vnl.name_var,text);
	text.appendText(" = ");
	switch (vnl.vterm.vterm.type)
	{
		case TermType.TT_Obj:
			print_obj (vnl.vterm.vterm,text);
			break;

		case TermType.TT_NameVar:
			if (vnl.name_var == vnl.vterm.vterm)
				text.appendText("Unbound");
			else
				print_name_var (vnl.vterm.vterm,text);
			break;

		case TermType.TT_Var:
		default:
			MQ_Error.mq_fatal ("something wrong in print_name_var_list\n");
			break;
	}
}


public static
void print_goal (MQ_Goal g,TextArea text)
{
	MQ_Goal sg;

	var_number = 0;
	up_print = Extern_h.up;
	if (g.goal_vterm!=null)
		print_vterm (g.goal_vterm.vterm,text);
	else
		text.appendText("()\n");
	if (g.head_cnstrs != Extern_h.mQ_void_cnstrs)
	{
		text.appendText(" |{");
		print_constraints_internal (g.head_cnstrs,text);
		text.appendText("}");
	}
	sg = g.subgoal;
	if (sg!=null)
	{
		text.appendText(" <= ");
		while (true)
		{
			print_vterm (sg.goal_vterm.vterm,text);
			sg = sg.next;
			if (sg == null)
				break;
			text.appendText(", ");
		}
	}

	if (g.body_cnstrs != Extern_h.mQ_void_cnstrs)
	{
		text.appendText("||{");
		print_constraints_internal (g.body_cnstrs,text);
		text.appendText("}");
	}
	text.appendText(";;\n");
//	unwind_variables (up_print);
}

public static int var_number;
static UnwindProtect up_print;
// $B%/%i%9$N=*$j(B
}
