/* Copyright (C) 1998 Kazumasa Yokota */
/*                                    */
package java_qxt;
/*
_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/ $B%/%i%9(Bemit _/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/
_/                                           ~~~~~~~~~~                                           _/
_/  $B%a%=%C%I$N$&$A!"(Bemit_subrel,check_subrel$B0J30$OCi<B$K0\?"$5$l$F$$$?!#$3$N#2$D$N%a%=%C%I$b(BMQ_   _/
_/  SubRel.java$B$K0\F0$7$?$@$1$G!"L\N)$C$?JQ99$O$J$5$l$F$$$J$$!#(B $B$D$^$j(Bemit.java$B$r8+$?8B$j$G$OFC(B   _/
_/  $B$KLdBj$O$J$$$H$$$($k!#$^$?5$$E$$$?E@$K$D$$$F$O(B ~/Seminar/Quik/note_doc $B$K=q$$$F$"$k$N$G$=$l(B   _/
_/  $B$r;2>H$9$k$3$H!#(B                                                                              _/
_/                                                                                                _/
_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/
*/


public class emit {



//          <<<$B%*%V%8%'%/%H$rFbItI=8=$KJQ$($k!#(B>>>
public static MQ_VTerm emit_obj (MQT_VTerm t_obj)
{     
	MQ_VTerm obj;
	int arity;
	MQT_AttrList t_atl;

	if (t_obj == macro.mqTO_True)
	{
		obj = Extern_h.mqO_True;
		return obj;
	}

	t_atl = t_obj.attr_list;
	// $B$3$3$N(BFor$BJ8$GB0@-$N?t$r?t$($k!#(B
	for (arity = 0; t_atl!=null; t_atl = t_atl.next)
		arity++;
	// $B%*%V%8%'%/%H$N4o(Bobj$B$rMQ0U$7$F(B...($BB0@-$N?t$@$1(BVector$B7?$NG[Ns$rMQ0U$9$k(B)
	obj = MQ_VTerm.make_object(t_obj.atom, arity);
	t_atl = t_obj.attr_list;
	// $B%*%V%8%'%/%H$NB0@-$rFbItI=8=$KJQ99!#(B
	emit_attr_list (t_atl, obj);
	// $BLa$jCM(B
	return obj;
}



//          <<<$BJQ?t$rFbItI=8=$KJQ$($k!#(B>>>
public static
MQ_VTerm emit_var (MQT_VTerm tv,MQ_PP pp_addr)
{
	MQT_Var vpool;
	MQ_VTerm var;
	MQ_VarList new_var_list;
	MQ_VTermAddrList new_addr_list;
        MQ_PP var_pp;

	var = tv.var;
	if(pp_addr == null)
		var_pp = new MQ_PP();
	else
		var_pp = pp_addr;

	for (vpool = MQT_Var.variable_pool; vpool != null; vpool = vpool.next_bucket){
		if (vpool.name.equals(tv.name)){
			if(vpool.var != null){
				var = vpool.var;
//				return var;
			}else{
				var = MQ_VTerm.make_MQ_Var ();
				vpool.var = var;
				MQ_VarList.var_list_p = new MQ_VarList (var, MQ_VarList.var_list_p);
				break;
			}
		}
	}

	// $B<B9TCf$G$"$l$P!"%a%b%j3d$j$D$1$r9T$J$&(B
	if (Extern_h.executing!=0)
	{
           var_pp.vterm = var;
	   var.vterm_addr_list = new MQ_VTermAddrList (var_pp,var.vterm_addr_list);
	}
	// $BLa$jCM(B($B?7$?$K@8@.$7$?JQ?t$N%"%I%l%9$rJV$9(B)
	return var;
}



//          <<<$B%I%C%H9`$rFbItI=8=$KJQ$($k!#(B>>>
public static
MQ_VTerm emit_dot (MQT_VTerm t_dot)
{
	MQ_VTerm dot = MQ_VTerm.make_MQ_Dot(t_dot.label);
	dot.vterm.vterm = emit_vterm (t_dot.vterm,dot.vterm);
	return dot;
}



//          <<<VTERM$B$rFbItI=8=$KJQ$($k!#(B>>>
// $BFC$KLdBj$O$J$7!#$3$3$G$O9=J8LZ(BMQT_VTerm$B$rFbItI=8=$KJQ$($F$$$k!#(BMQT_VTerm$B$O(BC$B$G8@$($P6&MQBN$K$"$?$k(B
//$B$b$N$J$N$G!":#JQ49$7$h$&$H$7$F$$$k(BMQT_VTerm$B$,$I$NB0@-$r;}$C$F$$$k$N$+$r8+$F!"=hM}$r?6$jJ,$1$k!#(B
public static
MQ_VTerm emit_vterm (MQT_VTerm t_vterm,MQ_PP pp_addr)
{
	switch (t_vterm.type)
	{
	case TermType.TT_Var:  // MQT_VTerm$B$,JQ?t$@$C$?$i(B
		MQ_VTerm var;
		var = emit_var (t_vterm,pp_addr);
		return var;
	case TermType.TT_Obj:  // MQT_VTerm$B$,%*%V%8%'%/%H$@$C$?$i(B
		MQ_VTerm obj;
		obj = emit_obj (t_vterm);
		return obj;
	default:  // $B$=$NB>(B
		MQ_Error.mq_fatal ("emit_vterm\n");
		return null;
	}
}



//          <<<TERM$B$rFbItI=8=$KJQ$($k!#(B>>>
// $B$3$l$b(Bemit_vterm$B$HF1$8$/!"JQ49$7$h$&$H$7$F$$$k(BMQT_Term$B$,$I$NB0@-$r;}$C$F$$$k$N$+$r8+$F!"=hM}$r?6(B
//$B$jJ,$1$k!#(B
public static MQ_VTerm emit_term (MQT_VTerm t_term,MQ_PP pp_addr)
{
	switch (t_term.type)
	{
	case TermType.TT_Var:  // MQT_Term$B$,JQ?t$@$C$?$i(B
		MQ_VTerm var;
		var = emit_var (t_term,pp_addr);
		return var;
	case TermType.TT_Obj:  // MQT_Term$B$,%*%V%8%'%/%H$@$C$?$i(B
		MQ_VTerm obj;
		obj = emit_obj (t_term);
		return obj;
	case TermType.TT_Dot:  // MQ_Term$B$,%I%C%H9`$@$C$?$i(B
		MQ_VTerm dot;
		dot = emit_dot (t_term);
		return dot;
	default:  // $B$=$NB>(B
		MQ_Error.mq_fatal ("emit_term\n");
		return null;
	}
}



//          <<<$BB0@-$rFbItI=8=$KJQ$($k!#(B>>>
// $B%*%V%8%'%/%H$K$D$$$F$$$kB0@-$rFbItI=8=$KJQ$($k$H$3$m!#FC$KJQ99E@$O$J$7!#(B
public static
void emit_attr_list (MQT_AttrList atl,MQ_VTerm obj)
{
	int i;

	for (i=0; atl!=null ; atl = atl.next, i++)
	{
		((MQ_Attr)obj.attr.elementAt(i)).label = atl.label;
		((MQ_Attr)obj.attr.elementAt(i)).vterm.vterm = emit_vterm ((MQT_VTerm)atl.vterm,((MQ_Attr)obj.attr.elementAt(i)).vterm);
	}
}



//          <<<$B@)Ls$rFbItI=8=$KJQ$($k!#(B>>>
// $B$3$3$G$$$&@)Ls$H$O!"(Bmicro-Quixote$B$N9=J8$G=q$+$l$F$$$k@)Ls$@$1$G$J$/!"B0@-$J$I$r4^$`$N9-$$0UL#$G$N(B
//$B@)Ls$G$"$k!#(B
public static
MQ_Constraints emit_constraints (MQT_Constraints t_cnstrs)
{
	MQ_Constraints cnstrs = Extern_h.mQ_void_cnstrs;
	MQ_Constraint cnstr;

	if (t_cnstrs == null)
		return Extern_h.mQ_void_cnstrs;

	while (t_cnstrs!=null)
	{
		int rel;
		MQ_VTerm var, var1;
		MQ_VarList new_var_list;

		switch (t_cnstrs.term1.type)
		{
		case TermType.TT_Dot:
			switch (t_cnstrs.term2.type)
			{
			case TermType.TT_Dot:
				rel = t_cnstrs.rel;
				var = MQ_VTerm.make_MQ_Var ();
				var1 = MQ_VTerm.make_MQ_Var ();
				MQ_VarList.var_list_p = new MQ_VarList (var ,MQ_VarList.var_list_p);
				MQ_VarList.var_list_p = new MQ_VarList (var1,MQ_VarList.var_list_p);
				cnstr = MQ_Constraint.make_cnstr (Rel.DotCongruent, null, var);
				cnstrs = MQ_Constraints.make_cnstrs_prev (cnstr, cnstrs);
				cnstr.term.vterm = emit_term (t_cnstrs.term1,cnstr.term);
				cnstr = MQ_Constraint.make_cnstr (Rel.DotCongruent, null, var1);
				cnstrs = MQ_Constraints.make_cnstrs_prev (cnstr, cnstrs);
				cnstr.term.vterm = emit_term (t_cnstrs.term2,cnstr.term);
				switch (rel)
				{
				case Rel.Subsumes:
				case Rel.Congruent:
				case Rel.ExternalExpr:
		  			cnstr = MQ_Constraint.make_cnstr (rel, var, var1);
		  			break;
				case Rel.Supersumes:
					cnstr = MQ_Constraint.make_cnstr (Rel.Subsumes, var1, var);
					break;
				case Rel.ExternalCnstr:
					{
					MQ_VTerm obj;

					obj = MQ_VTerm.make_object (t_cnstrs.op, 2);
					((MQ_Attr)obj.attr.elementAt(0)).label = null;
					((MQ_Attr)obj.attr.elementAt(0)).vterm.vterm = var;
					if (Extern_h.executing!=0)
						var.vterm_addr_list
							= new MQ_VTermAddrList (((MQ_Attr)obj.attr.elementAt(0)).vterm,
								var.vterm_addr_list);
					((MQ_Attr)obj.attr.elementAt(1)).label = null;
					((MQ_Attr)obj.attr.elementAt(1)).vterm.vterm = var1;
					if (Extern_h.executing!=0)
						var1.vterm_addr_list
							= new MQ_VTermAddrList (((MQ_Attr)obj.attr.elementAt(1)).vterm,
								var1.vterm_addr_list);
					cnstr = MQ_Constraint.make_cnstr (Rel.ExternalCnstr, Extern_h.mqO_True,
										obj);
					}
					break;
				default:
					MQ_Error.mq_fatal ("emit_constraints\n");
					break;
				}
				cnstrs = MQ_Constraints.make_cnstrs_prev (cnstr, cnstrs);
				break;

			case TermType.TT_Obj:
			case TermType.TT_Var:
				rel = t_cnstrs.rel;
				switch (rel)
				{
				case Rel.Congruent:
					cnstr = MQ_Constraint.make_cnstr (Rel.DotCongruent, null, null);
					cnstrs = MQ_Constraints.make_cnstrs_prev (cnstr, cnstrs);
					cnstr.term.vterm   = emit_term (t_cnstrs.term1,cnstr.term);
					cnstr.vterm.vterm = emit_vterm ((MQT_VTerm)t_cnstrs.term2,cnstr.vterm);
					break;
				case Rel.ExternalExpr:
				case Rel.Subsumes:
					var = MQ_VTerm.make_MQ_Var ();
					MQ_VarList.var_list_p = new MQ_VarList (var,MQ_VarList.var_list_p);
					cnstr = MQ_Constraint.make_cnstr (Rel.DotCongruent, null, var);
					cnstrs = MQ_Constraints.make_cnstrs_prev (cnstr, cnstrs);
					cnstr.term.vterm = emit_term (t_cnstrs.term1,cnstr.term);
					cnstr = MQ_Constraint.make_cnstr (rel, var, null);
					cnstr.vterm.vterm = emit_vterm ((MQT_VTerm)t_cnstrs.term2,cnstr.vterm);
					cnstrs = MQ_Constraints.make_cnstrs_prev (cnstr, cnstrs);
					break;
				case Rel.Supersumes:
					var = MQ_VTerm.make_MQ_Var ();
					MQ_VarList.var_list_p = new MQ_VarList (var,MQ_VarList.var_list_p);
					cnstr = MQ_Constraint.make_cnstr (Rel.DotCongruent, null, var);
					cnstrs = MQ_Constraints.make_cnstrs_prev (cnstr, cnstrs);
					cnstr.term.vterm = emit_term (t_cnstrs.term1,cnstr.term);
					cnstr = MQ_Constraint.make_cnstr (Rel.Subsumes, null, var);
					cnstr.term.vterm = emit_term (t_cnstrs.term2,cnstr.term);
					cnstrs = MQ_Constraints.make_cnstrs_prev (cnstr, cnstrs);
					break;
				case Rel.ExternalCnstr:
					{
					MQ_VTerm obj;

					var = MQ_VTerm.make_MQ_Var ();
					MQ_VarList.var_list_p = new MQ_VarList (var,MQ_VarList.var_list_p);
					cnstr = MQ_Constraint.make_cnstr (Rel.DotCongruent, null, var);
					cnstrs = MQ_Constraints.make_cnstrs_prev (cnstr, cnstrs);
					cnstr.term.vterm = emit_term (t_cnstrs.term1,cnstr.term);
					obj = MQ_VTerm.make_object (t_cnstrs.op, 2);
					((MQ_Attr)obj.attr.elementAt(0)).label = null;
					((MQ_Attr)obj.attr.elementAt(0)).vterm.vterm = var;
					if (Extern_h.executing!=0)
						var.vterm_addr_list
							= new MQ_VTermAddrList(((MQ_Attr)obj.attr.elementAt(0)).vterm,
								var.vterm_addr_list);
					((MQ_Attr)obj.attr.elementAt(1)).label = null;
					((MQ_Attr)obj.attr.elementAt(1)).vterm.vterm = emit_vterm ((MQT_VTerm)t_cnstrs.term2,((MQ_Attr)obj.attr.elementAt(1)).vterm);
					cnstr = MQ_Constraint.make_cnstr (Rel.ExternalCnstr, Extern_h.mqO_True,
							obj);
					cnstrs = MQ_Constraints.make_cnstrs_prev (cnstr, cnstrs);
					}
					break;
				default:
					MQ_Error.mq_fatal ("emit_constraints");
					break;
				}
				break;

			case TermType.TT_NameVar:
			default:
				MQ_Error.mq_fatal ("emit_constraints");
				break;
			}
			break;

		case TermType.TT_Obj:
		case TermType.TT_Var:
			switch (t_cnstrs.term2.type)
			{
			case TermType.TT_Dot:
				rel = t_cnstrs.rel;
				var = MQ_VTerm.make_MQ_Var ();
				MQ_VarList.var_list_p = new MQ_VarList (var,MQ_VarList.var_list_p);
				cnstr = MQ_Constraint.make_cnstr (Rel.DotCongruent, null, var);
				cnstrs = MQ_Constraints.make_cnstrs_prev (cnstr, cnstrs);
				cnstr.term.vterm = emit_term (t_cnstrs.term2,cnstr.term);
				switch (rel)
				{
				case Rel.Congruent:
				case Rel.Subsumes:
				case Rel.ExternalExpr:
					cnstr = MQ_Constraint.make_cnstr (rel, null, var);
					cnstr.term.vterm = emit_term (t_cnstrs.term1,cnstr.term);
					break;
				case Rel.Supersumes:
					cnstr = MQ_Constraint.make_cnstr (Rel.Subsumes, var, null);
					cnstr.vterm.vterm = emit_vterm ((MQT_VTerm)t_cnstrs.term1,cnstr.vterm);
					break;
				case Rel.ExternalCnstr:
					{
					MQ_VTerm obj;

					obj = MQ_VTerm.make_object (t_cnstrs.op, 2);
					((MQ_Attr)obj.attr.elementAt(0)).label = null;
					((MQ_Attr)obj.attr.elementAt(0)).vterm.vterm = emit_vterm ((MQT_VTerm)t_cnstrs.term1,((MQ_Attr)obj.attr.elementAt(0)).vterm);
					((MQ_Attr)obj.attr.elementAt(1)).label = null;
					((MQ_Attr)obj.attr.elementAt(1)).vterm.vterm = var;
					if (Extern_h.executing!=0)
						var.vterm_addr_list
							= new MQ_VTermAddrList(((MQ_Attr)obj.attr.elementAt(1)).vterm,
								var.vterm_addr_list);
					cnstr = MQ_Constraint.make_cnstr (Rel.ExternalCnstr, Extern_h.mqO_True,
								obj);
					}
					break;
				default:
					MQ_Error.mq_fatal ("emit_constraints\n");
					break;
				}
				cnstrs = MQ_Constraints.make_cnstrs_prev (cnstr, cnstrs);
				break;

			case TermType.TT_Obj:
			case TermType.TT_Var:
				rel = t_cnstrs.rel;
				switch (rel)
				{
				case Rel.Congruent:
				case Rel.Subsumes:
				case Rel.ExternalExpr:
					cnstr = MQ_Constraint.make_cnstr (rel, null, null);
					cnstr.term.vterm   = emit_term (t_cnstrs.term1,cnstr.term);
					cnstr.vterm.vterm = emit_vterm ((MQT_VTerm)t_cnstrs.term2,cnstr.vterm);
					break;
				case Rel.Supersumes:
					cnstr = MQ_Constraint.make_cnstr (Rel.Subsumes, null, null);
					cnstr.term.vterm   = emit_term (t_cnstrs.term2,cnstr.term);
					cnstr.vterm.vterm = emit_vterm ((MQT_VTerm)t_cnstrs.term1,cnstr.vterm);
					break;
				case Rel.ExternalCnstr:
					{
					MQ_VTerm obj;

					obj = MQ_VTerm.make_object (t_cnstrs.op, 2);
					((MQ_Attr)obj.attr.elementAt(0)).label = null;
					((MQ_Attr)obj.attr.elementAt(0)).vterm.vterm = emit_vterm ((MQT_VTerm)t_cnstrs.term1,((MQ_Attr)obj.attr.elementAt(0)).vterm);
					((MQ_Attr)obj.attr.elementAt(1)).label = null;
					((MQ_Attr)obj.attr.elementAt(1)).vterm.vterm = emit_vterm ((MQT_VTerm)t_cnstrs.term2,((MQ_Attr)obj.attr.elementAt(1)).vterm);
					cnstr = MQ_Constraint.make_cnstr (Rel.ExternalCnstr,Extern_h.mqO_True,
							obj);
					}
					break;
				default:
					{
					MQ_Error.mq_fatal ("emit_constraints");
					cnstr = null;  // $B$3$N9T$O(BC$B$K$O$J$+$C$?!#$J$<!)(B
					break;
					}
				}
				cnstrs = MQ_Constraints.make_cnstrs_prev (cnstr, cnstrs);
				break;

			case TermType.TT_NameVar:
			default:
				MQ_Error.mq_fatal ("emit_constraint\n");
				break;
			}
			break;


		case TermType.TT_NameVar:
		default:
			MQ_Error.mq_fatal ("emit_constraint\n");
			break;
		}
		t_cnstrs = t_cnstrs.next;
	}
	if(cnstrs != Extern_h.mQ_void_cnstrs)
		for(;cnstrs.prev != Extern_h.mQ_void_cnstrs;cnstrs = cnstrs.prev);
	return cnstrs;
}


//          <<<VTermList$B$rFbItI=8=$KJQ$($k!#(B>>>
// VTerm$B$OHFMQ$N%/%i%9$G!"JQ?t$K$b$J$j%*%V%8%'%/%H$K$b$J$j%I%C%H9`$K$b$J$k!#(BVTermList$B$O$3$N(BVTerm$B$r%j(B
//$B%9%H>u$K$D$J$0$?$a$N$b$N$G!"$3$l$r$?$I$j$J$,$iFbItI=8=$r@8@.$7$F$f$/$N$G$"$k!#(B
// VTermList$B$O<jF0%3%s%Q%$%k;~$K$O(BBODY$B$G$7$+;H$o$l$F$$$J$+$C$?!#(B
public static
MQ_VTermList emit_vterm_list (MQT_VTermList t_vtl)
{
	MQ_VTermList vtl = null;

	MQ_VTermList.vterm_list_p = null;
	while (t_vtl!=null)
	{
		MQ_VTermList.vterm_list_p = new MQ_VTermList (MQ_VTermList.vterm_list_p);
		MQ_VTermList.vterm_list_p.vterm.vterm = emit_vterm (t_vtl.vterm,MQ_VTermList.vterm_list_p.vterm);
		t_vtl = t_vtl.next;
	}
	return MQ_VTermList.vterm_list_p;
}


//          <<<RULE$B$rFbItI=8=$KJQ$($k!#(B>>>
// $B$3$3$O$b$C$H$bBg@Z$J$H$3$m$N0l$D!#%W%m%0%i%`$NBgItJ,$r@j$a$k%k!<%kIt$rFbItI=8=$KJQ$($F$$$k!#$3$N(B
//$B%/%i%9Cf$N$[$H$s$I$N%a%=%C%I$O$3$3$+$i5/F0$5$l$k!#(B
public static void emit_rule (MQT_VTerm t_head,MQT_Constraints head_t_cnstrs,
		MQT_VTermList t_body,MQT_Constraints body_t_cnstrs)
{
	MQT_Var vp;
	MQ_Rule rule;
	MQ_VTerm obj;
	MQ_RuleList rl, rl1;
	int arity;

	MQ_VarList.var_list_p = null;
	rule = new MQ_Rule ();
	rl = new MQ_RuleList (rule, null, 0);

	Extern_h.rule_list_last.next = rl;
	Extern_h.rule_list_last = rl;

	rule.head.vterm = emit_vterm (t_head,rule.head);
	rule.body = emit_vterm_list (t_body);
	rule.head_cnstrs = emit_constraints (head_t_cnstrs);
	rule.body_cnstrs = emit_constraints (body_t_cnstrs);
	rule.var_list = MQ_VarList.var_list_p;

	if (rule.head.vterm.type != TermType.TT_Obj)
		MQ_Error.mq_fatal ("rule of variable head is not supported yet.\n");
	obj = rule.head.vterm;
	arity = obj.arity;
	rl = obj.atom.rule_list;

	if (rl!=null)
	{
		rl1 = null;
		while (rl != null)
		{
			if (rl.arity > arity)
				break;
			rl1 = rl;
			rl = rl.next;
		}

//		if ((rl!=null) && (rl.arity == arity))
//			rl.last_rule = rl.last_rule.next = rule;
//		else
			if (rl1!=null){
				rule.next = rl1.rule.next;
				rl1.rule.next = rule;
new MQ_RuleList (rule, null, arity);
//  $BJQ99A0(B				rl1.next = new MQ_RuleList (rule, rl1.next, arity);
			}
			else{
				rule.next = rl.rule;
				obj.atom.rule_list = new MQ_RuleList (rule, null, arity);
// $BJQ99A0(B				obj.atom.rule_list = new MQ_RuleList (rule, rl, arity);
			}
	}
	else{
		obj.atom.rule_list = new MQ_RuleList (rule, null, arity);
		rule.next = null;
	}
	rl = obj.atom.rule_list;
	while(rl != null){
//		System.out.println("rl.rule  " + rl.rule);
		rl = rl.next;
	}
	rl = Extern_h.rule_list;
	while(rl != null){
//		System.out.println("rl.rule  " + rl.rule);
		rl = rl.next;
	}
}


//          <<<BODY$B$rFbItI=8=$KJQ$($k!#(B>>>
// BODY$B$rFbItI=8=$KJQ$($k$H$$$C$F$b!"%k!<%k$N$H$3$m$G=P$F$/$k(BBODY$B$rJQ49$9$k$N$G$O$J$/!"Ld$$9g$o$;It(B
//$BJ,$rFbItI=8=$KJQ$($k$3$H$G$"$k!#(B
public static MQ_Query emit_body (MQT_VTermList t_body,MQT_Constraints t_body_cnstrs)
{
	MQT_Var vp;
	MQ_Query query;
	MQ_Goal first_subgoal, subgoal, last_subgoal;
	MQ_VTermList vl;

	MQ_VarList.var_list_p = null;
	if (Extern_h.executing == 0)
		MQ_Error.mq_fatal ("Extern_h.executing == 0 in emit_body");

	query = new MQ_Query ();
	query.goal = new MQ_Goal();
	query.goal.rule = Extern_h.mQ_void_rule;

	query.body = emit_vterm_list (t_body);
	query.goal.body_cnstrs = emit_constraints (t_body_cnstrs);

	query.var_list = MQ_VarList.var_list_p;

	first_subgoal = subgoal = null;
	for (vl = query.body; vl!=null; vl = vl.next)
	{
		last_subgoal = subgoal;
		subgoal = new MQ_Goal();
		subgoal.goal_vterm = vl.vterm;
		if (vl.vterm.vterm.type == TermType.TT_Var)
		{
			vl.vterm.vterm.vterm_addr_list /* Extern_h.executing == 1 here */
				= new MQ_VTermAddrList (subgoal.goal_vterm,
					vl.vterm.vterm.vterm_addr_list);
		}
		if (last_subgoal!=null)
			last_subgoal.next = subgoal;
		else
			first_subgoal = subgoal;
	}
	query.goal.subgoal = first_subgoal;
	query.var_name_list = MQ_VarNameList.get_all_variables ();
	return query;
}

}
