/* Copyright (C) 1998 Kazumasa Yokota */
/*                                    */
package java_qxt;

public class cs {

static int constrain_front (MQ_Goal g)
{
  MQ_CnstrsAsmpts new_obj;
  VariableProtect vp1;

  if (Commands.mq_opt_constrain == 0)
    return macro.SUCCESS;

  vp = null;
  constrain_failed = macro.FALSE;

  /* protect variables against GC */
  mark_variables_in_cnstrs (g.head_cnstrs);
  mark_variables_in_cnstrs (g.body_cnstrs);
  mark_variables_in_cnstrs (Extern_h.cnstrs_asmpts.dot_cnstrs);
  mark_variables_in_cnstrs (Extern_h.cnstrs_asmpts.sub_cnstrs);
  mark_variables_in_cnstrs (Extern_h.cnstrs_asmpts.ext_cnstrs);
  mark_variables_in_cnstrs (Extern_h.cnstrs_asmpts.dot_asmpts);
  mark_variables_in_cnstrs (Extern_h.cnstrs_asmpts.sub_asmpts);
  mark_variables_in_cnstrs (Extern_h.cnstrs_asmpts.ext_asmpts);
  mark_variables_in_cnstrs (Extern_h.cnstrs_asmpts.dot_cnstrs_h);
  mark_variables_in_cnstrs (Extern_h.cnstrs_asmpts.sub_cnstrs_h);
  mark_variables_in_cnstrs (Extern_h.cnstrs_asmpts.ext_cnstrs_h);

  for (vp1=vp; vp1!=null; vp1=vp1.next)
    {
      Unify.unwind_protect_variable_in_cnstrs (vp1.var, vp1.vterm_addr_list);
      vp1.var.value.vterm = null;	/* clear macro.PROTECTED mark */
    }

  mm_current = mm_cnstrs;
  dot_cnstrs = cs_tangle_cnstrs (Extern_h.cnstrs_asmpts.dot_cnstrs);
  sub_cnstrs = cs_tangle_cnstrs (Extern_h.cnstrs_asmpts.sub_cnstrs);
  ext_cnstrs = cs_tangle_cnstrs (Extern_h.cnstrs_asmpts.ext_cnstrs);
  dot_asmpts = cs_tangle_cnstrs (Extern_h.cnstrs_asmpts.dot_asmpts);
  sub_asmpts = cs_tangle_cnstrs (Extern_h.cnstrs_asmpts.sub_asmpts);
  ext_asmpts = cs_tangle_cnstrs (Extern_h.cnstrs_asmpts.ext_asmpts);
  dot_cnstrs_h = cs_tangle_cnstrs (Extern_h.cnstrs_asmpts.dot_cnstrs_h);
  sub_cnstrs_h = cs_tangle_cnstrs (Extern_h.cnstrs_asmpts.sub_cnstrs_h);
  ext_cnstrs_h = cs_tangle_cnstrs (Extern_h.cnstrs_asmpts.ext_cnstrs_h);

  while (true)
    {
      Extern_h.binding_changed = macro.FALSE;
      constraint_solve_cnstrs ();
      if (constrain_failed!=0)
	{	 /* fail: */
	  for (vp1=vp; vp1!=null; vp1=vp1.next)
	    vp1.var.vterm_addr_list = vp1.vterm_addr_list;
    mm_current = mm_exec;
//  obstack_free (mm_cnstrs, cnstrs_first_obj); /* garbage collection */
//  cnstrs_first_obj = (unsigned char *)obstack_alloc (mm_cnstrs, 0);
	  return macro.FAILURE;
	}

      constraint_solve_asmpts ();
      if (constrain_failed!=0)
	{	 /* fail: */
	  for (vp1=vp; vp1!=null; vp1=vp1.next)
	    vp1.var.vterm_addr_list = vp1.vterm_addr_list;
    mm_current = mm_exec;
//  obstack_free (mm_cnstrs, cnstrs_first_obj); /* garbage collection */
//  cnstrs_first_obj = (unsigned char *)obstack_alloc (mm_cnstrs, 0);
	  return macro.FAILURE;
	}

      constraint_solve_cnstrs_h ();
      if (constrain_failed!=0)
	{	 /* fail: */
	  for (vp1=vp; vp1!=null; vp1=vp1.next)
	    vp1.var.vterm_addr_list = vp1.vterm_addr_list;
    mm_current = mm_exec;
//  obstack_free (mm_cnstrs, cnstrs_first_obj); /* garbage collection */
//  cnstrs_first_obj = (unsigned char *)obstack_alloc (mm_cnstrs, 0);
	  return macro.FAILURE;
	}

      if (Extern_h.binding_changed==0)
	break;
    }

  constrain_with_head_and_body_front (g);

  if (constrain_failed!=0)
    {     /* fail: */
      for (vp1=vp; vp1!=null; vp1=vp1.next)
	vp1.var.vterm_addr_list = vp1.vterm_addr_list;
    mm_current = mm_exec;
//  obstack_free (mm_cnstrs, cnstrs_first_obj); /* garbage collection */
//  cnstrs_first_obj = (unsigned char *)obstack_alloc (mm_cnstrs, 0);
      return macro.FAILURE;
    }

  /* macro.SUCCESS */
  for (vp1=vp; vp1!=null; vp1=vp1.next)
    vp1.var.vterm_addr_list = vp1.vterm_addr_list;
  mm_current = mm_exec;
  new_obj = make_cnstrs_asmpts ();
  /* scavenging */
  new_obj.dot_cnstrs = cs_tangle_cnstrs (dot_cnstrs);
  new_obj.sub_cnstrs = cs_tangle_cnstrs (sub_cnstrs);
  new_obj.ext_cnstrs = cs_tangle_cnstrs (ext_cnstrs);
  new_obj.dot_asmpts = cs_tangle_cnstrs (dot_asmpts);
  new_obj.sub_asmpts = cs_tangle_cnstrs (sub_asmpts);
  new_obj.ext_asmpts = cs_tangle_cnstrs (ext_asmpts);
  new_obj.dot_cnstrs_h = cs_tangle_cnstrs (dot_cnstrs_h);
  new_obj.sub_cnstrs_h = cs_tangle_cnstrs (sub_cnstrs_h);
  new_obj.ext_cnstrs_h = cs_tangle_cnstrs (ext_cnstrs_h);
  Extern_h.cnstrs_asmpts = new_obj;
//  obstack_free (mm_cnstrs, cnstrs_first_obj); /* garbage collection */
//  cnstrs_first_obj = (unsigned char *)obstack_alloc (mm_cnstrs, 0);

  return macro.SUCCESS;
}

static void constrain_with_head_and_body_front (MQ_Goal g)
{
  MQ_Constraints cs;

  for (cs = g.body_cnstrs; cs!=Extern_h.mQ_void_cnstrs; cs = cs.next)
    {
      Extern_h.binding_changed = macro.FALSE;

      add_cnstr_to_asmpts (cs.cnstr);
      if (constrain_failed!=0)
	return;
//#if 1
      add_cnstr_to_cnstrs_h (cs.cnstr);
      if (constrain_failed!=0)
	return;
//#endif

      while (true)
	{
	  Extern_h.binding_changed = macro.FALSE;
	  constraint_solve_cnstrs ();
	  if (constrain_failed!=0)
	    return;

	  constraint_solve_asmpts ();
	  if (constrain_failed!=0)
	    return;

	  constraint_solve_cnstrs_h ();
	  if (constrain_failed!=0)
	    return;

	  if (Extern_h.binding_changed==0)
	    break;
	}
    }

  for (cs = g.head_cnstrs; cs!=Extern_h.mQ_void_cnstrs; cs = cs.next)
    {
      Extern_h.binding_changed = macro.FALSE;
      add_cnstr_to_cnstrs_h (cs.cnstr);
      if (constrain_failed!=0)
	return;

      if (Extern_h.binding_changed==0)
	continue;

      while (true)
	{
	  Extern_h.binding_changed = macro.FALSE;
	  constraint_solve_cnstrs ();
	  if (constrain_failed!=0)
	    return;

	  constraint_solve_asmpts ();
	  if (constrain_failed!=0)
	    return;

	  constraint_solve_cnstrs_h ();
	  if (constrain_failed!=0)
	    return;

	  if (Extern_h.binding_changed==0)
	    break;
	}
    }
}

static int constrain_back (MQ_Goal g)
{
  MQ_CnstrsAsmpts new_obj;
  VariableProtect vp1;

  if (Commands.mq_opt_constrain == 0)
    return macro.SUCCESS;

  vp = null;
  constrain_failed = macro.FALSE;

  /* protect variables against GC */
  mark_variables_in_cnstrs (g.head_cnstrs);
  mark_variables_in_cnstrs (g.body_cnstrs);
  mark_variables_in_cnstrs (Extern_h.cnstrs_asmpts.dot_cnstrs);
  mark_variables_in_cnstrs (Extern_h.cnstrs_asmpts.sub_cnstrs);
  mark_variables_in_cnstrs (Extern_h.cnstrs_asmpts.ext_cnstrs);
  mark_variables_in_cnstrs (Extern_h.cnstrs_asmpts.dot_asmpts);
  mark_variables_in_cnstrs (Extern_h.cnstrs_asmpts.sub_asmpts);
  mark_variables_in_cnstrs (Extern_h.cnstrs_asmpts.ext_asmpts);
  mark_variables_in_cnstrs (Extern_h.cnstrs_asmpts.dot_cnstrs_h);
  mark_variables_in_cnstrs (Extern_h.cnstrs_asmpts.sub_cnstrs_h);
  mark_variables_in_cnstrs (Extern_h.cnstrs_asmpts.ext_cnstrs_h);

  for (vp1=vp; vp1!=null; vp1=vp1.next)
    {
      Unify.unwind_protect_variable_in_cnstrs (vp1.var, vp1.vterm_addr_list);
      vp1.var.value.vterm = null;	/* clear macro.PROTECTED mark */
    }

  mm_current = mm_cnstrs;
  dot_cnstrs = cs_tangle_cnstrs (Extern_h.cnstrs_asmpts.dot_cnstrs);
  sub_cnstrs = cs_tangle_cnstrs (Extern_h.cnstrs_asmpts.sub_cnstrs);
  ext_cnstrs = cs_tangle_cnstrs (Extern_h.cnstrs_asmpts.ext_cnstrs);
  dot_asmpts = cs_tangle_cnstrs (Extern_h.cnstrs_asmpts.dot_asmpts);
  sub_asmpts = cs_tangle_cnstrs (Extern_h.cnstrs_asmpts.sub_asmpts);
  ext_asmpts = cs_tangle_cnstrs (Extern_h.cnstrs_asmpts.ext_asmpts);
  dot_cnstrs_h = cs_tangle_cnstrs (Extern_h.cnstrs_asmpts.dot_cnstrs_h);
  sub_cnstrs_h = cs_tangle_cnstrs (Extern_h.cnstrs_asmpts.sub_cnstrs_h);
  ext_cnstrs_h = cs_tangle_cnstrs (Extern_h.cnstrs_asmpts.ext_cnstrs_h);

  while (true)
    {
      Extern_h.binding_changed = macro.FALSE;
      constraint_solve_cnstrs ();
      if (constrain_failed!=0)
	{	/* fail: */
	  for (vp1=vp; vp1!=null; vp1=vp1.next)
	    vp1.var.vterm_addr_list = vp1.vterm_addr_list;
    mm_current = mm_exec;
//  obstack_free (mm_cnstrs, cnstrs_first_obj); /* garbage collection */
//  cnstrs_first_obj = (unsigned char *)obstack_alloc (mm_cnstrs, 0);
	  return macro.FAILURE;
	}

      constraint_solve_asmpts ();
      if (constrain_failed!=0)
	{	/* fail: */
	  for (vp1=vp; vp1!=null; vp1=vp1.next)
	    vp1.var.vterm_addr_list = vp1.vterm_addr_list;
    mm_current = mm_exec;
//  obstack_free (mm_cnstrs, cnstrs_first_obj); /* garbage collection */
//  cnstrs_first_obj = (unsigned char *)obstack_alloc (mm_cnstrs, 0);
	  return macro.FAILURE;
	}

      constraint_solve_cnstrs_h ();
      if (constrain_failed!=0)
	{	/* fail: */
	  for (vp1=vp; vp1!=null; vp1=vp1.next)
	    vp1.var.vterm_addr_list = vp1.vterm_addr_list;
    mm_current = mm_exec;
//  obstack_free (mm_cnstrs, cnstrs_first_obj); /* garbage collection */
//  cnstrs_first_obj = (unsigned char *)obstack_alloc (mm_cnstrs, 0);
	  return macro.FAILURE;
	}

      if (Extern_h.binding_changed==0)
	break;
    }

  constrain_with_head_and_body_back (g);
  if (constrain_failed!=0)
    {    /* fail: */
      for (vp1=vp; vp1!=null; vp1=vp1.next)
	vp1.var.vterm_addr_list = vp1.vterm_addr_list;
    mm_current = mm_exec;
//  obstack_free (mm_cnstrs, cnstrs_first_obj); /* garbage collection */
//  cnstrs_first_obj = (unsigned char *)obstack_alloc (mm_cnstrs, 0);
      return macro.FAILURE;
    }

  /* macro.SUCCESS */
  for (vp1=vp; vp1!=null; vp1=vp1.next)
    vp1.var.vterm_addr_list = vp1.vterm_addr_list;
  mm_current = mm_exec;
  new_obj = make_cnstrs_asmpts ();
  /* scavenging */
  new_obj.dot_cnstrs = cs_tangle_cnstrs (dot_cnstrs);
  new_obj.sub_cnstrs = cs_tangle_cnstrs (sub_cnstrs);
  new_obj.ext_cnstrs = cs_tangle_cnstrs (ext_cnstrs);
  new_obj.dot_asmpts = cs_tangle_cnstrs (dot_asmpts);
  new_obj.sub_asmpts = cs_tangle_cnstrs (sub_asmpts);
  new_obj.ext_asmpts = cs_tangle_cnstrs (ext_asmpts);
  new_obj.dot_cnstrs_h = cs_tangle_cnstrs (dot_cnstrs_h);
  new_obj.sub_cnstrs_h = cs_tangle_cnstrs (sub_cnstrs_h);
  new_obj.ext_cnstrs_h = cs_tangle_cnstrs (ext_cnstrs_h);
  Extern_h.cnstrs_asmpts = new_obj;
//  obstack_free (mm_cnstrs, cnstrs_first_obj); /* garbage collection */
//  cnstrs_first_obj = (unsigned char *)obstack_alloc (mm_cnstrs, 0);

  return macro.SUCCESS;

}

static void constrain_with_head_and_body_back (MQ_Goal g)
{
  MQ_Constraints cs;

  for (cs = g.head_cnstrs; cs!=Extern_h.mQ_void_cnstrs; cs = cs.next)
    {
      Extern_h.binding_changed = macro.FALSE;

      add_cnstr_to_cnstrs (cs.cnstr);
      if (constrain_failed!=0)
	return;

      while (true)
	{
	  Extern_h.binding_changed = macro.FALSE;
	  constraint_solve_cnstrs ();
	  if (constrain_failed!=0)
	    return;

	  constraint_solve_asmpts ();
	  if (constrain_failed!=0)
	    return;

	  constraint_solve_cnstrs_h ();
	  if (constrain_failed!=0)
	    return;

	  if (Extern_h.binding_changed==0)
	    break;
	}
    }
}

static void constraint_solve_cnstrs ()
{
  int binding_changed_saved = Extern_h.binding_changed;
  int binding_changed_1;

  binding_changed_1 = macro.FALSE;
  Extern_h.binding_changed = macro.FALSE;

//  constraint_solve_dot_cnstrs ();
constraint_solve_dot_cnstrs ();  /* 1997/10/31 $B=$@5(B */
  if (constrain_failed!=0)
    return;
  binding_changed_1 |= (Extern_h.binding_changed!=0? 1: 0);

  Extern_h.binding_changed = macro.FALSE;
//  constraint_solve_sub_cnstrs ();
constraint_solve_sub_cnstrs ();  /* 1997/10/31 $B=$@5(B */
  if (constrain_failed!=0)
    return;
  binding_changed_1 |= (Extern_h.binding_changed!=0? 2: 0);

  Extern_h.binding_changed = macro.FALSE;
//  constraint_solve_ext_cnstrs ();
constraint_solve_ext_cnstrs ();  /* 1997/10/31 $B=$@5(B */
  if (constrain_failed!=0)
    return;
  binding_changed_1 |= (Extern_h.binding_changed!=0? 4: 0);

  while (binding_changed_1!=0)
    {
      binding_changed_1 = macro.FALSE;
      binding_changed_saved = macro.TRUE;

      if ((binding_changed_1 & 6)!=0)
	{
	  Extern_h.binding_changed = macro.FALSE;
//	  constraint_solve_dot_cnstrs ();
constraint_solve_dot_cnstrs ();  /* 1997/10/31 $B=$@5(B */
	  if (constrain_failed!=0)
	    return;
	  binding_changed_1 |= (Extern_h.binding_changed!=0? 1: 0);
	}

      if ((binding_changed_1 & 5)!=0)
	{
	  Extern_h.binding_changed = macro.FALSE;
//	  constraint_solve_sub_cnstrs ();
constraint_solve_sub_cnstrs ();  /* 1997/10/31 $B=$@5(B */
	  if (constrain_failed!=0)
	    return;
	  binding_changed_1 |= (Extern_h.binding_changed!=0? 2: 0);
	}

      if ((binding_changed_1 & 3)!=0)
	{
	  Extern_h.binding_changed = macro.FALSE;
//	  constraint_solve_ext_cnstrs ();
constraint_solve_ext_cnstrs ();  /* 1997/10/31 $B=$@5(B */
	  if (constrain_failed!=0)
	    return;
	  binding_changed_1 |= (Extern_h.binding_changed!=0? 4: 0);
	}
    }
  Extern_h.binding_changed = binding_changed_saved;
  return;
}

static void constraint_solve_asmpts ()
{
  int binding_changed_saved = Extern_h.binding_changed;
  int binding_changed_1;

  binding_changed_1 = macro.FALSE;
  Extern_h.binding_changed = macro.FALSE;

//  constraint_solve_dot_asmpts ();
constraint_solve_dot_asmpts ();  /* 1997/10/31 $B=$@5(B */
  if (constrain_failed!=0)
    return;
  binding_changed_1 |= (Extern_h.binding_changed!=0? 1: 0);

  Extern_h.binding_changed = macro.FALSE;
//  constraint_solve_sub_asmpts ();
constraint_solve_sub_asmpts ();  /* 1997/10/31 $B=$@5(B */
  if (constrain_failed!=0)
    return;
  binding_changed_1 |= (Extern_h.binding_changed!=0? 2: 0);

  Extern_h.binding_changed = macro.FALSE;
//  constraint_solve_ext_asmpts ();
constraint_solve_ext_asmpts ();  /* 1997/10/31 $B=$@5(B */
  if (constrain_failed!=0)
    return;
  binding_changed_1 |= (Extern_h.binding_changed!=0? 4: 0);

  while (binding_changed_1!=0)
    {
      binding_changed_1 = macro.FALSE;
      binding_changed_saved = macro.TRUE;

      if ((binding_changed_1 & 6)!=0)
	{
	  Extern_h.binding_changed = macro.FALSE;
//	  constraint_solve_dot_asmpts ();
constraint_solve_dot_asmpts (); /* 1997/10/31 $B=$@5(B */
	  if (constrain_failed!=0)
	    return;
	  binding_changed_1 |= (Extern_h.binding_changed!=0? 1: 0);
	}

      if ((binding_changed_1 & 5)!=0)
	{
	  Extern_h.binding_changed = macro.FALSE;
//	  constraint_solve_sub_asmpts ();
constraint_solve_sub_asmpts (); /* 1997/10/31 $B=$@5(B */
	  if (constrain_failed!=0)
	    return;
	  binding_changed_1 |= (Extern_h.binding_changed!=0? 2: 0);
	}

      if ((binding_changed_1 & 3)!=0)
	{
	  Extern_h.binding_changed = macro.FALSE;
//	  constraint_solve_ext_asmpts ();
constraint_solve_ext_asmpts (); /* 1997/10/31 $B=$@5(B */
	  if (constrain_failed!=0)
	    return;
	  binding_changed_1 |= (Extern_h.binding_changed!=0? 4: 0);
	}
    }
  Extern_h.binding_changed = binding_changed_saved;
  return;
}

static void constraint_solve_cnstrs_h ()
{
  int binding_changed_saved = Extern_h.binding_changed;
  int binding_changed_1;

  binding_changed_1 = macro.FALSE;
  Extern_h.binding_changed = macro.FALSE;

//  constraint_solve_dot_cnstrs_h ();
  constraint_solve_dot_cnstrs_h (); /* 1997/10/31 $B=$@5(B */
  if (constrain_failed!=0)
    return;
  binding_changed_1 |= (Extern_h.binding_changed!=0? 1: 0);

  Extern_h.binding_changed = macro.FALSE;
//  constraint_solve_sub_cnstrs_h ();
  constraint_solve_sub_cnstrs_h (); /* 1997/10/31 $B=$@5(B */
  if (constrain_failed!=0)
    return;
  binding_changed_1 |= (Extern_h.binding_changed!=0? 2: 0);

  Extern_h.binding_changed = macro.FALSE;
//  constraint_solve_ext_cnstrs_h ();
  constraint_solve_ext_cnstrs_h (); /* 1997/10/31 $B=$@5(B */
  if (constrain_failed!=0)
    return;
  binding_changed_1 |= (Extern_h.binding_changed!=0? 4: 0);

  while (binding_changed_1!=0)
    {
      binding_changed_1 = macro.FALSE;
      binding_changed_saved = macro.TRUE;

      if ((binding_changed_1 & 6)!=0)
	{
	  Extern_h.binding_changed = macro.FALSE;
//	  constraint_solve_dot_cnstrs_h ();
          constraint_solve_dot_cnstrs_h (); /* 1997/10/31 $B=$@5(B */
	  if (constrain_failed!=0)
	    return;
	  binding_changed_1 |= (Extern_h.binding_changed!=0? 1: 0);
	}

      if ((binding_changed_1 & 5)!=0)
	{
	  Extern_h.binding_changed = macro.FALSE;
//	  constraint_solve_sub_cnstrs_h ();
          constraint_solve_sub_cnstrs_h (); /* 1997/10/31 $B=$@5(B */
	  if (constrain_failed!=0)
	    return;
	  binding_changed_1 |= (Extern_h.binding_changed!=0? 2: 0);
	}

      if ((binding_changed_1 & 3)!=0)
	{
	  Extern_h.binding_changed = macro.FALSE;
//	  constraint_solve_ext_cnstrs_h ();
constraint_solve_ext_cnstrs_h (); /* 1997/10/31 $B=$@5(B */
	  if (constrain_failed!=0)
	    return;
	  binding_changed_1 |= (Extern_h.binding_changed!=0? 4: 0);
	}
    }
  Extern_h.binding_changed = binding_changed_saved;
  return;
}

static void add_cnstr_to_cnstrs (MQ_Constraint cnstr)
{
  int binding_changed_saved = Extern_h.binding_changed;

  Extern_h.binding_changed = macro.FALSE;
  switch (cnstr.rel)
    {
    case Rel.DotCongruent:
//      add_cnstr_to_dot_cnstrs (cnstr);
        add_cnstr_to_dot_cnstrs (cnstr); /* 1997/10/31 $B=$@5(B */
      break;

    case Rel.Subsumes:
    case Rel.SubsumesVarVar:
    case Rel.SubsumesVarObj:
    case Rel.SubsumesObjVar:
//      add_cnstr_to_sub_cnstrs (cnstr);
add_cnstr_to_sub_cnstrs (cnstr); /* 1997/10/31 $B=$@5(B */
      break;

    case Rel.Congruent:
      if (Unify.unify (cnstr.term, cnstr.vterm) == macro.FAILURE)
	constrain_failed = macro.TRUE;
      break;

    case Rel.ExternalExpr:
    case Rel.ExternalCnstr:
//      add_cnstr_to_ext_cnstrs (cnstr);
add_cnstr_to_ext_cnstrs (cnstr); /* 1997/10/31 $B=$@5(B */
      break;

    default:
      MQ_Error.mq_fatal ("add_cnstr_to_csntrs\n");
      break;
    }
  if ((constrain_failed!=0) || (Extern_h.binding_changed==0))
    {
      Extern_h.binding_changed = binding_changed_saved;
      return;
    }

  constraint_solve_cnstrs ();
  Extern_h.binding_changed = macro.TRUE;
}

static void add_cnstr_to_asmpts (MQ_Constraint cnstr)
{
  int binding_changed_saved = Extern_h.binding_changed;

  Extern_h.binding_changed = macro.FALSE;
  switch (cnstr.rel)
    {
    case Rel.DotCongruent:
//      add_cnstr_to_dot_asmpts (cnstr);  
      add_cnstr_to_dot_asmpts (cnstr); /* 1997/10/31 $B=$@5(B */
      break;

    case Rel.Subsumes:
    case Rel.SubsumesVarVar:
    case Rel.SubsumesVarObj:
    case Rel.SubsumesObjVar:
//      add_cnstr_to_sub_asmpts (cnstr);
      add_cnstr_to_sub_asmpts (cnstr); /* 1997/10/31 $B=$@5(B */
      break;

    case Rel.Congruent:
      if (Unify.unify (cnstr.term, cnstr.vterm) == macro.FAILURE)
	constrain_failed = macro.TRUE;
      break;

    case Rel.ExternalExpr:
    case Rel.ExternalCnstr:
//      add_cnstr_to_ext_asmpts (cnstr);
add_cnstr_to_ext_asmpts (cnstr); /* 1997/10/31 $B=$@5(B */
      break;

    default:
      MQ_Error.mq_fatal ("add_cnstr_to_asmpts\n");
      break;
    }
  if ((constrain_failed!=0) || (Extern_h.binding_changed==0))
    {
      Extern_h.binding_changed = binding_changed_saved;
      return;
    }
  constraint_solve_asmpts ();
  Extern_h.binding_changed = macro.TRUE;
}

static void add_cnstr_to_cnstrs_h (MQ_Constraint cnstr)
{
  int binding_changed_saved = Extern_h.binding_changed;

  Extern_h.binding_changed = macro.FALSE;
  switch (cnstr.rel)
    {
    case Rel.DotCongruent:
//      add_cnstr_to_dot_cnstrs_h (cnstr);
add_cnstr_to_dot_cnstrs_h (cnstr); /* 1997/10/31 $B=$@5(B */
      break;

    case Rel.Subsumes:
    case Rel.SubsumesVarVar:
    case Rel.SubsumesVarObj:
    case Rel.SubsumesObjVar:
//      add_cnstr_to_sub_cnstrs_h(cnstr);
add_cnstr_to_sub_cnstrs_h(cnstr); /* 1997/10/31 $B=$@5(B */
      break;

    case Rel.Congruent:
      if (Unify.unify (cnstr.term, cnstr.vterm) == macro.FAILURE)
	constrain_failed = macro.TRUE;
      break;

    case Rel.ExternalExpr:
    case Rel.ExternalCnstr:
//      add_cnstr_to_ext_cnstrs_h (cnstr);
add_cnstr_to_ext_cnstrs_h (cnstr); /* 1997/10/31 $B=$@5(B */
      break;

    default:
      MQ_Error.mq_fatal ("add_cnstr_to_cnstrs_h");
      break;
    }
  if ((constrain_failed!=0) || (Extern_h.binding_changed==0))
    {
      Extern_h.binding_changed = binding_changed_saved;
      return;
    }
  constraint_solve_cnstrs_h ();
  Extern_h.binding_changed = macro.TRUE;
}

static void delete_nonsence_asmpts ()
{

  MQ_Constraints cs;
//  MQ_Cons_PP cs_p = new MQ_Cons_PP();

  VariableProtect vp1;

  vp = null;
  dot_cnstrs = Extern_h.cnstrs_asmpts.dot_cnstrs;
  sub_cnstrs = Extern_h.cnstrs_asmpts.sub_cnstrs;
  ext_cnstrs = Extern_h.cnstrs_asmpts.ext_cnstrs;
  dot_asmpts = Extern_h.cnstrs_asmpts.dot_asmpts;
  sub_asmpts = Extern_h.cnstrs_asmpts.sub_asmpts;
  ext_asmpts = Extern_h.cnstrs_asmpts.ext_asmpts;
  dot_cnstrs_h = Extern_h.cnstrs_asmpts.dot_cnstrs_h;
  sub_cnstrs_h = Extern_h.cnstrs_asmpts.sub_cnstrs_h;
  ext_cnstrs_h = Extern_h.cnstrs_asmpts.ext_cnstrs_h;

  /* protect variables against GC */
  mark_variables_in_cnstrs (dot_cnstrs);
  mark_variables_in_cnstrs (sub_cnstrs);
  mark_variables_in_cnstrs (ext_cnstrs);
  mark_variables_in_cnstrs (dot_asmpts);
  mark_variables_in_cnstrs (sub_asmpts);
  mark_variables_in_cnstrs (ext_asmpts);
  mark_variables_in_cnstrs (dot_cnstrs_h);
  mark_variables_in_cnstrs (sub_cnstrs_h);
  mark_variables_in_cnstrs (ext_cnstrs_h);
  for (vp1=vp; vp1!=null; vp1=vp1.next)
    {
      Unify.unwind_protect_variable_in_cnstrs (vp1.var, vp1.vterm_addr_list);
      vp1.var.value.vterm = null;	/* clear macro.PROTECTED mark */
    }

  while (true)
    {
      Extern_h.binding_changed = macro.FALSE;
      for (cs=dot_asmpts; cs!=Extern_h.mQ_void_cnstrs; cs=cs.next)
//	if(true) /* 1997/10/31 $B=$@5(B */
//	if (check_cnstr_in_dot_cnstrs (cs.cnstr)) /* NOTE: may bind var */
      if (check_cnstr_in_dot_cnstrs (cs.cnstr)!=0) /* 1997/10/31 $B=$@5(B */
	  {
	    if (constrain_failed!=0)
	      return;

	    /* delete it */
	    if (cs.prev == null) /* that is: cs == dot_asmpts */
	      {
		dot_asmpts = cs.next;
		if (cs.next != Extern_h.mQ_void_cnstrs)
		  cs.next.prev = null;
	      }
	    else
	      {
		cs.prev.next = cs.next;
		if (cs.next != Extern_h.mQ_void_cnstrs)
		  cs.next.prev = cs.prev;
	      }
	  }
      if (Extern_h.binding_changed==0)
	break;
    }
  Extern_h.cnstrs_asmpts.dot_asmpts = dot_asmpts;

  for (cs=sub_asmpts; cs!=Extern_h.mQ_void_cnstrs; cs=cs.next)
//    if (true) /* 1997/10/31 $B=$@5(B */
//    if (check_cnstr_in_sub_cnstrs (cs.cnstr))
    if (check_cnstr_in_sub_cnstrs (cs.cnstr)!=0)/* 1997/10/31 $B=$@5(B */
      {
	if (constrain_failed!=0)
	  return;

	if (cs.prev == null) /* that is: cs == sub_asmpts */
	  {
	    sub_asmpts = cs.next;
	    if (cs.next != Extern_h.mQ_void_cnstrs)
	      cs.next.prev = null;
	  }
	else
	  {
	    cs.prev.next = cs.next;
	    if (cs.next != Extern_h.mQ_void_cnstrs)
	      cs.next.prev = cs.prev;
	  }
      }
  Extern_h.cnstrs_asmpts.sub_asmpts = sub_asmpts;

  for (cs=ext_asmpts; cs!=Extern_h.mQ_void_cnstrs; cs=cs.next)
//    if (true) /* 1997/10/31 $B=$@5(B */
//    if (check_cnstr_in_ext_cnstrs (cs.cnstr))
    if (check_cnstr_in_ext_cnstrs (cs.cnstr)!=0)/* 1997/10/31 $B=$@5(B */
      {
	if (constrain_failed!=0)
	  return;

	if (cs.prev == null) /* that is: cs == ext_asmpts */
	  {
	    ext_asmpts = cs.next;
	    if (cs.next != Extern_h.mQ_void_cnstrs)
	      cs.next.prev = null;
	  }
	else
	  {
	    cs.prev.next = cs.next;
	    if (cs.next != Extern_h.mQ_void_cnstrs)
	      cs.next.prev = cs.prev;
	  }
      }
  Extern_h.cnstrs_asmpts.ext_asmpts = ext_asmpts;

}

static MQ_VarList cs_tangle_var_list (MQ_VarList vl)
{
  MQ_VarList next;

  if (vl == null)
    return null;
  next = cs_tangle_var_list (vl.next);
  return new MQ_VarList (vl.var, next);
}

static MQ_Constraint cs_tangle_cnstr (MQ_Constraint cnstr)
{

  MQ_Constraint new_obj;

  new_obj = MQ_Constraint.make_cnstr (cnstr.rel, cnstr.term.vterm, cnstr.vterm.vterm);

  return new_obj;
}

static MQ_Constraints cs_tangle_cnstrs (MQ_Constraints cnstrs)
{
  MQ_Constraints new_obj, next;
  MQ_Constraint new_cnstr;
  if (cnstrs == Extern_h.mQ_void_cnstrs)
    return Extern_h.mQ_void_cnstrs;

  next = cs_tangle_cnstrs (cnstrs.next);

  if (cnstrs.cnstr.mark!=0)
    new_cnstr = cs_tangle_cnstr (cnstrs.cnstr);
  else
    new_cnstr = cnstrs.cnstr;

  new_obj = MQ_Constraints.make_cnstrs_after (new_cnstr, next);
  new_obj.l_var_list = cs_tangle_var_list(cnstrs.l_var_list);
  new_obj.r_var_list = cs_tangle_var_list (cnstrs.r_var_list);
  return new_obj;
}

static MQ_Constraints copy_cnstrs (MQ_Constraints cnstrs)
{
  MQ_Constraints new_obj, next;

  if (cnstrs == Extern_h.mQ_void_cnstrs)
    return Extern_h.mQ_void_cnstrs;

  next = copy_cnstrs (cnstrs.next);

  new_obj = MQ_Constraints.make_cnstrs_after (cnstrs.cnstr, next);
  new_obj.l_var_list = cs_tangle_var_list (cnstrs.l_var_list);
  new_obj.r_var_list = cs_tangle_var_list (cnstrs.r_var_list);
  return new_obj;
}

static void mark_variable (MQ_VTerm var)
{
  VariableProtect new_obj;

  if (var.value.vterm == macro.PROTECTED)
    return;
  if (var.value.vterm != null)
    MQ_Error.mq_fatal ("variable already has bound in mark_variables.");
  var.value.vterm = macro.PROTECTED;
  new_obj = new VariableProtect();
  new_obj.var = var;
  new_obj.vterm_addr_list = var.vterm_addr_list;
  new_obj.next = vp;
  vp = new_obj;
}

static MQ_VTermList vterm_list_visited;

static void mark_variables_in_vterm (MQ_VTerm vt)
{
  MQ_VTerm o;
  int i;
  MQ_VTermList vl;

  for (vl=vterm_list_visited; vl!=null; vl=vl.next)
    if (vl.vterm.vterm == vt)
      return;
  vterm_list_visited = new MQ_VTermList (vterm_list_visited);
  vterm_list_visited.vterm.vterm = vt;

  switch (vt.type)
    {
    case TermType.TT_Var:
      mark_variable (vt);
      break;
    case TermType.TT_Obj:
      o = vt;
      for (i=0; i< o.arity; i++)
	mark_variables_in_vterm (((MQ_Attr)o.attr.elementAt(i)).vterm.vterm);
      break;
    default:
      MQ_Error.mq_fatal ("mark_variables_in_vterm.");
      break;
    }
}

static void mark_variables_in_cnstrs (MQ_Constraints cnstrs)
{
  MQ_Constraints cs;

  vterm_list_visited = null;
  for (cs=cnstrs; cs != Extern_h.mQ_void_cnstrs; cs= cs.next)
    {
      if (cs.cnstr.term.vterm.type == TermType.TT_Dot)
	;
      else
	mark_variables_in_vterm (cs.cnstr.term.vterm);
      mark_variables_in_vterm (cs.cnstr.vterm.vterm);
    }
}

static MQ_CnstrsAsmpts make_cnstrs_asmpts ()
{
  MQ_CnstrsAsmpts new_obj;

  new_obj = new MQ_CnstrsAsmpts();
  new_obj.dot_cnstrs = new_obj.dot_asmpts = new_obj.dot_cnstrs_h =
    new_obj.sub_cnstrs = new_obj.sub_asmpts = new_obj.sub_cnstrs_h =
      new_obj.ext_cnstrs = new_obj.ext_asmpts = new_obj.ext_cnstrs_h = null;
  return new_obj;
}

static void init_constraints ()
{
//  mm_cnstrs = &cnstrs_obstack;
//  obstack_begin (mm_cnstrs, CONSTRAINTS_SIZE);
//  mm_current = mm_cnstrs;
  Extern_h.mQ_void_cnstr = MQ_Constraint.make_cnstr (Rel.Congruent, null, null);
  Extern_h.mQ_void_cnstrs = MQ_Constraints.make_cnstrs_after (Extern_h.mQ_void_cnstr, null);
  Extern_h.mQ_void_cnstrs_asmpts = make_cnstrs_asmpts ();
  Extern_h.mQ_void_cnstrs_asmpts.dot_cnstrs = Extern_h.mQ_void_cnstrs_asmpts.dot_asmpts
    = Extern_h.mQ_void_cnstrs_asmpts.sub_cnstrs = Extern_h.mQ_void_cnstrs_asmpts.sub_asmpts
      = Extern_h.mQ_void_cnstrs_asmpts.ext_cnstrs = Extern_h.mQ_void_cnstrs_asmpts.ext_asmpts
	= Extern_h.mQ_void_cnstrs_asmpts.dot_cnstrs_h
	  = Extern_h.mQ_void_cnstrs_asmpts.sub_cnstrs_h
	    = Extern_h.mQ_void_cnstrs_asmpts.ext_cnstrs_h
	      = Extern_h.mQ_void_cnstrs;
//  cnstrs_first_obj = (unsigned char *)obstack_alloc (mm_cnstrs, 0);
  Extern_h.cnstrs_asmpts = Extern_h.mQ_void_cnstrs_asmpts;
}













static void constraint_solve_dot_cnstrs ()
{
  dot_cnstrs = constraint_solve_dot (dot_cnstrs);
}

static void constraint_solve_dot_asmpts ()
{
  dot_asmpts = constraint_solve_dot (dot_asmpts);
}

static void constraint_solve_dot_cnstrs_h ()
{
  dot_cnstrs_h = constraint_solve_dot (dot_cnstrs_h);
}

static void add_cnstr_to_dot_cnstrs (MQ_Constraint cnstr)
{
  dot_cnstrs = add_cnstr_to_dot (cnstr, dot_cnstrs);
}

static void add_cnstr_to_dot_asmpts (MQ_Constraint cnstr)
{
  dot_asmpts = add_cnstr_to_dot (cnstr, dot_asmpts);
}

static void add_cnstr_to_dot_cnstrs_h (MQ_Constraint cnstr)
{
  dot_cnstrs_h = add_cnstr_to_dot (cnstr, dot_cnstrs_h);
}

static int check_cnstr_in_dot_cnstrs (MQ_Constraint cnstr)
{
  MQ_Constraints cs;
  MQ_VTerm dot1, dot2;

  for (cs=dot_cnstrs; cs!=Extern_h.mQ_void_cnstrs; cs=cs.next)
    {
      dot1 = cnstr.term.vterm;
      dot2 = cs.cnstr.term.vterm;

      if ((dot1.label == dot2.label) && 
	  (Unify.equal (dot1.vterm.vterm, dot2.vterm.vterm)!=0) )
	{
//#if 0
//	  if (Unify.unify (cnstr.vterm, cs.cnstr.vterm) == macro.FAILURE)
//	    constrain_failed = macro.TRUE;
//	  return macro.TRUE;
//#else
	  if (Unify.equal (cnstr.vterm.vterm, cs.cnstr.vterm.vterm)!=0)
	    {
	      Extern_h.binding_changed = macro.FALSE;
	      return macro.TRUE;
	    }
	  Extern_h.binding_changed = macro.FALSE;
//#endif
	}
      /* equal may bind variables */
      Extern_h.binding_changed = macro.FALSE;
    }
  return macro.FALSE;
}


static MQ_Constraints constraint_solve_dot (MQ_Constraints cs_p)
{
  MQ_Constraints cnstrs_changed, cs;
  MQ_VTerm dot;
  MQ_Constraint cnstr1;
  int binding_changed_saved;
  MQ_PP vt_p;

  binding_changed_saved = Extern_h.binding_changed;
  while (true)
    {
      cnstrs_changed = Extern_h.mQ_void_cnstrs;
      for (cs=cs_p; cs!=Extern_h.mQ_void_cnstrs; cs=cs.next)
	{
	  switch (cs.cnstr.rel)
	    {
	    case Rel.DotCongruentVar:
	      dot = cs.cnstr.term.vterm;
	      if (dot.vterm.vterm.type == TermType.TT_Obj
		  || (dot.vterm.vterm.type == TermType.TT_Var
		      && (dot.vterm.vterm).var_list != cs.l_var_list))
		{ /* instanciated or another binding to variable */
		  if (cs.prev == null) /* cs == *cs_p */
		    {
		      cs_p = cs.next;
		      if (cs.next != Extern_h.mQ_void_cnstrs)
			cs.next.prev = null;
		    }
		  else
		    {
		      cs.prev.next = cs.next;
		      if (cs.next != Extern_h.mQ_void_cnstrs)
			cs.next.prev = cs.prev;
		    }
		  cs.next = cnstrs_changed;
		  cs.prev = null;
		  if (cnstrs_changed != Extern_h.mQ_void_cnstrs)
		    cnstrs_changed.prev = cs;
		  cnstrs_changed = cs;
		}
	      break;
	    case Rel.DotCongruentObj:
	      break;
	    default:
	      MQ_Error.mq_fatal ("constraint_solve_dot.\n");
	      break;
	    }
	}

      Extern_h.binding_changed = macro.FALSE;
      for (cs=cnstrs_changed; cs!=Extern_h.mQ_void_cnstrs; cs=cs.next)
	{
	  dot = cs.cnstr.term.vterm;
	  if ((vt_p = eval_dot (dot)) == null)
	    {
	      cnstr1 = search_dot (dot, cs_p);
	      if (cnstr1 == null)
		{
		  switch (dot.vterm.vterm.type)
		    {
		    case TermType.TT_Var:
		      cnstr1 = MQ_Constraint.make_cnstr (Rel.DotCongruentVar,
					   cs.cnstr.term.vterm, cs.cnstr.vterm.vterm);
		      cs_p = MQ_Constraints.make_cnstrs_after (cnstr1, cs_p);
		      (cs_p).l_var_list = (dot.vterm.vterm).var_list;
		      break;
		    case TermType.TT_Obj:
		      cnstr1 = MQ_Constraint.make_cnstr (Rel.DotCongruentObj,
					   cs.cnstr.term.vterm, cs.cnstr.vterm.vterm);
		      cs_p = MQ_Constraints.make_cnstrs_after (cnstr1, cs_p);
		      (cs_p).l_var_list = cs.l_var_list;
		      break;
		    default:
		      MQ_Error.mq_fatal ("constraint_solve_dot_cnstrs.\n");
		      break;
		    }
		}
	      else{
		if (Unify.unify (cnstr1.vterm, cs.cnstr.vterm) == macro.FAILURE)
		  {
		    constrain_failed = macro.TRUE;
		    return cs_p;
		  }
              }
	  }
	  else /* dot has inherent attribute */{
	    if (Unify.unify (vt_p, cs.cnstr.vterm) == macro.FAILURE)
	      {
		constrain_failed = macro.TRUE;
		return cs_p;
	      }
          }
	}
      if (Extern_h.binding_changed==0)
	break;
      binding_changed_saved = macro.TRUE;
    }
  Extern_h.binding_changed = binding_changed_saved;
  return cs_p;
}

static MQ_Constraints add_cnstr_to_dot (MQ_Constraint cnstr, MQ_Constraints cs_p)
{
  MQ_Constraint cnstr1;
  MQ_VTerm dot;
  MQ_PP vt_p;

  dot = cnstr.term.vterm;
  if ((cnstr1 = search_dot (dot, cs_p)) == null)
    switch (dot.vterm.vterm.type)
      {
      case TermType.TT_Var:
	cnstr1 = MQ_Constraint.make_cnstr (Rel.DotCongruentVar, 
                                           cnstr.term.vterm, cnstr.vterm.vterm);
	cs_p = MQ_Constraints.make_cnstrs_after (cnstr1, cs_p);
	(cs_p).l_var_list = (dot.vterm.vterm).var_list;
	break;
      case TermType.TT_Obj:
	if ((vt_p = eval_dot (dot)) == null)
	  {
	    cnstr1 = MQ_Constraint.make_cnstr (Rel.DotCongruentObj, 
                                               cnstr.term.vterm, cnstr.vterm.vterm); 
      	    cs_p = MQ_Constraints.make_cnstrs_after (cnstr1, cs_p);
	    cs_p.l_var_list = null;
      	  }
	else /* dot has inherent attribute */{
	  if (Unify.unify (vt_p, cnstr.vterm) == macro.FAILURE)
	     constrain_failed = macro.TRUE; 
        }
	break;
      default:
	MQ_Error.mq_fatal ("add_cnstr_to_dot.\n");
	break;
     }
  else{
    if (Unify.unify (cnstr.vterm, cnstr1.vterm) == macro.FAILURE)
      constrain_failed = macro.TRUE;
  }
  return cs_p;
}

static MQ_Constraint search_dot (MQ_VTerm dot,MQ_Constraints  cnstrs)
{
  MQ_Constraints cs;
  MQ_VTerm dot1;

  for (cs=cnstrs; cs!=Extern_h.mQ_void_cnstrs; cs=cs.next)
    {
      dot1 = cs.cnstr.term.vterm;

      if ((dot.label == dot1.label) && 
	  (Unify.equal (dot.vterm.vterm, dot1.vterm.vterm)!=0) )
 	return cs.cnstr;
    }
  return null;
}

static void constraint_solve_ext_cnstrs ()
{
  ext_cnstrs = constraint_solve_ext (ext_cnstrs);
}

static void add_cnstr_to_ext_cnstrs (MQ_Constraint cnstr)
{
  ext_cnstrs = add_cnstr_to_ext (cnstr, ext_cnstrs);
}

static int check_cnstr_in_ext_cnstrs (MQ_Constraint cnstr)
{
  return search_ext (cnstr, ext_cnstrs);
}

static void constraint_solve_ext_asmpts ()
{
  ext_asmpts = constraint_solve_ext (ext_asmpts);
}

static void add_cnstr_to_ext_asmpts (MQ_Constraint cnstr)
{
  ext_asmpts = add_cnstr_to_ext (cnstr, ext_asmpts);
}

static void constraint_solve_ext_cnstrs_h ()
{
  ext_cnstrs_h = constraint_solve_ext (ext_cnstrs_h);
}

static void add_cnstr_to_ext_cnstrs_h (MQ_Constraint cnstr)
{
  ext_cnstrs_h = add_cnstr_to_ext (cnstr, ext_cnstrs_h);
}

static MQ_Constraints constraint_solve_ext (MQ_Constraints cs_p)
{
  MQ_Constraints cnstrs_changed, cs;
  int binding_changed_saved;
  MQ_VTerm result;
  MQ_PP  input = new MQ_PP();

  binding_changed_saved = Extern_h.binding_changed;
  while (true)
    {
      cnstrs_changed = Extern_h.mQ_void_cnstrs;
      for (cs=cs_p; cs!=Extern_h.mQ_void_cnstrs; cs=cs.next)
	{
	  cs.r_var_list = delete_bound_var_in_var_list (cs.r_var_list);
	  if (cs.r_var_list == null)
	    {
	      if (cs.prev == null) /* cs == *cs_p */
		{
		  cs_p = cs.next;
		  if (cs.next != Extern_h.mQ_void_cnstrs)
		    cs.next.prev = null;
		}
	      else
		{
		  cs.prev.next = cs.next;
		  if (cs.next != Extern_h.mQ_void_cnstrs)
		    cs.next.prev = cs.prev;
		}
	      cs.next = cnstrs_changed;
	      cs.prev = null;
	      if (cnstrs_changed != Extern_h.mQ_void_cnstrs)
		cnstrs_changed.prev = cs;
	      cnstrs_changed = cs;
	    }
	}

      Extern_h.binding_changed = macro.FALSE;
      for (cs=cnstrs_changed; cs!=Extern_h.mQ_void_cnstrs; cs=cs.next)
	{
	  switch (cs.cnstr.rel)
	    {
	    case Rel.ExternalExpr:
	      result = null;
//	      result = eval_ext_expr (cs.cnstr.vterm.vterm);
              input.vterm = result;
	      if (result == null)
		{ /* remain there */
		  cs_p = MQ_Constraints.make_cnstrs_after (cs.cnstr, cs_p);
		  (cs_p).r_var_list = null;
		}
	      else
		if (Unify.unify (cs.cnstr.term, input)
		    == macro.FAILURE)
		  {
		    constrain_failed = macro.TRUE;
		    return cs_p;
		  }
	      break;
	    case Rel.ExternalCnstr:

	      if (true)
//	      if (!eval_ext_cnstr (cs.cnstr.vterm.vterm))
		{
		  constrain_failed = macro.TRUE;
		  return cs_p;
		}
	      break;

	    default:
	      MQ_Error.mq_fatal ("constraint_solve_ext.\n");
	      break;
	    }
	}
      if (Extern_h.binding_changed==0)
	break;
      binding_changed_saved = macro.TRUE;
    }
  Extern_h.binding_changed = binding_changed_saved;
  return cs_p;
}

static MQ_Constraints add_cnstr_to_ext (MQ_Constraint cnstr,MQ_Constraints cs_p)
{
  MQ_VarList vl;
  MQ_VTerm result;
  MQ_PP input = new MQ_PP();

  if (search_ext (cnstr, cs_p)!=0)
    /* already there */
    return cs_p;

  if (cnstr.vterm.vterm.type == TermType.TT_Var)
    vl = new MQ_VarList (cnstr.vterm.vterm, null);
  else
    vl = Subsump.variables_in_obj (cnstr.vterm.vterm);

  if (vl == null)
    switch (cnstr.rel)
      {
      case Rel.ExternalExpr:
	result = null;
//	result = eval_ext_expr (cnstr.vterm.vterm);
        input.vterm = result;
	if (result == null)
	  { /* remain there */
	    cs_p = MQ_Constraints.make_cnstrs_after (cnstr, cs_p);
	    (cs_p).r_var_list = null;
	  }
	else
	  if (Unify.unify (cnstr.term, input) == macro.FAILURE)
	    constrain_failed = macro.TRUE;
	break;
      case Rel.ExternalCnstr:

	if (true)
//	if (!eval_ext_cnstr (cnstr.vterm.vterm))
	  constrain_failed = macro.TRUE;
	break;

      default:
	MQ_Error.mq_fatal ("add_cnstr_to_ext.\n");
	break;
      }
  else
    switch (cnstr.rel)
      {
      case Rel.ExternalExpr:
      case Rel.ExternalCnstr:
	cs_p = MQ_Constraints.make_cnstrs_after (cnstr, cs_p);
	(cs_p).r_var_list = vl;
	break;

      default:
	MQ_Error.mq_fatal ("add_cnstr_to_ext.\n");
	break;
      }

  return cs_p;
}

static int search_ext (MQ_Constraint cnstr, MQ_Constraints cnstrs)
{
  MQ_Constraints cs;

  for (cs=cnstrs; cs!=Extern_h.mQ_void_cnstrs; cs=cs.next)
    {
      if (cnstr.rel != cs.cnstr.rel)
	continue;
      if (cnstr.rel == Rel.ExternalExpr)
	{
         if ((Unify.equal(cnstr.term.vterm, cs.cnstr.term.vterm)!=0)
	      && (Unify.equal (cnstr.vterm.vterm, cs.cnstr.vterm.vterm)!=0))
	    return macro.TRUE;
	}
      else if (cnstr.rel == Rel.ExternalCnstr)
	{
	  if (Unify.equal (cnstr.vterm.vterm, cs.cnstr.vterm.vterm)!=0)
	    return macro.TRUE;
	}
      else
	MQ_Error.mq_fatal ("search_ext\n");
    }
  return macro.FALSE;
}

static void constraint_solve_sub_cnstrs ()
{
  MQ_Constraints cs_saved;  

//  sub_cnstrs = constraint_solve_sub (sub_cnstrs);
  cs_saved = constraint_solve_sub (sub_cnstrs);
  if(cs_saved!=null);
    sub_cnstrs = cs_saved;
}

static void constraint_solve_sub_asmpts ()
{
  sub_asmpts = constraint_solve_sub (sub_asmpts);
}

static void constraint_solve_sub_cnstrs_h ()
{
  sub_cnstrs_h = constraint_solve_sub (sub_cnstrs_h);
}

static void add_cnstr_to_sub_cnstrs (MQ_Constraint cnstr)
{
  MQ_Constraints cs_saved,cs_save;

  cnstrs_changed = Extern_h.mQ_void_cnstrs;
//  if ((Subsump.eval_subsumption (cnstr.term, cnstr.vterm, cnstrs_changed) !=0)
  if ((cs_saved=Subsump.eval_subsumption (cnstr.term.vterm, 
                                     cnstr.vterm.vterm, cnstrs_changed)) !=null){
    cnstrs_changed = cs_saved;
    
    cs_save = constraint_solve_subsumption (sub_cnstrs);
    if(cs_save!=null)
//    sub_cnstrs = constraint_solve_subsumption (sub_cnstrs);
      sub_cnstrs = cs_save;
  }
  else
    constrain_failed = macro.TRUE;
}

static void add_cnstr_to_sub_asmpts (MQ_Constraint cnstr)
{
  MQ_Constraints cs_saved,cs_save;

  cnstrs_changed = Extern_h.mQ_void_cnstrs;
//  if (Subsump.eval_subsumption (cnstr.term, cnstr.vterm, cnstrs_changed) !=0)
  if ((cs_saved=Subsump.eval_subsumption (cnstr.term.vterm, 
                                     cnstr.vterm.vterm, cnstrs_changed)) !=null){
    cnstrs_changed = cs_saved;

    cs_save = constraint_solve_subsumption (sub_asmpts);
//    sub_asmpts = constraint_solve_subsumption (sub_asmpts);
    if(cs_save!=null)    
    sub_asmpts = cs_save;
  }
  else
    constrain_failed = macro.TRUE;
}

static void add_cnstr_to_sub_cnstrs_h (MQ_Constraint cnstr)
{
  MQ_Constraints cs_saved,cs_save;

  cnstrs_changed = Extern_h.mQ_void_cnstrs;
//  if (Subsump.eval_subsumption (cnstr.term, cnstr.vterm, cnstrs_changed) !=0){
  if ((cs_saved=Subsump.eval_subsumption (cnstr.term.vterm, 
                                    cnstr.vterm.vterm, cnstrs_changed)) !=null){
    cnstrs_changed = cs_saved;

    cs_save = constraint_solve_subsumption (sub_cnstrs_h);
//    sub_cnstrs_h = constraint_solve_subsumption (sub_cnstrs_h);
    if(cs_save!=null)    
    sub_cnstrs_h = cs_save;
  }
  else{
    constrain_failed = macro.TRUE;
   }
}

static int check_cnstr_in_sub_cnstrs (MQ_Constraint cnstr)
{
  MQ_Constraints cs;

  cs = Extern_h.mQ_void_cnstrs;
//  if (Subsump.eval_subsumption (cnstr.term, cnstr.vterm, cs)==macro.FALSE)
  if ((cs=Subsump.eval_subsumption (cnstr.term.vterm, cnstr.vterm.vterm, cs))==null)
    return macro.FALSE;

  for (; cs!=Extern_h.mQ_void_cnstrs; cs=cs.next){
    if (check_cnstr_in_sub_cnstrs_1 (cs.cnstr)!=0)
      return macro.TRUE;
}
  return macro.FALSE;
}

static int check_cnstr_in_sub_cnstrs_1 (MQ_Constraint cnstr)
{
  MQ_Constraints cs, cs1;
  MQ_VTerm vt11, vt12;
  MQ_VTerm vt21, vt22;

  vt11 = cnstr.term.vterm;
  vt12 = cnstr.vterm.vterm;

  switch (cnstr.rel)
    {
    case Rel.SubsumesVarVar:
      for (cs=sub_cnstrs; cs!=Extern_h.mQ_void_cnstrs; cs=cs.next)
	{
	  vt21 = cs.cnstr.term.vterm;
	  vt22 = cs.cnstr.vterm.vterm;
	  if ((Unify.equal (vt11, vt21)!=0)
	      && (Unify.equal (vt12, vt22)!=0))
	    return macro.TRUE;
	}
      return macro.FALSE;
//      break;

    case Rel.SubsumesVarObj: /* X >= O <=  X >= P, P >= O */
      for (cs=sub_cnstrs; cs!=Extern_h.mQ_void_cnstrs; cs=cs.next)
	{
	  vt21 = cs.cnstr.term.vterm;
	  vt22 = cs.cnstr.vterm.vterm;
	  if (Unify.equal (vt11, vt21)!=0)
	    if (Unify.equal (vt12, vt22)!=0)
	      return macro.TRUE;
	    else
	      if (vt22.type == TermType.TT_Obj)
		{
		  cs1 = Extern_h.mQ_void_cnstrs;
//		  if (Subsump.eval_subsumption (vt12, vt22, cs1) 
//		      == macro.FALSE)
		  if ((cs1=Subsump.eval_subsumption (vt12, vt22, cs1)) 
		      == null)
		    continue;
		  for (; cs1!=Extern_h.mQ_void_cnstrs; cs1=cs1.next)
		    if (check_cnstr_in_sub_cnstrs_1 (cs1.cnstr) == macro.FALSE)
		      continue;
		  return macro.TRUE;
		}
	}
      return macro.FALSE;
//      break;

    case Rel.SubsumesObjVar: /* O >= X <=  P >= X, O >= P */
      for (cs=sub_cnstrs; cs!=Extern_h.mQ_void_cnstrs; cs=cs.next)
	{
	  vt21 = cs.cnstr.term.vterm;
	  vt22 = cs.cnstr.vterm.vterm;
	  if (Unify.equal (vt11, vt21)!=0)
	    {
	      if (Unify.equal (vt12, vt22)!=0)
		return macro.TRUE;
	    }
	  else if (Unify.equal (vt12, vt22)!=0)
	    if (vt21.type == TermType.TT_Obj)
	      {
		cs1 = Extern_h.mQ_void_cnstrs;
//		if (Subsump.eval_subsumption (vt11, vt21, cs1) == macro.FALSE)
		if ((cs1=Subsump.eval_subsumption (vt11, vt21, cs1)) ==null){
		  continue;
}
		for (; cs1!=Extern_h.mQ_void_cnstrs; cs1=cs1.next)
		  if (check_cnstr_in_sub_cnstrs_1 (cs1.cnstr) == macro.FALSE)
		    continue;
		return macro.TRUE;
	      }
	}
      return macro.FALSE;
//      break;

    default:
      MQ_Error.mq_fatal ("check_cnstr_in_sub_cnstrs.\n");
      return 0;//dummy
//      break;
    }
}

static MQ_Constraints constraint_solve_sub (MQ_Constraints cs_p)
{
  MQ_Constraints cs,cs_p2;

  cnstrs_changed = Extern_h.mQ_void_cnstrs;
  for (cs=cs_p; cs!=Extern_h.mQ_void_cnstrs; cs=cs.next)
    { 
      switch (cs.cnstr.rel)
	{
	case Rel.SubsumesVarVar:
	  if (cs.cnstr.term.vterm.type == TermType.TT_Obj
	      || cs.cnstr.vterm.vterm.type == TermType.TT_Obj
	      || (cs.cnstr.term.vterm.type == TermType.TT_Var
		  && cs.l_var_list != (cs.cnstr.term.vterm).var_list)
	      || (cs.cnstr.vterm.vterm.type == TermType.TT_Var
		  && cs.r_var_list != (cs.cnstr.vterm.vterm).var_list))
	    {
//	      if (Subsump.eval_subsumption (cs.cnstr.term,
//				    cs.cnstr.vterm,
//				    cnstrs_changed) == macro.FALSE)
	      if ((cnstrs_changed=Subsump.eval_subsumption 
                               (cs.cnstr.term.vterm,cs.cnstr.vterm.vterm,
				    cnstrs_changed)) == null)
		{
		  constrain_failed = macro.TRUE;
		  return cs_p;
		}

	      /* delete cs */
	      if (cs.prev == null) /* cs == *cs_p */
		{
		  cs_p = cs.next;
		  if (cs.next != Extern_h.mQ_void_cnstrs)
		    cs.next.prev = null;
		}
	      else
		{
		  cs.prev.next = cs.next;
		  if (cs.next != Extern_h.mQ_void_cnstrs)
		    cs.next.prev = cs.prev;
		}

	    }
	  break;

	case Rel.SubsumesVarObj:
	  if (cs.cnstr.term.vterm.type == TermType.TT_Obj
	      || (cs.cnstr.term.vterm.type == TermType.TT_Var
		  && cs.l_var_list != (cs.cnstr.term.vterm).var_list))
	    {
//	      if (Subsump.eval_subsumption (cs.cnstr.term,
//				    cs.cnstr.vterm,
//				    cnstrs_changed) == macro.FALSE)
	      if ((cnstrs_changed=Subsump.eval_subsumption 
                      (cs.cnstr.term.vterm,cs.cnstr.vterm.vterm,
				    cnstrs_changed)) == null)
		{
		  constrain_failed = macro.TRUE;
		  return cs_p;
		}

	      /* delete cs */
	      if (cs.prev == null) /* cs == *cs_p */
		{
		  cs_p = cs.next;
		  if (cs.next != Extern_h.mQ_void_cnstrs)
		    cs.next.prev = null;
		}
	      else
		{
		  cs.prev.next = cs.next;
		  if (cs.next != Extern_h.mQ_void_cnstrs)
		    cs.next.prev = cs.prev;
		}
	    }
	  else if (cs.r_var_list!=null)
	    {
	      cs.r_var_list = delete_bound_var_in_var_list (cs.r_var_list);
	      if (cs.r_var_list == null)
		{
		  /* delete cs */
		  if (cs.prev == null) /* cs == *cs_p */
		    {
		      cs_p = cs.next;
		      if (cs.next != Extern_h.mQ_void_cnstrs)
			cs.next.prev = null;
		    }
		  else
		    {
		      cs.prev.next = cs.next;
		      if (cs.next != Extern_h.mQ_void_cnstrs)
			cs.next.prev = cs.prev;
		    }
		  cs.next = cnstrs_changed;
		  cs.prev = null;
		  if (cnstrs_changed != Extern_h.mQ_void_cnstrs)
		    cnstrs_changed.prev = cs;
		  cnstrs_changed = cs;
		}
	    }
	  break;

	case Rel.SubsumesObjVar:
	  if (cs.cnstr.vterm.vterm.type == TermType.TT_Obj
	      || (cs.cnstr.vterm.vterm.type == TermType.TT_Var
		  && cs.r_var_list != (cs.cnstr.vterm.vterm).var_list))
	    {
//	      if (Subsump.eval_subsumption (cs.cnstr.term,
//				    cs.cnstr.vterm,
//				    cnstrs_changed) == macro.FALSE)
	      if ((cnstrs_changed=Subsump.eval_subsumption 
                     (cs.cnstr.term.vterm,cs.cnstr.vterm.vterm,
				    cnstrs_changed)) == null)
		{
		  constrain_failed = macro.TRUE;
		  return cs_p;
		}

	      /* delete cs */
	      if (cs.prev == null) /* cs == *cs_p */
		{
		  cs_p = cs.next;
		  if (cs.next != Extern_h.mQ_void_cnstrs)
		    cs.next.prev = null;
		}
	      else
		{
		  cs.prev.next = cs.next;
		  if (cs.next != Extern_h.mQ_void_cnstrs)
		    cs.next.prev = cs.prev;
		}
	    }
	  else if (cs.l_var_list!=null)
	    {
	      cs.l_var_list = delete_bound_var_in_var_list (cs.l_var_list);
	      if (cs.l_var_list == null)
		{
		  /* delete cs */
		  if (cs.prev == null) /* cs == *cs_p */
		    {
		      cs_p = cs.next;
		      if (cs.next != Extern_h.mQ_void_cnstrs)
			cs.next.prev = null;
		    }
		  else
		    {
		      cs.prev.next = cs.next;
		      if (cs.next != Extern_h.mQ_void_cnstrs)
			cs.next.prev = cs.prev;
		    }
		  cs.next = cnstrs_changed;
		  cs.prev = null;
		  if (cnstrs_changed != Extern_h.mQ_void_cnstrs)
		    cnstrs_changed.prev = cs;
		  cnstrs_changed = cs;
		}
	    }
	  break;

	default:
	  MQ_Error.mq_fatal ("constraint_solve_sub.\n");
	  break;
	}
    }

  cs_p2 = constraint_solve_subsumption (cs_p);
  if(cs_p2==null)
    return null;

    return cs_p2;
}

static MQ_Constraints constraint_solve_subsumption (MQ_Constraints cnstrs_p)
{
  MQ_Constraints new_cnstrs, cs, c_cs; 
  MQ_Constraints cs_save;
  MQ_Cons_PP new_cnstrs_p;
  MQ_Cons_PP c_cs_pp = new MQ_Cons_PP();

  new_cnstrs = cnstrs_p;
  while (true)
    {
      c_cs = Extern_h.mQ_void_cnstrs;
      c_cs_pp.cs=c_cs;
      for (cs=cnstrs_changed; cs!=Extern_h.mQ_void_cnstrs; cs=cs.next)
	{
//	  new_cnstrs = constraint_solve_subsumption_1 (cs, new_cnstrs, c_cs);
	  new_cnstrs = constraint_solve_subsumption_1 (cs, new_cnstrs, c_cs_pp);
          c_cs = c_cs_pp.cs;
	  if (new_cnstrs == null)
	    {
	      constrain_failed = macro.TRUE;
	      return null;
	    }
	}
      cnstrs_changed = c_cs;
      if (cnstrs_changed==Extern_h.mQ_void_cnstrs)
	break;
    }

  cnstrs_p = new_cnstrs;
  return cnstrs_p;
}

//static MQ_Constraints constraint_solve_subsumption_1 (MQ_Constraints a_cs,
//						      MQ_Constraints cnstrs,
//						      MQ_Constraints cs_p)
static MQ_Constraints constraint_solve_subsumption_1 (MQ_Constraints a_cs,
						      MQ_Constraints cnstrs,
						      MQ_Cons_PP cs_p)
{
  MQ_Constraint new_cnstr;
  MQ_Constraints new_cnstrs, cs, another_cs;
  MQ_VTerm obj;
  int dont_add_new_cnstr;

  new_cnstrs = Extern_h.mQ_void_cnstrs;
  another_cs = cs_p.cs;
  dont_add_new_cnstr = macro.FALSE;

  switch (a_cs.cnstr.rel)
    {
    case Rel.SubsumesVarVar:
      for (cs=cnstrs; cs!=Extern_h.mQ_void_cnstrs; cs=cs.next)
	{
	  if (Unify.equal(a_cs.cnstr.term.vterm, 
                          cs.cnstr.term.vterm) != 0)
	    if (Unify.equal (a_cs.cnstr.vterm.vterm, cs.cnstr.vterm.vterm)!=0)
	      /* X >= Y, X >= Y */ /* found same cnstr */
	      ;
	    else /* X >= Y, X >= Z */
	      {
		new_cnstrs = MQ_Constraints.make_cnstrs_after (cs.cnstr, new_cnstrs);
		new_cnstrs.l_var_list = cs.l_var_list;
		new_cnstrs.r_var_list = cs.r_var_list;
	      }
	  else if (Unify.equal (a_cs.cnstr.term.vterm, 
                                 cs.cnstr.vterm.vterm)!=0)
	    if (Unify.equal (a_cs.cnstr.vterm.vterm, cs.cnstr.term.vterm)!=0)
	      { /* X >= Y, Y >= X */
		Unify.unify (a_cs.cnstr.term, a_cs.cnstr.vterm);
		dont_add_new_cnstr = macro.TRUE;
	      }
	    else
	      { /* X >= Y, Z >= X */
		new_cnstrs = MQ_Constraints.make_cnstrs_after (cs.cnstr, new_cnstrs);
		new_cnstrs.l_var_list = cs.l_var_list;
		new_cnstrs.r_var_list = cs.r_var_list;
		if (cs.cnstr.term.vterm.type == TermType.TT_Var)
		  new_cnstr = MQ_Constraint.make_cnstr (Rel.SubsumesVarVar,
					  cs.cnstr.term.vterm, a_cs.cnstr.vterm.vterm);
		else
		  new_cnstr = MQ_Constraint.make_cnstr (Rel.SubsumesObjVar,
					  cs.cnstr.term.vterm, a_cs.cnstr.vterm.vterm);
		if (cnstr_exists_in_cnstrs (new_cnstr, cnstrs)==0)
		  {
		    another_cs = MQ_Constraints.make_cnstrs_after (new_cnstr, another_cs);
		    another_cs.l_var_list = cs.l_var_list;
		    another_cs.r_var_list = a_cs.r_var_list;
		  }
	      }
	  else if (Unify.equal(a_cs.cnstr.vterm.vterm, cs.cnstr.term.vterm)!=0)
	    { /* X >= Y, Y >= Z */
	      new_cnstrs = MQ_Constraints.make_cnstrs_after (cs.cnstr, new_cnstrs);
	      new_cnstrs.l_var_list = cs.l_var_list;
	      new_cnstrs.r_var_list = cs.r_var_list;
	      new_cnstr = MQ_Constraint.make_cnstr (Rel.SubsumesVarVar,
				      a_cs.cnstr.term.vterm, cs.cnstr.vterm.vterm);
	      if (cnstr_exists_in_cnstrs (new_cnstr, cnstrs)==0)
		{
		  another_cs = MQ_Constraints.make_cnstrs_after (new_cnstr, another_cs);
		  another_cs.l_var_list = a_cs.l_var_list;
		  another_cs.r_var_list = cs.r_var_list;
		}
	    }
	  else if (Unify.equal (a_cs.cnstr.vterm.vterm, cs.cnstr.vterm.vterm)!=0)
	    { /* X >= Y, Z >= Y */
	      new_cnstrs = MQ_Constraints.make_cnstrs_after (cs.cnstr, new_cnstrs);
	      new_cnstrs.l_var_list = cs.l_var_list;
	      new_cnstrs.r_var_list = cs.r_var_list;
	    }
	  else
	    { /* X >= Y, Z >= W */
	      new_cnstrs = MQ_Constraints.make_cnstrs_after (cs.cnstr, new_cnstrs);
	      new_cnstrs.l_var_list = cs.l_var_list;
	      new_cnstrs.r_var_list = cs.r_var_list;
	    }
	}
      break;

    case Rel.SubsumesVarObj:
      for (cs=cnstrs; cs!=Extern_h.mQ_void_cnstrs; cs=cs.next)
	{
	  if (Unify.equal(a_cs.cnstr.term.vterm, cs.cnstr.term.vterm)
	      !=0)
	    if (Unify.equal (a_cs.cnstr.vterm.vterm, cs.cnstr.vterm.vterm)!=0)
	      /* X >= Y, X >= Y */ /* found same cnstr */
	      ;
	    else /* X >= Y, X >= Z */
	      if (cs.cnstr.rel == Rel.SubsumesVarObj
		  && a_cs.r_var_list == null && cs.r_var_list == null)
		{
		  obj = Subsump.join (a_cs.cnstr.vterm.vterm,
				      cs.cnstr.vterm.vterm);
		  new_cnstr = MQ_Constraint.make_cnstr (Rel.SubsumesVarObj,
					  a_cs.cnstr.term.vterm, obj);
		  another_cs = MQ_Constraints.make_cnstrs_after (new_cnstr, another_cs);
		  another_cs.l_var_list = a_cs.l_var_list;
		  another_cs.r_var_list = null;
		  dont_add_new_cnstr = macro.TRUE;
		}
	      else
		{
		  new_cnstrs = MQ_Constraints.make_cnstrs_after (cs.cnstr, new_cnstrs);
		  new_cnstrs.l_var_list = cs.l_var_list;
		  new_cnstrs.r_var_list = cs.r_var_list;
		}
	  else if (Unify.equal (a_cs.cnstr.term.vterm, cs.cnstr.vterm.vterm)
		   !=0)
	    if (Unify.equal (a_cs.cnstr.vterm.vterm, cs.cnstr.term.vterm)!=0)
	      { /* X >= Y, Y >= X */
		Unify.bind (a_cs.cnstr.term.vterm, a_cs.cnstr.vterm.vterm);
		dont_add_new_cnstr = macro.TRUE;
	      }
	    else
	      { /* X >= Y, Z >= X */
		new_cnstrs = MQ_Constraints.make_cnstrs_after (cs.cnstr, new_cnstrs);
		new_cnstrs.l_var_list = cs.l_var_list;
		new_cnstrs.r_var_list = cs.r_var_list;
		if (cs.cnstr.rel == Rel.SubsumesVarVar)
		  {
		    new_cnstr = MQ_Constraint.make_cnstr (Rel.SubsumesVarObj,
					    cs.cnstr.term.vterm,
					    a_cs.cnstr.vterm.vterm);
		    if (cnstr_exists_in_cnstrs (new_cnstr, cnstrs)==0)
		      {
			another_cs = MQ_Constraints.make_cnstrs_after (new_cnstr, another_cs);
			another_cs.l_var_list = cs.l_var_list;
			another_cs.r_var_list = a_cs.r_var_list;
		      }
		  }
		else /* Rel.SubsumesObjVar */
		  {
//		    if (Subsump.eval_subsumption (cs.cnstr.term.vterm,
//					  a_cs.cnstr.vterm.vterm,
//					  another_cs) == macro.FALSE)
		    if ((another_cs =Subsump.eval_subsumption (cs.cnstr.term.vterm,
					  a_cs.cnstr.vterm.vterm,
					  another_cs)) == null)
		      return null;
		  }
	      }
	  else if (Unify.equal (a_cs.cnstr.vterm.vterm, cs.cnstr.term.vterm)
		   !=0)
	    { /* X >= Y, Y >= Z */
	      new_cnstrs = MQ_Constraints.make_cnstrs_after (cs.cnstr, new_cnstrs);
	      new_cnstrs.l_var_list = cs.l_var_list;
	      new_cnstrs.r_var_list = cs.r_var_list;
	      new_cnstr = MQ_Constraint.make_cnstr (Rel.SubsumesVarVar,
				      a_cs.cnstr.term.vterm, cs.cnstr.vterm.vterm);
	      if (cnstr_exists_in_cnstrs (new_cnstr, cnstrs)==0)
		{
		  another_cs = MQ_Constraints.make_cnstrs_after (new_cnstr, another_cs);
		  another_cs.l_var_list = a_cs.l_var_list;
		  another_cs.r_var_list = cs.r_var_list;
		}
	    }
	  else if (Unify.equal (a_cs.cnstr.vterm.vterm, cs.cnstr.vterm.vterm)!=0)
	    { /* X >= Y, Z >= Y */
	      new_cnstrs = MQ_Constraints.make_cnstrs_after (cs.cnstr, new_cnstrs);
	      new_cnstrs.l_var_list = cs.l_var_list;
	      new_cnstrs.r_var_list = cs.r_var_list;
	    }
	  else
	    { /* X >= Y, Z >= W */
	      new_cnstrs = MQ_Constraints.make_cnstrs_after (cs.cnstr, new_cnstrs);
	      new_cnstrs.l_var_list = cs.l_var_list;
	      new_cnstrs.r_var_list = cs.r_var_list;
	    }
	}
      break;

    case Rel.SubsumesObjVar:
      for (cs=cnstrs; cs!=Extern_h.mQ_void_cnstrs; cs=cs.next)
	{
	  if (Unify.equal (a_cs.cnstr.term.vterm, 
                           cs.cnstr.term.vterm) != 0)
	    if (Unify.equal (a_cs.cnstr.vterm.vterm, cs.cnstr.vterm.vterm)!=0)
	      /* X >= Y, X >= Y */ /* found same cnstr */
	      ;
	    else /* X >= Y, X >= Z */
	      {
		new_cnstrs = MQ_Constraints.make_cnstrs_after (cs.cnstr, new_cnstrs);
		new_cnstrs.l_var_list = cs.l_var_list;
		new_cnstrs.r_var_list = cs.r_var_list;
	      }
	  else if (Unify.equal (a_cs.cnstr.term.vterm, cs.cnstr.vterm.vterm)
		   !=0)
	    if (Unify.equal (a_cs.cnstr.vterm.vterm, cs.cnstr.term.vterm)!=0)
	      { /* X >= Y, Y >= X */
		Unify.bind (a_cs.cnstr.vterm.vterm, a_cs.cnstr.term.vterm);
		dont_add_new_cnstr = macro.TRUE;
	      }
	    else
	      { /* X >= Y, Z >= X */
		new_cnstrs = MQ_Constraints.make_cnstrs_after (cs.cnstr, new_cnstrs);
		new_cnstrs.l_var_list = cs.l_var_list;
		new_cnstrs.r_var_list = cs.r_var_list;
		new_cnstr = MQ_Constraint.make_cnstr (Rel.SubsumesVarVar,
					cs.cnstr.term.vterm, a_cs.cnstr.vterm.vterm);
		if (cnstr_exists_in_cnstrs (new_cnstr, cnstrs)==0)
		  {
		    another_cs = MQ_Constraints.make_cnstrs_after (new_cnstr, another_cs);
		    another_cs.l_var_list = cs.l_var_list;
		    another_cs.r_var_list = a_cs.r_var_list;
		  }
	      }
	  else if (Unify.equal (a_cs.cnstr.vterm.vterm, 
                                cs.cnstr.term.vterm) != 0)
	    { /* X >= Y, Y >= Z */
	      new_cnstrs = MQ_Constraints.make_cnstrs_after (cs.cnstr, new_cnstrs);
	      new_cnstrs.l_var_list = cs.l_var_list;
	      new_cnstrs.r_var_list = cs.r_var_list;
	      if (cs.cnstr.rel == Rel.SubsumesVarVar)
		{
		  new_cnstr = MQ_Constraint.make_cnstr (Rel.SubsumesObjVar,
					  a_cs.cnstr.term.vterm, cs.cnstr.vterm.vterm);
		  if (cnstr_exists_in_cnstrs (new_cnstr, cnstrs)==0)
		    {
		      another_cs = MQ_Constraints.make_cnstrs_after (new_cnstr, another_cs);
		      another_cs.l_var_list = a_cs.l_var_list;
		      another_cs.r_var_list = cs.r_var_list;
		    }
		}
	      else /* Rel.SubsumesVarObj */
		{
//		  if (Subsump.eval_subsumption (cs.cnstr.term,
//					a_cs.cnstr.vterm,
//					another_cs) == macro.FALSE)
		  if ((another_cs=Subsump.eval_subsumption 
                        (cs.cnstr.term.vterm,a_cs.cnstr.vterm.vterm,
					another_cs)) == null)
		    return null;
		}
	    }
	  else if (Unify.equal (a_cs.cnstr.vterm.vterm, cs.cnstr.vterm.vterm)!=0)
	    /* X >= Y, Z >= Y */
	    if (cs.cnstr.rel == Rel.SubsumesObjVar
		&& a_cs.l_var_list == null && cs.l_var_list == null)
	      {
		obj = Subsump.meet (a_cs.cnstr.term.vterm,
			    cs.cnstr.term.vterm);
		new_cnstr = MQ_Constraint.make_cnstr (Rel.SubsumesObjVar,
					obj, a_cs.cnstr.vterm.vterm);
		another_cs = MQ_Constraints.make_cnstrs_after (new_cnstr, another_cs);
		another_cs.l_var_list = null;
		another_cs.r_var_list = a_cs.r_var_list;
		dont_add_new_cnstr = macro.TRUE;
	      }
	    else
	      {
		new_cnstrs = MQ_Constraints.make_cnstrs_after (cs.cnstr, new_cnstrs);
		new_cnstrs.l_var_list = cs.l_var_list;
		new_cnstrs.r_var_list = cs.r_var_list;
	      }
	  else
	    {/* X >= Y, Z >= W */
	      new_cnstrs = MQ_Constraints.make_cnstrs_after (cs.cnstr, new_cnstrs);
	      new_cnstrs.l_var_list = cs.l_var_list;
	      new_cnstrs.r_var_list = cs.r_var_list;
	    }
	}
      break;

    default:
      MQ_Error.mq_fatal ("constraint_solve_subsumption_1.\n");
      break;
    }

  if (dont_add_new_cnstr==0)
    new_cnstrs = add_cnstrs_if_not_any (a_cs, new_cnstrs);

  cs_p.cs = another_cs;
  return new_cnstrs;
}

static int cnstr_exists_in_cnstrs (MQ_Constraint cnstr,MQ_Constraints cnstrs)
{
  MQ_Constraints cs;

  for (cs=cnstrs; cs != Extern_h.mQ_void_cnstrs; cs=cs.next)
    if (cs.cnstr.rel == cnstr.rel
	&& (Unify.equal(cs.cnstr.term.vterm,cnstr.term.vterm)!=0)
	&& (Unify.equal (cs.cnstr.vterm.vterm, cnstr.vterm.vterm)!=0))
      return macro.TRUE;
  return macro.FALSE;
}

static MQ_Constraints add_cnstrs_if_not_any (MQ_Constraints a_cs,
					     MQ_Constraints cnstrs)
{
  MQ_Constraints cs, new_obj;
  int exist_p = macro.FALSE;

  for (cs=cnstrs; cs != Extern_h.mQ_void_cnstrs; cs=cs.next)
    if (cs.cnstr.rel == a_cs.cnstr.rel
	&& (Unify.equal(cs.cnstr.term.vterm,a_cs.cnstr.term.vterm)!=0)
	&& (Unify.equal (cs.cnstr.vterm.vterm, a_cs.cnstr.vterm.vterm)!=0))
      {
	exist_p = macro.TRUE;
	break;
      }

  if (exist_p!=0)
    new_obj = cnstrs;
  else
    {
      new_obj = MQ_Constraints.make_cnstrs_after (a_cs.cnstr,cnstrs);
      new_obj.l_var_list = a_cs.l_var_list;
      new_obj.r_var_list = a_cs.r_var_list;
    }

  return new_obj;
}

static MQ_VarList delete_bound_var_in_var_list (MQ_VarList vl)
{
  MQ_VarList next, new_obj;

  if (vl == null)
    return null;

  next = delete_bound_var_in_var_list (vl.next);
  if (vl.var.value.vterm != null)
    new_obj = next;
  else
    if (next == vl.next)
      new_obj = vl;
    else
      new_obj = new MQ_VarList (vl.var, next);

  return new_obj;
}

public static MQ_PP eval_dot (MQ_VTerm dot)
{
  MQ_VTerm obj;
  int i;

  if (dot.vterm.vterm.type != TermType.TT_Obj)
    return null;
  obj = dot.vterm.vterm;
  for (i=0; i<obj.arity; i++)
    if ( ((MQ_Attr)obj.attr.elementAt(i)).label == dot.label)
      return ( ((MQ_Attr)obj.attr.elementAt(i)).vterm);
  return null;
}

public static MQ_VarList vl_p1, vl_p2;

//static unsigned char cnstrs_first_obj;
static VariableProtect vp;
static int constrain_failed;
static MQ_Constraints dot_cnstrs, dot_asmpts, dot_cnstrs_h;
static MQ_Constraints sub_cnstrs, sub_asmpts, sub_cnstrs_h;
static MQ_Constraints ext_cnstrs, ext_asmpts, ext_cnstrs_h;

//cs-sub.c
static MQ_Constraints cnstrs_changed;

//mm_*
public static int mm_current;
public static int mm_cnstrs = 1;
public static int mm_exec = 0;
}
