/* Copyright (C) 1998 Kazumasa Yokota */
/*                                    */
package java_qxt;

public class attr {

static MQ_Goal make_attribute_goals (MQ_Goal g)
{
  MQ_Goal ag, g1;
  MQ_Constraints cs;
  MQ_VTerm dot;

  if (Commands.mq_opt_inheritance==0)
    return null;

  first_subgoal = last_subgoal = null;

  for (cs=Extern_h.cnstrs_asmpts.dot_asmpts; cs!=Extern_h.mQ_void_cnstrs; cs=cs.next)
    {
      dot = cs.cnstr.term.vterm;
      if (Unify.equal (dot.vterm.vterm, g.head.vterm)==0)
	continue;

      if (cs.cnstr.vterm.vterm.type == TermType.TT_Var
	  && (is_parametric (dot.vterm.vterm) == macro.FALSE)){
	generate_attribute_goals (dot);
      }
    }

  if (first_subgoal!=null)
    {
      ag = new MQ_Goal ();
      ag.goal_vterm = g.goal_vterm;
      ag.type = GoalType.GT_Attribute;
      ag.next = g.next;
      ag.parent = g.parent;
      ag.subgoal = first_subgoal;
      for (g1=first_subgoal; g1!=null; g1 = g1.next)
	g1.parent = ag;
    }
  else
    ag = null;

  return ag;
}

static void generate_attribute_goals (MQ_VTerm dot)
{
  if ((Commands.mq_opt_inheritance & macro.INHERIT_UPWARD) != 0)
    generate_attribute_goals_upward (dot);
  if ((Commands.mq_opt_inheritance & macro.INHERIT_DOWNWARD) != 0)
    generate_attribute_goals_downward (dot);
}

static void generate_attribute_goals_upward (MQ_VTerm dot)
{
  MQ_VTerm o;
  MQ_Constraints cs;
  MQ_Goal subgoal;
  MQ_Constraint cnstr1, cnstr2, cnstr3;
  MQ_VTerm v1, v2;
  MQ_VTerm dot2;
  MQ_Atom l;
  MQ_Atom a;
  MQ_VTerm obj;
  int arity;
  MQ_RuleList rl;
  MQ_Rule r;
  MQ_VTermList var_list;
  int exist_p;
  int supersume_p;
  int i, j;

  o = dot.vterm.vterm;
  l = dot.label;
  arity = o.arity;

  Subsump.begin_get_atom_which_supersumes (o.atom);

  a = o.atom;

  subgoal = last_subgoal;
  do
    {
      for (rl=a.rule_list; (rl!=null) && rl.arity < arity; rl=rl.next)
	;

      for (rl=a.rule_list; rl!=null; rl=rl.next)
	for (r=rl.rule; r!=null; r=r.next)
	  {
	    if (r.head.vterm.type != TermType.TT_Obj)
	      MQ_Error.mq_fatal ("attr.java");
	    obj = r.head.vterm;
	    supersume_p = macro.TRUE;

	    if (obj.atom == o.atom && rl.arity == arity)
	      supersume_p = macro.FALSE; /* avoid refuting same object */

	    /* check obj is really supersumes o */
	    for (i=j=0; j < rl.arity; j++)
	      {
		if (i == arity)
		  supersume_p = macro.FALSE;

		if (supersume_p==0)
		  break;

		while (i < arity)
		  if (((MQ_Attr)obj.attr.elementAt(i)).label.name.compareTo( 
		       ((MQ_Attr)o.attr.elementAt(j)).label.name)>0)
		    {
		      supersume_p = macro.FALSE;
		      break;
		    }
		  else if (((MQ_Attr)obj.attr.elementAt(i)).label 
			   == ((MQ_Attr)o.attr.elementAt(j)).label)
		    break;
		  else
		    i++;
	      }
	    if (supersume_p==0)
	      continue;

	    /* check the rule bind the dot term */
	    exist_p = macro.FALSE;
	    for (cs=r.head_cnstrs; cs!=Extern_h.mQ_void_cnstrs; cs=cs.next)
	      if (cs.cnstr.term.vterm.type == TermType.TT_Dot
		  && (cs.cnstr.term.vterm).label == l)
		{
		  exist_p = macro.TRUE;
		  break;
		}
	    if (exist_p==0)
	      continue;

	    /* check if it is not intrinsic attribute */
	    for (j=0; j < rl.arity; j++)
	      if (((MQ_Attr)obj.attr.elementAt(j)).label == l)
		{
		  exist_p = macro.FALSE;
		  break;
		}
	    if (exist_p==0)
	      continue;

	    cs = Extern_h.mQ_void_cnstrs;
	    var_list = MQ_VTermList.generate_variables (r.var_list);
	    obj = Exec.tangle_obj (obj);   /* 1997/10/31 $B=$@5(B */
	    if ((cs=Subsump.eval_subsumption (o, obj,cs)) != null) /* 1997/11/13 $B=$@5(B */
	      {
		last_subgoal = subgoal;
		subgoal = new MQ_Goal ();
		subgoal.var_list = var_list;
		subgoal.type = GoalType.GT_Through;
		subgoal.goal_vterm.vterm = obj;
		subgoal.rule = r;
		subgoal.head_cnstrs                               /* 1997/10/31 $B=$@5(B */
		  = Exec.tangle_constraints (r.head_cnstrs);      /* 1997/10/31 $B=$@5(B */
		subgoal.body_cnstrs                               /* 1997/10/31 $B=$@5(B */
		  = Exec.tangle_constraints (r.body_cnstrs);      /* 1997/10/31 $B=$@5(B */


                subgoal.subgoal = Exec.generate_subgoals (subgoal); /* 1997/10/31 $B=$@5(B */
		dot2 = MQ_VTerm.make_MQ_Dot (dot.label);
		dot2.vterm.vterm = obj;
		v1 = MQ_VTerm.make_MQ_Var ();
		v2 = MQ_VTerm.make_MQ_Var ();
		cnstr1 = MQ_Constraint.make_cnstr (Rel.DotCongruent, 
                                                   dot,v1);
		cnstr2 = MQ_Constraint.make_cnstr (Rel.DotCongruent, 
                                                   dot2,v2);
		cnstr3 = MQ_Constraint.make_cnstr (Rel.Subsumes, 
                                                   v1, v2);
		cs = subgoal.head_cnstrs;
		cs = MQ_Constraints.make_cnstrs_after (cnstr1, cs);
		cs = MQ_Constraints.make_cnstrs_after (cnstr2, cs);
		cs = MQ_Constraints.make_cnstrs_after (cnstr3, cs);
		subgoal.head_cnstrs = cs;
		if (last_subgoal!=null)
		  last_subgoal.next = subgoal;
		else
		  first_subgoal = subgoal;
	      }
	  }
    }
  while ( (a=Subsump.get_next_atom_supersump()) !=null);

  last_subgoal = subgoal;
}

static void generate_attribute_goals_downward (MQ_VTerm dot)
{
  MQ_VTerm o;
  MQ_Constraints cs;
  MQ_Goal subgoal;
  MQ_Constraint cnstr1, cnstr2, cnstr3;
  MQ_VTerm v1, v2;
  MQ_VTerm dot2;
  MQ_Atom l;
  MQ_Atom a;
  MQ_VTerm obj;
  int arity;
  MQ_RuleList rl;
  MQ_Rule r;
  MQ_VTermList var_list;
  int exist_p;
  int subsume_p;
  int i, j;

  o = dot.vterm.vterm;
  l = dot.label;
  arity = o.arity;

  Subsump.begin_get_atom_which_subsumes (o.atom);
  a = o.atom;

  subgoal = last_subgoal;
  do{
    for (rl=a.rule_list; (rl!=null) && rl.arity <= arity; rl=rl.next)
      for (r=rl.rule; r!=null; r=r.next)
	{
	  if (r.head.vterm.type != TermType.TT_Obj)
	    MQ_Error.mq_fatal ("attr.c");
	  obj = r.head.vterm;
	  subsume_p = macro.TRUE;

	  if (obj.atom == o.atom && rl.arity == arity)
	    subsume_p = macro.FALSE; /* avoid refuting same object */

	  /* check obj is really subsumes o */
	  for (i=j=0; i < rl.arity; i++)
	    {
	      if (j == arity)
		subsume_p = macro.FALSE;

	      if (subsume_p==0)
		break;

	      while (j < arity)
		/* 1997/10/31 $B=$@5(B */
		if ( ( ((MQ_Attr)obj.attr.elementAt(i)).label.name.compareTo(((MQ_Attr)o.attr.elementAt(j)).label.name)) > 0 ) 

		  {
		    subsume_p = macro.FALSE;
		    break;
		  }
		else if (((MQ_Attr)obj.attr.elementAt(i)).label 
			 == ((MQ_Attr)o.attr.elementAt(j)).label)
		  break;
		else
		  j++;
	    }
	  if (subsume_p==0)
	    continue;
	  exist_p = macro.FALSE;
	  for (cs=r.head_cnstrs; cs!=Extern_h.mQ_void_cnstrs; cs=cs.next)
	    if (cs.cnstr.term.vterm.type == TermType.TT_Dot
		&& (cs.cnstr.term.vterm).label == l)
	      {
		exist_p = macro.TRUE;
		break;
	      }
	  if (exist_p==0)
	    continue;
	  /* check if it is not intrinsic attribute */
	  for (j=0; j < rl.arity; j++)
	    if (((MQ_Attr)obj.attr.elementAt(j)).label == l)
	      {
		exist_p = macro.FALSE;
		break;
	      }
	  if (exist_p==0)
	    continue;

	  cs = Extern_h.mQ_void_cnstrs;
	  var_list = MQ_VTermList.generate_variables (r.var_list);
	  obj = Exec.tangle_obj (obj); /* 1997/10/31 $B=$@5(B */
	  if ((cs=Subsump.eval_subsumption (obj, o, cs)) != null) /* 1997/10/31 $B=$@5(B */
	    {
	      last_subgoal = subgoal;
	      subgoal = new MQ_Goal ();
	      subgoal.var_list = var_list;
	      subgoal.type = GoalType.GT_Through;
	      subgoal.goal_vterm.vterm = obj;
	      subgoal.rule = r;
	      subgoal.head_cnstrs = Exec.tangle_constraints (r.head_cnstrs); /* 1997/10/31 $B=$@5(B */
	      subgoal.body_cnstrs = Exec.tangle_constraints (r.body_cnstrs); /* 1997/10/31 $B=$@5(B */
              subgoal.subgoal = Exec.generate_subgoals (subgoal); /* 1997/10/31 $B=$@5(B */
	      dot2 = MQ_VTerm.make_MQ_Dot (dot.label);
	      dot2.vterm.vterm = obj;
	      v1 = MQ_VTerm.make_MQ_Var ();
	      v2 = MQ_VTerm.make_MQ_Var ();
	      cnstr1 = MQ_Constraint.make_cnstr (Rel.DotCongruent, dot, v1);
	      cnstr2 = MQ_Constraint.make_cnstr (Rel.DotCongruent, dot2, v2);
	      cnstr3 = MQ_Constraint.make_cnstr (Rel.Subsumes, v2, v1);
	      cs = subgoal.head_cnstrs;
	      cs = MQ_Constraints.make_cnstrs_after (cnstr1, cs);
	      cs = MQ_Constraints.make_cnstrs_after (cnstr2, cs);
	      cs = MQ_Constraints.make_cnstrs_after (cnstr3, cs);
	      subgoal.head_cnstrs = cs;
	      if (last_subgoal!=null)
		last_subgoal.next = subgoal;
	      else
		first_subgoal = subgoal;
	    }
	}
  }
  while ( (a = Subsump.get_next_atom_subsump ())!=null );

  last_subgoal = subgoal;
}

static int is_parametric ( MQ_VTerm  vt)
{
  MQ_VTerm o;
  int i;

  switch (vt.type)
    {
    case TermType.TT_Var:
      return macro.TRUE;
    case TermType.TT_Obj:
      o =  vt;
      for (i=0; i < o.arity; i++)
	if (is_parametric (((MQ_Attr)o.attr.elementAt(i)).vterm.vterm)!=0)
	  return macro.TRUE;
      return macro.FALSE;
    default:
      MQ_Error.mq_fatal ("something wrong in is_parametric.");
      return 0;
    }
}


static MQ_Goal first_subgoal, last_subgoal;


}
