/* Copyright (C) 1998 Kazumasa Yokota */
/*                                    */
package java_qxt;

public class Unify {

static void init_unify ()
{
  ;
}

static void unwind_protect_variable (MQ_VTerm v)
{
  UnwindProtect up1;

  up1 = new UnwindProtect();
  up1.next  = Extern_h.up;
  up1.var   = v;
  up1.vterm_addr_list = null;
  Extern_h.up = up1;
}

static void unwind_protect_variable_in_cnstrs (MQ_VTerm v,
					      MQ_VTermAddrList vterm_addr_list)
{
  UnwindProtect up1;

  up1 = new UnwindProtect();
  up1.next  = Extern_h.up;
  up1.var   = v;
  up1.vterm_addr_list = vterm_addr_list;
  Extern_h.up = up1;
}

static void unwind_variable (MQ_VTerm var, MQ_VTermAddrList vterm_addr_list)
{
  MQ_VTermAddrList val;
  MQ_PP value = new MQ_PP(), orig;

  if (vterm_addr_list!=null)
    var.vterm_addr_list = vterm_addr_list;
  else
    {
      value.vterm = var.value.vterm;
      if (value.vterm != null)
	{
	  var.value.vterm = null;
	  for (val = var.vterm_addr_list; val!=null ; val = val.next)
	      val.vterm_addr.vterm = var;
	}
      else
	var.var_list = var.var_list.next;
    }
}

static void unwind_variables (UnwindProtect up_back)
{
  for (; Extern_h.up != up_back; Extern_h.up = Extern_h.up.next)
      unwind_variable (Extern_h.up.var, Extern_h.up.vterm_addr_list);
}

static int equal_var (MQ_VTerm v1, MQ_VTerm v2)
{
  UnwindProtect up1;
  int result;

  up1 = Extern_h.up;
  bind (v1, Extern_h.mq_name);
  if (v2.value.vterm == Extern_h.mq_name)
    result = macro.TRUE;
  else
    result = macro.FALSE;
  unwind_variables (up1);
  return result;
}

static int equal (MQ_VTerm vt1, MQ_VTerm vt2)
{
  MQ_VTerm v1, v2;
  MQ_VTerm o1, o2;
  int i;

  if (vt1 == vt2)
    return macro.TRUE;

  if (vt1.type == TermType.TT_Var)
    {
      v1 = vt1;
      if (vt2.type == TermType.TT_Var)
	{
	  v2 = vt2;
	  return equal_var (vt1,vt2);
	}
      return macro.FALSE;
    }
  else
    if (vt2.type == TermType.TT_Var)
      return macro.FALSE;
    else
      {
	if (vt1.type != TermType.TT_Obj)
	  MQ_Error.mq_fatal ("equal.");
	if (vt2.type != TermType.TT_Obj)
	  MQ_Error.mq_fatal ("equal.");

	o1 = vt1;
	o2 = vt2;
	if ((o1.atom != o2.atom) || (o1.arity != o2.arity))
	  return macro.FALSE;

	for (i=0; i < o1.arity; i++)
	  if (((MQ_Attr)o1.attr.elementAt(i)).label 
	      != ((MQ_Attr)o2.attr.elementAt(i)).label)
	    return macro.FALSE;

	for (i=0; i < o1.arity; i++)
	  if (equal ( ((MQ_Attr)o1.attr.elementAt(i)).vterm.vterm, 
		     ((MQ_Attr)o2.attr.elementAt(i)).vterm.vterm ) 
	      == macro.FALSE)
	    return macro.FALSE;
	return macro.TRUE;
      }
}

static void bind (MQ_VTerm var,MQ_VTerm vt)
{
  MQ_VTermAddrList val;
  MQ_VTerm orig;
  MQ_VarList vl;

  if (var.value.vterm != null)
    MQ_Error.mq_fatal ("bind.");

  unwind_protect_variable (var);

  var.value.vterm = vt;

  Extern_h.binding_changed = macro.TRUE;

  for (val = var.vterm_addr_list; val!=null; val = val.next)
      val.vterm_addr.vterm = vt;

  for (vl = var.var_list; vl!=null ; vl = vl.next)
    if (vl.var.value.vterm == null)
      bind (vl.var, vt);

}


static int unify (MQ_PP vt1_p,MQ_PP vt2_p)
{
  MQ_VTerm v1, v2;
  MQ_VTerm o1, o2;
  MQ_VTerm tmp;
  int i,f1=0,f2=0;

  if (vt1_p.vterm == vt2_p.vterm){
    return macro.SUCCESS;
  }

  if (vt1_p.vterm.type == TermType.TT_Var)
    {
      v1 = vt1_p.vterm;
      if (vt2_p.vterm.type == TermType.TT_Var)
	{
	  v2 = vt2_p.vterm;

	  if (((vt1_p.vterm).value.vterm != null) || ((vt2_p.vterm).value.vterm != null))
	    MQ_Error.mq_fatal ("1: unify.");
	  unwind_protect_variable (vt1_p.vterm);
	  unwind_protect_variable (vt2_p.vterm);
	  Extern_h.binding_changed = macro.TRUE;
          
	  vt1_p.vterm.var_list = new MQ_VarList (vt2_p.vterm, vt1_p.vterm.var_list);
	  vt2_p.vterm.var_list = new MQ_VarList (vt1_p.vterm, vt2_p.vterm.var_list);

	}
      else{
	bind (v1,vt2_p.vterm);
      /* macro.SUCCESS */
   } }
  else
    if (vt2_p.vterm.type == TermType.TT_Var)
      {
	v2 = vt2_p.vterm;
        
	bind (v2, vt1_p.vterm);
	/* macro.SUCCESS */
      }
    else
      {
	if (vt1_p.vterm.type != TermType.TT_Obj)
	  MQ_Error.mq_fatal ("2: unify.");
	if (vt2_p.vterm.type != TermType.TT_Obj)
	  MQ_Error.mq_fatal ("3: unify.");

	o1 = vt1_p.vterm;
	o2 = vt2_p.vterm;
	if ((o1.atom != o2.atom) || (o1.arity != o2.arity))
	  return macro.FAILURE;

	for (i=0; i < o1.arity; i++)
	  if ( ((MQ_Attr)o1.attr.elementAt(i)).label 
	        != 
	       ((MQ_Attr)o2.attr.elementAt(i)).label)
	    return macro.FAILURE;

	for (i=0; i < o1.arity; i++)
	  if (unify (((MQ_Attr)o1.attr.elementAt(i)).vterm, 
		     ((MQ_Attr)o2.attr.elementAt(i)).vterm) == macro.FAILURE)
	    return macro.FAILURE;
      }

  return macro.SUCCESS;
  }
}
