/* Copyright (C) 1998 Kazumasa Yokota */
/*                                    */
package java_qxt;

public class Subsump {


/*-------------------------------------------------------------------------*/
/* $B%a%=%C%IL>!'(Bgenerate_lattice                                            */
/* $B;EMM!'(Bgenerate_lattice()                                                */
/* $B0z?t!'$J$7!#(B                                                            */
/* $B5!G=!'(Blattice$B$N@8@.!#(B                                                   */
/* $BLa$jCM!'$J$7(B                                                            */
/*-------------------------------------------------------------------------*/

static void generate_lattice ()
{
  MQ_SubRel s;
  MQ_AtomList al1, al2, al, all_a;
  MQ_AtomSet as;
  MQ_AtomAtomSet aas, aas1, aas2, aas3;
  int i,j;
  String exec_obj;

  free_lattice ();

  lno=0;
  aas = null;

  /* set for bottom */
  al = MQ_AtomList.make_atom_list (Extern_h.mqA_Bottom, null);
  as = MQ_AtomSet.intern_atom_set (al);
  Extern_h.mqA_Bottom.lattice_index = lno++;
  aas = new MQ_AtomAtomSet (Extern_h.mqA_Bottom, as.atom_list, aas);

  /* set for top */
  al = MQ_AtomList.make_atom_list (Extern_h.mqA_Bottom, null); /* can't share */
  al = MQ_AtomList.make_atom_list (Extern_h.mqA_Top, al);

  for (s=MQ_SubRel.subrel_list; s!=null; s=s.next)
    {
      int exists;

      exists = 0;
      for (al1=al; al1!=null; al1=al1.next)
	if (al1.atom == s.a1)
	  {
	    exists = 1;
	    break;
	  }
      if (exists==0)
	al = MQ_AtomList.make_atom_list (s.a1, al);

      exists = 0;
      for (al1=al; al1!=null; al1=al1.next)
	if (al1.atom == s.a2)
	  {
	    exists = 1;
	    break;
	  }
      if (exists==0)
	al = MQ_AtomList.make_atom_list (s.a2, al);
    }
  as = MQ_AtomSet.intern_atom_set (al);
  all_a = as.atom_list;
  Extern_h.mqA_Top.lattice_index = lno++;
  aas = new MQ_AtomAtomSet (Extern_h.mqA_Top, as.atom_list, aas);

  MQ_AtomList all_atom;

  for (al1 = all_a; al1!=null; al1=al1.next)
    {
      if (al1.atom == Extern_h.mqA_Top || al1.atom == Extern_h.mqA_Bottom)
	continue;

      al = MQ_AtomList.make_atom_list (Extern_h.mqA_Bottom, null);
      for (al2 = all_a; al2!=null; al2=al2.next){
	if (subsume_subrel (al1.atom, al2.atom) !=0)
	  al = MQ_AtomList.make_atom_list (al2.atom, al);
      }
      al1.atom.lattice_index = lno++;
      as = MQ_AtomSet.intern_atom_set (al);
      aas = new MQ_AtomAtomSet (al1.atom, as.atom_list, aas);
    }

  while (true)
    {
      MQ_AtomAtomSet last_aas;

      last_aas = aas;
      aas1=aas;
      while (aas1!=null)
	{
	  aas1 = aas1.next;
	  for (aas2=aas1; aas2!=null; aas2 = aas2.next)
	    {
	      al = intersection (aas1.atom_list, aas2.atom_list);
	      if (atom_set_exsits (al) == macro.FALSE)
		{
//		  String  new_name;
		  String  name;
		  int len;
		  MQ_Atom atom;

		  len = aas1.atom.name.length()
		    +aas2.atom.name.length() + 4;
		  if (len > 1023)
		    name = "too-complexed...";
		  else
		    {
 			System.out.println("name+++++++++");
	//	      name = "&_"+aas1.atom.name+"_"+aas2.atom.name;
		      name = "&_"+aas1.atom.name;;
                      name.concat("_"+aas2.atom.name);
		    }

		  atom = MQ_Atom.make_atom (name);
		  atom.lattice_index = lno++;

		  for (aas3=aas; aas3!=null; aas3=aas3.next)
		    if ( (includes (aas1.atom, aas3.atom_list)!=0)
			 || 
			 (includes (aas2.atom, aas3.atom_list)!=0)
			)
		      {
			/* update atom_list of aas3 */
			delete_from_atom_set (aas3.atom_list);
			al1 = MQ_AtomList.make_atom_list (atom, aas3.atom_list);
			as = MQ_AtomSet.intern_atom_set (al1);
			aas3.atom_list = as.atom_list;
		      }

		  al = MQ_AtomList.make_atom_list (atom, al);
		  as = MQ_AtomSet.intern_atom_set (al);
		  aas = new MQ_AtomAtomSet (atom, as.atom_list, aas);
		}
	    }
	}
      if (aas == last_aas)
	break;
    }
  aas_begin = aas;

  l_bitmap = new boolean[lno*lno];
  /* bottom */
  for (j=0; j<lno; j++)
    l_bitmap[0*lno+j]=false;
  l_bitmap[0*lno+0]=true;
  /* top */
  for (j=0; j<lno; j++)
    l_bitmap[1*lno+j]=true;
  for (i=2; i<lno; i++)
    {
      for (j=0; j<lno; j++)
	l_bitmap[i*lno+j]=false;
      /* self */
      l_bitmap[i*lno+i]=true;
      /* bottom */
      l_bitmap[i*lno+0]=true;
    }

  lattice = new MQ_Atom[lno];
  i = lno;
  for (aas=aas_begin; aas!=null; aas=aas.next)
    {
      MQ_AtomList al_2;

      lattice[--i] = aas.atom;
      for (al_2=aas.atom_list; al_2!=null; al_2=al_2.next)
	modify_l_bitmap (aas.atom.lattice_index, al_2.atom.lattice_index);
    }

  int w,z;

}



/*-------------------------------------------------------------------------*/
/* $B%a%=%C%IL>!'(Bmodify_l_bitmap                                             */
/* $B;EMM!'(Bmodify_l_bitmap (int i,int j)                                     */
/* $B0z?t!'(Bint i$B!'Jq@]$9$k%"%H%`$N(Blattice_index$B$NCM!#(B                        */
/*       int j$B!'Jq@]$5$l$k%"%H%`$N(Blattice_index$B$NCM!#(B                      */
/* $B5!G=!'(Bl_bitmap[i*lno+j]$B$K(BTRUE$B$rBeF~$9$k!#(B                               */
/* $BLa$jCM!'$J$7(B                                                            */
/*-------------------------------------------------------------------------*/

static void modify_l_bitmap (int i,int j)
{
  if ((i < 0) || (j < 0))
    MQ_Error.mq_fatal ("something wrong in lattice");

  l_bitmap[i*lno+j] = true;
}

static MQ_Atom a_join (MQ_Atom a1,MQ_Atom a2)
{
  int x;
  int min;
  int l1, l2;

  if (a1 == a2)
    return a1;
  if (a1 == Extern_h.mqA_Bottom)
    return a2;
  if (a2 == Extern_h.mqA_Bottom)
    return a1;

  l1 = a1.lattice_index; 
  l2 = a2.lattice_index; 

  if ((l1 < 0) || (l2 < 0))
    return Extern_h.mqA_Top;

  min = 1;
  for (x=0; x<lno; x++)
    if (l_bitmap[x*lno+l1]&l_bitmap[x*lno+l2])
      if (l_bitmap[min*lno+x])
	min = x;

  return lattice[min];
}

static MQ_Atom a_meet (MQ_Atom a1, MQ_Atom a2)
{
  int x;
  int max;
  int l1, l2;
  l1 = a1.lattice_index; 
  l2 = a2.lattice_index; 

  if (a1 == a2)
    return a1;
  if (a1 == Extern_h.mqA_Top)
    return a2;
  if (a2 == Extern_h.mqA_Top)
    return a1;

  if ((l1 < 0) || (l2 < 0))
    return Extern_h.mqA_Bottom;

  max = 0;
  for (x=0; x<lno; x++)
    if (l_bitmap[l1*lno+x]&l_bitmap[l2*lno+x])
      if (l_bitmap[x*lno+max]!=false)
	max = x;

  return lattice[max];
}

public static MQ_VTerm join (MQ_VTerm o1, MQ_VTerm o2)
{
  MQ_Atom a;
  MQ_VTerm o;
  int i,j;
  int new_arity;
  int found;
  IJ_List ij_list;
//  struct obstack *mm_old;

  if (o1 == Extern_h.mqO_Bottom)
    return o2;

  if (o2 == Extern_h.mqO_Bottom)
    return o1;

  a = a_join (o1.atom, o2.atom);

  j = new_arity = 0;
  ij_list = null;

  /* Note: attr is sorted by label address */
  for (i=0; i < o1.arity; i++)
    {
      if (j == o2.arity)
	break;

      found = macro.FALSE;
      while (j < o2.arity)

	if (true)
//	if (
//	    ((MQ_Attr)o1.attr.elementAt(i)).label 
//	    > ((MQ_Attr)o2.attr.elementAt(j)).label)
	  break;
	else if (
		 ((MQ_Attr)o1.attr.elementAt(i)).label 
		 == ((MQ_Attr)o2.attr.elementAt(j)).label)
	  {
	    found = macro.TRUE;
	    break;
	  }
	else
	  j++;

      if (found!=0)
	{
	  ij_list = IJ_List.make_ij_list (i, j, ij_list);
	  new_arity++;
	}
    }

//  mm_old = mm_current;
//  mm_current = mm_exec;
  o = MQ_VTerm.make_object (a, new_arity);
//  mm_current = mm_old;
  while (ij_list!=null)
    {
      --new_arity;
      ((MQ_Attr)o.attr.elementAt(new_arity)).label
	= ((MQ_Attr)o1.attr.elementAt(ij_list.i)).label;
      ((MQ_Attr)o.attr.elementAt(new_arity)).vterm.vterm
	= Subsump.join(
			((MQ_Attr)o1.attr.elementAt(ij_list.i)).vterm.vterm,
			((MQ_Attr)o2.attr.elementAt(ij_list.j)).vterm.vterm);
      ij_list = ij_list.next;
    }

  return o;
}


public static MQ_VTerm meet (MQ_VTerm o1, MQ_VTerm o2)
{
  MQ_Atom a;
  MQ_VTerm o;
  int i,j;
  int new_arity;
  int found;
  IJ_List ij_list;
//  struct obstack *mm_old;

  if (o1 == Extern_h.mqO_Top)
    return o2;

  if (o2 == Extern_h.mqO_Top)
    return o1;

  a = a_meet (o1.atom, o2.atom);
  if (a == Extern_h.mqA_Bottom)
    return Extern_h.mqO_Bottom;

  j = new_arity = 0;
  ij_list = null;

  /* Note: attr is sorted by label address */
  for (i=0; i < o1.arity; i++)
    {
      found = macro.FALSE;
      while (j < o2.arity)//$B%*%V%8%'%/%H$N%]%$%s%?$NHf3S(B
	if (true)
//	if ( ((MQ_Attr)o1.attr.elementAt(i)).label 
//	    > ((MQ_Attr)o2.attr.elementAt(j)).label)
	  break;
	else if (((MQ_Attr)o1.attr.elementAt(i)).label 
		 == ((MQ_Attr)o2.attr.elementAt(j)).label)
	  {
	    found = macro.TRUE;
	    break;
	  }
	else
	  {
	    ij_list = IJ_List.make_ij_list (-1, j, ij_list);
	    new_arity++;
	    j++;
	  }

      if (found!=0)
	{
	  ij_list = IJ_List.make_ij_list (i, j, ij_list);
	  j++;
	}
      else
	ij_list = IJ_List.make_ij_list (i, -1, ij_list);
      new_arity++;
    }

  while (j < o2.arity)
    {
      ij_list = IJ_List.make_ij_list (-1, j, ij_list);
      new_arity++;
      j++;
    }
  
//  mm_old = mm_current;
//  mm_current = mm_exec;
  o = MQ_VTerm.make_object (a, new_arity);
//  mm_current = mm_old;
  while (ij_list!=null)
    {
      --new_arity;
      if (ij_list.i == -1)
	{
	  ((MQ_Attr)o.attr.elementAt(new_arity)).label 
	    = ((MQ_Attr)o2.attr.elementAt(ij_list.j)).label;
	  ((MQ_Attr)o.attr.elementAt(new_arity)).vterm 
	    = ((MQ_Attr)o2.attr.elementAt(ij_list.j)).vterm;
	}
      else if (ij_list.j == -1)
	{
	  ((MQ_Attr)o.attr.elementAt(new_arity)).label 
	    = ((MQ_Attr)o1.attr.elementAt(ij_list.i)).label;
	  ((MQ_Attr)o.attr.elementAt(new_arity)).vterm 
	   = ((MQ_Attr)o1.attr.elementAt(ij_list.i)).vterm;
	}
      else
	{
	  ((MQ_Attr)o.attr.elementAt(new_arity)).label 
	    = ((MQ_Attr)o1.attr.elementAt(ij_list.i)).label;
	  ((MQ_Attr)o.attr.elementAt(new_arity)).vterm.vterm
	    = meet( ((MQ_Attr)o1.attr.elementAt(ij_list.i)).vterm.vterm,
		    ((MQ_Attr)o2.attr.elementAt(ij_list.j)).vterm.vterm);
	}
      ij_list = ij_list.next;
    }

  return o;
}



/*-------------------------------------------------------------------------*/
/* $B%a%=%C%IL>!'(Bdelete_from_atom_set                                        */
/* $B;EMM!'(Bdelete_from_atom_set (MQ_AtomList al)                             */
/* $B0z?t!'(BMQ_AtomList al$B!':o=|$9$k%"%H%`%j%9%H!#(B                            */
/* $B5!G=!'(BMQ_AtomSet.atom_set_pool$B$+$i(Bal$B$r:o=|$9$k!#(B                        */
/* $BLa$jCM!'$J$7(B                                                            */
/*-------------------------------------------------------------------------*/

public static void delete_from_atom_set (MQ_AtomList al)
{
  MQ_AtomSet p, last;
  int val;

  last = null;
  for (p=MQ_AtomSet.atom_set_pool; p!=null; p=p.next_bucket)
    {
      if (MQ_AtomList.atom_list_cmp (al, p.atom_list) == macro.TRUE)
        {
          if (last!=null)
            last.next_bucket = p.next_bucket;
          else
            MQ_AtomSet.atom_set_pool = p.next_bucket;
          return;
        }
      last = p;
    }

  MQ_Error.mq_fatal ("delete_from_atom_set.");
}



/*-------------------------------------------------------------------------*/
/* $B%a%=%C%IL>!'(Bfree_lattice                                                */
/* $B;EMM!'(Bfree_lattice ()                                                   */
/* $B0z?t!'$J$7!#(B                                                            */
/* $B5!G=!'(Blattice$B$N=i4|2=!#(B                                                 */
/* $BLa$jCM!'$J$7(B                                                            */
/*-------------------------------------------------------------------------*/

static void free_lattice ()
{
  lattice_first_obj = null;
  MQ_AtomSet.atom_set_pool     = null;
}


/*-------------------------------------------------------------------------*/
/*        1997/10/29       $B=$@5(B                                            */
/*-------------------------------------------------------------------------*/

static void init_lattice()
{
   /*Extern_h.mqA_Bottom = MQ_Atom.intern_atom("&bottom");
   Extern_h.mqA_Top = MQ_Atom.intern_atom("&top");

   Extern_h.mqO_Bottom = MQ_VTerm.make_object(Extern_h.mqA_Bottom, 0);
   Extern_h.mqO_Top = MQ_VTerm.make_object(Extern_h.mqA_Top, 0);*/
}



/*-------------------------------------------------------------------------*/
/* $B%a%=%C%IL>!'(Bincludes                                                    */
/* $B;EMM!'(Bincludes (MQ_Atom a,MQ_AtomList al)                               */
/* $B0z?t!'(BMQ_Atom a$B!'%"%H%`!#(B                                               */
/*       MQ_AtomList al$B!'%"%H%`%j%9%H!#(B                                    */
/* $B5!G=!'(Bal $B$+$i(B a $B$rC5$9!#(B                                                */
/* $BLa$jCM!'(Bmacro.TRUE$B!'(Bal $B$K(B a $B$,B8:_$9$k>l9g!#(B                            */
/*         macro.FALSE$B!'(Bal $B$K(B a $B$,B8:_$7$J$$>l9g!#(B                         */
/*-------------------------------------------------------------------------*/

static int includes (MQ_Atom a,MQ_AtomList al)
{
  while (al!=null)
    {
      if (al.atom == a)
        return macro.TRUE;
      al = al.next;
    }
  return macro.FALSE;
}



/*-------------------------------------------------------------------------*/
/* $B%a%=%C%IL>!'(Bsubsume_subrel                                              */
/* $B;EMM!'(Bsubsume_subrel (MQ_Atom a1,MQ_Atom a2)                            */
/* $B0z?t!'(BMQ_Atom a1$B!'%"%H%`!#(B                                              */
/*       MQ_Atom a2$B!'%"%H%`!#(B                                              */
/* $B5!G=!'(Ba1 >= a2 $B$,Dj5A$5$l$F$$$k$+$r(B MQ_SubRel.subrel_list $B$r8+$FD4$Y$k!#(B*/
/* $BLa$jCM!'(Bmacro.TRUE$B!'(Ba1 >= a2 $B$,Dj5A$5$l$F$$$k>l9g!#(B                     */
/*         macro.FALSE$B!'(Ba1 >= a2 $B$,Dj5A$5$l$F$$$J$$>l9g!#(B                  */
/*-------------------------------------------------------------------------*/

static int subsume_subrel (MQ_Atom a1,MQ_Atom a2)
{
  MQ_SubRel s;

  if (a1 == a2)
    return macro.TRUE;

    for (s = MQ_SubRel.subrel_list; s!=null; s=s.next)
    if ((s.a1 == a1))
      if (subsume_subrel (s.a2, a2)!=0)
        return macro.TRUE;

  return macro.FALSE;
}



/*-------------------------------------------------------------------------*/
/* $B%a%=%C%IL>!'(Bintersection                                                */
/* $B;EMM!'(Bintersection (MQ_AtomList al1, MQ_AtomList al2)                   */
/* $B0z?t!'(BMQ_AtomList al1$B!'%"%H%`%j%9%H!#(B                                   */
/*       MQ_AtomList al2$B!'%"%H%`%j%9%H!#(B                                   */
/* $B5!G=!'(Bal1 $B$H(B al2 $B$K6&DL$9$k%"%H%`$N%j%9%H$r:n@.$9$k!#(B                   */
/* $BLa$jCM!'(Bal: al1 $B$H(B al2 $B$K6&DL$9$k%"%H%`$N%j%9%H!#(B                       */
/*         null$B!'6&DL$9$k%"%H%`$,L5$$>l9g!#(B                                */
/*-------------------------------------------------------------------------*/

static MQ_AtomList intersection (MQ_AtomList al1, MQ_AtomList al2)
{
  MQ_AtomList al;

  al=null;
  while ((al1!=null) && (al2!=null))
    if ( al1.atom ==  al2.atom)
      {
        al = MQ_AtomList.make_atom_list (al1.atom, al);
        al1 = al1.next;
        al2 = al2.next;
      }
    else if (al1.atom.name.compareTo(al2.atom.name)<0)
      al1 = al1.next;
    else if (al1.atom.name.compareTo(al2.atom.name)>0)
      al2 = al2.next;

  return al;
}



/*-------------------------------------------------------------------------*/
/* $B%a%=%C%IL>!'(Batom_set_exsits                                             */
/* $B;EMM!'(Batom_set_exsits (MQ_AtomList al)                                  */
/* $B0z?t!'(BMQ_AtomList al$B!'%"%H%`%j%9%H!#(B                                    */
/* $B5!G=!'(BMQ_AtomSet.atom_set_pool $B$K(B al $B$,B8:_$9$k$+$I$&$+$rD4$Y$k!#(B       */
/* $BLa$jCM!'(Bmacro.TRUE$B!'(BMQ_AtomSet.atom_set_pool $B$K(B al $B$,B8:_$9$k>l9g!#(B     */
/*         macro.FALSE$B!'(BMQ_AtomSet.atom_set_pool $B$K(B al $B$,B8:_$7$J$$>l9g!#(B  */
/*-------------------------------------------------------------------------*/

public static int atom_set_exsits (MQ_AtomList al)
{
  MQ_AtomList al1;
  MQ_AtomSet p;
  int val;

  al1 = copy_al (al);
  al1 = MQ_AtomList.sort_atom_list (al1);
  for (p=MQ_AtomSet.atom_set_pool; p!=null; p=p.next_bucket)
    if (MQ_AtomList.atom_list_cmp (al1, p.atom_list) == macro.TRUE)
      return macro.TRUE;
  return macro.FALSE;
}



/*-------------------------------------------------------------------------*/
/* $B%a%=%C%IL>!'(Bcopy_al                                                     */
/* $B;EMM!'(Bcopy_al (MQ_AtomList al)                                          */
/* $B0z?t!'(BMQ_AtomList al$B!'%"%H%`%j%9%H!#(B                                    */
/* $B5!G=!'(Bal $B$N%3%T!<$r:n@.$9$k!#(B                                           */
/* $BLa$jCM!'(Bnull$B!'(Bal==null$B$N>l9g!#(B                                          */
/*         MQ_AtomList$B!'(Bal!=null $B$N>l9g!#:n@.$7$?(Bal$B$N%3%T!<$N@hF,$rJV$9!#(B  */
/*-------------------------------------------------------------------------*/

static MQ_AtomList copy_al (MQ_AtomList al)
{
  MQ_AtomList next;

  if (al == null)
    return null;
  next = copy_al (al.next);
  return MQ_AtomList.make_atom_list (al.atom, next);
}

//static int eval_subsumption (MQ_VTerm vt1, MQ_VTerm vt2,
//			     MQ_Constraints cnstrs_p)
static MQ_Constraints eval_subsumption (MQ_VTerm vt1, MQ_VTerm vt2,
		MQ_Constraints cnstrs_p)    /* 1997/11/10 $B=$@5(B */
{
  MQ_VTerm o1, o2;
  MQ_Constraint cnstr;
  int i, j;
  int ans;

  if (Unify.equal (vt1, vt2) == macro.TRUE){
//    return macro.TRUE;
      return Extern_h.mQ_void_cnstrs;
  }

  switch (vt1.type)
    {
    case TermType.TT_Var:
      switch (vt2.type)
	{
	case TermType.TT_Var:
	  cnstr = MQ_Constraint.make_cnstr (Rel.SubsumesVarVar, vt1, vt2);
	  cnstrs_p = MQ_Constraints.make_cnstrs_after (cnstr, cnstrs_p);
	  (cnstrs_p).l_var_list = (vt1).var_list;
	  (cnstrs_p).r_var_list = (vt2).var_list;
//	  return macro.TRUE;
      return cnstrs_p;

	case TermType.TT_Obj:
	  cnstr = MQ_Constraint.make_cnstr (Rel.SubsumesVarObj, vt1, vt2);
	  cnstrs_p = MQ_Constraints.make_cnstrs_after (cnstr, cnstrs_p);
	  (cnstrs_p).l_var_list = (vt1).var_list;
	  (cnstrs_p).r_var_list = variables_in_obj (vt2);
//	  return macro.TRUE;
      return cnstrs_p;

	default:
	  MQ_Error.mq_fatal ("something wrong in eval_subsumption");
	  break;
	}
      break;

    case TermType.TT_Obj:
      switch (vt2.type)
	{
	case TermType.TT_Var:
	  cnstr = MQ_Constraint.make_cnstr (Rel.SubsumesObjVar, vt1, vt2);
	  cnstrs_p = MQ_Constraints.make_cnstrs_after (cnstr, cnstrs_p);
	  (cnstrs_p).l_var_list = variables_in_obj (vt1);
	  (cnstrs_p).r_var_list = (vt2).var_list;
//	  return macro.TRUE;
      return cnstrs_p;


	case TermType.TT_Obj:
	  o1 = vt1;
	  o2 = vt2;

	  if (o1.arity == 0){
//	    return a_subsume_p (o1.atom, o2.atom);
            ans = a_subsume_p (o1.atom, o2.atom);
            if(ans==macro.TRUE)
	      return Extern_h.mQ_void_cnstrs;
	    else
              return null;
          }
	  else if (o2.arity == 0)
//	    return macro.FALSE;
	    return null;
	  else
	    {
	      if (a_subsume_p (o1.atom, o2.atom) == macro.FALSE)
//		return macro.FALSE;
		return null;

	      for (i=j=0; i < o1.arity; i++)
		{
		  while (j < o2.arity)
		    if (((MQ_Attr)o1.attr.elementAt(i)).label 
			== ((MQ_Attr)o2.attr.elementAt(j)).label)
		      {
//			if (eval_subsumption (
//					 ((MQ_Attr)o1.attr.elementAt(i)).vterm,
//					 ((MQ_Attr)o2.attr.elementAt(j)).vterm,
//					      cnstrs_p) == macro.FALSE)
			if ((cnstrs_p=eval_subsumption (
					 ((MQ_Attr)o1.attr.elementAt(i)).vterm.vterm,
					 ((MQ_Attr)o2.attr.elementAt(j)).vterm.vterm,
					      cnstrs_p)) == null)



//			  return macro.FALSE;
			  return null;
			else
			  break;
		      }
		    else
		      j++;

		  if (j == o2.arity)
//		    return macro.FALSE;
		    return null;
		}
//	      return macro.TRUE;
	      return cnstrs_p;
	    }
	  
	default:
	  MQ_Error.mq_fatal ("something wrong in eval_subsumption");
//	  return 0;
	  return null;
	}

    default:
      MQ_Error.mq_fatal ("something wrong in eval_subsumption");
//      return 0;
	return null;
    }
  System.out.println("Bad processing...");
//  return 0;
  return null;
}



/*-------------------------------------------------------------------------*/
/* $B%a%=%C%IL>!'(Ba_subsume_p                                                 */
/* $B;EMM!'(Ba_subsume_p (MQ_Atom a1, MQ_Atom a2)                              */
/* $B0z?t!'(BMQ_Atom a1$B!'%"%H%`!#(B                                              */
/*       MQ_Atom a2$B!'%"%H%`!#(B                                              */
/* $B5!G=!'(Bl_bitmap[]$B$rD4$Y$F!"(Ba1>=a2$B$,@.N)$7$F$$$k$+$I$&$+$rD4$Y$k!#(B        */
/* $BLa$jCM!'(Bmacro.TRUE$B!'(Ba1>=a2$B$,@.N)$7$F$$$k>l9g!#(B                          */
/*         macro.FALSE$B!'(Ba1>=a2$B$,@.N)$7$F$$$J$$>l9g!#(B                       */
/*-------------------------------------------------------------------------*/

static int a_subsume_p (MQ_Atom a1, MQ_Atom a2)
{
  if (a1 == a2)
    return macro.TRUE;

  if (a1 == Extern_h.mqA_Top)
    return macro.TRUE;
  if (a2 == Extern_h.mqA_Bottom)
    return macro.TRUE;
  if ((a1.lattice_index < 0) || (a2.lattice_index < 0))
    return macro.FALSE;
  if (l_bitmap[a1.lattice_index*lno+a2.lattice_index])
    return macro.TRUE;
  else
    return macro.FALSE;
}



/*-------------------------------------------------------------------------*/
/* $B%a%=%C%IL>!'(Bvariables_in_obj                                            */
/* $B;EMM!'(Bvariables_in_obj (MQ_VTerm obj)                                     */
/* $B0z?t!'(BMQ_VTerm obj$B!'%*%V%8%'%/%H!#(B                                        */
/* $B5!G=!'(Bobj $B$KJQ?t$,4^$^$l$F$$$l$PJQ?t%j%9%H(B vl $B$K2C$($k!#(B                */
/* $BLa$jCM!'(Bvl$B!':n@.$7$?JQ?t%j%9%H!#(B                                        */
/*-------------------------------------------------------------------------*/

public static MQ_VarList variables_in_obj (MQ_VTerm obj)
{
  vl = null;
  variables_in_vterm (obj);
  return vl;
}



/*-------------------------------------------------------------------------*/
/* $B%a%=%C%IL>!'(Bvariables_in_vterm                                          */
/* $B;EMM!'(Bvariables_in_vterm (MQ_VTerm vterm)                               */
/* $B0z?t!'(BMQ_VTerm vterm$B!'9`!#(B                                              */
/* $B5!G=!'(Bvterm $B$KJQ?t$,4^$^$l$F$$$l$PJQ?t%j%9%H(B vl $B$K2C$($k!#(B              */
/* $BLa$jCM!'$J$7!#(B                                                          */
/*-------------------------------------------------------------------------*/

static void variables_in_vterm (MQ_VTerm vt)
{
  MQ_VTerm o;
  int i;

  switch (vt.type)
    {
    case TermType.TT_Var:
      vl = new MQ_VarList(vt, vl);
      break;
    case TermType.TT_Obj:
      o =  vt;
      for (i=0; i < o.arity; i++)
        variables_in_vterm (((MQ_Attr)o.attr.elementAt(i)).vterm.vterm);
      break;
    default:
      MQ_Error.mq_fatal ("something wrong in variables_in_vterm.");
      break;
    }
}



/*-------------------------------------------------------------------------*/
/* $B%a%=%C%IL>!'(Bbegin_get_atom_which_supersumes                             */
/* $B;EMM!'(Bbegin_get_atom_which_supersumes (MQ_Atom a)                       */
/* $B0z?t!'(BMQ_Atom a$B!'%"%H%`!#(B                                               */
/* $B5!G=!'(By $B$K(B a $B$N(B lattice_index $B$NCM$rBeF~!#(B                              */
/*       y<0 $B$J$i(B lno$B!"$=$&$G$J$1$l$P(B 0 $B$r(B x $B$KBeF~!#(B                      */
/* $BLa$jCM!'$J$7!#(B                                                          */
/*-------------------------------------------------------------------------*/

static void begin_get_atom_which_supersumes (MQ_Atom a)
{
  y = a.lattice_index;
  if (y < 0)
    x = lno;
  else
    x = 0;
}



/*-------------------------------------------------------------------------*/
/* $B%a%=%C%IL>!'(Bget_next_atom_supersump                                     */
/* $B;EMM!'(Bget_next_atom_supersump ()                                        */
/* $B0z?t!'(BMQ_Atom a$B!'%"%H%`!#(B                                               */
/* $B5!G=!'(Ba $B$KJq@]$5$l$k%"%H%`$r(B l_bitmap[] $B$+$iC5$9!#(B                      */
/* $BLa$jCM!'(Blattice[]$B!'(Ba $B$KJq@]$5$l$k%"%H%`!#(B                               */
/*         null$B!'(B a $B$KJq@]$5$l$k%"%H%`$,B8:_$7$J$$>l9g!#(B                   */
/*-------------------------------------------------------------------------*/

static MQ_Atom get_next_atom_supersump ()
{
  while (x < lno)
    if (l_bitmap[y*lno+x] && x != y)
      return lattice[x++];
    else
      x++;
  return null;
}



/*-------------------------------------------------------------------------*/
/* $B%a%=%C%IL>!'(Bbegin_get_atom_which_subsumes                               */
/* $B;EMM!'(Bbegin_get_atom_which_subsumes (MQ_Atom a)                         */
/* $B0z?t!'(BMQ_Atom a$B!'%"%H%`!#(B                                               */
/* $B5!G=!'(By $B$K(B a $B$N(B lattice_index $B$NCM$rBeF~!#(B                              */
/*       y<0 $B$J$i(B lno$B!"$=$&$G$J$1$l$P(B 0 $B$r(B x $B$KBeF~!#(B                      */
/* $BLa$jCM!'$J$7!#(B                                                          */
/*-------------------------------------------------------------------------*/

static void begin_get_atom_which_subsumes (MQ_Atom a)
{
  y = a.lattice_index;
  if (y < 0)
    x = lno;
  else
    x = 0;
}



/*-------------------------------------------------------------------------*/
/* $B%a%=%C%IL>!'(Bget_next_atom_subsump                                       */
/* $B;EMM!'(Bget_next_atom_subsump ()                                          */
/* $B0z?t!'(BMQ_Atom a$B!'%"%H%`!#(B                                               */
/* $B5!G=!'(Ba $B$rJq@]$9$k%"%H%`$r(B l_bitmap[] $B$+$iC5$9!#(B                        */
/* $BLa$jCM!'(Blattice[]$B!'(Ba $B$rJq@]$9$k%"%H%`!#(B                                 */
/*         null$B!'(B a $B$rJq@]$9$k%"%H%`$,B8:_$7$J$$>l9g!#(B                     */
/*-------------------------------------------------------------------------*/

public static MQ_Atom get_next_atom_subsump ()
{
  while (x < lno)
    if ((l_bitmap[x*lno+y]==true) && x != y)
      return lattice[x++];
    else
      x++;
  return null;
}

static String lattice_first_obj;
static MQ_Atom[] lattice;
static boolean[] l_bitmap;     /* well, it is not bitmap, actually... ;-) */
static int lno;
static MQ_AtomAtomSet aas_begin;
static int x, y;
static MQ_VarList vl;


}
