/* Copyright (C) 1998 Kazumasa Yokota */
/*                                    */
package java_qxt;
import java.lang.*;
import java.awt.*;

public class MQ_print  {

static
void print_atom (MQ_Atom atom)
{
  int quote = 0;
  String name;
  char c[];
  int i=0;

  c = new char[1];
  if ((name = atom.name) != null)//??????????
    {
      if ( Character.isDigit(name.charAt(i)) || Character.isLowerCase(name.charAt(i))
           || name.charAt(i) == '&' || name.charAt(i) >= 0x80){
       for ( ;i<name.length();i++ )
	  {
	    if ( !(  Character.isUpperCase(name.charAt(i))
                  || Character.isLowerCase(name.charAt(i))
		  || Character.isDigit(name.charAt(i))
		  || name.charAt(i) == '_' || name.charAt(i) >= 0x80))
	      {
		quote = 1;
		break;
	      }
	  }
      }
      else
	quote = 1;

      if (quote!=0){
	    Fquik.messagePrint ("\"+atom.name+\"");
      }
      else 
      {
        Fquik.messagePrint (atom.name);
      }
    }
  else
    {
      Fquik.messagePrint ("&nil");
    }
}

static void print_atom_lattice (MQ_Atom atom)
{
  int quote = 0;
  String name;
  char c[];
  int i=0;

  c = new char[1];
  if ((name = atom.name) != null)//??????????
    {
      if ( Character.isDigit(name.charAt(i)) || Character.isLowerCase(name.charAt(i))
           || name.charAt(i) == '&' || name.charAt(i) >= 0x80){
       for ( ;i<name.length();i++ )
	  {
	    if ( !(  Character.isUpperCase(name.charAt(i))
                  || Character.isLowerCase(name.charAt(i))
		  || Character.isDigit(name.charAt(i))
		  || name.charAt(i) == '_' || name.charAt(i) >= 0x80))
	      {
		quote = 1;
		break;
	      }
	  }
      }
      else
	quote = 1;

      if (quote!=0){
	    Fquik.messageLattice ("\"+atom.name+\"");
      }
      else 
      {
        Fquik.messageLattice (atom.name);
      }
    }
  else
    {
      Fquik.messageLattice ("&nil");
    }
}

static void print_name_var ( MQ_VTerm name_var)
{
  if (name_var.number != 0){
    Fquik.messagePrint ("_V"+ name_var.number);
  }
  else
    Fquik.messagePrint (name_var.name);
}


static void print_obj (MQ_VTerm obj)
{
  int i;

  print_atom (obj.atom);
  if (obj.arity!=0)
    {
      Fquik.messagePrint ("[");
      i = 0;
      while (true)
	{
	  print_atom (((MQ_Attr)obj.attr.elementAt(i)).label);
	  Fquik.messagePrint ("=");
	  print_vterm (((MQ_Attr)obj.attr.elementAt(i)).vterm.vterm);
	  if (++i >= obj.arity)
	    break;
	  Fquik.messagePrint (",");
	}
      Fquik.messagePrint("]");
    }
}

static void print_var (MQ_VTerm var)
{
  MQ_VTerm name_var;

  if (var.value.vterm != null)
    {
      print_vterm (var.value.vterm);
      return;
    }

  name_var = MQ_VTerm.make_name_var (++var_number, null);
  Unify.bind (var, name_var);
  print_name_var (name_var);
}

static void print_vterm (MQ_VTerm vterm)
{
  switch (vterm.type)
    {
    case TermType.TT_Obj:
      print_obj ( vterm);
      break;
    case TermType.TT_Var:
      print_var ( vterm);
      break;
    case TermType.TT_NameVar:
      print_name_var ( vterm);
      break;
    default:
      MQ_Error.mq_fatal ("something wrong in print_vterm\n");
      break;
    }
}

static void print_term (MQ_VTerm vterm)
{
  switch (vterm.type)
    {
    case TermType.TT_NameVar:
      print_name_var (vterm);
      break;
    case TermType.TT_Obj:
      print_obj (vterm);
      break;
    case TermType.TT_Var:
      print_var (vterm);
      break;
    case TermType.TT_Dot:
      print_dot (vterm);
      break;
    default:
      MQ_Error.mq_fatal ("print_term\n");
      break;
    }
}

static void print_dot (MQ_VTerm dot)
{
  print_vterm (dot.vterm.vterm);
  Fquik.messagePrint (".");
  print_atom (dot.label);
}

static void print_vterm_list (MQ_VTermList vtl)
{
  if (vtl == null)
    return;
  print_vterm_list (vtl.next);
  if (vtl.next!=null)
    Fquik.messagePrint (", ");
  print_vterm (vtl.vterm.vterm);
}

static void print_constraint (MQ_Constraint cnstr)
{
  switch (cnstr.rel)
    {
    case Rel.Subsumes:
    case Rel.SubsumesVarVar:
    case Rel.SubsumesVarObj:
    case Rel.SubsumesObjVar:
      print_term (cnstr.term.vterm);
      Fquik.messagePrint (">=");
      print_vterm (cnstr.vterm.vterm);
      break;

    case Rel.DotCongruent:
    case Rel.DotCongruentVar:
    case Rel.DotCongruentObj:
    case Rel.Congruent:
      print_term (cnstr.term.vterm);
      Fquik.messagePrint ("==");
      print_vterm (cnstr.vterm.vterm);
      break;

    case Rel.ExternalCnstr:
      print_vterm (((MQ_Attr)(cnstr.vterm.vterm).attr.elementAt(0)).vterm.vterm);
      Fquik.messagePrint ("#"+(cnstr.vterm.vterm).atom.name+"#");
      print_vterm (((MQ_Attr)(cnstr.vterm.vterm).attr.elementAt(1)).vterm.vterm);
      break;

    case Rel.ExternalExpr:
      print_term (cnstr.term.vterm);
      Fquik.messagePrint ("##");
      print_vterm (cnstr.vterm.vterm);
      break;

    default:
      MQ_Error.mq_fatal ("print_constraint\n");
      break;
    }
}

static void print_constraints_internal (MQ_Constraints cnstrs)
{
  if (cnstrs == Extern_h.mQ_void_cnstrs)
    return;
  print_constraints_internal (cnstrs.next);
  if (cnstrs.next != Extern_h.mQ_void_cnstrs)
    Fquik.messagePrint (", ");

  print_constraint (cnstrs.cnstr);
}

void print_constraints (MQ_Constraints cnstrs,int condition)
{
  String exec_obj;

  if (cnstrs == Extern_h.mQ_void_cnstrs)
    return;

  var_number = 0;
  up_print = Extern_h.up;

  if (condition !=0)
    Fquik.messagePrint (" if ");
  Fquik.messagePrint ("{ ");
  print_constraints_internal (cnstrs);
  Fquik.messagePrint (" }");
  Unify.unwind_variables (up_print);
}

/* Don't follow rule.next, it is chain for another purpose. */
static
void print_rule (MQ_Rule rule)
{
  MQ_VarList vl;

  for (vl=rule.var_list; vl!=null; vl = vl.next)
    vl.var.vterm_addr_list = null;
  print_vterm (rule.head.vterm);
  if (rule.head_cnstrs != Extern_h.mQ_void_cnstrs)
    {
      Fquik.messagePrint (" | { ");
      print_constraints_internal (rule.head_cnstrs);
      Fquik.messagePrint (" }");
    }

  if (rule.body!=null)
    {
      Fquik.messagePrint (" <= ");
      print_vterm_list (rule.body);

      if (rule.body_cnstrs != Extern_h.mQ_void_cnstrs)
	{
	  Fquik.messagePrint (" || { ");
	  print_constraints_internal (rule.body_cnstrs);
	  Fquik.messagePrint (" }");
	}
    }

  Fquik.messagePrint (";;\n");
}

static void print_all_subrel_sub (MQ_SubRel sl)
{
  if (sl == null)
    return;
  print_all_subrel_sub (sl.next);
  print_atom (sl.a1);
  Fquik.messagePrint (" >= ");
  print_atom (sl.a2);
  Fquik.messagePrint (";;\n");
}

static void print_all_subrel_sub_lattice (MQ_SubRel sl)
{
  if (sl == null)
    return;
  print_all_subrel_sub_lattice (sl.next);
  print_atom_lattice (sl.a1);
  Fquik.messageLattice (" >= ");
  print_atom_lattice (sl.a2);
  Fquik.messageLattice ("\n");
}

static void print_all_subrel ()
{
  print_all_subrel_sub (MQ_SubRel.subrel_list);
}

static void print_all_subrel_lattice ()
{
  print_all_subrel_sub_lattice (MQ_SubRel.subrel_list);
}

static void print_all_rules_sub (MQ_RuleList rl)
{
  while (rl!=null/*Extern_h.mQ_void_rule_list*/)
    {
      print_rule (rl.rule);
      rl = rl.next;
    }
}

static void print_all_rules ()
{

  up_print = Extern_h.up;
  var_number = 0;
  print_all_rules_sub (Extern_h.rule_list.next);
  Unify.unwind_variables (up_print);
}

static void print_var_name_list (MQ_VarNameList vnl)
{
  if (vnl == null)
    return;

  print_var_name_list (vnl.next);
  if (vnl.next!=null)
    Fquik.messagePrint (", ");

  print_name_var (vnl.name_var);
  Fquik.messagePrint (" = ");

  switch (vnl.vterm.vterm.type)
    {
    case TermType.TT_Obj:
      print_obj (vnl.vterm.vterm);
      break;

    case TermType.TT_NameVar:
      if (vnl.name_var == vnl.vterm.vterm)
	Fquik.messagePrint ("Unbound");
      else
	print_name_var (vnl.vterm.vterm);
      break;

    case TermType.TT_Var:
    default:
      MQ_Error.mq_fatal ("something wrong in print_name_var_list\n");
      break;
    }
}

static void print_answer (MQ_Query query)
{
  MQ_VarNameList vnl;

  up_print = Extern_h.up;
  var_number = 0;

  for (vnl=query.var_name_list; vnl!=null; vnl=vnl.next)
    if (vnl.vterm.vterm.type == TermType.TT_Var)
      {
	MQ_VTerm v;

	v = vnl.vterm.vterm;
	Unify.bind (v, vnl.name_var);
      }

  print_var_name_list (query.var_name_list);
  if (Extern_h.cnstrs_asmpts.dot_cnstrs != Extern_h.mQ_void_cnstrs
      || Extern_h.cnstrs_asmpts.sub_cnstrs != Extern_h.mQ_void_cnstrs
      || Extern_h.cnstrs_asmpts.ext_cnstrs != Extern_h.mQ_void_cnstrs)
    {

      Fquik.messagePrint (" { ");
      print_constraints_internal (Extern_h.cnstrs_asmpts.dot_cnstrs);
      if (Extern_h.cnstrs_asmpts.dot_cnstrs != Extern_h.mQ_void_cnstrs
	  && (Extern_h.cnstrs_asmpts.sub_cnstrs != Extern_h.mQ_void_cnstrs
	      || Extern_h.cnstrs_asmpts.ext_cnstrs != Extern_h.mQ_void_cnstrs))
	Fquik.messagePrint (", ");
      print_constraints_internal (Extern_h.cnstrs_asmpts.sub_cnstrs);


      if (Extern_h.cnstrs_asmpts.sub_cnstrs != Extern_h.mQ_void_cnstrs
	  && Extern_h.cnstrs_asmpts.ext_cnstrs != Extern_h.mQ_void_cnstrs)
	Fquik.messagePrint (", ");
      print_constraints_internal (Extern_h.cnstrs_asmpts.ext_cnstrs);
      Fquik.messagePrint (" }");
    }
  if (Extern_h.cnstrs_asmpts.dot_asmpts != Extern_h.mQ_void_cnstrs
      || Extern_h.cnstrs_asmpts.sub_asmpts != Extern_h.mQ_void_cnstrs
      || Extern_h.cnstrs_asmpts.ext_asmpts != Extern_h.mQ_void_cnstrs)
    {
      Fquik.messagePrint (" if { ");
      print_constraints_internal (Extern_h.cnstrs_asmpts.dot_asmpts);
      if (Extern_h.cnstrs_asmpts.dot_asmpts != Extern_h.mQ_void_cnstrs
	  && (Extern_h.cnstrs_asmpts.sub_asmpts != Extern_h.mQ_void_cnstrs
	      || Extern_h.cnstrs_asmpts.ext_asmpts != Extern_h.mQ_void_cnstrs))
	Fquik.messagePrint (", ");
      print_constraints_internal (Extern_h.cnstrs_asmpts.sub_asmpts);
      if (Extern_h.cnstrs_asmpts.sub_asmpts != Extern_h.mQ_void_cnstrs
	  && Extern_h.cnstrs_asmpts.ext_asmpts != Extern_h.mQ_void_cnstrs)
	Fquik.messagePrint (", ");
      print_constraints_internal (Extern_h.cnstrs_asmpts.ext_asmpts);
      Fquik.messagePrint (" }");
    }
  Fquik.messagePrint ("\n");
  Unify.unwind_variables (up_print);
}

static void print_goal (MQ_Goal g)
{
  MQ_Goal sg;

  var_number = 0;
  up_print = Extern_h.up;
  if (g.goal_vterm.vterm != null)
    print_vterm (g.goal_vterm.vterm);
  else
    Fquik.messagePrint ("()\n");
  if (g.head_cnstrs != Extern_h.mQ_void_cnstrs)
    {
      Fquik.messagePrint (" |{");
      print_constraints_internal (g.head_cnstrs);
      Fquik.messagePrint ("}");
    }
  sg = g.subgoal;
  if (sg!=null)
    {
      Fquik.messagePrint (" <= ");
      while (true)
	{
	  print_vterm (sg.goal_vterm.vterm);
	  sg = sg.next;
	  if (sg == null)
	    break;
	  Fquik.messagePrint (", ");
	}
    }

  if (g.body_cnstrs != Extern_h.mQ_void_cnstrs)
    {
      Fquik.messagePrint ("||{");
      print_constraints_internal (g.body_cnstrs);
      Fquik.messagePrint ("}");
    }
  Fquik.messagePrint (";;\n");
  Unify.unwind_variables (up_print);
}

static int var_number = 0;
static UnwindProtect up_print;


}
