/* Copyright (C) 1998 Kazumasa Yokota */
/*                                    */
package java_qxt;
import java.util.*;
//import 
//$B6&MQBN(B
public class MQ_VTerm {

	public MQ_VTerm(){}
	//$B#2=E%]%$%s%?$r<B8=$9$k$?$a$N%/%i%9(BMQ_PP$B$r:n$C$?(B

	public static MQ_VTerm make_MQ_Var(){
		MQ_VTerm var;
		var = new MQ_VTerm();
		var.type = TermType.TT_Var;
		var.value = new MQ_PP();
		var.vterm_addr_list = null;
		var.var_list = null;
		return var;
	}

	public static MQ_VTerm make_MQ_Term(){
		MQ_VTerm term;
		term = new MQ_VTerm();
		return term;
	}

	public static MQ_VTerm make_MQ_Dot(MQ_Atom label){
		MQ_VTerm dot;
		dot = new MQ_VTerm();
		dot.type = TermType.TT_Dot;
		dot.vterm = new MQ_PP();
		dot.label = label;
		return dot;
	}

	public static MQ_VTerm make_MQ_Obj(){
		MQ_VTerm obj;
		obj = new MQ_VTerm();
		obj.attr = new Vector();
		return obj;
	}

	public static MQ_VTerm make_object(MQ_Atom atom,int arity)
	{
		MQ_Attr att;
		MQ_VTerm new_obj;
		int i;

		new_obj = MQ_VTerm.make_MQ_Obj();
		new_obj.type = TermType.TT_Obj;
		new_obj.atom = atom;
		new_obj.arity = arity;
		for (i=0; i < arity; i++)
		{
			att = new MQ_Attr();
			new_obj.attr.addElement(att);
		}
		return new_obj;
	}

	public static MQ_VTerm make_MQ_NameVar()
	{
		MQ_VTerm namevar;
		namevar = new MQ_VTerm();
		return namevar;
	}

	public static MQ_VTerm make_name_var (int number,String string)
	{
  		MQ_VTerm new_obj;

		if (number!=0)
			new_obj = MQ_VTerm.make_MQ_NameVar();
		else
		{
			if (string == null)
				MQ_Error.mq_fatal ("don't give me null in make_name_var");

			new_obj = MQ_VTerm.make_MQ_NameVar();
			new_obj.name = string;
		}
		new_obj.type = TermType.TT_NameVar;
		new_obj.number = number;
		return new_obj;
	}

	public int type;

	// MQ_Obj
	public MQ_Atom atom;
	public int arity;
	public Vector  attr;//MQ_Attr$B$NMWAG$r3JG<(B

	// MQ_Var
	public MQ_PP          value;    /* this helps me debug :-) */
	public MQ_VTermAddrList  vterm_addr_list;
	public MQ_VarList        var_list;

	// MQ_Dot
	//$B#2=E%]%$%s%?$r<B8=$9$k$?$a$N%/%i%9(BMQ_PP$B$r:n$C$?!#(B
	public MQ_PP  vterm;
	public MQ_Atom   label;

	// MQ_NameVar
	public int number;
	public String name;
}
