/* Copyright (C) 1998 Kazumasa Yokota */
/*                                    */
package java_qxt;


public class MQ_SubRel {

public MQ_SubRel (MQ_Atom a1,MQ_Atom a2,MQ_SubRel next)
//make_subrel$B$KBP1~(B
{
  this.a1 = a1;
  this.a2 = a2;
  this.next = next;
}

static void emit_subrel (int op,MQ_Atom a1,MQ_Atom a2)
{
  switch (op)
    {
    case Rel.Subsumes:
      if (check_subrel (a1, a2, subrel_list) == macro.SUCCESS)
	subrel_list = new MQ_SubRel (a1, a2, subrel_list);
      break;
    case Rel.Supersumes:
      if (check_subrel (a2, a1, subrel_list) == macro.SUCCESS)
	subrel_list = new MQ_SubRel(a2, a1, subrel_list);
      break;
    default:
      MQ_Error.mq_error("valid operators for subsumption relation are >= or =<.");
      break;
    }
}

static int check_subrel (MQ_Atom a1,MQ_Atom a2,MQ_SubRel subrel_list)
{
  MQ_SubRel sl;

  for (sl=subrel_list; sl != null ; sl=sl.next)
    if ((sl.a1 == a1) && (sl.a2 == a2))
      {
	MQ_Error.mq_error("subsumption already exists. (ignored)");
	return macro.FAILURE;
      }
    else if ((sl.a1 == a2) && (sl.a2 == a1))
      {
	MQ_Error.mq_error("contradiction in subsumption(s). (ignored).");
	return macro.FAILURE;
      }

  return macro.SUCCESS;
}
  
public MQ_SubRel  next;
public MQ_Atom    a1,a2;

public static MQ_SubRel subrel_list;

}
