/* Copyright (C) 1998 Kazumasa Yokota */
/*                                    */
package java_qxt;
import java_cup.runtime.*;


public class MQ_Atom extends token {

  public MQ_Atom(int term_num)
    {
      super(term_num);
    }

  public static MQ_Atom make_ATOM(String string,int term_num)
    {
      MQ_Atom new_obj,p;

      new_obj = new MQ_Atom(term_num);
      new_obj.name = string;
      new_obj.next_bucket = null;
      new_obj.rule_list   = null;
      new_obj.lattice_index = -1;

      for (p = atom_pool; p!=null ; p = p.next_bucket)
	if (string.equals(p.name))  //$BEy$7$$(B
	  return p;                   //$B%W!<%k$K$D$J$,$J$$(B
      
      new_obj.next_bucket = atom_pool;//$B%W!<%k$K$D$J$0(B
      atom_pool = new_obj;
      return new_obj;
    }
  
  public static MQ_Atom system_atom (String string)
{
  MQ_Atom new_atom;
  new_atom = make_ATOM(string,sym_num.ATOM);
  new_atom.lattice_index = -2;
  return new_atom;
}

public static MQ_Atom make_atom (String string)
{
  MQ_Atom new_obj;

  if (string == null)
    MQ_Error.mq_fatal ("don't give me null in make_atom");

  new_obj = new MQ_Atom(sym_num.ATOM);
  new_obj.next_bucket = null;
  new_obj.rule_list = null;
  new_obj.lattice_index = -1;
  new_obj.name = string;
  return new_obj;
}

public static MQ_Atom intern_atom(String str)
{
  MQ_Atom p, new_obj;
//  int val;

//  val = hash (string);
  for (p = atom_pool; p!=null; p = p.next_bucket)
    if (str.equals(p.name))
      return p;

  new_obj = make_atom (str);
  new_obj.next_bucket = atom_pool;
  atom_pool = new_obj;
  return new_obj;

}

  
  public MQ_Atom      next_bucket;
  public MQ_RuleList  rule_list;
  public int          lattice_index;
  public String       name;

  public static MQ_Atom atom_pool;
}
