/* Copyright (C) 1998 Kazumasa Yokota */
/*                                    */
package java_qxt;

public class Lookup {


void init_lookup ()
{
  ;
}

void free_lookup ()
{
  ;
}

static int lookup_active_goals (MQ_Goal g)
{
  MQ_Lookup l_this;
  MQ_VTermList body;
  MQ_Goal g1;
  int entry =0;//default$BCM$K8GDj(B

  if (Commands.mq_opt_lookup==0)
    return macro.FALSE;

  var_list = null;
  var_number = 0;
  vterm_list_orig = vterm_list_tangled = null;
  l_this = new MQ_Lookup();

  l_this.head.vterm = lookup_tangle_vterm (g.goal_vterm.vterm);
  l_this.head_cnstrs = lookup_tangle_constraints (g.head_cnstrs);
  body = null;
  for (g1=g.subgoal; g1!=null; g1 = g1.next)
    {
      body = new MQ_VTermList (body);
      body.vterm.vterm = lookup_tangle_vterm (g1.goal_vterm.vterm);
    }
  l_this.body = body;
  l_this.body_cnstrs = lookup_tangle_constraints (g.body_cnstrs);
  while (var_list!=null)
    {
      var_list.var.value.vterm = null;
      var_list = var_list.next;
    }

  l_this.entry = entry;
  g.lookup = l_this;//entry$B%U%#!<%k%I$O;H$o$J$$(B

  for (g1=g.parent; g1!=null; g1 = g1.parent)
    if (/* g1.lookup.entry == entry
	&& */ g.type == g1.type
	&& compare_lookup (l_this, g1.lookup) == macro.TRUE)
      {
	g.lookup = null;
	return macro.TRUE;
      }

  return macro.FALSE;
}

static MQ_VTerm lookup_tangle_var (MQ_VTerm var)
{
  MQ_VTerm nv;

  if (var.value.vterm!=null)
    return var.value.vterm;

  nv = MQ_VTerm.make_name_var (++var_number, null);
  var.value.vterm = nv;
  var_list = new MQ_VarList(var, var_list);
  return nv;
}

static MQ_VTerm lookup_tangle_obj (MQ_VTerm obj)
{
  MQ_VTerm new_obj;
  int i, arity;
  MQ_VTermList vlo, vlt;
  MQ_VTerm vt;

  vt = obj;
  for (vlo=vterm_list_orig, vlt=vterm_list_tangled;
       vlo!=null;
       vlo=vlo.next, vlt=vlt.next)
    if (vlo.vterm.vterm == vt)
      return vlt.vterm.vterm;

  vterm_list_orig = new MQ_VTermList (vterm_list_orig);
  vterm_list_orig.vterm.vterm = vt;
  vterm_list_tangled = new MQ_VTermList (vterm_list_tangled);

  arity = obj.arity;
  new_obj = MQ_VTerm.make_object (obj.atom, arity);

  vterm_list_tangled.vterm.vterm = new_obj;
  for (i=0; i < arity; i++)
    {
      ((MQ_Attr)new_obj.attr.elementAt(i)).label 
       = ((MQ_Attr)obj.attr.elementAt(i)).label;
      ((MQ_Attr)new_obj.attr.elementAt(i)).vterm.vterm
	= lookup_tangle_vterm (((MQ_Attr)obj.attr.elementAt(i)).vterm.vterm);
    }
  return new_obj;
}

static MQ_VTerm lookup_tangle_dot (MQ_VTerm dot)
{
  MQ_VTerm new_obj;

  new_obj = MQ_VTerm.make_MQ_Dot (dot.label);
  new_obj.vterm.vterm = lookup_tangle_vterm (dot.vterm.vterm);
  return new_obj;
}

static MQ_VTerm lookup_tangle_vterm (MQ_VTerm vterm)
{
  MQ_VTerm new_obj;

  switch (vterm.type)
    {
    case TermType.TT_NameVar:
      new_obj = vterm;
      break;
    case TermType.TT_Var:
      new_obj = lookup_tangle_var (vterm);
      break;
    case TermType.TT_Obj:
      new_obj =  lookup_tangle_obj (vterm);
      break;
    default:
      MQ_Error.mq_fatal ("something wrong in lookup_tangle_vterm");
      new_obj = null;
      break;
    }

  return new_obj;
}

static MQ_VTerm lookup_tangle_term (MQ_VTerm vterm)
{
  MQ_VTerm new_obj;

  switch (vterm.type)
    {
    case TermType.TT_NameVar:
      new_obj = vterm;
      break;
    case TermType.TT_Var:
      new_obj =  lookup_tangle_var (vterm);
      break;
    case TermType.TT_Obj:
      new_obj =  lookup_tangle_obj (vterm);
      break;
    case TermType.TT_Dot:
      new_obj =  lookup_tangle_dot (vterm);
      break;
    default:
      MQ_Error.mq_fatal ("something wrong in lookup_tangle_term");
      new_obj = null;
      break;
    }
  return new_obj;
}

static MQ_Constraint lookup_tangle_constraint (MQ_Constraint cnstr)
{
  MQ_Constraint new_obj;

  new_obj = MQ_Constraint.make_cnstr (cnstr.rel, null, null);
  new_obj.term.vterm = lookup_tangle_term (cnstr.term.vterm);
  new_obj.vterm.vterm = lookup_tangle_vterm (cnstr.vterm.vterm);
  return new_obj;
}

static MQ_Constraints lookup_tangle_constraints (MQ_Constraints cnstrs)
{
  MQ_Constraints new_obj, next;
  MQ_Constraint cnstr;

  if (cnstrs == null)
    MQ_Error.mq_fatal ("something wrong in lookup_tangle_constraints");

  if (cnstrs == Extern_h.mQ_void_cnstrs)
    return Extern_h.mQ_void_cnstrs;

  next = lookup_tangle_constraints (cnstrs.next);
  cnstr = lookup_tangle_constraint (cnstrs.cnstr);
  new_obj = MQ_Constraints.make_cnstrs_after (cnstr, next);
  return new_obj;
}

static int compare_vterm (MQ_VTerm vt1, MQ_VTerm vt2)
{
  MQ_VTerm o1, o2;
  MQ_VTerm n1, n2;
  int i;

  if (vt1 == vt2)
    return macro.TRUE;

  if ((vt1.type == TermType.TT_Var) || (vt2.type == TermType.TT_Var))
    MQ_Error.mq_fatal ("lookup: variable in the structure.");

  if ((vt1.type == TermType.TT_NameVar) && (vt2.type == TermType.TT_NameVar))
    {
      n1 =  vt1;
      n2 =  vt2;
      if (n1.number == n2.number)
	return macro.TRUE;
      else
	return macro.FALSE;
    }

  if ((vt1.type == TermType.TT_Obj) && (vt2.type == TermType.TT_Obj))
    {
      o1 = vt1;
      o2 = vt2;
      if ((o1.atom != o2.atom) || (o1.arity != o2.arity))
	return macro.FALSE;

      for (i=0; i < o1.arity; i++)
	if (((MQ_Attr)o1.attr.elementAt(i)).label 
	    != ((MQ_Attr)o2.attr.elementAt(i)).label)
	  return macro.FALSE;

      for (i=0; i < o1.arity; i++)
	if (compare_vterm ( ((MQ_Attr)o1.attr.elementAt(i)).vterm.vterm,
             	 ((MQ_Attr)o2.attr.elementAt(i)).vterm.vterm) == macro.FALSE)
	  return macro.FALSE;

      return macro.TRUE;
    }
  return macro.FALSE;
}

static int compare_vterm_list (MQ_VTermList vl1, MQ_VTermList vl2)
{
  while (vl1!=null)
    {
      if (vl2 == null)
	return macro.FALSE;
      if (compare_vterm (vl1.vterm.vterm, vl2.vterm.vterm) == macro.FALSE)
	return macro.FALSE;
      vl1 = vl1.next;
      vl2 = vl2.next;
    }
  if (vl2 == null)
    return macro.TRUE;
  else
    return macro.FALSE;
}

static int compare_dot (MQ_VTerm d1, MQ_VTerm d2)
{
  if (d1.label != d2.label)
    return macro.FALSE;
  return compare_vterm (d1.vterm.vterm, d2.vterm.vterm);
}

static int compare_term (MQ_VTerm t1, MQ_VTerm t2)
{
  if (t1.type == TermType.TT_Dot)
    if (t2.type == TermType.TT_Dot)
      return compare_dot (t1, t2);
    else
      return macro.FALSE;

  if (t2.type == TermType.TT_Dot)
      return macro.FALSE;

  return compare_vterm (t1, t2);
}

static int compare_cnstr (MQ_Constraint cnstr1, MQ_Constraint cnstr2)
{
  if (cnstr1.rel != cnstr2.rel)
    return macro.FALSE;
  if (compare_term (cnstr1.term.vterm, cnstr2.term.vterm) == macro.FALSE)
    return macro.FALSE;
  if (compare_vterm (cnstr1.vterm.vterm, cnstr2.vterm.vterm) == macro.FALSE)
    return macro.FALSE;
  return macro.TRUE;
}

static int compare_cnstrs (MQ_Constraints cnstrs1, MQ_Constraints cnstrs2)
{
  while (cnstrs1 != Extern_h.mQ_void_cnstrs)
    {
      if (cnstrs2 == Extern_h.mQ_void_cnstrs)
	return macro.FALSE;
      if (compare_cnstr (cnstrs1.cnstr, cnstrs2.cnstr) == macro.FALSE)
	return macro.FALSE;
      cnstrs1 = cnstrs1.next;
      cnstrs2 = cnstrs2.next;
    }
  if (cnstrs2 == Extern_h.mQ_void_cnstrs)
    return macro.TRUE;
  else
    return macro.FALSE;
}

static int compare_lookup (MQ_Lookup l1, MQ_Lookup l2)
{
  if ((compare_vterm (l1.head.vterm, l2.head.vterm)!=0)
      && (compare_vterm_list (l1.body, l2.body)!=0)
      && (compare_cnstrs (l1.head_cnstrs, l2.head_cnstrs)!=0)
      && (compare_cnstrs (l1.body_cnstrs, l2.body_cnstrs)!=0) )
    return macro.TRUE;

  return macro.FALSE;
}

public int entry;
public MQ_VTerm head;
public MQ_VTermList body;
public MQ_Constraints head_cnstrs, body_cnstrs;

static int var_number;
static MQ_VarList var_list;
static MQ_VTermList vterm_list_orig, vterm_list_tangled;



}
