/* Copyright (C) 1998 Kazumasa Yokota */
/*                                    */
package java_qxt;

import java.io.*;
import java_cup.runtime.*;

public class FileList {

  public FileList(String filename)
    {
      this.in_stream = null;
      this.next = file_list;
      this.filename = filename;
      file_list = this;
    }
  
  public static void init_scanner()
    {
loop:      while(true){
	if (file_list == null) {
	  in_stream = System.in;
	  scanner_obj = new scanner(in_stream);
	  FileList.init_interactive (1);
	  return;
	}
	else{
	  if (file_list.filename.equals("-debug"))
	    {
	      file_list = file_list.next;
	      continue loop;
	    }
	  try{
	    in_stream = new FileInputStream(file_list.filename);
	    scanner_obj = new scanner(in_stream);
	    file_list = file_list.next;
	    return;
	  }catch (Exception e) {
	    System.out.println("I am FileList.java L36"+e);
	  }
	}
      }
    }
  
  public static void init_scanner_2(String file)
    {
       try{
	   in_stream = new FileInputStream(file);
	   scanner_obj = new scanner(in_stream);
           return;
	  }catch (Exception e) {
	    System.out.println("I am FileList.java L36"+e);
	  }
       
    }
  
  public static token next_token() 
    {
      token next_token;

      while (true){   
	try{  
	  next_token = scanner_obj.get_next_token();

	  if (next_token.sym != sym_num.EOF) 
	    {
     //	      System.out.println(next_token.sym);
     //	      System.out.println("Mode is " + Extern_h.mq_mode);
	      return next_token;
	    }
          else
            {
              return next_token;
	    }


  //  $B0J2<$NItJ,$,%U%!%$%kF~NO$N>l9g$OI,MW$,$J$$!%(B
  /*	  if (in_stream == System.in)
	    {
     //	      System.out.println("I throw a EOF");
	      return next_token;
	    }
	    
	  //$B?7$7$$%U%!%$%k$N(Bscanner$B%*%V%8%'%/%H$r:n$j!"$=$l$K@Z$jBX$($k(B
	  if ((file_list != null)&&(file_list.filename.equals("-debug")))
	    file_list = file_list.next;
	  if (file_list == null) {
	    in_stream = System.in;
	    scanner_obj = new scanner(in_stream);
	    FileList.init_interactive (1);
	    FileList.output_prompt ();
	    System.out.println("standerd input");
	    System.out.println("interactive ="+Extern_h.interactive);
	  }
	  else { 
	    in_stream = new FileInputStream(file_list.filename);
	    scanner_obj = new scanner(in_stream);
	    file_list = file_list.next;
	  } */
	}catch (IOException e) {
	  System.out.println("I am FileList L71"+e);
	}
      }
    }
  
static void output_prompt ()
{
  if (Extern_h.interactive==0)
    return;

  if (Extern_h.last_char_is_newline > 4)
    {
      help ();
      Extern_h.last_char_is_newline =1;
    }

  switch (Extern_h.mq_mode)
    {
    case macro.MODE_COMMAND:
      System.out.print ("&> ");
      System.out.flush();break;

    case macro.MODE_PROGRAM:
      System.out.print ("&s,r> ");
      System.out.flush();break;

    case macro.MODE_PROGRAM_SUBSUMPTION:
      System.out.print ("subsumption> ");
      System.out.flush();break;

    case macro.MODE_PROGRAM_RULE:
      System.out.print ("rule> ");
      System.out.flush();break;

    case macro.MODE_QUERY:
      System.out.print ("?- ");
      System.out.flush();break;

    case macro.PS_EXPECT_TERM:
      System.out.print (";;> ");
      System.out.flush();break;

    case macro.PS_EXPECT_PRD:
    case macro.PS_EXPECT_Q_PRD:
      System.out.print (".> ");
      System.out.flush();break;

    default:
      MQ_Error.mq_fatal ("wrong parser state\n");
      break;
    }
}

static void help ()
{
  switch (Extern_h.mq_mode)
    {
    case macro.MODE_COMMAND:
      System.out.println ("\tThis is COMMAND mode.  Following commands are valid.");
      System.out.println ("");
      System.out.println ("\t&program;; (end with &end.)");
      System.out.println ("\t\tInput program.");
      System.out.println ("\t\t(If you input programs repeatedly,");
      System.out.println ("\t\t they are inserted incrementally into the database.)");
      System.out.println ("\t&quit;;");
      System.out.println ("\t\tQuit Micro Quixote.");
      System.out.println ("\t&query;;");
      System.out.println ("\t\tGo to QUERY mode.");
      System.out.println ("\t&set [ optionn [value] ];;");
      System.out.println ("\t\tset option to the value.");
      System.out.println ("\t&clear [ rule|subsumption ];;");
      System.out.println ("\t\tclear rules/subsumptions.");
      System.out.println ("\t&show [ rule|subsumption|program|version ];;");
      System.out.println ("\t\tshow rule/subsumption/program.");
      System.out.println ("");

      break;

    case macro.MODE_PROGRAM:
      System.out.print ("\tThis is PROGRAM mode.  Following commands are valid.\n");
      System.out.println ("");
      System.out.println ("\t&rule;;");
      System.out.println ("\t\tGo to RULE mode");
      System.out.println ("\t&subsumption;;\n");
      System.out.println ("\t\tGo to SUBSUMPTION mode");
      System.out.println ("\t&end.");
      System.out.println ("\t\tEnd program and go back to COMMAND mode.");
      break;

    case macro.MODE_PROGRAM_SUBSUMPTION:
      System.out.println ("\tThis is SUBSUMPTION mode.  Please input subsumption relation.");
      System.out.println ("");
      System.out.println ("\ta >= b;;");
      System.out.println ("\t\tadd a subsumption relation `a subsumes b' into database.");
      System.out.println ("\t&end.");
      System.out.println ("\t\tEnd program and go back to COMMAND mode.");
      break;
    case macro.MODE_PROGRAM_RULE:
      System.out.println ("\tThis is RULE mode.  Please input rule/fact.");
      System.out.println ("");
      System.out.println ("\tapple/[color=green];;");
      System.out.println ("\t\tadd a rule `apple with color=green' into database.");
      System.out.println ("\ta <= b;;");
      System.out.println ("\t\tadd a rule `if b then a' into database.");
      System.out.println ("\t&end.");
      System.out.println ("\t\tEnd program and go back to COMMAND mode.");
      break;

    case macro.MODE_QUERY:
      System.out.println ("\tThis is QUERY mode.  Please input query.");
      System.out.println ("");
      System.out.println ("\tapple/[color=X].");
      System.out.println ("\t\task Quixote for color of apple.");
      System.out.println ("\t&end.");
      System.out.println ("\t\tEnd query and go back to COMMAND mode.");
      break;

    case macro.PS_EXPECT_TERM:
      System.out.println ("\t");
      break;

    case macro.PS_EXPECT_PRD:
    case macro.PS_EXPECT_Q_PRD:
      System.out.println ("\t");
      break;

    default:
      MQ_Error.mq_fatal ("wrong parser state");
      break;
    }
  System.out.println ("");
}


static void init_interactive (int is_interactive_p)
    {
      Extern_h.interactive = is_interactive_p;
    }
   

  public FileList         next;
  public String           filename;

  public static InputStream      in_stream;
  public static FileList  file_list;
  public static scanner   scanner_obj;
}

