/* Copyright (C) 1998 Kazumasa Yokota */
/*                                    */
package java_qxt;

public class Exec {

static void init_exec ()
{ }

static void begin_exec ()
{
  Extern_h.executing = 1;
  prev_goal = null;
}

static void suspend_exec ()
{
  Extern_h.executing = 0;
}

static void resume_exec ()
{
  Extern_h.executing = 1;
}

static void end_exec ()
{
  Extern_h.executing = 0;
}

static int solve (MQ_Goal sg)
{
  MQ_Goal g;
  int direction = macro.DOWN;

  g = sg;
  while (g != null)
    if (direction == macro.UP)
      if (g.type == GoalType.GT_Once)
	if (g.next == null)
	  {
	    g = g.parent;
	    direction = macro.UP;
	  }
	else
	  {
	    direction = macro.DOWN;
	    g = g.next;
	  }
      else if (g.type == GoalType.GT_Attribute)
	{
	  if (g.next == null)
	    {
	      g = g.parent;
	      direction = macro.UP;
	    }
	  else
	    {
	      direction = macro.DOWN;
	      g = g.next;
	    }
	}
      else if (cs.constrain_back (g) == macro.SUCCESS)
	{
	  MQ_Goal ag;

	  if (g.type == GoalType.GT_Done ||
	      (ag = attr.make_attribute_goals (g)) == null){
	    if (g.next == null)
	      {
		g = g.parent;
		direction = macro.UP;
	      }
	    else
	      {
		direction = macro.DOWN;
		g = g.next;
	      }
}
	  else
	    {
	      if (Lookup.lookup_active_goals (ag) == macro.FALSE)
		{
		  direction = macro.DOWN;
		  ag.prev = prev_goal;
		  prev_goal = ag;
		  g = ag.subgoal;
		}
	      else if (g.next == null)
		{
		  g = g.parent;
		  direction = macro.UP;
		}
	      else
		{
		  direction = macro.DOWN;
		  g = g.next;
		}
	    }
	}
      else
	{
	  g = prev_goal;
	  direction = macro.DOWN;
	}
    else /* direction == macro.DOWN */
      if (g.type == GoalType.GT_General)
	{
	  MQ_Goal first_subgoal;
	  if (g.rule == null)
	    { /* first execution */
	      MQ_Atom a;
	      int arity;
	      MQ_RuleList rl;

	      g.up = Extern_h.up;
	      g.cnstrs_asmpts = Extern_h.cnstrs_asmpts;
	      g.prev = prev_goal;

	      if (g.goal_vterm.vterm.type == TermType.TT_Obj)
		{
		  a = ( g.goal_vterm.vterm).atom;
		  arity = ( g.goal_vterm.vterm).arity;
		  rl = a.rule_list;

		  while (rl!=null)
		    if (rl.arity < arity)
		      rl = rl.next;
		    else
		      break;

		  if ((rl == null) || (rl.arity > arity))
		    {
		      g = g.prev;
		      continue;
		    }

		  g.rule_list = null;
		  g.rule = rl.rule;
		}
	      else
		{ /* variable proposition */
		  /* rule_list has always mQ_void_rule_list */
		  g.rule_list = Extern_h.rule_list.next;
		  if (g.rule_list == null)
		    {
		      g = g.prev;
		      continue;
		    }
		  g.rule = g.rule_list.rule;
		}
	    }
	  else
	    { /* try next rule */
	      Extern_h.cnstrs_asmpts = g.cnstrs_asmpts;
	      Unify.unwind_variables (g.up);
	      if (g.rule_list!=null)
		{ /* variable proposition */
		  g.rule_list = g.rule_list.next;
		  if (g.rule_list == null)
		    {
		      g.rule = null;
		      g = g.prev;
		      if (Commands.mq_opt_trace!=0)
			System.out.println ("fail.");
		      continue;
		    }
		  g.rule = g.rule_list.rule;
		}
	      else
		if ((g.rule = g.rule.next) == null)
		  {
		    g = g.prev;
		    if (Commands.mq_opt_trace!=0)
		      System.out.println ("fail.");
		    continue;
		  }
	    }

	  g.var_list = MQ_VTermList.generate_variables (g.rule.var_list);
	  g.head.vterm = tangle_vterm (g.rule.head.vterm, g.head);

	  if (Unify.unify (g.goal_vterm, g.head) == macro.FAILURE)
	    continue;

	  g.head_cnstrs = tangle_constraints (g.rule.head_cnstrs);
	  g.body_cnstrs = tangle_constraints (g.rule.body_cnstrs);

	  if (cs.constrain_front (g) == macro.FAILURE)
	    continue;

	  g.subgoal = first_subgoal = generate_subgoals (g);

	  g.lookup = null;

	  if (first_subgoal == null)
	    { /* fact */
	      direction = macro.UP;
	      prev_goal = g;
	      continue;
	    }

	  if (Lookup.lookup_active_goals (g) == macro.FALSE)
	    {
	      prev_goal = g;
	      g = g.subgoal;
	    }
	}
      else if (g.type == GoalType.GT_Attribute)
	{
	  g = g.prev;
	}
      else if (g.type == GoalType.GT_Done)
	{
	  g.type = GoalType.GT_Through;
	  g = g.prev;
	}
      else if (g.type == GoalType.GT_Once)
	{
	  Extern_h.cnstrs_asmpts = g.cnstrs_asmpts;
	  Unify.unwind_variables (g.up);
	  g.type = GoalType.GT_Done;
	  if (cs.constrain_front (g) == macro.FAILURE)
	    {
	      g = g.prev;
	      continue;
	    }

	  prev_goal = g;
	  if (g.subgoal!=null)
	    g = g.subgoal;
	  else
	    direction = macro.UP;
	}
      else if (g.type == GoalType.GT_Through)
	{
	  g.type = GoalType.GT_Once;
	  g.up = Extern_h.up;
	  g.cnstrs_asmpts = Extern_h.cnstrs_asmpts;
	  g.prev = prev_goal;
	  Lookup.lookup_active_goals (g);
	  prev_goal = g;
	  direction = macro.UP;
	}
      else
	MQ_Error.mq_fatal ("solve.");

  if (direction == macro.UP)
    return macro.SUCCESS;
  else
    return macro.FAILURE;
}

static void do_query (MQ_Query query)
{
  int say_yes = 0;

  printing = macro.FALSE;
  Extern_h.up = null;
  Extern_h.cnstrs_asmpts = Extern_h.mQ_void_cnstrs_asmpts;

  if (cs.constrain_front (query.goal) == macro.FAILURE)
    say_yes = 0;

  else {
    if (solve (query.goal.subgoal) == macro.SUCCESS)
      {
        Fquik.messagePrint ("yes. \n");
        say_yes = 1;

        cs.delete_nonsence_asmpts ();
        if (Extern_h.constrain_failed==0)
	  {
	    MQ_print.print_answer (query);
	    printing = macro.FALSE;
	  }

      while (solve (prev_goal) == macro.SUCCESS)
	{
	  cs.delete_nonsence_asmpts ();
	  if (Extern_h.constrain_failed==0)
	    {
	      printing = macro.TRUE;
	      MQ_print.print_answer (query);
	      printing = macro.FALSE;
	    }
	}
      }
      else
	say_yes = 0;
    }

    if (say_yes == 0)
      Fquik.messagePrint ("no. \n");
}

static MQ_VTerm tangle_var (MQ_VTerm var_template, MQ_PP vterm_p)
{
  MQ_VTerm vt;

  vt = var_template.vterm_addr_list.vterm_addr.vterm;

  if (vt.type == TermType.TT_Var)
    {
      MQ_VTerm var;

      var =  vt;
      /* Extern_h.executing == 1 here */
      var.vterm_addr_list
	= new MQ_VTermAddrList(vterm_p, var.vterm_addr_list);
    }
  return vt;
}

static MQ_VTerm tangle_obj (MQ_VTerm obj)
{
  MQ_VTerm new_obj;
  int i, arity;

  arity = obj.arity;
  new_obj = MQ_VTerm.make_object (obj.atom, arity);
  for (i=0; i < arity; i++)
    {
      ((MQ_Attr)new_obj.attr.elementAt(i)).label 
	= ((MQ_Attr)obj.attr.elementAt(i)).label;
      ((MQ_Attr)new_obj.attr.elementAt(i)).vterm.vterm
	= tangle_vterm (((MQ_Attr)obj.attr.elementAt(i)).vterm.vterm,
			((MQ_Attr)new_obj.attr.elementAt(i)).vterm);
    }

  return new_obj;
}

static MQ_VTerm tangle_dot (MQ_VTerm dot)
{
  MQ_VTerm new_obj;

  new_obj = MQ_VTerm.make_MQ_Dot(dot.label);
  new_obj.vterm.vterm = tangle_vterm (dot.vterm.vterm, new_obj.vterm);
  return new_obj;
}

static MQ_VTerm tangle_vterm (MQ_VTerm vterm, MQ_PP vterm_p)
{
  MQ_VTerm new_obj;

  switch (vterm.type)
    {
    case TermType.TT_Var:
      new_obj = tangle_var (vterm, vterm_p);
      break;
    case TermType.TT_Obj:
      new_obj =  tangle_obj (vterm);
      break;
    default:
      MQ_Error.mq_fatal ("tangle_vterm");
      new_obj = null;
      break;
    }

  return new_obj;
}

static MQ_VTerm tangle_term (MQ_VTerm vterm, MQ_PP term_p)
{
  MQ_VTerm new_obj;

  if (vterm == null)
    return null;

  switch (vterm.type)
    {
    case TermType.TT_Var:
      new_obj =  tangle_var (vterm, term_p);
      return new_obj;
    case TermType.TT_Obj:
      new_obj =  tangle_obj (vterm);
      return new_obj;
    case TermType.TT_Dot:
      new_obj =  tangle_dot (vterm);
      return new_obj;
    default:
      MQ_Error.mq_fatal ("tangle_term");
      return null;
    }
}

static MQ_Constraint tangle_constraint (MQ_Constraint cnstr)
{
  MQ_Constraint new_obj;

  new_obj = MQ_Constraint.make_cnstr (cnstr.rel, null, null);
  new_obj.term.vterm = tangle_term (cnstr.term.vterm, new_obj.term);
  new_obj.vterm.vterm = tangle_vterm (cnstr.vterm.vterm, new_obj.vterm);
  return new_obj;
}

static MQ_Constraints tangle_constraints (MQ_Constraints cnstrs)
{
  MQ_Constraints new_obj, next = Extern_h.mQ_void_cnstrs;
  MQ_Constraint cnstr;

  if (cnstrs == null)
    MQ_Error.mq_fatal ("tangle_constraints");

  if (cnstrs == Extern_h.mQ_void_cnstrs)
    return Extern_h.mQ_void_cnstrs;

  next = tangle_constraints (cnstrs.next);
  cnstr = tangle_constraint (cnstrs.cnstr);
  new_obj = MQ_Constraints.make_cnstrs_after (cnstr, next);

  return new_obj;
}

static MQ_Goal generate_subgoals (MQ_Goal g)
{
  MQ_Goal subgoal, first_subgoal, last_subgoal;
  MQ_VTermList vl;

  first_subgoal = last_subgoal = subgoal = null;
  for (vl=g.rule.body; vl!=null; vl = vl.next)
    {
      last_subgoal = subgoal;
      subgoal = new MQ_Goal ();
      subgoal.goal_vterm.vterm
	= tangle_vterm (vl.vterm.vterm, subgoal.goal_vterm);
      subgoal.parent = g;
      if (last_subgoal !=null)
	last_subgoal.next = subgoal;
      else
	first_subgoal = subgoal;
    }
  return first_subgoal;
}

static void begin_tmp ()
{
  Extern_h.temporary = 1;
  rule.begin_temp_alloc_rule ();
  subrel.begin_temp_alloc_subrel ();
}

static void end_tmp ()
{
  Extern_h.temporary = 0;
  rule.end_temp_alloc_rule ();
  subrel.end_temp_alloc_subrel ();
}



MQ_Goal mq_goal_true;
static int printing;

static MQ_Goal prev_goal;

}
