/* Copyright (C) 1998 Kazumasa Yokota */
/*                                    */
package java_qxt;
import java.io.*;

public class Commands {

static void init_command ()
{
  atom_on = MQ_Atom.system_atom ("on");
  atom_off = MQ_Atom.system_atom ("off");
  atom_lookup = MQ_Atom.system_atom ("lookup");
  atom_constrain = MQ_Atom.system_atom ("constrain");
  atom_program = MQ_Atom.system_atom ("program");
  atom_rule = MQ_Atom.system_atom ("rule");
  atom_subsumption = MQ_Atom.system_atom ("subsumption");
  atom_inheritance = MQ_Atom.system_atom ("inheritance");
  atom_version = MQ_Atom.system_atom ("version");
  atom_no = MQ_Atom.system_atom ("no");
  atom_down = MQ_Atom.system_atom ("down");
  atom_up = MQ_Atom.system_atom ("up");
  atom_all = MQ_Atom.system_atom ("all");
}

static void cmd_quit ()
{
  System.exit (0);
}

static void print_lookup_value ()
{
  if (mq_opt_lookup != 0)
    System.out.println ("lookup: on");
  else
    System.out.println ("lookup: off");
}

static void print_constrain_value ()
{
  if (mq_opt_constrain == 1)
    System.out.println ("constrain: on");
  else
    System.out.println ("constrain: off");
}

static void print_inheritance_value ()
{
  switch (mq_opt_inheritance)
    {
    case macro.INHERIT_NO:
      System.out.println ("inheritance: no");
      break;
    case macro.INHERIT_DOWNWARD:
      System.out.println ("inheritance: down");
      break;
    case macro.INHERIT_UPWARD:
      System.out.println ("inheritance: up");
      break;
    case macro.INHERIT_BOTH:
      System.out.println ("inheritance: all");
      break;
    default:
      MQ_Error.mq_fatal ("print_inheritance_value");
      break;
    }
}

static void cmd_set (MQ_Atom option,MQ_Atom value)
{
  if (option == null)
    {
      print_constrain_value ();
      print_lookup_value ();
      print_inheritance_value ();
    }
  else if (option == atom_constrain)
    {
      if (value == null)
	{
	  System.out.println ("valid values are:");
	  System.out.println ("\ton off");
	}
      else if (value == atom_on)
	mq_opt_constrain = 1;
      else if (value == atom_off)
	mq_opt_constrain = 0;
      else
	MQ_Error.mq_error ("invalid value for constrain");
      print_constrain_value ();
    }
  else if (option == atom_lookup)
    {
      if (value == null)
	{
	  System.out.println ("valid values are:");
	  System.out.println ("\toff on");
	}
      else if (value == atom_on)
	mq_opt_lookup = 1;
      else if (value == atom_off)
	mq_opt_lookup = 0;
      else
	MQ_Error.mq_error ("invalid value for lookup");
      print_lookup_value ();
    }
  else if (option == atom_inheritance)
    {
      if (value == null)
	{
	  System.out.println ("valid values are:");
	  System.out.println ("\tno down up all");
	}
      else if (value == atom_no)
	mq_opt_inheritance = macro.INHERIT_NO;
      else if (value == atom_down)
	mq_opt_inheritance = macro.INHERIT_DOWNWARD;
      else if (value == atom_up)
	mq_opt_inheritance = macro.INHERIT_UPWARD;
      else if (value == atom_all)
	mq_opt_inheritance = macro.INHERIT_BOTH;
      else
	MQ_Error.mq_error ("invalid value for inheritance");
      print_inheritance_value ();
    }
}

//static  void cmd_load (MQ_Atom filename)
//{
//  gobble_newline ();
//  pushfilename (filename.name, TRUE);
//}

//void cmd_clear (MQ_Atom what)
//{
//  if (what == null)
//    {
//      free_atom ();
//      free_subrel ();
//      free_rule ();
//    }
//  else if (what == atom_rule)
//    {
//      free_rule ();
//      remove_rule ();
//    }
//  else if (what == atom_subsumption)
//    {
//      free_subrel ();
//    }
//  else
//    {
//      System.out.println ("\tusage:");
//      System.out.println ("\t\t&clear");
//      System.out.println ("\t\t&clear rule");
//      System.out.println ("\t\t&clear subsumption");
//    }
//}

static void cmd_show_all ()
{
   System.out.println ("\tusage:");
   System.out.println ("\t\t&show;;");
   System.out.println ("\t\t&show version;;");
   System.out.println ("\t\t&show program;;");
   System.out.println ("\t\t&show rule;;");
   System.out.println ("\t\t&show subsumption;;");
}
static void cmd_show_item (MQ_Atom what)
{
  if (what.name.equals("program"))
    show_program ();
  else if (what.name.equals("rule"))
    show_rule ();
  else if (what.name.equals("subsumption"))
    show_subsumption ();
  else if (what.name.equals("version"))
    show_version ();
}

static void show_version ()
{
  Fquik.messagePrint ("QUIK version Ver.0.1.  Copyright (C) 1997 Yokota Lab. \n");
}

static void show_program ()
{
  Fquik.messagePrint ("&program;; \n");
  show_subsumption ();
  show_rule ();
  Fquik.messagePrint ("&end. \n");
}

static void show_rule ()
{
//  mm_current = mm_exec;
    Fquik.messagePrint ("&rule;; \n");
    MQ_print.print_all_rules ();
//  mm_current = mm_rule;
}

static void show_subsumption ()
{
//  mm_current = mm_exec;
    Fquik.messagePrint ("&subsumption;; \n");
    MQ_print.print_all_subrel ();
//  mm_current = mm_rule
}

static void show_subsumption_lattice ()
{
//  mm_current = mm_exec;
    MQ_print.print_all_subrel_lattice ();
//  mm_current = mm_rule
}

static void init_options ()
{
  mq_opt_lookup = 1;       /* do lookup */
  mq_opt_trace = debug;    /* do trace if debug */
  mq_opt_constrain = 1;    /* solve constraints */
  mq_opt_inheritance = 3;  /* attribute inheritance all(downward and upward) */
}

static MQ_Atom atom_on, atom_off;
static MQ_Atom atom_lookup;
static MQ_Atom atom_constrain;
static MQ_Atom atom_program, atom_rule, atom_subsumption;
static MQ_Atom atom_no, atom_down, atom_up, atom_all;
static MQ_Atom atom_inheritance;
static MQ_Atom atom_version;

static int mq_opt_constrain;
static int mq_opt_lookup;
static int mq_opt_trace;
static int mq_opt_inheritance;
static int debug=0;
static int debug_memory=0;

}






