/*                      Copyright(C)1997  Mitsuru Ishizuka             */
/*                                        Yukio Ohsawa                 */
/*                                 Dept. of Information & Commun. Eng. */
/*                                 School of Eng.                      */
/*                                 Univ. of Tokyo                      */  

#include <stdio.h>
#include <stdlib.h>
#include <sys/time.h>
#include <sys/resource.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>

Display *d;
Window w, r, exit_w,right_w,left_w,up_w,down_w,next_w;
Font f;
XEvent e;
int *x_axis, *y_axis;
unsigned long blue, white, black, green, red, MyColor(); 
void draws_angle(), draws_circle(), draws_line(), draws_node(), shows_graph(),
     draws_num(),write_atom();

GC gc;
double cputime, cputime1, cputime2;
struct rusage rus;

/* Stays constant */
int bnk, nd_max, right_num, divc, in_ex, *is_inc, *is_goal, *and_ch,see_graph,see_input,
    *and_chlds;
int *atr, *stt, *strctr, str_num, *slack, slk_num, *srnd_num, *link, link_num,
    x, *rght_sonae, *srnd, ttl_node, node, node_1, *core, *papa, *papa_num,
    *sugu_ue, *leaf, *lttr, *br_num, *lft_bnk, *and_left, and_num, *bound,
    inc, goal, *chld, *chld_num, global, cycle_num,*focus,*cont_num;
double *uppr, *lwr, *rel;

/* Works hard, always */
int  rch, *mark1, *beer, ch_out, *in_arr, *out_arr, *arrow,x_goal,y_goal;
double *value, *cost;

/* Initialized every exchange */
double bst_cst, *the_cost;
double cmp;

/* Initialiized in smaller loops*/
int grp_num, nst_num, *mark2, flg_out, *can_nst, *lnk_of_nst, *tukatta, *times,
    *nst_th, nxt,sum, init_num, sm1_end, cand_num;
double min_ch, minch1, *diff, *rate, now_aus;

#define SCALE 	10
#define DENSE  	2

#define WORDS  	5000    /*All Node number*/

/* -----------------------------------------------------------------*/
/* Reduce the following two values ,if 'Segmentation Fault' arises. */

#define STRUCT 	1000    /*area for structual variables*/   
#define SLACK  	1000    /*area for slack variables*/

/* ---------------------------------------------------------------- */

#define ALL   	( STRUCT + SLACK )
#define CIRCUM 	200    /*nodes around a node*/
#define GROUP  	100
#define NEST   	2000
#define DEPTH   200

#define RLENGTH 50   /*number of inc*/

FILE *fp,*fopen();

void solves(), arrower(), arrow_sub(), arrow_back(), set_true();
void impr(), symplex(), relative(), waitme(), input_newversion(), gstep();
void period(), collon(), slct_wh(), zero_spot(),eq_check();
void initializer(), shows_net(), shows_net2(), compare(), insisted();
void outputs(), shows_value(), shows_value2(), shows_change(),draws_bg();
int trial(), trial_sub(), impr_sub(), new_strctr(), new_slack(), prpgt(),
    approx(), impr_sub(), abs_i(), exchange(), perifec(), selects(),
    searches(), hihn(), simpl2();
double abs_f(), flt();

/*****The COST FUNCTION is defined only as a default coeffients!!!!!!****/

		/*************************/
		/****  For a dieting   ***/
		/*************************/

main(int argc,char **argv){
    int i, j, i1, j1, choice, init_rch, br, t, pig, *parity, illegal;
    double v;
    XSetWindowAttributes a;
    unsigned long fg, bg;

    cont_num=(int*)malloc(WORDS*5*sizeof(int));		/*  1K */
    focus=(int*)malloc(ALL*sizeof(int));		/*  1K */
    leaf=(int*)malloc(WORDS*5*sizeof(int));		/*  1K */
    rght_sonae=(int*)malloc(ALL*sizeof(int));		/*  1K */
    br_num=(int*)malloc(WORDS*5*sizeof(int));		/*  1K */
    lttr=(int*)malloc(WORDS*5*sizeof(int));		/*  1K */
    is_inc=(int*)malloc(ALL*sizeof(int));
    is_goal=(int*)malloc(ALL*sizeof(int));
    chld=(int*)malloc(STRUCT*CIRCUM*sizeof(int));   	/* 10K */
    chld_num=(int*)malloc(STRUCT*sizeof(int));      	/*  1K */
    sugu_ue=(int*)malloc(WORDS*5*sizeof(int));		/*  1K */
    and_left=(int*)malloc(STRUCT*sizeof(int));		/*  1K */
    tukatta=(int*)malloc(ALL*sizeof(int));		/*  1K */
    times=(int*)malloc(ALL*sizeof(int));		/*  1K */
    lft_bnk=(int*)malloc(STRUCT*sizeof(int));		/*  1K */
    cost=(double*)malloc(STRUCT*sizeof(double));       	/*  1K */
    the_cost=(double*)malloc(ALL*sizeof(double));     	/*  1K */
    papa=(int*)malloc(ALL*CIRCUM*sizeof(int));		/*  1K */
    papa_num=(int*)malloc(ALL*sizeof(int));		/*  1K */
    core=(int*)malloc(100*sizeof(int));			/* .1K */
    arrow=(int*)malloc(ALL*CIRCUM*sizeof(int));		/* 20K */
    mark1=(int*)malloc(ALL*sizeof(int));		/*  2K */
    mark2=(int*)malloc(ALL*sizeof(int));		/*  2K */
    beer=(int*)malloc(STRUCT*sizeof(int));		/*  1K */
    bound=(int*)malloc(SLACK*sizeof(int));		/*  1K */
    /*** bound=2 when uppr, 0 when lower ***/
    lwr=(double*)malloc(ALL*sizeof(double));		/*  8K */
    uppr=(double*)malloc(ALL*sizeof(double));	        /*  8K */
    diff=(double*)malloc(ALL*sizeof(double));	        /*  8K */
    rate=(double*)malloc(STRUCT*sizeof(double));	/*  4K */
    srnd_num=(int*)malloc(ALL*sizeof(int));		/*  8K */
    srnd=(int*)malloc(ALL*CIRCUM*sizeof(int));		/* 20K */
    link=(int*)malloc(ALL*CIRCUM*sizeof(int));		/* 20K */
    slack=(int*)malloc(SLACK*sizeof(int));		/*  1K */
    strctr=(int*)malloc(STRUCT*sizeof(int));		/*  1K */
    rel=(double*)malloc(ALL*CIRCUM*sizeof(double));	/* 40K */
    value=(double*)malloc(ALL*sizeof(double));		/*  4K */
    stt=(int*)malloc(ALL*sizeof(int));			/*  1K */
    atr=(int*)malloc(ALL*sizeof(int));			/*  1K */
    can_nst=(int*)malloc(ALL*sizeof(int));		/*.05K */
    in_arr=(int*)malloc(SLACK*sizeof(int));		/*  1K */
    out_arr=(int*)malloc(SLACK*sizeof(int));		/*  1K */
    nst_th=(int*)malloc(ALL*sizeof(int));		/*  1K */
    lnk_of_nst=(int*)malloc(NEST*CIRCUM*sizeof(int));   /*  1K */
    and_chlds=(int*)malloc(ALL*sizeof(int));
    and_ch=(int*)malloc(ALL*CIRCUM*sizeof(int));
				/* Total memory = 209.35K*/

    x_axis=(int*)malloc(ALL*sizeof(int));
    y_axis=(int*)malloc(ALL*sizeof(int));
    parity=(int*)malloc(ALL*CIRCUM*sizeof(int));
    /* total memory of internal varibables is 1Mbites*/

    if((fp=fopen( argv[1],"r"))==NULL){
	printf("can't open file %s\t",*argv);
	exit(1);
    }
	printf("\n\n");
	printf("*******************************************************\n");
	printf("*******************************************************\n");
	printf("	NBP (Networked Bubble Propagation)	       \n");
	printf("***  	     A High-speed Abduction System 	   ***\n");
	printf("*******************************************************\n");
	printf("*     CopyRighted by Y.Ohsawa and M.Ishizuka (1996)   *\n");
	printf("*******************************************************\n");
	printf("\n\n");

	printf("The input data :  %s\n",argv[1]);
	if((fp=fopen( argv[1],"r"))==NULL){
		printf("Can't open file : %s\n",*argv);
		exit(1);
	}
	printf("\n");
	printf("Do you see the process of reading the input file (Yes:1 / No:0)?\n");
	scanf("%d",&see_input);
	printf("You see the inference graph of NBP, nodes denoted by (Node:0 / Atom:1).\n (If you do not see the graph, type 2.)\n");
	scanf("%d",&see_graph);

    if(see_graph<2){
	d = XOpenDisplay(NULL);    
	r = RootWindow(d ,0);
	bg = WhitePixel(d, DefaultScreen(d));
	fg = BlackPixel(d, DefaultScreen(d));
	green=MyColor(d, "green");
	red=MyColor(d, "red");
	black=MyColor(d, "black");
	blue=MyColor(d, "blue");
	white=MyColor(d, "white");
	w = XCreateSimpleWindow (d, r, 10, 10, 1000, 900, 0, fg, bg);
	exit_w = XCreateSimpleWindow (d, w, 10, 15, 30, 30, 2, fg, bg);
	next_w = XCreateSimpleWindow (d, w, 900, 200, 40, 50, 2, fg, bg);
	up_w = XCreateSimpleWindow (d, w, 900, 45, 30, 45, 2, fg, bg);
	down_w = XCreateSimpleWindow (d, w, 900, 130, 30, 45, 2, fg, bg);
	left_w = XCreateSimpleWindow (d, w, 850, 95, 45, 30, 2, fg, bg);
	right_w = XCreateSimpleWindow (d, w, 935, 95, 45, 30, 2, fg, bg);
	a.override_redirect = False;
	XChangeWindowAttributes(d, w, CWOverrideRedirect, &a);
	XStoreName(d, w, "Bubble Propagation Network.");
	XSelectInput(d, w, ExposureMask | ButtonPressMask);
	XSelectInput(d, w, KeyPressMask);
	XSelectInput(d, exit_w, ExposureMask | ButtonPressMask);
	XSelectInput(d, next_w, ExposureMask | ButtonPressMask);
	XSelectInput(d, up_w, ExposureMask | ButtonPressMask);
	XSelectInput(d, down_w, ExposureMask | ButtonPressMask);
	XSelectInput(d, left_w, ExposureMask | ButtonPressMask);
	XSelectInput(d, right_w, ExposureMask | ButtonPressMask);
	XMapWindow(d, w);
	XMapSubwindows(d, w);
	f = XLoadFont(d, "a14"); 
	gc = XCreateGC(d, w, 0, 0);
	XSetFont(d, gc, f);
	XDrawString(d, exit_w, gc, 1, 20, "EXIT", 5);
	XFlush(d);
	x_goal=450;
	y_goal=100;
    }

    getrusage(RUSAGE_SELF,&rus);
    cputime1=rus.ru_utime.tv_sec + rus.ru_utime.tv_usec*1.0e-6;	  
    initializer(argv,argc);
/*
    getrusage(RUSAGE_SELF,&rus);
    cputime=rus.ru_utime.tv_sec + rus.ru_utime.tv_usec*1.0e-6;
    printf("runtime sym=%9.2f[s]\n",cputime-cputime1);
  */

    eq_check();
    set_true();
/*    printf("str %d, slk %d\n",str_num,slk_num);*/

    /*while(1)*/
    if(see_graph<2)     shows_graph(x_goal,y_goal);

    for(i=1;i<=link_num;i++)
	parity[i]=0;

    for(i=1;i<=ttl_node;i++)
	for(j=1;j<=srnd_num[i];j++)
	    parity[link[i*CIRCUM+j]]++;

    illegal=0;
    for(i=1;i<=ttl_node;i++)
	for(j=1;j<=srnd_num[i];j++)
	    if(parity[link[i*CIRCUM+j]]<2){
		printf("%d is not seen from %d,\n",i,srnd[i*CIRCUM+j]);
		illegal=1;
	    }

    if(illegal)
	exit(1);


    init_rch=rch;
    nst_num=ttl_node;
    for(i=1;i<=ttl_node;i++){
	can_nst[i]=i;
	tukatta[i]=times[i]=0;
	for(j=1;j<=srnd_num[i];j++)
	    arrow[link[i*CIRCUM+j]]=0;
    }
    arrower();
    if(see_graph<2)     shows_graph(x_goal,y_goal);
    cycle_num=0;

    while(1){
	for(i=1;i<=ttl_node;i++){	       
	    if(flt(value[i]-uppr[i])>0.0||flt(value[i]-lwr[i])<0.0){
		printf("[%d]%f(%f<x<%f)=\n",i,value[i],lwr[i],uppr[i]);
		for(j=1;j<=srnd_num[i];j++)
		    printf("+%f[%d]",-1.0/rel[i*CIRCUM+j]*value[srnd[i*CIRCUM+j]],srnd[i*CIRCUM+j]);
		printf("\n");
	    }
        }

	/* pr<1, value, srnds, arrows */
	br=0;
	rch=0;
	t=0;
	for(i=1;i<=ttl_node;i++)
	    if(stt[i]==1){
		if(atr[i]==1)	rch++;
		else 	      	beer[++br]=i;
	    }  

	for(i=1;i<=ttl_node;i++)
	    if(stt[i]==1){
		if(atr[i]==1) 	beer[++br]=i;
	    }  
/*	printf("[%d of %d=%d]\n",rch,str_num,br);*/
	if(rch>=str_num&&flg_out==0)
	    break;

	choice=trial(0);
	tukatta[choice]=1;
	for(i=1;i<=ttl_node;i++)
	    if(tukatta[i]>0)
		tukatta[i]++;
	exchange(choice);
	eq_check();
	printf("[%d]\n",++cycle_num);
/*	outputs();*/
    }
/*    getchar();*/
    impr();
    /* pr<1, value, srnds, arrows */
    getrusage(RUSAGE_SELF,&rus);
    cputime=rus.ru_utime.tv_sec + rus.ru_utime.tv_usec*1.0e-6;
    printf("runtime=%9.2f[s]\n",cputime-cputime1);
    outputs();
    if(see_graph<2){
	draws_bg();
        /* IF THE RED LINES OF ACTIVE PART IS WANTED, DO getchar() BELOW.*/
	shows_graph(x_goal,y_goal);
	while(1){
		XNextEvent(d, &e);
		switch(e.type){
		case Expose :
/* IF THE RED LINES OF ACTIVE PART IS WANTED, DO getchar() BELOW.*/
		    draws_bg();
		    shows_graph(x_goal,y_goal);
		     break;	
		case ButtonPress :
		    XClearWindow(d,w);
		    draws_bg();
		    if(e.xany.window == right_w) x_goal+=100;
		    if(e.xany.window == left_w) x_goal-=100;
		    if(e.xany.window == up_w) y_goal-=100;
		    if(e.xany.window == down_w) y_goal+=100;
		    if(e.xany.window == exit_w) exit(1);
		     shows_graph(x_goal,y_goal);
		     break;
		}
	}    
     	waitme();
    }
    else printf("Are you ready to quit (touch return key)?\n");
    getchar();
}


void draws_bg(){
    XSetForeground(d, gc, red);
    XFillRectangle(d, w, gc, 0, 5, 50, 50);
    XDrawString(d, exit_w, gc, 1, 20, "EXIT ", 5);

    XSetForeground(d, gc, blue);
    XDrawString(d, up_w, gc, 1, 20, " UP ", 5);
    XDrawString(d, down_w, gc, 1, 20, "DOWN", 5);
    XDrawString(d, right_w, gc, 1, 20, "RIGHT", 5);
    XDrawString(d, left_w, gc, 1, 20, "LEFT", 5);

    XSetForeground(d, gc, green);
    XFillRectangle(d, w, gc, 890, 190, 60, 70);

    XSetForeground(d, gc, black);
    XDrawString(d, w, gc, 850, 20, "Move", 5);
    XDrawString(d, w, gc, 880, 20, " the ", 5);
    XDrawString(d, w, gc, 920, 20, "Graph", 5);
    XDrawString(d, next_w, gc, 1, 20, "Next", 5);
    XDrawString(d, next_w, gc, 1, 35, "Step", 5);
    return;
}

void eq_check()
{
    int i,j,ng;
    double kurabe;
    ng=0;
    for(i=1;i<=slk_num;i++){ 
	kurabe=0;
	for(j=1;j<=srnd_num[slack[i]];j++)
	    kurabe+=-1.0*value[srnd[slack[i]*CIRCUM+j]]/rel[slack[i]*CIRCUM+j];
	if(flt(value[slack[i]]-kurabe)!=0.0){ 
	    printf("NG:%d\n",slack[i]);
	    printf("value(%f<<%f)=%f=",
		   lwr[slack[i]], uppr[slack[i]], value[slack[i]]);
	    for(j=1;j<=srnd_num[slack[i]];j++)
		printf("+%f[%d]",-1.0/rel[slack[i]*CIRCUM+j]
		                 *value[srnd[slack[i]*CIRCUM+j]],
		       srnd[slack[i]*CIRCUM+j]);
	    printf("\n");
	    ng=1;
	}
    }
    if(ng==1) exit(1);
    
}

void gstep(){
/*	printf("[%d**1]\n",cycle_num);
    XNextEvent(d, &e);
	printf("[%d**2]\n",cycle_num);
    switch(e.type){
    case ButtonPress :
	printf("[%d**3]\n",cycle_num);
        printf("Button Press\n");;          
    }
    */

    return;
}

void waitme(){
    while(1){
	XNextEvent(d, &e);
	switch(e.type){
	case Expose :
            XDrawString(d, exit_w, gc, 1, 20, "EXIT", 5);
	    shows_graph(x_goal,y_goal);
	    break;	 
	case ButtonPress :
            if(e.xany.window == exit_w)
                exit(1);	    
	}
    }    
    return;
}

void initializer(char **argv, int argc){
    int i, *strth, *slkth;
    double t_cost;
    strth=(int*)malloc(STRUCT*sizeof(int));
    slkth=(int*)malloc(SLACK*sizeof(int));
    input_newversion(strth,slkth,argv,argc);

    for(i=1;i<=slk_num;i++)
	cost[slack[i]]=cost[papa[slack[i]*CIRCUM+1]];
    for(i=1;i<=str_num;i++) 
	if(srnd_num[strctr[i]]!=papa_num[strctr[i]]) 	cost[strctr[i]]=0.0;
        else	if(focus[strctr[i]]==0)			cost[strctr[i]]=1.0;
                else					cost[strctr[i]]=0.0;
    for(i=0;i<nd_max+1;i++) 
	cost[leaf[i]] *= the_cost[i];

/*    for(i=1;i<=str_num;i++)
	printf("cost[%d]=%f(%d,%d,%d)\n",strctr[i],cost[strctr[i]],
	       focus[strctr[i]],srnd_num[strctr[i]],papa_num[strctr[i]]);
*/
    symplex(strth,slkth);

/*
    t_cost=0.0;
    for(i=1;i<=str_num;i++){
	if(strctr[i]<65) t_cost+=value[strctr[i]]*cost[strctr[i]];
	if(flt(cost[strctr[i]]-1.0)==0.0) printf("+%d\n",strctr[i]);
    }
    printf("t_cost=%f,srnd_num[22]=%d",t_cost,srnd_num[22]);
*/

    for(i=1;i<=ttl_node;i++)
	in_arr[i]=out_arr[i]=0;

    /* shows_net(); */
    return;
}

void set_true(){
    int i, j, more_to_set, *alrdy;
    
    alrdy=(int*)malloc(ALL*sizeof(int));
    for(i=1;i<=str_num;i++)
	alrdy[strctr[i]]=0;	
    more_to_set=1;
    
    while(more_to_set){
	more_to_set=0;
	for(i=1;i<=str_num;i++)
	    if(lwr[strctr[i]]>0.5&&alrdy[strctr[i]]==0){
		more_to_set=1;
		alrdy[strctr[i]]=1;
		for(j=1;j<=and_chlds[strctr[i]];j++){
		    lwr[srnd[and_ch[strctr[i]*CIRCUM+j]*CIRCUM+2]]=1.0;
		}
	    }
    }
    return;
}

void shows_graph(int iks, int wai){
    char *kazu;
    int i, j, k, dr, drawn_num, *drawn_node, tonari, *drawn, *kodomo_num, k2,
	gaki, mitudo, mitudo_limit, mitudo_areax, mitudo_areay, kihon, mawari,
	muki;
         
    drawn_node=(int*)malloc(ALL*sizeof(int));
    drawn=(int*)malloc(ALL*sizeof(int));		
    kodomo_num=(int*)malloc(ALL*sizeof(int));
    kazu=(char *)malloc(sizeof(char)*5);	
    XSetLineAttributes (d, gc, 1, LineSolid, CapButt, JoinMiter);

    for(i=1;i<=ttl_node;i++){
	drawn[i]=0;
	kodomo_num[i]=0;
    }
    drawn[1]=1;
    drawn_node[drawn_num=1]=1;
    x_axis[1]=iks;
    y_axis[1]=wai;
    draws_circle(1);
    while(drawn_num<ttl_node)
	for(j=1;j<=drawn_num;j++){
	    dr=drawn_node[j];
	    kihon=x_axis[dr];
	    for(k=1;k<=srnd_num[dr];k++){
		tonari=srnd[dr*CIRCUM+k];
		if(drawn[tonari]==0){
		    gaki=++kodomo_num[dr];
		    if(atr[tonari]==0){
			mitudo_limit=DENSE;
			mitudo_areax=70;
			mitudo_areay=50;
		    }
		    else{
			mitudo_limit=0;
			mitudo_areax=SCALE;
			if(k!=1)
			    kihon+=
				powint(-1,gaki+1)*(int)(300/(gaki+10)*(gaki));
			mitudo_areay=SCALE;
		    }
		    if((srnd_num[dr]>2 && srnd_num[tonari]>2 && atr[tonari]==0)
		       || atr[tonari]==1)
			while(1){
			    mitudo=0;
			    for(i=1;i<=drawn_num;i++){
				mawari=drawn_node[i];
				if(abs_i(x_axis[mawari]-kihon)<mitudo_areax &&
				   abs_i(y_axis[mawari]-y_axis[dr]-50)<mitudo_areay)
				    if(++mitudo>mitudo_limit){
					kihon+=
					    ((x_axis[dr]>
					      x_axis[drawn_node[j-1]])*2-1)
					      *mitudo_areax;
					break;
				    }
			    }
			    if(mitudo<=mitudo_limit)
				break;
			}
		    drawn_node[++drawn_num]=tonari;
		    if(atr[tonari]==0){
			for(k2=1;k2<=srnd_num[tonari];k2++) 
			    if(srnd[tonari*CIRCUM+k2]==dr)
				break;	
			if(k2==1){
			    x_axis[tonari]=kihon+powint(-1,gaki)
				           *(int)(100/(gaki+10)*gaki);
			    y_axis[tonari]=y_axis[dr]+50;
			}
			else{
			    x_axis[tonari]=kihon+powint(-1,gaki)
					   *(int)(185/(gaki+10)*gaki);
			    y_axis[tonari]=y_axis[dr]+50;
			}
		    }
		    else if(k==1){
			x_axis[tonari]=kihon;
			y_axis[tonari]=y_axis[dr]+50;			
		    }
		    else{
			x_axis[tonari]=kihon;
			y_axis[tonari]=y_axis[dr]+50;
		    }
		    drawn[tonari]=1;
		}
	    }
	}

    for(i=1;i<=slk_num;i++)
	if(srnd_num[k=slack[i]]>2){
	    y_axis[k]+=((y_axis[k]>y_axis[srnd[k*CIRCUM+1]])*2-1)*10;
	    x_axis[k]+=(int)((x_axis[k]-x_axis[srnd[k*CIRCUM+1]])/10);
	}
/*
    for(i=2;i<=drawn_num;i++){
	k=drawn_node[i];
	draws_node(k);
        sprintf(kazu,"%d",k);
	muki=(int)(((x_axis[k]>x_axis[drawn_node[i-1]])*2-1)*SCALE*0.7);
	XDrawString(d, w, gc,x_axis[k]-5+muki,y_axis[k]+SCALE*2,
		    kazu, strlen(kazu));
	for(j=1;j<=srnd_num[k];j++){
	    draws_line(k,srnd[k*CIRCUM+j],0);
	    draws_node(srnd[k*CIRCUM+j]);
	}	
	draws_node(k);
    }
*/
	for(i=1;i<=drawn_num;i++){
	    k=drawn_node[i];
	    draws_node(k);
	    switch(see_graph){
	        case 0: sprintf(kazu,"%d",k);
                    if(i>1)
			muki
			    =(int)(((x_axis[k]>x_axis[drawn_node[i-1]])*2-1)*SCALE*0.7);
                    else muki=(int)(SCALE*0.7);
		    XDrawString(d, w, gc,x_axis[k]-(int)(0.3*SCALE)+muki,
				y_axis[k]+(int)(SCALE*1.5),kazu, strlen(kazu));

		    break;
	        case 1: write_atom(k,drawn_node,x_axis,y_axis);
	    }
	    for(j=1;j<=srnd_num[k];j++){
		draws_line(k,srnd[k*CIRCUM+j],0);
		draws_node(srnd[k*CIRCUM+j]);
	    }	
	    draws_node(k);
	}
    XFlush(d);
    free(drawn_node);
    free(drawn);      
    free(kazu);
    free(kodomo_num); 
    return;
}

int  powint(int a, int b){
    int i, power;
    power=1;
    for(i=1;i<=b;i++)
	power*=a;
    return(power);
}

void draws_node(int node){
    switch(atr[node]){
    case 1:
	draws_circle(node);
	break;
    case 0:
	draws_angle(node);
    }
    return;
}

void draws_angle(int node){
    int x, y;
    switch(stt[node]){
    case 1:
	XSetForeground(d, gc, black);
	break;
    case 0:
	XSetForeground(d, gc, white);
    }
    if(flt(value[node]-uppr[node])>0.0||flt(value[node]-lwr[node])<0.0)
	XSetForeground(d, gc, red);
    x=x_axis[node];
    y=y_axis[node];
    XFillRectangle(d, w, gc, x-(int)(SCALE/2), y-(int)(SCALE/2), SCALE, SCALE);
    XSetForeground(d, gc, black);
    XDrawRectangle(d, w, gc, x-(int)(SCALE/2), y-(int)(SCALE/2), SCALE, SCALE);
    return;
}

void draws_circle(int node){
    int x, y;
    switch(stt[node]){
    case 1:
	XSetForeground(d, gc, black);
	break;
    case 0:
	XSetForeground(d, gc, white);
    }
    if(flt(value[node]-uppr[node])>0.0||flt(value[node]-lwr[node])<0.0)
	XSetForeground(d, gc, red);
    if(flt(value[node]-1.0)==0.0)
	XSetForeground(d, gc, green);
    x=x_axis[node];
    y=y_axis[node];
					
    XFillArc(d, w, gc, x-(int)(SCALE/2), y-(int)(SCALE/2), 
	     SCALE, SCALE, 0*64, 360*64);
    XSetForeground(d, gc, black);
    XDrawArc(d, w, gc, x-(int)(SCALE/2), y-(int)(SCALE/2), 
	     SCALE, SCALE, 0*64, 360*64);
    if(papa_num[node]==srnd_num[node]){
	XDrawArc(d, w, gc, x-(int)(0.8*SCALE), y-(int)(0.8*SCALE), 
		 (int)(1.6*SCALE), (int)(1.6*SCALE), 0*64, 360*64);
    }
    return;
}

void draws_line(int a, int b, int jd){
    int xa,xb,ya,yb;
    xa=x_axis[a];
    ya=y_axis[a];
    xb=x_axis[b];
    yb=y_axis[b];
    if(jd==0) XSetForeground(d, gc, black);
    if(jd==1) XSetForeground(d, gc, red);
    if(jd==2) XSetForeground(d, gc, red);
    if(jd==3) XSetForeground(d, gc, green);
    XDrawLine(d, w, gc, xa, ya, xb, yb);
    return;
}

unsigned long MyColor(Display *display, char *color){
    Colormap cmap;
    XColor c0, c1;
    cmap=DefaultColormap(display, 0);
    XAllocNamedColor(display, cmap, color, &c1, &c0);
    return(c1.pixel);
}

void shows_net(){
    int j,k,m;								
    printf("ttl_node=%d\n",ttl_node);
    m=0;
    for(j=0;j<=ttl_node;j++){
	if(++m==10){
	    gstep();
	    m=0;
	}
	printf("atr is %d stt is %d,and_chlds %d, ",
	       atr[j], stt[j], and_chlds[j]);
	for(k=1;k<=srnd_num[j];k++)
	    printf("[%d(%d)-[%d](%d%d)-%d]",
		   j, atr[j], arrow[link[j*CIRCUM+k]], stt[j],
		   stt[srnd[j*CIRCUM+k]], srnd[j*CIRCUM+k]);
	printf("\n");
    }
    gstep();
    return;
}

void shows_net2(){
    int i, j, k, m;
    m=0;
    for(i=1;i<=nst_num;i++){
	if(++m==10){
	    gstep();
	    m=0;
	}
	j=can_nst[i];
	printf("atr is %d stt is %d ", atr[j],stt[j]);
	for(k=1;k<=srnd_num[j];k++)
	    printf("[%d(%d)-[%d](%d%d)-%d]",
		   j, atr[j], arrow[link[j*CIRCUM+k]], stt[j],
		   stt[srnd[j*CIRCUM+k]], srnd[j*CIRCUM+k]);
	printf("\n");
    }
    gstep();
    return;
}

void arrower(){
    int i, j, *cand_arr, now, *car_num, srst, sl, sr, srsl;

    cand_arr=(int*)malloc(ALL*sizeof(int));
    car_num=(int*)malloc(sizeof(int));
    /**  the candidate node to be in a same nest of arrow  **/

    for(i=1;i<=str_num;i++) 
	if((flt(value[strctr[i]])==0.0 || flt(value[strctr[i]])==1.0)
	    && stt[strctr[i]]==0){		
	    stt[strctr[i]]=1;
	}

    for(i=1;i<=nst_num;i++)
	mark1[can_nst[i]]=0;
      
    *car_num=0;
    for(i=1;i<=str_num;i++){
	if(stt[strctr[i]]==1)
	    cand_arr[++*car_num]=strctr[i];
    }
	
    arrow_sub(cand_arr,car_num);
    *car_num=0;
    for(i=1;i<=slk_num;i++){
	if(stt[slack[i]]==0)
	    cand_arr[++*car_num]=slack[i];
	}
	 
    arrow_back(cand_arr,car_num);
    free(cand_arr);
    free(car_num);
    return;
}

void arrow_sub(int *cand_arr, int *car_num){
    int i, j, now, srst, sl, sr, srsl, *tmp_mark, trace, squees;

    tmp_mark=(int*)malloc(ALL*sizeof(int));
    getrusage(RUSAGE_SELF,&rus);
    cputime2=rus.ru_utime.tv_sec + rus.ru_utime.tv_usec*1.0e-6;	  
    for(i=1;i<=nst_num;i++){
	node=can_nst[i];
	tmp_mark[node]=0;
    }
		
    now=0;
    while(now<*car_num){
	mark1[cand_arr[++now]]=1;
	/***  mark1 is the mark of already arrowed (start or end of arrow).***/
	for(srst=1;srst<=srnd_num[cand_arr[now]];srst++){
	    if(tmp_mark[sl=srnd[cand_arr[now]*CIRCUM+srst]]==0){
		mark1[sl]=1;

		if(arrow[link[cand_arr[now]*CIRCUM+srst]]==0){
		    arrow[link[cand_arr[now]*CIRCUM+srst]]=-1;
		    in_arr[sl]++;
		    out_arr[cand_arr[now]]++;
	        }
		if(in_arr[sl]==srnd_num[sl]-1&&stt[sl]==1){
		    /*it is not neccesary to say sl is atr=0*/
		    for(srsl=1;srsl<=srnd_num[sl];srsl++){
			if(mark1[srnd[sl*CIRCUM+srsl]]==0){
			    tmp_mark[sl]=1;
			    mark1[squees=srnd[sl*CIRCUM+srsl]]=1;
			    if(stt[squees]==0){
				if(arrow[link[sl*CIRCUM+srsl]]==0){
				    arrow[link[sl*CIRCUM+srsl]]=1;
				    cand_arr[++*car_num]=squees;
				}
			    }
			    else{
				if(arrow[link[sl*CIRCUM+srsl]]==0){
				    stt[sl]=0;
				    arrow[link[sl*CIRCUM+srsl]]=-1;
				    in_arr[sl]++;
				    out_arr[srnd[sl*CIRCUM+srsl]]++;
				}
			    }
			}
		    }
		}
		if(stt[sl]==1&&in_arr[sl]==srnd_num[sl]){
		    stt[sl]=0;
		    /********* Nodes' cost change ***************/
		}
	    } 
	}
    }

    free(tmp_mark);
    return;
}

void arrow_back(int *cand_arr, int *car_num){
    int i, j, now, srst, sl, sr, srsl, *tmp_mark, trace, squees;

    tmp_mark=(int*)malloc(ALL*sizeof(int));
    getrusage(RUSAGE_SELF,&rus);
    cputime2=rus.ru_utime.tv_sec + rus.ru_utime.tv_usec*1.0e-6;	  
    for(i=1;i<=nst_num;i++){
	node=can_nst[i];
	tmp_mark[node]=0;
    }
    now=0;
    while(now<*car_num){
	mark1[cand_arr[++now]]=1;
	/***  mark1 is the mark of already arrowed (start or end of arrow).***/
	for(srst=1;srst<=srnd_num[cand_arr[now]];srst++){
	    if(tmp_mark[sl=srnd[cand_arr[now]*CIRCUM+srst]]==0){
		mark1[sl]=1;
		if(arrow[link[cand_arr[now]*CIRCUM+srst]]==0){
		    arrow[link[cand_arr[now]*CIRCUM+srst]]=-1;
		    out_arr[sl]++;
		    in_arr[cand_arr[now]]++;
	        }
		if(out_arr[sl]==srnd_num[sl]-1&&stt[sl]==0){
		    /*it is not neccesary to say sl is atr=0*/
		    /*tmp_mark denotes a receiving node already squeesed*/
		    for(srsl=1;srsl<=srnd_num[sl];srsl++){
			if(mark1[srnd[sl*CIRCUM+srsl]]==0){
			    tmp_mark[sl]=1;
			    mark1[squees=srnd[sl*CIRCUM+srsl]]=1;
			    if(stt[squees]==1){
				if(arrow[link[sl*CIRCUM+srsl]]==0){
				    arrow[link[sl*CIRCUM+srsl]]=1;
				    cand_arr[++*car_num]=squees;
				}
			    }
			    else{
				if(arrow[link[sl*CIRCUM+srsl]]==0){
				    stt[sl]=1;
				    arrow[link[sl*CIRCUM+srsl]]=-1;
				    out_arr[sl]++;
				    in_arr[srnd[sl*CIRCUM+srsl]]++;
				}
			    }
			}
		    }
		}
		if(in_arr[sl]==srnd_num[sl]){
		    stt[sl]=0;
		}
	    } 
	}
    }
    free(tmp_mark);
    return;
}

int trial(int taihen){
    int chosen,br, div, i, counter, sonae, sonae3, sonae2, 
	h, j,shld_change,w_break,c18;
    double bst_out, best, gap, how_out, out_min, vl;
    
    /*printf("   trial jointed\n");*/
    out_min=1000000.0;
    chosen=0;
    counter=0;
    sonae=sonae2=sonae3=0;
    for(br=1;br<=str_num;br++){
	if(flt(uppr[beer[br]]-lwr[beer[br]])>0.0) {
	    while(1){
	      div=trial_sub(beer[br]);
	      w_break=0;
	      if(div==-1)
		  for(i=1;i<=nst_num;i++){
		    if(atr[can_nst[i]]==0&&stt[can_nst[i]]){
			stt[can_nst[i]]=0;
			for(j=1;j<=srnd_num[can_nst[i]];j++) 
			    arrow[can_nst[i]*CIRCUM+j]=-1;
			if(can_nst[i]==beer[br]) w_break=1;
			break;
		    }
		  }
	       if(div>-1||w_break==1)  break;

		
            }
	    
	    shld_change=0;
	    for(i=1;i<=nst_num;i++){
		vl=value[can_nst[i]];
		if(flt(vl-uppr[can_nst[i]])>0.0 ||flt(vl-lwr[can_nst[i]])<0.0){
		    shld_change=1;
		}
	    }
	    how_out=now_aus;
	    for(h=1;h<=nst_num;h++)
		if(stt[i=can_nst[h]]==0||i==beer[br]){
		    if((flt(value[i]-lwr[i]))<0.0)
			how_out-=flt(lwr[i]-value[i])*cost[i];
		    if((flt(value[i]-uppr[i]))>0.0)
			how_out-=flt(value[i]-uppr[i])*cost[i];
		    if((flt(value[i]+diff[i]*minch1-lwr[i]))<0.0)
			how_out+=flt(lwr[i]-value[i]-diff[i]*minch1)*cost[i];
		    if((flt(value[i]+diff[i]*minch1-uppr[i]))>0.0)
			how_out+=flt(value[i]+diff[i]*minch1-uppr[i])*cost[i];
		}

	    for(i=1;i<=nst_num;i++){
		mark2[can_nst[i]]=0;		        
		diff[can_nst[i]]=0.0;
	    }
	    /*printf("how_out=%f/now_aus=%f\n",how_out,now_aus);*/
	    /*printf("div[%d, out %f],",div,how_out);*/
	    if(flg_out==0||shld_change==1)
		if(abs_f(how_out)<out_min){
		    if((tukatta[beer[br]]==0 || tukatta[beer[br]]>5)
		       && (beer[br]!=div || times[beer[br]]<=2)){
			out_min=abs_f(how_out);
			sonae3=beer[br];
		    }
		    if((tukatta[beer[br]]==0 || tukatta[beer[br]]>10)
		       && (beer[br]!=div || times[beer[br]]<=2)){ 	
			sonae2=beer[br];
		    }
		    if(tukatta[beer[br]]==0
		       && (beer[br]!=div||times[beer[br]]<=2)){
			sonae=beer[br];
		    }
		}
	    if(flg_out==1){
		if(flt(how_out-now_aus)<0.0
		   && (beer[br]!=div || times[beer[br]]<=2)
		   /* && ((tukatta[beer[br]]==0 || tukatta[beer[br]]>2)
           	      || (tukatta[beer[br]]==2 && times[beer[br]]<=2))*/){
		    chosen=beer[br];
		    break;
		}
		else if(sonae!=0) 	chosen=sonae;
		else if(sonae2!=0)	chosen=sonae2;
		else if(sonae3!=0)	chosen=sonae3;	
		else 			chosen=0;
	    }
	    else{
		now_aus=0.0;
		if(atr[beer[br]]==0 && atr[div]==1){
		    chosen=beer[br];
		    break;
		}
		else if(atr[beer[br]]==atr[div] && flt(cmp)<0.0){
		    chosen=beer[br];
		}	
		else 	chosen=sonae;
	    }
	}
    }
    /*printf("exchange 1 to choice=%d(%d) started !!\n",chosen,atr[chosen]);*/
    if(chosen==0){
	shows_value();
	printf("failure\n");
	waitme();
    }

/******	When no change black rangle .vs. any white is available in he    ****/ 
/****** feasibility body is available, approximate the structural values ****/ 
/****** and test if feasible value can be attained by this process.	 ****/ 
    
    return(chosen);
}


int trial_sub(int choice){
    int i, j, now, div, slk, lk;
    slk=choice;
    now=0;
    for(i=1;i<=nst_num;i++){
	node=can_nst[i];
	for(j=1;j<=srnd_num[node];j++){
	    lnk_of_nst[link[node*CIRCUM+j]]=0;
	}
    }
    can_nst[1]=choice;
    mark2[choice]=1;
    nst_num=1;
    nst_th[choice]=1;
    while(now<nst_num){
	/** Generate Nest including non-arrowed nets. **/		
	now++;	
	node=can_nst[now];
	for(i=1;i<=srnd_num[node];i++){
	    if(arrow[lk=link[node*CIRCUM+i]]!=2*atr[node]-1){
				/* implies at most only arrows from 'now'.*/
		lnk_of_nst[lk]=1;
		if(mark2[srnd[node*CIRCUM+i]]==0){
		    can_nst[++nst_num]=srnd[node*CIRCUM+i];
		    mark2[can_nst[nst_num]]=1;
		    nst_th[can_nst[nst_num]]=nst_num;
		}
	    }
	}
    }
    div=prpgt(choice);
    return(div);
}

int exchange(int choice){ 
    /*****  As the trial is finished, now we execute the change selected ***/
    /***** above. 							 ***/
		
    int i, j, div, now, stop, jdg_apr, tr, *apr, *new_rch, *new_abs, *diff_rch,
	*diff_abs, *car_num, *cand_arr, lk,i18,pressed;

    /*diff_rch=(int*)calloc(100,sizeof(int));*/
    diff_rch=(int*)malloc(sizeof(int));
    diff_abs=(int*)malloc(sizeof(int));
    car_num=(int*)malloc(sizeof(int));
    cand_arr=(int*)malloc(STRUCT*sizeof(int));
    new_rch=(int*)malloc(STRUCT*sizeof(int));
    new_abs=(int*)malloc(SLACK*sizeof(int));
    in_ex=1;
    *diff_rch=0;
    *diff_abs=0;
    div=trial_sub(choice);
	
    if(choice==div)
	times[choice]++;
/*    printf("choice[%d] %d, div[%d] %d\n",atr[choice],choice,atr[div],div);*/
    if(see_graph<2){
	for(i=1;i<=nst_num;i++){
	    for(j=1;j<=srnd_num[can_nst[i]];j++)
		if(lnk_of_nst[link[can_nst[i]*CIRCUM+j]]){
		    draws_line(can_nst[i],srnd[can_nst[i]*CIRCUM+j],1);
		}		
	     }			
	for(i=1;i<=nst_num;i++)	draws_node(can_nst[i]);
	XFlush(d);
    }
/*  shows_change();*/
    if(see_graph<2){
            draws_bg();
/* IF THE RED LINES OF ACTIVE PART IS WANTED, DO getchar() BELOW.*/
	    XFlush(d);
	    while(1){
		XNextEvent(d, &e);
		pressed=0;
		switch(e.type){
		case Expose :
		    draws_bg();
		    shows_graph(x_goal,y_goal);
		     break;	
		case ButtonPress :
		    XClearWindow(d,w);
		    draws_bg();
		    if(e.xany.window == right_w) shows_graph(x_goal+=100,y_goal);
		    if(e.xany.window == left_w) shows_graph(x_goal-=100,y_goal);
		    if(e.xany.window == up_w) shows_graph(x_goal,y_goal-=100);
		    if(e.xany.window == down_w) shows_graph(x_goal,y_goal+=100);
		    if(e.xany.window == next_w){
			shows_graph(x_goal,y_goal);
			pressed=1;
		    }
		    if(e.xany.window == exit_w) exit(1);
		     break;
		}
		     if(pressed==1) break;
	    }    
	    for(i=1;i<=nst_num;i++){
		for(j=1;j<=srnd_num[can_nst[i]];j++)
		   if(lnk_of_nst[link[can_nst[i]*CIRCUM+j]]){
		       draws_line(can_nst[i],srnd[can_nst[i]*CIRCUM+j],0);
		   }					
	    }
    }
    for(i=1;i<=nst_num;i++)
	mark2[can_nst[i]]=0;

    /*** find the node to reach an integer value  **/
    stt[choice]=0;
    stt[div]=1;	
    /*****  As the trial is finished,now we execute the selected change ***/
    for(i=1;i<=nst_num;i++){
	node=can_nst[i];
	for(j=1;j<=srnd_num[node];j++){
	    if(lnk_of_nst[lk=link[node*CIRCUM+j]]==1){
		if(atr[node]==1&&arrow[lk]==-1){
		    out_arr[node]-=1;
		    in_arr[srnd[node*CIRCUM+j]]-=1;
		}
		if(atr[node]==0&&arrow[lk]==-1){
		    in_arr[node]-=1;
		    out_arr[srnd[node*CIRCUM+j]]-=1;
		}
		arrow[lk]=0;
		lnk_of_nst[lk]=0;/*Initialize links*/
	    }
	}
    }
    flg_out=0;
    for(i=1;i<=nst_num;i++){
	node=can_nst[i];
	if(stt[node]==0||node==div){
	    if((flt(value[node]-lwr[node]))<0.0)
		now_aus-=abs_f(lwr[node] -value[node])*cost[node];
	    if((flt(value[node]-uppr[node]))>0.0)
		now_aus-=abs_f(value[node]-uppr[node])*cost[node];
	    value[node]+=diff[node]*min_ch;
/*	    if(node==38) printf("value[38]=%f,diff[38]=%f",value[38],diff[38]);	*/
	    if((flt(value[node]-lwr[node]))<0.0)
		now_aus+=abs_f(lwr[node] -value[node])*cost[node];
	    if((flt(value[node]-uppr[node]))>0.0)
		now_aus+=abs_f(value[node]-uppr[node])*cost[node];
	}
    }

    if(flt(now_aus)>0.0)      	flg_out=1;
    else	       		now_aus=0.0;

    for(i=1;i<=nst_num;i++){
	node=can_nst[i];
	if(atr[node]==1&&(flt(value[node]-1.0)==0.0||flt(value[node])==0.0)){
	    stt[node]=1;
	    new_rch[++*diff_rch]=node;
	}
	if(atr[node]==0&&stt[node]==0)
	    new_abs[++*diff_abs]=node;
    }
    
    if(flg_out==1){		
	jdg_apr=approx(new_rch,new_abs,diff_rch,diff_abs);
	if(jdg_apr==0){
	    /*****  In the case of feasible after approximation, **********/
	    printf("appr worked\n");
	    outputs();
	}
    }
    for(i=1;i<=*diff_rch;i++)	cand_arr[i]=new_rch[i];
    for(i=1;i<=nst_num;i++) 	mark1[can_nst[i]]=0;
    *car_num=*diff_rch;
    arrow_sub(cand_arr,car_num);

    for(i=1;i<=*diff_abs;i++)	cand_arr[i]=new_abs[i];
    *car_num=*diff_abs;
    arrow_back(cand_arr,car_num);
    in_ex=0;
    if(see_graph<2){
	for(i=1;i<=nst_num;i++) 	draws_node(can_nst[i]);
	XFlush(d);
    }
/*    printf("div%d=[%d],%f\n",div,stt[div],value[div]);*/
    free(diff_rch);
    free(diff_abs);
    free(car_num);
    free(cand_arr);
    free(new_rch);
    free(new_abs);
    return(div);
}

int prpgt(int choice){
    int div, i, j, h, g, end, erst, erst_th,dead;
    double *reach, *flow;
	
    reach=(double*)malloc(GROUP*NEST*sizeof(double));
    flow=(double*)malloc(GROUP*NEST*sizeof(double));
				
    if(atr[choice]==0) 	erst_th=2;
    else 	   	erst_th=1;
    
    while(1){
	erst=can_nst[erst_th++];
	if(atr[erst]==1){
	    dead=simpl2(flow,reach,erst,choice);
	    if(dead==0) break;
	}
        if(erst_th>nst_num)	    return(-1);
   }
/*
    for(g=1;g<=grp_num;g++)
	for(h=1;h<=nst_num;h++){
	    if(in_ex==1)
		printf("(erst %d)flow[%d,%d]=%f\n",
		       erst,g,can_nst[h],flow[g*NEST+h]);
	}
*/
    solves(reach);
    slct_wh(flow);            /** selecting div **/
    div=selects(choice);      /** selected div **/
    compare(choice,div);      /** compare and selsect thebest choice **/
    if(in_ex==1 && atr[div]==0 &&
       (flg_out==0 && flt(cmp)==0.0) || flg_out==1){
	div=divc;
	min_ch=minch1;
    }

    /*printf("min_ch=%fapprminch1=%f\n",min_ch,minch1);*/
    free(reach);
    free(flow);
    return(div);
}

void compare(int choice, int div){
    /* The followings are checked.  */
    /* 1. How far the current point is transporting out of the body if any. */
    /* 2. If the cost or integer degree decreases or not. */

    int i;
    double dif_nrm;

    /*printf("         compare jointed\n");*/
    dif_nrm=0;
    for(i=1;i<=nst_num;i++){
	node=can_nst[i];	
	if(stt[node]==0||node==choice){
	    if(atr[div]==0){
		if(atr[node]==1){
		    dif_nrm
			+=abs_f(0.5-value[node])
			-abs_f(0.5-(value[node]+diff[node]*min_ch));
		    cmp=dif_nrm;
		}
	    }
	}	
    }
    return;
}

int approx(int *new_rch, int *new_abs, int *diff_rch, int *diff_abs){
    int sr, sri, i, jdg_apr, s, t, m, node, *sumi, violants, *violate;
    double *apr_sl;
	
    apr_sl=(double*)malloc(ALL*sizeof(double));
    violate=(int*)malloc(STRUCT*sizeof(int));
    sumi=(int*)malloc(ALL*sizeof(int));
    for(i=1;i<=ttl_node;i++) sumi[i]=0;
    violants=0;
    for(s=1;s<=ttl_node;s++)
	if(atr[s]==0){
	    apr_sl[s]=0.0;
	    if((flt(value[s]-uppr[s])>0.0)||(flt(value[s]-lwr[s])<0.0))
		for(i=1;i<=srnd_num[s];i++){
		    if(sumi[sri=srnd[s*CIRCUM+i]]!=1){
			violate[++violants]=sri;
			sumi[sri]=1;
                    }
		}
	}
    
    for(i=1;i<=violants;i++){
	node=violate[i];
	for(t=1;t<=srnd_num[node];t++){
	    sri=srnd[node*CIRCUM+t];
	    apr_sl[sri]=value[sri];
	}
    }

    for(i=1;i<=violants;i++){
	node=violate[i];
	if(value[node]<0.5)	apr_sl[node]=0.0;
	else			apr_sl[node]=1.0;
	for(t=1;t<=srnd_num[node];t++){
	    apr_sl[srnd[node*CIRCUM+t]]
		+=rel[node*CIRCUM+t]*(apr_sl[node]-value[node]);
	}
    }
	
    jdg_apr=0; 
    for(i=1;i<=violants;i++){
	node=violate[i];
	for(t=1;t<=srnd_num[node];t++){
	    sri=srnd[node*CIRCUM+t];
	    if(flt(apr_sl[sri]- lwr[sri])<0.0
	       || flt(apr_sl[sri]-uppr[sri])>0.0){	  
		jdg_apr=1;
	    }
	}
    }
	
    if(jdg_apr==0){
	for(t=1;t<=violants;t++){
	    node=violate[t];
	    value[node]=apr_sl[node];	
	    for(i=1;i<=srnd_num[node];i++){
		sri=srnd[node*CIRCUM+i];
		value[sri]=apr_sl[sri];
	    }
	}
	flg_out=0;
	now_aus=0.0;
	for(i=1;i<=nst_num;i++){
	    node=can_nst[i];
	    if(atr[node]==1&&(flt(value[node])==1.0||flt(value[node])==0.0)){
		stt[node]=1;
		new_rch[++*diff_rch]=node;
	    }
	    if(atr[node]==0&&stt[node]==0)
		new_abs[++*diff_abs]=node;
	}	
    }
    return(jdg_apr);
}

void shows_value(){
    int k, i, j;
    double v;
    k = 0;
    gstep();

    for(i=1;i<=ttl_node;i++){
	if(++k==10){
	    gstep();
	    k=0;
	}
	printf("%d%dvalue[%d](%f<<%f)=%f=",
	       atr[i], stt[i], i, lwr[i], uppr[i], value[i]);
	if(atr[i]==0)
	    for(j=1;j<=srnd_num[i];j++)
		printf("+%f[%d]",-1.0/rel[i*CIRCUM+j]*value[srnd[i*CIRCUM+j]],
		       srnd[i*CIRCUM+j]);
	v=0;
	for(j=1;j<=srnd_num[i];j++){
	    v+=-1.0/rel[i*CIRCUM+j]*value[srnd[i*CIRCUM+j]];
	}
	printf("\n");
    }
    gstep();
    return;
}

void shows_value2(){
    int k, i, j, n;
    double v;
    k=0;
    gstep();
	
    for(n=1;n<=nst_num;n++){
	i=can_nst[n];
	if(++k==10){
	    gstep();
	    k=0;
	}
	printf("%d%dvalue[%d](%f<<%f)=%f=",
	       atr[i], stt[i], i, lwr[i], uppr[i], value[i]);
	if(atr[i]==0)
	    for(j=1;j<=srnd_num[i];j++)
		printf("+%f[%d]",-1.0/rel[i*CIRCUM+j]*value[srnd[i*CIRCUM+j]],
		       srnd[i*CIRCUM+j]);
	v=0;
	for(j=1;j<=srnd_num[i];j++){
	    v+=-1.0/rel[i*CIRCUM+j]*value[srnd[i*CIRCUM+j]];
	}
	printf("\n");
    }
    gstep();
    return;
}

void shows_change(){
    int k, i, j, n;
    gstep();
    k=0;
    printf("nst_num=%d\n",nst_num);
    for(n=1;n<=nst_num;n++){
	i=can_nst[n];
	if(++k==10){
	    gstep();
	    k=0;
	}
	printf("[%d]:+%f*%f=%f\n",i,diff[i],min_ch,value[i]);
    }
    gstep();
}

void impr(){
    int i, j, k, m, sl, now, sncnd_num, son, pa1, pa2, *bottom, btm_num,
	*son_cand, ok, *pointed, *alrdy, see;

    son_cand=(int*)malloc(STRUCT*CIRCUM*sizeof(int));
    alrdy=(int*)malloc(ALL*sizeof(int));
    bottom=(int*)malloc(STRUCT*sizeof(int));
    pointed=(int*)malloc(SLACK*sizeof(int));
    printf("The solution is being improved...\n");
    btm_num=0;
    see=0;
   
    for(i=1;i<=ttl_node;i++){
	pointed[i]=0;
	alrdy[i]=0;
	if(srnd_num[i]==papa_num[i]){
	    bottom[++btm_num]=i;
	}	
    }
    gstep();
    
    for(i=1;i<=btm_num;i++){
	if(see) printf("***** bottom is %d ***********\n",bottom[i]);
	sncnd_num=1;
	son_cand[1]=bottom[i];
	now=0;
	if(flt(value[bottom[i]]-1.0)==0.0){
	if(see) printf("***** bottom is TRUE (%f)\n",value[bottom[i]]);
	    ok=1;
	    while(now<sncnd_num){
		if(flt(value[son_cand[++now]]-1.0)==0.0) son=son_cand[now];
		if(see==1) 
		    printf("%d{%d<%d}>%d\n",son_cand[1],now,sncnd_num,son);
		for(j=1;j<=papa_num[son];j++){
		    pa1=papa[son*CIRCUM+j];
		    if(see==1) 	printf("(%d)%d>>%d\n",j,son,pa1);
		    if(see_graph<2){		    
			draws_line(son,pa1,2);
                        XFlush(d);
		    }
		    pointed[pa1]++;
		    for(k=2;k<=srnd_num[pa1];k++) 	
			alrdy[srnd[pa1*CIRCUM+k]]=0;
		    if(flt(value[pa1]+1.0*pointed[pa1]-uppr[pa1])>0.0){
			pa2=papa[pa1*CIRCUM+1];
			if(see==1)
		          printf("(%d)%d>>%d [Since %d pointed by %d links]\n",
				   j, pa1,pa2, pa1, pointed[pa1]);	
			if(see_graph<2){
			    draws_line(pa2,pa1,2);
			    XFlush(d);
			}
			if(alrdy[pa2]==0&&flt(value[pa2]-1.0)==0.0&&pa2!=goal){
			    if(see==1) 	printf("add %d\n",pa2);
			    alrdy[pa2]=1;
			    son_cand[++sncnd_num]=pa2;
			}
			else{
			    if(see==1){ 
				printf("*** give up ***(alr[%d]:%d,v%f)\n",
				      pa2,alrdy[pa2],value[pa2]);
				if(see_graph<2){
				    draws_line(pa1,pa2,3);
				    XFlush(d);
				    gstep();
				}
			    }
			    ok=0;
			    break;
			}			
		    }
		}
		if(ok==0) break;
	    }
	    for(j=1;j<=sncnd_num;j++) 	alrdy[son_cand[j]]=0;
	    if(ok==1){
		if(see==1){
		    printf("***************\n");			  
		    gstep();
		}
		for(j=1;j<=sncnd_num;j++){
		    value[sl=son_cand[j]]=0.0;
		    if(see==1) printf("zero set %d\n",sl);
		    for(k=1;k<=srnd_num[sl];k++) {
			value[srnd[sl*CIRCUM+k]]-=rel[sl*CIRCUM+k];
		    }
		}
	    }
	    for(j=1;j<=sncnd_num;j++){
		if(son_cand[j]!=goal)	  
		    for(m=1;m<=papa_num[son_cand[j]];m++)
			pointed[papa[son_cand[j]*CIRCUM+m]]=0;
            }
        }
    }
    printf("END AS SUCCESS\n");
    return;
}
	 
int simpl2(double *flow, double *reach, int erst, int choice){
    /** Reduction from areas into groups  **/
    int i, j, h, node1, sri, *nd1_cand, *in, nd1_num, end, grp, sm2_end,
	lk, *mark3, min_rm, *cand,node, *alrdy, *alr_can, k, stt_1;
	
    in=(int*)malloc(ALL*sizeof(int));
    cand=(int*)malloc(STRUCT*sizeof(int));
    nd1_cand=(int*)malloc(STRUCT*CIRCUM*sizeof(int));
    alrdy=(int*)malloc(ALL*sizeof(int));
    alr_can=(int*)malloc(ALL*sizeof(int));
    mark3=(int*)malloc(NEST*CIRCUM*sizeof(int));
    /* Already check of links as candidates */
    /*printf("         simpl2 jointed,erst=%d,choice=%d\n",erst,choice);*/
    stt[choice]=0;
	        /*****  the initial area of the initial group is defined. ***/
                /****  the initial node for each group is node1. ***/	
    grp=0;	/*** the first group is grp=0  ***/
    nd1_num=1; 	/*** nd1_num,the candidates for node1 to begin the next group*/
    sum=-1;	/*** sum is the total number of areas ever passed through*/
    nd1_cand[1]=erst;
		/*** the first node1 is node1=erst (necessarily strctr) ***/
    for(i=1;i<=nst_num;i++){
	node=can_nst[i];
	alrdy[node]=alr_can[node]=0;
	in[node]=in_arr[node];
	if(atr[node]==0)
	    for(j=1;j<=srnd_num[node];j++){
		if(lnk_of_nst[lk=link[node*CIRCUM+j]]==1 && arrow[lk]==-1){
		    in[node]-=1;
		}
	    }
    }
    end=0;	
    sm2_end=0;
    min_rm=CIRCUM;
    for(i=1;i<=link_num;i++) mark3[i]=0;
    while(1){
	sm2_end=1;
	for(i=1;i<=nd1_num;i++){
	    /** find the initial area not passed yet.**/
	    if(alrdy[nd1_cand[i]]==0){
		node1=nd1_cand[i];
		sm2_end=0;
		break;
	    }
	}
	if(sm2_end==1)   break;
	grp_num=++grp;
	for(j=1;j<=grp-2;j++) reach[grp*NEST+j]=0.0;
	for(h=1;h<=nst_num;h++){
	    flow[grp_num*NEST+h]=0.0;
	    rate[grp_num]=0.0;
	}
    	core[grp]=node1;	/*** the core, the root node of next gorup **/
	flow[grp*NEST+nst_th[node1]]=1.0;
	nxt=0; 		/*** 'nxt' is the count of passed areas in the group**/
	cand_num=1;			
	alr_can[node1]=1;
	cand[1]=node1; 		/** the initial area is set .**/
	while(nxt<cand_num)
	    if(alrdy[cand[++nxt]]==0){
		node=cand[nxt];
/*if(in_ex==1&&cycle_num==18) printf("-[%d]",node);*/
		alrdy[node]=1;		/** the next passing area is added.**/
		sum+=2;	/* sum increases by 2 (1 triangle + 1 circle)per step*/
		for(i=1;i<=srnd_num[node];i++){
		    /** the surrounding areas**/ 
		    if(mark2[sri=srnd[node*CIRCUM+i]]==1 && 
		       mark3[link[node*CIRCUM+i]]==0){
			mark3[link[node*CIRCUM+i]]=1;
			if(stt[sri]==1&&in_ex==1&&see_graph<2){
			    draws_line(node,srnd[node*CIRCUM+i],2);
			    XFlush(d);
			}
			for(j=1;j<=grp;j++){
			    /** for the flows from passed groups**/
			    flow[j*NEST+nst_th[sri]]
				+=flow[j*NEST+nst_th[node]]*rel[node*CIRCUM+i];
/*if(in_ex==1&&cycle_num==18) printf("-%d",sri);*/
			}
			in[sri]++;
			if(stt[sri]==1&&in[sri]==srnd_num[sri]-1){
			    for(k=1;k<=srnd_num[sri];k++){
				if(alrdy[srnd[sri *CIRCUM+ k]]==0
				   && mark2[srnd[sri *CIRCUM+ k]]==1
				   && alr_can[srnd[sri *CIRCUM+ k]]==0){
				    mark3[link[sri*CIRCUM+k]]=1;
				    if(in_ex==1&&see_graph<2){
					draws_line(sri,srnd[sri*CIRCUM+k],2);
					XFlush(d);
					if(in_ex==1&&cycle_num==4) gstep();
				    }
				    for(j=1;j<=grp;j++){
					flow[j*NEST+nst_th[srnd[sri*CIRCUM+k]]]
					    +=flow[j*NEST+nst_th[sri]]*rel[sri*CIRCUM+k];
/*if(in_ex==1&&cycle_num==18) printf("+%d",srnd[sri*CIRCUM+k]);*/
				    }
				    break;
				}  
			    }
			    cand[++cand_num]=srnd[sri *CIRCUM+ k];
			    alr_can[cand[cand_num]]=1;
			}
	/**** cand is the candidate of the nxt area in the same group ***/
			if(stt[sri]==1&&in[sri]==srnd_num[sri]){
			    end++;
			    sum++;
			    if(grp-1<end){
				stt[choice]=1;
/*			printf("[choice %d],erst %d dead on %d, grp %d end %d\n",
				       choice,erst,sri,grp,end);*/

				return(sri);
			    }
			    else for(j=1;j<=grp;j++){
				reach[j*NEST+ end]=flow[j*NEST+nst_th[sri]];
			    }
			}
			if(stt[sri]==1&&in[sri]<=srnd_num[sri]-2){
			    for(j=1;j<=srnd_num[sri];j++){
				if(alrdy[srnd[sri*CIRCUM+j]]==0
				   && mark2[srnd[sri *CIRCUM+ j]]==1)
				    nd1_cand[++nd1_num]=srnd[sri*CIRCUM+ j];
			    }
			}
		    }
		}
     /**** nd1_cand is the candidate of the initial area in the nxt group ***/
	    }
    }
    stt[choice]=1;
    free(in);
    free(cand);
    free(nd1_cand);
    free(alrdy);
    free(alr_can);
    free(mark3);
    return(0);
}

void solves(double *reach){
    int i, j, k, dark_arr;
    double others, r;

    /*printf("grp_num=%d\n",grp_num);*/
    if(grp_num>=2){
	for(i=1;i<=grp_num-1;i++){
	    for(j=1;j<=grp_num-1;j++)if(i!=j){
		if(flt(reach[i*NEST+i])!=0.0)
		    r=reach[i *NEST+ j]/reach[i *NEST+ i];
		else r=0.0;
		for(k=1;k<=grp_num;k++){
		    reach[k *NEST+ j]-=r*reach[k *NEST+ i];
		}
	    }
	}
	rate[grp_num]=1.0;
	dark_arr=0;
	for(j=1;j<=grp_num-1;j++) 
	    if(flt(reach[j*NEST+j])==0.0) dark_arr=1;
	if(dark_arr==0)
	    for(j=1;j<=grp_num-1;j++){
		if(flt(reach[j*NEST+j])!=0.0)
		    rate[j]=-1.0*reach[grp_num *NEST+ j]/reach[j *NEST+ j];
		else rate[j]=0.0;
	    }
	else{
	    for(j=1;j<=grp_num-1;j++) 
		if(flt(reach[j*NEST+j])==0.0) 
		    rate[j]=1.0;
	    rate[grp_num]=0.0;
	}
    }
    else rate[1]=1.0;
    return;	
}

void slct_wh(double *flow){
    int count, g, h;	
        
    for(h=1;h<=nst_num;h++) diff[can_nst[h]]=0.0;
    for(g=1;g<=grp_num;g++){
	for(h=1;h<=nst_num;h++){
	    diff[can_nst[h]]+=flow[g*NEST+h]*rate[g];
/* 	    if(in_ex==1)
		printf("%d, diff[%d]=%f, flow=%f, rate[%d]=%f\n",g,can_nst[h],
		       diff[can_nst[h]], flow[g*NEST+h], g, rate[g]);
*/		       
	}
    }
    return;
}

double abs_f(double x){
    double y;
    if(x<0.0) y=-1.0*x;
    else      y=x;
    return(y);
}

int abs_i(int x){
    int y;
    if(x<0) y=-1*x;
    else      y=x;
    return(y);
}

int selects(int choice){
    int i, k, n, cnt_wh, cnt_wc, div, br, *stnby;
    double direct, *want;
	
    stnby=(int*)malloc(10*sizeof(int));
    want=(double*)malloc(ALL*sizeof(double));         /*10K*/
    /* want is the wanted additional value to each */
    /* node to be non-basic */
    cnt_wh=0;
    cnt_wc=0;
    min_ch=100000.0;
    minch1=100000.0;
    /*for(i=1;i<=ttl_node;i++) printf("diiff[%d]=%f\n",i,diff[i]);*/

    direct=(value[choice]-0.5*(uppr[choice]+lwr[choice]))/diff[choice];
    /* If direct is +, values of nodes with diff>0 must decrease */ 
    for(i=1;i<=nst_num;i++){
	n=can_nst[i];
	if(stt[n]==0||choice==n){
	    if(flt(direct*diff[n])<=0.0)
		/** if the strctr must increase **/
	        /** want is the wanted change of n **/
		want[n]=uppr[n]-value[n];
	    else   want[n]=lwr[n]-value[n];
		/* if this is the first white checked, or   */
		/* if the effect to the choice is the least ever */

	    if(flt(diff[n])!=0.0 &&
	       (++cnt_wh==1||abs_f(want[n]/diff[n])<=abs_f(min_ch))){
		div=n;  		/** div xis the best white of all*/
		/*printf("%d,",div);*/
		min_ch=want[n]/diff[n];
	    }			
	    if(flt(diff[n])!=0.0&&atr[n]==1/** if the node is circle,and if**/
	       &&(cnt_wc==0||abs_f(want[n]/diff[n])<=abs_f(minch1))){
		++cnt_wc;
		divc=n;
		/** div is the best white of circle*/
		minch1=want[n]/diff[n];
	    }
	}
    }
    if(flt(abs_f(min_ch)-abs_f(minch1))==0.0){
	div=divc;
    }
    return(div);
}

void input_newversion(int *strth, int *slkth, char **argv, int argc){
    int or, ch, *c, i, j, common, *rght, left, one_wrd, *inv, *queried,
	*ichbn, *nd_br, *lft_hstry, skip_line, *replied, exist_read_line,*cost_defined, 
        line, found, *common_1, c_pow,incs,*contradict, *inc_array, inc_line,cost_defining;
    double ex_depth;

    common_1=(int*)malloc(sizeof(int));
    c=(int*)malloc(sizeof(int));
    inv=(int*)malloc(sizeof(int));
    queried=(int*)malloc(ALL*sizeof(int));
    cost_defined=(int*)malloc(ALL*sizeof(int));
    replied=(int*)malloc(ALL*sizeof(int));
    nd_br=(int*)malloc(STRUCT*100*sizeof(int));
    rght=(int*)malloc(10*sizeof(int));
    lft_hstry=(int*)malloc(SLACK*sizeof(int));
    ichbn=(int*)malloc(SLACK*sizeof(int));
    inc_array=(int*)malloc(RLENGTH*sizeof(int));
    contradict=(int*)malloc(CIRCUM*WORDS*5*sizeof(int));

    ttl_node=0;
    slk_num=0;
    str_num=0;
    and_num=0;
    nd_max=0;
    br_num[0]=0;
    bnk=0;
    link_num=0;	
    one_wrd=0;
    ex_depth=1.25;
    skip_line=0;
    inc_line=0;
    cost_defining=0;
    exist_read_line=1;    
    while(exist_read_line){
	if((fp=fopen( argv[1],"r"))==NULL){
	    printf("can't open file %s\t",*argv);
	    exit(1);
	}
	line=1;
	exist_read_line=0;
	while((*c=getc(fp))!='>'&&*c!='!'&&*c!='$'&&*c!=EOF) {
	    if(*c=='\n') line++;
	    if(skip_line==0||*c=='\n') {
		if(see_input)	printf("%c",*c);
		switch (*c){ 
		case '/':
/*		    if(common)
			exit(1);
			*/
		    cost_defined[node]=cost_defining=1;
		    c_pow=0;
		    the_cost[node]=0;
		    break;
		case '\n':
		    if(inc_line){
			for(i=1;i<=incs;i++)for(j=1;j<=incs;j++)if(j!=i)
			   contradict[inc_array[i]*CIRCUM+(++cont_num[inc_array[i]])]
				=inc_array[j];
			inc_line=0;
		    }
		    ex_depth*=0.8;
		    if(skip_line){
			skip_line=0;
			node=0;
			break;
		    }
		    period(ichbn,left,rght,right_num,ex_depth,common_1);
		    node=0;
		    break;
		    
		case ':': break;
		case ' ': break;
		case '\t': break;
		case '-':
		    right_num=0;
		    if(*inv==0) one_wrd=0;
		    if((queried[node]==0||replied[line]==1)
		       && (one_wrd!=1||replied[line]==1)){
			skip_line=1;
			break;
		    }
		    else{
			replied[line]=1;
			exist_read_line=1;
		    }
		    left=hihn(common,chld,chld_num,lft_bnk,lft_hstry,ichbn);
		    if(one_wrd==1){				
			if(*inv==2){
			    goal=leaf[node];
			    uppr[goal]=1.0;
			    lwr[goal]=1.0;
			    is_goal[goal]=1;
			}	      
			else if(*inv==1) {
			    inc_line=1;
			    inc=leaf[node];
			    uppr[inc]=0.0;
			    lwr[inc]=0.0;
			    is_inc[inc]=1;
			    incs=0;
			}
		    }  
		    one_wrd=0;
		    cost_defining=0;
		    node=0;
		    break;
		case ',':
		case '.':
		    if(inc_line) inc_array[++incs]=node;
		    queried[node]=1;
		    if(cost_defining){
			the_cost[node]*=powint(10,c_pow);
		    }
		    if(cost_defined[node]==0) the_cost[node]=1.0;
		    collon(common,common_1,left,rght);
		    node=0;
		    cost_defining=0;
		    one_wrd=0;   		
		    break;
		default:
		    if(cost_defining){
			the_cost[node]+=(*c-48)*1.0/powint(10,++c_pow);
		    }
		    else{
			*inv=0;  
			found=search(nd_br,c,inv);
			if(found==0){
			    cost_defined[node]=0;
			    queried[node]=0;
			    replied[node]=0;
			}
			common=queried[node];
			one_wrd++;
		    }
		}
	    }
	}
	fclose(fp);
    }

/*Below,those nodes appeared in the left sides before are treated as'lft_bnk'*/

    for(i=1;i<=bnk;i++)
	if(is_inc[lft_bnk[i]]==0){
	    and_chlds[lft_bnk[i]]=0;
	    or=new_slack(chld_num[lft_bnk[i]]+1,0.0,-100.0);
	    bound[ttl_node]=2;
	    relative(or,lft_bnk[i],1,(++srnd_num[lft_bnk[i]]),-1.0);
	    papa[or*CIRCUM+(papa_num[or]=1)]=srnd[or*CIRCUM+1];
	    /* Above 4 lines refers to   OR slack .VS. the left bank */   
	    for(j=1;j<=chld_num[lft_bnk[i]];j++){
		ch=chld[lft_bnk[i]*CIRCUM+j];
		new_slack(2,100.0,0.0);
		bound[ttl_node]=0;
		/* Above, child nodes and completeness nodes are defined */
		relative(lft_bnk[i],ttl_node,++srnd_num[lft_bnk[i]],1,1.0);
		/* Above 4 lines refers to completeness slack.VS. left banks */
		relative(ch,or,++srnd_num[ch],j+1,-1.0);
		papa[ch*CIRCUM+(++papa_num[ch])]=or;
		/* Above 4 lines refers to OR slack.VS. children ***/   
		relative(ch,ttl_node,++srnd_num[ch],2,-1.0);
		papa[ttl_node*CIRCUM+(papa_num[ttl_node]=1)]=lft_bnk[i];
		papa[ch*CIRCUM+(++papa_num[ch])]=ttl_node;	
		/* Above 4 lines referpps to completeness slack.VS.children */ 
		/* OR's constraints are y>=any x, y<=sum of all x. */
	    }
	}
    
    for(i=1;i<=slk_num;i++)	slkth[slack[i]]=i;
    for(i=1;i<=str_num;i++)	strth[strctr[i]]=i;
    for(i=1;i<=str_num;i++){
	atr[strctr[i]]=1;
	if(is_inc[strctr[i]]==0&&is_goal[strctr[i]]==0){
	    uppr[strctr[i]]=1.0;
	    lwr[strctr[i]]=0.0;
	}
    }
    for(i=1;i<=slk_num;i++)	atr[slack[i]]=0;
    for(i=1;i<=str_num;i++)	bound[strctr[i]]=1;
    if((fp=fopen( argv[1],"r"))==NULL){
	printf("can't open file %s\t",*argv);
	exit(1);
    }
    if(*c!=EOF) insisted(inc_array, contradict, nd_br, fp,the_cost);
    fclose(fp);
    free(c);
    free(queried);
    free(inv);
    free(nd_br);
    free(rght);
    free(lft_hstry);
    free(ichbn);
    return;
}

int search(int *nd_br, int *c, int *inv){
    int common,i;	
    *inv=0;
    common=0;
    for(i=1;i<=br_num[node];i++){
	if(lttr[nd_br[node*CIRCUM+i]]==*c){
	    common=1;
	    node=nd_br[node*CIRCUM+i];
	    break;
	}
    }
				
    if(common==0){
	nd_br[node*CIRCUM+(++br_num[node])]=++nd_max;
	cont_num[nd_max]=0;
	br_num[nd_max]=0;
	sugu_ue[nd_max]=node;
	node=nd_max;
	lttr[nd_max]=*c;
    }
    if(*c=='0') *inv=1;
    if(*c=='1') *inv=2;
    return(common);
}


void insisted(int *inc_array, int *contradict, int *nd_br,FILE *fp,double *the_cost)
{
	int *inv,*c,spot,i,j,ins,*ins_node,cost_defining,c_pow;
	ins_node=(int*)malloc(10*sizeof(int));
	inv=(int*)malloc(sizeof(int));
	c=(int*)malloc(sizeof(int));
/*	if(fp==NULL){
	    printf("can't open file %s in zero_spot \t",*argv);
	    exit(1);
	}
*/	
	if(see_input)	printf("********** INSTIST ***********\n");
	for(i=1;i<=ttl_node;i++) focus[i]=0;
	while((*c=getc(fp))!=EOF) {
	switch(*c){
	  case '$':
	    node=0;
	    cost_defining=0;
	    while((*c=getc(fp))!='\n'&&*c!=EOF){
		if(see_input)	printf("%c",*c);
		switch(*c){
			case '/': 
			    cost_defining=1;
			    c_pow=0;
			    the_cost[node]=0.0;
			    break;
			case ',': 
			case '.': 
			    if(cost_defining) the_cost[node]*=powint(10,c_pow);
			    cost_defining=0;	
			    node=0;
			    break;
			default:  
			    if(cost_defining)
			       the_cost[node]+=(*c-48)*1.0/powint(10,++c_pow);
			    else search(nd_br,c,inv);				
		}
	    }
	    break;
	  case '>':
	    node=0;
	    while((*c=getc(fp))!='\n'&&*c!=EOF){
		if(see_input)	printf("%c",*c);
		switch(*c){
			case ',': 
			case '.': 
			          focus[spot=leaf[node]]=1;
				  if(see_input) printf("(%d)\n",leaf[node]);
				  node=0;
				  break;
			default:  search(nd_br,c,inv);				
		}
	    }
	    break;
	  case '!':
	     node=0;
	     ins=0;
             while((*c=getc(fp))!='\n'&&*c!=EOF){
		 if(see_input)	printf("%c",*c);
		switch(*c){
			case ',': 
			case '.': ins_node[++ins]=node;
			          if(see_input)	  printf("(%d)\n",leaf[node]);
				  node=0;
/*				  if(see_input)	 printf("cont_num: %d\n",cont_num[ins_node[1]]);*/
				  break;
			default:  search(nd_br,c,inv);				
		}
	      }	
	    for(i=1;i<=ins;i++)for(j=1;j<=cont_num[ins_node[i]];j++){
		the_cost[contradict[ins_node[i]*CIRCUM+j]]=1000000.0;
/*		printf("%d put, %d negated\n",
		       ins_node[i],contradict[ins_node[i]*CIRCUM+j]);
*/
	    }
	  }
	}
	free(inv);
	free(c);
	return;
}

void relative(int a, int b, int b_of_a, int a_of_b, double rateab){
    double rateba;
	
    rateba=-1.0/rateab;
    srnd[a*CIRCUM+b_of_a]=b;
    rel[a*CIRCUM+b_of_a]=rateab;
    srnd[b*CIRCUM+a_of_b]=a;
    rel[b*CIRCUM+a_of_b]=rateba;
    link[a*CIRCUM+b_of_a]=link[b*CIRCUM+a_of_b]=++link_num;
    /*if(a==3 || b==3)
	printf("[%d and %d connected by %dth]\n",a,b,b_of_a);*/
    return;
}

int new_strctr(int neighbors){
    int added;
    
    added=strctr[(++str_num)]=++ttl_node;
    rght_sonae[added]=0;

    /*printf("newly %d (str)\n",added);*/
    cost[added]=1.0;
    uppr[added]=1.0;
    lwr[added]=0.0;
    atr[added]=1;
    srnd_num[added]=neighbors;
    is_inc[added]=0;
    is_goal[added]=0;
    if(see_input)    printf("(%d)",added);
    return(added);
}

int new_slack(int neighbors, double up, double lw){
    int added;
    
    added=slack[(++slk_num)]=++ttl_node;
    /*printf("newly %d (slk)\n",added);*/
    uppr[added]=up;
    lwr[added]=lw;
    atr[added]=0;
    srnd_num[added]=neighbors;
    papa_num[added]=chld_num[added]=and_chlds[added]=stt[added]=0;
    if(see_input)    printf("[%d]",added);
    return(added);
}

void period(int *ichbn, int left, int *rght, int right_num, double ex_depth,
	    int *common_1){
    int j, and, ch;

    if(right_num==1&&*common_1==0){
	and_chlds[left]=0;
	leaf[node_1]=left;
	and_left[++and_num]=left;
    }
    else{
	and=new_slack(right_num+1,100.0,1.0-(double)right_num);
	and_chlds[left]=right_num;
	bound[and]=0;
	and_left[++and_num]=left;
	if(ichbn[left]==0)
	    /* ichbn is the first sita neighbor of the left */
	    ichbn[left]=slack[slk_num];
	relative(left,and,++srnd_num[left],1,1.0);
	papa[and*CIRCUM+(papa_num[and]=1)]=srnd[and*CIRCUM+1];
	/***** Above 4 lines refers to   AND slack.VS. the left  ***/   
	for(j=1;j<=right_num;j++){
	    ch=rght[j];
            cost[ch]=cost[left]/right_num;
	    /* For slack cost def. after input()*/
	    and_ch[left*CIRCUM+j]=new_slack(2,0.0,-100.0);
	    bound[ttl_node]=2;		        
	    /*  childs and completenesses  ***/
	    relative(left,ttl_node,++srnd_num[left],1,1.0);  
	    /* completeness.VS. left */   
	    relative(ch,and,++srnd_num[ch],j+1,-1.0);
	    papa[ch*CIRCUM+(++papa_num[ch])]=and;		
	    /*  AND slack.VS. children */   
	    relative(ch,ttl_node,++srnd_num[ch],2,-1.0);
	    papa[ttl_node*CIRCUM+(++papa_num[ttl_node])]=left;
	    papa[ch*CIRCUM+(++papa_num[ch])]=ttl_node;	
	    /*completenes.VS. children */   
	}
    }
    return;
}		

int hihn(int common, int *chld, int *chld_num, int *lft_bnk, int *lft_hstry,
	 int *ichbn){  	
    int i, j, ch, trade, left, and;
	
    if(common==1){
	left=leaf[node];
/*	printf("and_chlds[%d]=%d\n",left,and_chlds[left]);*/
	if(lft_hstry[node]==1&&and_chlds[left]==0){
	}
	if(lft_hstry[node]==1&&is_inc[left]==0){
	    if(chld_num[left]==0){
		/* so that this is the second app. as left*/
		/* chld_num is number of children of left as head of OR rule */
		lft_bnk[++(bnk)]=left;
		/*** the former node becomes the first child's papa ***/
		chld[left*CIRCUM+(++chld_num[left])]
		    =new_strctr(and_chlds[left]+(and_chlds[left]>0));
		/* ttl_node <-> left */

                if(node!=rght_sonae[left])
/*this is need for erase "unseen".*/
                leaf[rght_sonae[left]]=ttl_node;
		for(j=1;j<=srnd_num[left];j++){
		    if(srnd[left*CIRCUM+j]==ichbn[left]){
			relative(ttl_node,ichbn[left],1,1,rel[left*CIRCUM+j]);
			papa[ichbn[left]*CIRCUM+1]=ttl_node;
			link_num-=1;
			link[ttl_node*CIRCUM+1]=link[ichbn[left]*CIRCUM+1]
			    =link[left*CIRCUM+j];
			break;
		    }	
		}
	     /* and_ch is slack node where chld are OR's structural children */
		for(i=1;i<=and_chlds[left];i++){
		    ch=and_ch[left*CIRCUM+i];
		    srnd[ttl_node*CIRCUM+i+1]=ch;
		    papa[ch*CIRCUM+1]=ttl_node;
		    for(j=1;j<=srnd_num[left];j++){
			if(srnd[left*CIRCUM+j]==ch){
			    link[ttl_node*CIRCUM+i+1]=link[left*CIRCUM+j];
			    rel[ttl_node*CIRCUM+i+1]=rel[left*CIRCUM+j];
			    break;
			}	
		    }	
		    and_ch[ttl_node*CIRCUM+i]=ch;
		    for(j=1;j<=srnd_num[ch];j++){
			if(srnd[ch*CIRCUM+j]==left){
			    srnd[ch*CIRCUM+j]=ttl_node;
			    break;
			}
		    }	
		} 
		and_chlds[ttl_node]=and_chlds[left];
		for(i=1;i<=and_num;i++)
		    if(and_left[i]==left)
			and_left[i]=ttl_node;
		bound[left]=0;				
		bound[ttl_node]=0;				
		trade=0;
		for(i=1;i<=srnd_num[left];i++){
		    if(srnd[left*CIRCUM+i]==ichbn[left])
			trade=1;
		    if(trade==1){	
			srnd[left*CIRCUM+i]=
			    srnd[left*CIRCUM+i+1+and_chlds[left]];
			rel[left*CIRCUM+i]=
			    rel[left*CIRCUM+i+1+and_chlds[left]];
			link[left*CIRCUM+i]=
			    link[left*CIRCUM+i+1+and_chlds[left]];
		    }
		}
		srnd_num[left]-=and_chlds[left]+(and_chlds[left]>0);
	    }	
	    /*** the current node becomes the second or some-th child ***/
	    chld[left*CIRCUM+(++chld_num[left])]=new_strctr(0);
	    left=ttl_node;
	}
	else{	
	    lft_hstry[node]=1;
	    ichbn[left]=0;
	}
    }
    else{
	left=new_strctr(0);
	ichbn[left]=0;
	lft_hstry[node]=1;
	chld_num[left]=0;
	leaf[node]=left;
    }
    return(left);
}			

void collon(int common, int *common_1, int left, int *rght){
    switch(++right_num){
    case 1 :
	if(common==1)	 rght[1]=leaf[node];
	else{
	    rght_sonae[left]=node;
	    leaf[rght_sonae[left]]=left;
	}
	*common_1=common;
	node_1=node;
	break;
    case 2 : 
	rght_sonae[left]=0;
	if(*common_1==0)	leaf[node_1]=rght[1]=new_strctr(0);
	if(common==0)    	leaf[node]=rght[2]=new_strctr(0);
	else    		rght[2]=leaf[node];
	break;	
    default : 
	if(common==1)	rght[right_num]=leaf[node];
	else{
	    rght[right_num]=new_strctr(0);
	    leaf[node]=ttl_node;
	}
    }
    return;
}
	
/* In this function, reducive symplex method is neccesary */
/*for many hyper plains cross together.*/
void symplex(int *strth, int *slkth){
    int smp_cyc, i, j, n, piv_w, sri, tate, k, yoko, sl, str, slk, *white, 
        piv_b, amr, ul, v, feasible, geta, tp, *wht, *stay, *are, arere, w,
        *virgin;
    double *tmp_cst, rg, elm, rt, *elmnt, max_opt, min, max, *rgh_end, elm1;

    /* cost translate */

    if(see_input){
	printf("Cost of Hypotheses\n");
    for(i=1;i<=ttl_node;i++) if(atr[i]==1&&(papa_num[i]==srnd_num[i]))
	printf("cost[%d]=%f\n",i,cost[i]);
    }
    stay=(int*)malloc(STRUCT*sizeof(int));
    are=(int*)malloc(ALL*ALL*sizeof(int));
    elmnt=(double*)malloc(ALL*ALL*sizeof(double));
    rgh_end=(double*)malloc(ALL*sizeof(double));
    white=(int*)malloc(ALL*sizeof(int));
    tmp_cst=(double*)malloc(ALL*sizeof(double));
    wht=(int*)malloc(ALL*sizeof(int));
    virgin=(int*)malloc(ALL*sizeof(int));

    /*** bound=2 when uppr, 0 when lower 1 when both ***/
    /*** element[x][y] is the [x]th collum, [y]th line  ***/
    /****  initization  ******/
    tate=slk_num+and_num+1;
    yoko=slk_num+str_num+and_num+1;
    getrusage(RUSAGE_SELF,&rus);
    cputime=rus.ru_utime.tv_sec + rus.ru_utime.tv_usec*1.0e-6;
    /*printf("runtime symp.1=%9.2f[s]\n",cputime-cputime1);*/
    for(i=1;i<=yoko;i++){	  
	stay[i]=0;
	for(j=1;j<=tate;j++){
	    elmnt[i*ALL+j]=0.0;
	}            
    }
	
    for(slk=1;slk<=slk_num;slk++){
	sl=slack[slk];
	if(bound[sl]==2) rgh_end[slk]=uppr[sl];
	if(bound[sl]==0) rgh_end[slk]=lwr[sl];			
	for(i=1;i<=srnd_num[sl];i++){
	    sri=srnd[sl*CIRCUM+i];
	    if(is_inc[sri]==1) rgh_end[slk]+=-1.0/rel[sl*CIRCUM+i];
	    elmnt[(slk_num+strth[sri])*ALL+slk]=1.0/rel[sl*CIRCUM+i];
	    wht[slk_num+strth[sri]]=0;
	    rgh_end[slk]-=-1.0/rel[sl*CIRCUM+i];
	}
	elmnt[slk*ALL+slk]=bound[sl]-1.0;
	white[slk]=slk;
	wht[slk]=1;
    }
    for(i=1;i<=and_num;i++){
	str=strth[and_left[i]];
	elmnt[(slk_num+str)*ALL+slk_num+i]=1.0;
	elmnt[(slk_num+str_num+i)*ALL+slk_num+i]=1.0;
	if(is_inc[and_left[i]]==1||is_goal[and_left[i]]==1){
	    stay[slk_num+str_num+i]=stay[slk_num+str]=1;
	    rgh_end[slk_num+i]=0.0;
	}
	else rgh_end[slk_num+i]=1.0;
	white[slk_num+i]=slk_num+str_num+i;
	wht[slk_num+str_num+i]=1;
    }
    
    
    /*** Special statements for the goal *********/
    str=strth[goal];
   if(see_graph)    printf("goal %d,str %d\n",goal,str);
    elmnt[(slk_num+str)*ALL+slk_num+and_num+1]=1.0;
    elmnt[(slk_num+str_num+and_num+1)*ALL+slk_num+and_num+1]=1.0;
    stay[slk_num+str_num+and_num+1]=stay[slk_num+str]=1;
    rgh_end[slk_num+and_num+1]=0.0;
    white[slk_num+and_num+1]=slk_num+str_num+and_num+1;
    wht[slk_num+str_num+and_num+1]=1;
	
    bst_cst=0;
/*    for(i=1;i<=str_num;i++)
	printf("cost[%d]=%f\n",strctr[i],cost[strctr[i]]);
	*/
    for(i=1;i<=slk_num;i++)	tmp_cst[i]=0;
    for(i=1;i<=str_num;i++)	bst_cst+=tmp_cst[slk_num+i]=-cost[strctr[i]];
/*          THE SYMPLEX TABLAU                                            */
/*________________________________________________________________________*/
/* up?		*  *			if up uppr-1.0/rel(sl to str)-..  */
/*   up?	*   * *			if lwr lwr			  */
/*     up?	  *   *							  */
/*       *	  * *    *						  */
/*         *	*  *   *						  */
/*           *	 *   *  *						  */
/*	      	1.0	    1		if and_left=goal or inc 0.0	  */
/*		    1.0	      1		else 1.0			  */
/* 		  1		1					  */
/*		     1            1					  */
/*____________|_____________|________|					  */
/* slk_num      str_num   	   and_num                                */
/*              uppr-x         x-lwr                                       */

    /** shows elements is supposed to be here **/
    getrusage(RUSAGE_SELF,&rus);
    cputime=rus.ru_utime.tv_sec + rus.ru_utime.tv_usec*1.0e-6;
    /*printf("runtime symp.2=%9.2f[s]\n",cputime-cputime1);*/

    /****  symplex method  ******/

    feasible=smpl_cycle(tate,yoko,stay,tmp_cst,elmnt,rgh_end,white,wht,virgin);
    if(see_input) printf("feasible=%d\n",feasible);
    if(feasible==0){
	feasible=smpl_cycle2(tate,yoko,stay,tmp_cst,elmnt,rgh_end,
			     white,wht,virgin);	
	if(see_input) 	printf("feasible2=%d\n",feasible);
	feasible=smpl_cycle(tate,yoko,stay,tmp_cst,elmnt,rgh_end,
			    white,wht,virgin);
        if(see_input) 	printf("feasible3=%d\n",feasible);			
    }
    else flg_out=0;


    /**************END of SYMPLEX ******/
    /*****  at a critical point, the situation is 1, else 0. *****/
    for(i=1;i<=yoko;i++)			stt[i]=0;
    for(i=1;i<=yoko;i++)			wht[i]=0;
    for(j=1;j<=tate;j++)  			wht[white[j]]=1;;
    for(i=1;i<=slk_num;i++) 
	if(wht[i]==1)	     			stt[slack[i]]++;
    for(i=slk_num+1;i<=slk_num+str_num;i++)	
	if(wht[i]==1)	   		    	stt[strctr[i-slk_num]]++;
    for(i=1;i<=and_num;i++) 
	if(wht[i+slk_num+str_num]==0)		stt[and_left[i]]-=1;
    if(wht[and_num+1+slk_num+str_num]==0)	stt[goal]-=1;
    for(i=1;i<=ttl_node;i++)   			stt[i]=(stt[i]==0||stt[i]==-1);
    for(i=1;i<=chld_num[inc];i++)           	stt[chld[inc*CIRCUM+i]]=1;

    /**  value desicion **/
    for(j=1;j<=tate;j++){
	if(white[j]<=slk_num){
	    if(bound[slack[white[j]]]==2) 
		value[slack[white[j]]]
		    =uppr[slack[white[j]]]
		    -rgh_end[j]/elmnt[white[j]*ALL+j];
	    if(bound[slack[white[j]]]==0) 
		value[slack[white[j]]]
		    =lwr[slack[white[j]]]
		    +rgh_end[j]/elmnt[white[j]*ALL+j];
	}
	else if(white[j]<=slk_num+str_num)
	    value[strctr[white[j]-slk_num]]
		=uppr[strctr[white[j]-slk_num]]
		-rgh_end[j]/elmnt[white[j]*ALL+j];
	else if(white[j]<=slk_num+str_num+and_num)
	    value[and_left[white[j]-str_num-slk_num]]
		=lwr[and_left[white[j]-str_num-slk_num]]
		+rgh_end[j]/elmnt[white[j]*ALL+j];
	else  
	    value[goal]
		=lwr[goal]
		+rgh_end[j]/elmnt[white[j]*ALL+j];
    }

    for(n=1;n<=yoko;n++){
	if(wht[n]==0){
	    if(n<=slk_num){
		if(bound[slack[n]]==2)	
		    value[slack[n]]=uppr[slack[n]];
		if(bound[slack[n]]==0)	
		    value[slack[n]]=lwr[slack[n]];
	    }	
	    else if(n<=slk_num+str_num)  
		value[strctr[n-slk_num]]=uppr[strctr[n-slk_num]];
	    else
		value[and_left[n-slk_num-str_num]]
		    =lwr[and_left[n-slk_num-str_num]];
	}
    }

    getrusage(RUSAGE_SELF,&rus);
    cputime=rus.ru_utime.tv_sec + rus.ru_utime.tv_usec*1.0e-6;
    /* printf("runtime symp.4=%9.2f[s]\n",cputime-cputime1);*/
    gstep();
    free(are);
    free(elmnt);
    free(rgh_end);
    free(white);
    free(tmp_cst);
    free(wht);
    free(stay);
    return;
}

int smpl_cycle(int tate, int yoko, int *stay, double *tmp_cst, double *elmnt,
	       double *rgh_end, int *white, int *wht, int *virgin){
    int i, j, n, ok, ok1, jdg_stp, piv_b, piv_w, feasible;
    double max_opt, min, elm, elm1, rg, rt, *warizan;

    warizan=(double*)malloc(ALL*sizeof(double));
    jdg_stp=0;
    while(jdg_stp==0){
        ok=0;
        ok1=0;
	max_opt=0.0;
/*	if(bst_cst>-4) printf("*piv_b=%d\n",piv_b);*/
	for(i=1;i<=yoko;i++)	
       	if((stay[i]==0||i<=slk_num+str_num)
	   && flt(tmp_cst[i])<0.0&&tmp_cst[i]<max_opt){
	    ok1=1;
	    max_opt=tmp_cst[i];
	    piv_b=i;
/*	if(bst_cst>-4) printf("piv_b=%d\n",piv_b);*/
	}
	virgin[piv_b]=0;
        min=10000000.0;
/*	if(bst_cst>-4) printf("*piv_w=%d\n",piv_w);*/
	if(ok1==1) 
	    for(n=1;n<=tate;n++){
		if(flt(elmnt[white[n]*ALL+n]*(elm=elmnt[piv_b*ALL+n]))>0.0
		   && flt(rg=(rgh_end[n]/elm))>=0.0
		   && flt(rg-min)<=0.0){
		    min=rg;
		    piv_w=n;
		    ok=1;
		}
	    }
/*	if(bst_cst>-4) printf("piv_w=%d\n",piv_w);*/
	if(ok==0) break;

	wht[piv_b]=1;
	wht[white[piv_w]]=0;
	white[piv_w]=piv_b;

	if(flt(elm=elmnt[piv_b*ALL+piv_w])!=0.0){
	    for(j=1;j<=tate;j++)
		warizan[j]=elmnt[piv_b*ALL+j]/elm;
	    for(i=1;i<=yoko;i++){
		if(flt(elm1=elmnt[i*ALL+piv_w])!=0.0){
		    for(j=1;j<=tate;j++)
			if(j!=piv_w){
			    rt=warizan[j];
			    if(flt(rt)!=0.0){
				elmnt[i*ALL+j]-=elm1*rt;
			    }
			}
		}
	    }
	    if(flt(elm1=rgh_end[piv_w])!=0.0)
		for(j=1;j<=tate;j++)
		    if(j!=piv_w){
			rt=warizan[j];
			if(flt(rt)!=0.0)
			    rgh_end[j]-=elm1*rt;
		    }
	}

	/** thisingle line is assurance of 0 a1s 0 **/
	if(flt(elm)!=0.0){
	    rt=tmp_cst[piv_b]/elm;
	    for(i=1;i<=yoko;i++){
		tmp_cst[i]-=elmnt[i*ALL+piv_w]*rt;
		if(flt(tmp_cst[i])<0.0&&(1==wht[i])){
		    printf("crime is %d,whose cost is %f\n",i,tmp_cst[i]);
		}
		/*printf("%d%d,",(tmp_cst[i]<0.0),1-wht[i]);*/
	    }
		bst_cst-=rgh_end[piv_w]*rt;
        }
/*printf("*bst_cst=%f\n",bst_cst);*/
	tmp_cst[piv_b]=0.0;
	jdg_stp=1;
	for(i=1;i<=yoko;i++){
/*	    printf("%f,",tmp_cst[i]);*/
	    if(flt(tmp_cst[i])<0.0) jdg_stp=0;
	}
    }
/*    printf("jdg_stp=%d,ok=%d\n",jdg_stp,ok);*/
    feasible=1;
/*printf("bst_cst1=%f\n",bst_cst);*/
    for(i=1;i<=tate;i++){
	if(flt(rgh_end[i]/elmnt[white[i]*ALL+i])<0.0){
	    feasible=0;
	    break;
	}
    }


    return(feasible);
}

int smpl_cycle2(int tate, int yoko, int *stay, double *tmp_cst, double *elmnt,
		double *rgh_end, int *white, int *wht, int *virgin){
    int i, j, n, ok, jdg_stp, piv_b, piv_w, feasible, *new_partner,pivmem_b,
	pivmem_w,ok_vio,tmp_n,prev_w;
    double max_opt, min, elm, elm1, rg, rt, *warizan,vio_min;
	
    warizan=(double*)malloc(ALL*sizeof(double));
    new_partner=(int*)malloc(ALL*ALL*sizeof(int));
    feasible=0;
    for(i=1;i<=tate;i++) warizan[i]=0.0;
    for(i=1;i<=yoko;i++) for(j=1;j<=yoko;j++) new_partner[i*ALL+j]=1;
    while(feasible==0){
        ok=ok_vio=0;
	max_opt=0.0;
	for(i=1;i<=yoko;i++){	
	    if((stay[i]==0||i<=slk_num+str_num)&&wht[i]==0&&i!=prev_w){
			virgin[i]=0;
		        min=10000000.0;
		        vio_min=10000000.0;
		     for(n=1;n<=tate;n++){
			 elm=elmnt[i*ALL+n];
			 if(new_partner[i*ALL+white[n]]&&flt(elm)!=0.0){
			  rg=rgh_end[n]/elm;
			  if(flt(elmnt[white[n]*ALL+n]*elm)>0.0&&
			     flt(rg)>=0.0&&flt(min-rg)>=0.0){
				 min=rg;
				 piv_b=i;
				 piv_w=n;
				 ok=1;
			  } 
			  if(flt(elmnt[white[n]*ALL+n]*elm)<0.0&&
			     flt(rg)>0.0&&flt(vio_min-rg)>=0.0){
			         vio_min=rg;			
/*				 tmp_n=n;*/
			  }
			 }    
		     }
		     if(ok==1&&flt(min-vio_min)>=0.0){
			 ok_vio=1;
		     }
		}
	       if(ok_vio==1) break;
		if(ok==1){
		      pivmem_b=piv_b;
		      pivmem_w=piv_w;
		}
	}
	if(ok==1){
	    if(ok_vio==0){
		piv_b=pivmem_b;
		piv_w=pivmem_w;
	    }
	}
        else  break;
/*	printf("B: %d, W: %d\n",piv_b,white[piv_w]);*/

/*	new_partner[piv_b*ALL+piv_w]=0;*/
	new_partner[piv_b*ALL+white[piv_w]]
	=new_partner[white[piv_w]*ALL+piv_b]=0;
	prev_w=white[piv_w];
	wht[piv_b]=1;
	wht[white[piv_w]]=0;
	white[piv_w]=piv_b;

 	if(flt(elm=elmnt[piv_b*ALL+piv_w])!=0.0){
	    for(j=1;j<=tate;j++) warizan[j]=elmnt[piv_b*ALL+j]/elm;
	    for(i=1;i<=yoko;i++){
		if(flt(elm1=elmnt[i*ALL+piv_w])!=0.0){
		    for(j=1;j<=tate;j++)
			if(j!=piv_w){
			    rt=warizan[j];
/*ato de toru*/		    if(flt(rt)!=0.0){
				elmnt[i*ALL+j]-=elm1*rt;

			    }
/*			 printf("#");*/
			}
		}
	    }
	    if(flt(elm1=rgh_end[piv_w])!=0.0)
		for(j=1;j<=tate;j++)
		    if(j!=piv_w){
			rt=warizan[j];
			if(flt(rt)!=0.0)    rgh_end[j]-=elm1*rt;
		    }
	}

      	/** thisingle line is assurance of 0 a1s 0 **/
	if(flt(elm)!=0.0){
	    rt=tmp_cst[piv_b]/elm;
	    for(i=1;i<=yoko;i++){
		tmp_cst[i]-=elmnt[i*ALL+piv_w]*rt;
		if(flt(tmp_cst[i])<0.0&&(1==wht[i])){
		    printf("crime is %d,whose cost is %f\n",i,tmp_cst[i]);
		}
	        /*printf("%d%d,",(tmp_cst[i]<0.0),1-wht[i]);*/
	    }	 
		bst_cst-=rgh_end[piv_w]*rt;
        }

	tmp_cst[piv_b]=0.0;
        feasible=1;
        for(i=1;i<=tate;i++){
	    if(flt(rgh_end[i]/elmnt[white[i]*ALL+i])<0.0){
		feasible=0;
		break;
	    }
	}
    }
    if(ok==0){
	printf("NO SOLUTION\n");
	if(see_graph<2) shows_graph(x_goal,y_goal);
	gstep();
	exit(1);
    }
    /*printf("ok=%d,ok1=%d\n",ok,ok1);*/
    free(warizan);
    free(new_partner);
    return(feasible);
}

double flt(double x){
    double y;
    if(x<0.000001&&x>-0.000001)	y=0.0;
    else 			y=x;
    return(y);
}

void outputs(){
    int this, nd, i, j, *moji;

    moji=(int*)malloc(10*sizeof(int));
    printf("SOLUTION SET\n");
    for(this=1;this<=ttl_node;this++){
	if(atr[this]==1&&flt(value[this]-1.0)==0.0){
	    for(nd=1;nd<=nd_max;nd++){
		if(leaf[nd]==this&&br_num[nd]==0){
		    moji[i=1]=nd;
		    if(i==1){
			while(moji[i]!=0){
			    moji[++i]=sugu_ue[moji[i-1]];
			}
			for(j=1;j<=i;j++) printf("%c",lttr[moji[i+1-j]]);
			printf(",");
		    }
		}
	    }
	}
    }
    printf("\n");
    return;
}

void write_atom(write_node,drawn_node,x_axis,y_axis)
int write_node,*drawn_node,*x_axis,*y_axis;
{/* UNNC B */
        char *atom;
	int this,nd,i,j,*moji,muki,dx;
	moji=(int*)malloc(10*sizeof(int));
	atom=(char*)malloc(5*sizeof(char));
	 for(nd=1;nd<=nd_max;nd++){
             if(leaf[nd]==write_node&&br_num[nd]==0){
		    moji[i=1]=nd;
		    if(i==1){
			    while(moji[i]!=0){
				    moji[++i]=sugu_ue[moji[i-1]];
			    }
		    	for(j=1;j<=i;j++){
			    sprintf(atom,"%c",lttr[moji[i+1-j]]);
			    muki=(int)(((x_axis[write_node]>x_axis[drawn_node[i-1]])*2-1)
				       *SCALE*0.7);
			    dx=5*j;
			    XDrawString(d, w, gc,x_axis[write_node]-(int)(0.3*SCALE)+muki+dx,
					y_axis[write_node]+SCALE*1.5, atom, strlen(atom));
			}
/*		    	for(j=1;j<=i;j++) printf("%c",lttr[moji[i+1-j]]);
		    	printf(",");
*/	            }
	    }
	}

	free(moji);
	free(atom);
	return;
}


		

		
					
			
			





