% Copyright (C) 1997  Katsumi Inoue 
%
%%% stable.pl %%%
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%						               %
%	Stable Model semantics of Abductive Logic Program      %
%						               %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% if Programs have a model then return 'Sat',
%    else return 'Unsat'.
%
mg :-
	time(_),
	(do(_) -> true;!,fail),
%	write('M = '),write(M),
	time(T),
	print_time(T).

%
% return model set of MGTP's output
%
mgtp(M) :-
	time(_),
	do1(M),
	time(T),
	print_time(T).

mgtpall :-
	time(_),
	doall(M),
	time(T),
	length(M,L),
	print_set(M,satisfy),
	print_length1(L),
	print_time(T).


%
% return Satisfy or Unsatisfy
%        if program have a stable model then return sat and its model,
%        else return unsat.
% Attention!!
% Program's Class is only Normal Logic Program
%           or a part of Extended Disjunctive Program
%
st(Md) :-
	time(_),
	stone(Md),
	time(T),
	print_time(T).

stone(Md) :-
	do1(M),
        (M = 'No more models' -> Md = 'No more answer sets';
	obj_c([M],[Md|_])).

        
%
% --- Help ----
%     output Program's Class
%
class :-
	write('******** Class ********'),nl,
	write('[1]elp    : Extended Logic Programs'),nl,
	write('[2]nredp  : Non-Redundant Extended Disjunctive Programs'),nl,
	write('[3]aelp   : Abductive Extended Logic Programs'),nl,
	write('[4]edp    : Extended Disjunctive Programs'),nl,
	write('[5]nraedp : Non-Redundant Abductive \\
                            Extended Disjunctive Programs'),nl,
	write('[6]aedp   : Abductive Extended Disjunctive Programs'),nl.


%
% Stable Model
% ---- All stable model of each Program's Class ----
%   default aedp:Abductive Extended Disjunctive Programs
%
st_all :-
	program(Class),
	st_all(Class).
st_all(Class) :-
	time(_),
	stone(M,Class),
	time(T),
	(M = 'none' -> L = 0,write('Answer set is none');
	    length(M,L),print_set(M,answer)),nl,
	print_length(L),
	print_time(T).


%
% Number of Stable Model
% ---- Number of stable model at each Program's Class ----
%   default aedp:Abductive Extended Disjunctive Prolgrams
%
st_num :-
	program(Class),
	st_num(Class).
st_num(Class) :-
	time(_),
	stone(M,Class),
	time(T),
	(M = 'none' -> L = 0;length(M,L)),
	print_length(L),
	print_time(T).


%
% Stable Model
% ---- Extended Logic Programs ----
%       ST = obj_c(Tp|w)
%
stone(Md,elp) :-
	doall(M),
	(M = [] -> Md = [];
	    obj_c(M,M1),
	    none_or_empty(M1,Md)).

%
% Minimal Belief Set
% ---- Abductive Extended Logic Programs ----
%      min-BM<p,r> = min_r(obj_c(Tpr|w)).
%
stone(Md,aelp) :-
	doall(M),
	(M = [] -> Md = [];
	    remove_work_abducible(M,M1),
	    obj_c(M1,M2),
	    min_r(M2,M3),
	    none_or_empty(M3,Md)).

%
% Consistent Answer Set
% ---- Non-Redundant Extended Disjunctive Programs ----
%      AS_p = obj_c(Tp|w).
%
stone(Md,nredp) :-
	doall(M),
	(M = [] -> Md = [];
	    obj_c(M,M1),
	    none_or_empty(M1,Md)).

%
% Consistent Answer Set
% ---- Extended Disjunctive Programs ----
%      AS_p = obj_c(min(Tp|w)).
%
stone(Md,edp) :-
	doall(M),
	(M = [] -> Md = [];
	    min(M,M1),
	    obj_c(M1,M2),
	    none_or_empty(M2,Md)).

%
% Minimal Belief set
% ---- Non-Redundant Abductive Extended Disjunctive Programs ----
%      min-BS<p,r> = min_r(obj_c(Tp|w)).
%
stone(Md,nraedp) :-
	doall(M),
	(M = [] -> Md = [];
	    remove_work_abducible(M,M1),
	    obj_c(M1,M3),
	    min_r(M3,M4),
	    none_or_empty(M4,Md)).

%
% Minimal Belief set
% ---- Abductive Extended Disjunctive Programs ----
%      min-BS<p,r> = min_r(obj_c(min(Tp|w))).
%
stone(Md,aedp) :-
	doall(M),
	(M = [] -> Md = [];
	    remove_work_abducible(M,M1),
	    min(M1,M2),
	    obj_c(M2,M3),
	    min_r(M3,M4),
	    none_or_empty(M4,Md)).



%
% Runtime function
%
%time(T) :-
%        statistics(runtime,[_,T]),!.

% print Run time
%print_time(T) :-
%	nl,write('* Time: '),
%	T1 is T /1000,
%	write(T1),
%	write(' sec. *'),nl,!.

%
% output
%
print_length(L) :-
	write('Number of answer sets : '),write(L),nl,!.

print_length1(L) :-
	write('Number of Models: '),write(L),nl,!.

print_set([],_) :- printf(['Answer sets : []',{nl}]).
print_set(M,answer) :-
	write('Answer sets : ['),
	(M = [] -> write(']'),nl;nl,print_set1(M)),!.
print_set(M,satisfy) :-
	write('Models : ['),nl,
	print_set1(M),!.

print_set1([M]) :- !,write(M),write(']'),nl.
print_set1([M|L]) :-
	write(M),nl,
	print_set1(L).










