% Copyright (C) 1997  Katsumi Inoue 
%
%%% model1.pl %%%
%
% (C)1992 Institute for New Generation Computer Technology
% (Read COPYRIGHT for detailed information.)
:- dynamic find_model/1.

do(Md) :- do(Md,default).
do1(Md) :- do(Md,one).
doall(Md) :- do(Md,all).

do(Md,default) :- model(M), flis(FLIS), lis(LIS), disjU(DisjU), disjO(DisjO),
	do(M, FLIS,LIS, DisjU,DisjO, _,Md,default) -> Md='unsat';Md ='sat'.
do(Md,one) :- model(M), flis(FLIS), lis(LIS), disjU(DisjU), disjO(DisjO),
	do(M, FLIS,LIS, DisjU,DisjO, _,MD,one),
	do_result(MD),
	result(MD,Md).
do(Md,all) :- model(M), flis(FLIS), lis(LIS), disjU(DisjU), disjO(DisjO),
	do(M, FLIS,LIS, DisjU,DisjO, _,Md,all),
	do_result(Md).


result(MD,Md) :- MD = [_,Md].
%result([],'No model').
result([],'No more models').

% delete variable of list (fainally mgtp result)
do_result([]).
do_result([_|L]) :- do_result(L),!.

do(_,_,_,[],[], NewMd,Md,one) :-
	add_model_list(NewMd,Md,one).
do(_,_,_,[],[], _,_,one).
do(_,_,_,[],[], NewMd,Md,N) :- !,
	add_model_list(NewMd,Md,N).
do(M, FLIS,LIS, DisjU,DisjO, _,Md,N) :-
	doFalse(M,[], FLIS,LIS, DisjU,DisjO, Md,N).

% List of models
add_model_list(_,_,default) :- !,fail.
add_model_list(New,[one,New],one).	
add_model_list(New,Md,all) :-
	(var(New) -> true;model_list(New,Md)).

model_list(New,[M1|M2]) :-
	(var(M1) -> M1 = New;
	    equal_list(M1,New) ->true;model_list(New,M2)).

doFalse(M,DM, FLIS,LIS, [P|DisjU],DisjO, Md,N) :- !,
	(member(P,M) -> doFalse(M,DM, FLIS,LIS, DisjU,DisjO, Md,N);
	    doFalse1(M, P,DM, FLIS,LIS, DisjU,DisjO, Md,N)).
doFalse(M,DM, FLIS,LIS, [],[Dis|DisjO], Md,N) :- !,
	(checkConsq(Dis,NDis, M) ->
	    expandFalse(NDis, M,DM, FLIS,LIS, DisjO, Md,N);
	    doFalse(M,DM, FLIS,LIS, [],DisjO, Md,N)).
doFalse(M,DM, FLIS,LIS, [],[], Md,N) :- 
%	DM = [_|_],
	satisfyClauses(M,DM, LIS,NLIS, [],DisjU, [],DisjO),
	do(M, FLIS,NLIS, DisjU,DisjO, M,Md,N).

doFalse1(M, P,DM, FLIS,LIS, DisjU,DisjO, Md,N) :-
	M1 = [P|M],
	satisfyClauses(M1,[P], FLIS,NFLIS, [],False, _,_),
	(False = [] -> doFalse(M1,[P|DM], NFLIS,LIS, DisjU,DisjO, Md,N);
	    true).

% case of return a model
expandFalse(_, _,_, _,_, _, Md,one) :- \+var(Md),Md = [one|_],!.
% otherwise
expandFalse([P|Ps], M,DM, FLIS,LIS, DisjO, Md,N) :- 
	doFalse(M,DM, FLIS,LIS, P,DisjO, Md,N),
	expandFalse(Ps, M,DM, FLIS,LIS, DisjO, Md,N).
expandFalse([], _,_, _,_, _, _,_).


satisfyClauses(M,DM, [lis(I,LiS)|LIS],[lis(I,NLiS)|NLIS1], Si,So, Di,Do) :- !,
	satisfyClause(I,LiS,NLiS, M,DM, Si,Sm, Di,Dm),
	satisfyClauses(M,DM, LIS,NLIS1, Sm,So, Dm,Do).
satisfyClauses(_,_, [],[], Si,Si, Di,Di).

satisfyClause(ID,LiS,NLiS, M,[PAT|DM], Si,So, Di,Do) :- !,
	satisfyClause1(ID,LiS,LiS1, M,PAT, Si,Sm, Di,Dm),
	satisfyClause(ID,LiS1,NLiS, M,DM, Sm,So, Dm,Do).

satisfyClause(ID,LiS,LiS, M,[], Si,Si, Di,Di).

satisfyClause1(ID,LiS,NLiS, M,PAT, Si,So, Di,Do) :- pc(ID,PAT), !,
	satisfyAnte(ID,LiS,NLiS, M,[PAT], [[]],[], Si,So, Di,Do).
satisfyClause1(ID,LiS,LiS, M,PAT, Si,Si, Di,Di).

satisfyAnte(ID,[],[], M,DM, Stack,DStack, Si,So, Di,Do) :- !,
	satisfyLiteral(ID, M,DM, Stack,DStack, Si,So, Di,Do).
satisfyAnte(ID,[S|LiS],[NS|NLiS1], M,DM, Stack,DStack, Si,So, Di,Do) :- 
	satisfyLiteral(ID, M,DM, Stack,DStack, S,NS, [],DS),
	satisfyAnte(ID,LiS,NLiS1, M,DM, S,DS, Si,So, Di,Do).

%
%   satisfyLiteral(+ClauseID, +WholeModel,+DifferentialOfModel,
%           +PreviousStack,+DifferentialOfPreviousStack,
%           +CurrentStack,-CurrentStack,
%           +DifferentialOfCurrentStack,-DifferentialOfCurrentStack)
%
satisfyLiteral(ID, M,DM, Stack,[S|DStack], Si,So, Di,Do) :- !,
	satisfyLiteral(ID, M,S, Si,Sm, Di,Dm),
	satisfyLiteral(ID, M,DM, Stack,DStack, Sm,So, Dm,Do).
satisfyLiteral(ID, M,DM, [S|Stack],DStack, Si,So, Di,Do) :- !,
	satisfyLiteral(ID, DM,S, Si,Sm, Di,Dm),
	satisfyLiteral(ID, M,DM, Stack,DStack, Sm,So, Dm,Do).
satisfyLiteral(_, _,_, [],[], Si,Si, Di,Di).

satisfyLiteral(ID, [P|Ps],S, Si,So, Di,Do) :- !,
	c(ID, [P|S], Si,Sm, Di,Dm),
	satisfyLiteral(ID, Ps,S, Sm,So, Dm,Do).
satisfyLiteral(_, [],_, Si,Si, Di,Di).

%
%   Library
%
checkConsq([],[], _).
checkConsq([X|Xs],Ys, M) :- checkConsq1(X,M, 0,Y,Y, Xs,Ys).

checkConsq1([],M, 1,H,[], Xs,[H|Ys]) :- checkConsq(Xs,Ys, M).
checkConsq1([A|X],M, S,H,T, Xs,Ys) :- 
	(member(A,M) -> checkConsq1(X,M, S,H,T, Xs,Ys);
	    T = [A|T1],	checkConsq1(X,M, 1,H,T1, Xs,Ys)).
