% Copyright (C) 1997  Katsumi Inoue 
%
%%% mgtp2uty.pl %%%
%
% (C)1992 Institute for New Generation Computer Technology
% (Read COPYRIGHT for detailed information.)

%--------------------------------------------------------------
%	Library Utility (for MGTP translator)
%
%
%--------------------------------------------------------------

%-------------------------------------------------------%
%	List Utility					%
%-------------------------------------------------------%

%--------< app_list >-----------------------------------%

app_list([],L,L) :- !.
app_list([One|Rem],L,[One|NewRem]) :-
	app_list(Rem,L,NewRem).

%-------< delete list >---------------------------------%

delete_list(_,_,[],[]) :- !.
delete_list(strong,DEL,[DEL|Rem],NewRem) :- !,
	delete_list(strong,DEL,Rem,NewRem).
delete_list(weak,DEL,[One|Rem],NewRem) :-
	DEL == One,!,
	delete_list(weak,DEL,Rem,NewRem).
delete_list(Mode,DEL,[One|Rem],[One|NewRem]) :- !,
	delete_list(Mode,DEL,Rem,NewRem).

%------< to flat list >---------------------------------%

to_flat_list([],[]) :- !.
to_flat_list([One|Rem],L) :- !,
	to_flat_list_one(One,L,Lrem),
	to_flat_list(Rem,Lrem).

to_flat_list_one((One,Rem),[One|NewRem],Lrem) :- !,
	to_flat_list_one(Rem,NewRem,Lrem).
to_flat_list_one(One,[One|Lrem],Lrem) :- !.

%-------------------------------------------------------%
%	data type convert				%
%-------------------------------------------------------%

%-------< term to list >--------------------------------%

to_list((One,Rem),List) :- !,
	to_AndList((One,Rem),List).
to_list((One;Rem),List) :- !,
	to_OrList((One;Rem),List).
to_list(One,[One]) :- !.

to_AndList((One,Rem),[One|NewRem]) :- !,
	to_AndList(Rem,NewRem).
to_AndList(One,[One]) :- !.

to_OrList((One;Rem),[NewOne|NewRem]) :- !,
	to_AndList(One,NewOne),
	to_OrList(Rem,NewRem).
to_OrList(One,[NewOne]) :-
	to_AndList(One,NewOne).

%-------< AND clause <-> OR clause >---------------------%

andTerm_to_orTerm((Lone;Lrem),R) :- !,
	andTerm_to_orTerm_one(Lone,Lrem,R).
andTerm_to_orTerm((Lone,_),Lone).
andTerm_to_orTerm((_,Lrem),R) :- !,
	andTerm_to_orTerm(Lrem,R).
andTerm_to_orTerm(L,L) :- !.

andTerm_to_orTerm_one((One,_),Lrem,(One;NewLrem)) :-
	andTerm_to_orTerm(Lrem,NewLrem).
andTerm_to_orTerm_one((_,Rem),Lrem,R) :- !,
	andTerm_to_orTerm_one(Rem,Lrem,R).
andTerm_to_orTerm_one(Lone,Lrem,(Lone;NewLrem)) :- !,
	andTerm_to_orTerm(Lrem,NewLrem).

orTerm_to_andTerm((One;_),One) .
orTerm_to_andTerm((_;Rem),One) :- !,
	orTerm_to_andTerm(Rem,One).
orTerm_to_andTerm(One,One) :- !.

%-------------------------------------------------------%
%	i/o device 					%
%-------------------------------------------------------%

%-------< print with format >---------------------------%
printf(Var) :-
	var(Var),!,
	print(Var).
printf(Term) :- !,
	printf_list(Term).

printf_list([]) :- !.
printf_list([One|Rem]) :- !,
	printf_list_one(One),
	printf(Rem).
printf_list(One) :-
	printf_list_one(One).

printf_list_one({Control}) :- !,
	port_control(Control).
printf_list_one('') :- !.
printf_list_one(Term) :-
	print(Term).

port_control(repeat(N,Obj)) :- !,
	port_loop(N,Obj).
port_control(nl) :- !,
	nl.
port_control(nl(N)) :- !,
	port_loop(N,{nl}).
port_control(quote(Term)) :- !,
	writeq(Term).
port_control(ttyflush) :- !,
	ttyflush.
port_control(tab) :- !,
	write('        ').
port_control(tab(N)) :- !,
	port_loop(N,{tab}).

port_loop(0,_) :- !.
port_loop(N,Obj) :- !,
	printf(Obj),
	NewN is N - 1,
	port_loop(NewN,Obj).

%-------< can file open >-------------------------------%

can_file_open(read,File) :- !,
	seeing(Current),
	nofileerrors,
	see(File),
	seen,
	see(Current),!.
can_file_open(write,File) :- !,
	telling(Current),
	nofileerrors,
	tell(File),
	told,
	tell(Current),!.

%-------< can file open with extention >----------------%

can_file_open(Flg,user,_,user) :-
	can_file_open(Flg,user),!.
can_file_open(Flg,Name,Ext,File) :-
	can_file_open_add_ext_one(Name,dummy,_),!,
	can_file_open_add_ext(Name,Ext,File),
	can_file_open(Flg,File),!.
can_file_open(Flg,Name,_,Name) :- !,
	can_file_open(Flg,Name).

can_file_open_add_ext(_,[],_) :- !,fail.
can_file_open_add_ext(Name,[Ext|_],File) :-
	can_file_open_add_ext_one(Name,Ext,File).
can_file_open_add_ext(Name,[_|Erem],File) :- !,
	can_file_open_add_ext(Name,Erem,File).
can_file_open_add_ext(Name,Ext,File) :- !,
	can_file_open_add_ext_one(Name,Ext,File),!.

can_file_open_add_ext_one(Name,Ext,File) :- !,
	name(Name,Nlis),
	name(Ext,Elis),
	can_file_open_add_ext_lis(Nlis,Elis,Flis),
	name(File,Flis),!.

can_file_open_add_ext_lis([46,47|Nlis],Elis,[46,47|Flis]) :- !,		%% ./
	can_file_open_add_ext_lis(Nlis,Elis,Flis).
can_file_open_add_ext_lis([46,46,47|Nlis],Elis,[46,46,47|Flis]) :- !,	%% ./
	can_file_open_add_ext_lis(Nlis,Elis,Flis).
can_file_open_add_ext_lis([46|_],_,_) :- !,fail.			%% '*.*'
can_file_open_add_ext_lis([],Elis,[46|Elis]) :- !.
can_file_open_add_ext_lis([C|Nlis],Elis,[C|Flis]) :- !,
	can_file_open_add_ext_lis(Nlis,Elis,Flis).

%-------< can file open with extention,message >--------%

can_file_open_msg(Mode,Name,Ext,File) :-
	can_file_open(Mode,Name,Ext,File),!.
can_file_open_msg(_,Name,_,_) :- !,
	printf(['[ Can''t open file : "',Name,'". ]',{nl}]),
	fail.

%-------< file to name , extention >--------------------%

filename_to_name_ext(File,Name,Ext) :-
	var(File),!,
	name(Name,Nlis),
	name(Ext,Elis),
	app_list(Nlis,[46|Elis],Flis),
	name(File,Flis).
filename_to_name_ext(File,Name,Ext) :-
	File = [_|_],!,
	filename_to_name_ext_l(File,Name,Ext).
filename_to_name_ext(File,Name,Ext) :-
	name(File,Flis),
	filename_to_name_ext_list(Flis,Nlis,Elis),
	name(Name,Nlis),
	name(Ext,Elis).

filename_to_name_ext_list([],[],[]) :- !.
filename_to_name_ext_list([46,47|Flis],[46,47|Nlis],Elis) :- !,		%% ./
	filename_to_name_ext_list(Flis,Nlis,Elis).
filename_to_name_ext_list([46,46,47|Flis],[46,46,47|Nlis],Elis) :- !,	%% ../
	filename_to_name_ext_list(Flis,Nlis,Elis).
filename_to_name_ext_list([46|Elis],[],Elis) :- !.			%% '*.*'
filename_to_name_ext_list([C|Flis],[C|Nlis],Elis) :-
	filename_to_name_ext_list(Flis,Nlis,Elis).

filename_to_name_ext_l([],[],[]) :- !.
filename_to_name_ext_l([Fone|Frem],[None|Nrem],[Eone|Erem]) :-
	filename_to_name_ext(Fone,None,Eone),
	filename_to_name_ext_l(Frem,Nrem,Erem).

%-------------------------------------------------------%
%	Others Utility					%
%-------------------------------------------------------%

%-------< not not match >-------------------------------%

not_not_match(L,_) :- var(L),!,fail.  % add by user
not_not_match(L,R) :-
	numbervars(R,0,_),
	\+( L = R ),!,fail.
not_not_match(_,_) :- !.

%-------< get variables >-------------------------------%

get_variables(Term,Vars) :- !,
	get_variables(Term,[],Vars).

get_variables(Var,L,[Var|NewL]) :-
	var_original(Var),!,      % used a original var predicate
	get_variables_in(L,Var,NewL).
get_variables(Term,L,NewL) :-
	functor(Term,_,Arity),
	get_variables_arg(Arity,Term,L,NewL).

get_variables_in([],_,[]) :- !.
get_variables_in([Vone|Vrem],NewVar,Vrem) :-
	Vone == NewVar,!.
get_variables_in([Vone|Vrem],NewVar,[Vone|NewVrem]) :-
	get_variables_in(Vrem,NewVar,NewVrem).

get_variables_arg(0,_,L,L) :- !.
get_variables_arg(C,Term,L,NewL) :-
	arg(C,Term,Arg),
	get_variables(Arg,L,MedL),
	NewC is C - 1,
	get_variables_arg(NewC,Term,MedL,NewL).

% original variable predicate
% If Var is variable or charcter by numbervars predicate
%        then true,
% otherwise false.

var_original(Var) :-
	var(Var);
	(Var =.. [Pre|_] -> Pre = '$VAR';
	    fail).

%-------< counter >------------------------------------%

counter(init,Fun) :- !,
	( retract('COUNT'(Fun,_)) ; true ),!.
counter(up,Fun) :- !,
	counter(get,Fun,_).

counter(set,Fun,Num) :- !,
	( retract('COUNT'(Fun,_)) ; true ),
	asserta('COUNT'(Fun,Num)),!.
counter(get,Fun,Num) :- !,
	( retract('COUNT'(Fun,Num0)),
	  Num is Num0 + 1
	; Num = 1 ),
	asserta('COUNT'(Fun,Num)),!.
counter(refer,Fun,Num) :- !,
	( clause('COUNT'(Fun,Num),_,_) ; Num=0 ),!.

%member(X,[X|_]) :- !.
%member(X,[_|Y]) :- member(X,Y).

members(X,[X|_]).
members(X,[_|Y]) :- members(X,Y).
