% Copyright (C) 1997  Katsumi Inoue 
%
%%% query.pl %%%
%
/***************************************************/
/*						   */
/*           Query command to Action MGTP          */
/*                                                 */
/***************************************************/

/********************/
/* ֤ܤ */
/********************/
transition(A) :- 
	make_situation(A,1),
	assertz(sit(0)),sit(Sit),retract(sit(Sit)),
	program(Form),stone(M,Form),!,
	transition1(M,Sit,1,0),length(M,L),
	assert(mnum(L)),assertz(pf(0,0,0)),assertz(nf(0,0,0)),
	out_transition(1,0),!,retall.

/* ϥޤǤξ */
make_situation(A,Snumc) :- 
	asserta(sit(A)),A = [_|A1],
	Snumc1 is Snumc + 1,make_situation(A1,Snumc1).
make_situation(_,Snumc):- assert(sitnum(Snumc)).

/*֤ (situation loop)*/
transition1(_,0,_,_):- !.
transition1(M,Sit,Mnum,Snum) :- 
	transition2(M,Sit,Mnum,Snum),
	Snum1 is Snum + 1,sit(Sit1),retract(sit(Sit1)),
	transition1(M,Sit1,Mnum,Snum1).

/*֤ (answer sets loop)*/
transition2([],_,_,_) :- !.
transition2([M1|M2],Sit,Mnum,Snum) :- 
	get_neg_fluent(M1,Sit,Mnum,Snum),
	get_pos_fluent(M1,Sit,Mnum,Snum),
	Mnum1 is Mnum + 1,
	transition2(M2,Sit,Mnum1,Snum).

/*ΩƤ롡negative fluents롡*/
get_neg_fluent(M1,Sit,Mnum,Snum) :- 
	member(-holds(NF,Sit),M1)->
	(assert(nf(NF,Mnum,Snum)),delete(-holds(NF,Sit),M1,M2),
	get_neg_fluent(M2,Sit,Mnum,Snum));true.

/*ΩƤ positive fluents롡*/
get_pos_fluent(M1,Sit,Mnum,Snum) :-
	member(holds(PF,Sit),M1) -> 
	(assert(pf(PF,Mnum,Snum)),delete(holds(PF,Sit),M1,M2),
	get_pos_fluent(M2,Sit,Mnum,Snum));true.
	
/* transition ϡ(answer sets loop)*/
out_transition(Mnum,Snum):- 
	nl,write('Answer sets No'),write(Mnum),write(':'),nl,
	out_transition1(Mnum,Snum),
	Mnum1 is Mnum + 1,mnum(L),Mnum1 =< L,out_transition(Mnum1,0).
out_transition(_,_).
        
/* transition (situation loop)*/
out_transition1(Mnum,Snum) :- 
	write('s'),write(Snum),write('={ '),
	out_transition2(Mnum,Snum),
	Snum1 is Snum + 1,sitnum(L),Snum1 < L,
	out_transition1(Mnum,Snum1).
out_transition1(_,_).

/* fluents */
out_transition2(Mnum,Snum) :- 
	pf(PF,Mnum,Snum),retract(pf(PF,Mnum,Snum)),
	write(PF),check_comma(Mnum,Snum),fail.
out_transition2(Mnum,Snum) :- 
	nf(NF,Mnum,Snum),retract(nf(NF,Mnum,Snum)),
	write('-'),write(NF),
	check_comma(Mnum,Snum),fail.
out_transition2(_,_).

check_comma(Mnum,Snum) :- 
	(pf(_,Mnum,Snum)->write(',');
	(nf(_,Mnum,Snum)->write(',');write(' }'),nl)).	    

retall :- 
	retractall(nf(_,_,_)),
	retractall(pf(_,_,_)),
	retractall(mnum(_)),
	retractall(sitnum(_)),
	retractall(sit(_)).


/********************/
/* query holds(F,S) */
/********************/
holds(F,S) :- 
	holds_common_before(F,S,M,Ftmp,Stmp,Mtmp),
	(exist_check(holds(Ftmp,Stmp),Mtmp) -> 
	holds_out(F,S,M);retractall(non_exist(_)),fail).

holds_out(_,_,[]) :- 
	holds_common_after.
holds_out(F,S,[M1|M2]) :-
	print_answer_set(M1),
	!,(member1(holds(F,S),M1);nl,holds_out(F,S,M2)).


/********************/
/* query holds(F,S) */
/********************/
-holds(F,S) :- 
	holds_common_before(F,S,M,Ftmp,Stmp,Mtmp),
	(exist_check(-holds(Ftmp,Stmp),Mtmp) -> 
	-holds_out(F,S,M);retractall(non_exist(_)),fail).

-holds_out(_,_,[]) :- 
	holds_common_after.
-holds_out(F,S,[M1|M2]) :-
	print_answer_set(M1),
	!,(member1(-holds(F,S),M1);nl,-holds_out(F,S,M2)).

/* query holds,-holds ̤ */
holds_common_before(F,S,M,Ftmp,Stmp,Mtmp) :-
	assert(non_exist(0)),
	program(Form),stone(M,Form),!,
	copy_term(M,Mtmp),
	copy_term(F,Ftmp),
	copy_term(S,Stmp).

/* query holds,-holds ̤θ */
holds_common_after :- 
	retractall(non_exist(_)),
	fail.

/* 뤬¸ߤ뤫Υå */
%exist_check(_,[]) :- write('Goal is none !'),!,fail.
exist_check(_,[]).
exist_check(X,[M1|M2]) :- 
	member(X,M1);assert(non_exist(M1)),exist_check(X,M2).

print_answer_set(M1) :-
	(non_exist(M1),
	 write('Anser set :'),nl,write(M1),nl,
	 write('Goal is none !') ;
        (write('Anser set :'),nl,write(M1))),nl.
	
	

/************************/
/* query planning(F,S)  */
/* (F is ground-fluent) */  
/************************/
planning(F,S) :- 
	assert(exist(0)),
	program(Form),
	stone(M,Form),!,
	planning1(F,M,_,S).

/*  S (anser sets loop) */
planning1(_,[],_,_):- fail.
planning1(F,[M1|M2],Stmp,S):-
	print_answer_set2(M1),
	!,
	(planning2(F,M1,Stmp,S);
	      (exist(1)-> true;nl,write('Goal is none !'),nl),
	 retractall(exist(_)),
	 planning1(F,M2,Stmp,S)).

/*  S (fluent loop) */
planning2([],_,Stmp,S) :- S = Stmp,assert(exist(1)).
planning2([F1|F2],M,Stmp,S):-
	(F1 = -(F11)->
	    member1(-holds(F11,Stmp),M);
	    member1(holds(F1,Stmp),M)),
	planning2(F2,M,Stmp,S).

print_answer_set2(M1):-
	nl,write('Anser set :'),nl,
	write(M1),nl.


/**************************/
/*  Domain element  */
/**************************/
/* top-down  alpcompile ΤȤ˥ȤƤ
   ǤѤ domain element 
   bottom-up  ALPϤǵ᤿ǥѤ
   domain element  */
/*----------------------*/
/* (top-down) */
/*----------------------*/
situation :- 
	write('Situations :'),nl,
	situation(X),write(X),nl,fail.

/*-------------------------------*/
/* Ⱦ(bottom-up) */
/*-------------------------------*/
sit_num :- domain_element('Situation').

/*----------------------------*/
/* (top-down) */
/*----------------------------*/
action :- 
	write('Actions :'),nl,
	action(X),write(X),nl,fail.

/*-------------------------------------------*/
/* ȥ(bottom-up) */
/*-------------------------------------------*/
action_num :- domain_element('Action').

/*------------------------------*/
/* ե롼Ȥ(top-down) */
/*------------------------------*/
fluent :- 
	write('Fluents :'),nl,
	fluent(X),write(X),nl,fail.

/*-----------------------------------------------*/
/* ե롼ȿȥե롼Ȥ(bottom-up) */
/*-----------------------------------------------*/
fluent_num  :- domain_element('Fluent').

/*---------------------------------------*/
/* ãǽȤο(bottom-up) */
/*---------------------------------------*/
reachable :- 
	reach,!,
	reachable(S),write(S),
	retractall(reachable(S)),
	nl,fail.

/*--- Domain element θФΤѤؿ ---*/
/* reachable 򥢥 */
reach :- 
	(reach0(M)-> reach1(M,0,0,_),nl,write('Reachables :'),nl,nl
	;write('All situations reachable !')).

/* reachable ޤफΥå */
reach0(M) :- 
	program(Form),
	stone(M,Form),!,
	M = [M1|_],
	count(reachable(_),M1,L),
	(L \== 0 -> true;fail).

/* reachable θ(answer sets loop) */
reach1([],_,_,Csum):- write('Number of Reachables : '),write(Csum),nl,!.
reach1([M1|M2],C,Ctmp,Csum) :-
	reach2(M1,C,Ctmp,Csum),reach1(M2,C,Ctmp,Csum).

/* reachable θ(reachable(S) loop) */
/* ºݤ˥ȤƤ */
reach2([],C,Ctmp,Csum):- (var(C) -> true;Csum is Ctmp + C).
reach2(M1,C,Ctmp,Csum):-
	(member(reachable(S),M1) -> 
	      (reachable(S)-> true;assert(reachable(S)),C1 is C + 1)
	      ,delete(reachable(S),M1,M11),
              reach2(M11,C1,Ctmp,Csum)
	;reach2([],C,Ctmp,Csum)).

/* domain element θФȤοΥ */
domain_element(A) :- 
	do1(X),
	(X == 'No more models' -> write('This Domain has no model!');
	(A == 'Situation' -> count(situation(_),X,L);
	    (A == 'Fluent' -> count(fluent(_),X,L);
	        (A == 'Action' -> count(action(_),X,L))))),
	(write('Number of '),write(A),write('s : '),
	write(L),nl,
	write(A),write('s :'),nl,
	!,domain_element_out(A,X)).

/* domain element ν */
domain_element_out(_,[]) :- !.
domain_element_out(A,X) :- 
	(A == 'Situation' -> 
	     (member(situation(S),X) -> 
	         (write(S),nl,delete(situation(S),X,X1),
                 domain_element_out(A,X1))
	     ;domain_element_out(A,[]));
        (A == 'Fluent' -> 
	     (member(fluent(S),X) -> 
	         (write(S),nl,delete(fluent(S),X,X1),
                 domain_element_out(A,X1))
	     ;domain_element_out(A,[]));
        (A == 'Action' -> 
	     (member(action(S),X) -> 
	         (write(S),nl,delete(action(S),X,X1),
                 domain_element_out(A,X1))
	     ;domain_element_out(A,[])) ))).


/******************************/
/* HELP about Possible Querys */
/******************************/
action_help :- 
	write('*** Possible Query ***'),nl,
	write('   holds(F,S).'),nl,
	write('   -holds(F,S).'),nl,
	write('   transition(A).'),nl,
	write('   planning(A,S).'),nl,
	write('   situation.'),nl,
	write('   sit_num.'),nl,
	write('   fluent.'),nl,
	write('   fluent_num.'),nl,
	write('   action.'),nl,
	write('   action_num.'),nl,
	write('   reachable.'),nl.












