% Copyright (C) 1997  Katsumi Inoue 
%
%%% pr2uty.pl %%%
%
%
% pr2mgtp --utility--
%
:- dynamic 'Component'/1.

sigma(N,Num) :-
	sigma1(N,0,Num),!.
sigma1(0,X,X).
sigma1(N,X,Num) :-
	Y is N + X,
	N1 is N -1,
	sigma1(N1,Y,Num).

in_var_take(G,X) :-
	(var_original(G);G =.. [_|Para]),
	in_variable(Para,X).

in_variable([],[]).
in_variable([X|L],[X|Y]) :- var_original(X),in_variable(L,Y).
in_variable([X|_],Y) :- in_var_take(X,Y).
in_variable([_|L],Y) :- in_variable(L,Y).
	

%
% if goal:G includes variables then return succese
% else return fail.
% variable of numbervars is ok.
%
in_var_hold(G) :-
	(var_original(G);G =.. [_|Para]),
	in_variable_hold(Para).

in_variable_hold([X|_]) :- var_original(X).
in_variable_hold([X|_]) :- in_var_hold(X).
in_variable_hold([_|L]) :- in_variable_hold(L).


% Initialize of component number
'Component'(10).

%
% <<<< set_component >>>>
% set default number
%
set_component :-
	retract('Component'(_)),
	asserta('Component'(10)).

%
% <<<< set_component(N) >>>>
% set component number N
%
set_component(N) :-
	retract('Component'(_)),
	asserta('Component'(N)).

%
% <<<< component_check(S) >>>>
% check component number:N of literal
% for Num of 'Component'(Num)
%   if Num < N then Yes,else No.
%
component_check(S) :-
	component_literal(S,0,N),
	'Component'(Num),!,
	N > Num.

%
% <<<< component_literal(G,Init,N) >>>>
% return component number:Num of literal
% Init is initialize:0
%
component_literal(G,Init,Num) :-
	(var(G);G =.. [_|Para]),
	N1 is Init +1,
	component(Para,N1,Num).

component([],N,N).
component([X|L],N,N1) :- 
	component_literal(X,N,Num),
	component(L,Num,N1).


%
% make negative clause list
%
nclause1_list(New,[M1|M2]) :-
	(var(M1) -> M1 = New;
	    (hold_equal(M1,New) ->true;nclause1_list(New,M2))).

hold_equal(X,Y) :-
	copy_term([X,Y],[X1,Y1]),
	numbervars(X1,0,_),numbervars(Y1,0,_),!,
	X1 = Y1.

nclause2_list(New,[M1|M2]) :-
	(var(M1) -> M1 = New;nclause2_list(New,M2)).


% append
%append([],L,L).
%append([X|L1],L2,[X|L3]) :- append(L1,L2,L3).

%
% append1
%   not contain same literal
%
append1([],L,L).
append1([X|L1],L2,[X|L3]) :- \+member(X,L2),append1(L1,L2,L3).
append1([_|L1],L2,L3) :- append1(L1,L2,L3).


%
% <<<< equal_list(X,Y) >>>>
%    If List X equal List Y then return Yes else return No.
%
equal_list([],[]).
equal_list([X|L],L1) :-
	member(X,L1),
	delete_list(weak,X,L1,L2),
	equal_list(L,L2).

%
% <<<< equal_list(X,Y) >>>>
%    If List X equal List Y then return Yes else return No.
%
each_holds_equal_list(X,Y) :-
	copy_term(X,X1),copy_term(Y,Y1),
	numbervars(X1,0,_),numbervars(Y1,0,_),
	equal_list(X1,Y1).

holds_equal_list(X,Y) :-
	copy_term([X,Y],[X1,Y1]),
	numbervars([X1,Y1],0,_),
	equal_list(X1,Y1).


member2(_,[]).
member2(X,[Y|R]) :- X = Y,member2(X,R).
member2(X,[_|R]) :- member2(X,R).

%
% <<< hold_member(X,L) >>>>
%   member for hold X and L
%
hold_member(X,L) :-
	copy_term([X,L],[X1,L1]),!,
	numbervars(X1,0,_),
	numbervars(L1,0,_),
	member(X1,L1).

%
% last element of list
%
last_list([X],X).
last_list([_|X],Y) :- last_list(X,Y).


%
% check of whether skip or
%                  skip and original
%
check_not_only_skip(AL,O,N,Skip) :-
	(O = [] -> S1 = [];check_each_literal(O,AL,S1)),
	(N = [] -> S2 = [];check_each_literal(N,AL,S2)),
	append(S1,S2,Skip).

%
% check of whether skip or
%                  skip and original for list
%
check_each_literal([],_,_).
check_each_literal([O|R],AL,S) :-
	whether_skip(O,AL,S),!,
	check_each_literal(R,AL,S).
check_each_literal([_|R],AL,S) :-
	check_each_literal(R,AL,S).

%
% main of check for skip or skip and original
%
whether_skip(_,[],_).
whether_skip(O,[AL|R],S) :-
	(subsume(O,AL) -> whether_skip(O,R,S);
	    (subsume(AL,O) -> set_list(AL,S);whether_skip(O,R,S))).

set_product(X,X3) :-
	mem_set(X,X1),
	make_set(_,X,[],X2),	
	append(X2,X1,X3).

mem_set([],[]).
mem_set([X|R],[[X]|L]) :- mem_set(R,L).

make_set(_,[],[],_).
make_set(_,X,[],S) :-
	X = [H|R],
	make_set([H],R,R,S).
make_set(X,O,[R|L1],S) :-
	append(X,[R],Y),
	set_list(Y,S),
	make_set(Y,L1,L1,S),
	make_set(X,O,L1,S).

set_list(New,[New|_]).
set_list(New,[M1|M2]) :-
	(var(M1) -> M1 = New;
	    set_list(New,M2)).

%
% ---- divide(X,Y,P,Q) ----
% P is a part of list X such is same length of Y
% Q is rest list
% therefore append(P,Q,X)
%
divide(L,[],[],L).
divide([X|R],[_|R1],[X|R2],Y) :-
	divide(R,R1,R2,Y).


%
% <<<< intersection_ne(X,Y,Z) >>>>
% Z is intersection of X and abducible:Y
% if element of X == element of Y then not contain element of Z
%
intersection_ne([],_,[]).
intersection_ne([X|R],Y,[X|Z]) :-
	subsume_list_ne(X,Y),!,
	intersection_ne(R,Y,Z).
intersection_ne([_|R],Y,Z) :- intersection_ne(R,Y,Z).

%
% <<<< hold_intersection(X,Y,Z) >>>>
% Z is intersection of X and abducible:Y
% numbervars version
%
hold_intersection(X,Y,Z) :-
	copy_term([X,Y],[X1,Y1]),
	numbervars([X1],0,_),
	numbervars([Y1],0,_),
	hold_intersection1(X1,Y1,Z).

hold_intersection1([],_,[]).
hold_intersection1([X|R],Y,[X|Z]) :-
	member(X,Y),!,
	hold_intersection1(R,Y,Z).
hold_intersection1([_|R],Y,Z) :- hold_intersection1(R,Y,Z).

%
% <<<< intersection(X,Y,Z) >>>>
% Z is intersection of X and abducible:Y
%
intersection([],_,[]).
intersection([X|R],Y,[X|Z]) :-
	subsume_list(X,Y),!,
	intersection(R,Y,Z).
intersection([_|R],Y,Z) :- intersection(R,Y,Z).

%
% <<<< subtraction(X,Y,Z) >>>>
% Z is that remove abducible:Y from X.
%
subtraction([],_,[]).
subtraction([X|R],Y,Z) :-
	member(X,Y),!,
	subtraction(R,Y,Z).
subtraction([X|R],Y,[X|Z]) :-
	subtraction(R,Y,Z).


%
% <<<< subsume_list_ne(X,Y) >>>>
% if X is subsumed element of list:Y
%      then return Yes,
%      else return No.
% if X == element of Y then not contain element of Z
%
subsume_list_ne(X,[Y|_]) :- subsume_ne(X,Y).
subsume_list_ne(X,[_|R]) :- subsume_list_ne(X,R).

%
% <<<< subsume_list(X,Y) >>>>
% if X is subsumed element of list:Y
%      then return Yes,
%      else return No.
%
subsume_list(X,[Y|_]) :- subsume(X,Y).
subsume_list(X,[_|R]) :- subsume_list(X,R).

%
% <<<< subsume1_list(X,Y) >>>>
% if X subsume element of list:Y
%      then return Yes,
%      else return No.
%
subsume1_list(X,[Y|_]) :- subsume(Y,X).
subsume1_list(X,[_|R]) :- subsume1_list(X,R).

%
% <<<< subsume(X,Y) >>>>
% if X is subsumed Y
%      then return Yes,
%      else return No.
%
subsume(X,Y) :-
	copy_term(X,X1),
	copy_term(Y,Y1),
	numbervars(X1,0,_),!,
	X1 = Y1.

%
% <<<< subsume_ne(X,Y) >>>>
% if X is subsumed Y
%      then return Yes,
%      else return No.
% if X == Y then return No.
%
subsume_ne(X,Y) :-
	copy_term(X,X1),
	copy_term(Y,Y1),
	copy_term(Y,Y2),
	numbervars(X1,0,_),!,
	numbervars(Y2,0,_),!,
	X1 = Y1,
	\+(X1 == Y2).



