% Copyright (C) 1997  Katsumi Inoue 
%
%%% act_alp.pl %%%
%
/*********************************************/
/**                                         **/   
/**   Translation Program to                **/
/**	  Logic Program(ALP input clauses)  **/
/**                   from Action Domains.  **/ 
/**                                         **/   
/**   줫ץؤ  **/
/**                        Ѵץ   **/
/**                                         **/   
/*********************************************/


/*-----     Ϥβǽޥ     -----*/
/* 1. actcompile(file). ->                */
/*          situation([A2,A1])<- action(A1),action(A2). */
/* 2. actcompile1(file,n). ->  n            */
/* 3. actcompile2(file,A).                              */
/*      AϥΥꥹ:ʺǽ[an,...,a1] */
/*      ->      situation([an,...,a1]).           */

actcompile(File):- actcompile1(File,2).
actcompile1(File,N) :- 
	time(_),
	assert(filename(File)),
	assert(sit(N)),assert(string(*)),
	(act(File)-> fail;true),!.
actcompile2(File,A) :- 
	time(_),
	assert(filename(File)),
	assert(string(A)),assert(sit(*)),
	(act(File)-> fail;true).


/*------------  ᥤؿ -------------*/
/* (1).  : preface                  */
/* (2). 1ɤ߹ : readline            */
/* (3). Υå : dis_check    */
/* (4). ɤ꤫̿å : syntax_check */
/* (5). ѿΤν : var_check      */
/* (6). ѴȽ : pi0,pi1,pi2,pi3      */
/* (2)(6)ޤǤ򷫤֤                 */

act(File):- 
	preface(File),
	repeat,
            readline(X,J),
	    ((J== -1) -> (!,fail);
	    (dis_check(X,X1),
	    comma_check(X1,_,X2),
            syntax_check(X2,Y),
	    var_check(Y,[],_),
	    pi0(Y),pi1(Y),pi2(Y),pi3(Y),
	fail)).
act(_).

/*------------*/
/*(1)   */
/*------------*/

/* ե ¹Բǽ̿ޤफȽʤ*/
preface(File):- 
	assert(f(*)),assert(a(*)),
	assert(reachable(*)),assert(var_list(*,*)),
	name(File,Fcode),
	append(Fcode,[46,112,114],Newcode),
	name(NewFile,Newcode),
	append(Fcode,[46,100,111,109],Orgcode),
	name(OrgFile,Orgcode),
	tell(NewFile),see(OrgFile),
	(executability_judge->fail;see(OrgFile)).

/* ¹Բǽ̿ޤफȽ*/
executability_judge :- 
	repeat,
        readline_pre(X,J),
        (J== -1,!,fail;
	    (member1(impossible,X) -> 
		assert(reachable(include));true)
	,fail).

reachable_include:- reachable(include).

readline_pre([W|WS],TC):- 
	get0(TC),!,
	(TC== -1,seen;readword(TC,W,DC),
        W\==[],restline(DC,WS),!).
readline_pre([],_):- !.


/*----------------------*/
/*  repeat (2)---(6)    */
/*----------------------*/

/*-----  (2)ɤ߹  -----*/
/* Ԥɤ߹ؿ               */
/* load causes loaded.ɤ.     */
/* readline([load,causes,loaded]).  */

readline([W|WS],TC):- 
	get0(TC),!,
	(TC== -1,aftercare;readword(TC,W,DC),
        W\==[],restline(DC,WS),!).
readline([],_):- !.

/* ʬؿ */
readword(TC,W,DC):- 
	filter(TC,TCode),!,get0(C),
	restword(C,RCode,DC),
	name(W,[TCode|RCode]).
readword(10,[],_):- !.
readword(_,W,DC):- get0(C),readword(C,W,DC).

/* ŬڤʸΤߤ̲ᤵե륿 */
filter(45,45):- !.
filter(40,40):- !.
filter(41,41):- !.
filter(95,95):- !.
filter(124,124):- !.
filter(Ch,Ch):- Ch>64,Ch<91,!. 
filter(Ch,Ch):- Ch>96,Ch<123,!. 
filter(Ch,Ch):- Ch>47,Ch<58.

/* ɤ߹ߤ³ؿ */
restword(Ch,[Co|R_Co],D):-  
	filter(Ch,Co),!,get0(Next),
	restword(Next,R_Co,D).
restword(Ch,[],Ch).

/* ԤνȽǤؿ */
restline(10,[]):- !.
restline(C,[W|WS]):- 
	readword(C,W,DC),W\==[],restline(DC,WS).
restline(_,[]):- !.

/* ʳƵ§νϤʤɡ*/
aftercare:- 
	initial_complete,
	situation_generation,
	domain_law,
	inertia_law_ab,
	reachability_law,
	seen,told,out,
	retractall(reachable(_)),
	time(T),
	printf(['actcompile ... ']),
	print_time(T).

/* λ */
out :- retract(filename(File)),
	write('saving program in '),
	write(File),
	write('.pr ...done !!'),nl.


/*-----   (3)Υå  -----*/

/* νåؿ */
dis_check(X,X1) :- member('|',X),modify(X,_,[],X1),!.
dis_check(X,X):- !.

/* νؿ            */
/*  [f1,f2,|,f3] -> [f1,f2|f3] */

modify([],_,Res,Xnew):- reverse(Res,Xnew),!.
modify(['|'|X2],Pre,[_|Rest],Xnew):-
	name(Pre,Precode),
	X2 = [X2h|X2t],
	name(X2h,X2hcode),
	append([124],X2hcode,X2hcode1),
	append(Precode,X2hcode1,Xnewcode),
	name(Xnewc,Xnewcode),
	append([Xnewc],Rest,Res1),
	modify(X2t,Xnewc,Res1,Xnew) .
modify([X1|X2],_,Res,Xnew):-
	Pre = X1,
	append([X1],Res,Res1),
	modify(X2,Pre,Res1,Xnew).

/* [always, loc(X , 1) , loc(X , 2 ...] ->
	[always, loc(X,1) , loc(X,2) ,...] */
comma_check([],Xtmp,Xout) :- Xout = Xtmp,!.
comma_check([Xh|Xt],Xtmp,Xout):-
	name(Xh,Xhcode),
	member(40,Xhcode),
	\+ member(41,Xhcode),!,
	comma_check1(Xhcode,Xt,Xtmp1,Xt1),
	append(Xtmp,[Xtmp1],Xtmp2),!,
        comma_check(Xt1,Xtmp2,Xout).
comma_check([Xh|Xt],Xtmp,Xout):-
	append(Xtmp,[Xh],Xtmp1),!,
	comma_check(Xt,Xtmp1,Xout).

comma_check1(Xhcode,[Xth| Xtt],Xtmp1,Xt1):-
	name(Xth,Xthcode),
	member(41,Xthcode),
	append(Xhcode,[44],Xhcode1),
	append(Xhcode1,Xthcode,Xtmpcode),
	name(Xtmp1,Xtmpcode),
	(member(124,Xthcode),\+ last(41,Xthcode)-> 
	    comma_check1(Xtmpcode,Xtt,Xtmp1,Xt1);Xt1 = Xtt),!.
comma_check1(Xhcode,[Xth|Xtt],Xtmp1,Xt1):-
	name(Xth,Xthcode),
	append(Xhcode,[44],Xhcode1),
	append(Xhcode1,Xthcode,Xtmpcode),!,
	comma_check1(Xtmpcode,Xtt,Xtmp1,Xt1).
	
/*-----   (4)ɤ꤫̿å   -----*/

syntax_check(X,Y):- 
	member1(after,X),
	conc(F,[after|A],X),action_after(A),
	Y=[after,F,A].
syntax_check(X,Y):- 
	member1(initially,X),
	conc([initially],F,X),
	Y=[initially,F].
syntax_check(X,Y):- 
	member1(suffices,X),
	conc(F1,[suffices,for|F2],X),
        Y=[suffices,F1,F2].
syntax_check(X,Y):- 
	member1(always,X),
	conc([always],F,X),
	Y=[always,F].
syntax_check(X,Y):- 
	member1(never,X),
	conc([never],F,X),
	Y=[never,F].
syntax_check(X,Y):- 
	member1(impossible,X),
	conc([impossible,A],[if|F],X),action_stac(A),
	Y=[impossible,A,F].
syntax_check(X,Y):- 
	member1(if,X),member1(causes,X),
	X=[X1|X2],conc([causes|F],[if|P],X2),
	action_stac(X1),Y=[causes1,X1,F,P],!.
syntax_check(X,Y):- 
	member1(causes,X),
	X=[X1|X2],conc([causes],F,X2),
	action_stac(X1),Y=[causes2,X1,F].

/*----- (5)ѿޤΰΤν -----*/	
/* ѿޤॢ󡢥ե롼ȤμФ */
/* ex. f(X),f(Y) suffices for f1(X,Y) */
/*     var_list = [[f1(X,Y)],[f(X),f(Y)]]. 򥢥 */

var_check([after,_,_],_,_):-
	(var_list([],[]) -> true;
	                    assert(var_list([],[]))).
var_check([initially,_],_,_):-
	(var_list([],[]) -> true;
	                    assert(var_list([],[]))).
var_check([suffices,F1,F2],Ltmp,Lout2):-
	var_check1(F1,Ltmp,Lout1,fluent),
	var_check1(F2,[],Lout2,fluent),
	(var_list(Lout2,Lout1) -> true;assert(var_list(Lout2,Lout1))).
var_check([always,_],_,_):-
	(var_list([],[]) -> true;
	                    assert(var_list([],[]))).
var_check([never,_],_,_):-
	(var_list([],[]) -> true;
	                    assert(var_list([],[]))).
var_check([impossible,A,F],Ltmp,Lout2):-
	var_check1(F,Ltmp,Lout1,fluent),
	var_check1([A],[],Lout2,action),
	(var_list(Lout2,Lout1) -> true;assert(var_list(Lout2,Lout1))).
var_check([causes1,A,F,P],Ltmp,Lout3):-
	var_check1(F,Ltmp,Lout1,fluent),
	var_check1(P,Lout1,Lout2,fluent),
	var_check1([A],[],Lout3,action),
	(var_list(Lout3,Lout2) -> true;assert(var_list(Lout3,Lout2))).
var_check([causes2,A,F],Ltmp,Lout2):-
	var_check1(F,Ltmp,Lout1,fluent),
	var_check1([A],[],Lout2,action),
	(var_list(Lout2,Lout1) -> true;assert(var_list(Lout2,Lout1))).

/* ̿ѿޤե롼Ȥ䥢Ф */
/* ex. f(X),f(Y) suffices for f1(X,Y) -> [f(X),f(Y)] or [f1(X,Y)] */

var_check1([],[],Lout,_):- Lout=[],!.
var_check1([],Ltmp,Lout,_):- Lout = Ltmp,!.
var_check1(List,Lvar,Lout,Func):-
        List = [X|List1],
	var_check2(X,Lvar,Lvar1,Func),
	!,var_check1(List1,Lvar1,Lout,Func).
var_check1(List,Lvar,Lout,Func):- 
	List=[_|List1],
	var_check1(List1,Lvar,Lout,Func).

var_check2(X,Lvar,Lvar1,Func):-
	name(X,Xcode),
	member(124,Xcode),
	disjunction_write_common(X,X1,_,X2),
	non_ground(X1),!,
	notrm(X1,X11),
	XX =.. [Func,X11],
	(\+ member(XX,Lvar)->
        append(Lvar,[XX],Lvartmp);Lvar = Lvartmp),
	!,var_check2(X2,Lvartmp,Lvar1,Func).
var_check2(X,Lvar,Lvar1,Func):-
	non_ground(X),!,
	notrm(X,X1),
	XX =.. [Func,X1],
	(\+ member(XX,Lvar)->
        append(Lvar,[XX],Lvar1);Lvar = Lvar1).


/*-----  (6)̿ѴʬʽϤޤ -----*/

/*--- ̿Ѵ ---*/
/* value̿                             */
/* F after A1;...;Am ηѴؿ  */
pi0([after,_,_]).

pi1([after,[],_]):- !.
pi1([after,[F1|F2],[A1|A2]]):- 
	reverse([A1|A2],REV),
        disjunction_write_value(F1,REV),
	write_comma_period(F2),
	pi1([after,F2,[A1|A2]]).
pi2([after,_,_]).
pi3([after,_,_]).

/* initially F ηѴؿ */
pi0([initially,_]).

pi1([initially,[]]):-!.
pi1([initially,[F1|F2]]):- 
	disjunction_write_value(F1,[]),
	write_comma_period(F2),
	pi1([initially,F2]).
pi2([initially,_]).
pi3([initially,_]).

/* sufficency̿ */
/* F1 suffices for F2 ηѴؿ */
pi0([suffices,F1,[]]):- 
	write_sit_action,
	write_comma_period(F1),!.
pi0([suffices,F1,[F21|F22]]):- 
	disjunction_write_suff(F21),
	write_comma(F22),
	pi0([suffices,F1,F22]).

pi1([suffices,[],_]):-!.
pi1([suffices,[F11|F12],F2]):- 
	write_holds_suff(F11),
	write_comma_period(F12),
	pi1([suffices,F12,F2]).

pi2([suffices,_,[]]):- 
	write(' <- '),!.
pi2([suffices,F1,[F21|F22]]):- 
	disjunction_write_suff_0(F21),
	write_comma(F22),
	pi2([suffices,F1,F22]).

pi3([suffices,[],_]):-!.
pi3([suffices,[F11|F12],F2]):- 
	write_holds_0(F11),
	write_comma_period(F12),
	pi3([suffices,F12,F2]).

/* always F ηѴؿ */
pi0([always,_]).

pi1([always,[]]):- !.
pi1([always,[F1|F2]]):- 
	disjunction_write_suff(F1),
	write_comma_arrow_sit(F2),
	pi1([always,F2]).  
pi2([always,_]).
pi3([always,_]).

/* never F ηѴؿ */
pi0([never,F]):- 
	write_sit_arrow,
	write_comma_period(F).

pi1([never,[]]):-!.
pi1([never,[F1|F2]]):- 
        write_holds(F1),
	write_comma_period(F2),
        pi1([never,F2]).  
pi2([never,_]).
pi3([never,_]).

/* ¹Բǽ̿ */
/* impossible A if P ηѴؿ */
pi0([impossible,A,_]):- 
	write('-reachable(['),write(A),write('|S]) <- ').

pi1([impossible,[],_]):-!.
pi1([impossible,A,[F1|F2]]):- 
	write_holds(F1),
        write_comma_period(F2),
        pi1([impossible,A,F2]).
pi2([impossible,_,_]).

/* effect̿ */
/* A causes F if P ηѴؿ */
pi0([causes1,A,[],P]):-
	write_comma_sit_action1([],A),
	write_comma_period(P),!.
pi0([causes1,A,[F1|F2],P]):- 
	disjunction_write_effect(F1,A),
        write_comma(F2),
        pi0([causes1,A,F2,P]).

pi1([causes1,_,_,[]]):-!.
pi1([causes1,A,F,[P1|P2]]):- 
	    write_holds(P1),
	    write_comma_period(P2),
	    pi1([causes1,A,F,P2]).

pi2([causes1,_,_,_]).
pi3([causes1,_,_,_]).

/* A causes F ηѴؿ */
pi0([causes2,_,_]):- !.


pi1([causes2,A,[]]):- write_comma_sit_action2([],A),!.
pi1([causes2,A,[F1|F2]]):- 
	disjunction_write_effect(F1,A),
	write_comma(F2),
	pi1([causes2,A,F2]).

pi2([causes2,_,_]).
pi3([causes2,_,_]).


/*-----  ̿ν  -----*/
/* ','  */
write_comma(F) :-
	(F\==[] -> write(',');true).

/* '.' or ','  */
write_comma_period(F) :-
        (F==[])->write('.'),nl,!;
        write(',').

/* '<- reachable(S)' or '<- situation(S)' or ','  */
write_sit_arrow:-
	(reachable_include -> 
	       write('<- reachable(S)');
               write('<- situation(S)')).

/* '<- reachable([A|S])' or '<- situation([A|S])' or ','  */
write_sit_action:-
	(reachable_include -> 
	       write(' <- reachable([A|S])');
               write(' <- situation([A|S])')).

/* '<-reachable(S).' or '<-situation(S).' or ','  */
write_comma_arrow_sit(F) :-
        (F==[])->
	    (reachable_include -> 
	         write(' <- reachable(S).');
                 write(' <- situation(S).')),
	nl;
        write(',').

/* ',reachable([A|S]).' or ',situation([A|S]).' or ','  */
write_comma_sit_action1(F,A) :-
            (F==[])->
	    (reachable_include -> 
	         (write(' <- reachable(['),
	         write(A),write('|S])'));
		 (write(' <- situation(['),
	         write(A),write('|S])')))
        ;
        write(',').

/* '<-reachable([A|S]).' or '<-situation([A|S]).' or ','  */
write_comma_sit_action2(F,A) :-
        (F==[])->
  	    (reachable_include -> 
	         (write(' <- reachable(['),
	         write(A),write('|S]).'));
		 (write(' <- situation(['),
	         write(A),write('|S]).'))),
        nl;
        write(',').


/* holdsϴؿ(value) */
write_holds_value(F,REV):- 
	notrm(F,FO),fluent_stac(FO),
        Y=.. [holds,FO,REV],
        not_out(F),
        write(Y).

/* holdsϴؿ(common) */
write_holds(F) :- notrm(F,FO),fluent_stac(FO),
        Y=.. [holds,FO,S],name(S,[83]),not_out(F),
        write(Y).

/* holdsϴؿ(common) */
write_holds_0(F) :- notrm(F,FO),
        Y=.. [holds,FO,[]],not_out(F),
        write(Y).

/* abϴؿ(suff) */
write_ab_suff(F) :- 
	write(','),
        notrm(F,FO),fluent_stac(FO),
        Y=.. [ab,FO,A,S],
	name(S,[83]),name(A,[65]),
        write(Y).

/* holdsϴؿ(suff-ab-body) */
write_holds_suff(F) :- notrm(F,FO),fluent_stac(FO),not_out(F),
        write('holds('),write(FO),write(',[A|S])').

/* holdsϴؿ(effect-head) */
write_holds_effect(F,A):- 
	notrm(F,FO),fluent_stac(FO),
        not_out(F),write('holds('),write(FO),
        write(',['),write(A),write('|S])').

/* abϴؿ(effect) */
write_ab_effect(F,A):- 
	notrm(F,FO),fluent_stac(FO),
        write(',ab('),write(FO),
        write(','),write(A),write(',S)').

/* ξν(value) */
disjunction_write_value(Fdis,REV):-
	disjunction_write_common(Fdis,F1,F2code,F2),
	write_holds_value(F1,REV),write(' ; '),
	(member(124,F2code)->
	     disjunction_write_value(F2,REV),!;
	     (write_holds_value(F2,REV),!)).
disjunction_write_value(Fdis,REV):- 
	write_holds_value(Fdis,REV).
 
/* ξν(sufficiency) */
disjunction_write_suff(Fdis):-
	disjunction_write_common(Fdis,F1,F2code,F2),
	write_holds_suff(F1),
	write_ab_suff(F1),
	write(' ; '),
	(member(124,F2code)->
	     disjunction_write_suff(F2),!;
	     (write_holds_suff(F2),write_ab_suff(F2),!)).
disjunction_write_suff(Fdis):- 
	write_holds_suff(Fdis),write_ab_suff(Fdis).

/* ξν([] sufficiency) */
disjunction_write_suff_0(Fdis):-
	disjunction_write_common(Fdis,F1,F2code,F2),
	write_holds_0(F1),
	write(' ; '),
	(member(124,F2code)->
	     disjunction_write_suff_0(F2),!;
	     (write_holds_0(F2),!)).
disjunction_write_suff_0(Fdis):- 
	write_holds_0(Fdis).

/* ξν(effect) */
disjunction_write_effect(Fdis,A):-
	disjunction_write_common(Fdis,F1,F2code,F2),
	write_holds_effect(F1,A),
	write_ab_effect(F1,A),
	write(' ; '),nl,
	(member(124,F2code)->
	     disjunction_write_effect(F2,A),!;
	     (write_holds_effect(F2,A),write_ab_effect(F2,A),!)).
disjunction_write_effect(Fdis,A):- 
	write_holds_effect(Fdis,A),
	write_ab_effect(Fdis,A).
        
/* ξν(common) */
disjunction_write_common(Fdis,F1,F2code,F2):-
	name(Fdis,Fcode),
	member(124,Fcode),
	divide_two_list(124,Fcode,F1code,F2code),
	delete([],F1code,F11code),!,
        name(F1,F11code),name(F2,F2code).

/* ĤΥꥹȤʬ䤹ؿ            */
/*  cʬ [a,b,c,d,e] -> [a,b],[d,e] */
divide_two_list(X,[Y|Z],[Res1|Result1],Result2):-
	X==Y -> 
	    Res1 = [],
	    Result1 =[],
	    Result2=Z;
            Res1 = Y,
	    divide_two_list(X,Z,Result1,Result2).


/*-----  Ƶ§ν  -----*/

/* § */
initial_complete:- 
	write('holds(F,[]);-holds(F,[])<- fluent(F).'),nl,
        retractall(f(*)),fluent_dom.

fluent_dom:- 
	retract(f(FO)),D1=.. [fluent,FO],
        write(D1),write('.'),nl,fluent_dom.
fluent_dom.

/* ؿ */
situation_generation :- 
	sit(N),
	N \== '*',
	write('situation(['),
	make_string(N,N),
	write_sit(1,N),
	write_sit2,
	retract(sit(_)),!.
situation_generation :- 
	string(A),
	A\=='*',
	write_sit3(A),
	write_sit2,
	retract(string(_)),!.

make_string(NC,N):- 
	NC \== 0 ,
	write('A'),write(NC),
	(NC == 1 -> 
	    write('])<- ');
            write(','),NC1 is NC - 1,
	    make_string(NC1,N)).
make_string(_,_) :- !.

write_sit(NC,N) :- 
	NC =< N ,
	write('action(A'),write(NC),write(')'),
	(NC == N -> 
	    write('.'),nl;
            write(','),NC1 is NC + 1,
	    write_sit(NC1,N)).
write_sit(_,_):- !.  
write_sit2 :-
	write('situation(S)<- situation([A|S]).'),nl,
        retractall(a(*)),action_dom.
write_sit3(A) :-
	write('situation('),write(A),write(').'),nl.

action_dom :- 
	retract(a(A)),D2=.. [action,A],
        write(D2),write('.'),nl,action_dom.
action_dom.

/* ˡ§ν */
inertia_law :- 
	write('holds(F,[A|S]) <- holds(F,S),'),
	(reachable_include-> 
	     write('reachable([A|S]),');
             write('situation([A|S]),')),
        write('not -holds(F,[A|S]).'),nl,
	write('-holds(F,[A|S]) <- -holds(F,S),'),
	(reachable_include-> 
	     write('reachable([A|S]),');
             write('situation([A|S]),')),
        write('not holds(F,[A|S]).'),nl.
inertia_law_ab :- 
	write('holds(F,[A|S]) <- '),
	(reachable_include-> 
	     write('reachable([A|S]),');
             write('situation([A|S]),')),
        write('holds(F,S),'),
        write('not ab(F,A,S).'),nl,
	write('-holds(F,[A|S]) <- '),
	(reachable_include-> 
	     write('reachable([A|S]),');
             write('situation([A|S]),')),
        write('-holds(F,S),'),
        write('not ab(F,A,S).'),nl.

/* reachability§ */
reachability_law :- 
	(reachable_include->reachability_law1,reachability_law2;true).

reachability_law1 :-
	write('reachable(S)<- situation(S),'),
	write('not -reachable(S).'),nl,
	write('-reachable([A|S])<- situation([A|S]),'),
	write('-reachable(S).'),nl.

reachability_law2 :-
	write('<- -reachable(S),holds(F,S).'),nl,
	write('<- -reachable(S),-holds(F,S).'),nl.
	
/* ΰ̾§ */
domain_law :- 	retract(var_list(*,*)),domain_law0.
domain_law0 :- 
	retract(var_list(Lvarh,Lvart)),
	domain_law1(Lvarh,Lvart),domain_law0.
domain_law0.

domain_law1([],_).
domain_law1(Lvarh,Lvart) :-
	write_head(Lvarh),
	write_body(Lvart).

write_head([]).
write_head([L1|L2]):-
	write(L1),
	(L2 == [] -> write(' <- ');write(',')),
	write_head(L2).

write_body([]).
write_body([L1|L2]):-
	write(L1),
	(L2 == [] -> write('.'),nl;write(',')),
	write_body(L2).


/*-----------------------------*/
/*-----  桼ƥƥ -----*/
/*-----------------------------*/

/* -Ϥؿ*/
not_out(F):- name(F,X),X=[Xx|_],not_out1(Xx).   
not_out1(45):- write('-'),!.
not_out1(_).

/* -ؿ */
notrm(F,FO):- name(F,X),X=[Xx|Xy],Xx=45,name(FO,Xy),!.
notrm(F,FO):- FO=F.

/* domҸμ */
fluent_stac(FO):- name(FO,Fcode),
	member(124,Fcode),((Fcode == 124,!);
	divide_two_list(124,Fcode,Acode,Bcode),
	delete([],Acode,Acode1),
	name(A,Acode1),
	name(B,Bcode),fluent_stac(A),fluent_stac(B),!).
fluent_stac(FO):- f(F),F==FO,!.
fluent_stac(FO):- \+ non_ground(FO),!,assert(f(FO)).
fluent_stac(_).

action_stac(A):- a(AO),AO==A,!.
action_stac(A):- \+ non_ground(A),!,assert(a(A)).
action_stac(_).
action_after([]):- !.
action_after(A) :- member(Amem,A),
	action_stac(Amem),
	A=[_|A2],
	action_after(A2).
non_ground(X):- name(X,Xcode),member1(Xcode1,Xcode),
	Xcode1 > 64,Xcode1 < 91.








