/* ----------------------------------------------------------
%        Copyright (C) 1996-1997 Kazuhiko Ohno, Masahiko Ikawa,
%        and Computer Architecture Laboratory, Depertment of
%        Information Science, Kyoto University.
%----------------------------------------------------------- */  

/* ---------------------------------------------------------- 
	 %   (C)1993,1994,1995 Institute for New Generation Computer Technology 
	 %       (Read COPYRIGHT for detailed information.) 
	 ----------------------------------------------------------- */

#define MAIN
#include <klic/wdebug.h>
#ifndef FIRST
#ifdef DIST
/*#define exit(X) myexit(__FILE__, __LINE__, X)*/
#endif
#include <klic/basic.h>
#include <klic/struct.h>
#include <klic/primitives.h>
#include <klic/unify.h>
#include <klic/timing.h>
#include <klic/functorstuffs.h>

#include <string.h>
#include <stdio.h>
#include <setjmp.h>
#include <errno.h>
#ifdef USESIG
#include <signal.h>
#endif

#ifdef SHM
#include <klic/shm.h>
#endif

#ifdef SCHED
#include <klic/sched.h>
#include <klic/debugprint.h>
#include <klic/schedobj.h>
#include <klic/testpredicate.h>
#endif

#ifdef DIST
/*#include <klic/trace.h>*/
#include <time.h>
#include <sys/types.h>
#include <unistd.h>
#include <klic/distio.h>
#include <klic/interpe.h>
#include <klic/sighndl.h>
#include <klic/rmon.h>

int receive_message();
q* gc_exp_table();
q* gc_decode_stack();
q* scan_imp_table();

#ifdef PACKSEND
q* gc_pk_flg();
#endif

#endif
#include <klic/options.h>


extern char *runtime_version, *runtime_date;

jmp_buf klic_topmost;
int start_tracing = 0;
#ifdef DEBUGLIB
int count_suspension = 0;
#endif
#ifdef DIST
int pvmdebug = 0;
#endif
#ifdef USETIMER
static Volatile int dummy_alarm_set;
#endif /*USETIMER*/
module module_main();

extern  struct predicate predicate_main_xmain_0;

#ifdef SCHED
extern q* topsucceed_stackp;
#endif

#ifdef DIST
extern Const struct predicate topsucceed_pred;
#endif

char *optarg;

#ifdef DIST
static int
kill_tasks (allocp, sig)
q *allocp;
int sig;
{
    klic_fprintf(stdout, "kill tasks\n");
    kill_child();
    exit(1);
}
#endif


#ifdef SCHED
static void toploop()
{
  declare_globals;
  struct threadrec *qp = current_queue;
	Const struct predicate *toppred;
	module func;


	toppred = (struct predicate *)*--(qp->stack->top); /* get predicate @ikawa */
  func = (module)toppred->func;
  while (1) {
    func = ((module (*)())func)(glbl, qp, heapp, toppred, qp->stack->top);
    qp = current_queue;
		toppred = (struct predicate*)*qp->stack->top;
  }
}
#else
static void toploop()
{
  declare_globals;
  struct goalrec *qp = current_queue;
  Const struct predicate *toppred = qp->pred;
  module func = (module)toppred->func;
  while (1) {
    func = ((module (*)())func)(glbl, qp, heapp, toppred);
    qp = current_queue;
    toppred = qp->pred;
  }
}
#endif

#ifdef DEBUGLIB
long intr_count =0;
long signal_count =0;
int gc_count = 0;
long idle_count = 0;
struct scheduling_object_method_table* scheduling_methtab;
extern struct scheduling_object_method_table* get_scheduling_methtab();
#endif

long idle_time;
long idle_sec;
long idle_usec;


#ifdef SCHED

klic_main(argc, argv)
     int argc;
     char **argv;
{

  declare_globals;
  void initalloc();

  q *initiate_prioq();
  q *reinitiate_prioq();
#ifdef USESIG
  void init_klic_signal_handling();
#endif
#ifdef USETIMER
  void init_virtualized_timer();
  void init_klic_timer_handling();
#endif
#ifdef DEBUGLIB
#ifdef SCHED
  extern struct threadrec *trace_thread();
#else
  extern struct goalrec *trace_goal();
#endif
#endif
#ifdef SHM
  struct timeval time_before;
  gettimeofday(&time_before);
#endif /*SHM*/
	
  program_name = argv[0];
  total_node = num_pes = 1;
  my_node = 0;
  h_size = HEAPSIZE;
  max_h_size = (unsigned long)(-1); /* largest possible */
  max_a_ratio = 0.5;
  inc_size = INCREMENTSIZE;
	idle_time = 0;
#ifdef SCHED
	s_size = STACKSIZE;
	s_num = STACKNUM;
#endif
#ifdef USETIMER
  dl_det_interval = 500000;	/* default deadlock detect interval is 500ms */
#endif
  {
      int targc = argc;
      char **targv = argv;
      char *errp = parse_opts(opttable, &targc, &targv);
      if (errp) {
				int i;
				klic_fprintf(stderr,
										 "Invalid or missusage option or value '%s'\n", errp);
				klic_fprintf(stderr,
										 "Usage: %s [options, ...] [program arguments, ...]\n",
										 program_name);
				for (i = 0; opttable[i].opt_str; ++i) {
					if (opttable[i].opt_usage)
						klic_fprintf(stderr, "\t%s\n", opttable[i].opt_usage);
				}
				exit(1);
      }
      command_argc = targc;
      command_argv = targv;
      if (verbose)
				klic_fprintf(stderr, "KLIC runtime version %s (%s)\n",
										 runtime_version, runtime_date);
		}
  total_node = num_pes;
#ifdef DIST
  if (total_node == 0)
    total_node = 1;

  if (eager_transfer_all_flag) {
		eager_transfer_level = -1;
  } else if (!eager_transfer_level) {
		eager_transfer_level = 1;
  }
  {
		int child_id;
		/* Spawn total_node+1 nodes.
			 1 node for SHOEN node, 'total_node' for reduction nodes.
			 the spawn_children() should return:
			 parent process:	0
			 child processes:	1 <= nodeid <=  total_node+1 */
		child_id = spawn_children(total_node + 1, opttable,
															program_name, command_argc, command_argv);
		if (child_id == 0) {
			io_init_comm();
			io_server(command_argc, command_argv);
			/* never return from io_server() */
			exit(0);
		}
		my_node = child_id - 1;
		total_node = num_pes;
		/* Master node:		my_node == 0		IS_MASTER_NODE()
			 SHOEN node:		my_node == total_node	IS_SHOEN_NODE()
			 Reduction nodes:	0 <= my_node < total_node
			 */
		init_dist();
  }
#endif /* DIST */

  /* All processing depending on the argument variables must be done
     after spawn_children() or it fails to read the arguments. */
  maxactiveratio = max_a_ratio;
  heapsize = h_size;

	/* new glbl members @ikawa */
	stacksize = s_size;
	number_of_stack = s_num;

  maxheapsize = max_h_size;
  incrementsize = inc_size;
  if (heapsize > maxheapsize)
    maxheapsize = heapsize;

	/* out file for debug @ikawa*/
	{
		char logname[100];
#ifdef SCHED
#ifdef PFIRST
				sprintf(logname,"p-log%d",my_node);
#else
		sprintf(logname,"d-log%d",my_node);
#endif				
#endif	
		if(!(logfile = fopen(logname,"w")))
			fatal("can't open logfile");
	}
	
  initalloc();
	
#ifdef SHM
  My_glbl = glbl = shm_init(glbl);
#endif
	
  {
    extern struct threadrec *get_top_priority_queue();
    q *allocp;
		
		struct threadrec *qp;
#ifdef PFIRST
		/* initialization of no_request structure */
		no_request = (struct request_record*)malloc(sizeof(struct request_record));
		no_request->reply_data = NO_REQUEST;
		no_request->wait_thread = NO_WAIT_THREAD;
		current_request = no_request;
#ifdef DIST
		request_queue_top = request_queue_tail = no_request;
		throw_flag = reply_first = 0;
#endif
#endif
    allocp = initiate_prioq(heapp);
    qp = (struct threadrec *) allocp;
	 
#ifdef USESIG
    init_klic_signal_handling();
#endif	/*USESIG */
#ifdef USETIMER
    init_virtualized_timer();
    init_klic_timer_handling();
#endif


		/* end of initiating in klic_main */

#ifdef DIST
#ifdef PACKSEND
    register_gc_hook(gc_pk_flg);
#endif
    register_gc_hook(gc_exp_table);
    register_gc_hook(gc_decode_stack);
    register_after_gc_hook(scan_imp_table);

    if (IS_MASTER_NODE(my_node)) {	/* master node */
			qp->stack = stq;
			stq = stq->next;
			*(qp->stack->top)++ = (q)&predicate_main_xmain_0;
#ifdef PFIRST
			qp->prio = HIGHESTPRIO-1;
			qp->rtop = qp->rtail = no_request;
			heapp = allocp + 6;

			/* For request fifo queue */
#else
			heapp = allocp + 2;
#endif			
			node_wtc = SUPPLY_WTC_UNIT;
    } else if (IS_SHOEN_NODE(my_node)) {	/* shoen node */
			add_signal_handler(SIGTERM, kill_tasks);
			shoen_wtc = -SUPPLY_WTC_UNIT;
			{
				struct timeval tp;
				struct timezone tzp;
				if(!gettimeofday(&tp, &tzp)){
					netstat.start_sec = tp.tv_sec;
					netstat.start_usec= tp.tv_usec;
				}
			}
    }

    init_rusage(); /***** for inter NODE *****/
#else /* !DIST */
		/* make main thread */

		qp->stack = stq;
		stq = stq->next;
		*(qp->stack->top)++ = (q)&predicate_main_xmain_0;
#ifdef PFIRST
		qp->prio = HIGHESTPRIO-1;
		qp->rtop = qp->rtail = no_request;
		heapp = allocp + 6;

#else
    heapp = allocp + 2;
#endif

#endif /* DIST */

#ifdef DEBUGLIB
    cum_susps = 0;
    cum_resumps = 0;
    suspensions = 0;
    resumes = 0;
#endif /* DEBUGLIB */
#ifdef DIST /* spawn check */
	ioprintf("Spawn task in Node %d \n",my_node);
#endif
    while (1) {
#ifdef DEBUGLIB
      cum_susps += suspensions;
      suspensions = 0;
      cum_resumps += resumes;
      resumes = 0;
      current_prio = -1;
      suspended_goal_list = 0;
      if (start_tracing) {
				initiate_trace();
#ifdef DIST
				if (IS_MASTER_NODE(my_node))
#endif
					qp = trace_thread(qp, 1, 0);
				start_tracing = 0;
      }
      initialize_suspension_count_table();
#endif	/*DEBUGLIB*/
				current_prio = -1;
#ifdef DIST
      if (IS_MASTER_NODE(my_node))
#endif
#ifdef SHM
      if ( my_node == MASTER )
#endif
			
#ifdef SCHED
				
			(void) enqueue_thread(0, HIGHESTPRIO-1, qp, glbl);
			
			current_queue = get_top_priority_queue();
			resume_flag = 0;
#ifdef PFIRST
				prior_thread = resumed_threads = generic_suspend_threads = 0;
#else
			resumed_threads = generic_suspend_threads = 0;
#endif
#endif
#ifdef DIST
      init_dist_signal_setup();
#else /* !DIST */
      interrupt_off = -1;
      postmortem_pred = 0;
      postmortem_args = 0;
#endif /* DIST */

			/* finish initialization */
			
			if (setjmp(klic_topmost) == 0) toploop();
				
#ifdef DIST
      DetachIO();
      CloseIO();
      Close_net();
      break;
#else /*!DIST*/

			/* Don't care @ikawa */
			
			if (postmortem_pred == 0 || postmortem_args == 0) break;
			klic_fprintf(stderr, "Starting postmortem processing...\n");
			allocp = initiate_prioq(heapp+incrementsize/2); /* dirty patch */
			qp = (struct threadrec *) allocp;
			qp->stack = stq;
			stq = stq->next;
			if(stq == &stack_tail)
				expand_stack_area();
			{
				q *stackp = qp->stack->top;
				if (isfunctor(postmortem_args)) {
					int arity = arityof(functor_of(postmortem_args));
					int k;
					for (k=arity-1; k==0; k++) {
						*stackp++ = arg(postmortem_args, k);
					}
				}
				*stackp++ = (q)postmortem_pred;
					qp->stack->top = stackp;
				allocp += 3;
				heapp = allocp;
				}
#endif /*DIST*/
		}
  }

#ifdef SHM
  if ( my_node == MASTER ) {
    wait(0);
    {
      struct timeval time_after;
      if(!gettimeofday(&time_after)){
	fprintf(stderr,
		"Response time is %d msec\n",
		(time_after.tv_sec - time_before.tv_sec)*1000 +
		(time_after.tv_usec - time_before.tv_usec)/1000);
      }
    }
  }
#endif /*SHM*/
#ifdef DEBUGLIB
	/* print out various status for debug @ikawa */
	
	{
		struct timeval idle_t;
		if(!gettimeofday(&idle_t,NULL)){
			idle_time +=
				((idle_t.tv_sec - idle_sec)*1000 + (idle_t.tv_usec -idle_usec)/1000);
		}
	}
	fprintf(logfile,"%d:gc count %d\n",my_node,gc_count);
	fprintf(logfile,"%d:intr count %d\n",my_node,intr_count);
	fprintf(logfile,"%d:signal count %d\n",my_node,signal_count);
	fprintf(logfile,"%d:idle count %d\n",my_node,idle_count);
	fprintf(logfile,"%d:idle time %d msec\n",my_node,idle_time);
	fflush(logfile);
	fclose(logfile);
#endif
  return 0;
}
#else/*!SCHED*/
klic_main(argc, argv)
     int argc;
     char **argv;
{
  declare_globals;
  void initalloc();

  q *initiate_prioq();
  q *reinitiate_prioq();
#ifdef USESIG
  void init_klic_signal_handling();
#endif
#ifdef USETIMER
  void init_virtualized_timer();
  void init_klic_timer_handling();
#endif
#ifdef DEBUGLIB
  extern struct goalrec *trace_goal();
#endif
#ifdef SHM
  struct timeval time_before;
  gettimeofday(&time_before);
#endif /*SHM*/
  program_name = argv[0];
  total_node = num_pes = 1;
  my_node = 0;
  h_size = HEAPSIZE;
  max_h_size = (unsigned long)(-1); /* largest possible */
  max_a_ratio = 0.5;
  inc_size = INCREMENTSIZE;
	idle_time = 0;
#ifdef USETIMER
  dl_det_interval = 500000;	/* default deadlock detect interval is 500ms */
#endif
  {
      int targc = argc;
      char **targv = argv;
      char *errp = parse_opts(opttable, &targc, &targv);
      if (errp) {
	  int i;
	  klic_fprintf(stderr,
		       "Invalid or missusage option or value '%s'\n", errp);
	  klic_fprintf(stderr,
		       "Usage: %s [options, ...] [program arguments, ...]\n",
		       program_name);
	  for (i = 0; opttable[i].opt_str; ++i) {
	      if (opttable[i].opt_usage)
		klic_fprintf(stderr, "\t%s\n", opttable[i].opt_usage);
	  }
	  exit(1);
      }
      command_argc = targc;
      command_argv = targv;
      if (verbose)
	klic_fprintf(stderr, "KLIC runtime version %s (%s)\n",
		     runtime_version, runtime_date);
  }
  total_node = num_pes;
#ifdef DIST
  if (total_node == 0)
    total_node = 1;

  if (eager_transfer_all_flag) {
      eager_transfer_level = -1;
  } else if (!eager_transfer_level) {
      eager_transfer_level = 1;
  }
  {
      int child_id;
      /* Spawn total_node+1 nodes.
	 1 node for SHOEN node, 'total_node' for reduction nodes.
	 the spawn_children() should return:
	 parent process:	0
	 child processes:	1 <= nodeid <=  total_node+1 */
      child_id = spawn_children(total_node + 1, opttable,
				    program_name, command_argc, command_argv);
      if (child_id == 0) {
	  io_init_comm();
	  io_server(command_argc, command_argv);
	  /* never return from io_server() */
	  exit(0);
      }
      my_node = child_id - 1;
      total_node = num_pes;
      /* Master node:		my_node == 0		IS_MASTER_NODE()
	 SHOEN node:		my_node == total_node	IS_SHOEN_NODE()
	 Reduction nodes:	0 <= my_node < total_node
	 */
      init_dist();
  }
#endif /* DIST */
  /* All processing depending on the argument variables must be done
     after spawn_children() or it fails to read the arguments. */
  maxactiveratio = max_a_ratio;
  heapsize = h_size;
  maxheapsize = max_h_size;
  incrementsize = inc_size;
  if (heapsize > maxheapsize)
    maxheapsize = heapsize;
			{
				char logname[100];
				sprintf(logname,"log%d",my_node);
				if(!(logfile = fopen(logname,"w")))
					fatal("can't open logfile");
			}

  initalloc();

#ifdef SHM
  My_glbl = glbl = shm_init(glbl);
#endif

  {
    extern struct goalrec *get_top_priority_queue();
    q *allocp;
    struct goalrec *qp;

    allocp = initiate_prioq(heapp);
    qp = (struct goalrec *) allocp;

#ifdef USESIG
    init_klic_signal_handling();
#endif	/*USESIG */
#ifdef USETIMER
    init_virtualized_timer();
    init_klic_timer_handling();
#endif
#ifdef DIST
#ifdef PACKSEND
    register_gc_hook(gc_pk_flg);
#endif
    register_gc_hook(gc_exp_table);
    register_gc_hook(gc_decode_stack);
    register_after_gc_hook(scan_imp_table);

    if (IS_MASTER_NODE(my_node)) {	/* master node */
	qp->pred = &predicate_main_xmain_0;
	heapp = allocp + 2;
	node_wtc = SUPPLY_WTC_UNIT;
    } else if (IS_SHOEN_NODE(my_node)) {	/* shoen node */
	add_signal_handler(SIGTERM, kill_tasks);
	shoen_wtc = -SUPPLY_WTC_UNIT;
	{
	    struct timeval tp;
	    struct timezone tzp;
	    if(!gettimeofday(&tp, &tzp)){
		netstat.start_sec = tp.tv_sec;
		netstat.start_usec= tp.tv_usec;
	    }
	}
    }
    init_rusage(); /***** for inter NODE *****/
#else /* !DIST */
    qp->pred = &predicate_main_xmain_0;
    heapp = allocp + 2;
#endif /* DIST */
#ifdef DEBUGLIB
    cum_susps = 0;
    cum_resumps = 0;
    suspensions = 0;
    resumes = 0;
#endif /* DEBUGLIB */
    while (1) {
#ifdef DEBUGLIB
      cum_susps += suspensions;
      suspensions = 0;
      cum_resumps += resumes;
      resumes = 0;
      current_prio = -1;
      suspended_goal_list = 0;
      if (start_tracing) {
	  initiate_trace();
#ifdef DIST
	  if (IS_MASTER_NODE(my_node))
#endif
	    qp = trace_goal(qp, 1, 0);
	  start_tracing = 0;
      }
      initialize_suspension_count_table();
#endif	/*DEBUGLIB*/
#ifdef DIST
      if (IS_MASTER_NODE(my_node))
#endif
#ifdef SHM
      if ( my_node == MASTER )
#endif
	(void) enqueue_goal(0, HIGHESTPRIO-1, qp, glbl);

      current_queue = get_top_priority_queue();
      resumed_goals = 0;

#ifdef DIST
      init_dist_signal_setup();
#else /* !DIST */
      interrupt_off = -1;
      postmortem_pred = 0;
      postmortem_args = 0;
#endif /* DIST */

      if (setjmp(klic_topmost) == 0) toploop();

#ifdef DIST
      DetachIO();
      CloseIO();
      Close_net();
      break;
#else /*!DIST*/
      if (postmortem_pred == 0 || postmortem_args == 0) break;
      klic_fprintf(stderr, "Starting postmortem processing...\n");
      allocp = initiate_prioq(heapp+incrementsize/2); /* dirty patch */
      qp = (struct goalrec *) allocp;
      qp->pred = postmortem_pred;
      allocp += 2;
      if (isfunctor(postmortem_args)) {
	int arity = arityof(functor_of(postmortem_args));
	int k;
	for (k=0; k<arity; k++) {
	  *allocp++ = arg(postmortem_args, k);
	}
      }
      heapp = allocp;
#endif /*DIST*/
    }
  }
#ifdef SHM
  if ( my_node == MASTER ) {
    wait(0);
    {
      struct timeval time_after;
      if(!gettimeofday(&time_after)){
	fprintf(stderr,
		"Response time is %d msec\n",
		(time_after.tv_sec - time_before.tv_sec)*1000 +
		(time_after.tv_usec - time_before.tv_usec)/1000);
      }
    }
  }
#endif /*SHM*/
#ifdef DEBUGLIB
	{
		struct timeval idle_t;
		if(!gettimeofday(&idle_t,NULL)){
			idle_time +=
				((idle_t.tv_sec - idle_sec)*1000 + (idle_t.tv_usec -idle_usec)/1000);
		}
	}
	fprintf(logfile,"gc count %d\n",gc_count);
	fprintf(logfile,"intr count %d\n",intr_count);
	fprintf(logfile,"signal count %d\n",signal_count);
	fprintf(logfile,"idle count %d\n",idle_count);
	fprintf(logfile,"%d:idle time %d msec\n",my_node,idle_time);
	fflush(logfile);
	fclose(logfile);
#endif

  return 0;
} 
#endif

#ifdef USETIMER
static void dummy_alarm_handler()
{
    dummy_alarm_set = 0;
}
#endif



#ifdef SCHED
extern struct stackrec topsucceed_stack;
extern struct threadrec *get_top_priority_queue();

module topsucceed(glbl, qp, allocp, toppred, stackp)
	struct global_variables *glbl;
	struct threadrec *qp;
	q *allocp;
	Const struct predicate *toppred;
	q *stackp;
#ifdef DIST
{
	struct threadrec *tmpqp;
  extern q *klic_interrupt();
  extern void send_return_wtc();
  extern Const struct predicate topsucceed_pred;

	/* for mesure idle time @ikawa */
	struct timeval idle_t;
	struct timezone idle_tp;
	qp->stack->top++;

	if(!gettimeofday(&idle_t,&idle_tp)){
		idle_sec = idle_t.tv_sec;
		idle_usec = idle_t.tv_usec;
	}
 idle_loop:
	idle_count++;
  if (IS_SHOEN_NODE(my_node)) {	/* if shoen node */
		if (shoen_wtc > 0) { 
			ioeprintf("illegal wtc in shoen node\n");
			fatal("illegal WTC");
		} else if(shoen_wtc == 0){
			struct timeval tp;
			struct timezone tzp;
			if(!gettimeofday(&tp, &tzp)){
				iosprintf("Response time is %d msec\n",
									(tp.tv_sec - netstat.start_sec)*1000 +
										(tp.tv_usec - netstat.start_usec)/1000);
			}
			terminate_all_node();
			CloseIO();
			Close_net();
			exit(0);
		}
  } else {			/* if normal node */
#ifdef PFIRST
		if ( suspensions == resumes && !susp_msg_list){
			if(resumed_threads || prior_thread)
				fatal("there are active thread in topsucced priority\n");
			if (node_wtc)
				send_return_wtc(node_wtc);
		}
#else
		if ( suspensions == resumes && !susp_msg_list ) {
			if (node_wtc)
				send_return_wtc(node_wtc);
		}
#endif
  }
	
  IDLE_ON();
  {
		sigset_t new_mask;
		sigset_t prev_mask;
		if (sigfillset(&new_mask) < 0)
			fatalp("sigfillset", "");
		if (sigprocmask(SIG_BLOCK, &new_mask, &prev_mask) < 0)
			fatalp("sigprocmask", "mask set error");
		if (interrupt_off)
				if (sigsuspend(&prev_mask) < 0 && errno != EINTR)
					fatalp("sigsuspend", "");
		if (sigprocmask(SIG_SETMASK, &prev_mask, (sigset_t *)0) < 0)
			fatalp("sigprocmask", "mask reset error");
	}
	
#ifdef PFIRST
	resume_flag = 1;
  allocp[0] = (q)qp->next;
	allocp[1] = (q)0;
	allocp[2] = (q)&topsucceed_stack;
	allocp[3] = (q)no_request;
	allocp[4] = (q)0;
	allocp[5] = (q)0;
		
	qp = (struct threadrec *)allocp;
	qp->next->before = qp;
	allocp += 6;
#else	
  allocp[0] = (q)qp->next;
  allocp[1] = (q)&topsucceed_stack;
  qp = (struct threadrec *)allocp;
  allocp += 2;
#endif
  IDLE_OFF();
  heapp = klic_interrupt(allocp, qp, qp->stack->top);
  qp = current_queue;
#ifdef PFIRST
	resume_flag = 0;
#endif

  if ((qp->stack == &topsucceed_stack) && (heapp == allocp)) {
#ifdef PFIRST
		allocp -= 6;
#else
		allocp -= 2;
#endif
      goto idle_loop;
  }

		if(!gettimeofday(&idle_t,&idle_tp)){
			idle_time +=
				((idle_t.tv_sec - idle_sec)*1000 + (idle_t.tv_usec -idle_usec)/1000);
		}

	{
		/* thread change */
		
		struct predicate *pred;
		pred = (struct predicate *)*(--qp->stack->top);
#ifdef WDEBUG
		if(current_prio == 0){
			char *buf;
			buf = sprint_qp(qp);
			fprintf(logfile,"%d:thread's prio is topsucceed priority \n%s",
									 my_node,buf);
		}else{
			char *buf;
			buf = sprint_qp(qp);
			fprintf(logfile,"%d: thread change in tops\n  %s ",my_node,buf);
		}
#endif
		return (module) pred->func;
	}
}

#else /* #ifndef DIST */
{

  extern q *klic_interrupt();
  extern Const struct predicate topsucceed_pred;
  if (suspensions == resumes) {
#ifdef DEBUGLIB
    if(count_suspension) {
      if(suspensions) {
				klic_fprintf(stderr, "Suspension counts:\n");
				printf("%d\n",suspensions);
				/*	scan_suspended_pred(); */
      } else {
				klic_fprintf(stderr, "No suspension in this run.\n");
      }
    }
#endif
    longjmp(klic_topmost, 1);
	}
	
#ifdef USESIG

  /* perpetual suspension suspected, but let's wait a while for interrupts */

  /* enqueue topsucceed thread again */
	allocp[0] = (q)qp;
	allocp[1] = (q)&topsucceed_stack;
	qp = (struct threadrec *)allocp;
	allocp += 2;

  /* Let's not hastily check perpetual suspension */
#ifdef USETIMER
  if (dl_det_interval) {
    extern void call_after_specified_interval();
    sigset_t new_mask;
    sigset_t prev_mask;
    sigfillset(&new_mask);
    sigprocmask(SIG_BLOCK, &new_mask, &prev_mask);
    while (interrupt_off && dummy_alarm_set)
      sigsuspend(&prev_mask);
    if (interrupt_off) {
	call_after_specified_interval(dl_det_interval/(unsigned long)1000000,
				      dl_det_interval%(unsigned long)1000000,
				      dummy_alarm_handler);
	dummy_alarm_set = 1;
	/* Use while-do rather than do-while to avoid suspected OS bugs */
	while (interrupt_off && dummy_alarm_set)
	    sigsuspend(&prev_mask);
    }
    sigprocmask(SIG_SETMASK, &prev_mask, 0);
  }
#else
#ifdef USEUSLEEP
  usleep(1000);
#else
  (void) sleep(1);
#endif /*USEUSLEEP*/
#endif

  /* If no interrupts during the pause, run GC */
  if (interrupt_off)
#ifdef USETIMER
    if (dl_det_interval != 0)
#endif
		allocp = real_heaplimit;
#ifdef SCHED
	qp->stack->top = stackp;
#endif
  allocp = klic_interrupt(allocp, qp);
  qp = current_queue;
#ifdef SCHED
	stackp = qp->stack->top;
#endif
	
  if (qp->stack == &topsucceed_stack) {
    /* no interrupt after topsucceed was called */
		sigset_t new_mask;
		sigset_t prev_mask;
		if (sigfillset(&new_mask) < 0)
			fatalp("sigfillset", "");
		if (sigprocmask(SIG_BLOCK, &new_mask, &prev_mask) < 0)
			fatalp("sigprocmask", "mask set error");
		if (interrupt_off)
			if (sigsuspend(&prev_mask) < 0 && errno != EINTR)
				fatalp("sigsuspend", "");
		if (sigprocmask(SIG_SETMASK, &prev_mask, (sigset_t *)0) < 0)
			fatalp("sigprocmask", "mask reset error");
		
  }
  /* check resumpsions */
  heapp = klic_interrupt(allocp, qp);
	{
		struct predicate *pred;
		pred = (struct predicate*)*--current_queue->stack->top;
		return (module) pred->func;
	}
#else /*!USESIG*/
  fatalf("%d perpetually suspending goals found",
				 suspensions-resumes);
#endif /*USESIG*/

}
#endif /*DIST*/
#else/*!SCHED*/
module topsucceed(glbl, qp, allocp, toppred)
     struct global_variables *glbl;
     struct goalrec *qp;
     q *allocp;
     Const struct predicate *toppred;
#ifdef DIST
{
  extern q *klic_interrupt();
  extern void send_return_wtc();
  extern Const struct predicate topsucceed_pred;
	struct timeval idle_t;
	struct timezone idle_tp;
	
	if(!gettimeofday(&idle_t,&idle_tp)){
		idle_sec = idle_t.tv_sec;
		idle_usec = idle_t.tv_usec;
	}
	
 idle_loop:
	idle_count++;
  if (IS_SHOEN_NODE(my_node)) {	/* if shoen node */
      if (shoen_wtc > 0) { 
	  ioeprintf("illegal wtc in shoen node\n");
	  fatal("illegal WTC");
      } else if(shoen_wtc == 0){
	  struct timeval tp;
	  struct timezone tzp;
	  if(!gettimeofday(&tp, &tzp)){
	      iosprintf("Response time is %d msec\n",
		      (tp.tv_sec - netstat.start_sec)*1000 +
		      (tp.tv_usec - netstat.start_usec)/1000);
	  }
	  terminate_all_node();
	  CloseIO();
	  Close_net();
	  exit(0);
      }
  } else {			/* if normal node */
      if ( suspensions == resumes && !susp_msg_list) {
	  if (node_wtc)
	    send_return_wtc(node_wtc);
      }
  }

  IDLE_ON();
  {
      sigset_t new_mask;
      sigset_t prev_mask;
      if (sigfillset(&new_mask) < 0)
	fatalp("sigfillset", "");
      if (sigprocmask(SIG_BLOCK, &new_mask, &prev_mask) < 0)
	fatalp("sigprocmask", "mask set error");
      if (interrupt_off)
	if (sigsuspend(&prev_mask) < 0 && errno != EINTR)
	  fatalp("sigsuspend", "");
      if (sigprocmask(SIG_SETMASK, &prev_mask, (sigset_t *)0) < 0)
	fatalp("sigprocmask", "mask reset error");
  }

  allocp[0] = (q)qp->next;
  allocp[1] = (q)&topsucceed_pred;
  qp = (struct goalrec *)allocp;
  allocp += 2;

  IDLE_OFF();
  heapp = klic_interrupt(allocp, qp);
  qp = current_queue;

  if ((qp->pred == &topsucceed_pred) && (heapp == allocp)) {
      allocp -= 2;
      goto idle_loop;
  }
	if(!gettimeofday(&idle_t,&idle_tp)){
		idle_time +=
			((idle_t.tv_sec - idle_sec)*1000 + (idle_t.tv_usec -idle_usec)/1000);
	}
  
  return (module) current_queue->pred->func;
}

#else /* #ifndef DIST */
{
  extern q *klic_interrupt();
  extern Const struct predicate topsucceed_pred;
  if (suspensions == resumes) {
#ifdef DEBUGLIB
    if(count_suspension) {
      if(suspensions) {
	klic_fprintf(stderr, "Suspension counts:\n");
	scan_suspended_pred();
      } else {
	klic_fprintf(stderr, "No suspension in this run.\n");
      }
    }
#endif
    longjmp(klic_topmost, 1);
  }

#ifdef USESIG
  /* perpetual suspension suspected, but let's wait a while for interrupts */

  /* enqueue topsucceed goal again */
  allocp[0] = (q)qp;
  allocp[1] = (q)&topsucceed_pred;
  qp = (struct goalrec *)allocp;
  allocp += 2;

  /* Let's not hastily check perpetual suspension */
#ifdef USETIMER
  if (dl_det_interval) {
    extern void call_after_specified_interval();
    sigset_t new_mask;
    sigset_t prev_mask;
    sigfillset(&new_mask);
    sigprocmask(SIG_BLOCK, &new_mask, &prev_mask);
    while (interrupt_off && dummy_alarm_set)
      sigsuspend(&prev_mask);
    if (interrupt_off) {
	call_after_specified_interval(dl_det_interval/(unsigned long)1000000,
				      dl_det_interval%(unsigned long)1000000,
				      dummy_alarm_handler);
	dummy_alarm_set = 1;
	/* Use while-do rather than do-while to avoid suspected OS bugs */
	while (interrupt_off && dummy_alarm_set)
	    sigsuspend(&prev_mask);
    }
    sigprocmask(SIG_SETMASK, &prev_mask, 0);
  }
#else
#ifdef USEUSLEEP
  usleep(1000);
#else
  (void) sleep(1);
#endif /*USEUSLEEP*/
#endif

  /* If no interrupts during the pause, run GC */
  if (interrupt_off)
#ifdef USETIMER
    if (dl_det_interval != 0)
#endif
      allocp = real_heaplimit;
  allocp = klic_interrupt(allocp, qp);
  qp = current_queue;

  if (qp->pred == &topsucceed_pred) {
    /* no interrupt after topsucceed was called */
      sigset_t new_mask;
      sigset_t prev_mask;
      if (sigfillset(&new_mask) < 0)
	fatalp("sigfillset", "");
      if (sigprocmask(SIG_BLOCK, &new_mask, &prev_mask) < 0)
	fatalp("sigprocmask", "mask set error");
      if (interrupt_off)
	if (sigsuspend(&prev_mask) < 0 && errno != EINTR)
	  fatalp("sigsuspend", "");
      if (sigprocmask(SIG_SETMASK, &prev_mask, (sigset_t *)0) < 0)
	fatalp("sigprocmask", "mask reset error");

  }
  /* check resumpsions */
  heapp = klic_interrupt(allocp, qp);
  return (module) current_queue->pred->func;
#else /*!USESIG*/
  fatalf("%d perpetually suspending goals found",
	 suspensions-resumes);
#endif /*USESIG*/
}
#endif /*DIST*/
#endif
#endif /* baka */
