/* ----------------------------------------------------------
%        Copyright (C) 1996-1997 Kazuhiko Ohno, Masahiko Ikawa,
%        and Computer Architecture Laboratory, Depertment of
%        Information Science, Kyoto University.
%----------------------------------------------------------- */  

/* ----------------------------------------------------------
%   (C)1993,1994,1995 Institute for New Generation Computer Technology
%       (Read COPYRIGHT for detailed information.)
----------------------------------------------------------- */

/* #define WDEBUG  */
#ifndef FIRST
#include <klic/basic.h>
#include <klic/struct.h>
#include <klic/sighndl.h>
#include <klic/primitives.h>
#include <klic/schedule.h>
#include <klic/debugprint.h>
#ifdef DIST
#include <klic/rmon.h>
#else
#define GC_ON()
#define GC_OFF()
#endif
#ifdef SHM
#include <klic/shm.h>
#endif
#ifdef SCHED
#include <klic/wdebug.h>
#include <stdio.h>
#endif

int sigint_interrupt = 0;

#ifdef SCHED
extern struct threadrec thread_queue_tail;
#ifdef PFIRST

Inline struct threadrec *enqueue_prior_thread(qp)
	struct threadrec *qp;
{
	declare_globals;
	struct threadrec *pt = prior_thread;
	pt->next = qp;
	qp->before = pt;
	prior_thread = 0;
	if(interrupt_off) heaplimit = real_heaplimit;

	/* for debug fprintf enqueue prior thread */
#ifdef WDEBUG
	fprintf(logfile,"%d:enqueue prior_thread %x ",my_node,pt); 
	while(qp != &thread_queue_tail){
		fprintf(logfile," -> %x ",qp);
		qp = qp->next;
	}
	fprintf(logfile,"\n");
	fflush(logfile);
#endif
	return (current_queue = pt);
}
#endif

struct threadrec *enqueue_resumed_threads(qp)
     struct threadrec *qp;
{
  declare_globals;
  struct threadrec *rsmt = resumed_threads;

	
  if (rsmt != 0) {
		/* thread change is occured ,but
			 the reason is not finished execution of before thread */
		struct threadrec *newqp = rsmt->next;
		rsmt->next = qp;
#ifdef PFIRST
		qp->before = rsmt;
#endif
		qp = newqp;
		resumed_threads = 0;
#ifdef WDEBUG
		{
			struct threadrec *tmp = qp;
			fprintf(logfile,"%d:enqueue resumed_thread ",my_node);
			while(qp != &thread_queue_tail){
				fprintf(logfile," -> %x ",qp);
				qp = qp->next;
			}
			fprintf(logfile,"\n");
			fflush(logfile);
			qp = tmp;
		}
#endif		
			if (interrupt_off) heaplimit = real_heaplimit;
  }
  return (current_queue = qp);
}

#ifdef DEBUGLIB
extern long intr_count;
#endif

q *klic_interrupt(allocp, qp, stackp)
	q *allocp;
	struct threadrec *qp;
	q * stackp;
{
  declare_globals;
  long retry;
  extern q *klic_signal_handler();
#ifdef DEBUGLIB
  extern int trace_flag;
#ifdef SCHED
  extern struct threadrec *trace_after();
#else
  extern struct goalrec *trace_after();
#endif
#endif

#ifdef DEBUGLIB
	intr_count++;
#endif
	
	current_queue = qp ;
	/* resumption first */

	if(resume_flag){
		qp = enqueue_resumed_threads(qp);
	}
#ifdef PFIRST
	if(prior_thread){
		qp = enqueue_prior_thread(qp);
	}
#endif
	
#ifdef DEBUGLIB
  if (trace_flag) {
    qp = trace_after(qp, allocp, stackp);
    allocp = heapp;
  }
#endif

  do {
    retry = 0;

    /* signal handling */
#ifdef USESIG
    if (!signal_done) {
      allocp = klic_signal_handler(allocp);
			current_queue = qp;
      retry = (allocp + this_more_space >= real_heaplimit); 
      /* some goals may have been resumed by the signal handler */
			qp = current_queue;
			if(resume_flag)
				qp = enqueue_resumed_threads(qp);
			if(interrupt_off) heaplimit = real_heaplimit;
    }
#endif

    if (sigint_interrupt) {
      fatal("Execution aborted by SIGINT");
    }

#ifdef SHM
    while( (Volatile int)ext_queued ) {
      *cur_status = 1;
      ext_queued = 0;
      klic_barrier();
      qp = get_invoked_goals(qp);
      interrupt_off = -1;
      heaplimit = real_heaplimit;
      retry |= (allocp + this_more_space >= heaplimit);
    }
#endif

		/* generic_new suspend for gc */

		if (generic_suspend_threads){
			{
				struct threadrec *gst = generic_suspend_threads;
				WDEB(fprintf(logfile,"%d:generic_suspend thread %x\n",my_node,gst));
				if (gst != 0) {
					struct threadrec *newqp = gst->next;
					gst->next = qp;
#ifdef PFIRST
					qp->before = gst;
#endif
					qp = newqp;
					generic_suspend_threads = 0;
				}
			}
		}

		
    /* priority support */
		
    if (higher_priority_thread) {
      higher_priority_thread = 0;
      put_priority_queue(qp, current_prio);
      qp = get_top_priority_queue();
      if (interrupt_off) heaplimit = real_heaplimit;
    }

		/* producer first */
		
#ifdef SHM
    if (ck_shm_gc() || allocp + this_more_space >= real_heaplimit) {
      extern struct goalrec *klic_gc();
      *cur_status = 3;
    /* ck_shm_gc will call another GC */
#else
    if (allocp + this_more_space >= real_heaplimit) {
      extern struct threadrec *klic_gc();
#endif
#ifdef DEBUGLIB
			extern int gc_count;
#endif
      GC_ON();
/*			printf("allocp %x this_more_space %x real_heaplimit %x\n",
							allocp,this_more_space,real_heaplimit);*/
#ifdef DEBUGLIB
			gc_count++;
#endif
      qp = klic_gc(qp);
#ifdef SHM
      *cur_status = 1;
#endif
      GC_OFF();

      allocp = heapp;
    }
  } while (retry);

#ifndef PFIRST
		resume_flag = 0;
#endif
		
		current_queue = qp;
		return allocp;
	}
#else
static struct goalrec *enqueue_resumed_goals(qp)
     struct goalrec *qp;
{
  declare_globals;
  struct goalrec *rsmg = resumed_goals;
  if (rsmg != 0) {
    struct goalrec *newqp = rsmg->next;
    rsmg->next = qp;
    qp = newqp;
    resumed_goals = 0;
    if (interrupt_off) heaplimit = real_heaplimit;
  }
  return qp;
}

q *klic_interrupt(allocp, qp)
     q *allocp;
     struct goalrec *qp;
{
  declare_globals;
  long retry;
  extern q *klic_signal_handler();
#ifdef DEBUGLIB
  extern int trace_flag;
  extern struct goalrec *trace_after();
	extern long intr_count;
	intr_count++;
#endif
	
  qp = enqueue_resumed_goals(qp);

#ifdef DEBUGLIB
  if (trace_flag) {
    qp = trace_after(qp, allocp);
    allocp = heapp;
  }
#endif
	
  do {
    retry = 0;

    /* signal handling */
#ifdef USESIG
    if (!signal_done) {
      allocp = klic_signal_handler(allocp);
      retry = (allocp + this_more_space >= real_heaplimit);
      /* some goals may have been resumed by the signal handler */
      qp = enqueue_resumed_goals(qp);
    }
#endif
		
    if (sigint_interrupt) {
      fatal("Execution aborted by SIGINT");
    }
		
    /* priority support */
    if (higher_priority_goal) {
      higher_priority_goal = 0;
      put_priority_queue(qp, current_prio);
      qp = get_top_priority_queue();
      if (interrupt_off) heaplimit = real_heaplimit;
    }
    if (allocp + this_more_space >= real_heaplimit) {
      extern struct goalrec *klic_gc();
#ifdef DEBUGLIB
			extern long gc_count;
			gc_count++;
#endif
      GC_ON();
      qp = klic_gc(qp);
      GC_OFF();
			
      allocp = heapp;
    }
	} while (retry);
#ifdef SCHED
	resume_flag = 0;
#endif
	current_queue = qp;
	return allocp;
	}
#endif	
#endif/* aho */
