/* ----------------------------------------------------------
%        Copyright (C) 1996-1997 Kazuhiko Ohno, Masahiko Ikawa,
%        and Computer Architecture Laboratory, Depertment of
%        Information Science, Kyoto University.
%----------------------------------------------------------- */  

/* ----------------------------------------------------------
%   (C)1993,1994,1995 Institute for New Generation Computer Technology
%       (Read COPYRIGHT for detailed information.)
----------------------------------------------------------- */

#include <klic/wdebug.h>
#include <klic/basic.h>
#include <klic/struct.h>
#include <klic/primitives.h>
#include <klic/timing.h>
#include <stdio.h>
#include <klic/functorstuffs.h>
#include <klic/gobj.h>
#include <klic/susp.h>

#ifdef SCHED
#include <klic/debugprint.h>
#include <klic/sched.h>
#endif
#ifdef DIST
#include <klic/interpe.h>
#ifdef PACKSEND
#include <pk_macro.h>
q general_gc();
#endif
#endif
#ifdef SHM
#include <klic/shm.h>



#define push_shm_stack(addr,sp,max)                     \
{                                                       \
   if ( (sp) == max )  {                                \
    (sp) = make_shm_larger_stack(sp);                   \
    max = shm_gcmax;                                    \
  }                                                     \
  *(sp)++ = (q*)(addr);                                 \
}

#endif


long copy_threads;


extern char *malloc(), *malloc_check(), *realloc_check();
#ifdef SCHED
extern struct threadrec thread_queue_tail;
#else
extern struct goalrec goal_queue_tail;
#endif

static Inline void flip_spaces()
{
  declare_globals;
  q *tempp = new_space_top;
  unsigned long temps = new_space_size;
  new_space_top = old_space_top;
  new_space_size = old_space_size;
  old_space_top = tempp;
  old_space_size = temps;
}

#ifdef SCHED
static struct threadrec *collect_garbage();
#else
static struct goalrec *collect_garbage();
#endif

#ifdef SCHED
struct threadrec *klic_gc(qp)
	struct threadrec *qp;
#else
struct goalrec *klic_gc(qp)
     struct goalrec *qp;
#endif
{
  timerstruct before, after;
  declare_globals;
  static lastgc_dangerous = 0;
  static int make_heap_larger = 0; /* make heap larger in the next GC */
  q *new_new_space_top;
  unsigned long bytesize;
  int k;
	copy_threads = 0;
  if (measure_gc) measure(before);
 gc_again:
  if (make_heap_larger) {
    q *new_old_space_top;
    heapsize *= 2;
    if (heapsize > maxheapsize) heapsize = maxheapsize;
    bytesize = (heapsize+incrementsize)*sizeof(q);
    new_old_space_top = (q *)malloc(bytesize);
    if (new_old_space_top != 0) {
      new_new_space_top = (q *)malloc(bytesize);
      if (new_new_space_top != 0) {
				free(old_space_top);
				old_space_top = new_old_space_top;
				old_space_size = bytesize;
      } else {
				free(new_old_space_top);
				if (lastgc_dangerous) {
					fatal("Not enough space collected and can't make heap larger");
				}
      }
    }
  } else if (lastgc_dangerous) {
    fatalf("Maximum heap size specified (%u words) has been used up",
					 maxheapsize);
  }
  flip_spaces();
  copied_susp = 0;		/* for perpetual suspension detection */
#ifdef SCHED
#ifdef WDEBUG
	fprintf(logfile,"%d: gc start ... \n",my_node);
	fflush(logfile);
#endif
#endif
  qp = collect_garbage(qp);
#ifdef SCHED
#ifdef WDEBUG
	fprintf(logfile,"%d: gc end ... \n",my_node);
	fflush(logfile);
#endif
#endif
  if (copied_susp != suspensions-resumes) {
#ifdef SCHED
    fatal("Perpetually suspending thread(s) found during GC");
#else
    fatal("Perpetually suspending goal(s) found during GC");
#endif
  }
  if (make_heap_larger) {
    free(old_space_top);
    old_space_top = new_new_space_top;
    old_space_size = bytesize;
  }
  make_heap_larger =
    (heapp-new_space_top+this_more_space > heapsize*maxactiveratio &&
     heapsize < maxheapsize);
  if (lastgc_dangerous = (real_heaplimit < heapp+this_more_space)) {
    goto gc_again;
  }
  this_more_space = 0;
  gctimes++;
#ifdef SHM
    if ( F_shm_gc ) qp = shm_gc(qp);
#endif
  if (measure_gc) {
    measure(after);
#ifdef GETRUSAGE
    gcums += diff_usec(ru_utime)/1000;
    gcsms += diff_usec(ru_stime)/1000;
#else
    gcums += (int) tick2msec(field_diff(tms_utime));
    gcsms += (int) tick2msec(field_diff(tms_stime));
#endif
  }
#ifdef PFIRST
	current_queue = qp;
#endif
  return qp;
}


#ifdef PFIRST
struct scheduling_record **
make_larger_srec_stack(sp)
	struct scheduling_record **sp;
{
  declare_globals;
  struct scheduling_record **newstack;
  srecstack_size *= 2;
  newstack = (struct scheduling_record **)realloc_check
		(srecstack, srecstack_size*sizeof(struct scheduling_record *));
  sp = newstack+(sp-srecstack);
  srecstack = newstack;
  srecmax = newstack+srecstack_size;
  return sp;
}

struct threadrec***
make_larger_gthread_stack(sp)
	struct threadrec***sp;
{
  declare_globals;
  struct threadrec ***newstack;
  gthreadstack_size *= 2;
  newstack = (struct threadrec***)
		realloc_check(gthreadstack, gthreadstack_size*sizeof(struct threadrec**));
  sp = newstack+(sp-gthreadstack);
  gthreadstack = newstack;
  gthreadmax = newstack+gthreadstack_size;
  return sp;
}

#endif

q**
make_larger_stack(sp)
     q**sp;
{
  declare_globals;
  q **newstack;
  gcstack_size *= 2;
  newstack = (q**)realloc_check(gcstack, gcstack_size*sizeof(q*));
  sp = newstack+(sp-gcstack);
  gcstack = newstack;
  gcmax = newstack+gcstack_size;
  return sp;
}

#ifdef SHM
q** make_shm_larger_stack(sp)
     q**sp;
{
  declare_globals;
  q **newstack;
  shm_gcstack_size *= 2;
  newstack = (q**)realloc_check(shm_gcstack, shm_gcstack_size*sizeof(q*));
  sp = newstack+(sp-shm_gcstack);
  shm_gcstack = newstack;
  shm_gcmax = newstack+shm_gcstack_size;
  return sp;
}
#endif

#define within_new_space(x)	\
( (unsigned long)(x) - (unsigned long)ntop < nsize)

#define within_old_space(x)	\
( (unsigned long)(x) - (unsigned long)otop < osize)


#define push_gc_stack(addr, sp, max)			\
{							\
  if ((sp) == max) {					\
    (sp) = make_larger_stack(sp);			\
    max = gcmax;					\
  }							\
  *(sp)++ = (addr);					\
}

#ifdef PFIRST

#define push_srec_stack(addr, sp, max)			\
{							\
  if ((sp) == max) {					\
    (sp) = make_larger_srec_stack(sp);			\
    max = srecmax;					\
  }							\
  *(sp)++ = (addr);					\
}

#define push_gthread_stack(addr)			\
{	 \
		 WDEB(fprintf(stderr,"%d:push gthread %x -> %x \n",my_node,addr,*addr)); \
  if (gthreadsp == gthreadmax) {					\
    gthreadsp = make_larger_gthread_stack(gthreadsp);			\
  }							\
  *(gthreadsp)++ = (addr);					\
}

#endif


#ifdef SHM
#define reserve_copy(from, to, sp, max)                 \
if (from == makeref(&from)) {                           \
  to = from = makeref(&to);                             \
} else {                                                \
  to = from;                                            \
  if (!isatomic(from)) {                                \
    if ( is_shma(from) ) {                              \
       push_shm_stack(&to,shm_sp,shm_gcmax);            \
    } else if ( within_old_space(from )) {              \
       from = makeref(&to);                             \
       push_gc_stack(&to, sp, max);                     \
    }                                                   \
  }                                                     \
}
#else
#define reserve_copy(from, to, sp, max)			\
if (from == makeref(&from)) {				\
  to = from = makeref(&to);				\
} else {						\
  to = from;						\
  if (!isatomic(from) && within_old_space(from)) {	\
    from = makeref(&to);				\
    push_gc_stack(&to, sp, max);			\
  }							\
}
#endif

#ifdef SCHED
#ifdef PFIRST
extern struct predicate stack_change_pred;

struct threadrec *
copy_one_thread(thread,sp,max,susp,otop,osize,allocp)
	struct threadrec* thread;
	q** sp;
	q** max;
	int susp;
	q* otop;
	unsigned long osize;
	q* allocp;
{
	declare_globals;
	q*stp;
	struct threadrec *ot = thread;
	struct threadrec *nt = (struct threadrec *)allocp;
	struct request_record *orequest = ot->rtop;
	struct request_record *nrequest;
	nt->stack = ot->stack;
	nt->prio = ot->prio;
	allocp += 6;
	nt->rtop = ot->rtop;

	/*
		 fprintf(logfile,"%d:copy_thread(%d)",my_node,susp);
		 fflush(logfile);
		 */
	if(orequest != no_request){
		nrequest = (struct request_record *)allocp;
		nrequest->next = no_request;
		nrequest->reply_data = orequest->reply_data;
		nrequest->wait_thread = orequest->wait_thread;
		allocp += 3;
		nt->rtop = nrequest;
		
		if(orequest->reply_data != (struct susprec*)0){
			q* address = (q*)&nrequest->reply_data;
			if(!isatomic(*address) && within_old_space(*address))
				push_gc_stack(address,sp,max);
		}
		if(orequest->wait_thread != (struct threadrec*)0){
			if(!isatomic(nrequest->wait_thread)
				 && within_old_space(nrequest->wait_thread)){
				push_gthread_stack(&nrequest->wait_thread);
			}
		}
	}

	/*	
		 fprintf(logfile," %x(%x) -> %x(%x) \n"
		 ,ot,ot->rtop,nt,nt->rtop);
		 fflush(logfile);
		 */
	
	orequest->next = nrequest;
	nt->next = ot->next;
	ot->next = nt;

	/* copy stack */
	stp = nt->stack->top;
	{
		struct stackrec *tmp = nt->stack;
		while(1){
			while(--stp >= tmp->bottom){
				if(!isatomic(*stp) && within_old_space(*stp)){
					push_gc_stack(stp,sp,max);
				}
			}
			if((*(stp+2)) != (q)&stack_change_pred)
				break;
			else{
				/* stack is chained */
				tmp = (struct stackrec *)*(stp+1);
				stp = tmp->top;
			}
		}
	}
	if(susp) copied_susp++;
	gcsp = sp;
	heapp = allocp;
	return nt;
}

#else

#define copy_one_thread(thread, sp, max, susp) \
{ \
	q *stp; \
	struct threadrec *ot=(thread); \
	struct threadrec *nt=(struct threadrec *)hp; \
	nt->stack=ot->stack; \
	hp += 2; \
	nt->next = ot->next; \
	ot->next = nt; \
	(thread) = nt; \
	stp = nt->stack->top; \
	while(--stp >= nt->stack->bottom){ \
		if(!isatomic(*stp) && within_old_space(*stp)){ \
			push_gc_stack(stp,sp,max); \
		} \
	} \
	if(susp) copied_susp++; \
}
#endif
#endif
#define copy_one_goal(goal, sp, max, susp)		\
{							\
  struct goalrec *og=(goal);				\
  int n = (og)->pred->arity;				\
  struct goalrec *ng = (struct goalrec *)hp;		\
  hp += n + 2;						\
  ng->next = og->next;					\
  og->next = ng;					\
  ng->pred = og->pred;					\
  og->pred = 0;						\
  while (--n >= 0) {					\
    reserve_copy(og->args[n], ng->args[n], (sp), (max)); \
  }							\
  (goal) = ng;						\
  if (susp) copied_susp++;				\
}

#ifdef PACKSEND
#define copy_one_pk_flg(pkf, sp, max)  \
{ \
	struct pk_flag *opkf = (pkf); \
	struct pk_flag *npkf = (struct pk_flag *)hp; \
	hp += 2; \
	npkf->next = opkf->next; \
	opkf->next = npkf; \
	if(opkf->value == (q)&(opkf->value)){ \
		npkf->value = (q)&(npkf->value); \
		opkf->value = (q)&(npkf->value); \
    pk_flg = npkf; \
	}else if(isint(opkf->value)){ \
		npkf->value = opkf->value; \
	  opkf->value = (q)(npkf->value); \
		pk_flg = npkf; \
	}else{ \
	  q newvar; \
		newvar = general_gc(*(q*)pkf->value, hp, sp); \
		npkf->value = newvar; \
		hp = heapp; \
	  opkf->value = (q)&(npkf->value); \
	} \
 (pkf) = (npkf); \
}


struct pk_flag *copy_pk_flg_queue();

q* gc_pk_flg(allocp, ntop, otop, nsize, osize)
	q *allocp, *ntop, *otop;
	unsigned long nsize, osize;
{
	declare_globals;
	extern struct pk_flag *pk_flg_top;
	extern struct pk_flag *pk_flg;
	extern struct pk_flag pk_flg_tail;
	q newdata;
	int i;

	i = 0;
	
	pk_flg_top = copy_pk_flg_queue(pk_flg_top, allocp, ntop, otop, nsize, osize);
	allocp = heapp;
	return(allocp);
}

extern q* copy_terms();

struct pk_flag *copy_pk_flg_queue(pkf, hp, ntop, otop, nsize, osize)
     struct pk_flag *pkf;
     q *hp;
     q *ntop, *otop;
     unsigned long nsize, osize;
{
  declare_globals;
  struct pk_flag *last, *next;
	extern struct pk_flag pk_flg_tail;
	extern struct pk_flag *pk_flg;
	
  /* Copy queue in reverse order */
  /* By this, variables will have better chance to be allocated */
  /* within the goal records or structures that'll be read after */
  /* their instantiation */

  /* First, reverse the goal queue */
  for (last=0; pkf!=&pk_flg_tail; last=pkf, pkf=next) {
    next = pkf->next;
    pkf->next = last;
  }
  /* Then copy and rearrange the goal queue */
  pkf = last;
  last = &pk_flg_tail;

  for (; pkf != 0; pkf=next) {
    next=pkf->next;
    copy_one_pk_flg(pkf, gcsp, gcmax);
    hp = copy_terms(hp, ntop, otop, nsize, osize, gcsp, gcmax); 
    pkf->next = last;
    last = pkf;
  }
  heapp = hp;
  return last;
}

#endif



static q *
copy_terms(hp, ntop, otop, nsize, osize, sp, max)
     q *hp;
     q *ntop, *otop;
     unsigned long nsize, osize;
     q **sp, **max;
{
  declare_globals;
  while (sp > gcstack) {
    q *addr = *--sp;
    q obj = *addr;
  loop:
#ifdef SHM
          if ( is_shma(obj) ) {
            *addr = obj;
            if ( ptagof(obj) != ATOMIC ) {
              push_shm_stack(addr,shm_sp,shm_gcmax);
            }
            continue;
          }
#endif
    switch (ptagof(obj)) {
    case ATOMIC:
      *addr = obj;
      break;
    case VARREF:
      {
				q value;
      deref:
#ifdef PFIRST
				if(check_srec(obj)){
					fatal("gc stack value is srec directly!\n");
				}
#endif
				value = derefone(obj);
				switch (ptagof(value)) {
				case VARREF:
#ifdef PFIRST
					if(check_srec(value)){
						/* $B6&M-JQ?t$N%3%T!<(B */
						if(within_new_space(addr)){
							*addr = derefone(obj) = makeref(addr);
						}else{
							struct scheduling_record* svar = untag_scheduling_record(value);
							*hp = (q)tag_scheduling_record(hp);
							*(hp+1) = (q)svar->pthread;
							*addr = derefone(obj) = makeref(hp);
							push_gthread_stack(((struct threadrec**)hp+1));
							hp += 2;
						}
					}else if (derefone(value) == obj) {
#else
						if(derefone(value) == obj){
#endif
							if (value == obj) {
								if (within_new_space(addr)) {
									*addr = derefone(obj) = makeref(addr);
								} else {
									*addr = derefone(obj) = *hp = makeref(hp);
									hp++;
								}
							} else {
								struct susprec *s = suspp(value);
								if (is_generator_susp(s->u)) {
									struct generator_susp *gsusp = generator_suspp(s);
									q newvar = *addr = derefone(obj) = makeref(hp);
									hp++;
									{
										struct generator_susp *newgsusp = generator_suspp(hp);
										hp += sizeof(struct generator_susp) / sizeof(q);
#ifdef PFIRST
										/* generator copy */
										s->backpt = derefone(newvar) = makeref(newgsusp);
										newgsusp->gthread = s->gthread;
										if(s->gthread != (struct threadrec*)0){
												push_gthread_stack(&newgsusp->gthread);
										}
#else
										derefone(newvar) = makeref(newgsusp);
#endif
										derefone(obj) = newgsusp->backpt = makeref(newvar);
									{
										struct generator_object *oldobj =
											untag_generator_susp(gsusp->u.o);
										q newplace = (q)(oldobj->method_table);
										if(!isstruct(newplace)) {
											/* not yet copied */
											struct generator_object *newobj;
											newobj = (struct generator_object *)
												generic_gc(oldobj, hp, sp);
											sp = gcsp;
											hp = heapp;
											oldobj->method_table = 
												(struct generator_object_method_table *)
													makefunctor(newobj);
											newgsusp->u.o = tag_generator_susp(newobj);
										} else {
											/* already copied */
											newgsusp->u.o =
												tag_generator_susp(functorp(newplace));
										}
									}
								}
							} else {
								struct hook *second_hook = s->u.first_hook.next;
								struct hook *h = second_hook;
								struct hook dummy;
								struct hook *last = &dummy;
#ifdef SCHED
								union thread_or_consumer lastu;
#else
								union goal_or_consumer lastu;
#endif
								q newvar;
								
								/* make a new variable, anyway */
								newvar = *addr = derefone(obj) = *hp = makeref(hp);
								hp++;
								lastu.l = 0;
								do {
#ifdef SCHED
									union thread_or_consumer u;
#else
									union goal_or_consumer u;
#endif									
									u = h->u;
									if (u.l != 0) {
#ifdef SCHED
										union thread_or_consumer nu;
#else
										union goal_or_consumer nu;
#endif
										nu.l = 0;
										if (!is_consumer_hook(u)) {
#ifdef SCHED

											if(!isref(u.t->next)){
												nu.t = u.t;
#ifdef PFIRST
												nu.t = copy_one_thread(nu.t,sp,max,1,otop,osize,hp);
												sp = gcsp;
												hp = heapp;
#else
												copy_one_thread(nu.t,sp,max,1);
#endif
											}else{
												goto not_a_valid_hook;
											}
#else											
											/* suspended goal */
											if (u.g->pred == 0) {
												nu.g = u.g->next;
											} else if (!isref(u.g->next)) {
												nu.g = u.g;
												copy_one_goal(nu.g, sp, max, 1);
											} else {
												goto not_a_valid_hook;
											}
#endif
										} else {
											/* consumer object */
											q newplace = (q)(untag_consumer_hook(u.o)->method_table);
											if (isstruct(newplace)) {
												nu.o = tag_consumer_hook(functorp(newplace));
											} else {
												struct consumer_object *newobj =
													(struct consumer_object *)
														generic_gc(untag_consumer_hook(u.o), hp, sp);
												sp = gcsp;
												hp = heapp;
												untag_consumer_hook(u.o)->method_table =
													(struct consumer_object_method_table *)
														makefunctor(newobj);
												nu.o = tag_consumer_hook(newobj);
											}
										}
										if (lastu.l != 0) {
											struct hook *nh = (struct hook *)hp;
											hp += sizeof(struct hook)/sizeof(q);
											nh->u = lastu;
											last->next = nh;
											last = nh;
										}
										lastu = nu;
									}
								not_a_valid_hook:
									h = h->next;
								} while (h != second_hook);
								if (lastu.l != 0) {
									struct susprec *ns = (struct susprec *)hp;
#ifdef PFIRST
									ns->gthread = s->gthread;
									if(s->gthread != (struct threadrec*)0){
										push_gthread_stack(&ns->gthread);
									}
									s->backpt = (q)ns;
									WDEB(fprintf(stderr,"%d:copy susp %x -> %x\n",my_node,s,ns));
#endif
									hp += sizeof(struct susprec)/sizeof(q);
									last->next = &ns->u.first_hook;
									ns->backpt = newvar;
									ns->u.first_hook.next = dummy.next;
									ns->u.first_hook.u = lastu;
									derefone(newvar) = (q)ns;
								}
							}
							}
#ifndef PFIRST
						}else if (within_old_space(value)) 
#else
					}else if (within_old_space(value)) 
#endif
						{
							obj = value;
							goto deref;
					} else {
						*addr = value;
#ifdef SHM
	    if ( is_shma(value) ) push_shm_stack(addr,shm_sp,shm_gcmax);
#endif
					}
					break;
				case CONS:
					if (within_new_space(value)) {
						*addr = makeref(&cdr_of(value));
					} else {
						obj = value;
						goto cons_case;
					}
					break;
				case ATOMIC:
					*addr = value;
					break;
				default: /* FUNCTOR */
					obj = value;
					goto functor_case;
				}
      }
      break;
    case CONS:
    cons_case:
      if (within_old_space(obj)) {
				q cdr = cdr_of(obj);
				if (!isstruct(cdr) || !within_new_space(cdr)) {
					q newcons = makecons(hp);
					hp += 2;
					reserve_copy(car_of(obj), car_of(newcons), sp, max);
					*addr = cdr_of(obj) = newcons;
					if (isatomic(cdr)) {
						cdr_of(newcons) = cdr;
					} else {
						if (cdr == makeref(&cdr_of(obj))) {
							cdr_of(newcons) = makeref(&cdr_of(newcons));
						} else {
							addr = &cdr_of(newcons);
							obj = cdr;
							goto loop;
						}
					}
				} else {
					*addr = cdr;
				}
      } else {
				*addr = obj;
      }
      break;
    default: /* FUNCTOR */
    functor_case:
      if (within_old_space(obj)) {
				q f = functor_of(obj);
				if(!isstruct(f)){
					if(isref(f)) {
						struct data_object *oldobj
							= (struct data_object *)functorp(obj);
						q *newobj;
						newobj = generic_gc(oldobj, hp, sp);
						sp = gcsp;
						hp = heapp;
						*addr = functor_of(obj) = makefunctor(newobj);
					} else {
						q newfunct = makefunctor(hp);
						int k = arityof(f);
						hp += k+1;
						*addr = functor_of(obj) = newfunct;
						functor_of(newfunct) = f;
						do {
							k--;
							reserve_copy(arg(obj,k), arg(newfunct,k), sp, max);
						} while (k > 0);
					}
				} else {
					*addr = f;
				}
      } else {
				*addr = obj;
      }
      break;
    }
  }
  gcsp = sp;
  return hp;
}

#ifdef SCHED
	struct threadrec *copy_one_queue(qp, hp, ntop, otop, nsize, osize)
     struct threadrec *qp;
     q *hp;
     q *ntop, *otop;
     unsigned long nsize, osize;
{
  declare_globals;
#ifdef PFIRST
  struct threadrec *last, *next;
#else
  struct threadrec *last, *next, *tmp;
#endif
  /* Copy queue in reverse order */
  /* By this, variables will have better chance to be allocated */
  /* within the thread records or structures that'll be read after */
  /* their instantiation */


#ifdef PFIRST
	/* $BAPJ}8~%j%s%/$N$?$a5U=g$KJB$YBX$($J$$(B */
	qp = thread_queue_tail.before;
	next = qp->before;
	qp = copy_one_thread(qp, gcsp, gcmax, 0, otop, osize, hp);
	hp = copy_terms(heapp,ntop,otop,nsize,osize,gcsp,gcmax);
	qp->next = &thread_queue_tail;
	last = thread_queue_tail.before = qp;
	for (qp=next; qp!=0 ;qp=next){
		next = qp->before;
		qp = copy_one_thread(qp,gcsp,gcmax,0,otop,osize,hp);
		hp = copy_terms(heapp,ntop,otop,nsize,osize,gcsp,gcmax);
		qp->next = last;
		last->before = qp;
		last = qp;
	}
	
#else
  /* First, reverse the thread queue */
  for (last=0; qp!=&thread_queue_tail; last=qp, qp=next) {
    next = qp->next;
    qp->next = last;
  }
	
  /* Then copy and rearrange the thread queue */

  qp = last;
  last = &thread_queue_tail;
  for (; qp != 0; qp=next) {
    next=qp->next;
    copy_one_thread(qp, gcsp, gcmax, 0);
    hp = copy_terms(hp, ntop, otop, nsize, osize, gcsp, gcmax);
    qp->next = last;
		last = qp;
  }
#endif
  heapp = hp;
  return last;
		
}
#else
struct goalrec *copy_one_queue(qp, hp, ntop, otop, nsize, osize)
     struct goalrec *qp;
     q *hp;
     q *ntop, *otop;
     unsigned long nsize, osize;
{
  declare_globals;
  struct goalrec *last, *next;

  /* Copy queue in reverse order */
  /* By this, variables will have better chance to be allocated */
  /* within the goal records or structures that'll be read after */
  /* their instantiation */

  /* First, reverse the goal queue */
  for (last=0; qp!=&goal_queue_tail; last=qp, qp=next) {
    next = qp->next;
    qp->next = last;
  }
  /* Then copy and rearrange the goal queue */
  qp = last;
  last = &goal_queue_tail;
  for (; qp != 0; qp=next) {
    next=qp->next;
#ifdef SHM
    if ( is_shma(qp) ) {
        qp->next = last;
        last = qp;
        continue;
    }
#endif
    copy_one_goal(qp, gcsp, gcmax, 0);
    hp = copy_terms(hp, ntop, otop, nsize, osize, gcsp, gcmax);
    qp->next = last;
    last = qp;
  }
  heapp = hp;
  return last;
}
#endif

#ifdef SCHED
static struct threadrec *collect_garbage(qp)
	struct threadrec *qp;
#else
static struct goalrec *collect_garbage(qp)
     struct goalrec *qp;
#endif
{
  declare_globals;
  int k;
  q *allocp, *ntop, *otop;
  unsigned long nsize, osize;
  struct prioqrec *pq = prioq.next;
#ifdef PFIRST
	struct threadrec *queue_tail = thread_queue_tail.before;
#endif

#ifdef DIST
  if (node_wtc == 0) {
    fatal("invalid WTC in gc");
  }
#endif

  if (gctimes==0) {
    /* allocate GC stack on first GC */
    gcstack_size = GCSTACKSIZE;
    gcstack = (q**)malloc_check(gcstack_size*sizeof(q*));
    gcsp = gcstack;
    gcmax = gcstack+gcstack_size;
#ifdef PFIRST
		srecstack_size = SRECSTACKSIZE;
    srecstack = (struct scheduling_record **)
			malloc_check(srecstack_size*sizeof(struct scheduling_record*));
    srecsp = srecstack;
    srecmax = srecstack+srecstack_size;
		gthreadstack_size = GTHREADSTACKSIZE;
    gthreadstack = (struct threadrec***)
			malloc_check(gthreadstack_size*sizeof(struct threadrec**));
    gthreadsp = gthreadstack;
    gthreadmax = gthreadstack+gthreadstack_size;
#endif		
		
#ifdef SHM
    shm_gcstack_size = GCSTACKSIZE;
    shm_gcstack = (q**)malloc(shm_gcstack_size*sizeof(q*));
    shm_sp = shm_gcstack;
    shm_gcmax = shm_gcstack+shm_gcstack_size;
  } else {
    shm_sp = shm_gcstack;
#endif
  }

#ifdef SHM
  /* copy into Shared-memory Generator hook data */
  {
    TADDRtbl* sptr = &ADDRtbl;
    TADDRtbl* nptr;
    sptr = &ADDRtbl;
    for(sptr=sptr->next;sptr!=&ADDRtbl;sptr=nptr) {
      nptr = sptr->next;
      switch(ptagof(sptr->localA)) {
      case CONS:
      case FUNCTOR: { /* generator hook */
	struct generator_object* addi;
	Shvar* objp;
	q temp;
  Re_try:
	temp = derefone(sptr->globalA);
	if ( !isref(temp) ) { break; }
	if ( derefone(temp) != (q)sptr->globalA ) {
	  sptr->globalA = (q*)temp; goto Re_try;
	}
	addi = n_lock(((q)sptr->globalA),temp);
	if ( derefone(sptr->globalA) != temp ) { goto Re_try; }
	objp = (Shvar*)untag_generator_susp(addi);
	if ( is_genhook(objp->chain)) {
	  q tempg;
	  shm_arg_copy(&sptr->localA,&tempg);
	  klic_barrier();
	  *(sptr->globalA) = tempg;
	  free_local_tbl(sptr);
	} else {
	  n_unlock(temp,addi);
	}
      }
      }
    }
  }
#endif

  allocp = ntop = heaptop = new_space_top;
  otop = old_space_top;
  real_heapbytesize = nsize = new_space_size;
  osize = old_space_size;
  real_heaplimit = allocp+heapsize;
  if (interrupt_off) heaplimit = real_heaplimit;
  else heaplimit = 0;
  heapbottom = real_heaplimit+incrementsize;

	WDEB(fprintf(stderr,"%d:ntop %x\n",my_node,ntop));
	
  for (k=0; k<num_gc_hooks; k++) {
	allocp = gc_hook_table[k](allocp, ntop, otop, nsize, osize);
  }


	
  for(; pq->prio >= 0; pq = pq->next) {
		/* copy other priority queue */
#ifdef PFIRST
		thread_queue_tail.before = pq->last;
		pq->q->before = 0;
    pq->q = copy_one_queue(pq->q, allocp, ntop, otop, nsize, osize);
		pq->last = thread_queue_tail.before;
#else
    pq->q = copy_one_queue(pq->q, allocp, ntop, otop, nsize, osize);
#endif
    allocp = heapp;
  }

#ifdef SCHED
	if(resumed_threads){
		/* copy resumed threads */
		struct threadrec* rsmt,*tmp;
		rsmt = resumed_threads;
		tmp = rsmt->next;
		rsmt->next = &thread_queue_tail;
#ifdef PFIRST
		thread_queue_tail.before = rsmt;
		tmp->before = (struct threadrec *)0;
#endif
		rsmt = tmp;

#ifdef PFIRST
		tmp = copy_one_queue(rsmt, allocp, ntop, otop, nsize, osize);
		rsmt = thread_queue_tail.before;
		tmp->before = rsmt;
		rsmt->next = tmp;
		resumed_threads = rsmt;
#else
		tmp = rsmt = copy_one_queue(rsmt, allocp, ntop, otop, nsize, osize);
		while(tmp->next != &thread_queue_tail){
			tmp = tmp->next;
		}
		tmp->next = rsmt;
		resumed_threads = tmp;
#endif
		allocp = heapp;
	}
#endif

#ifdef PFIRST
	/* copy prior_thread */
	if(prior_thread){
		prior_thread = copy_one_thread
			(prior_thread, gcsp, gcmax, 0, otop, osize, allocp);
		prior_thread->next = prior_thread->before = prior_thread;
		allocp = heapp;
	}
	/* copy current priority queue */
	if(qp != &thread_queue_tail){
		thread_queue_tail.before = queue_tail;
		qp->before = 0;
		qp = copy_one_queue(qp, allocp, ntop, otop, nsize, osize);
	}
#else
  qp = copy_one_queue(qp, allocp, ntop, otop, nsize, osize);
#endif
#ifdef SHM
  {
    TADDRtbl* sptr = &ADDRtbl;
    TADDRtbl* nptr;
    q *hp = heapp;
    sptr = &ADDRtbl;
    for(sptr=sptr->next;sptr!=&ADDRtbl;sptr=nptr) {
      nptr = sptr->next;
      switch(ptagof(sptr->localA)) {
      case CONS:
      case FUNCTOR: { /* generator hook but anybody reqested */
        push_gc_stack((q*)&sptr->localA,gcsp,gcmax);
        hp = copy_terms(hp, ntop, otop, nsize, osize, gcsp, gcmax);
        push_shm_stack(&sptr->globalA,shm_sp,shm_gcmax);
        break;
      }
      case ATOMIC: { /* genarator object (distributed interface) */
	q wk = (q)untag_local(sptr->localA);
	if ( !derefone(wk) ) { /* consumer */
	  q top = (q)&(sptr->localA);
	  derefone(wk) = top;
	  derefone(top) = wk;
	  push_gc_stack(&top,gcsp,gcmax);
	  hp = copy_terms(hp, ntop, otop, nsize, osize, gcsp, gcmax);
	  wk = derefone(top);
	  if ( wk != top ) {
	    sptr->localA = (q*)tag_local(wk);
	    derefone(wk) = 0;
            push_shm_stack(&sptr->globalA,shm_sp,shm_gcmax);
          } else goto REM_HOOK;
	  break;
	} else { /* generator */
	  push_gc_stack(&wk,gcsp,gcmax);
	  hp = copy_terms(hp, ntop, otop, nsize, osize, gcsp, gcmax);
	  sptr->localA = (q*)tag_local(wk);
          push_shm_stack(&sptr->globalA,shm_sp,shm_gcmax);
	  break;
	}
      }
      default: { /* normal goal */
	struct goalrec* wqp = (struct goalrec*)sptr->localA;
	if ( !wqp ) { /* skip */
	} else if ( !wqp->pred ) {
	  sptr->localA = (q*)wqp->next;
	} else if ( isint(wqp->next) ) {
	  copy_one_goal(wqp, gcsp, gcmax,1);
	  sptr->localA = (q*)wqp;
	  hp = copy_terms(hp, ntop, otop, nsize, osize, gcsp, gcmax);
	  if ( isref(sptr->globalA) ) {
	    q ww;
	    while (1) {
	      ww = derefone(sptr->globalA);
	      if ( isref(ww) ) {
		if ( (q)sptr->globalA == derefone(ww) ) break;
		else {
		  sptr->globalA = (q*)ww;
		}
	      } else break;
	    }
	  }
	  push_shm_stack(&sptr->globalA,shm_sp,shm_gcmax);
	} else {
	REM_HOOK:
	  sptr->localA = 0;
          /* removes a hook record */
	  {
	    struct generator_object* addi;
	    q sv;
	    Shvar* objp;
	    Sinfo *hk,*bsi,*si;
	    q var = (q)sptr->globalA;
	    sv = derefone(var);
	    if ( !isref(sv) || derefone(sv) != var )  { goto REM_skip; }
	    addi = n_lock(var,sv);
	    if ( derefone(var) != sv ) goto REM_skip;
	    objp = (Shvar*)untag_generator_susp(addi);
	    hk = objp->chain;
	    if ( hk->indp == sptr ) {
	      objp->chain = hk->next;
		  free_local_tbl(sptr);
	    } else {
	      for(bsi=hk,si=bsi->next;(si);bsi=si,si=si->next) {
		if ( si->indp == sptr ) {
		  bsi->next = si->next;
		  free_local_tbl(sptr);
		  break; }
	      }
	    }
	    n_unlock(sv,addi);
	  REM_skip:
	    ;
	  }
	}
      }
      }
    }
    heapp = hp;
  }
#endif

#ifdef SCHED
#ifdef DEBUGLIB
  {
    struct suspended_thread_rec *sgl = suspended_thread_list;
    struct suspended_thread_rec **sgl_tail = &suspended_thread_list;
    struct threadrec *dead_thread = 0;
    q *hp = heapp;
    if (copied_susp != suspensions-resumes) {
      klic_fprintf(stderr,
		   "%d perpetually suspending threads found\n",
		   suspensions-resumes-copied_susp);
    }
    /* First, we will copy the surface of suspended thread list.
       This is needed to distinguish resumed threads and
       threads copied while copying other threads in this list */
    while (sgl != 0) {
			q* stackp = sgl->thread->stack->top;
			struct predicate *pred = (struct predicate *)*--stackp;
      if (pred == 0 ||
					/* already copied */
					!isref(sgl->thread->next)
					/* or not resumed yet */
					) {
				struct suspended_thread_rec *newsgr =
					(struct suspended_thread_rec *)hp;
				hp += sizeof(struct suspended_thread_rec)/sizeof(q);
				*sgl_tail = newsgr;
				newsgr->thread = sgl->thread;
				sgl_tail = &newsgr->next;
      }
      sgl = sgl->next;
    }
    *sgl_tail = 0;
    /* Next, we will copy the suspended threads */
    sgl = suspended_thread_list;
    while (sgl != 0) {
			q* stackp = sgl->thread->stack->top;
			struct predicate* pred = (struct predicate *)*--stackp;
      if (pred != 0) {
				/* not copied yet */
#ifdef PFIRST
				sgl->thread =
					copy_one_thread(sgl->thread, gcsp, gcmax, 0, otop, osize, hp);
				hp = heapp;
#else
				copy_one_thread(sgl->thread, gcsp, gcmax, 0);
#endif
				hp = copy_terms(hp, ntop, otop, nsize, osize, gcsp, gcmax);
				dead_thread = sgl->thread;
      } else {
				sgl->thread = sgl->thread->next;
      }
      sgl = sgl->next;
    }
    heapp = hp;
    if (dead_thread != 0) {
      /* we have to make the dead thread look like a normal ready queue */
			extern struct threadrec thread_queue_tail;
      dead_thread->next = &thread_queue_tail;
			trace_deadlock(dead_thread); 
    }
  }
#endif
#else
#ifdef DEBUGLIB
  {
    struct suspended_goal_rec *sgl = suspended_goal_list;
    struct suspended_goal_rec **sgl_tail = &suspended_goal_list;
    struct goalrec *dead_goal = 0;
    q *hp = heapp;
    if (copied_susp != suspensions-resumes) {
      klic_fprintf(stderr,
		   "%d perpetually suspending goals found\n",
		   suspensions-resumes-copied_susp);
    }
    /* First, we will copy the surface of suspended goal list.
       This is needed to distinguish resumed goals and
       goals copied while copying other goals in this list */
    while (sgl != 0) {
      if (sgl->goal->pred == 0 ||
	  /* already copied */
	  !isref(sgl->goal->next)
	  /* or not resumed yet */
	  ) {
	struct suspended_goal_rec *newsgr =
	  (struct suspended_goal_rec *)hp;
	hp += sizeof(struct suspended_goal_rec)/sizeof(q);
	*sgl_tail = newsgr;
	newsgr->goal = sgl->goal;
	sgl_tail = &newsgr->next;
      }
      sgl = sgl->next;
    }
    *sgl_tail = 0;
    /* Next, we will copy the suspended goals */
    sgl = suspended_goal_list;
    while (sgl != 0) {
      if (sgl->goal->pred != 0) {
	/* not copied yet */
	copy_one_goal(sgl->goal, gcsp, gcmax, 0);
	hp = copy_terms(hp, ntop, otop, nsize, osize, gcsp, gcmax);
	dead_goal = sgl->goal;
      } else {
	sgl->goal = sgl->goal->next;
      }
      sgl = sgl->next;
    }
    heapp = hp;
    if (dead_goal != 0) {
      /* we have to make the dead goal look like a normal ready queue */
      extern Const struct predicate queue_empty_pred;
      ((struct goalrec *)hp)->pred = &queue_empty_pred;
      dead_goal->next = (struct goalrec *)hp;
      hp += sizeof(struct goalrec)/sizeof(q);
/*       trace_deadlock(dead_goal); */
			exit(0);
    }
  }
#endif
#endif	
  for (k=0; k<num_after_gc_hooks; k++) {
    heapp = after_gc_hook_table[k](heapp);
  }

	/* copy request_record */
#ifdef PFIRST
	if(current_request != no_request){
		current_request = current_request->next;
#ifdef GCDEBUG
			 fprintf(logfile,"%d:current_requst %x %x\n",
			 my_node,current_request,current_request->next);
			 fflush(logfile);
#endif
#ifdef GCDEBUG
			 fprintf(logfile," -> %x",rqt);
			 fflush(logfile);
			 fprintf(logfile,"(%x,%x) ",
			 rqt->reply_data,rqt->wait_thread);
			 fflush(logfile);
#endif
#ifdef DIST
		{
			struct request_record *rqt = request_queue_top;
			struct request_record *last = 0;
			q *hp = heapp;
			while(rqt != no_request){
				q data = rqt->reply_data->backpt;
				while(isref(data)){
				q tmp = derefone(data);
				if(isref(tmp) && data == derefone(tmp)){
					struct request_record *newreq = 
						(struct request_record*)hp;
					newreq->next = (struct request_record*)((q*)hp+3);
					newreq->reply_data = (struct susprec *)data;
					if(isref(rqt->wait_thread)){
						newreq->wait_thread = rqt->wait_thread->next;
					}else{
						struct consumer_object *rplobj =
							untag_consumer_hook(rqt->wait_thread);
						newreq->wait_thread = (struct threadrec *)
							tag_consumer_hook(functorp(rplobj->method_table));
					}
					last = newreq;
					hp+=3;
					break;
				}
			  data = tmp;
			}
				rqt = rqt->next;
			}

#ifdef GCDEBUG
		 fprintf(logfile,"-> no_request\n");
		 fprintf(logfile,"%d: heapp %x , hp %x\n",my_node,heapp,hp);
		 fflush(logfile);
#endif

			if(heapp != hp){
				request_queue_top = (struct request_record *)heapp;
				request_queue_tail = last;
				request_queue_tail->next = no_request;
				heapp = hp;
			} else {
				request_queue_top = no_request;
				request_queue_tail = last;
			}
#ifdef GCDEBUG
	{
		wbufp = wbuf;
		rqt = request_queue_top;
		fprintf(logfile,"%d:newrqt",my_node);
		fflush(logfile);
		while(rqt != no_request){
		 fprintf(logfile," -> %x",rqt);
		 fflush(logfile);
		 fprintf(logfile,"(%x,%x) ",
						 rqt->reply_data,rqt->wait_thread);
		 fflush(logfile);
		 rqt = rqt->next;
	 }
		fprintf(logfile," -> no_request\n");
		fflush(logfile);
	}
#endif
		}
#endif
	}

	/* gthreadstack$B$+$i$N%3%T!<(B */
	{
		struct threadrec ***sp;
		sp = gthreadsp;
		while(sp > gthreadstack){
			struct threadrec** gthreadp = *--sp;
			struct threadrec *gthread = *gthreadp;
			/*			
				 fprintf(logfile,
				 "%d:pop gthread %x -> %x \n",my_node,gthreadp,gthread);
				 fflush(logfile);
				 */

			if(isref(gthread)){
				*gthreadp = gthread->next;
			}else{
				struct consumer_object *rplobj =
					untag_consumer_hook(gthread);
				*gthreadp = (struct threadrec *)
					tag_consumer_hook(functorp(rplobj->method_table));
			}
		}
		gthreadsp = sp;
	}

#endif
	
  return qp;
}

/*
  interface routine for copying one term
*/

	q* copy_one_term(term, allocp, ntop, otop, nsize, osize)
     q *term;
     q *allocp, *ntop, *otop;
     unsigned long nsize, osize;
{
  declare_globals;
  push_gc_stack(term, gcsp, gcmax);
  return
    copy_terms(allocp, ntop, otop, nsize, osize, gcsp, gcmax);
}

/*
  for generic object
*/
q
general_gc(term, allocp, sp)
	q *term;
	q *allocp;
	q **sp;
{
  declare_globals;

  push_gc_stack(term, sp, gcmax);
  heapp = copy_terms(allocp, new_space_top, old_space_top,
		     new_space_size, old_space_size,
		     sp, gcmax);
  return *term;
}

