/* ----------------------------------------------------------
%        Copyright (C) 1996-1997 Kazuhiko Ohno, Masahiko Ikawa,
%        and Computer Architecture Laboratory, Depertment of
%        Information Science, Kyoto University.
%----------------------------------------------------------- */  

#define DEBUG
#include <klic/basic.h>
#include <klic/struct.h>
#include <klic/primitives.h>
#include <klic/index.h>
#include <klic/gb.h>
#include <klic/functorstuffs.h>
#include <klic/atomstuffs.h>
#include <stdio.h>
#include <klic/gobj.h>
#include <klic/susp.h>
#include <klic/sched.h>
/*#include <klic/testpredicate.h>*/
#include <klic/g_methtab.h>
#include <klic/debugprint.h>
#include <klic/wdebug.h>
#ifdef PDEBUG
Const struct thread_name_rec trec_tail = {
	0,
	(char *)"tail",
	0
};
#endif

void print_thread_name();
extern struct predicate stack_empty_pred;
extern struct predicate stack_change_pred;

#ifdef PDEBUG
void delete_trec(thread)
	struct threadrec *thread;
{
	declare_globals;
	struct thread_name_rec *trec = trec_queue;
	struct thread_name_rec *before = 0;
	while(trec != &trec_tail){
		if(trec->addr == thread){
			if(before){
				before->next = trec->next;
			}else{
				trec = trec->next;
			}
			free(trec);
			return;
		}
		before = trec;
		trec=trec->next;
	}
}
#endif

void reset_thread_name_rec(old,new)
	struct threadrec *old,*new;
{
	declare_globals;
#ifdef PDEBUG
	struct thread_name_rec *trec = trec_queue;
	while(trec != &trec_tail){
		if(trec->addr == old){
			trec->addr = new;
			break;
		}
		if(isref(trec))
			trec=trec->next;
		else
			break;
	}
#endif
}
		

char *sprint_stack_queue(stack,thread,buf)
	struct stackrec *stack;
	struct threadrec *thread;
	char *buf;
{
	declare_globals;
	struct stackrec *tmp = stack;
	q* bottom = stack->bottom;
	q data = *(stack->bottom+2);

	print_thread_name(thread);
	sprintf(buf,"'s stack :\n %x",stack);
	buf += strlen(buf);
	while(data == (q)&stack_change_pred){
		tmp = (struct stackrec *)*(tmp->bottom+1);
		sprintf(buf," -> %x ",tmp);
		buf += strlen(buf);
		data = *(tmp->bottom+2);
	}
	return buf;
}

extern char* malloc_check();

void set_thread_name_rec(thread,name)
	struct threadrec *thread;
	char *name;
{
#ifdef PDEBUG
	declare_globals;
	struct thread_name_rec *trec;
	trec = (struct thread_name_rec*)malloc_check(sizeof(struct thread_name_rec));
	trec->thread_name = name;
	trec->addr = thread;
	trec->next = trec_queue;
	trec_queue = trec;
#endif
}


char *sprint_thread_name(thread,buf)
	struct threadrec *thread;
	char *buf;
{
	declare_globals;

#ifndef DIST
#ifdef PDEBUG
	struct thread_name_rec *trec = trec_queue;
	char *name = "Unknown";
	while(trec != &trec_tail){
		if(trec->addr == thread){
			name = trec->thread_name;
			break;
		}
		trec = trec->next;
	}
	sprintf(buf,"%s (%x)",name,thread);
	buf += strlen(buf);
#else
	sprintf(buf,"(%x)",thread);
	buf += strlen(buf);
#endif
#else
	sprintf(buf,"(%x)",thread);
	buf += strlen(buf);
#endif
	return buf;
}

char *sprint_susprec(sx,bufp)
	struct susprec *sx;
	char *bufp;
{
	declare_globals;
	if(is_generator_susp(sx->u)){
		/*		
		struct generator_susp *gsusp = generator_suspp(sx);
		struct generator_object *gobj = untag_generator_susp(gsusp->u.o);
		*/
		sprintf(bufp," %x (generator_susp)",sx);
		bufp+=strlen(bufp);
	}else{
		struct hook *top = sx->u.first_hook.next;
		struct hook *loopp = top;
		sprintf(bufp," %x (consumers or suspend_threads) ",sx);
		bufp+=strlen(bufp);
	}
	return bufp;
}
		 


char *sprint_const(data,bufp)
	q data;
	char *bufp;
{
	declare_globals;
	switch (ptagof(data)) {
	case CONS:
		{
			q car,cdr;
			car = car_of(data);
			cdr = cdr_of(data);
			sprintf(bufp,"[");
			bufp += strlen(bufp);
			sprintf(bufp,"%x",car);
			bufp += strlen(bufp);
			sprintf(bufp,"|");
			bufp += strlen(bufp);
			/* 			sprintf(bufp,"%x",cdr);
							bufp += strlen(bufp);
							*/
			bufp = sprint_data(cdr,bufp);
			sprintf(bufp,"]");
			bufp += strlen(bufp);
		}
		break;
	case ATOMIC:
		sprintf(bufp,"%d (ATOM)",intval(data));
		bufp += strlen(bufp);
		break;
	case FUNCTOR:
		sprintf(bufp,"functor");
		bufp += strlen(bufp);
		break;
	}
	return bufp;
}



char* sprint_data(data,bufp)
	q data;
	char *bufp;
{
	declare_globals;
	if(isref(data)){
		q tmp = derefone(data);
		if(isref(tmp)){
		deref:
			{
#ifdef PFIRST
				if(check_srec(tmp)){
					sprintf(bufp," %x (%x) ",tmp,srecp(data)->pthread);
					bufp += strlen(bufp);
					return bufp;
				}
#endif
				if(tmp == data){
					sprintf(bufp," %x (REF) ",data);
					bufp += strlen(bufp);
					return bufp;
				}else{
					q tmp1 = derefone(tmp);
					if(isref(tmp1)){
						if(tmp1 == data){
							struct susprec* susp = (struct susprec *)tmp;
							sprintf(bufp," %x ->",data);
							bufp += strlen(bufp);
							bufp = sprint_susprec(tmp,bufp);
						}else{
							sprintf(bufp," %x ->",data);
							bufp += strlen(bufp);
							data = tmp;
							tmp = tmp1;
							goto deref;
						}
					}else{
						sprintf(bufp," %x -> %x -> ",data,tmp);
						bufp += strlen(bufp);
						bufp = sprint_const(tmp1,bufp);
					}
				}
			}
		}else{
			sprintf(bufp," %x -> ",data);
			bufp += strlen(bufp);
			bufp = sprint_const(tmp,bufp);
		}
	}else{
		bufp = sprint_const(data,bufp);
	}
	return bufp;
}


		 



char* sprint_qp(qp)
	struct threadrec *qp;
{
	declare_globals;
	char buf[1000];
	char *bp = buf;
	char *bufp = buf;
	sprintf(bp,"qp -> ");
	bp += strlen(bp);
	{ 
		extern struct threadrec thread_queue_tail;
		struct threadrec *before,*tmp = qp;
		if(tmp != &thread_queue_tail){
			sprintf(bp," %x ",tmp);
			bp += strlen(bp);
			while(tmp != &thread_queue_tail){
				before = tmp;
				tmp = tmp->next;
#ifdef PFIRST
				if(tmp != &thread_queue_tail && before != tmp->before){
#ifndef DIST
					sprintf(bp," %x -> %x ",before,tmp->before);
					bp += strlen(bp);
#endif
					fatal("Unexpected thread chain !!");
					
				}
#endif
				sprintf(bp," ->");
				bp+=strlen(bp);
				if(tmp == &thread_queue_tail){
					sprintf(bp,"thread_queue_tail(%x):(p(%d))\n",tmp,current_prio);
					bp+=strlen(bp);
				}else{
					sprintf(bp," %x",tmp);
					bp+=strlen(bp);
				}
			}
			sprintf(bp,"\n");
			bp+=strlen(bp);
		}else{
			sprintf(bp,"thread_queue_tail(%x):(p(%d))\n",tmp,current_prio);
			bp+=strlen(bp);
		}
	}
	return bufp;
}


		



char *sprint_thread(thread,bufp)
	struct threadrec *thread;
	char *bufp;
{
	declare_globals;

	sprintf(bufp,"======= thread(%x) =======\n",thread);
	bufp+=strlen(bufp);
	{ 
		int i,j,arity; 
		struct predicate *pred; 
		q* stackp = thread->stack->top; 
		pred = (struct predicate *)*--stackp;
		j = 0;

		do{
			arity = pred->arity;
			sprintf(bufp,"pred %x\n",pred);
			bufp+=strlen(bufp);
			
/* 			print_predicate_name(pred);*/
			for (i=0;i<arity;i++){ 
				q arg; 
				sprintf(bufp,"arg[%d] of %dth stack :",i,j); 
				bufp+=strlen(bufp);
				arg = *--stackp; 
				if(isref(arg)){ 
				 q temp = derefone(arg); 
			 deref_print:
#ifdef PFIRST
				 if(issrec(temp)){
					 sprintf(bufp," %x -> { %x (thread (%x))}\n , "
									 ,arg,temp,((struct scheduling_record*)arg)->pthread);
					 bufp+=strlen(bufp);
				 }else if (arg != temp){
#else
				 if(arg != temp){
#endif
					 if(isref(temp)) { 
						 q temp1 = derefone(temp); 
						 if(temp1 == arg) {
							 struct susprec *sx = (struct susprec *)temp;
							 sprintf(bufp," %x -> %x ->",arg,temp);
							 bufp+=strlen(bufp);
							 bufp = sprint_susprec(sx,bufp);
						 }else{ 
							 sprintf(bufp," %x ->",arg); 
							 bufp+=strlen(bufp);
							 arg = temp; 
							 temp = temp1; 
							 goto deref_print; 
						 } 
					 }else{
						 sprintf(bufp," %x -> ",arg);
						 bufp+=strlen(bufp);
						 bufp = sprint_const(temp);
						 sprintf(bufp,"\n");
						 bufp+=strlen(bufp);
					 } 
				 }else{ 
					 sprintf(bufp," %x:REF\n",arg); 
					 bufp+=strlen(bufp);
				 } 
				}else{ 
					bufp = sprint_const(arg,bufp);
					sprintf(bufp,"\n");
					bufp+=strlen(bufp);
				} 
			}
		}while((pred = (struct predicate *)*--stackp) != &stack_empty_pred); 
	}
		return bufp;
}

char *sprint_goal(stackp,bufp)
	q *stackp;
	char *bufp;
{
	declare_globals;

	sprintf(bufp,"goal(");
	bufp += strlen(bufp);
	{ 
		int i,j,arity; 
		struct predicate *pred; 
		pred = (struct predicate *)*--stackp;
		j = 0;
		
		arity = pred->arity;
		/* 	print_predicate_name(pred);*/
		for (i=0;i<arity;i++){ 
			q arg; 
			arg = *--stackp; 
			if(isref(arg)){ 
				q temp = derefone(arg); 
			deref_print:
#ifdef PFIRST
				 if(issrec(temp)){
					 sprintf(bufp," %x (thread (%x)) ",
									 temp,((struct scheduling_record*)arg)->pthread);
					 bufp+=strlen(bufp);
				 }else if (arg != temp){
#else
					 if(arg != temp){
#endif
						 if(isref(temp)) {
							 q temp1 = derefone(temp); 
							 if(temp1 == arg) {
								 struct susprec *sx = (struct susprec *)temp;
								 if(is_generator_susp(sx->u)){
									 sprintf(bufp," %x (exref)",sx);
									 bufp+=strlen(bufp);
								 }else{
									 sprintf(bufp," %x (susp) ",sx);
									 bufp+=strlen(bufp);
								 }
							 }
						 }
#ifndef PFIRST
					 }else
#else
				 }else
#endif
					 {
						 sprintf(bufp," %x:(REF)",arg); 
						 bufp+=strlen(bufp);
					 } 
			}else{ 
				bufp = sprint_const(arg,bufp);
			} 
			sprintf(bufp,",");
			bufp += strlen(bufp);
		}
	}
	sprintf(bufp,");");
	bufp += strlen(bufp);
	return bufp;
}
	

void print_throw_thread(thread)
	struct threadrec *thread;
{
	char buf[1000];
	char *bufp = buf;
	sprintf(bufp,"thread(%x)\n",thread);
	bufp += strlen(bufp);
	bufp = sprint_goal(thread->stack->top,bufp);
	fprintf(logfile,"   %s\n",buf);
	return;
}


char*
sprint_queue(qp,buf)
	struct threadrec *qp;
	char *buf;
{ 
	extern struct threadrec thread_queue_tail;
	struct threadrec *tmp = qp;
	buf = sprint_qp(tmp,buf);
	sprintf(buf,"\n");
	buf += strlen(buf);
	while(tmp != &thread_queue_tail){
		int i = 0;
		buf = sprint_thread(tmp,buf); 
		tmp = tmp->next; 
		i++; 
	} 
	return buf;
}


void print_susprec(sx)
	struct susprec *sx;
{
	declare_globals;
	char buf[1000];
	char *bufp = buf;
	bufp = sprint_susprec(sx,bufp);
	fprintf(logfile," %x",buf);
}

void print_thread_name(thread)
	struct threadrec *thread;
{
	declare_globals;
	char buf[1000];
	char *bufp = buf;
	bufp = sprint_thread_name(thread,bufp);
	fprintf(logfile," %x",buf);
}


void print_data(data)
	q data;
{
	declare_globals;
	char buf[1000];
	char *bufp = buf;
	bufp = sprint_data(data,bufp);
	fprintf(logfile," %s",buf);
}

void print_thread(thread)
	struct threadrec*  thread;
{
	declare_globals;
	char buf[1000];
	char *bufp = buf;
	bufp = sprint_thread(thread,bufp);
	fprintf(logfile," %x",buf);
}

void print_const(data)
	q data;
{
	declare_globals;
	char buf[1000];
	char *bufp = buf;
	bufp = sprint_const(data,bufp);
	fprintf(logfile," %x",buf);
}


void print_qp(qp)
	struct threadrec *qp;
{
	declare_globals;
	char buf[1000];
	char *bufp = buf;
	bufp = sprint_qp(qp,bufp);
	fprintf(logfile," %x",buf);
}

void print_queue(qp)
	struct threadrec *qp;
{
	declare_globals;
	char buf[1000];
	char *bufp = buf;
	bufp = sprint_queue(qp,bufp);
	fprintf(logfile," %x",buf);
}

void print_stack_queue(stack,thread)
	struct stackrec *stack;
	struct threadrec *thread;
{
	declare_globals;
	char buf[1000];
	char *bufp = buf;
	bufp = sprint_stack_queue(stack,thread,bufp);
	fprintf(logfile," %x",buf);
}


void print_thread_num(qp)
	struct threadrec *qp;
{
	declare_globals;
	int num=0;
	extern struct threadrec thread_queue_tail;
	struct threadrec *rsmt = resumed_threads;
	struct threadrec *top = rsmt;

	if(rsmt !=0){
		num++;
		while(rsmt->next != top){
			num++;
			rsmt = rsmt->next;
		}
	}
	while(qp != &thread_queue_tail){
		num++;
		qp = qp->next;
	}

	num += (suspensions-resumes);

	fprintf(logfile,
					" the number of suspended threads is %d\n",suspensions-resumes);
	fprintf(logfile," the number of nessesary copy thread is %d\n",num);
}


