/* ----------------------------------------------------------
%        Copyright (C) 1996-1997 Kazuhiko Ohno, Masahiko Ikawa,
%        and Computer Architecture Laboratory, Depertment of
%        Information Science, Kyoto University.
%----------------------------------------------------------- */  

/* ---------------------------------------------------------- 
%   (C)1994,1995 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
/* #define WDEBUG
#define INT_CL_DEBUG   */
#define DD(X)
#include <klic/wdebug.h>
#include <klic/basic.h>
#include <klic/struct.h>
#include <klic/primitives.h>
#include <klic/unify.h>
#include <klic/functorstuffs.h> 
#include <klic/timing.h>

#include <klic/gb.h>
#include <klic/gobj.h>
#include <klic/susp.h>
#include <klic/functorstuffs.h>
#include <klic/atomstuffs.h>

#include <stdio.h>
#include <setjmp.h>

#include <klic/interpe.h>
#include <klic/rmon.h>

#include <klic/generic.h> 
#include <klic/index.h> 
#include <klic/alloc.h>

#include <klic/distio.h>

#ifdef SCHED
#include <klic/sched.h>
#include <klic/debugprint.h>
#endif

#ifdef PACKSEND
#include <pk_struct.h>
#include <pk_throw.h>
#include <pk_macro.h>
#include <pk_index.h>
#include <packsend.h>
#endif

/*
  Distributed unification
  ANSWER VALUE		void send_answer_value(data, node, index, wec)
  READ			long send_read(node, index, var)
  RELEASE		void send_release(node, index, wec)
  UNIFY			void send_unify(node, index, wec, data)

  Process migration
  THROW GOAL		struct goalrec * send_throw_goal(node, goal, oldqp)
			

  Termination for the reduction nodes
  TERMINATE MSG		void terminate_all_node()

  */

extern q search_exptbl();
extern q reply_hook_g_new();
#ifdef SCHED
struct threadrec *trace_thread();
#else
struct goalrec *trace_goal();
#endif

extern void encode_data();
extern void send_message();
extern void send_message_without_wtc_chk();
extern void terminate_profiling();
extern void message_suspend();

q pop_decode_stack();

#ifdef PACKSEND
/* GENERIC OBJECT */
q reply_all_hook_g_new();
q answerhook_g_new();
q in_exref_g_new();
q out_exref_g_new();
q packbuf_g_new();
#endif

/*
  ANSWER VALUE
  */
#ifdef PACKSEND
q*
#else
static q*
#endif
decode_answer_value(inbuf, allocp)
combuf *inbuf;
q *allocp;
{
    q exref;
    module decoder;  
    long return_index, wec;
    declare_globals;

		INT_CL_DEBUG_X(fprintf(logfile,"%d:decode_answer_value\n", my_node));
		INT_CL_DEBUG_X(fflush(logfile));

		DD(fprintf(logfile,"%d:decode_answer_value\n", my_node));
		
    INT_CL_PROBE_X(netstat.recv_answer_cnt++);

    add_node_wtc(GET_BUFFER(inbuf));

    return_index = GET_BUFFER(inbuf);
    wec          = GET_BUFFER(inbuf);

    exref = (q)search_exptbl(return_index, wec);  

    deref_and_switch(exref, susp_label, atomic_label, cons_label, funct_label);
	atomic_label:
	cons_label:
	funct_label:
    /* decode_data is not used, and collected by local GC */
    decode_data = pop_decode_stack();

    return(allocp);

	susp_label:

#ifdef PFIRST
		if(check_srec(derefone(exref)))
			fatal("unify answer_value with srec , it never happens!\n");
#endif

    decode_data = pop_decode_stack();
    receive_answer_flag = 1;

    /* Hack to avoid sending %unify when a ReadHook receives answer_value. */
    answer_return_exp_index = return_index;
    
    allocp = do_unify(allocp, exref, decode_data);

		
    answer_return_exp_index = -1;
    receive_answer_flag = 0;
    /* Hack to avoid sending %unify when a ReadHook receives answer_value. */
    return(allocp);
}



static long
encode_answer_value(data, buffer, index, wec)
q data;
combuf *buffer;
long index, wec;
{
	long wtc, send_wtc;
	
	INT_CL_PROBE_X(netstat.send_answer_cnt++);
	
	wtc = get_wtc(ANSWER_WTC_UNIT, get_wtc_normal_request);
	send_wtc = wtc;
#ifdef PFIRST
	encode_data(buffer, data, eager_transfer_level,0);
#else
	encode_data(buffer, data, eager_transfer_level);
#endif
	PUT4_BUFFER(buffer, decode_answer_value, send_wtc, index, wec);  
	return(wtc);
}

void
send_answer_value(data, node, index, wec)
long node;
q data;
long index, wec;
{
	combuf *buffer = NODE_TO_BUFFER(node);
	declare_globals;
	DD(fprintf(logfile,"%d:send_answer_value for node %d\n", my_node,node)); 
	INT_CL_DEBUG_X(fprintf(logfile,"%d:send_answer_value for node %d\n"
												 , my_node,node));
	INT_CL_DEBUG_X(fflush(logfile));
	
	if(!encode_answer_value(data, buffer, index, wec)){
		message_suspend(ANSWER_WTC_UNIT, node, buffer);
	} else {
		send_message(node, buffer);
	}
}

struct generator_object_method_table* get_exref_methtab();
#ifdef PACKSEND
struct generator_object_method_table* get_inexref_methtab();
struct generator_object_method_table* get_outexref_methtab();
#endif


/*struct exref_object{
  struct generator_object_method_table *method_table;
  long node;
  long index;
  long wec;
  q    to_exref;
  long gc_flag;
};*/

#include<klic/ge_exref.h>

static int transfer_read();

/*
  READ
  */

#ifdef PFIRST
#ifdef WDEBUG
extern char* sprint_data();
#endif

extern struct predicate predicate_unify__term__dcode_xunify__goal_2;
extern q* enqueue_unify();
extern int
change_prior_thread();

static q*
unify_rhook(allocp,rsusp,data)
	q* allocp;
	struct susprec *rsusp;
	q data;
{
	declare_globals;
#ifdef WDEBUG
	{
		char buf[1000],buf1[1000];
		char *bufp = buf;
		char *buf1p = buf1;
		bufp = sprint_data(rsusp->backpt,bufp);
		buf1p = sprint_data(data,buf1p);
		fprintf(logfile,"%d:rUnify with %s , %s\n",my_node,buf,buf1);
		fflush(logfile);
	}
#endif
	if(data == smask(derefone(data))){
		if(data != derefone(data)){
			struct request_record *newreq;
			makenewrequest(allocp,newreq,rsusp,rsusp->u.first_hook.u.o);
			if(!reply_first){
				struct threadrec *producer = srecp(data)->pthread;
#ifdef WDEBUG
				fprintf(logfile,"%d: first request %x (%x,%x) producer %x\n",my_node,
											newreq,newreq->reply_data,newreq->wait_thread,producer);
				fflush(logfile);
#endif
				current_request = newreq;
				newreq->next = producer->rtop;
				producer->rtop = newreq;
				(void)change_prior_thread(producer);
				reply_first = 1;
			}else{
				struct threadrec *producer = srecp(data)->pthread;
				rsusp->gthread = producer;
				/* now not fifo */
				newreq->next = request_queue_top;
				request_queue_top = newreq;

				/* debug print */
#ifdef WDEBUG
				fprintf(logfile,"%d:wait request %x (%x,%x)\n",my_node,
								newreq,newreq->reply_data,newreq->wait_thread);
				fflush(logfile);
#endif
				/*
					 newreq = newreq->next;
					 while(newreq != no_request){
					 fprintf(logfile,"-> %x (%x , %x)",
					 newreq,newreq->reply_data,newreq->wait_thread);
					 fflush(logfile);
					 newreq = newreq->next;
					 }
					 fprintf(logfile,"-> no_request\n");
					 fflush(logfile);
					 */
			}
			derefone(data) = rsusp->backpt;
			return(allocp);
		}else{
			derefone(data) = rsusp->backpt;
			return(allocp);
		}
	}else{
		/* susprec */
		struct susprec *susp = (struct susprec *)derefone(data);
#ifdef WDEBUG
		fprintf(logfile,"%d:unify reply_hook with susprec %x = %x\n",my_node,
						rsusp,susp);
		fflush(logfile);
#endif
		if(is_generator_susp(susp->u)){
			/* unify consumer with generator,
				 we tried generate method. */
			struct generator_object *gobj =
				untag_generator_susp(generator_suspp(susp)->u.o);
			q tmp;
			tmp = generic_generate(gobj,allocp);
#ifdef WDEBUG
			fprintf(logfile,"%d:genereate result in runify %x\n",my_node,tmp);
			fflush(logfile);
#endif
			switch((long)tmp){
			case (long)makeref(0):		/* GC request */
				allocp = enqueue_unify(susp->backpt,rsusp->backpt,
															 &predicate_unify__term__dcode_xunify__goal_2);
				break;
			case (long)makecons(0):
				fatal("illegal situation at the generator unification");
			default:
				allocp = heapp;
				derefone(susp->backpt) = tmp;
				if(isref(tmp) && tmp == derefone(tmp)){
					derefone(tmp) = rsusp->backpt;
					return allocp;
				}else{
					return do_unify(allocp,tmp,rsusp->backpt);
				}
			}
		}else{
			/* merge two hook */
			rsusp->u.first_hook.next = susp->u.first_hook.next;
			susp->u.first_hook.next = &rsusp->u.first_hook;
			return allocp;
		}
	}
}
#endif

static q*
decode_read(inbuf, allocp)
	combuf *inbuf;
	q *allocp;
{
	q data, rhook;
	long node, index, wec;
	declare_globals;
	long recved_wtc, trans_cnt;
	
	INT_CL_PROBE_X(netstat.recv_read_cnt++);

	/*  node_wtc = node_wtc + GET_BUFFER(inbuf);*/
	recved_wtc = GET_BUFFER(inbuf);

	data = (q)search_exptbl(GET_BUFFER(inbuf), 1L);
	trans_cnt = GET_BUFFER(inbuf);
	trans_cnt--;

	node  = GET_BUFFER(inbuf);
	index = GET_BUFFER(inbuf);
	wec   = GET_BUFFER(inbuf);

	INT_CL_DEBUG_X(fprintf(logfile,"%d:decode_read from node %d\n",
												 my_node,node));
		INT_CL_DEBUG_X(fflush(logfile));

	DD(fprintf(logfile,"%d:decode read from node %d\n",my_node,node));  

deref_and_switch(data, susp_label, atomic_label, cons_label, funct_label);
 susp_label:
#ifdef PFIRST
	if(smask(derefone(data)) != data)
#else
	if(derefone(data) != data)
#endif
		{
			struct susprec *term = (struct susprec *)(derefone(data));
			if(trans_cnt > 0) {
				struct susprec *term = (struct susprec *)(derefone(data));
				if(is_generator_susp(term->u)){
					struct generator_susp *susp1 = generator_suspp(derefone(data));
					struct exref_object *dummy_obj =
						(struct exref_object *)untag_generator_susp(susp1->u.o);	
					if(dummy_obj-> method_table == get_exref_methtab()){
						fprintf(logfile, "Node:%d exref read transfer\n", my_node);
						if(transfer_read(trans_cnt,recved_wtc,node,index,wec,dummy_obj))
							return(allocp);
					}else{
#ifdef SCHED
						print_data(data);
						fprintf(logfile,"term %x : term->u %x\n",term,term->u);
#endif
						fatal("Decode read invalid generator");
					}
				}
			}
		}
	/* Transferring %read message is not implemented yet */
	add_node_wtc(recved_wtc);
	generic_arg[0] = makeint(node);	/* Node Number */
	generic_arg[1] = makeint(index); /* exp_table (for answer) index */
	generic_arg[2] = makeint(wec); /* WEC */
	new_generic(reply_hook_g_new, 3, rhook, 0);

	DD(fprintf(logfile,"request data is unbound reply first %d\n",derefone(data)!=data)); 
#ifdef PFIRST
	if(rhook != derefone(rhook))
		allocp = unify_rhook(allocp ,(struct susprec*)derefone(rhook), data);
	else
		derefone(rhook) = data;
#else
	allocp = do_unify(allocp ,rhook, data);
#endif
	return(allocp);

 atomic_label:
 cons_label:
 funct_label:										/* data_obj$B$GAw$l$J$$$b$N$,$"$k;~$O!"$3$3$,JQ$o$k(B */
	DD(fprintf(logfile,"request data is already bound,\n"));
    
	{
		combuf *buffer = NODE_TO_BUFFER(node);
/*		INT_CL_DEBUG_X
			(fprintf(logfile,
							 "%d:send_reply_answer_value current_wtc=%d, retwtc = %d\n",
							 my_node, node_wtc, recved_wtc));
		INT_CL_DEBUG_X(fflush(logfile)); */
		
		INT_CL_PROBE_X(netstat.send_answer_cnt++);

#ifdef PFIRST
		encode_data(buffer, data, eager_transfer_level,0);
#else
		encode_data(buffer, data, eager_transfer_level);
#endif
		PUT4_BUFFER(buffer, decode_answer_value, recved_wtc, index, wec);  
		send_message_without_wtc_chk(node, buffer);
	}
	return(allocp);
}

static int
transfer_read(transc,recved_wtc,node,index,wec,exref)
long transc, recved_wtc, node, index, wec;
struct exref_object* exref;
{
    declare_globals;
    if(exref->wec > MIN_WEC){
	combuf *buffer = NODE_TO_BUFFER(exref->node);
	exref->wec--;
	PUT4_BUFFER(buffer, decode_read, recved_wtc, exref->index, transc);
	PUT3_BUFFER(buffer, node, index, (long)EXPORT_UNIT_WEC);
	send_message(exref->node, buffer);
	fprintf(logfile, "Node %d, read transfered to node %d\n", 
		my_node, exref->node);
		INT_CL_DEBUG_X(fflush(logfile));
	
	return(1);
    } else {
	fprintf(logfile, "Node %d, tried to read transfered but failed\n", my_node);
	return(0);
    }
}

static long
encode_read(buffer, index, var, exptbl_indexp, transc)
combuf *buffer;
long index;
q var;
long * exptbl_indexp;
long transc;
{
	declare_globals;
	int ret_index,wtc, send_wtc;
	INT_CL_PROBE_X(netstat.send_read_cnt++);
	
	wtc = get_wtc(READ_WTC_UNIT, get_wtc_normal_request);
	send_wtc = wtc;
	if (send_wtc == 0)
		send_wtc = READ_WTC_UNIT;
	PUT4_BUFFER(buffer, decode_read, send_wtc, index, transc);
	
	ret_index = regist_exptbl(var);
	PUT3_BUFFER(buffer, my_node, ret_index, (long)EXPORT_UNIT_WEC);
	
	*exptbl_indexp = ret_index;
	return(wtc);
}

long
send_read(node, index, var, transc)
long node;	/* Node No.	of Imported Data */
long index;	/* ExpTbl index of Imported Data */
q var;		/* To Readhook			 */
long transc;
{
	long exptbl_index;
	combuf *buffer = NODE_TO_BUFFER(node);
	declare_globals;
	INT_CL_DEBUG_X(fprintf(logfile,"%d:send_read for node %d\n", my_node,node));
		INT_CL_DEBUG_X(fflush(logfile));
	DD(fprintf(logfile,"%d:send_read for node %d\n", my_node,node));
	
	if(!encode_read(buffer, index, var, &exptbl_index, transc)){
		message_suspend(READ_WTC_UNIT, node, buffer);
	} else {
		send_message(node, buffer);
	}


	return exptbl_index;
}

#ifdef PACKSEND
extern q* pk_suspend_goal();
void send_read_all_forward();

static q*
decode_read_all(inbuf, allocp)
	combuf *inbuf;
	q *allocp;
{
	q data, rhook;
	long node, index, wec, wtc, message_wtc;
	declare_globals;
	long recved_wtc, recved_index, trans_cnt, goalnum;
	long init_rd_index;
	
	INT_CL_DEBUG_X(iosprintf("%d:decode_read_all\n", my_node));
	INT_CL_PROBE_X(netstat.recv_read_cnt++);

	init_rd_index = inbuf->rd_index;

	recved_wtc = GET_BUFFER(inbuf);
	recved_index = GET_BUFFER(inbuf);
	data = (q)search_exptbl(recved_index, 1L);
	trans_cnt = GET_BUFFER(inbuf);
	trans_cnt--;

	node = GET_BUFFER(inbuf);
	index = GET_BUFFER(inbuf);
	wec = GET_BUFFER(inbuf);
	goalnum = GET_BUFFER(inbuf);

	if(node != my_node){
	
		pack_switch(data, ref_label, gobj_label, bound_label);
	
	ref_label:
		add_node_wtc(recved_wtc);
		generic_arg[0] = makeint(node);
		generic_arg[1] = makeint(index);
		generic_arg[2] = makeint(wec);
		generic_arg[3] = makeint(goalnum);
		new_generic(reply_all_hook_g_new, 4, rhook, 0);
		allocp = (q*)do_unify(allocp, rhook, data);
		return(allocp);
		
	gobj_label:
		{
			if(node != my_node){
				struct susprec *sdata = (struct susprec *)derefone(data);
				if(is_generator_susp(sdata->u)){
					declare_globals;
					
					struct generator_susp *gsdata = generator_suspp(sdata);
					q backpt = gsdata->backpt;
					
					struct exref_object *exref = 
						(struct exref_object *)untag_generator_susp(gsdata->u.o);
					exp_table[recved_index].wec++;
					send_read_all_forward(trans_cnt,recved_wtc,node,index,wec,
																exref,goalnum);
					return(allocp);
				}else{
					goto ref_label;
				}
			}else{
				goto ref_label;
			}
		}
	bound_label:
		{
			struct goalrec *newgoal;
			q anshok;
			extern struct predicate *packsend_goal[];
			extern struct pk_flag *pk_flg;
			extern struct pk_flag *pk_flg_top;		
			extern struct pk_flag pk_flg_tail;
			extern int pending;
			
			if(!pending)
				add_node_wtc(recved_wtc);
			else 
				pending = 0;
			
			if(node != my_node){
				if(pk_buffer_unused()){
					struct pk_flag *new_pk_flg;
					q pk_buf;
					if(allocp + this_more_space + 14 >= real_heaplimit){
						INT_CL_DEBUG_X(iosprintf("%d:DECODE_PENDING \n",my_node));
						pending = 1;
						inbuf->rd_index = init_rd_index - 1;
						return (allocp+14);
					}
					
					generic_arg[0] = makeint(node);
					generic_arg[1] = makeint(index);
					generic_arg[2] = makeint(wec);
					new_generic(answerhook_g_new,3,anshok,0);
					
					new_pk_flg = (struct pk_flag*)allocp;
					new_pk_flg->next = &(pk_flg_tail);
					new_pk_flg->value = (q)&(new_pk_flg->value);
					
					allocp += 2;
					
					generic_arg[0] = anshok;
					generic_arg[1] = makeint(my_node);
					generic_arg[2] = (q)&(new_pk_flg->value);
					new_generic(packbuf_g_new, 3, pk_buf, 0);
					
					pk_flg = new_pk_flg;
					pk_flg_top = new_pk_flg;				
					
					newgoal = (struct goalrec *)allocp;
					newgoal->pred = (struct predicate *)packsend_goal[goalnum];
					newgoal->args[0] = (q)data;
					newgoal->args[1] = (q)pk_buf;
					
					allocp += 4;
					resume_same_prio(newgoal);
				}else{
					struct pk_flag *new_pk_flg;
					struct pk_flag *tmp_pk_flg;
					q pk_flg1;
					q pk_buf;
					
					if(allocp + this_more_space + 20 >= real_heaplimit){
						INT_CL_DEBUG_X(iosprintf("%d:DECODE_PENDING \n",my_node));
						pending = 1;
						inbuf->rd_index = init_rd_index - 1;
						return (allocp+20);
					}
					
					
					generic_arg[0] = makeint(node);
					generic_arg[1] = makeint(index);
					generic_arg[2] = makeint(wec);
					new_generic(answerhook_g_new,3,anshok,0);
					
					tmp_pk_flg = pk_flg;
					deref_pk_flg(tmp_pk_flg);
					new_pk_flg = (struct pk_flag *)allocp;
					tmp_pk_flg->next = new_pk_flg;
					new_pk_flg->next = &pk_flg_tail;
					new_pk_flg->value = (q)&(new_pk_flg->value);
					
					allocp += 2;
					
					generic_arg[0] = anshok;
					generic_arg[1] = makeint(my_node);
					generic_arg[2] = (q)&(new_pk_flg->value);
					new_generic(packbuf_g_new, 3, pk_buf, 0);
					
					pk_flg = new_pk_flg;

					newgoal = (struct goalrec *)allocp;
					newgoal->pred = (struct predicate *)packsend_goal[goalnum];
					newgoal->args[0] = (q)data;
					newgoal->args[1] = (q)pk_buf;
					
					allocp += 4;
					allocp = pk_suspend_goal(allocp, newgoal, pk_flg1);
					return(allocp);
				}
			}else{
				q my_data = (q)search_exptbl(index, wec);
				
				if(isref(my_data)){
					q temp0 = derefone(my_data);
					if(temp0 != my_data){
						if(isref(temp0)){
							q temp1 = derefone(temp0);
						deref_my_data:
							if(my_data == temp1){
								receive_answer_flag = 1;
								answer_return_exp_index = index;
								allocp = do_unify(allocp, my_data, data);
								answer_return_exp_index = -1;
								receive_answer_flag = 0;
								INT_CL_DEBUG_X(iosprintf("%d:receive answer\n",my_node));
							}else{
								my_data = temp0;
								temp0 = temp1;
								goto deref_my_data;
							}
						}else{
							fatal(" My_data is not ref1!");
						}
					}else{
						fatal("My_data is not bound!");
					}
				}else{
					fatal("My-data is not ref2!");
				}
			}
			return(allocp);
		}
	}else{
		q my_data = (q)search_exptbl(index,wec);
		add_node_wtc(recved_wtc);
		allocp = do_unify(allocp,my_data,data);
		return(allocp);
	}
}
	
void send_read_all_forward
(transc,recved_wtc,node,index,wec,exref,goalnum)
	long transc, recved_wtc, node, index, wec, goalnum;
	struct exref_object* exref;
{

	declare_globals;

	INT_CL_DEBUG_X(iosprintf
								 ("%d:send_read_all_forward for %d\n", my_node,exref->node));
	{
		combuf *buffer = NODE_TO_BUFFER(exref->node);
		PUT4_BUFFER(buffer, decode_read_all, recved_wtc,exref->index,transc);
		PUT4_BUFFER(buffer, node, index, (long)EXPORT_UNIT_WEC, goalnum);
		send_message(exref->node,buffer);
		INT_CL_DEBUG_X(fprintf(logfile, "Node %d, read_all_forward to node %d\n", 
												 my_node, exref->node));
		INT_CL_DEBUG_X(fflush(logfile));
	}
}	

static long
encode_read_all(buffer, index, var, goalnum, exptbl_indexp, transc)
	combuf *buffer;
	long index;
	q var;
	long goalnum;
	long *exptbl_indexp;
	long transc;
{
	declare_globals;
	int ret_index,wtc,send_wtc;

	INT_CL_PROBE_X(netstat.send_read_cnt++);

	wtc = get_wtc(READ_WTC_UNIT, get_wtc_normal_request);
	send_wtc = wtc;
	if(send_wtc == 0)
		send_wtc = READ_WTC_UNIT;
	PUT4_BUFFER(buffer, decode_read_all, send_wtc, index, transc);

	ret_index = regist_exptbl(var);
	
	PUT4_BUFFER(buffer,my_node,ret_index,
							(long)EXPORT_UNIT_WEC,goalnum);
	*exptbl_indexp = ret_index;

	return(wtc);
}

			
long send_read_all(node, index, var , goalnum, transc)
long node;
long index;
q var;
long goalnum;
long transc;
{
	declare_globals;
	long exptbl_index;
	combuf *buffer = NODE_TO_BUFFER(node);

	INT_CL_DEBUG_X(iosprintf("%d:send_read_all\n", my_node));
    
	if(!encode_read_all(buffer, index, var, 
											goalnum, &exptbl_index, transc)){
		message_suspend(READ_WTC_UNIT, node, buffer);
	}else{
		send_message(node, buffer);
	}
	return exptbl_index;
}

#endif


/*
  RELEASE
  */
static q*
decode_release(inbuf, allocp)
combuf *inbuf;
q *allocp;
{
    q exp_data;
    declare_globals;
    long exp_index, wec;
    
/* 		INT_CL_DEBUG_X(fprintf(logfile,"%d:decode_release\n", my_node)); */
    INT_CL_PROBE_X(netstat.recv_release_cnt++);
    
    exp_index = GET_BUFFER(inbuf);
    wec       = GET_BUFFER(inbuf);
    
    exp_data = (q)search_exptbl(exp_index, wec);
    return(allocp);
}
static void encode_release(buffer, index, wec)
	combuf *buffer;
	long index;
	long wec;
{
	INT_CL_PROBE_X(netstat.send_release_cnt++);
	
	PUT3_BUFFER(buffer, decode_release, index, wec);
}

void
send_release(node, index, wec)
	long node, index, wec;
{
	combuf *buffer = NODE_TO_BUFFER(node);
	INT_CL_DEBUG_X(declare_globals);
	INT_CL_DEBUG_X(fprintf(logfile,"%d:send_release\n", my_node));
	INT_CL_DEBUG_X(fflush(logfile));

	encode_release(buffer, index, wec);
	send_message_without_wtc_chk(node, buffer);
}

/*
  UNIFY
  */
#ifdef PACKSEND
q*
#else
static q*
#endif
decode_unify(inbuf, allocp)
combuf *inbuf;
q *allocp;
{
    q exp_data;
    long unify_index, unify_wec;
    module decoder;    
    declare_globals;

    INT_CL_PROBE_X(netstat.recv_unify_cnt++);
		INT_CL_DEBUG_X(fprintf(logfile,"%d:decode_unify\n",
													 my_node));
		INT_CL_DEBUG_X(fflush(logfile));

		DD(fprintf(logfile,"%d:decode_unify\n",
						my_node));
		
    /*  node_wtc = node_wtc + GET_BUFFER(inbuf);*/
    add_node_wtc(GET_BUFFER(inbuf));
   
    unify_index = GET_BUFFER(inbuf);
    unify_wec   = GET_BUFFER(inbuf);
    exp_data = (q)search_exptbl(unify_index, unify_wec);

		/*    decoder = (module)GET_BUFFER(inbuf);
    allocp = (q *)decoder(inbuf, allocp);*/
    decode_data = pop_decode_stack();
    allocp = do_unify(allocp, exp_data, decode_data);
    return(allocp);
}


static long
encode_unify(buffer, index, wec, data)
combuf *buffer;
q data;
long index, wec;
{
    long wtc, send_wtc;

    INT_CL_PROBE_X(netstat.send_unify_cnt++);

    wtc = get_wtc(UNIFY_WTC_UNIT, get_wtc_normal_request);
    send_wtc = wtc;
    if (send_wtc == 0)
      send_wtc = UNIFY_WTC_UNIT;
#ifdef PFIRST
    encode_data(buffer, data, eager_transfer_level,0);
#else
    encode_data(buffer, data, eager_transfer_level);
#endif
    PUT4_BUFFER(buffer, decode_unify, send_wtc, index, wec);
    
    return(wtc);
}

void
send_unify(node, index, wec, data)
long node,index, wec;
q data;
{
	combuf *buffer = NODE_TO_BUFFER(node);
	declare_globals;
	INT_CL_DEBUG_X(fprintf(logfile,"%d:send_unify for node %d\n",
												 my_node,node));
	DD(fprintf(logfile,"%d:send_unify for node %d\n",
				my_node,node));	
	INT_CL_DEBUG_X(fflush(logfile));
    
    if(!encode_unify(buffer, index, wec, data)){
	message_suspend(UNIFY_WTC_UNIT, node, buffer);
    } else {
	send_message(node, buffer);
    }
}

/*
  THROW GOAL
  */


#ifdef PACKSEND

static void
pkgoallist_search(my_pred,throw_pred,mode_tablep,goal_tablep)
	struct predicate *my_pred;
	struct predicate *throw_pred;
	int **mode_tablep;
	int **goal_tablep;
{
	extern THROW_GOAL_INFO throw_goal_info[];
	int i=0;
	while(!(throw_goal_info[i].throw_pred == NULL)){
		if(throw_pred == throw_goal_info[i].throw_pred
			 && my_pred == throw_goal_info[i].my_pred){
			*mode_tablep = throw_goal_info[i].mode_table;
			*goal_tablep = throw_goal_info[i].goal_table;
			break;
		}
		i++;
	}
}

static long
pk_encode_throw_goal(my_pred,throw_goal,buffer,allocpp)
	struct predicate *my_pred;
	struct goalrec *throw_goal;
	combuf *buffer;
	q **allocpp;
{
	int arity,i;
	long wtc,send_wtc;
	declare_globals;
	int *mode_table,*goal_table;

  INT_CL_PROBE_X(netstat.send_throw_cnt++);

	wtc = get_wtc(THROW_WTC_UNIT, get_wtc_normal_request);
	send_wtc = wtc;
	if(send_wtc==0)
		send_wtc = THROW_WTC_UNIT;

	arity = (int) (throw_goal->pred->arity);

		/****** make mode_table and goal_table ****/

	pkgoallist_search(my_pred,throw_goal->pred,&mode_table,&goal_table);
	*allocpp += (arity+2);

	for(i=0;i<arity;i++){
		pk_encode_data(buffer,throw_goal->args[i],mode_table[i],goal_table[i]);
	}
		
	PUT4_BUFFER(buffer,decode_throw_goal,send_wtc,(long)current_prio,throw_goal->pred);

	return(wtc);
}

extern struct goalrec* trace_goal();

struct goalrec *
pk_send_throw_goal(node, goal, oldqp, toppred, allocpp)
	long node;
	struct goalrec *goal;
	struct goalrec *oldqp;
	struct predicate *toppred;
	q **allocpp;
{
	declare_globals;
	extern int trace_flag;
	combuf *buffer;

  INT_CL_DEBUG_X(iosprintf("%d:send_throw_goal\n", my_node));
  if(node >= total_node){
    ioeprintf("Try to send node %d from node %d\n",node, my_node);
    fatal("send_throw_goal, invalid destination node");
  }    

  if(node == my_node){ /* prio of goal == prio of oldqp ?? */
    goal->next = oldqp;
    return(goal);
  } else {
    buffer = NODE_TO_BUFFER(node);
#ifdef DEBUGLIB
    if (trace_flag) {
      static long throw_trace_count = 0;
      goal = trace_goal(goal, (node+1)*100000+throw_trace_count);
      throw_trace_count++;
    }
#endif
		
		if(!pk_encode_throw_goal(toppred ,goal, buffer, allocpp)){
			message_suspend(THROW_WTC_UNIT, node, buffer);
		}else{
			send_message(node, buffer);
		}
		return(oldqp);
	}
}
#else
#ifdef SCHED
static q*
decode_throw_thread(inbuf, allocp)
     combuf *inbuf;
     q *allocp;
{
  declare_globals;
  struct threadrec *newthread;
	struct predicate *pred_of_goal;
  unsigned short int arity;
  int i;
  module decoder;
  long prio;
	q* stackp;
	
  INT_CL_PROBE_X(netstat.recv_throw_cnt++);

	DD(fprintf(logfile,"decode_throw_thread\n"));
  /*  node_wtc = node_wtc + GET_BUFFER(inbuf);*/
  add_node_wtc(GET_BUFFER(inbuf));
  prio = GET_BUFFER(inbuf);

  pred_of_goal = (struct predicate *)(GET_BUFFER(inbuf));
  arity = (unsigned short int)(pred_of_goal->arity);
	
	newthread = (struct threadrec *)allocp;
	newthread->stack = stq;
	stq = stq->next;
	if(stq == &stack_tail)
		expand_stack_area();
	
	INT_CL_DEBUG_X(fprintf(logfile,
												 "%d:decode_throw_thread %x\n",my_node,newthread));
	INT_CL_DEBUG_X(fflush(logfile));
	
#ifdef PFIRST
	newthread->rtop = no_request;
	newthread->rtail = (struct request_record *)0;
	newthread->prio = prio;
	allocp += 6;
#else
	allocp += 2;
#endif
	stackp = newthread->stack->top;
	
  for ( i=arity; i > 0 ; i--){
		*stackp++ = pop_decode_stack();
  }  
	
	*stackp++ = (q)pred_of_goal;
	newthread->stack->top = stackp;

	WDEB(print_throw_thread(newthread));
	
	if(prio == current_prio){
		resume_same_prio(newthread);
	}else{
		(void) enqueue_thread(0,prio,newthread,glbl);
	}
  return(allocp);
}



static long
encode_throw_thread(thread, buffer)
struct threadrec *thread;
combuf *buffer;
{
  int arity,i;
  long wtc;
  long send_wtc;
  declare_globals; 
	q send_data;
	q* stackp;
	struct predicate *pred;
	extern struct predicate stack_empty_pred;
	
  INT_CL_PROBE_X(netstat.send_throw_cnt++);

  wtc = get_wtc(THROW_WTC_UNIT, get_wtc_normal_request);
  send_wtc = wtc;

	if (send_wtc== 0)
    send_wtc = THROW_WTC_UNIT;

#ifdef PFIRST
	throwing_thread = thread;
#endif
	stackp = thread->stack->top;
	pred = (struct predicate *)*--stackp;
	arity = pred->arity;
	for(i=0;i<arity;i++){
		send_data = (q)*--stackp;
#ifdef PFIRST
		encode_data(buffer, send_data, eager_transfer_level,1);
#else
		encode_data(buffer, send_data, eager_transfer_level);
#endif		
	}
	PUT4_BUFFER(buffer, decode_throw_thread, send_wtc, (long)current_prio,pred);
  return(wtc);
}


struct threadrec *
send_throw_thread(node, thread, oldqp, allocp)
long node;
struct threadrec *thread;
struct threadrec *oldqp;
q* allocp;
{
  declare_globals;
  extern int trace_flag;
  combuf *buffer;
	
	INT_CL_DEBUG_X(fprintf(logfile,"%d:send_throw_goal for node %d\n",
												 my_node,node));
	INT_CL_DEBUG_X(print_throw_thread(thread));
	INT_CL_DEBUG_X(fflush(logfile));
  if(node >= total_node){
    ioeprintf("Try to send node %d from node %d\n",node, my_node);
    fatal("send_throw_goal, invalid destination node");
  }    

  if(node == my_node){ /* prio of goal == prio of oldqp ?? */
    thread->next = oldqp;
#ifdef PFIRST
		thread->before = oldqp->before;
		oldqp->before = thread;
#endif		
    return(thread);
  } else {
    buffer = NODE_TO_BUFFER(node);
#ifdef DEBUGLIB
    if (trace_flag) {
      static long throw_trace_count = 0;
      thread = trace_thread(thread, (node+1)*100000+throw_trace_count);
      throw_trace_count++;
    }
#endif

    if(!encode_throw_thread(thread, buffer, allocp)){
      message_suspend(THROW_WTC_UNIT, node, buffer);
    } else {
      send_message(node, buffer);
    }
#ifdef PFIRST
		thread->next = (struct threadrec *)1;
#endif
    return(oldqp);
  }
}
#else
static q*
decode_throw_goal(inbuf, allocp)
     combuf *inbuf;
     q *allocp;
{
  declare_globals;
  struct goalrec *newgoal;
  struct predicate *pred_of_goal;
  unsigned short int arity;
  int i;
  module decoder;
  long prio;

  INT_CL_DEBUG_X(iosprintf("%d:decode_throw_goal\n", my_node));
  INT_CL_PROBE_X(netstat.recv_throw_cnt++);

  /*  node_wtc = node_wtc + GET_BUFFER(inbuf);*/
  add_node_wtc(GET_BUFFER(inbuf));
  prio = GET_BUFFER(inbuf);

  pred_of_goal = (struct predicate *)(GET_BUFFER(inbuf));
  arity = (unsigned short int)(pred_of_goal->arity); 
  newgoal = (struct goalrec *)allocp;
  allocp = allocp+arity+2;
/*  if(allocp >= real_heaplimit){
    fatal("Bad estimation of decodeing, heap exausted");
  }*/

  newgoal->pred = pred_of_goal;

  for ( i=arity; i > 0 ; i--){
    newgoal->args[i-1] = pop_decode_stack();
  }  

  if(prio == current_prio){
    resume_same_prio(newgoal); 
  } else {
    (void) enqueue_goal(0, prio, newgoal, glbl);    
  }
  return(allocp);
}

static long
encode_throw_goal(goal, buffer)
struct goalrec *goal;
combuf *buffer;
{
  int arity,i;
  long wtc;
  long send_wtc;
  declare_globals;

  INT_CL_PROBE_X(netstat.send_throw_cnt++);

  wtc = get_wtc(THROW_WTC_UNIT, get_wtc_normal_request);
  send_wtc = wtc;
  if (send_wtc== 0)
    send_wtc = THROW_WTC_UNIT;

  arity = (int) (goal->pred->arity);
  for(i=0;i<arity;i++){
      encode_data(buffer, goal->args[i], eager_transfer_level);
  }

  PUT4_BUFFER(buffer, decode_throw_goal, send_wtc, (long)current_prio,
	      goal->pred);
  return(wtc);
}

struct goalrec *
send_throw_goal(node, goal, oldqp)
long node;
struct goalrec *goal;
struct goalrec *oldqp;
{
  declare_globals;
  extern int trace_flag;
  combuf *buffer;

  INT_CL_DEBUG_X(iosprintf("%d:send_throw_goal\n", my_node));
  if(node >= total_node){
    ioeprintf("Try to send node %d from node %d\n",node, my_node);
    fatal("send_throw_goal, invalid destination node");
  }    

  if(node == my_node){ /* prio of goal == prio of oldqp ?? */
    goal->next = oldqp;
    return(goal);
  } else {
    buffer = NODE_TO_BUFFER(node);
#ifdef DEBUGLIB
    if (trace_flag) {
      static long throw_trace_count = 0;
      goal = trace_goal(goal, (node+1)*100000+throw_trace_count);
      throw_trace_count++;
    }
#endif
    if(!encode_throw_goal(goal, buffer)){
      message_suspend(THROW_WTC_UNIT, node, buffer);
    } else {
      send_message(node, buffer);
    }
    return(oldqp);
  }
}
#endif
#endif

/*
  TERMINATE MSG decoding/encoding
  */

static char *
put_network_statistics(io_buf)
char *io_buf;
{
  declare_globals;
  char *ptr = io_buf;
  sprintf(ptr,"NODE %d Net Stat:\n", my_node);
  ptr += strlen(ptr);
  if (IS_SHOEN_NODE(my_node)) {
    sprintf(ptr, " rcv_req_wtc %d, snd_sup_wtc %d, rcv_ret_wtc %d\n",
	    netstat.recv_request_wtc_cnt, netstat.send_supply_wtc_cnt,
	    netstat.recv_return_wtc_cnt);
    ptr += strlen(ptr);
  } else {
    sprintf(ptr,
	    " snd_thrw %d, snd_read %d, snd_ufy %d, snd_ans %d, snd_rel %d\n",
	    netstat.send_throw_cnt, netstat.send_read_cnt,
	    netstat.send_unify_cnt, netstat.send_answer_cnt,
	    netstat.send_release_cnt);
    ptr += strlen(ptr);
    sprintf(ptr,
	    " rcv_thrw %d, rcv_read %d, rcv_ufy %d, rcv_ans %d, rcv_rel %d\n",
	    netstat.recv_throw_cnt,
	    netstat.recv_read_cnt, netstat.recv_unify_cnt,
	    netstat.recv_answer_cnt, netstat.recv_release_cnt);
    ptr += strlen(ptr);
    sprintf(ptr, " snd_req_wtc %d, rcv_sup_wtc %d, snd_ret_wtc %d\n",
	    netstat.send_request_wtc_cnt, netstat.recv_supply_wtc_cnt,
	    netstat.send_return_wtc_cnt);
    ptr += strlen(ptr);
    sprintf(ptr, " msg_susp %d, msg_resu %d\n",
	    netstat.msg_suspend_cnt, netstat.msg_resume_cnt);
    ptr += strlen(ptr);
  }
  sprintf(ptr, " total_msg %d, total_send_bytes %d, total_recv_bytes %d\n\n",
	  netstat.send_throw_cnt + netstat.recv_throw_cnt
	  + netstat.send_read_cnt + netstat.recv_read_cnt
	  + netstat.send_unify_cnt + netstat.recv_unify_cnt
	  + netstat.send_answer_cnt + netstat.recv_answer_cnt
	  + netstat.send_release_cnt + netstat.recv_release_cnt
	  + netstat.send_request_wtc_cnt + netstat.recv_request_wtc_cnt
	  + netstat.send_supply_wtc_cnt + netstat.recv_supply_wtc_cnt
	  + netstat.send_return_wtc_cnt + netstat.recv_return_wtc_cnt,
	  netstat.send_data_siz, netstat.recv_data_siz);
  ptr += strlen(ptr);
  return ptr;
}

#ifdef REDUCTION_CNT
extern long reduction_cnt;
extern long garbage_collection_cnt;
#endif

static char *
put_node_statistics(io_buf)
char *io_buf;
{
  declare_globals;
  long utime, stime;
  extern timerstruct before_exec, after_exec;

  measure(after_exec);
#define  field_diff_dist(field) (after_exec.field - before_exec.field)

#ifdef GETRUSAGE
#define  diff_usec_dist(field)\
  (field_diff_dist(field.tv_sec) * 1000000 + field_diff_dist(field.tv_usec))
  utime = (long)(diff_usec_dist(ru_utime)/1000);
  stime = (long)(diff_usec_dist(ru_stime)/1000);

#else /* !GETRUSAGE */
  utime = ((long)tick2msec(field_diff_dist(tms_utime)));
  stime = ((long)tick2msec(field_diff_dist(tms_stime)));

#endif/* !GETRUSAGE */

  {
      char *ptr = io_buf;
      sprintf(ptr, "Node %ld Local Stat:\n", my_node);
      ptr += strlen(ptr);
  
      if (!IS_SHOEN_NODE(my_node)) {
	  sprintf(ptr, " heap size = %d words\n", heapsize);
	  ptr += strlen(ptr);
      }
      sprintf(ptr, " %ld ms total; %ld user; %ld system\n",
	      utime + stime, utime, stime);
      ptr += strlen(ptr);
      if (!IS_SHOEN_NODE(my_node)) {
	  if (measure_gc) {
	      sprintf(ptr, " %ld ms utime & %ld ms stime in ",
		      gcums, gcsms);
	      ptr += strlen(ptr);
	  }
	  sprintf(ptr, " %ld GC %ld suspensions; %ld resumptions\n",
		  gctimes, suspensions, resumes);
	  ptr += strlen(ptr);
#ifdef REDUCTION_CNT
			sprintf(ptr, " %ld reductions; %ld gargage_collections\n",
							reduction_cnt,garbage_collection_cnt);
			ptr += strlen(ptr);
#endif
      }
      return ptr;
  }
}

static void
print_statistics()
{
    char charbuf[4096];
    char *ptr = charbuf;
    ptr = put_node_statistics(ptr);
#ifdef MACDEP_DIST_STATISTICS
    MACDEP_DIST_STATISTICS();
#endif
    ptr = put_network_statistics(ptr);
    iosprintf("%s", charbuf);
}

static q*
decode_terminate_msg(inbuf, allocp)
combuf *inbuf;
q *allocp;
{
    extern jmp_buf klic_topmost;
  if (network_statistics_flag)
    print_statistics();
  longjmp(klic_topmost, 1);
#if 0
  CloseIO();
  Close_net();
				/* usually all reduction nodes finish their
				   task here. */
  exit(0);
#endif
}

static void
encode_terminate_msg(buffer)
combuf *buffer;
{
    PUT_BUFFER(buffer, decode_terminate_msg);
}

static void
send_terminate_msg(node)
long node;
{
  combuf *buffer = NODE_TO_BUFFER(node);
	INT_CL_DEBUG_X(declare_globals);
  INT_CL_DEBUG_X(fprintf(logfile,"%d:send_terminate\n", my_node));
	INT_CL_DEBUG_X(fflush(logfile));

  encode_terminate_msg(buffer);
  send_message_without_wtc_chk(node, buffer);
}

/*
  Currently terminate_all_node() is called from topsucceed() on shoen node,
  therefore, this message is not delivered to the shoen.
  The child nodes should not call this function.
  */
void
terminate_all_node()
{
    declare_globals;
    long node;
    for (node = 0; node < total_node; ++node)
      send_terminate_msg(node);
    if (network_statistics_flag)
      print_statistics();
    if (rmonnode)
      terminate_profiling();
}
