/* ----------------------------------------------------------
%        Copyright (C) 1996-1997 Kazuhiko Ohno, Masahiko Ikawa,
%        and Computer Architecture Laboratory, Depertment of
%        Information Science, Kyoto University.
%----------------------------------------------------------- */  

/* ---------------------------------------------------------- 
%   (C)1993,1995 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */

#define INIT
#include <klic/basic.h>
#include <klic/struct.h>
#include <klic/primitives.h>

#define DEBUGSCHED

#ifdef SCHED
#include <klic/sched.h>
#endif

extern char *malloc(), *realloc();

char *malloc_check(size)
     unsigned long size;
{
  char *res = malloc(size);
  if (res == 0) {
    fatalf("No more memory available from Unix\nMalloc failed for %d bytes",
	   size);
  }
  return res;
}

char *realloc_check(original, newsize)
     char *original;
     unsigned long newsize;
{
  char *res = realloc(original, newsize);
  if (res == 0) {
    fatalf("No more memory available from Unix\nRealloc failed for %d bytes",
	   newsize);
  }
  return res;
}


#ifdef SCHED
struct stackrec topsucceed_stack;

void reinit_alloc()
{
  declare_globals;
	int i;
	
	/* Heap Area initiation */
  heaplimit = real_heaplimit = new_space_top+heapsize;
  heapbottom = real_heaplimit+incrementsize;
  heaptop = heapp = new_space_top;
  real_heapbytesize = (unsigned long)heaptop - (unsigned long)heapbottom;
  this_more_space = 0;
  gc_hooktab_size = 32;
  num_gc_hooks = 0;
  gc_hook_table = (q*(**)())malloc_check(gc_hooktab_size*sizeof(q*(**)()));
  after_gc_hooktab_size = 32;
  num_after_gc_hooks = 0;
  after_gc_hook_table =
    (q*(**)())malloc_check(gc_hooktab_size*sizeof(q*(**)()));

}

extern module queue_empty();
extern module stack_empty();

struct stackrec stack_tail;

extern struct predicate queue_empty_pred;
extern struct predicate stack_empty_pred;
extern struct predicate stack_change_pred;

#include <klic/susprec.h>	

void
reinit_alloc_for_threading()
{
	declare_globals;
	int i;
	unsigned long stackbytesize;
	struct stackrec *stack;
	q* stackarea;


	/* initialize stack record */
	
	if(stacksize != 0 && number_of_stack != 0) {
		stackbytesize = stacksize * sizeof(q);
	}else{
    fatalf
			("Illegal memory size specification: stack = %d, number_of_stack = %d",
			 stacksize, number_of_stack);
	}	
	
	stack_tail.next = 0;
	stack_tail.bottom = stack_tail.top = (q *)malloc_check(3*sizeof(q));
	stack_tail.limit  = stack_tail.bottom + 3;
	stack_tail.change_num = 0;
	*(stack_tail.top++) = (q)&queue_empty_pred;
	
	stack =
		(struct stackrec*)calloc((number_of_stack),sizeof(struct stackrec));
	stackarea = (q*)malloc_check((number_of_stack) * stackbytesize);
	for(i=0;i<number_of_stack-1;i++){
		stack[i].next = &stack[i+1];
		stack[i].bottom = stack[i].top = stackarea;
		stack[i].limit = ((stackarea += stacksize)-1);
		stack[i].change_num = 0;
		*(stack[i].top)++ = (q)&stack_empty_pred;
	}
	stack[number_of_stack-1].next = &stack_tail;
	stack[number_of_stack-1].bottom = stack[number_of_stack-1].top = stackarea;
	stack[number_of_stack-1].limit = ((stackarea += stacksize)-1);
	stack[number_of_stack-1].change_num = 0;
	*(stack[number_of_stack-1].top)++ = (q)&stack_empty_pred;
	
	stq = stack;

	/* make stack for topsucceed_thread */
	topsucceed_stack.next = 0;
	topsucceed_stack.bottom = topsucceed_stack.top =
		(q *)malloc_check(stackbytesize);
	topsucceed_stack.limit = stack[i].bottom + stacksize;
	topsucceed_stack.change_num = 0;
	*(topsucceed_stack.top)++ = (q)&stack_empty_pred;

	/* initiate generic suspend stack */
	gs_stack.stp = (q *)malloc_check(GS_STACKSIZE);
	gs_stack.flag = 0;
	gs_stack.var = 0;

}


void initalloc()
{
  declare_globals;
  unsigned long bytesize;
	
  if(heapsize != 0  && incrementsize != 0) {
    bytesize = (heapsize + incrementsize)*sizeof(q);
  } else {
    fatalf("Illegal memory size specification: heap = %d, incremental = %d",
	    heapsize, incrementsize);
  }

  old_space_size = new_space_size = bytesize;
  new_space_top = (q *)malloc_check(bytesize);
  old_space_top = (q *)malloc_check(bytesize);

#ifdef SCHED
	reinit_alloc_for_threading(); /* initiate stackarea */
#endif
  reinit_alloc();
}

void
expand_stack_area()
{
	declare_globals;
	int i;
	unsigned long stackbytesize;
	struct stackrec *stack;
	struct scheduling_record *schedrec;
	q* newstackarea;
#ifdef DEBUGSCHED
	printf("expand stack area\n");
#endif

	/* reinitiate stack record */
	stackbytesize = stacksize * sizeof(q);
	stack =
		(struct stackrec*)calloc(EXPAND_STACK_NUM,sizeof(struct stackrec));
	newstackarea = (q*)malloc_check(EXPAND_STACK_NUM*stackbytesize);
	for(i=0;i<EXPAND_STACK_NUM-1;i++){
		stack[i].next = &stack[i+1];
		stack[i].bottom = stack[i].top = newstackarea;
		stack[i].limit = ((newstackarea += stacksize)-1);
		stack[i].change_num = 0;
		*(stack[i].top)++ = (q)&stack_empty_pred;
	}
	stack[EXPAND_STACK_NUM-1].next = &stack_tail;
	stack[EXPAND_STACK_NUM-1].bottom = stack[EXPAND_STACK_NUM-1].top =
		newstackarea;
	stack[EXPAND_STACK_NUM-1].limit = ((newstackarea += stacksize)-1);
	stack[EXPAND_STACK_NUM-1].change_num = 0;
	*(stack[EXPAND_STACK_NUM-1].top)++ = (q)&stack_empty_pred;
	
	stq = stack;
}

q*
expand_stack(thread,stackp,put_num)
	struct threadrec *thread;
	q* stackp;
	long put_num;
{
	declare_globals;
	q* ret;
	struct stackrec *newstack;
	puts("expand_stack");
	thread->stack->top = stackp;

	if(put_num >= stacksize){
		long newsize;
		do{
			newsize = stacksize*2;
		}while(newsize >= stacksize);
		newstack = (struct stackrec *)malloc(sizeof(struct stackrec));
		stackp = newstack->bottom = newstack->top
			= (q *)malloc(sizeof(q)*newsize);
		newstack->limit = newstack->bottom + newsize;
		newstack->next = 0;
	}else{
		newstack = stq;
		stq = stq->next;
		if(stq == &stack_tail)
			expand_stack_area();
		stackp = newstack->top;
	}
	*stackp++ = (q)thread->stack;
	*stackp++ = (q)&stack_change_pred;
	newstack->top = stackp;
	thread->stack = newstack;

/*	print_stack_queue(newstack,thread); */
	
	return stackp;
}

#else
void reinit_alloc()
{
  declare_globals;
  heaplimit = real_heaplimit = new_space_top+heapsize;
  heapbottom = real_heaplimit+incrementsize;
  heaptop = heapp = new_space_top;
  real_heapbytesize = (unsigned long)heaptop - (unsigned long)heapbottom;
  this_more_space = 0;
  gc_hooktab_size = 32;
  num_gc_hooks = 0;
  gc_hook_table = (q*(**)())malloc_check(gc_hooktab_size*sizeof(q*(**)()));
  after_gc_hooktab_size = 32;
  num_after_gc_hooks = 0;
  after_gc_hook_table =
    (q*(**)())malloc_check(gc_hooktab_size*sizeof(q*(**)()));
}

void initalloc()
{
  declare_globals;
  unsigned long bytesize;

  if(heapsize != 0  && incrementsize != 0) {
    bytesize = (heapsize + incrementsize)*sizeof(q);
  } else {
    fatalf("Illegal memory size specification: heap = %d, incremental = %d",
	    heapsize, incrementsize);
  }

  old_space_size = new_space_size = bytesize;
  new_space_top = (q *)malloc_check(bytesize);
  old_space_top = (q *)malloc_check(bytesize);
  reinit_alloc();
}
#endif

void register_gc_hook(routine)
     q*(*routine)();
{
  declare_globals;
  if (num_gc_hooks >= gc_hooktab_size) {
    gc_hooktab_size *= 2;
    gc_hook_table = (q*(**)())
      realloc_check(gc_hook_table,
		    gc_hooktab_size*sizeof(q*(**)()));
  }
  gc_hook_table[num_gc_hooks++] = routine;
}

void register_after_gc_hook(routine)
     q*(*routine)();
{
  declare_globals;
  if (num_after_gc_hooks >= after_gc_hooktab_size) {
    after_gc_hooktab_size *= 2;
    after_gc_hook_table = (q*(**)())
      realloc_check(after_gc_hook_table,
		    after_gc_hooktab_size*sizeof(q*(**)()));
  }
  after_gc_hook_table[num_after_gc_hooks++] = routine;
}

