/* ----------------------------------------------------------
%        Copyright (C) 1996-1997 Kazuhiko Ohno, Masahiko Ikawa,
%        and Computer Architecture Laboratory, Depertment of
%        Information Science, Kyoto University.
%----------------------------------------------------------- */  

#ifdef PFIRST
#define special_thread prior_thread
#define put_sobj_for_new_thread(tp,reg,offset1,offset2) \
{ \
		allocp[offset1] = (q)tag_scheduling_record(&allocp[offset1]); \
		allocp[offset2] = (q)tp; \
		*(new_thread->stack->top)++ = reg = makeref(&allocp[offset1]); \
}

#define make_newvar_with_mode_for_struct(reg,offset1,offset2,offset3) \
{ \
		allocp[offset1] = reg = makeref(&allocp[offset2]); \
		allocp[offset2] = (q)tag_scheduling_record(&allocp[offset2]); \
		allocp[offset3] = (q)qp; \
}

#define make_newvar_with_mode(reg,offset1,offset2) \
{ \
		allocp[offset1] = (q)tag_scheduling_record(&allocp[offset1]); \
		allocp[offset2] = (q)qp; \
		reg = makeref(&allocp[offset1]); \
}

#define load_newvar_with_mode(reg,offset1,offset2) \
   make_newvar_with_mode(reg,offset1,offset2);

#define push_sobj(reg,offset1,offset2,offset3) \
    allocp[offset1] = (q)tag_scheduling_record(&allocp[offset1]); \
		allocp[offset2] = (q)qp; \
		stackp[offset3] = reg = makeref(&allocp[offset1]); 

#define make_scheduling_record(reg,offset1,offset2,thread) \
    allocp[offset1] = (q)tag_scheduling_record(&allocp[offset1]); \
		allocp[offset2] = (q)thread; \
		reg = makeref(&allocp[offset1]); 

#define reset_sobj(reg) \
	q tmp = derefone(reg); \
	if(check_srec(tmp)){ \
		struct scheduling_record *srec = srecp(reg); \
		srec->pthread = new_thread; \
	} \
 *(new_thread->stack->top)++ = (q)reg; 

#else
#define special_thread resumed_threads
#define put_sobj_for_new_thread(tp,reg,offset1,offset2) \
{ \
	*(new_thread->stack->top)++ = allocp[offset2] = reg = makeref(&allocp[offset2]); \
}

#define make_newvar_with_mode_for_struct(reg,offset1,offset2,offset3) \
{ \
		allocp[offset1] = reg = makeref(&allocp[offset1]); \
}

#define make_newvar_with_mode(reg,offset1,offset2) \
{ \
		allocp[offset1] = reg = makeref(&allocp[offset1]); \
}

#define load_newvar_with_mode(reg,offset1,offset2) \
   make_newvar_with_mode(reg,offset1,offset2);

#define push_sobj(reg,offset1,offset2,offset3) \
		stackp[offset3] = allocp[offset2] = reg = makeref(&allocp[offset2]); 

#define make_scheduling_record(reg,offset1,offset2,thread) \
		allocp[offset2] = reg = makeref(&allocp[offset2]); 


#define reset_sobj(reg) \
{ \
	*(new_thread->stack->top)++ = reg; \
}
#endif
