/* ----------------------------------------------------------
%        Copyright (C) 1996-1997 Kazuhiko Ohno, Masahiko Ikawa,
%        and Computer Architecture Laboratory, Depertment of
%        Information Science, Kyoto University.
%----------------------------------------------------------- */  

#include <klic/pfirst.h>
#include <klic/sobj.h>
#define STACKSIZE 100
#define STACKNUM  10
#define GS_STACKSIZE 1000
#define EXPAND_STACK_NUM 10
#define INTERVAL_OF_STACK_COPY 10
#define THREAD_SIZE 6

extern q* scheduling_g_new();
extern q* expand_stack();
#ifndef INIT
extern struct stackrec stack_tail;
/* extern struct scheduling_record schedrec_tail;*/
#endif

#define get_stack(thread) \
{ \
	thread->stack = stq; \
	stq = stq->next; \
	if(stq == &stack_tail) \
		expand_stack_area(); \
}

#ifdef PFIRST

#define makenewthread(thread,offset) \
{ \
	thread = (struct threadrec *)&allocp[offset]; \
	thread->stack = stq; \
	thread->prio = current_prio; \
  thread->rtop = thread->rtail = no_request; \
	stq = stq->next; \
	if(stq == &stack_tail) \
		expand_stack_area(); \
}

#define initialize_threadrec(thread,offset) \
{ \
	thread = (struct threadrec *)&allocp[offset]; \
	thread->stack = stq; \
	thread->prio = current_prio; \
  thread->rtop = thread->rtail = no_request; \
	stq = stq->next; \
	if(stq == &stack_tail) \
		expand_stack_area(); \
}

#define enqueue_newthread(thread,qp) \
{ \
	thread->next = qp->next; \
	qp->next->before = thread; \
	qp->next = thread; \
	thread->before = qp; \
}

#else
#define makenewthread(thread,offset) \
{ \
	thread = (struct threadrec *)&allocp[offset]; \
	thread->stack = stq; \
	stq = stq->next; \
	if(stq == &stack_tail) \
		expand_stack_area(); \
}

#define initialize_threadrec(thread,offset) \
{ \
	thread = (struct threadrec *)&allocp[offset]; \
	thread->stack = stq; \
	stq = stq->next; \
	if(stq == &stack_tail) \
		expand_stack_area(); \
}

#define enqueue_newthread(thread,qp) \
{ \
	thread->next = qp->next; \
	qp->next = thread; \
}

#endif


#define check_stack(put_num) \
{ \
	if((stackp + put_num) >= qp->stack->limit){ \
		 stackp = expand_stack(qp,stackp,put_num); \
	} \
}

#define change_stack_table() \
{ \
	stack[next_stack] = (q*)STACK_USED; \
	while(stack[next_stack] == (q*)STACK_USED) \
		next_stack = (++next_stack) % number_of_stack; \
}

#define push_gs_stack() \
{ \
	int i,j,max,arity; \
	struct predicate *pred; \
	max = gs_stack.flag; \
	for(j=0;j<max;j++){ \
		pred = (struct predicate *)*--(gs_stack.stp); \
		arity = pred->arity; \
		check_stack(arity+1); \
		for(i=0;i<arity;i++) \
			*stackp++ = *--(gs_stack.stp); \
		*stackp++ = (q)pred; \
		gs_stack.flag--; \
	} \
	reasonp = reasons; \
  *reasonp++ = gs_stack.var; \
	if (interrupt_off) heaplimit = real_heaplimit; \
}
