/* ----------------------------------------------------------
%        Copyright (C) 1996-1997 Kazuhiko Ohno, Masahiko Ikawa,
%        and Computer Architecture Laboratory, Depertment of
%        Information Science, Kyoto University.
%----------------------------------------------------------- */  

extern struct predicate stack_empty_pred;

#define print_qp(qp) \
{ \
	printf("qp -> "); \
	{ \
		extern struct threadrec thread_queue_tail; \
		struct threadrec *tmp = qp; \
		while(tmp != &thread_queue_tail){ \
			printf("%x -> ",tmp); \
			tmp = tmp->next; \
		} \
		printf("thread_queue_tail\n"); \
	} \
}

#define print_queue(qp) \
{ \
	printf("qp::\n"); \
	{ \
		extern struct threadrec thread_queue_tail;  \
		struct threadrec *tmp = qp; \
		while(tmp != &thread_queue_tail){  \
			int i = 0; \
			print_thread(tmp,i); \
			tmp = tmp->next; \
			i++; \
		} \
		printf("thread_queue_tail\n"); \
	} \
}
		
#define print_thread(thread,n) \
{ \
		printf("=== thread %x sobj %x ====\n",thread,((struct scheduling_object *)((long)(*(thread->sobj))->u.o-1))); \
	{ \
		int i,arity; \
		struct predicate *pred; \
		q* stackp = thread->stack->top; \
		do{ \
					puts(""); \
			pred = *--stackp; \
			arity = pred->arity; \
			printf("predicate %x : arity %d\n",pred,arity); \
			for (i=0;i<arity;i++){ \
				q arg; \
				printf("arg[%d]:",i); \
				arg = *--stackp; \
				if(isref(arg)){ \
				 q temp = derefone(arg); \
				deref_print_##n##: \
					if (arg != temp){ \
						if(isref(temp)) { \
							q temp1 = derefone(temp); \
							if(temp1 == arg) { \
								printf(" %x -> %x ->",arg,temp); \
								printf("%x(susprec)\n",temp1); \
							}else{ \
								printf(" %x ->",arg); \
								arg = temp; \
								temp = temp1; \
								goto deref_print_##n##; \
							} \
						}else{ \
							printf(" %x -> Real %x\n",arg,temp); \
						} \
					}else{ \
						printf(" %x:REF\n",arg); \
					} \
				}else{ \
					printf(" %x:Realobj\n",arg); \
				} \
			} \
		}while((pred = *--stackp) != &stack_empty_pred); \
	} \
}
			
		
		
