/* ----------------------------------------------------------
%        Copyright (C) 1996-1997 Kazuhiko Ohno, Masahiko Ikawa,
%        and Computer Architecture Laboratory, Depertment of
%        Information Science, Kyoto University.
%----------------------------------------------------------- */  

/* ---------------------------------------------------------- 
%   (C)1993 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */

#ifdef PFIRST
#define deref_and_switch(x, susp, atomic, cons, funct)	\
{ \
  while (1) { \
    if (!isstruct(x)) { \
      if (atomicnotref(x)) { \
				goto atomic; \
      } else { \
				q temp0 = smask(derefone(x)); \
				if(isref(temp0) && smask(derefone(temp0)) == x){ \
						goto susp; \
				} \
				(x) = temp0; \
      } \
    } else { \
      if(functnotcons(x)) \
				goto funct; \
      else goto cons; \
    } \
  } \
}
#else
#define deref_and_switch(x, susp, atomic, cons, funct)	\
{ \
  while (1) { \
    if (!isstruct(x)) { \
      if (atomicnotref(x)) { \
	goto atomic; \
      } else { \
	q temp0 = derefone(x); \
	if(isref(temp0) && (x) == derefone(temp0)) { \
	  goto susp; \
	} else { \
	  (x) = temp0; \
	} \
      } \
    } else { \
      if(functnotcons(x)) \
	goto funct; \
      else goto cons; \
    } \
  } \
}
#endif


#define deref_and_test(x, susp) \
{ \
  q temp0 = derefone(x); \
  if(!isref(temp0) || (x) != derefone(temp0)) { \
    (x) = temp0; \
  } else { \
    *reasonp++ = (x); \
    goto susp; \
  } \
}

#ifdef SCHED
#ifdef PFIRST
#define deref_and_jump_of_lvalue(x,loop) \
{ \
	q before; \
	q temp0 = smask(derefone(x)); \
	while(1){ \
		if(!isref(temp0)){ \
			(x) = derefone(x); \
			goto loop; \
		}else if((x) == temp0 ||(x) == derefone(temp0)){ \
			 break; \
  	}else{ \
			 (x) = temp0; \
			  temp0 = smask(derefone(temp0)); \
	 } \
	} \
}
#else
#define deref_and_jump_of_lvalue(x,loop) \
{ \
	q before; \
	q temp0 = derefone(x); \
	while(1){ \
		if(!isref(temp0)){ \
			(x) = temp0; \
			goto loop; \
		}else if((x) == temp0 || derefone(temp0) == (x)){ \
				break; \
  	}else{ \
			(x) = temp0; \
			temp0 = derefone(temp0); \
	   } \
	} \
}
#endif
#endif

#define deref_and_jump(x, loop) \
{ \
  q temp0 = derefone(x); \
  if(!isref(temp0)) { \
    (x) = temp0; \
    goto loop; \
  } \
}

#define not_cons(x)		((tag = ptagof(x)) != CONS)
#define not_functor()		(tag <= CONS)
#define not_atomic()		(tag == 0)
