/* ----------------------------------------------------------
%        Copyright (C) 1996-1997 Kazuhiko Ohno, Masahiko Ikawa,
%        and Computer Architecture Laboratory, Depertment of
%        Information Science, Kyoto University.
%----------------------------------------------------------- */  

/* ---------------------------------------------------------- 
%   (C)1993,1994,1995 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
#ifndef FIRST
/* Reasons of interruption */
#define EXTEVENT	makeint(0)
#define FAILURE		makeint(1)

#ifdef SCHED
extern q *interrupt_thread();
#else
extern q *interrupt_goal();
#endif
int check_stack_for_alternatively();
struct goalrec *enqueue_goal();
struct goalrec *enqueue_after_waiting();
struct goalrec *enqueue_throw_goal();

#ifdef SCHED
struct threadrec *enqueue_throw_thread();
#endif
#ifdef SCHED
#define enqueue_at_priority(p,q0,q)	\
{	\
  qp = enqueue_after_waiting(q0, (p), q, allocp, 0); \
}

#define enqueue_at_priority_no_check(x,q0,q)		\
{							\
  long prio = intval(x);				\
  qp = enqueue_thread(q0, prio, q, glbl);			\
}

#define enqueue_at_lower_priority(p,q0,q)		\
{							\
  qp = enqueue_after_waiting(q0, (p), q, allocp, 1);	\
}

#define enqueue_at_lower_priority_no_check(x,q0,q)	\
{							\
  long prio = current_prio-intval(x);			\
  qp = enqueue_thread(q0, prio, q, glbl);			\
}
#else
#define enqueue_at_priority(p,q0,q)			\
{							\
  qp = enqueue_after_waiting(q0, (p), q, allocp, 0);	\
}

#define enqueue_at_priority_no_check(x,q0,q)		\
{							\
  long prio = intval(x);				\
  qp = enqueue_goal(q0, prio, q, glbl);			\
}

#define enqueue_at_lower_priority(p,q0,q)		\
{							\
  qp = enqueue_after_waiting(q0, (p), q, allocp, 1);	\
}

#define enqueue_at_lower_priority_no_check(x,q0,q)	\
{							\
  long prio = current_prio-intval(x);			\
  qp = enqueue_goal(q0, prio, q, glbl);			\
}
#endif


#define switch_on_pred()	switch (toppred->pred)

#define case_pred(p, label)	case (p): goto label;

#define last_case_pred(p, label) default: goto label;

#ifdef SCHED
#define resume_check() \
{ \
	if(special_thread){ \
		resume_flag = 1; \
		goto interrupt_check; \
	}else \
		goto proceed_label; \
}

#ifdef OLD
#define interrupt_check() \
{ \
	stackp += toppred->arity; \
	*stackp++ = (q)toppred; \
		if(gs_stack.flag){ \
	generic_interrupt: \
			push_gs_stack(); \
		}	\
  if(reasonp != 0l){ \
		allocp = interrupt_thread(allocp, toppred, reasonp, qp, stackp);  \
		qp=current_queue;  \
		stackp = qp->stack->top;  \
  }else{  \
		qp->stack->top = stackp; \
  } \
}
#endif

#define interrupt_check() \
{ \
	stackp += toppred->arity; \
	*stackp++ = (q)toppred; \
		if(gs_stack.flag){ \
	generic_interrupt: \
			push_gs_stack(); \
		}	\
  if(reasonp != 0l){ \
		allocp = interrupt_thread(allocp, toppred, reasonp, qp, stackp);  \
		qp=current_queue;  \
		stackp = qp->stack->top;  \
  } \
}



#define loop_within_module(f)	\
{ \
  module (*func)(); \
		if (allocp >= heaplimit) { \
	   interrupt_check: \
		if(gs_stack.flag){ \
		 goto generic_interrupt; \
										 } \
			qp->stack->top = stackp; \
			allocp = klic_interrupt(allocp, qp, stackp); \
      qp = current_queue; \
			stackp = qp->stack->top; \
	  } \
	proceed_label: \
  	toppred = (struct predicate *)*--stackp; \
	if ((func = toppred->func) == (f)){ \
		/* next goal is in same module */ \
		goto module_top; \
	} \
	/* next goal is not in same module, \
		 but thread is not change */ \
	heapp = allocp;  \
	qp->stack->top = stackp; \
	current_queue = qp; \
	return (module) func; \
}



#else
#define loop_within_module(f)	\
{ \
  module (*func)(); \
  if (allocp >= heaplimit) { \
    allocp = klic_interrupt(allocp, qp); \
    qp = current_queue; \
  } \
  if ((func = (toppred = qp->pred)->func) == (f)) \
    goto module_top; \
  heapp = allocp; \
  current_queue = qp; \
  return (module) func; \
}
#endif
#endif /* aho */
#define execute(label)\
{\
  if (allocp < heaplimit) goto label;\
}


#ifdef SCHED
#define execute_for_loop(label) \
{  \
	if (allocp < heaplimit && !special_thread) goto label; \
	if (special_thread){ \
		resume_flag = 1; \
		heaplimit = 0; \
	} \
}

/* #define execute_for_loop(label) execute(label)  */

#define proceed() \
{ \
		if (allocp < heaplimit) goto proceed_label; \
		else goto interrupt_check; \
}
		
#else
#define proceed()	\
{	\
  goto proceed_label;	\
}
#endif

#ifdef PACKSEND
#define throw_goal(parent_pred,node,oldqp,goal) \
{\
	 qp = enqueue_throw_goal((node),(goal),(oldqp),(parent_pred),allocp); \
}
#else
#ifdef SCHED
#define throw_thread(node, thread) \
{ \
		qp->next = enqueue_throw_thread((node),(thread),qp->next); \
}
#endif

#define throw_goal(node, oldqp, goal) \
{ \
  qp = enqueue_throw_goal((node), (goal), (oldqp), allocp);\
}
#endif
