# viewpp_gardpred.tcl (viewpp tcl script for gard unification)
#
# Copyright (C) 1997  Jun Nagumo

proc g_atomic { id } {

    global item_table

    set attr $item_table($id,attribute)

    if { $attr == "ATOM" } {
	return true
    } {
	return false
    }

}

proc g_integer { id } {

    global item_table

    set attr $item_table($id,attribute)

    if { $attr != "ATOM" } {
	return false
    } {}

    set name $item_table($id,name)

    if { [regexp {[+--]?[0-9]+} $name] == 1 } {
	return true
    } {
	return false
    }
}

proc g_atom { id } {

    global item_table

    set res1 [g_atomic $id]
    set res2 [g_integer $id]

    if { ($res1 == "true")&&($res2 == "false") } {
	return true
    } {
	return false
    }
}

proc g_not_atomic { id } {

    set res [g_atomic $id]

    case $res {
	true { return false }
	false { return true }
    }
}

proc g_not_integer { id } {

    set res [g_integer $id]

    case $res {
	true { return false }
	false { return true }
    }
}

proc g_not_atom { id } {

    set res [g_atom $id]

    case $res {
	true { return false }
	false { return true }
    }
}
