# viewpp_fileload.tcl (viewpp tcl part for file load)
#
# Copyright (C) 1997  Jun Nagumo

set file_selected FALSE
set selected_filename ""

################################################################
#  load_file
#
#    եΥ
################################################################

proc load_file {} {

    global directory
    global file_selected
    global selected_filename

    set file_selected FALSE

    toplevel .lf
    wm title .lf "Load File"

    frame .lf.dir
      label .lf.dir.label -text "Directory"
      entry .lf.dir.entry -width 40 -textvariable directory
    
    frame .lf.fil
      label .lf.fil.label -text "File"
      listbox .lf.fil.list -width 39 -yscrollcommand ".lf.fil.scl set"
      scrollbar .lf.fil.scl -orient vertical \
                       -command ".lf.fil.list yview"

    frame .lf.but
      button .lf.but.ok -text "Load" -command "file_selected"
      button .lf.but.cancel -text "Cancel" -command "load_cancel"

    bind .lf.fil.list <Double-Button-1> { file_selected }

    set pg [wm geometry .]

    scan $pg "%d x %d + %d + %d" dam1 dam2 px py
    wm geometry .lf +[expr $px + 200]+[expr $py + 100]
    
    pack .lf.dir .lf.fil .lf.but -side top -fill x -expand 1
    pack .lf.dir.label .lf.dir.entry -side left -fill x -expand 1
    pack .lf.fil.label .lf.fil.list -side left -anchor n
    pack .lf.fil.scl -side left -fill y
    pack .lf.but.ok .lf.but.cancel -side left

    while { 1==1 } {
	disp_filelist [get_filelist $directory]
	tkwait variable file_selected

	if { [string match ((*)) $selected_filename]==1 } {
	    scan $selected_filename ((%s directory
            set directory [string trim $directory ) ]

	    cd $directory
	    set directory [pwd]
	    continue
	} {
	    break
	}
    }

    return $directory/$selected_filename
}

################################################################
#  load_cancel
#
#   եɤΥ󥻥
################################################################

proc load_cancel {} {

    global selected_filename
    global file_selected

    set file_selected TRUE
    set selected_filename ""

    return {}
}

################################################################
#  get_filelist dir
#
#    եΥꥹȤ
################################################################

proc get_filelist { dir } {

    set all [glob -nocomplain $dir/*]
    set ret {}
    set ret_d {}
    set ret_f {}
    set ret2 {}
    set ret2_d {}
    set ret2_f {}
    set ret3 {}
    set ret3_d {}
    set ret3_f {}

    set allfiles [llength $all]

    for {set i 0} {$i < $allfiles} {incr i} {

	set name [lindex $all $i]
	if {[file isdirectory $name]==1} {
	    lappend ret_d $name
	    continue
	} {}
	if {[file extension $name] == ".vpp"} {
	    lappend ret_f $name
	    continue
	} {}
	    
    }

    set files_d [llength $ret_d]
    for {set i 0} {$i < $files_d} {incr i} {

	set fullname [lindex $ret_d $i]
	regsub .*/ $fullname "" shortname

	lappend ret2_d $shortname
    }

    set files_f [llength $ret_f]
    for {set i 0} {$i < $files_f} {incr i} {

	set fullname [lindex $ret_f $i]
	regsub .*/ $fullname "" shortname

	lappend ret2_f $shortname
    }

    set ret3_d [lsort $ret2_d]
    set ret3_f [lsort $ret2_f]

    set ret3 [concat $ret3_d $ret3_f]

    return $ret3
    
}


################################################################
#  disp_filelist { list }
#
#    ꥹȥܥå˥ե̾ΥꥹȤɽ
################################################################

proc disp_filelist { list } {

    set files [llength $list]

    .lf.fil.list delete 0 end

    for {set i 0} {$i < $files} {incr i} {

	set name [lindex $list $i]
	if {[file isdirectory $name]==1} {
	    .lf.fil.list insert $i (($name))
	} {}
	if {[file extension $name] == ".vpp"} {
	    .lf.fil.list insert $i $name
	} {}
    }
    .lf.fil.list insert 0 ((..))
}

################################################################
#  file_selected
#
#    򤵤줿ե̾
################################################################

proc file_selected {} {

    global file_selected
    global selected_filename

    set filenum [.lf.fil.list curselection]
    set file [.lf.fil.list get $filenum $filenum]

    set file_selected TRUE
    set selected_filename $file


    return $file
}

##(eof)#########################################################
