#! /usr/local/bin/wish.new -f
# viewpp.tcl (viewpp tcl part main routine)
#
# Copyright (C) 1997   Jun Nagumo

################################################################
#Хѿ
################################################################

set entrytext {}           ;# 
set entryreturn FALSE      ;# 

set selected FALSE         ;# å˥ƥब
                           ;# 򤵤줿 TRUE
set startitem {}           ;# åitem

set pushed 0               ;# .cˤɤμΥƥ֤
set item_last 0            ;# ˻Ȥ Item ID
set line_last 0            ;# ˻Ȥ Line ID
set pred_last 0            ;# ˻Ȥ Pred ID
set pred_last_tmp 0

set directory [pwd]        ;# ȥǥ쥯ȥ

################################################################
# եΥ
################################################################

source viewpp_fileload.tcl
source viewpp_gardpred.tcl

################################################################
#  itemput x y
#
#   (x,y)ΰ֤˳item֤
################################################################

proc itemput { x y xx yy } {

    global pushed
    global pushed_pred

    set pushed 0
    set pushed_pred 0

    if { [.c find overlapping $x $y $x $y] != "" } { return } {}

    .m post $xx $yy
    tkwait variable pushed

    switch $pushed {
	Pred {makepred $x $y $pushed_pred}
	Atom {makeatom $x $y ""}
	Cons {makecons $x $y}
    }

}

################################################################
#  makepred x y id
#
#   (x,y)ΰ֤ pred_id ֤
################################################################

proc makepred { x y pred_id } {

    global item_last
    global item_table
    global pred_table
    global id_tag_table

    set pid [.c create oval [expr $x-25] [expr $y-25] \
	                    [expr $x+25] [expr $y+25] \
		   -outline gray -fill #eeaa66 -tags c$item_last]

    .c create text [expr $x] [expr $y] -text $pred_table($pred_id,name) \
		   -tags c$item_last

    set itemid $item_last

    set id_tag_table($pid) $item_last

    .c bind c$itemid <B2-Motion> "node_drag $item_last %x %y"
    .c bind $pid <Enter> ".c itemconfigure $pid -fill #ffddaa"
    .c bind $pid <Leave> ".c itemconfigure $pid -fill #eeaa66"
#    .c bind $pid <Button-3> "extract_pred $itemid %x %y"

    set item_table($itemid,attribute) PRED
    set item_table($itemid,x) $x
    set item_table($itemid,y) $y
    set item_table($itemid,name) $pred_id

    incr item_last

    set item_table($itemid,in) {}
    for {set i 1} {$i <= $pred_table($pred_id,in)} {incr i} {
	set id [.c create oval [expr $x-25+$i*15] [expr $y-35] \
		               [expr $x-15+$i*15] [expr $y-25] \
  		               -outline gray -fill white -tags c$itemid]
	lappend item_table($itemid,in) $item_last

	.c bind $id <Button-1> "makeline {PRED $itemid IN $i}"

	set item_table($item_last,attribute) IN
	set item_table($item_last,belong) $itemid
	set item_table($item_last,name) $i
	set item_table($item_last,edgeid) {}

	incr item_last
    }

    set item_table($itemid,out) {}
    for {set i 1} {$i <= $pred_table($pred_id,out)} {incr i} {
	set id [.c create oval [expr $x-25+$i*15] [expr $y+35] \
		               [expr $x-15+$i*15] [expr $y+25] \
		               -outline gray -fill gray -tags c$itemid]
	lappend item_table($itemid,out) $item_last

	.c bind $id <Button-1> "makeline {PRED $itemid OUT $i}"

	set item_table($item_last,attribute) OUT
	set item_table($item_last,belong) $itemid
	set item_table($item_last,name) $i
	set item_table($item_last,edgeid) {}

	incr item_last
    }

    .c raise c$id
    update

    return $itemid
}

################################################################
#   makeatom x y [name]
#
#    (x,y) ΰ֤ atom ֤
################################################################

proc makeatom { x y atomvalue } {

    global item_last
    global item_table
    global id_tag_table

    set id [.c create oval [expr $x-15] [expr $y-15] \
                           [expr $x+15] [expr $y+15] \
	           -outline black -fill #77ddff -tags c$item_last]

    set id_tag_table($id) $item_last

    .c bind $id <Button-1> "makeline {ATOM $item_last}"
    .c bind $id <Button-3> "change_value $item_last"
    .c bind $id <B2-Motion> "node_drag $item_last %x %y"
    .c bind $id <Enter> ".c itemconfigure $id -fill #88ffff"
    .c bind $id <Leave> ".c itemconfigure $id -fill #77ddff"

    if { $atomvalue=="" }  {
	set atomvalue [entry_dialog "Value of Atom" "\[\]"]
    }

    .c create text $x $y -text $atomvalue -tags c$item_last

    set item_table($item_last,attribute) ATOM
    set item_table($item_last,x) $x
    set item_table($item_last,y) $y
    set item_table($item_last,name) $atomvalue
    set item_table($item_last,edgeid) {}

    .c raise c$item_last

    update

    incr item_last

    return [expr $item_last - 1]
}

################################################################
#  change_value id
#
#    atom ƤѤ
################################################################

proc change_value { id } {

    global item_table

    set name $item_table($id,name)

    set newname [entry_dialog "Value of Atom" $name]

    .c dchars c$id 0 end
    .c insert c$id end $newname

    set item_table($id,name) $newname

}

################################################################
#   makedammy x y
#
#    (x,y) ΰ֤ dammy ֤
################################################################

proc makedammy { x y } {

    global item_last
    global item_table

    set id [.c create oval [expr $x-1] [expr $y-1] \
                           [expr $x+1] [expr $y+1] \
	           -outline blue -fill blue -tags c$item_last]

    set item_table($item_last,attribute) DAMMY
    set item_table($item_last,x) $x
    set item_table($item_last,y) $y

    .c raise c$item_last
    update

    incr item_last

    return [expr $item_last - 1]
}

################################################################
#   makecons x y
#
#    (x,y) ΰ֤ cons ֤
################################################################

proc makecons { x y } {

    global item_last
    global item_table
    global id_tag_table

    set itemid $item_last

    set id [.c create oval [expr $x-10] [expr $y-10] \
	                   [expr $x+10] [expr $y+10] \
	           -outline black -fill blue -tags c$item_last]

    set id_tag_table($id) $item_last

    .c bind $id <Button-1> "makeline {CONS $itemid IN 0}"
    .c bind $id <B2-Motion> "node_drag $itemid %x %y"
    .c bind $id <Enter> ".c itemconfigure $id -fill violet"
    .c bind $id <Leave> ".c itemconfigure $id -fill blue"

    set item_table($item_last,attribute) CONS
    set item_table($item_last,x) $x
    set item_table($item_last,y) $y
    set item_table($item_last,edgeid) {}
    incr item_last

    set id [.c create oval [expr $x-18] [expr $y-8] [expr $x-2] [expr $y+8] \
    	                  -outline gray -fill white -tags c$itemid]

    .c bind $id <Button-1> "makeline {CONS $itemid OUT 1}"

    set item_table($item_last,attribute) OUT
    set item_table($item_last,belong) $itemid
    set item_table($item_last,name) 1
    set item_table($item_last,edgeid) {}
    lappend item_table($itemid,out) $item_last
    incr item_last

    set id [.c create oval [expr $x+2] [expr $y-8] [expr $x+18] [expr $y+8] \
    	                  -outline gray -fill white -tags c$itemid]

    .c bind $id <Button-1> "makeline {CONS $itemid OUT 2}"

    set item_table($item_last,attribute) OUT
    set item_table($item_last,belong) $itemid
    set item_table($item_last,name) 2
    set item_table($item_last,edgeid) {}
    lappend item_table($itemid,out) $item_last
    incr item_last

    .c raise c$itemid
    update

    return $itemid
}

################################################################
#   makesnoc x y
#
#    (x,y) ΰ֤ snoc ֤
################################################################

proc makesnoc { x y } {

    global item_last
    global item_table
    global id_tag_table

    set itemid $item_last

    set id [.c create oval [expr $x-10] [expr $y-10] \
	                   [expr $x+10] [expr $y+10] \
	           -outline black -fill pink -tags c$item_last]

    set id_tag_table($id) $item_last

    .c bind $id <Button-1> "makeline {SNOC $itemid IN 0}"
    .c bind $id <B2-Motion> "node_drag $itemid %x %y"
    .c bind $id <Enter> ".c itemconfigure $id -fill violet"
    .c bind $id <Leave> ".c itemconfigure $id -fill pink"

    set item_table($item_last,attribute) SNOC
    set item_table($item_last,x) $x
    set item_table($item_last,y) $y
    incr item_last

    set id [.c create oval [expr $x-18] [expr $y-8] [expr $x-2] [expr $y+8] \
    	                  -outline gray -fill white -tags c$itemid]

    .c bind $id <Button-1> "makeline {SNOC $itemid OUT 1}"

    set item_table($item_last,attribute) OUT
    set item_table($item_last,belong) $itemid
    set item_table($item_last,name) 1
    lappend item_table($itemid,out) $item_last
    incr item_last

    set id [.c create oval [expr $x+2] [expr $y-8] [expr $x+18] [expr $y+8] \
    	                  -outline gray -fill white -tags c$itemid]

    .c bind $id <Button-1> "makeline {SNOC $itemid OUT 2}"

    set item_table($item_last,attribute) OUT
    set item_table($item_last,belong) $itemid
    set item_table($item_last,name) 2
    lappend item_table($itemid,out) $item_last
    incr item_last

    .c raise c$item_last
    update

    return $itemid
}

################################################################
#    makeline
#
#     å
################################################################

proc makeline { arglist } {

    global selected
    global startitem

    if { "$selected" == "FALSE" } {
	selectitem $arglist
    } {
	if { $startitem == $arglist } {
	    set selected FALSE
	    .c delete sbox
	    .l.sta configure -text "Your select was canceled."
	    return
	} {}

	drawline $arglist
    }

}

################################################################
#  selectitem arglist
#
#   
################################################################

proc selectitem { arglist } {

    global selected
    global item_table
    global startitem

    set selected TRUE

    set attr [lindex $arglist 0]
    set itemid [lindex $arglist 1]

    switch -regexp $attr {

	(ATOM|DAMMY) {
	    set x1 [expr $item_table($itemid,x)-16]
	    set y1 [expr $item_table($itemid,y)-16]
	    set x2 [expr $item_table($itemid,x)+16]
	    set y2 [expr $item_table($itemid,y)+16]
	}
	PRED {
	    set inout [lindex $arglist 2]
	    set num [lindex $arglist 3]
	    set x1 [expr $item_table($itemid,x)-25+$num*15]
	    set x2 [expr $item_table($itemid,x)-15+$num*15]

	    switch $inout {
		IN {
		    set y1 [expr $item_table($itemid,y)-35]
		    set y2 [expr $item_table($itemid,y)-25]
		}
		OUT {
		    set y1 [expr $item_table($itemid,y)+35]
		    set y2 [expr $item_table($itemid,y)+25]
		}
	    }
	}
	(CONS|SNOC) {
	    set inout [lindex $arglist 2]
	    set num [lindex $arglist 3]
	    switch $inout {
		IN {
		    set x1 [expr $item_table($itemid,x)-12]
		    set y1 [expr $item_table($itemid,y)-12]
		    set x2 [expr $item_table($itemid,x)+12]
		    set y2 [expr $item_table($itemid,y)+12]
		}
		OUT {
		    switch $num {
			1 {
			    set x1 [expr $item_table($itemid,x)-20]
			    set y1 [expr $item_table($itemid,y)-10]
			    set x2 [expr $item_table($itemid,x)]
			    set y2 [expr $item_table($itemid,y)+10]
			}
			2 {
			    set x1 [expr $item_table($itemid,x)]
			    set y1 [expr $item_table($itemid,y)-10]
			    set x2 [expr $item_table($itemid,x)+20]
			    set y2 [expr $item_table($itemid,y)+10]
			}
		    }
		}
	    }
	}
    }
    set startitem $arglist

    .c create rectangle $x1 $y1 $x2 $y2 -outline black -tags sbox
}

################################################################
#    drawline arglist
#
#    å
################################################################

proc drawline { arglist } {

    global item_table
    global line_last
    global line_table
    global startitem
    global selected

    .c delete sbox

    set selected FALSE

    set start_geo [get_itemgeo $startitem]
    set end_geo [get_itemgeo $arglist]

    set x1 [lindex $start_geo 0]
    set y1 [lindex $start_geo 1]
    set x2 [lindex $end_geo 0]
    set y2 [lindex $end_geo 1]

    .c create line $x1 $y1 $x2 $y2 -fill blue -width 2 -tags l$line_last
    .c lower l$line_last

    set line_table($line_last,x1) $x1
    set line_table($line_last,y1) $y1
    set line_table($line_last,x2) $x2
    set line_table($line_last,y2) $y2

    set line_table($line_last,idp1) [lindex $startitem 1]
    set line_table($line_last,idp2) [lindex $arglist 1]

    set id1 [write_edgeinfo $startitem $line_last]
    set id2 [write_edgeinfo $arglist $line_last]

    set line_table($line_last,id1) $id1
    set line_table($line_last,id2) $id2

    set startitem {}
    incr line_last

}

################################################################
#   write_edgeinfo  arglist lineid
#
#    item_table  edge
################################################################

proc write_edgeinfo { arglist lineid } {

    global item_table

    set attr [lindex $arglist 0]
    set id [lindex $arglist 1]

    switch -regexp $attr {
	(ATOM|DAMMY) {
	    lappend item_table($id,edgeid) $lineid
	    set pid $id
	}
	PRED {
	    set inout [lindex $arglist 2]
	    set num [lindex $arglist 3]

	    switch $inout {
		IN {
		    set w_id [lindex $item_table($id,in) [expr $num-1]]
		}
		OUT {
		    set w_id [lindex $item_table($id,out) [expr $num-1]]
		}
	    }
	    set pid $w_id
	    set item_table($w_id,edgeid) $lineid
	}
	(CONS|SNOC) {
	    set inout [lindex $arglist 2]
	    set num [lindex $arglist 3]

	    switch $inout {
		IN {
		    set item_table($id,edgeid) $lineid
		    set pid $id
		}
		OUT {
		    set w_id [lindex $item_table($id,out) [expr $num-1]]
		    set item_table($w_id,edgeid) $lineid
		    set pid $w_id
		}
	    }
	}

    }

    return $pid
}

################################################################
#    get_itemget arglist
#
#     item κɸ
################################################################

proc get_itemgeo { arglist } {

    global item_table

    set attr [lindex $arglist 0]
    set itemid [lindex $arglist 1]

    switch -regexp $attr {

	(ATOM|DAMMY) {
	    set x $item_table($itemid,x)
	    set y $item_table($itemid,y)
	}
	PRED {
	    set inout [lindex $arglist 2]
	    set num [lindex $arglist 3]
	    set x [expr $item_table($itemid,x)-20+$num*15]

	    switch $inout {
		IN {
		    set y [expr $item_table($itemid,y)-30]
		}
		OUT {
		    set y [expr $item_table($itemid,y)+30]
		}
	    }
	}
	(CONS|SNOC) {
    	    set inout [lindex $arglist 2]
	    set num [lindex $arglist 3]
	    set y $item_table($itemid,y)

	    switch $inout {
		IN {
		    set x $item_table($itemid,x)
		}
		OUT {
		    switch $num {
			1 {
			    set x [expr $item_table($itemid,x)-10]
			}
			2 {
			    set x [expr $item_table($itemid,x)+10]
			}
		    }
		}
	    }
	}
    }

    return [list $x $y]
}

################################################################
#   entry_dialog title default
#
#    ʸϤΥ
################################################################

proc entry_dialog { title default } {

    toplevel .di

    global entrytext
    global entryreturn

    set entrytext {}
    set entryreturn FALSE

    entry .di.e -relief sunken -textvariable entrytext
    .di.e insert 0 $default
    bind .di.e <Key-Return> "set entryreturn TRUE"

    set pg [wm geometry .]

    scan $pg "%d x %d + %d + %d" dam1 dam2 px py
    wm title .di $title
    wm geometry .di +[expr $px + 200]+[expr $py + 100]
    pack .di.e -side top

    tkwait variable entryreturn

    destroy .di
    return $entrytext
}

################################################################
#  replace_base
#
#    ץ졼롼θƤӽФ򤹤
################################################################

proc replace_base { execflag } {

    global item_table
    global line_table
    global item_last
    global line_last

    replace

    if { "$execflag"=="FALSE" } { return } {}

    set finishflag 3

    while { $finishflag != 0 } {

	set finishflag 0
	set snoclist [makesnoclist]
	
	set ret FALSE                ;# CONS  SNOC η
	foreach i $snoclist {
	    set ret [snoccons $i]
	}

	if { "$ret" != "FALSE" } {
	    replace
	    incr finishflag
	} {}

	for {set i 0} {$i < $line_last} {incr i} {
	    set id1 $line_table($i,idp1)
	    set id2 $line_table($i,idp2)
	    set at1 $item_table($id1,attribute)
	    set at2 $item_table($id2,attribute)

	    if { ("$at1"=="ATOM")&&("$at2"=="ATOM") } {
		atomunif $id1 $id2
	    } {}
	}
	
	set ret2 [pred_check]

	foreach i $ret2 {
	    set xx $item_table($i,x)
	    set yy $item_table($i,y)
	    extract_pred $i $xx $yy
	}
	if { $ret2 !={} } {
	    replace
	    incr finishflag
	} {}

	set ret3 [makedammylist]
	foreach i $ret3 {
	    dammy_delete $i
	}
	if { $ret3 != {} } {
	    replace
	    incr finishflag
	}

    }

}

################################################################
#  makesnoclist
#
#   snoc ΥꥹȤ
################################################################

proc makesnoclist {} {

    global item_table
    global item_last

    set snoclist {}

    for {set i 0} {$i < $item_last} {incr i} {
	set attr $item_table($i,attribute)
	if { "$attr"=="SNOC" } {
	    lappend snoclist $i
	} {}
    }

    return $snoclist
}

################################################################
#  makedammylist
#
#    dammyΡɤΥꥹȤ
################################################################

proc makedammylist {} {

    global item_table
    global item_last

    set dammylist {}

    for {set i 0} {$i < $item_last} {incr i} {
	set attr $item_table($i,attribute)
	if { "$attr"=="DAMMY" } {
	    lappend dammylist $i
	} {}
    }

    return $dammylist
}

################################################################
#  dammy_delete id
#
#    ߡΡ id 
################################################################

proc dammy_delete { id } {

    global item_table
    global line_table

    set item_table($id,attribute) DELETE
    .c delete c$id

    set line1 [lindex $item_table($id,edgeid) 0]
    set line2 [lindex $item_table($id,edgeid) 1]

    set line_table($line1,id1) -1
    set line_table($line2,id1) -1
    .c delete l$line1
    .c delete l$line2

    set n1 $line_table($line1,idp1)
    set n2 $line_table($line1,idp2)
    set n3 $line_table($line2,idp1)
    set n4 $line_table($line2,idp2)
    set n1_ $line_table($line1,id1)
    set n2_ $line_table($line1,id2)
    set n3_ $line_table($line2,id1)
    set n4_ $line_table($line2,id2)

    if { $id == $n1 } {	
	set pear1 $n2
	set pear1_ $n2_
    } { 
	set pear1 $n1
	set pear1_ $n1_
    }
    if { $id == $n3 } {
	set pear2 $n4
	set pear2_ $n4_
    } {
	set pear2 $n3
	set pear2_ $n3_
    }

    set attr $item_table($pear1,attribute)
    switch $attr {
	ATOM {
	    set to_arglist [list ATOM $pear1]
	}
	PRED {
	    set intablist $item_table($pear1,in)
	    set outtablist $item_table($pear1,out)
	    
	    set innum [expr [lsearch -exact $intablist $pear1_]+1]
	    if { $innum != -1 } {
		set to_arglist [list PRED $pear1 IN $innum]
	    } {
		set outnum [expr [lsearch -exact $outtablist $pear1_]+1]
		set to_arglist [list PRED $pear OUT $outnum]
	    }
	}
	CONS {
	    if { $pear1 == $pear1_ } {
		set to_arglist [list CONS $pear1 IN 0]
	    } {
		set outtablist $item_table($pear1,out)
		set outnum [expr [lsearch -exact $outtablist $pear1_]+1]
		set to_arglist [list CONS $pear1 OUT $outnum]
	    }
	}
	SNOC {
	    if { $pear1 == $pear1_ } {
		set to_arglist [list SNOC $pear1 IN 0]
	    } {
		set outtablist $item_table($pear1,out)
		set outnum [expr [lsearch -exact $outtablist $pear1_]+1]
		set to_arglist [list SNOC $pear1 OUT $outnum]
	    }
	}
    }

    set attr $item_table($pear2,attribute)
    switch $attr {
	ATOM {
	    set to_arglist [list ATOM $pear2]
	}
	PRED {
	    set intablist $item_table($pear2,in)
	    set outtablist $item_table($pear2,out)
	    
	    set innum [expr [lsearch -exact $intablist $pear2_]+1]
	    if { $innum != -1 } {
		set from_arglist [list PRED $pear2 IN $innum]
	    } {
		set outnum [expr [lsearch -exact $outtablist $pear2_]+1]
		set from_arglist [list PRED $pear2 OUT $outnum]
	    }
	}
	CONS {
	    if { $pear2 == $pear2_ } {
		set to_arglist [list CONS $pear2 IN 0]
	    } {
		set outtablist $item_table($pear2,out)
		set outnum [expr [lsearch -exact $outtablist $pear2_]+1]
		set from_arglist [list CONS $pear2 OUT $outnum]
	    }
	}
	SNOC {
	    if { $pear2 == $pear2_ } {
		set from_arglist [list SNOC $pear2 IN 0]
	    } {
		set outtablist $item_table($pear2,out)
		set outnum [expr [lsearch -exact $outtablist $pear2_]+1]
		set from_arglist [list SNOC $pear2 OUT $outnum]
	    }
	}
    }

    makeline $from_arglist
    makeline $to_arglist

}

################################################################
#  replace
#
#   ɽΥץ졼
################################################################

proc replace {} {

    global item_table
    global item_last
    global line_table
    global line_last

    set items {}            ;# Υꥹ

    for {set i 0} {$i < $item_last} {incr i} {
	set attr $item_table($i,attribute)
	if { [regexp (PRED|ATOM|CONS|SNOC|DAMMY) $attr] } {
	    lappend items $i
	} {}
    }                       ;# ưоݤΥꥹȤ

    while { 1 == 1 } {

	set ddist 0

	foreach i $items {

	    set x1 $item_table($i,x)
	    set y1 $item_table($i,y)
	    set dx 0
	    set dy 0

	    foreach j $items {

		if { $i == $j } { continue } {}

		set x2 $item_table($j,x)
		set y2 $item_table($j,y)
		set dist [expr hypot($x1-$x2,$y1-$y2)]
		set direct [direct_check $i $j]

		set c_0 [calc_c0 $i $j]    ;# ΡɴֺŬΥ׻

		switch $direct {

		    TRUE {
			set sim [expr 8.0*log($dist/$c_0)]
			set ddx [expr $sim*($x2-$x1)]
			set ddy [expr $sim*($y2-$y1)]
		    }
		    FALSE {
			if { $dist < [expr $c_0*2] } {
			    set sim [expr 1.2]
			} {
			    set sim [expr 0.6/($dist*$dist)]
			}
			set ddx [expr $sim*($x1-$x2)]
			set ddy [expr $sim*($y1-$y2)]
		    }
		}
		set dx [expr $dx+$ddx]
		set dy [expr $dy+$ddy]

	    }      ;# foreach j

	    set dx [expr int($dx/40)]
	    set dy [expr int($dy/40)]

	    incr item_table($i,x) $dx
	    incr item_table($i,y) $dy

            move_node $i $dx $dy

	    incr ddist [expr int(hypot($dx,$dy))]

	}          ;# foreach i

	if { $ddist < [expr [llength $items]*2] } {
	    break
	} {}
	
    }              ;# while {true}

    .l.sta configure -justify left -text "Replace finished."


}

################################################################
#    node_drag id
#
#     idɥå줿
################################################################

proc node_drag { id x y } {

    global item_table

    set x0 $item_table($id,x)
    set y0 $item_table($id,y)

    set dx [expr int($x-$x0)]
    set dy [expr int($y-$y0)]

    move_node $id $dx $dy

    incr item_table($id,x) $dx
    incr item_table($id,y) $dy

}


################################################################
#    move_node id dx dy
#
#    ΰư
################################################################

proc move_node { id dx dy } {

    global item_table
    global line_table

    set dx [expr int($dx)]
    set dy [expr int($dy)]

    .c move c$id $dx $dy

    switch -regexp $item_table($id,attribute) {
	PRED {
	    foreach k $item_table($id,in) {
		set lin $item_table($k,edgeid)

		if { $lin == {} } { break } {}

		set which [which_edge $k $lin {}]

		incr line_table($lin,x$which) $dx
		incr line_table($lin,y$which) $dy

		set xx1 $line_table($lin,x1)
		set yy1 $line_table($lin,y1)
		set xx2 $line_table($lin,x2)
		set yy2 $line_table($lin,y2)

		.c coords l$lin $xx1 $yy1 $xx2 $yy2

	    }

	    foreach k $item_table($id,out) {
		set lin $item_table($k,edgeid)

		if { $lin == {} } { break } {}

		set which [which_edge $k $lin {}]

		incr line_table($lin,x$which) $dx
		incr line_table($lin,y$which) $dy

		set xx1 $line_table($lin,x1)
		set yy1 $line_table($lin,y1)
		set xx2 $line_table($lin,x2)
		set yy2 $line_table($lin,y2)

		.c coords l$lin $xx1 $yy1 $xx2 $yy2
	    }

	}
	(ATOM|DAMMY) {
	    foreach k $item_table($id,edgeid) {

		if { $k == {} } { break } {}

		set which [which_edge $id $k p]
		incr line_table($k,x$which) $dx
		incr line_table($k,y$which) $dy

		set xx1 $line_table($k,x1)
		set yy1 $line_table($k,y1)
		set xx2 $line_table($k,x2)
		set yy2 $line_table($k,y2)

		.c coords l$k $xx1 $yy1 $xx2 $yy2
	    }
	}
	(CONS|SNOC) {
	    foreach k $item_table($id,edgeid) {

		if { $k == {} } { break } {}

		set which [which_edge $id $k p]

		incr line_table($k,x$which) $dx
		incr line_table($k,y$which) $dy

		set xx1 $line_table($k,x1)
		set yy1 $line_table($k,y1)
		set xx2 $line_table($k,x2)
		set yy2 $line_table($k,y2)

		.c coords l$k $xx1 $yy1 $xx2 $yy2
	    }


	    foreach k $item_table($id,out) {

		set lin $item_table($k,edgeid)

		if { $lin == {} } { break } {}

		set which [which_edge $k $lin {}]

		incr line_table($lin,x$which) $dx
		incr line_table($lin,y$which) $dy

		set xx1 $line_table($lin,x1)
		set yy1 $line_table($lin,y1)
		set xx2 $line_table($lin,x2)
		set yy2 $line_table($lin,y2)

		.c coords l$lin $xx1 $yy1 $xx2 $yy2
	    }


	}
    }

    update
}

################################################################
#  direct_check  node1 node2
#
#   ƱΤľ³Ƥ뤫Ĵ٤
################################################################

proc direct_check { node1 node2 } {

    global line_table
    global line_last

    set ret FALSE

    for {set i 0} {$i < $line_last} {incr i} {

	if { $line_table($i,id1) == -1 } { continue } {}

	set n1 $line_table($i,idp1)
	set n2 $line_table($i,idp2)

	if { ($node1==$n1)&&($node2==$n2) } {
	    set ret TRUE
	    break
	} {}
	if { ($node1==$n2)&&($node2==$n1) } {
	    set ret TRUE
	    break
	} {}
    }

    return $ret
}

################################################################
#   which_edge node edge
#
#     node  edge Τɤ餬դƤ뤫Ĵ٤
################################################################

proc which_edge { node edge flag } {

    global line_table

    set n1 $line_table($edge,id${flag}1)
    set n2 $line_table($edge,id${flag}2)

    if { $node == $n1 } { return 1 } {}
    if { $node == $n2 } { return 2 } {}
    return 0
}

################################################################
#   connect_edge node
#
#   node ³Ƥ edgeID ȿ¦node_id֤
################################################################

proc connect_edge { node } {

    global line_table
    global line_last

    set ret {-1 -1 -1}

    for {set i 0} {$i < $line_last} {incr i} {
	set n1 $line_table($i,id1)
	set n2 $line_table($i,id2)

	if { $n1 == -1 } { continue } {}

	if { $node==$n1 } {
	    set partner $line_table($i,id2)
    	    set partner_p $line_table($i,idp2)
	    set ret [list $i $partner $partner_p]
	    break
	} {}
	if { $node==$n2 } {
	    set partner $line_table($i,id1)
    	    set partner_p $line_table($i,idp1)
	    set ret [list $i $partner $partner_p]
	    break
	} {}

    }

    return $ret
}

################################################################
#   calc_c0 node1 node2
#
#    Ρɴ֤κŬΥ׻
################################################################

proc calc_c0 { node1 node2 } {

    global item_table
    global line_table

    set attr1 $item_table($node1,attribute)
    set attr2 $item_table($node2,attribute)


    set c0 70

    if { (("$attr1"=="CONS")&&("$attr2"=="SNOC"))|| \
         (("$attr1"=="SNOC")&&("$attr2"=="CONS")) } {
        set edgeid $item_table($node1,edgeid)
        set id1 $line_table($edgeid,id1)
        set id2 $line_table($edgeid,id2)

        if { (($node1==$id1)&&($node2==$id2))|| \
             (($node1==$id2)&&($node2==$id1)) } {
                 set c0 5
        } {}
    } {}

    if { ("$attr1"=="ATOM")||("$attr2"=="ATOM") } {
	set c0 50
    } {}

    if { ("$attr1"=="ATOM")&&("$attr2"=="ATOM") } {
	set name1 $item_table($node1,name)
	set name2 $item_table($node2,name)
	if { $name1 == $name2 } {
	    set c0 5
	} {}
    } {}

    if { ("$attr1"=="DAMMY")||("$attr2"=="DAMMY") } {
	set c0 20
    } {}

    return $c0
}

################################################################
#   extract_pred
#
#    predicate Ÿ
################################################################

proc extract_pred { id x y } {

    global item_table
    global line_table
    global pred_table
    global selected

    set item_table($id,attribute) DELETED
    set pred $item_table($id,name)

    set extracted_name $pred_table($pred,name)

    foreach i $item_table($id,in) {
	set item_table($i,attribute) DELETED
    }
    foreach i $item_table($id,out) {
	set item_table($i,attribute) DELETED
    }

    set cx $item_table($id,x)
    set cy $item_table($id,y)

    .c itemconfigure c$id -fill pink
    .c lower c$id
    
    for {set i 1} {$i <= 30} {incr i} {
	.c scale c$id $cx $cy 1.02 1.02
	update
    }

    set nodes $pred_table($pred,nodes)
    set lines $pred_table($pred,lines)
    set theta [expr 2*3.1415/$nodes]
    set r 40
    set itemlist {}

    for {set i 1} {$i <= $nodes} {incr i} {

	set xx [expr $x+int($r*cos($i*$theta))]
	set yy [expr $y+int($r*sin($i*$theta))]

	set attr [lindex $pred_table($pred,contents,$i) 0]

	switch $attr {
	    PRED {
		lappend itemlist \
		  [makepred $xx $yy [lindex $pred_table($pred,contents,$i) 1]]
	    }
	    CONS {
		lappend itemlist [makecons $xx $yy]
	    }
	    SNOC {
		lappend itemlist [makesnoc $xx $yy]
	    }
	    ATOM {
		lappend itemlist \
		  [makeatom $xx $yy [lindex $pred_table($pred,contents,$i) 1]]
	    }
	    DAMMY {
		lappend itemlist [makedammy $xx $yy]

	    }
	}

    }

    set selected FALSE

    for {set i 1} {$i <= $lines} {incr i} {

	set from_arg {}
	set to_arg {}

	set from $pred_table($pred,line,$i,1)
	set to $pred_table($pred,line,$i,2)

	set pred_from $pred_table($pred,contents,[lindex $from 0])
	set pred_to $pred_table($pred,contents,[lindex $to 0])
	set id_from [lindex $itemlist [expr [lindex $from 0]-1]]
	set id_to [lindex $itemlist [expr [lindex $to 0]-1]]
	set rest_from [lrange $from 1 end]
	set rest_to [lrange $to 1 end]

	set atr_from [lindex $pred_from 0]
	set atr_to [lindex $pred_to 0]

	set from_arg [concat $atr_from $id_from $rest_from]
	set to_arg [concat $atr_to $id_to $rest_to]

	makeline $from_arg
	makeline $to_arg
    }

    set inlist $item_table($id,in)
    for {set i 1} {$i <= $pred_table($pred,in)} {incr i} {

	set tab_id [lindex $inlist [expr $i-1]]
	set connection [connect_edge $tab_id]
	set delline [lindex $connection 0]
	set partner [lindex $connection 1]
	set partner_p [lindex $connection 2]

	set fromnodedat $pred_table($pred,into,$i)
	set fromid [lindex $itemlist [expr [lindex $fromnodedat 0]-1]]
	set from_arglist [list $item_table($fromid,attribute)\
		               $fromid \
			       [lindex $fromnodedat 1]\
			       [lindex $fromnodedat 2]]


	.c delete l$delline

	set line_table($delline,id1) -1

	set attr $item_table($partner_p,attribute)

	switch $attr {
	    ATOM {
		set to_arglist [list ATOM $partner_p]
	    }
	    PRED {
		set intablist $item_table($partner_p,in)
		set outtablist $item_table($partner_p,out)

		set innum [expr [lsearch -exact $intablist $partner]+1]
		if { $innum != -1 } {
		    set to_arglist [list PRED $partner_p IN $innum]
		} {
		    set outnum [expr [lsearch -exact $outtablist $partner]+1]
		    set to_arglist [list PRED $partner_p OUT $outnum]
		}
	    }
	    CONS {
		if { $partner == $partner_p } {
		    set to_arglist [list CONS $partner_p IN 0]
		} {
		    set outtablist $item_table($partner_p,out)
		    set outnum [expr [lsearch -exact $outtablist $partner]+1]
		    set to_arglist [list CONS $partner_p OUT $outnum]
		}
	    }
	    SNOC {
		if { $partner == $partner_p } {
		    set to_arglist [list SNOC $partner_p IN 0]
		} {
		    set outtablist $item_table($partner_p,out)
		    set outnum [expr [lsearch -exact $outtablist $partner]+1]
		    set to_arglist [list SNOC $partner_p OUT $outnum]
		}
	    }
	}

	makeline $from_arglist
	makeline $to_arglist
    }

    set outlist $item_table($id,out)
    for {set i 1} {$i <= $pred_table($pred,out)} {incr i} {

	set tab_id [lindex $outlist [expr $i-1]]
	set connection [connect_edge $tab_id]
	set delline [lindex $connection 0]
	set partner [lindex $connection 1]
	set partner_p [lindex $connection 2]

	set fromnodedat $pred_table($pred,outgo,$i)
	set fromid [lindex $itemlist [expr [lindex $fromnodedat 0]-1]]
	set from_arglist [list $item_table($fromid,attribute)\
		               $fromid \
			       [lindex $fromnodedat 1]\
			       [lindex $fromnodedat 2]]

	.c delete l$delline

	set line_table($delline,id1) -1
	set attr $item_table($partner_p,attribute)

	switch $attr {
	    ATOM {
		set to_arglist [list ATOM $partner_p]
	    }
	    PRED {
		set intablist $item_table($partner_p,in)
		set outtablist $item_table($partner_p,out)

		set innum [expr [lsearch -exact $intablist $partner]+1]
		if { $innum != -1 } {
		    set to_arglist [list PRED $partner_p IN $innum]
		} {
		    set outnum [expr [lsearch -exact $outtablist $partner]+1]
		    set to_arglist [list PRED $partner_p OUT $outnum]
		}

	    }
	    CONS {
		if { $partner == $partner_p } {
		    set to_arglist [list CONS $partner_p IN 0]
		} {
		    set outtablist $item_table($partner_p,out)
		    set outnum [expr [lsearch -exact $outtablist $partner]+1]
		    set to_arglist [list CONS $partner_p OUT $outnum]
		}
	    }
	    SNOC {
		if { $partner == $partner_p } {
		    set to_arglist [list SNOC $partner_p IN 0]
		} {
		    set outtablist $item_table($partner_p,out)
		    set outnum [expr [lsearch -exact $outtablist $partner]+1]
		    set to_arglist [list SNOC $partner_p OUT $outnum]
		}
	    }
	}

	makeline $from_arglist
	makeline $to_arglist

    }
    .l.sta configure -justify left -text "Predicate $extracted_name Extracted."

    .c delete c$id 

    replace
}

################################################################
#  node_delete id
#
#   桼λؼˤΡɤκ
################################################################

proc node_delete { id } {

    global item_table
    global line_table

    set attr $item_table($id,attribute)

    .c delete c$id
    set item_table($id,attribute) DELETED

    switch -regexp $attr {
	ATOM {
	    set ret [connect_edge $id]
	    set pear [lindex $ret 1]
	    set line [lindex $ret 0]

	    set item_table($pear,edgeid) {}

	    .c delete l$line
	    set line_table($line,id1) -1
	}
	CONS {
	    set ret [connect_edge $id]
	    set pear [lindex $ret 1]
	    set line [lindex $ret 0]

	    set item_table($pear,edgeid) {}

	    .c delete l$line
	    set line_table($line,id1) -1

	    set id1 [lindex $item_table($id,out) 0]
	    set id2 [lindex $item_table($id,out) 1]

	    set ret [connect_edge $id1]
	    set pear [lindex $ret 1]
	    set line [lindex $ret 0]

	    set item_table($pear,edgeid) {}

	    .c delete l$line
	    set line_table($line,id1) -1

	    set ret [connect_edge $id2]
	    set pear [lindex $ret 1]
	    set line [lindex $ret 0]

	    set item_table($pear,edgeid) {}

	    .c delete l$line
	    set line_table($line,id1) -1

	}
	PRED {
	    set inlist $item_table($id,in)
	    set outlist $item_table($id,in)

	    foreach i $inlist {
		set ret [connect_edge $i]
		set pear [lindex $ret 1]
		set line [lindex $ret 0]

		set item_table($pear,edgeid) {}

		.c delete l$line
		set line_table($line,id1) -1
	    }
	    foreach i $outlist {
		set ret [connect_edge $i]
		set pear [lindex $ret 1]
		set line [lindex $ret 0]

		set item_table($pear,edgeid) {}

		.c delete l$line
		set line_table($line,id1) -1
	    }
	}

    }

}

################################################################
#  delete_base x y
#
#   delete줿Ȥν
################################################################

proc delete_base { x y } {

    set id [getclosest $x $y]

    if { "$id"=="" } {
	return
    } {
	node_delete $id
    }
}
    

################################################################
#  snoccons id
#
#   SNOC idȤ³줿 CONS ηԤ
################################################################

proc snoccons { id } {

    global item_table
    global line_table
    global line_last

    ################ ǥե ################

    set info [snoccons_check $id]

    if { "$info" == "FALSE" } { return FALSE } {}

    set delline [lindex $info 0]
    set consid  [lindex $info 1]

    set item_table($id,attribute) DELETED

    foreach i $item_table($id,out) {
	set item_table($i,attribute) DELETED
    }

    .c delete c$id 

    set item_table($consid,attribute) DELETED

    foreach i $item_table($consid,out) {
	set item_table($i,attribute) DELETED
    }

    .c delete c$consid 

    .c delete l$delline
    set line_table($delline,id1) -1

    set snoc1 [lindex $info 2]
    set snoc2 [lindex $info 3]
    set cons1 [lindex $info 4]
    set cons2 [lindex $info 5]

    set dellines [list [lindex $snoc1 0] [lindex $snoc2 0] \
	               [lindex $cons1 0] [lindex $cons2 0] ]

    foreach i $dellines {
	.c delete l$i
	set line_table($i,id1) -1
    }
    
    ################ ե ################

    foreach i {1 2} {

	set idp1 [lindex [subst $[subst snoc$i]] 2]
	set idp2 [lindex [subst $[subst cons$i]] 2]

	set id1 [lindex [subst $[subst snoc$i]] 1]
	set id2 [lindex [subst $[subst cons$i]] 1]

	foreach j {1 2} {

	    set attr $item_table([subst $[subst idp$j]],attribute)

	    switch $attr {

		ATOM {
		    set arglist$j [list ATOM [subst $[subst idp$j]]]
		}
		PRED {
		    set intablist $item_table([subst $[subst idp$j]],in)
		    set outtablist $item_table([subst $[subst idp$j]],out)

		    set innum [expr [lsearch -exact $intablist [subst $[subst id$j]]]+1]
		    if { $innum != -1 } {
			set arglist$j [list PRED [subst $[subst idp$j]] IN $innum]
		    } {
			set outnum [expr [lsearch -exact $outtablist [subst $[subst id$j]]]+1]
			set arglist$j [list PRED [subst $[subst idp$j]] OUT $outnum]
		    }
		}
		CONS {
		    if { [subst $[subst id$j]] == [subst $[subst idp$j]] } {
			set arglist$j [list CONS [subst $[subst idp$j]] IN 0]
		    } {
			set outtablist $item_table([subst $[subst idp$j]],out)
			set outnum [expr [lsearch -exact $outtablist [subst $[subst id$j]]]+1]
			set arglist$j [list CONS [subst $[subst idp$j]] OUT $outnum]
		    }
		}
		SNOC {
		    if { [subst $[subst id$j]] == [subst $[subst idp$j]] } {
			set arglist$j [list SNOC [subst $[subst idp$j]] IN 0]
		    } {
			set outtablist $item_table([subst $[subst idp$j]],out)
			set outnum [expr [lsearch -exact $outtablist [subst $[subst id$j]]]+1]
			set arglist$j [list SNOC [subst $[subst idp$j]] OUT $outnum]
		    }
		}
	    }
	}

	makeline $arglist1
	makeline $arglist2

	.l.sta configure -justify left -text "CONS and SNOC Unificated."
    }

}

################################################################
#  snoccons_check id
#
#    INƱΤ³줿 cons  snoc ǽǤ뤫Ĵ٤
################################################################

proc snoccons_check { id } {

  global item_table
  global line_table

  if { "$item_table($id,attribute)" != "SNOC" } { return FALSE } {}

  set cons [connect_edge $id]
  set lineid [lindex $cons 0]
  set cons_id [lindex $cons 1]
  set cons_pid [lindex $cons 2]

  if { "$item_table($cons_id,attribute)" != "CONS" } { return FALSE } {}  

  set snocout1 [lindex $item_table($id,out) 0]
  set snocout2 [lindex $item_table($id,out) 1]
  set consout1 [lindex $item_table($cons_id,out) 0]
  set consout2 [lindex $item_table($cons_id,out) 1]

  set n1 [connect_edge $snocout1]
  set n2 [connect_edge $snocout2]
  set n3 [connect_edge $consout1]
  set n4 [connect_edge $consout2]

  for {set i 1} {$i <= 4} {incr i} {
      if { [lindex n$i 0] == -1 } { return FALSE } {}
  }

  return [list $lineid $cons_id $n1 $n2 $n3 $n4]

}

################################################################
#  pred_check
#
#   Ÿǽ᤬뤫Ĵ١ŸǽҸ id ΥꥹȤ֤
################################################################

proc pred_check {} {

    global item_table
    global item_last
    global pred_table
    global pred_last

    set predlist {}
    set retlist {}

    for {set i 0} {$i < $item_last} {incr i} {
	if { $item_table($i,attribute)=="PRED" } {
	    lappend predlist $i
	} {}
    }

    foreach i $predlist {

	set num $item_table($i,name)
	set name $pred_table($num,name)

	if { "$name"!="Result" } {
#	    if {"$name"=="append"} {
#		set ret [okcheck $i]
#		if {$ret=="TRUE"} {lappend retlist $i} {}
#	    } {}

            set candpredlist [samenamepreds $name]
            set ret [ok_check $i $candpredlist]
            if {$ret=="TRUE"} {lappend retlist $i} {}
	    
	} {}

    }

    return $retlist
}

################################################################
#  ok_check id list
#
#   id ˤĤƥɥ˥եߤ
################################################################

proc ok_check { id list } {

    global pred_table
    global pred_last
    global item_table
    global item_last

    set predid $item_table($id,name)



    foreach i $list {

	set gardlist {}
	set nodes $pred_table($i,nodes)

	for {set j 1} {$j <= $nodes} {incr j} {

	    set stat $pred_table($i,stat,$j)

	    if {$stat == "gard"} {lappend gardlist $j} {}
	}

	#### Unification Start ####

	if { [llength $gardlist] == 0 } {
	    return TRUE 
	} {}

	if { [llength $gardlist] == 1 } {

	    set gardcontnum [lindex $gardlist 0]
	    set gardcontent $pred_table($i,contents,$gardcontnum)
	    set gardattr [lindex $gardcontent 0]

	    if { $gardattr == "ATOM" } {

		set atomname [lindex $gardcontent 1]

		set ins $pred_table($i,in)
		for {set k 1} {$k <= $ins} {incr k} {
		    set num [lindex $pred_table($i,into,$k) 0]
		    if {$num == $gardcontnum} {
			set into_atom $k
			break
		    } {}
		}
		
		# k ˤϡܤΰΥɤؤϤäƤ롥

		set pear2 [lindex $item_table($id,in) [expr $k-1]]
		set pear [lindex [connect_edge $pear2] 1]

		set pearattr $item_table($pear,attribute)

		if { $pearattr != "ATOM" } { continue } {}

		set pearname $item_table($pear,name)

		if { $atomname == $pearname } { 
		    # ŸơɤνҸŸ뤫
		    # table ˽񤭤Ǥ
		    set item_table($id,name) $i
		    return TRUE
		} {
		    continue
		}

	    } {}   ;# ATOMΥ˥ե󤳤ޤ

	    if { $gardattr == "SNOC" } {

		set ins $pred_table($i,in)
		for {set k 1} {$k <= $ins} {incr k} {
		    set num [lindex $pred_table($i,into,$k) 0]
		    if {$num == $gardcontnum} {
			set into_atom $k
			break
		    } {}
		}
		
		# k ˤϡܤΰΥɤؤϤäƤ롥
		set pear2 [lindex $item_table($id,in) [expr $k-1]]
		set pear [lindex [connect_edge $pear2] 1]

		set pearattr $item_table($pear,attribute)

		if { $pearattr != "CONS" } { continue } {}

		# ŸơɤνҸŸ뤫
		# table ˽񤭤Ǥ
		set item_table($id,name) $i
		return TRUE

	    } {}   ;# SNOCΥ˥ե󤳤ޤ

	    if { $gardattr == "PRED" } {

		set gardpredid [lindex $gardcontent 1]
		set gardpredname $pred_table($gardpredid,name)
		set gardpredgroup $pred_table($gardpredid,group)

		if { $gardpredgroup == "BODY" } { continue } {}

		set ins $pred_table($i,in)
		for {set k 1} {$k <= $ins} {incr k} {
		    set num [lindex $pred_table($i,into,$k) 0]
		    if {$num == $gardcontnum} {
			set into_atom $k
			break
		    } {}
		}
		
		# k ˤϡܤΰΥɤؤϤäƤ롥
		set pear2 [lindex $item_table($id,in) [expr $k-1]]
		set pear [lindex [connect_edge $pear2] 1]

		# prar ˡ³idäƤ롥

		case $gardpredname {
		    atomic {
			set ret [g_atomic $pear]
		    }
		    integer {
			set ret [g_integer $pear]
		    }
		    atom {
			set ret [g_atom $pear]
		    }
		    not_atomic {
			set ret [g_not_atomic $pear]
		    }
		    not_integer {
			set ret [g_not_integer $pear]
		    }
		    not_atom {
			set ret [g_not_atom $pear]
		    }
		    default {
			continue
		    }
		}

		if { $ret == "false" } { continue } {}

		set item_table($id,name) $i
		return TRUE

	    } {}   ;# ɽҸΥ˥ե󤳤ޤ
	

	} {
	}

    }

    return FALSE
}

################################################################
#  samenamepreds name
#
#   name Ȥ̾ pred_id ΥꥹȤ֤
################################################################

proc samenamepreds { name } {

    global pred_table
    global pred_last

    set ret {}

    for {set i 0} {$i < $pred_last} {incr i} {

	if { $name == $pred_table($i,name) } {
	    lappend ret $i
	} {}
    }

    return $ret

}

################

proc okcheck { id } {

    global item_table
    global line_table

    set in1 [lindex $item_table($id,in) 0]
    set pear [lindex [connect_edge $in1] 2]
    
    set pearattr $item_table($pear,attribute)

    if {"$pearattr"=="ATOM"} {
	set item_table($id,name) 1  ;#Τؤ󤬥ϥå
    } {}

    return TRUE

}

################################################################
#  atomunif id1 id2
#
#    ȥƱΤΥ˥ե
################################################################

proc atomunif { id1 id2 } {

    global item_table
    global line_table

    set lineid $item_table($id1,edgeid)

    set name1 $item_table($id1,name)
    set name2 $item_table($id2,name)

    if { $name1 == $name2 } {
	.c delete l$lineid
	.c delete c$id1
	.c delete c$id2

	set item_table($id1,attribute) DELETED
	set item_table($id2,attribute) DELETED
	set line_table($lineid,id1) -1

	.l.sta configure -text "Atom Unification"
    } {}

    return
}


################################################################
#  all_clear
#
#   ̤ӥơ֥Υꥢ
################################################################

proc all_clear {} {

    global item_table
    global line_table
    global item_last
    global line_last

    for {set i 0} {$i < $item_last} {incr i} {
	set attr $item_table($i,attribute)
	if { [regexp (PRED|ATOM|CONS|SNOC|DAMMY) $attr] } {
	    .c delete c$i
	} {}
    }

    for {set i 0} {$i < $line_last} {incr i} {
	if { $line_table($i,id1) != -1 } {
	    .c delete l$i 
	} {}
    }

    unset item_table
    unset line_table
    set item_last 0
    set line_last 0

    .l.sta configure -text ""
}

################################################################
#  get_pred_last
#
#   pred_last ֤ͤ(klitclƤФ)
################################################################

proc get_pred_last {} {

    global pred_last

    scan $pred_last %d pred_tmp
    set pred_last $pred_tmp        ;#;פʲԥк

puts ($pred_last)
    return $pred_last
}

################################################################
#  get_name_number name
#
#   nameбPredID֤(klitclƤФ)
################################################################

proc get_name_number { name } {

    global pred_table
    global pred_last

    for {set i 0} {$i < $pred_last} {incr i} {

	if { [exist_check $i] == 0 } {
	    if { $name == $pred_table($i,name) } {
		return $i
	    } {}
	} {}
    }

    return 999
}

proc exist_check { i } {

    global pred_table

    catch { set dam $pred_table($i,name) } err

    if { [string range $err 0 9] == "can't read" } {
	return 1
    } {
	return 0
    }

}

################################################################
#  get_in_args name
#
#   nameФpredϰ֤(klitclƤФ)
################################################################

proc get_in_args { name } {

    global pred_table
    global pred_last

    if { $name == "=" } { return 1 } {}

    for {set i 0} {$i < $pred_last} {incr i} {
	if { $name == $pred_table($i,name) } {
	    return $pred_table($i,in)
	} {}
    }

    return 0
}

################################################################
#  viewpp_exit
#
#    λФ
################################################################

proc viewpp_exit {} {

    set ret [tk_dialog .exit "viewPP exit" "Reary Exit?" question 0 Yes No]

    if { $ret == 0 } {
	exit 
    } {
	return
    }

}

################################################################
#  getclosest x y
#
#   (x,y) ˰ֶᤤ tag 
################################################################

proc getclosest { x y } {

    global id_tag_table

    set id [.c find overlapping $x $y $x $y]

    if { "$id" == "" } { return "" } {}

    return $id_tag_table($id)

}

################################################################
#  load_file_base 
#
#    եΥ
################################################################

proc load_file_base {} {

    global pred_last
    global pred_table

#    exec rm /tmp/viewpptmp.tcl

    set file [load_file]

    if { $file == "" } {destroy .lf;return} {}

    puts ($file)

    klic main makepredtable $file

    while { ([file exists /tmp/viewpptmp.tcl] == 0) } {
	after 1000
    }

    after 2000

    destroy .lf

    .l.sta configure -text "Load Complete."

}

proc source_tmp {} {
    
    global pred_last
    global pred_table

    source /tmp/viewpptmp.tcl

    make_pred_menu

}

################################################################
#  make_pred_menu
#
#   ҸΥ˥塼
################################################################

proc make_pred_menu {} {

    global pred_table
    global pred_last

    scan $pred_last %d pred_tmp
    set pred_last $pred_tmp        ;#;פʲԥк

    set namelist {}
    .m.p delete 0 last

    for {set i 0} {$i < $pred_last} {incr i} {

	set name $pred_table($i,name)
	set group $pred_table($i,group)
	set ality [expr $pred_table($i,in)+$pred_table($i,out)]
	
	set labelname $name/$ality

	if { [lsearch -exact $namelist $labelname] != -1 } { continue } {}
	if { $group == "GARD" } { continue } {}

	lappend namelist $labelname

	.m.p add command -label $labelname \
		-command "set pushed_pred $i;set pushed Pred"
    }
}


################################################################

#### ¢Ҹ Pred Table ####

set pred_last 7
# set pred_table(0,name) append
# set pred_table(0,in) 2
# set pred_table(0,out) 1
# set pred_table(0,nodes) 3
# set pred_table(0,lines) 3
# set pred_table(0,contents,1) {SNOC}
# set pred_table(0,contents,2) {CONS}
# set pred_table(0,contents,3) {PRED 0}
# set pred_table(0,line,1,1) {1 OUT 1}
# set pred_table(0,line,1,2) {2 OUT 1}
# set pred_table(0,line,2,1) {1 OUT 2}
# set pred_table(0,line,2,2) {3 IN 1}
# set pred_table(0,line,3,1) {2 OUT 2}
# set pred_table(0,line,3,2) {3 OUT 1}
# set pred_table(0,into,1) {1 IN 1}
# set pred_table(0,into,2) {3 IN 2}
# set pred_table(0,outgo,1) {2 IN 1}

# set pred_table(1,name) append
# set pred_table(1,in) 2
# set pred_table(1,out) 1
# set pred_table(1,nodes) 2
# set pred_table(1,lines) 0
# set pred_table(1,contents,1) {ATOM "[]"}
# set pred_table(1,contents,2) {DAMMY}
# set pred_table(1,into,1) {1 IN 1}
# set pred_table(1,into,2) {2 IN 1}
# set pred_table(1,outgo,1) {2 OUT 1}

set pred_table(0,name) Result
set pred_table(0,group) BODY
set pred_table(0,in) 1
set pred_table(0,out) 0

set pred_table(1,name) atom
set pred_table(1,group) GARD
set pred_table(1,in) 1
set pred_table(1,out) 1
set pred_table(1,nodes) 1
set pred_table(1,lines) 0
set pred_table(1,contents,1) {DAMMY}
set pred_table(1,stat,1) {body}
set pred_table(1,into,1) {1 IN 1}
set pred_table(1,outgo,1) {1 OUT 1}

set pred_table(2,name) atomic
set pred_table(2,group) GARD
set pred_table(2,in) 1
set pred_table(2,out) 1
set pred_table(2,nodes) 1
set pred_table(2,lines) 0
set pred_table(2,contents,1) {DAMMY}
set pred_table(2,stat,1) {body}
set pred_table(2,into,1) {1 IN 1}
set pred_table(2,outgo,1) {1 OUT 1}

set pred_table(3,name) integer
set pred_table(3,group) GARD
set pred_table(3,in) 1
set pred_table(3,out) 1
set pred_table(3,nodes) 1
set pred_table(3,lines) 0
set pred_table(3,contents,1) {DAMMY}
set pred_table(3,stat,1) {body}
set pred_table(3,into,1) {1 IN 1}
set pred_table(3,outgo,1) {1 OUT 1}

set pred_table(4,name) not_atom
set pred_table(4,group) GARD
set pred_table(4,in) 1
set pred_table(4,out) 1
set pred_table(4,nodes) 1
set pred_table(4,lines) 0
set pred_table(4,contents,1) {DAMMY}
set pred_table(4,stat,1) {body}
set pred_table(4,into,1) {1 IN 1}
set pred_table(4,outgo,1) {1 OUT 1}

set pred_table(5,name) not_atomic
set pred_table(5,group) GARD
set pred_table(5,in) 1
set pred_table(5,out) 1
set pred_table(5,nodes) 1
set pred_table(5,lines) 0
set pred_table(5,contents,1) {DAMMY}
set pred_table(5,stat,1) {body}
set pred_table(5,into,1) {1 IN 1}
set pred_table(5,outgo,1) {1 OUT 1}

set pred_table(6,name) not_integer
set pred_table(6,group) GARD
set pred_table(6,in) 1
set pred_table(6,out) 1
set pred_table(6,nodes) 1
set pred_table(6,lines) 0
set pred_table(6,contents,1) {DAMMY}
set pred_table(6,stat,1) {body}
set pred_table(6,into,1) {1 IN 1}
set pred_table(6,outgo,1) {1 OUT 1}

################################################################
#ᥤ롼
################################################################

wm title . "viewPP"

frame .f

image create photo filebutton -format ppm -file "bitmap/file.ppm"
image create photo repbutton -format ppm -file "bitmap/replace.ppm"
image create photo exebutton -format ppm -file "bitmap/exec.ppm"
image create photo clrbutton -format ppm -file "bitmap/clear.ppm"
image create photo exitbutton -format ppm -file "bitmap/exit.ppm"

button .f.b_fil -width 48 -height 32 -image filebutton \
	-command "load_file_base"
button .f.b_rep -width 48 -height 32 -image repbutton \
	-command "replace_base FALSE"
button .f.b_exe -width 48 -height 32 -image exebutton \
	-command "replace_base TRUE"
label  .f.pad1  -relief raise
button .f.b_clr -width 48 -height 32 -image clrbutton -command all_clear
button .f.b_exi -width 48 -height 32 -image exitbutton -command viewpp_exit

bind .f.b_fil <Enter> {.l.sta configure -text "Load File"}
bind .f.b_fil <Leave> {.l.sta configure -text ""}
bind .f.b_rep <Enter> {.l.sta configure -text "Replace Program"}
bind .f.b_rep <Leave> {.l.sta configure -text ""}
bind .f.b_exe <Enter> {.l.sta configure -text "Execution Program"}
bind .f.b_exe <Leave> {.l.sta configure -text ""}
bind .f.b_clr <Enter> {.l.sta configure -text "Clear Field"}
bind .f.b_clr <Leave> {.l.sta configure -text ""}
bind .f.b_exi <Enter> {.l.sta configure -text "Exit viewPP"}
bind .f.b_exi <Leave> {.l.sta configure -text ""}

canvas .c -width 700 -height 500 -relief sunken
bind .c <Button-1> { itemput %x %y %X %Y }
bind .c <Delete> { }

frame .l
label .l.lab  -width 8 -text Status: -relief raise
label .l.sta  -relief sunken -text "Welcome to viewPP!"

pack .f .c .l -fill x
focus .c
bind .c <Delete> "delete_base %x %y"

pack .f.b_fil .f.b_rep .f.b_exe  -side left
pack .f.pad1 -side left -fill both -expand 1
pack .f.b_exi .f.b_clr -side right
pack .l.lab -side left
pack .l.sta -side right -fill x -expand 1

menu .m -tearoff 0
.m add cascade -label Predicate -menu .m.p
.m add command -label Atom -command {set pushed Atom}
.m add command -label Cons -command {set pushed Cons}

menu .m.p -tearoff 0

if { [file exists /tmp/viewpptmp.tcl] == 1 } {
    exec rm /tmp/viewpptmp.tcl
} {}

make_pred_menu

##(eof)#########################################################
