/* Copyright (C) 1996 Shigeyuki Nakagawa */
#include <sys/time.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

static int sock;
static struct sockaddr_un saun;
static char buf[1024];

FILE *fp;

/* $B%=%1%C%H$X$N@\B3(B */
static int connect_socket( char *address )
{
    int len;

    sock = socket(AF_UNIX,SOCK_STREAM,0);
    if ( sock < 0 ) return -1;

    saun.sun_family = AF_UNIX;
    strcpy(saun.sun_path,address);
    
    len = sizeof(saun.sun_family) + strlen(saun.sun_path);

    if ( connect(sock,&saun,len) < 0 ) return -1;

    return sock;
}

/* $B%=%1%C%H$H$N@\B3$rJD$8$k(B */
static void close_socket()
{
    close(sock);
}

/* $BJ8;zNs(B str $B$N@hF,$K(B prefix $B$,4^$^$l$F$$$k$+D4$Y$k(B */
static int str_prefix_check( char *str, char *prefix )
{
    while ( *prefix != '\0' )
	if ( *str++ != *prefix++ ) return 1;

    return 0;
}

/* $B%a%$%s(B */
int main ( int argc, char **argv )
{
    int nfds, sokds;
    fd_set readfds;

    if ( argc == 1 ) {
	puts("usage: ndbconsole <pathname>");
	exit(1);
    }

    sokds = connect_socket(argv[1]);
    if ( sokds < 0 ) {
	perror("ndbconsole");
	exit(1);
    }

    while (1) {

	FD_ZERO(&readfds);
	FD_SET(0,&readfds);
	FD_SET(sokds,&readfds);

	nfds = select(sokds+1,&readfds,NULL,NULL,NULL);

	if ( nfds > 0 ) {

	    if ( FD_ISSET(0,&readfds) != 0 ) {

		int n = read(0,buf,sizeof(buf));

		if ( n == 0 ) break;
		buf[n-1] = '\n';
		send(sokds,buf,n,0);

	    } else if ( FD_ISSET(sokds,&readfds) != 0 ) {

		int n = read(sokds,buf,sizeof(buf));

		if ( n == 0 ) break;
		buf[n] = '\0';
/*		if ( str_prefix_check(buf,"@@@CLOSE@@@") == 0 ) */
		if ( strstr(buf,"@@@CLOSE@@@") != NULL )
		    break;
		printf("%s",buf);
		fflush(stdout);

	    }
	}
    }

    close_socket();

    exit(0);
}

