% Copyright (C) 1997 $BBgFb(B $BBs<B(B
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%   rule of replacement.
%%%
%%% 'fff1_'  --->  'R1= ,function:'
%%% '),fff2_' ---> ',R1,R2),function:'
%%% '),fff3_' ---> ',R2,R3),function:'
%%%   ....
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


%% definition of domain.
% #1
domain(D), {
	fff1_pick_up(D,1,X,R)} --> dom(X,1), tmp_domain(R,2).
% #2
tmp_domain(D,N), {
	fff1_pick_up(D,1,X,R), 
	fff2_plus(N,1,N1)} --> dom(X,N), tmp_domain(R,N1).
% #3
tmp_domain([],N) --> n_of_terms(N).


%% t \in Domain, A --> A{x/t}.  (( x is one of variables in A. ))
% #4
dom(T,N), pr(A), {
	fff1_atom(A), 
	fff2_var(A,1,V), 
	fff3_subst2(A,[{V,T}],B)} --> pr(B).


%% resolution. 
% #5
pr(A), pr(imp(B,C)), {
	fff1_ground(A), 
	fff2_subst1(B,S,A), 
	fff3_subst2(C,S,D)} --> pr(D).


%% facts.
% #6
pos(A,I) --> fact(A).

% #7
pr(A), {fff1_atom(A),
	fff2_ground(A)} --> fact(A).



%% truncation. (from facts (containing examples and background knowledge))
% #8
fact(A), dom(T,N), {
	fff1_term_in_clause(T,A), 
	fff2_inv_subst(A,[T],H),
	fff3_subst1(H,S,A), 
	fff4_elem_of_subst1(S,1,V,T1),
	fff5_eq(T,T1)} --> hyp(H,V,[{T,N}]).

% #
fact(A), hyp(H,V), dom(T,N), {
	fff1_subst2(H,[{V,T}],B), 
	fff2_eq(A,B)} --> hyp(H,V,[{T,N}]).


%% truncation. (from hypotheses confirmed)
% #
hyp(H,V0), dom(T,N), {
	fff1_term_in_clause(T,H),
	fff2_inv_subst(H,[T],NewH),
	fff3_subst1(NewH,S,H), 
	fff4_elem_of_subst3(S,V,T)} --> hyp(NewH,V,[{T,N}]).

% #
hyp(H0,V0), hyp(H,V), dom(T,N), {
	fff1_subst2(H,[{V,T}],H1),
	fff2_eq(H0,H1)} --> hyp(H,V,[{T,N}]).



% #
hyp(H,V,Ts) --> hyp(H,V) ; neg_hyp(H,V).

% #
hyp(H,V), neg_hyp(H,NV) --> false.



%% neg-example is deducted. --> specialize hypothesis. (W-operator)
% #
neg(A,I), hyp(H,V), dom(T,N), {
	fff1_subst2(H,[{V,T}],B),
	fff2_eq(A,B)} --> neg_hyp(H,V,[{T,N}]).

% #
neg_hyp(NH,NV,NTs), hyp(H,V), dom(T,N), {
	fff1_subst2(H,[{V,T}],H1),
	fff2_eq(NH,H1)} --> neg_hyp(H,V,[{T,N}]).

% #
neg_hyp(H,V,Ts) --> neg_hyp(H,V).


%% Intra-construction (W-operator)
% #
neg_hyp(H,NV), hyp(H,V,Ts), hyp(A,V1,Ts1), {
	fff1_length(H,Len),
	fff2_less(Len,3),
	fff3_atom(A),
	fff4_num_of_vars(A,1),
	fff5_subset(Ts1,Ts),
	fff6_var_temp(A,A1),
	fff7_subst1(A,TempS,A1), 
	fff8_elem_of_subst2(TempS,V1,V2),
	fff9_subst2(imp(A1,H),[{V2,V}],NewH)} --> hyp(NewH,V) ; neg_hyp(NewH,V).


% #
hyp(H,V) --> deriv(H).


% #
fact(A), deriv(imp(B,C)), {
	fff1_subst1(B,S,A),
	fff2_subst2(C,S,D)} --> deriv(D).

% #
fact(A), deriv(imp(B,C)), neg(D,J), dom(T,N), {
	fff1_subst1(B,S,A),
	fff2_subst2(C,S,C1),
	fff3_eq(C1,D),
	fff4_elem_of_subst1(S,1,V,T1),
	fff5_eq(T,T1)} --> neg_hyp(imp(B,C),V,[{T,N}]).

% #
fact(A), deriv(imp(B,C)), neg_hyp(D,NV), dom(T,N), {
	fff1_subst1(B,S,A),
	fff2_subst2(C,S,C1),
	fff3_eq(C1,D),
	fff4_elem_of_subst1(S,1,V,T1),
	fff5_eq(T,T1)} --> neg_hyp(imp(B,C),V,[{T,N}]).






%% Domain = {a,b,c,d}
%true --> dom(a), dom(b), dom(c), dom(d).
true --> domain([a,b,c,d]).

%% true --> p(X,X).
true --> pr([p,var(0),var(0)]).

%% true --> q(a,b), q(b,c), q(c,d).
true --> pr([q,a,b]), pr([q,b,c]), pr([q,c,d]).

%% p(X,Y), q(Y,Z) --> p(X,Z).
true --> pr(imp([p,var(0),var(1)],imp([q,var(1),var(2)],[p,var(0),var(2)]))). 

%% pos
true --> pos([r,a,a],1), pos([r,a,b],2), pos([r,a,c],3), pos([r,a,d],4),
	 pos([r,b,b],5), pos([r,b,c],6), pos([r,b,d],7), 
	 pos([r,c,c],8), pos([r,c,d],9), 
	 pos([r,d,d],10).

%% neg
true --> neg([r,b,a],1), neg([r,c,a],2), neg([r,c,b],3), neg([r,d,c],4), neg([r,d,b],5),
	 neg([r,d,a],6).
