/******  Hypothetical Reasoning System                    ********/
/******  using Networked Bubble Propagation (NBP) method  ********/
/******  -- Predicate Logic version --- NBP1              ********/
/******                                                   ********/
/******  Copyright(C) 1996  Yukio Ohsawa, Mitsuru Ishizuka, ******/
/******                     Hirishi Dohi and Masahiro Itoh  ******/
/******                                                   ********/
/******           1996.4  Ishizuka Lab.                   ********/
/******                   Dept. of Info. and Commun. Eng. ********/
/******                   Univ. of Tokyo                  ********/
/******                                                   ********/

#include <stdio.h>
#include <sys/time.h>
#include <sys/resource.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>

#include <tcl.h>
#include <tk.h>

    Display      *d, *d1;
    Tk_Window    tkwin, tkwin1;
    Tcl_Interp   *interp;
    Tk_3DBorder  border;

    Window       w;

    int *x_axis, *y_axis, iks, wai;
    unsigned long blue,white, black,green,red, MyColor(); 
    void  draws_angle(),draws_circle(),draws_line(),draws_node(),shows_graph(),
          draws_num();
    GC gc, gc1;
    double cputime,cputime1,cputime2;
struct rusage rus;

/* Stays constant */
int bnk,nd_max,right_num,divc,in_ex,*is_inc,*is_goal,*and_ch,*and_chlds;
int *atr,*stt,*strctr,str_num, *slack,slk_num,*srnd_num,*link,link_num,x,*rght_sonae,
	*srnd, ttl_node,node,node_1,*core,*papa,*papa_num,*sugu_ue,*leaf,*lttr,*br_num,	
	*lft_bnk,*and_left,and_num,*bound,inc,goal,*chld,*chld_num,global,cycle_num;
double *uppr,*lwr,*rel;

/* Works hard, always */
int  rch,*mark1,*beer,ch_out,*in_arr,*out_arr,*arrow;
double *value,*cost;

/* Initialized every exchange */
double bst_cst;
double cmp;
/* Initialiized in smaller loops*/
int grp_num,nst_num,*mark2,flg_out,*can_nst,
    *lnk_of_nst,*tukatta,*times,
    *nst_th, nxt,sum,init_num,sm1_end,cand_num;
double min_ch,minch1,*diff,*rate,now_aus;


#define SCALE 10
#define WORDS  100
#define STRUCT 500
#define SLACK  500
#define ALL   1000
#define CIRCUM 50
#define GROUP  10
#define NEST   500
#define DEPTH   20
#define DENSE  2

FILE *fp,*fopen();


void   solves(), arrower(),arrow_sub(),arrow_back(),set_true();
void  impr(),symplex(),relative(),waitme(),input_newversion();
void  period(),  collon(), slct_wh();
void  initializer(),shows_net(),shows_net2(),compare();
void outputs(),shows_value(),shows_value2(),shows_change();
int trial(),trial_sub() ,impr_sub(),new_strctr(),new_slack(),
    prpgt() ,approx(),impr_sub(),abs_i(),
    exchange(),perifec(),selects(),search(),hihn(),simpl2();
double  abs_f(), flt();

/***************  Tcl $B$N$?$a$K(B *********************/
int   Nbp0(), Nbp1(), Nbp2(),
      Nbp3(), Nbp4(), Nbp5(), Nbp6(), Nbp7(), Go(), Edit(),
      Input(), Redraw();
void  Reshow();
int   step, mode, offset;
double  bai;
char  *name;
void  fralc();
/*****The COST FUNCTION is defined only as a default coefficients!!!!!!****/

		/*************************/
		/****  For a dieting   ***/
		/*************************/


int i,j,i1,j1,choice,init_rch,br,t,pig,*parity,illegal;
double v;
int tcl;
XSetWindowAttributes a;
unsigned long fg, bg;
XGCValues gcv, gcv1;
XFontStruct *font;
       
/***************  Itoh   *******************/
char *num;
void shows_step();

main(argc,argv)
int     argc;
char    *argv[];
	{
	    static char *display = NULL;
	    interp  = Tcl_CreateInterp();
	    tkwin   = Tk_CreateMainWindow(interp, NULL, "nbp", "Nbp"); 
	    
	    Tk_MapWindow(tkwin);   

	    if (tkwin == NULL) {
		fprintf(stderr, "%s\n", interp->result);
		exit(1);
	    }
	    
	    if (Tcl_Init(interp) == TCL_ERROR) {
		fprintf(stderr, "Tcl_Init failed: %s\n", interp->result);
	    }
	    if (Tk_Init(interp) == TCL_ERROR) {
		fprintf(stderr, "Tk_Init failed: %s\n", interp->result);
	    }

	    bai = 1.0;
	    offset = 0;
/*
	    d       = Tk_Display(tkwin);
	    w       = Tk_WindowId(tkwin);  
	    
	    font = XLoadQueryFont(d, "fixed");
	    bg = WhitePixel(d, DefaultScreen(d));
	    fg = BlackPixel(d, DefaultScreen(d));

	    green=MyColor(d, "green");
	    red=MyColor(d, "red");
	    black=MyColor(d, "black");
	    blue=MyColor(d, "blue");
	    white=MyColor(d, "white");

	    gcv.font = font->fid; gcv.foreground = fg; gcv.background = bg;
	    gc = XCreateGC (d, w,GCFont | GCForeground | GCBackground, &gcv);

	    XFlush(d);
*/
	    Tcl_CreateCommand(interp, "go", Go, (ClientData) NULL,
			      (Tcl_CmdDeleteProc *) NULL);
	    Tcl_CreateCommand(interp, "main0", Nbp0, (ClientData) NULL,
			      (Tcl_CmdDeleteProc *) NULL);
	    Tcl_CreateCommand(interp, "main1", Nbp1, (ClientData) NULL,
			      (Tcl_CmdDeleteProc *) NULL);
	    Tcl_CreateCommand(interp, "main2", Nbp2, (ClientData) NULL,
			      (Tcl_CmdDeleteProc *) NULL);
	    Tcl_CreateCommand(interp, "main3", Nbp3, (ClientData) NULL,
			      (Tcl_CmdDeleteProc *) NULL);
	    Tcl_CreateCommand(interp, "main4", Nbp4, (ClientData) NULL,
			      (Tcl_CmdDeleteProc *) NULL);
	    Tcl_CreateCommand(interp, "main5", Nbp5, (ClientData) NULL,
			      (Tcl_CmdDeleteProc *) NULL);
	    Tcl_CreateCommand(interp, "main6", Nbp6, (ClientData) NULL,
			      (Tcl_CmdDeleteProc *) NULL);
	    Tcl_CreateCommand(interp, "main7", Nbp7, (ClientData) NULL,
			      (Tcl_CmdDeleteProc *) NULL);
	    Tcl_CreateCommand(interp, "edit", Edit, (ClientData) NULL,
			      (Tcl_CmdDeleteProc *) NULL);
	    Tcl_CreateCommand(interp, "input", Input, (ClientData) NULL,
			      (Tcl_CmdDeleteProc *) NULL);
	    Tcl_CreateCommand(interp, "redraw", Redraw, (ClientData) NULL,
			      (Tcl_CmdDeleteProc *) NULL);
		    
	    
/*	    Tk_CreateEventHandler(tkwin, ExposureMask|StructureNotifyMask,
				  Reshow, (ClientData) NULL);
	*/    
	    Tcl_Eval(interp, "wm minsize . 1 1");
	    Tcl_Eval(interp, "wm maxsize . 1500 1000");
	    Tcl_Eval(interp, "wm geometry . 1000x600"); 
	    Tcl_Eval(interp, "wm geometry . +60+100");
/*	    Tcl_Eval(interp, "canvas .canvas -yscrollcommand {.scroll set} 
                              scrollbar .scroll -command {.canvas yview}
                              pack .scroll -side right -fill y
                              pack .canvas -side left -fill both
                              focus .canvas
                              focus .scroll
");  */
	    Tcl_LinkVar(interp, "mode", (char *) &mode, TCL_LINK_INT);
	    Tcl_LinkVar(interp, "step", (char *) &step, TCL_LINK_INT);
	    Tcl_LinkVar(interp, "bai",  (char *) &bai,  TCL_LINK_DOUBLE);
	    Tcl_LinkVar(interp, "name", (char *) &name, TCL_LINK_STRING);
	    Tcl_LinkVar(interp, "offset", (char *) &offset, TCL_LINK_INT);

/**********     $B$3$3$+$i!"%W%m%7!<%8%c$N@_Dj(B    **************/

	    Tcl_Eval(interp, "

         proc loadFile file {
            .edit.top.text delete 1.0 end
            set f [open $file]
            while {![eof $f]} {
                 .edit.top.text insert end [read $f 1000]
            }
            close $f

         proc saveFile file {
            set fs [open $file w+]
            puts -nonewline $fs [edit.top.text get 1.0 end]
            flush $fs
            close $fs
         }");

/**********     $B$3$3$+$i!"%a%K%e!<$N@_Dj(B     ****************/

	    Tcl_VarEval(interp, "
       frame .mbar -relief raised -bd 2
       pack .mbar -side top -fill x
       menubutton .mbar.file -text File -underline 0 \
                             -menu .mbar.file.menu
       menubutton .mbar.option -text Option -underline \
                            0 -menu .mbar.option.menu
       pack .mbar.file .mbar.option -side left
       menu .mbar.file.menu 
       .mbar.file.menu add command -label Editor -command \
                                {edit $name} -underline 0 
       .mbar.file.menu add separator
       .mbar.file.menu add command -label \
                          Quit -underline 0 -command exit
       menu .mbar.option.menu
       .mbar.option.menu add cascade -label Mode \
                   -underline 0 -menu .mbar.option.menu.mode
       .mbar.option.menu add separator
       .mbar.option.menu add cascade -label Zoom \
                        -underline 0 -menu .mbar.option.menu.zoom
       menu .mbar.option.menu.mode
       .mbar.option.menu.mode add radiobutton -label \
                                 {non     stop} -variable mode -value 0
       .mbar.option.menu.mode add radiobutton -label \
                                 {step by step} -variable mode -value 1       
       menu .mbar.option.menu.zoom
       .mbar.option.menu.zoom add radiobutton -label {*0.5} \
                     -variable bai -value 0.5 -command redraw 
       .mbar.option.menu.zoom add radiobutton -label {*0.8} \
                     -variable bai -value 0.8 -command redraw
       .mbar.option.menu.zoom add radiobutton -label {*1} \
                     -variable bai -value 1.0 -command redraw
       .mbar.option.menu.zoom add radiobutton -label {*1.2} \
                     -variable bai -value 1.2 -command redraw
       .mbar.option.menu.zoom add radiobutton -label {*1.5} \
                     -variable bai -value 1.5 -command redraw
       tk_menuBar .mbar .mbar.file .mbar.option
       focus .mbar", (char *)NULL);

/**********   Setting for canvas and scroll **********/

/*	    Tcl_Eval(interp, "frame .canvas -yscrollcommand {.scroll set} 
                              scrollbar .scroll -command {.canvas yview}
                              pack .scroll -side right -fill y
                              pack .canvas -side left -expand 1 -fill both
                              focus .canvas
");
*/
	    Tcl_Eval(interp, "scrollbar .scroll
                              pack .scroll -side right -fill y
");
		    
/**********      $B$3$3$+$i!"%\%?%s$NDj5A!J=i4|@_Dj!K(B   ***********/

	    Tcl_Eval(interp, "button .c -text Exec
	                      pack .c");
	    Tcl_Eval(interp, "bind .c <Button-1> {go $name}");  
	    
/*	    Tcl_Eval(interp, "button .d -text Quit -command exit");
	    Tcl_Eval(interp, "pack .d");
*/
/**********     Setting for X   **********/

/*	    tkwin1  = Tk_NameToWindow(interp, ".canvas", tkwin);
*/
	    d       = Tk_Display(tkwin);
	    w       = Tk_WindowId(tkwin);  
	    
	    font = XLoadQueryFont(d, "fixed");
	    bg = WhitePixel(d, DefaultScreen(d));
	    fg = BlackPixel(d, DefaultScreen(d));

	    green=MyColor(d, "green");
	    red=MyColor(d, "red");
	    black=MyColor(d, "black");
	    blue=MyColor(d, "blue");
	    white=MyColor(d, "white");

	    gcv.font = font->fid; gcv.foreground = fg; gcv.background = bg;
	    gc = XCreateGC (d, w,GCFont | GCForeground | GCBackground, &gcv);

	    XFlush(d);

/**********    End the setting and go to loop  **********/
	    Tk_CreateEventHandler(tkwin, ExposureMask|StructureNotifyMask,
				  Reshow, (ClientData) NULL);

	    Tk_MainLoop();

}	    
/******************  $B$3$3$+$i$O!"(BTcl $B$N%3%^%s%I$NDj5A!*(B  *************/

int Input(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[])
{
    if(argc==1) {
	Tcl_VarEval(interp, "
             toplevel .input
             label .input.label -text {File name:}
             entry .input.entry -width 20 -relief sunken -bd 2 \
                              -textvariable name
             pack .input.label .input.entry -side left -padx 1m -pady 2m
             bind .input.entry <Return> {destroy .input}
             set x [expr [winfo rootx .] + [winfo width .]/3]
             set y [expr [winfo rooty .] + [winfo height .]/3]
             wm geometry .input +$x+$y                   
             tkwait window .input             
          ", (char *)NULL);
    }       

    if(argc>1) {
	if(name == NULL) 
	    name = "";

	Tcl_Eval(interp, "
        proc file_entry {parent} {
             global w
             set w $parent
             toplevel $w.input
             label $w.input.label -text {File name:}
             entry $w.input.entry -width 20 -relief sunken -bd 2 \
                              -textvariable name
             pack $w.input.label $w.input.entry -side left -padx 1m -pady 2m
             bind $w.input.entry <Return> {destroy $w.input
                                           if {$which==1} {loadFile $name}
                                           if {$which==4} {saveFile $name}}
             set x [expr [winfo rootx $w] + [winfo width $w]/3]
             set y [expr [winfo rooty $w] + [winfo height $w]/3]
             wm geometry $w.input +$x+$y             
          }");
	Tcl_VarEval(interp, "file_entry ", argv[1], (char *)NULL);
    }
    return(TCL_OK);
}


int Go(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) 
{
    if(name == NULL) {
	name = "";
	Tcl_Eval(interp, "input");
	argv[1] = name;
	printf("%s",argv[1]);
    }

    printf("mode = %d\n",mode);
    if(mode == 1) {
	while(step > 7)  {
	    step = step - 8;
	}
	
	switch (step)  {
	case 0: Tcl_VarEval(interp, "main0 ", argv[1], (char *)NULL);  break;
	case 1: Tcl_VarEval(interp, "main1 ", argv[1], (char *)NULL);  break;  
	case 2: Tcl_VarEval(interp, "main2 ", argv[1], (char *)NULL);  break;  
	case 3: Tcl_VarEval(interp, "main3 ", argv[1], (char *)NULL);  break;  
	case 4: Tcl_VarEval(interp, "main4 ", argv[1], (char *)NULL);  break;  
	case 5: Tcl_VarEval(interp, "main5 ", argv[1], (char *)NULL);  break;  
	case 6: Tcl_VarEval(interp, "main6 ", argv[1], (char *)NULL);  break;  
	case 7: Tcl_VarEval(interp, "main7 ", argv[1], (char *)NULL);  break;  
	}
	step++;
    }
    else {
	while(step > 7)  step = step - 8;
	if(step<1) {
	    Tcl_VarEval(interp, "main0 ", argv[1], (char *)NULL);
	    step++; }
	if(step<2) {
	    Tcl_VarEval(interp, "main1 ", argv[1], (char *)NULL);
	    step++; }
	if(step<3) {
	    Tcl_VarEval(interp, "main2 ", argv[1], (char *)NULL);
	    step++; }
	if(step<4) {
	    Tcl_VarEval(interp, "main3 ", argv[1], (char *)NULL);
	    step++; }
	if(step<5) {
	    Tcl_VarEval(interp, "main4 ", argv[1], (char *)NULL);
	    step++; }
	if(step<6) {
	    Tcl_VarEval(interp, "main5 ", argv[1], (char *)NULL);
	    step++; }
	if(step<7) {
	    Tcl_VarEval(interp, "main6 ", argv[1], (char *)NULL);
	    step++; }
	if(step<8) {
	    Tcl_VarEval(interp, "main7 ", argv[1], (char *)NULL);
	    step++; }
    }
    return(TCL_OK);
}


int Edit(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) 
{
    char *a;
    
    Tcl_Eval(interp, "
         global which
         toplevel .edit
         wm geometry .edit 44x24
         wm minsize .edit 44 24
         frame .edit.top -relief raised -bd 1
         pack .edit.top -side top -fill both
         frame .edit.bot -relief groove -bd 1
         pack .edit.bot -side bottom -fill both
 
         text .edit.top.text -relief raised -bd 2 -yscrollcommand \
                                 {.edit.top.scroll set} -setgrid true
         scrollbar .edit.top.scroll -command {.edit.top.text yview}
    
         button .edit.bot.button1 -text Open
         button .edit.bot.button2 -text Start 
         button .edit.bot.button3 -text Test 
         button .edit.bot.button4 -text Save
         button .edit.bot.button5 -text Quit -command {destroy .edit}

         pack .edit.bot.button1 .edit.bot.button2 .edit.bot.button3 \
              .edit.bot.button4 .edit.bot.button5 -side left -expand 1 \
                                 -padx 3m -pady 3m -ipady 1m

         pack .edit.top.scroll -side right -fill y
         pack .edit.top.text -side left

         bind .edit.bot.button2 <1> {go $name}        
         bind .edit.bot.button1 <1> {set which 1
                                     input .edit}
         bind .edit.bot.button3 <1> {
                         set which 3
                         set f1 [open $name.nbp w+]
                         puts -nonewline $f1 [.edit.top.text get 1.0 end]
                         flush $f1
                         close $f1
                         go $name.nbp}
         bind .edit.bot.button4 <1> {set which 4
                                     input .edit}
         proc loadFile file {
            .edit.top.text delete 1.0 end
            set f [open $file]
            while {![eof $f]} {
                 .edit.top.text insert end [read -nonewline $f]
            }
            close $f
         }
         proc saveFile file {
            set fs [open $file w+]
            puts -nonewline $fs [.edit.top.text get 1.0 end]
            flush $fs
            close $fs
         }");
    a = "kb2.dat";
    printf("%s", name);

/*    Tcl_Eval(interp, "bind .edit.bot.button1 <1> {puts $name}");
*/
/*    Tcl_VarEval(interp, "bind .edit.bot.button1 <1> {set step 0
                                                     go ", name, 
                           "}", (char *)NULL); 
*/
    Tcl_VarEval(interp, "loadFile ", name, (char *)NULL);
    
    return(TCL_OK);
}

void Reshow(ClientData clientData, XEvent *eventPtr) 
{
    if(step>2){
	shows_graph(Tk_Width(tkwin)*3/5, 100);
    }
    XDrawString(d, w, gc, 100, 100, "Bubble Propagation Network.",
		strlen("Bubble Propagation Network."));
}

int Redraw(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) 
{
    if(step>2){
	XClearWindow(d, w);
	shows_graph(Tk_Width(tkwin)*3/5, 100+offset);
    }
    XDrawString(d, w, gc, 100, 100, "Bubble Propagation Network.",
		strlen("Bubble Propagation Network."));
    return(TCL_OK);
}


int Nbp0(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) 
{
    static char *display = NULL;
    printf("Global memory is %d BITES\n",global=
	   (STRUCT*CIRCUM)+(STRUCT)   +WORDS*5	+STRUCT	+STRUCT
	   +STRUCT*4      +STRUCT*4   +ALL*CIRCUM	+ALL	+100
	   +100	       +ALL*CIRCUM +ALL		+ALL	+STRUCT
	   +STRUCT	       +SLACK	   +ALL	        +ALL	+ALL
	   +STRUCT*4      +ALL	   +ALL		+ALL*CIRCUM+SLACK
	   +STRUCT	       +ALL*CIRCUM +ALL*4	+ALL    +ALL
	   +ALL	       +ALL	   +SLACK	+SLACK	+ALL
	   +NEST*CIRCUM);
    printf("main()");

    leaf=(int*)calloc(WORDS*5, sizeof(int));	/* 1K*/
    rght_sonae=(int*)calloc(ALL, sizeof(int));	/* 1K*/
    br_num=(int*)calloc(WORDS*5, sizeof(int));	/* 1K*/
    lttr=(int*)calloc(WORDS*5, sizeof(int));	/* 1K*/
    is_inc=(int*)calloc(ALL, sizeof(int));
    is_goal=(int*)calloc(ALL, sizeof(int));
    chld=(int*)calloc(STRUCT*CIRCUM, sizeof(int));   /* 10K */
    chld_num=(int*)calloc(STRUCT, sizeof(int));      /* 1K*/
    sugu_ue=(int*)calloc(WORDS*5, sizeof(int));	/* 1K*/
    and_left=(int*)calloc(STRUCT, sizeof(int));	/* 1K*/
    tukatta=(int*)calloc(ALL, sizeof(int));	/* 1K*/
    times=(int*)calloc(ALL, sizeof(int));	/* 1K*/
    lft_bnk=(int*)calloc(STRUCT, sizeof(int));	/* 1K*/
    cost=(double*)calloc(STRUCT, sizeof(double));		/* 1K*/
    papa=(int*)calloc(ALL*CIRCUM, sizeof(int));		/* 1K*/
    papa_num=(int*)calloc(ALL, sizeof(int));		/* 1K*/
    core=(int*)malloc(100*sizeof(int));		/*.1K*/
    arrow=(int*)calloc(ALL*CIRCUM, sizeof(int));	/*20K*/
    mark1=(int*)calloc(ALL, sizeof(int));		/*2K*/
    mark2=(int*)calloc(ALL, sizeof(int));		/*2K*/
    beer=(int*)calloc(STRUCT, sizeof(int));		/*1K*/
    bound=(int*)calloc(SLACK, sizeof(int));		/*1K*/
    /*** bound=2 when uppr, 0 when lower ***/
    lwr=(double*)calloc(ALL, sizeof(double));		/*8K*/
    uppr=(double*)calloc(ALL, sizeof(double));	        /*8K*/
    diff=(double*)calloc(ALL, sizeof(double));	        /*8K*/
    rate=(double*)calloc(STRUCT, sizeof(double));	/*4K*/
    srnd_num=(int*)calloc(ALL, sizeof(int));		/*8K*/
    srnd=(int*)calloc(ALL*CIRCUM, sizeof(int));	/*20K*/
    link=(int*)calloc(ALL*CIRCUM, sizeof(int));	/*20K*/
    slack=(int*)calloc(SLACK, sizeof(int));		/*1K*/
    strctr=(int*)calloc(STRUCT, sizeof(int));	/*1K*/
    rel=(double*)calloc(ALL*CIRCUM, sizeof(double));	/*40K*/
    value=(double*)calloc(ALL, sizeof(double));	/*4K*/
    stt=(int*)calloc(ALL, sizeof(int));		/*1K*/
    atr=(int*)calloc(ALL, sizeof(int));		/*1K*/
    can_nst=(int*)calloc(ALL, sizeof(int));		/*.05K*/
    in_arr=(int*)calloc(SLACK, sizeof(int));		/*1K*/
    out_arr=(int*)calloc(SLACK, sizeof(int));		/*1K*/
    nst_th=(int*)calloc(ALL, sizeof(int));		/*1K*/
    lnk_of_nst=(int*)calloc(NEST*CIRCUM, sizeof(int));		/*1K*/
    and_chlds=(int*)calloc(ALL, sizeof(int));
    and_ch=(int*)calloc(ALL*CIRCUM, sizeof(int));
    /* Total memory = 209.35K*/
    /* Total memory = 209.35K*/
    x_axis=(int*)calloc(ALL, sizeof(int));
    y_axis=(int*)calloc(ALL, sizeof(int));
    parity=(int*)calloc(ALL*CIRCUM, sizeof(int));
    num=(char *)malloc(sizeof(char)*5);
    /* total memory of internal varibables is 1Mbites*/
    
    step = 0;
    
    printf("Propositional logic Hypothetical Reasoning on the input data %s\n",argv[1]);
    if((fp=fopen( argv[1],"r"))==NULL){
	printf("can't open file %s\t",*argv);
/*	exit(1);  */
	return(TCL_ERROR);
    }
    getrusage(RUSAGE_SELF,&rus);
    cputime1=rus.ru_utime.tv_sec + rus.ru_utime.tv_usec*1.0e-6;	  

    XClearWindow(d, w);
    XDrawString(d, w, gc, 100, 100, "Bubble Propagation Network.",
		strlen("Bubble Propagation Network."));
    shows_step(step);
    return(TCL_OK);
}

int Nbp1(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) 
{
    initializer(argv,argc);
    shows_step(step);
    return(TCL_OK);
}

int Nbp2(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) 
{
/*    border = Tk_Get3DBorder(tkwin, GCBackground, &gcv); 
    Tk_Fill3DRectangle(d, Tk_WindowID(tkwin), border, 0, 0, Tk_Width(tkwin), Tk_Height(tkwin), 10, TK_RELIEF_RAISED); */
    set_true();
    printf("str %d, slk %d\n",str_num,slk_num);
/*    XClearWindow(d, w);
    XDrawString(d, w, gc, 100, 100, "Bubble Propagation Network.",
		strlen("Bubble Propagation Network."));
  */  /*while(1)*/ shows_graph(Tk_Width(tkwin)*3/5, 100+offset);
    shows_step(step);
    return(TCL_OK);
}

int Nbp3(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) 
{
    
    for(i=1;i<=link_num;i++) parity[i]=0;
    for(i=1;i<=ttl_node;i++) for(j=1;j<=srnd_num[i];j++) parity[link[i*CIRCUM+j]]++;
    illegal=0;
    for(i=1;i<=ttl_node;i++) for(j=1;j<=srnd_num[i];j++) if(parity[link[i*CIRCUM+j]]<2){
	printf("%d is not seen from %d,\n",i,srnd[i*CIRCUM+j]);
	illegal=1;
    }
    if(illegal) exit(1);
    
    getrusage(RUSAGE_SELF,&rus);
    cputime1=rus.ru_utime.tv_sec + rus.ru_utime.tv_usec*1.0e-6;
    init_rch=rch;
    nst_num=ttl_node;
    for(i=1;i<=ttl_node;i++){
	can_nst[i]=i;
	tukatta[i]=times[i]=0;
	for(j=1;j<=srnd_num[i];j++) arrow[link[i*CIRCUM+j]]=0;
    }
    arrower();
    shows_graph(Tk_Width(tkwin)*3/5, 100+offset);
    shows_step(step);
    return(TCL_OK);
}

int Nbp4(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) 
{
    cycle_num=0;
    
    while(1){
	for(i=1;i<=ttl_node;i++){	       
	    if(flt(value[i]-uppr[i])>0.0||flt(value[i]-lwr[i])<0.0){
		printf("[%d]%f(%f<x<%f)=\n",i,value[i],lwr[i],uppr[i]);
		for(j=1;j<=srnd_num[i];j++)
		    printf("+%f[%d]",-1.0/rel[i*CIRCUM+j]*value[srnd[i*CIRCUM+j]],srnd[i*CIRCUM+j]);
		printf("\n");
	    }
        }
	
	/* pr<1, value, srnds, arrows */
	br=0;
	rch=0;
	t=0;
	for(i=1;i<=ttl_node;i++) if(stt[i]==1){
	    if(atr[i]==1)      rch++;
	    else 	      beer[++br]=i;
	}  
	for(i=1;i<=ttl_node;i++) if(stt[i]==1){
	    if(atr[i]==1)      beer[++br]=i;
	}  
	printf("[%d of %d]\n",rch,str_num);
	if(rch>=str_num&&flg_out==0) break;
	
	choice=trial(0);
	tukatta[choice]=1;
	for(i=1;i<=ttl_node;i++)        if(tukatta[i]>0) tukatta[i]++;
	exchange(choice);
	
	
	/*		pig=0;
			for(i=1;i<=ttl_node;i++) pig+=stt[i];
			printf("pig=%d\n",pig);
			*/
	printf("[%d]\n",++cycle_num);
	outputs();
    }
    shows_step(step);
    return(TCL_OK);
}

int Nbp5(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) 
{
    outputs();
    impr();
    /* pr<1, value, srnds, arrows */
    shows_step(step);
    return(TCL_OK);
}


int Nbp6(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) 
{
    getrusage(RUSAGE_SELF,&rus);
    cputime=rus.ru_utime.tv_sec + rus.ru_utime.tv_usec*1.0e-6;
    printf("runtime=%9.2f[s]\n",cputime-cputime1);
    shows_graph(Tk_Width(tkwin)*3/5, 100+offset);
    shows_step(step);
    return(TCL_OK);
}

int Nbp7(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) 
{
    outputs();
    /*	waitme();  */
    printf("Are you ready to say goodby (touch return key)?\n");
    shows_step(step);
    free(leaf);
    free(rght_sonae);
    free(br_num);
    free(lttr);
    free(is_inc);
    free(is_goal);
    free(chld);
    free(chld_num);
    free(sugu_ue);
    free(and_left);
    free(tukatta);
    free(times);
    free(lft_bnk);
    free(cost);
    free(papa);
    free(papa_num);
    free(core);
    free(arrow);
    free(mark1);
    free(mark2);
    free(beer);
    free(bound);
    free(lwr);
    free(uppr);
    free(diff);
    free(rate);
    free(srnd_num);
    free(srnd);
    free(link);
    free(slack);
    free(strctr);
    free(rel);
    free(value);
    free(stt);
    free(atr);
    free(can_nst);
    free(in_arr);
    free(out_arr);
    free(nst_th);
    free(lnk_of_nst);
    free(and_chlds);
    free(and_ch);
    free(x_axis);
    free(y_axis);
    free(parity);
    free(num);
    
    return(TCL_OK);
}


/*********   $B$3$3$^$G!"(BTcl $B$N%3%^%s%I$NDj5A!*!J$N$O$:!*!K(B    *******/
    
void fralc()
{
	free(leaf);
	free(rght_sonae);
	free(br_num);
	free(lttr);
	free(is_inc);
	free(is_goal);
	free(chld);
	free(chld_num);
	free(sugu_ue);
	free(and_left);
	free(tukatta);
	free(times);
	free(lft_bnk);
	free(cost);
	free(papa);
	free(papa_num);
	free(core);
	free(arrow);
	free(mark1);
	free(mark2);
	free(beer);
	free(bound);
	free(lwr);
	free(uppr);
	free(diff);
	free(rate);
	free(srnd_num);
	free(srnd);
	free(link);
	free(slack);
	free(strctr);
	free(rel);
	free(value);
	free(stt);
	free(atr);
	free(can_nst);
	free(in_arr);
	free(out_arr);
	free(nst_th);
	free(lnk_of_nst);
	free(and_chlds);
	free(and_ch);
	free(x_axis);
	free(y_axis);
	free(parity);
    }

void waitme1()
{
    char *x;

    printf("Do you want to exit this program?");
    scanf("%s",x);
    if(x == "y") 
	exit();
    else waitme1();
}

   
void waitme()
{
	XEvent e;
	int x,y;
	unsigned int eight, width,height;
	int ifexpose=0;
	XSelectInput(d,w,ExposureMask);
	while(1){
		XNextEvent(d, &e);
		ifexpose=0;
		switch(e.type){
			case Expose :	shows_graph(Tk_Width(tkwin)*3/5, 100+offset);
					ifexpose=1;
					break;
/*
			case GraphicsExpose :
				printf("GExposed\n");
				x=e.xgraphicsexpose.x; y=e.xgraphicsexpose.y;
				width=e.xgraphicsexpose.width;
				height=e.xgraphicsexpose.height;
				XRaiseWindow(d,w);
				ifexpose=1;
*/
		}
		if(ifexpose==1) break;
	}

	return;
}
void initializer(argv,argc)
int argc;
char *argv[];
{
	int i,*strth,*slkth;
	strth=(int*)calloc(STRUCT, sizeof(int));
	slkth=(int*)calloc(SLACK, sizeof(int));
	input_newversion(strth,slkth,argv,argc);


	for(i=1;i<=slk_num;i++)	cost[slack[i]]=cost[papa[slack[i]*CIRCUM+1]];
	for(i=1;i<=str_num;i++) 
	  if(srnd_num[strctr[i]]==papa_num[strctr[i]]) cost[strctr[i]]=1.0;
	  else 					       cost[strctr[i]]=0.0;

	
	symplex(strth,slkth);
	for(i=1;i<=ttl_node;i++) in_arr[i]=out_arr[i]=0;
/*	shows_net();*/

	free(strth);
	free(slkth);
	return;
}

void set_true()
{
	int i,j,more_to_set,*alrdy;
	alrdy=(int*)calloc(ALL, sizeof(int));
	for(i=1;i<=str_num;i++) alrdy[strctr[i]]=0;	
	more_to_set=1;
	while(more_to_set){
		more_to_set=0;
		for(i=1;i<=str_num;i++) if(lwr[strctr[i]]>0.5&&alrdy[strctr[i]]==0){
			more_to_set=1;
			alrdy[strctr[i]]=1;
			for(j=1;j<=and_chlds[strctr[i]];j++){
				 lwr[srnd[and_ch[strctr[i]*CIRCUM+j]*CIRCUM+2]]=1.0;
			}
		}
	}
	free(alrdy);
	return;
}



void shows_graph(iks,wai)
{
   char *kazu, *num;
   int i,j,k,dr,drawn_num,*drawn_node,tonari,*drawn,*kodomo_num, k2,
	gaki,mitudo,mitudo_limit,mitudo_areax,mitudo_areay,kihon,mawari,muki;
   int xs, ys;

         drawn_node=(int*)calloc(ALL, sizeof(int));
         drawn=(int*)calloc(ALL, sizeof(int));		
         kodomo_num=(int*)calloc(ALL, sizeof(int));
        kazu=(char *)malloc(sizeof(char)*5);	
	XSetLineAttributes (d, gc, 1, LineSolid, CapButt, JoinMiter);


	for(i=1;i<=ttl_node;i++){
		drawn[i]=0;
	        kodomo_num[i]=0;
	}
	drawn[1]=1;
	drawn_node[drawn_num=1]=1;
	x_axis[1]=iks;
	y_axis[1]=wai;
	draws_circle(1);

	while(drawn_num<ttl_node) for(j=1;j<=drawn_num;j++){
		 dr=drawn_node[j];
		 kihon=x_axis[dr];
		 for(k=1;k<=srnd_num[dr];k++){
		   tonari=srnd[dr*CIRCUM+k];
		   if(drawn[tonari]==0){
		      gaki=++kodomo_num[dr];
 	              if(atr[tonari]==0){
          		    mitudo_limit=DENSE;
			    mitudo_areax=70;
			    mitudo_areay=50;
		      }
	              else{
          		    mitudo_limit=0;
			    mitudo_areax=SCALE;
			    if(k!=1) kihon+=
					powint(-1,gaki+1)*(int)(300/(gaki+10)*(gaki));
			    mitudo_areay=SCALE;
		      }
		      if((srnd_num[dr]>2&&srnd_num[tonari]>2&&atr[tonari]==0)||atr[tonari]==1)
		      while(1){
			mitudo=0;
			for(i=1;i<=drawn_num;i++){
			    mawari=drawn_node[i];
			    if(abs_i(x_axis[mawari]-kihon)<mitudo_areax
				&&abs_i(y_axis[mawari]-y_axis[dr]-50)<mitudo_areay)
			       if(++mitudo>mitudo_limit){
				  kihon+=((x_axis[dr]>x_axis[drawn_node[j-1]])
					  *2-1)*mitudo_areax;
				   break;
                       		}
			}
			if(mitudo<=mitudo_limit) break;
		      }
			drawn_node[++drawn_num]=tonari;
			if(atr[tonari]==0){
			   for(k2=1;k2<=srnd_num[tonari];k2++) 
				if(srnd[tonari*CIRCUM+k2]==dr)   break;	
			   if(k2==1){
				 x_axis[tonari]=kihon+powint(-1,gaki)
					      *(int)(100/(gaki+10)*gaki);
				 y_axis[tonari]=y_axis[dr]+50;
			   }
			   else{
				 x_axis[tonari]=kihon+powint(-1,gaki)
					      *(int)(185/(gaki+10)*gaki);
				 y_axis[tonari]=y_axis[dr]+50;			
			   }
			}
			else if(k==1){
				 x_axis[tonari]=kihon;
				 y_axis[tonari]=y_axis[dr]+50;			
			   }
			   else{
				 x_axis[tonari]=kihon;
				 y_axis[tonari]=y_axis[dr]+50;
			   }
			drawn[tonari]=1;
		  }
	}
  }

  for(i=1;i<=slk_num;i++) if(srnd_num[k=slack[i]]>2){
		y_axis[k]
		  +=((y_axis[k]>y_axis[srnd[k*CIRCUM+1]])*2-1)*10;
		x_axis[k]
		  +=(int)((x_axis[k]-x_axis[srnd[k*CIRCUM+1]])/10);
  }
  for(i=2;i<=drawn_num;i++){
	k=drawn_node[i];
	draws_node(k);
        sprintf(kazu,"%d",k);
	muki=(int)(((x_axis[k]>x_axis[drawn_node[i-1]])*2-1)*SCALE*0.7);
	
	xs = x_axis[1] - bai*(x_axis[1] - (x_axis[k]-5+muki));
        ys = y_axis[1] - bai*(y_axis[1] - (y_axis[k]+SCALE*2));
	XDrawString(d, w, gc, xs, ys, kazu, strlen(kazu));

/*	XDrawString(d, w, gc, x_axis[k]-5+muki, y_axis[k]+SCALE*2,
		    kazu, strlen(kazu));  */
	for(j=1;j<=srnd_num[k];j++){
		draws_line(k,srnd[k*CIRCUM+j],0);
		draws_node(srnd[k*CIRCUM+j]);
	}
	draws_node(k);
   }
   XFlush(d);
   free(drawn_node);
   free(drawn);      
   free(kazu);
   free(kodomo_num); 
   return;
	
}

 int  powint(a,b)
 int a,b;
 {
	 int i,power;
	 power=1;
	 for(i=1;i<=b;i++)  power*=a;
	 return(power);
 }


void draws_node(node)
int node;
{
	switch(atr[node]){
		case 1: draws_circle(node);
			break;
		case 0: draws_angle(node);
	}
	return;
}

void draws_angle(node)
int node;
{
    int x, y;
    switch(stt[node]){
	case 1: XSetForeground(d, gc, black);
                break;
	case 0: XSetForeground(d, gc, white);
    }
    if(flt(value[node]-uppr[node])>0.0||flt(value[node]-lwr[node])<0.0)
	 XSetForeground(d, gc, red);
/*    x=x_axis[node];
    y=y_axis[node]; */

    x = x_axis[1] - bai*(x_axis[1] - x_axis[node]);
    y = y_axis[1] - bai*(y_axis[1] - y_axis[node]); 

    XFillRectangle(d, w, gc, x-(int)(SCALE/2), y-(int)(SCALE/2),  SCALE, SCALE);
    XSetForeground(d, gc, black);
    XDrawRectangle(d, w, gc, x-(int)(SCALE/2), y-(int)(SCALE/2),  SCALE, SCALE);
    return;
}

void draws_circle(node)
int node;
{
    int x, y;
    switch(stt[node]){
	case 1: XSetForeground(d, gc, black);
                break;
	case 0: XSetForeground(d, gc, white);
    }
    if(flt(value[node]-uppr[node])>0.0||flt(value[node]-lwr[node])<0.0)
	 XSetForeground(d, gc, red);
    if(flt(value[node]-1.0)==0.0)
	 XSetForeground(d, gc, green);

/*    x=x_axis[node];
    y=y_axis[node];*/

    x = x_axis[1] - bai*(x_axis[1] - x_axis[node]);
    y = y_axis[1] - bai*(y_axis[1] - y_axis[node]); 

   XFillArc(d, w, gc, x-(int)(SCALE/2), y-(int)(SCALE/2), 
	SCALE, SCALE, 0*64, 360*64);
   XSetForeground(d, gc, black);
   XDrawArc(d, w, gc, x-(int)(SCALE/2), y-(int)(SCALE/2), 
	SCALE, SCALE, 0*64, 360*64);
   if(papa_num[node]==srnd_num[node]){
	 XDrawArc(d, w, gc, x-(int)(0.8*SCALE), y-(int)(0.8*SCALE), 
		(int)(1.6*SCALE), (int)(1.6*SCALE), 0*64, 360*64);
   }
    return;
}

void draws_line(a,b,jd)
int a,b,jd;
{
	int xa,xb,ya,yb;
/*	xa=x_axis[a];
	ya=y_axis[a];
	xb=x_axis[b];
	yb=y_axis[b]; */

	xa = x_axis[1] - bai*(x_axis[1] - x_axis[a]);
	ya = y_axis[1] - bai*(y_axis[1] - y_axis[a]);
	xb = x_axis[1] - bai*(x_axis[1] - x_axis[b]);
	yb = y_axis[1] - bai*(y_axis[1] - y_axis[b]);

    if(jd==0) XSetForeground(d, gc, black);
    if(jd==1) XSetForeground(d, gc, red);
    if(jd==2) XSetForeground(d, gc, red);
    XDrawLine(d, w, gc, xa, ya, xb, yb);
    return;
}

unsigned long MyColor(display, color)
Display *display;
char *color;
{
	Colormap cmap;
	XColor c0, c1;
	cmap=DefaultColormap(display, 0);
	XAllocNamedColor(display, cmap, color, &c1, &c0);
	return(c1.pixel);
}

void shows_net()
{
   int j,k,m;								
   printf("ttl_node=%d\n",ttl_node);
	m=0;
   for(j=0;j<=ttl_node;j++){
	if(++m==10){
	    printf("void shows_net()");
	    /* getchar(); */


	    m=0;
	}
	printf("atr is %d stt is %d,and_chlds %d, ", atr[j],stt[j],and_chlds[j]);
	for(k=1;k<=srnd_num[j];k++)
	printf("[%d(%d)-[%d](%d%d)-%d]",j,atr[j],arrow[link[j*CIRCUM+k]],stt[j],
				     stt[srnd[j*CIRCUM+k]],srnd[j*CIRCUM+k]);
	    printf("\n");
   }
   printf("void shows_net()");
   /* getchar(); */


   return;
}

void shows_net2()
{
   int i,j,k,m;								
	m=0;
   for(i=1;i<=nst_num;i++){
	if(++m==10){
	    printf("void shows_net2()");
	    /* getchar(); */


	    m=0;
	}
	j=can_nst[i];
	printf("atr is %d stt is %d ", atr[j],stt[j]);
	for(k=1;k<=srnd_num[j];k++)
	printf("[%d(%d)-[%d](%d%d)-%d]",j,atr[j],arrow[link[j*CIRCUM+k]],stt[j],
				     stt[srnd[j*CIRCUM+k]],srnd[j*CIRCUM+k]);
	    printf("\n");
    }
   printf("int shows_net2()");
   /* getchar(); */


   return;
}


void arrower()
{
	int i,j,*cand_arr,now,*car_num,srst,sl,sr,srsl;

		cand_arr=(int*)calloc(ALL, sizeof(int));
		car_num=(int*)calloc(1, sizeof(int));
		/**  the candidate node to be in a same nest of arrow  **/

	for(i=1;i<=str_num;i++) 
	if((flt(value[strctr[i]])==0.0||flt(value[strctr[i]])==1.0)
	    &&stt[strctr[i]]==0){
		
		stt[strctr[i]]=1;
	}

  for(i=1;i<=nst_num;i++) mark1[can_nst[i]]=0;
      *car_num=0;
	for(i=1;i<=str_num;i++)	{
		if(stt[strctr[i]]==1) cand_arr[++*car_num]=strctr[i];
	}
	arrow_sub(cand_arr,car_num);
      *car_num=0;
	for(i=1;i<=slk_num;i++)	{
		if(stt[slack[i]]==0) cand_arr[++*car_num]=slack[i];
	}
	arrow_back(cand_arr,car_num);
	free(cand_arr);
	free(car_num);
	return;
}


void arrow_sub(cand_arr,car_num)
int *cand_arr,*car_num;
{
 int i,j,now,srst,sl,sr,srsl,*tmp_mark,trace,squees;

 tmp_mark=(int*)calloc(ALL, sizeof(int));

	getrusage(RUSAGE_SELF,&rus);
	cputime2=rus.ru_utime.tv_sec + rus.ru_utime.tv_usec*1.0e-6;	  
	for(i=1;i<=nst_num;i++){
		node=can_nst[i];
		tmp_mark[node]=0;
	}
		
   now=0;
   while(now<*car_num)
   {
	mark1[cand_arr[++now]]=1;
	      /***  mark1 is the mark of already arrowed (start or end of arrow).***/
	for(srst=1;srst<=srnd_num[cand_arr[now]];srst++){
	    if(tmp_mark[sl=srnd[cand_arr[now]*CIRCUM+srst]]==0){
		mark1[sl]=1;

		if(arrow[link[cand_arr[now]*CIRCUM+srst]]==0){
			arrow[link[cand_arr[now]*CIRCUM+srst]]=-1;
			in_arr[sl]++;
			out_arr[cand_arr[now]]++;
	        }

		if(in_arr[sl]==srnd_num[sl]-1&&stt[sl]==1){
		   /*it is not neccesary to say sl is atr=0*/
			for(srsl=1;srsl<=srnd_num[sl];srsl++){
		        	if(mark1[srnd[sl*CIRCUM+srsl]]==0){
					tmp_mark[sl]=1;
					mark1[squees=srnd[sl*CIRCUM+srsl]]=1;
					if(stt[squees]==0){
						if(arrow[link[sl*CIRCUM+srsl]]==0){
							arrow[link[sl*CIRCUM+srsl]]=1;
							cand_arr[++*car_num]=squees;
					        }
					}
					else{

						if(arrow[link[sl*CIRCUM+srsl]]==0){
							stt[sl]=0;
							arrow[link[sl*CIRCUM+srsl]]=-1;
							in_arr[sl]++;
							out_arr[srnd[sl*CIRCUM+srsl]]++;
					        }
					}
				}
			}
		}
		if(stt[sl]==1&&in_arr[sl]==srnd_num[sl]){
		    stt[sl]=0;
             /********* Nodes' cost change ***************/
		}
	   } 
       }
    }

 free(tmp_mark);
	return;
}

void arrow_back(cand_arr,car_num)
int *cand_arr,*car_num;
{

 int i,j,now,srst,sl,sr,srsl,*tmp_mark,trace,squees;
	 tmp_mark=(int*)calloc(ALL, sizeof(int));
	getrusage(RUSAGE_SELF,&rus);
	cputime2=rus.ru_utime.tv_sec + rus.ru_utime.tv_usec*1.0e-6;	  
	for(i=1;i<=nst_num;i++){
		node=can_nst[i];
		tmp_mark[node]=0;
	}
   now=0;
   while(now<*car_num){
	mark1[cand_arr[++now]]=1;
	      /***  mark1 is the mark of already arrowed (start or end of arrow).***/
	for(srst=1;srst<=srnd_num[cand_arr[now]];srst++){
	    if(tmp_mark[sl=srnd[cand_arr[now]*CIRCUM+srst]]==0){
		mark1[sl]=1;
		if(arrow[link[cand_arr[now]*CIRCUM+srst]]==0){
			arrow[link[cand_arr[now]*CIRCUM+srst]]=-1;
			out_arr[sl]++;
			in_arr[cand_arr[now]]++;
	        }

		if(out_arr[sl]==srnd_num[sl]-1&&stt[sl]==0){
		   /*it is not neccesary to say sl is atr=0*/
			/*tmp_mark denotes a receiving node already squeesed*/
			for(srsl=1;srsl<=srnd_num[sl];srsl++){
		        	if(mark1[srnd[sl*CIRCUM+srsl]]==0){
					tmp_mark[sl]=1;
					mark1[squees=srnd[sl*CIRCUM+srsl]]=1;
					if(stt[squees]==1){

					     if(arrow[link[sl*CIRCUM+srsl]]==0){
						arrow[link[sl*CIRCUM+srsl]]=1;
						cand_arr[++*car_num]=squees;
					     }
					}
					else{
						if(arrow[link[sl*CIRCUM+srsl]]==0){
							stt[sl]=1;
							arrow[link[sl*CIRCUM+srsl]]=-1;
							out_arr[sl]++;
							in_arr[srnd[sl*CIRCUM+srsl]]++;
					        }

					}
 				}
			}

		}
		if(in_arr[sl]==srnd_num[sl]){
		    stt[sl]=0;

		}
 	   } 
       }
    }
 free(tmp_mark);
	return;
}


int trial(taihen)
int taihen;
{
    int chosen,br,div,i,j,counter,sonae,sonae3,sonae2,h,shld_change;
    double bst_out, best,gap,how_out,out_min,vl,w_break;
    /*printf("   trial jointed\n");*/
    out_min=1000000.0;
    chosen=0;
    counter=0;
    sonae=sonae2=sonae3=0;
    for(br=1;br<=str_num;br++){
	if(flt(uppr[beer[br]]-lwr[beer[br]])>0.0) {
	    while(1){
		div=trial_sub(beer[br]);
		
		for(i=1;i<=nst_num;i++)	mark2[can_nst[i]]=0;		        
		/*printf("beer %d [%d], div'%d\n",beer[br],atr[beer[br]], div);*/
		if(div<0){
		    stt[-1*div]=0;
		    for(j=1;j<=srnd_num[-1*div];j++)   arrow[-1*div*CIRCUM+j]=-1;
		    br++;
		}
		else  break;
	    }
	    
	    shld_change=0;
	    
	    
	    for(i=1;i<=nst_num;i++){
		vl=value[can_nst[i]];
		if(flt(vl-uppr[can_nst[i]])>0.0 ||flt(vl-lwr[can_nst[i]])<0.0){
		    
		    shld_change=1;
		}
	    }
	    how_out=now_aus;
	    for(h=1;h<=nst_num;h++)if(stt[i=can_nst[h]]==0||i==beer[br]){
		if((flt(value[i]-lwr[i]))<0.0)
		    how_out-=flt(lwr[i]-value[i])*cost[i];
		if((flt(value[i]-uppr[i]))>0.0)
		    how_out-=flt(value[i]-uppr[i])*cost[i];
		if((flt(value[i]+diff[i]*minch1-lwr[i]))<0.0)
		    how_out+=flt(lwr[i]-value[i]-diff[i]*minch1)*cost[i];
		if((flt(value[i]+diff[i]*minch1-uppr[i]))>0.0)
		    how_out+=flt(value[i]+diff[i]*minch1-uppr[i])*cost[i];
		/* printf("%f(%f<%f<%f[%d of cost %f, diff %f]\n)",
		  how_out,lwr[i],value[i],uppr[i],i,cost[i], diff[i]);
					    */			}
	    for(i=1;i<=nst_num;i++){
		mark2[can_nst[i]]=0;		        
		diff[can_nst[i]]=0.0;
	    }
	    /*printf("how_out=%f/now_aus=%f\n",how_out,now_aus);*/
	    /*printf("div[%d, out %f],",div,how_out);*/
	    if(flg_out==0||shld_change==1)
		if(abs_f(how_out)<out_min){
		    
		    if((tukatta[beer[br]]==0||tukatta[beer[br]]>5)
		       &&(beer[br]!=div||times[beer[br]]<=2)){
			out_min=abs_f(how_out);
			sonae3=beer[br];
		    }
		    if((tukatta[beer[br]]==0||tukatta[beer[br]]>10)
		       &&(beer[br]!=div||times[beer[br]]<=2)){ 	
			sonae2=beer[br];
		    }
		    if(tukatta[beer[br]]==0
		       &&(beer[br]!=div||times[beer[br]]<=2)){
			sonae=beer[br];
		    }
		}
	    if(flg_out==1){
		if(flt(how_out-now_aus)<0.0
		   /*   &&(beer[br]!=div||times[beer[br]]<=2)  */
		   &&(tukatta[beer[br]]==0||tukatta[beer[br]]>5)
		   /*  ||(tukatta[beer[br]]==2&&times[beer[br]]<=2)) */
		   ){
		    chosen=beer[br];
		    break;
		}
		else if(sonae!=0)   chosen=sonae;
		else if(sonae2!=0)	chosen=sonae2;
		else if(sonae3!=0)	chosen=sonae3;	
		else chosen=0;
	    }
	    else{
		now_aus=0.0;
		if(atr[beer[br]]==0&&atr[div]==1){
		    chosen=beer[br];
		    break;
		} else if(atr[beer[br]]==atr[div]&&flt(cmp)<0.0){
		    chosen=beer[br];
		}
		else   	      chosen=sonae;
	    }
	    
	}
    }
    
    /*printf("exchange 1 to choice=%d(%d) started !!\n",chosen,atr[chosen]);*/
    
    if(chosen==0){
	shows_value();
	printf("failure\n");
	waitme1();
    }
    
    /***When no change black rangle .vs. any white is available in he****/ 
    /***feasibility body is available, approximate the structural values****/ 
    /***and test if feasible value can be attained by this process.****/ 
    return(chosen);
}




int trial_sub(choice)
int choice;
{
	int i,j,now,div,slk,lk;
	  slk=choice;
	    now=0;
	    for(i=1;i<=nst_num;i++){
	      node=can_nst[i];
              for(j=1;j<=srnd_num[node];j++){
		lnk_of_nst[link[node*CIRCUM+j]]=0;
	      }
           }
	    can_nst[1]=choice;
	    mark2[choice]=1;
	    nst_num=1;
	    nst_th[choice]=1;
	      while(now<nst_num){
		/** Generate Nest including non-arrowed nets. **/		
		      now++;	
                      node=can_nst[now];
				for(i=1;i<=srnd_num[node];i++){
				 if(arrow[lk=link[node*CIRCUM+i]]!=2*atr[node]-1){
				 /* implies at most only arrows from 'now'.*/
					lnk_of_nst[lk]=1;
		                     if(mark2[srnd[node*CIRCUM+i]]==0){
					can_nst[++nst_num]=srnd[node*CIRCUM+i];
					mark2[can_nst[nst_num]]=1;
					nst_th[can_nst[nst_num]]=nst_num;
				     }
       				}
			}
		}
	div=prpgt(choice);
	return(div);
}


int exchange(choice) 
			/*****  As the trial is finished,now we execute the change selected ***/
int choice;						/***** above. ***/
{
		int i,j,div,now,stop,jdg_apr,tr,*apr,*new_rch,*new_abs,*diff_rch,*diff_abs,
		    *car_num,*cand_arr,lk;

		/*diff_rch=(int*)calloc(100,sizeof(int));*/

		diff_rch=(int*)calloc(1, sizeof(int));
		diff_abs=(int*)calloc(1, sizeof(int));
		car_num=(int*)calloc(1, sizeof(int));
		cand_arr=(int*)calloc(STRUCT, sizeof(int));
		new_rch=(int*)calloc(STRUCT, sizeof(int));
		new_abs=(int*)calloc(SLACK, sizeof(int));
		in_ex=1;
		*diff_rch=0;
		*diff_abs=0;

		div=trial_sub(choice);
		if(choice==div) times[choice]++;
		printf("choice[%d] %d, div[%d] %d\n",atr[choice],choice,atr[div],div);
	        for(i=1;i<=nst_num;i++){
		 for(j=1;j<=srnd_num[can_nst[i]];j++)
			if(lnk_of_nst[link[can_nst[i]*CIRCUM+j]]){
				draws_line(can_nst[i],srnd[can_nst[i]*CIRCUM+j],1);
			}		
		}			
	        for(i=1;i<=nst_num;i++)		 draws_node(can_nst[i]);
		XFlush(d);
		/*shows_change();*/
		printf("int exchange(choice");
		/* getchar(); */



	        for(i=1;i<=nst_num;i++){
			 for(j=1;j<=srnd_num[can_nst[i]];j++)
				if(lnk_of_nst[link[can_nst[i]*CIRCUM+j]]){
					draws_line(can_nst[i],srnd[can_nst[i]*CIRCUM+j],0);
				}					
		}
	        for(i=1;i<=nst_num;i++) mark2[can_nst[i]]=0;

		    				/*** find the node to reach an integer value  **/
			stt[choice]=0;
			stt[div]=1;	

			/*****  As the trial is finished,now we execute the selected change ***/	
		for(i=1;i<=nst_num;i++){
			node=can_nst[i];
			for(j=1;j<=srnd_num[node];j++){
				if(lnk_of_nst[lk=link[node*CIRCUM+j]]==1){
					if(atr[node]==1&&arrow[lk]==-1){
					  out_arr[node]-=1;
                                          in_arr[srnd[node*CIRCUM+j]]-=1;
				        }
					if(atr[node]==0&&arrow[lk]==-1){
					  in_arr[node]-=1;
                                          out_arr[srnd[node*CIRCUM+j]]-=1;
				        }
					arrow[lk]=0;
					lnk_of_nst[lk]=0;/*Initialize links*/

				}
		        }

		}

		flg_out=0;
		for(i=1;i<=nst_num;i++){
			node=can_nst[i];
			if(stt[node]==0||node==div){
			  if((flt(value[node]-lwr[node]))<0.0)
		              now_aus-=abs_f(lwr[node] -value[node])*cost[node];
			  if((flt(value[node]-uppr[node]))>0.0)
			      now_aus-=abs_f(value[node]-uppr[node])*cost[node];
			  value[node]+=diff[node]*min_ch;
			  if((flt(value[node]-lwr[node]))<0.0)
		              now_aus+=abs_f(lwr[node] -value[node])*cost[node];
			  if((flt(value[node]-uppr[node]))>0.0)
			      now_aus+=abs_f(value[node]-uppr[node])*cost[node];
		        }
		}
		if(flt(now_aus)>0.0) flg_out=1;
		else		     now_aus=0.0;

		for(i=1;i<=nst_num;i++){
			node=can_nst[i];
			if(atr[node]==1&&(flt(value[node]-1.0)==0.0||flt(value[node])==0.0)){
			  stt[node]=1;
			  new_rch[++*diff_rch]=node;
			}

			if(atr[node]==0&&stt[node]==0)
			  new_abs[++*diff_abs]=node;
		}
		if(flg_out==1){		
			jdg_apr=approx(new_rch,new_abs,diff_rch,diff_abs);
			if(jdg_apr==0){	/*****  In the case of feasible after approximation, **********/
				printf("appr worked\n");
				outputs();
  			}
		}

		for(i=1;i<=*diff_rch;i++)	cand_arr[i]=new_rch[i];
		for(i=1;i<=nst_num;i++) 	mark1[can_nst[i]]=0;
		*car_num=*diff_rch;
		arrow_sub(cand_arr,car_num);
		for(i=1;i<=*diff_abs;i++)	cand_arr[i]=new_abs[i];
		*car_num=*diff_abs;
		arrow_back(cand_arr,car_num);
		in_ex=0;
	        for(i=1;i<=nst_num;i++)		 draws_node(can_nst[i]);
		XFlush(d);

	printf("div%d=[%d],%f\n",div,stt[div],value[div]);
	free(diff_rch);
	free(diff_abs);
	free(car_num);
	free(cand_arr);
	free(new_rch);
	free(new_abs);
	return(div);
}

int prpgt(choice)
int choice;
{
	int div,i,j,h,g,end,erst,erst_th;
	double *reach,*flow,dead;
	reach=(double*)calloc(GROUP*NEST, sizeof(double));
	flow=(double*)calloc(GROUP*NEST, sizeof(double));				

	if(atr[choice]==0) erst_th=2;
	else 		   erst_th=1;


	while(1){
		erst=can_nst[erst_th++];
		if(atr[erst]==1){
		    dead=simpl2(flow,reach,erst,choice);
		    if(dead==0) break;
		    }
		if(erst_th>nst_num) {
		    free(reach);
		    free(flow);
		    return(-1*dead);
		}
	    }

/*
		for(g=1;g<=grp_num;g++)
		  for(h=1;h<=nst_num;h++){
			 if(in_ex==1)
			 printf("(erst %d)flow[%d,%d]=%f\n",erst,g,can_nst[h],flow[g*NEST+h]);
		  }
*/
	solves(reach);
	slct_wh(flow);            /** selecting div **/



	div=selects(choice);	  /* selected div */
	compare(choice,div);      /** compare and selsect thebest choice */



	if(in_ex==1&&atr[div]==0&&
	   (flg_out==0&&flt(cmp)==0.0)||flg_out==1){
		div=divc;
		min_ch=minch1;
		printf("minch1\n");
	}

	/*printf("min_ch=%fapprminch1=%f\n",min_ch,minch1);*/
	free(reach);
	free(flow);
	return(div);
}

void compare(choice,div)
int choice,div;	/**** The followings are checked.  **/
	       	/** 1. How far the current point is transporting out of the body if any. ***/
      		/** 2. If the cost or integer degree decreases or not. ***/
{
	int i;
	double dif_nrm;

	/*printf("         compare jointed\n");*/
	dif_nrm=0;
	for(i=1;i<=nst_num;i++)   								
	{
		node=can_nst[i];	
	        if(stt[node]==0||node==choice){
		       if(atr[div]==0){
			       if(atr[node]==1){
				dif_nrm
	           		  +=abs_f(0.5-value[node])
				    -abs_f(0.5-(value[node]+diff[node]*min_ch));
				cmp=dif_nrm;
			       }
		       }
		}	
	}
	return;
}

int approx(new_rch,new_abs,diff_rch,diff_abs)
int	*new_rch,*new_abs,*diff_rch,*diff_abs;
{
	int sr,sri,i,jdg_apr,s,t,m,node,*sumi,violants,*violate;
	double *apr_sl;
	apr_sl=(double*)calloc(ALL, sizeof(double));
	violate=(int*)calloc(STRUCT, sizeof(int));
	sumi=(int*)calloc(ALL, sizeof(int));
	for(i=1;i<=ttl_node;i++) sumi[i]=0;
	violants=0;
	for(s=1;s<=ttl_node;s++)if(atr[s]==0){
		apr_sl[s]=0.0;
		if((flt(value[s]-uppr[s])>0.0)||(flt(value[s]-lwr[s])<0.0))
		  for(i=1;i<=srnd_num[s];i++){
		    if(sumi[sri=srnd[s*CIRCUM+i]]!=1){
		             violate[++violants]=sri;
	                     sumi[sri]=1;
                    }
	         }
	}
	for(i=1;i<=violants;i++){
		node=violate[i];
		for(t=1;t<=srnd_num[node];t++){
		  sri=srnd[node*CIRCUM+t];
                  apr_sl[sri]=value[sri];
	        }
	}

	for(i=1;i<=violants;i++){
		node=violate[i];

		if(value[node]<0.5)
			apr_sl[node]=0.0;
		else	apr_sl[node]=1.0;
		for(t=1;t<=srnd_num[node];t++){

			apr_sl[srnd[node*CIRCUM+t]]
			  +=rel[node*CIRCUM+t]*(apr_sl[node]-value[node]);
		}
	}
	jdg_apr=0; 

	for(i=1;i<=violants;i++){
		node=violate[i];

		for(t=1;t<=srnd_num[node];t++){
		  sri=srnd[node*CIRCUM+t];

		  if(flt(apr_sl[sri]- lwr[sri])<0.0
		   ||flt(apr_sl[sri]-uppr[sri])>0.0){	  
			  jdg_apr=1;
		  }
	       }
	}
	if(jdg_apr==0){
		for(t=1;t<=violants;t++){
			node=violate[t];
			value[node]=apr_sl[node];	
			for(i=1;i<=srnd_num[node];i++){
			  sri=srnd[node*CIRCUM+i];
			  value[sri]=apr_sl[sri];
		        }
		}
		flg_out=0;
		now_aus=0.0;
		for(i=1;i<=nst_num;i++){
			node=can_nst[i];
			if(atr[node]==1&&(flt(value[node])==1.0||flt(value[node])==0.0)){
				stt[node]=1;
				new_rch[++*diff_rch]=node;
			}
			if(atr[node]==0&&stt[node]==0)
			  new_abs[++*diff_abs]=node;
		}	
	}
	free(apr_sl);
	free(violate);
	free(sumi);

	return(jdg_apr);
}

void shows_value()
{
	int k,i,j;
	double v;
	printf("void shows_value()");
	/* getchar(); */


	k=0;
	for(i=1;i<=ttl_node;i++){
		if(++k==10){
		    printf("void shows_value()");
		    /* getchar(); */


		    k=0;
		}
		printf("%d%dvalue[%d](%f<<%f)=%f=",atr[i],stt[i],i,lwr[i],uppr[i],value[i]);
		if(atr[i]==0)
		for(j=1;j<=srnd_num[i];j++)
		  printf("+%f[%d]",-1.0/rel[i*CIRCUM+j]*value[srnd[i*CIRCUM+j]],srnd[i*CIRCUM+j]);
		v=0;
		for(j=1;j<=srnd_num[i];j++){
		 v+=-1.0/rel[i*CIRCUM+j]*value[srnd[i*CIRCUM+j]];
		}
		printf("\n");
	}
	printf("void shows_value()");
	/* getchar(); */


	return;
}

void shows_value2()
{
	int k,i,j,n;
	double v;
	printf("void shows_value2()");
	/* getchar(); */


	k=0;
	for(n=1;n<=nst_num;n++){
	 	i=can_nst[n];
		if(++k==10){
		    printf("void shows_value2()");
		    /* getchar(); */


		    k=0;
		}
		printf("%d%dvalue[%d](%f<<%f)=%f=",atr[i],stt[i],i,lwr[i],uppr[i],value[i]);
		if(atr[i]==0)
		for(j=1;j<=srnd_num[i];j++)
		  printf("+%f[%d]",-1.0/rel[i*CIRCUM+j]*value[srnd[i*CIRCUM+j]],srnd[i*CIRCUM+j]);
		v=0;
		for(j=1;j<=srnd_num[i];j++){
		 v+=-1.0/rel[i*CIRCUM+j]*value[srnd[i*CIRCUM+j]];
		}
		printf("\n");
	}
	printf("void shows_value2()");
	/* getchar(); */


	return;
}
void shows_change()
{
	int k,i,j,n;
	printf("void shows_change()");
	/* getchar(); */


	k=0;
	printf("nst_num=%d\n",nst_num);
	for(n=1;n<=nst_num;n++){
	 	i=can_nst[n];
		if(++k==10){
		    printf("void shows_change()");
		    /* getchar(); */


		    k=0;
		}
		printf("[%d]:+%f*%f=%f\n",i,diff[i],min_ch,value[i]);
	}
	printf("void shows_change()");
	/* getchar(); */


}

void impr()
{
	int i,j,k,m,sl,now,sncnd_num,son,pa1,pa2,*bottom,btm_num,*son_cand,ok,*pointed,*alrdy,see;
	son_cand=(int*)calloc(STRUCT*CIRCUM, sizeof(int));
	alrdy=(int*)calloc(ALL, sizeof(int));
	bottom=(int*)calloc(STRUCT, sizeof(int));
	pointed=(int*)calloc(SLACK, sizeof(int));
         printf(" improvement jointed\n");
	btm_num=0;
	for(i=1;i<=ttl_node;i++){
	    pointed[i]=0;
	    alrdy[i]=0;
	    if(srnd_num[i]==papa_num[i]){
		  bottom[++btm_num]=i;
	   }
	}
	printf("void inpr()");
	/* getchar(); */


         printf(" improvement jointed2\n");
        for(i=1;i<=btm_num;i++){
         sncnd_num=1;
         son_cand[1]=bottom[i];
         now=0;
	 see=0;
         if(flt(value[bottom[i]]-1.0)==0.0){
		  ok=1;
	   while(now<sncnd_num){
		  if(flt(value[son_cand[++now]]-1.0)==0.0) son=son_cand[now];
		   if(see=1) printf(">%d\n",son);
		  for(j=1;j<=papa_num[son];j++){
			  pa1=papa[son*CIRCUM+j];
			  if(see=1) printf("(%d)>>%d\n",j,pa1);			  
			  draws_line(son,pa1,2);
			  pointed[pa1]++;
			  for(k=2;k<=srnd_num[pa1];k++) alrdy[srnd[pa1*CIRCUM+k]]=0;
  		          if(flt(value[pa1]+1.0*pointed[pa1]-uppr[pa1])>0.0){
				 pa2=papa[pa1*CIRCUM+1];
	 			 if(see=1) printf("(%d)>>>%d [%d pointed by %d links]\n",
					           j,pa2,pa1,pointed[pa1]);		
				 draws_line(pa2,pa1,2);
				 XFlush(d);
			 printf("%d%d%d\n",alrdy[pa2]==0,flt(value[pa2])==1.0,pa2!=goal);/**R**/
			         if(alrdy[pa2]==0&&flt(value[pa2])-1.0==0.0&&pa2!=goal)/**R**/{
					alrdy[pa2]=1;
					son_cand[++sncnd_num]=pa2;
				}
				 else{
				     if(see=1){ 
					 printf("************* give up ****\n");
					 printf("void impr()");
					 /* getchar(); */


				     }
					  ok=0;
					 break;
				}			
			  }
		  }
		  if(ok==0) break;
	   }
	   for(j=1;j<=sncnd_num;j++) alrdy[son_cand[j]]=0;
           printf("ok=%d\n",ok);
	   if(ok==1){
		 if(see=1){
		     printf("***************\n");			  
		     printf("void impr()");
		     /* getchar(); */


		 }
		for(j=1;j<=sncnd_num;j++){
			 value[sl=son_cand[j]]=0.0;
			 for(k=1;k<=srnd_num[sl];k++) {
				value[srnd[sl*CIRCUM+k]]-=rel[sl*CIRCUM+k];
				printf("change %d\n",srnd[sl*CIRCUM+k]);
			}
		}
	    }
	    for(j=1;j<=sncnd_num;j++){
		if(son_cand[j]!=goal)	  /**R**/
			for(m=1;m<=papa_num[son_cand[j]];m++)
			  pointed[papa[son_cand[j]*CIRCUM+m]]=0;
            }
        }
     }

	printf("END AS SUCCESS\n");

	free(son_cand);
	free(alrdy);
	free(bottom);
	free(pointed);

	return;
}
	 
int simpl2(flow,reach,erst,choice)  /** Reduction from areas into groups  **/
double *flow,*reach;
int erst,choice;
{
	int i,j,h,node1,sri,*nd1_cand,*in,nd1_num,end,grp,sm2_end,
	    lk,*mark3,min_rm,*cand,node,*alrdy,*alr_can,k,stt_1;
	in=(int*)calloc(ALL, sizeof(int));
	cand=(int*)calloc(STRUCT, sizeof(int));
	nd1_cand=(int*)calloc(STRUCT, sizeof(int));
	alrdy=(int*)calloc(ALL, sizeof(int));
	alr_can=(int*)calloc(ALL, sizeof(int));
	mark3=(int*)calloc(NEST*CIRCUM, sizeof(int));/* Already check of links as candidates */
	/*printf("         simpl2 jointed,erst=%d,choice=%d\n",erst,choice);*/
	stt[choice]=0;

				/*****  the initial area of the initial group is defined. ***/
				/****  the initial node for each group is node1. ***/
	
	grp=0;			/*** the first group is grp=0  ***/
	nd1_num=1;		/*** nd1_num,the candidates for node1 to begin the next group*/
	sum=-1;			/*** sum is the total number of areas ever passed through*/
	nd1_cand[1]=erst;		/*** the first node1 is node1=erst (necessarily strctr) ***/
		for(i=1;i<=nst_num;i++){
			node=can_nst[i];
			alrdy[node]=alr_can[node]=0;
			in[node]=in_arr[node];
			if(atr[node]==0)
			for(j=1;j<=srnd_num[node];j++){
				if(lnk_of_nst[lk=link[node*CIRCUM+j]]==1
				   &&arrow[lk]==-1){
					  in[node]-=1;
			  }
                      }
		}
	end=0;	
	sm2_end=0;
	min_rm=CIRCUM;
	for(i=1;i<=link_num;i++) mark3[i]=0;
	while(1)	{
		sm2_end=1;
		for(i=1;i<=nd1_num;i++){	/** find the initial area not passed yet.**/
			if(alrdy[nd1_cand[i]]==0){
				node1=nd1_cand[i];
				sm2_end=0;
				break;
			}
		}
		if(sm2_end==1)   break;
		grp_num=++grp;
		for(h=1;h<=nst_num;h++){
		  flow[grp_num*NEST+h]=0.0;
		  rate[grp_num]=0.0;
		}

		for( i=1; i<=grp; i++) reach[grp_num*NEST+1]=0.0;
		core[grp]=node1;		/*** the core, the root node of next gorup **/
		flow[grp*NEST+nst_th[node1]]=1.0;
		nxt=0;			/*** 'nxt' is the count of passed areas in the group**/
		cand_num=1;			
		alr_can[node1]=1;
		cand[1]=node1;				/** the initial area is set .**/

		while(nxt<cand_num)	if(alrdy[cand[++nxt]]==0){
			node=cand[nxt];
			alrdy[node]=1;		/** the next passing area is added.**/
			sum+=2;	/* sum increases by 2 (1 triangle  + 1 circle)per Step*/
			for(i=1;i<=srnd_num[node];i++){	/** the surrounding areas**/ 
			   if(mark2[sri=srnd[node*CIRCUM+i]]==1&&mark3[link[node*CIRCUM+i]]==0){
				mark3[link[node*CIRCUM+i]]=1;
				if(stt[sri]==1&&in_ex==1){
					draws_line(node,srnd[node*CIRCUM+i],2);
					XFlush(d);
					if(in_ex==1&&cycle_num==4) 
					    printf("int simpl2");
					    /* getchar(); */


				}


				for(j=1;j<=grp;j++){	/** for the flows from passed groups**/
					flow[j*NEST+nst_th[sri]]
					  +=flow[j*NEST+nst_th[node]]*rel[node*CIRCUM+i];
				}
				in[sri]++;
				if(stt[sri]==1&&in[sri]==srnd_num[sri]-1){
					
					for(k=1;k<=srnd_num[sri];k++){
						if(alrdy[srnd[sri *CIRCUM+ k]]==0&&mark2[srnd[sri *CIRCUM+ k]]==1
						  &&alr_can[srnd[sri *CIRCUM+ k]]==0){
                            			  mark3[link[sri*CIRCUM+k]]=1;

						if(in_ex==1){
							draws_line(sri,srnd[sri*CIRCUM+k],2);
							XFlush(d);
					if(in_ex==1&&cycle_num==4)
					    printf("int simpl2");
					    /* getchar(); */


						}

						  for(j=1;j<=grp;j++){
							  flow[j*NEST+nst_th[srnd[sri *CIRCUM+ k]]]
							+=flow[j*NEST+nst_th[sri]]*rel[sri*CIRCUM+k];
						  }
						  break;
						}  
					}
					cand[++cand_num]=srnd[sri *CIRCUM+ k];

					alr_can[cand[cand_num]]=1;
				}
		 /**** cand is the candidate of the nxt area in the same group ***/
				if(stt[sri]==1&&in[sri]==srnd_num[sri]){
					end++;
					sum++;
					if(grp-1<end){
						stt[choice]=1;
						printf("[choice %d],erst %d dead on %d, grp %d end %d\n",
							choice,erst,sri,grp,end);		
						return(1);
					}
					else for(j=1;j<=grp;j++){
						reach[j*NEST+ end]=flow[j*NEST+nst_th[sri]];

         				}
				}


			     if(stt[sri]==1&&in[sri]<=srnd_num[sri]-2){
				

			       for(j=1;j<=srnd_num[sri];j++){
				    if(alrdy[srnd[sri *CIRCUM+ j]]==0&&mark2[srnd[sri *CIRCUM+ j]]==1)
					 nd1_cand[++nd1_num]=srnd[sri*CIRCUM+ j];
			       }
			     }
			}
		   }
		 /**** nd1_cand is the candidate of the initial area in the nxt group ***/

	         }
	}

	stt[choice]=1;
	free(in);
	free(cand);
	free(nd1_cand);
	free(alrdy);
	free(alr_can);
	free(mark3);
	return(0);
}

void solves(reach)
double *reach;
{
	int i,j,k,dark_arr;
	double others,r;
/*printf("grp_num=%d\n",grp_num);*/
	  if(grp_num>=2){
  		for(i=1;i<=grp_num-1;i++){
			for(j=1;j<=grp_num-1;j++)if(i!=j){
				if(flt(reach[i*NEST+i])!=0.0)
				  r=reach[i *NEST+ j]/reach[i *NEST+ i];
				else r=0.0;
				for(k=1;k<=grp_num;k++){
					reach[k *NEST+ j]-=r*reach[k *NEST+ i];
				}
			}
		}
		rate[grp_num]=1.0;
		dark_arr=0;
		for(j=1;j<=grp_num-1;j++) 
		  if(flt(reach[j*NEST+j])==0.0) dark_arr=1;
		if(dark_arr==0)
		for(j=1;j<=grp_num-1;j++){
			if(flt(reach[j*NEST+j])!=0.0)
			   rate[j]=-1.0*reach[grp_num *NEST+ j]/reach[j *NEST+ j];
			else rate[j]=0.0;
		}
		else{
			for(j=1;j<=grp_num-1;j++) 
			  if(flt(reach[j*NEST+j])==0.0) 
			     rate[j]=1.0;
			rate[grp_num]=0.0;
		}
	  }
	   else rate[1]=1.0;

	return;	
}


void slct_wh(flow)
double *flow;
{
	int count,g,h;	
        for(h=1;h<=nst_num;h++) diff[can_nst[h]]=0.0;
	for(g=1;g<=grp_num;g++){
	  for(h=1;h<=nst_num;h++){

		  diff[can_nst[h]]+=flow[g*NEST+h]*rate[g];
/*		  if((can_nst[h]==61||can_nst[h]==62||can_nst[h]==65)&&cycle_num==4&&in_ex==1)
		     &&cycle_num==4&&in_ex==1)
			 printf("%d, diff[%d]=%f, flow=%f, rate[%d]=%f\n",g,can_nst[h],diff[can_nst[h]],
		     	flow[g*NEST+h],g,rate[g]); 
*/
				

	  }
       }


	return;
}

double abs_f(x)
double x;
{
	double y;
	if(x<0.0) y=-1.0*x;
	else      y=x;
	return(y);

}

int abs_i(x)
int x;
{
	int y;
	if(x<0) y=-1*x;
	else      y=x;
	return(y);

}



int selects(choice)
int choice;
{
	int i,k,n,cnt_wh,cnt_wc,div,br,*stnby;
	double direct,*want;
	stnby=(int*)calloc(10, sizeof(int));
	want=(double*)calloc(ALL, sizeof(double));         /*10K*/
	/* want is the wanted additional value to each */
	 /* node to be non-basic */
	cnt_wh=0;
	cnt_wc=0;
	min_ch=100000.0;
	minch1=100000.0;
        /*for(i=1;i<=ttl_node;i++) printf("diiff[%d]=%f\n",i,diff[i]);*/

	direct=(value[choice]-0.5*(uppr[choice]+lwr[choice]))/diff[choice];
	/* If direct is +, values of nodes with diff>0 must decrease */ 
	for(i=1;i<=nst_num;i++){
		n=can_nst[i];
		if(stt[n]==0||choice==n){
			if(flt(direct*diff[n])<=0.0)  /** if the strctr must increase **/
					/*want is the wanted change of n */
				want[n]=uppr[n]-value[n];
			 else   want[n]=lwr[n]-value[n];
				 /* if this is the first white checked, or   */
				/* if the effect to the choice is the least ever */

			if(flt(diff[n])!=0.0&&(++cnt_wh==1||abs_f(want[n]/diff[n])<=abs_f(min_ch))){
			        div=n;  		/** div xis the best white of all*/
				/*printf("%d,",div);*/
				min_ch=want[n]/diff[n];
			}
			
			if(flt(diff[n])!=0.0&&atr[n]==1/** if the node is circle,and if**/
			    &&(cnt_wc==0||abs_f(want[n]/diff[n])<=abs_f(minch1))
			  ){
				++cnt_wc;
         	 		divc=n;
				/** div is the best white of circle*/
			  	minch1=want[n]/diff[n];
			}
		}
	}
	if(flt(abs_f(min_ch)-abs_f(minch1))==0.0){
	    div=divc;
	}
	free(stnby);
	free(want);
	return(div);
}



void input_newversion(strth,slkth,argv,argc)
int *strth, *slkth, argc;
char *argv[];
{
	int or,ch,*c,i,j,common,*rght,left,one_wrd,*inv,*queried,
	    *ichbn,*nd_br,*lft_hstry,skip_line,*replied,
	     exist_read_line,line,found,*common_1;
	int kuhaku;
	double ex_depth;
	common_1=(int*)calloc(1, sizeof(int));
	c=(int*)calloc(1, sizeof(int));
	inv=(int*)calloc(1, sizeof(int));
	queried=(int*)calloc(ALL, sizeof(int));
	replied=(int*)calloc(ALL, sizeof(int));
	nd_br=(int*)calloc(STRUCT*100, sizeof(int));
	rght=(int*)calloc(10, sizeof(int));
	lft_hstry=(int*)calloc(SLACK, sizeof(int));
	ichbn=(int*)calloc(SLACK, sizeof(int));

	ttl_node=0;
	slk_num=0;
	str_num=0;
	and_num=0;
	nd_max=0;
	br_num[0]=0;
	bnk=0;
	link_num=0;	
	one_wrd=0;
	ex_depth=1.25;
	skip_line=0;
	exist_read_line = 1;
        while(exist_read_line){  
	    printf("exist_read_line %d\n", exist_read_line);
	          if((fp=fopen( argv[1],"r"))==NULL){
			printf("can't open file %s\t",*argv);
			exit(1);
		   }
		  line=1;
		  exist_read_line=0;

		  while((*c=getc(fp))!=EOF) {

			if(*c=='\n') line++;
			else kuhaku = 1;

			if(skip_line==0||*c=='\n') {
			    printf("%c",*c);
			    switch (*c){ 
			    case '\n':
				if(kuhaku==0) break;
				ex_depth*=0.8;
				if(skip_line){
				    skip_line = 0;
				    node = 0;
				    kuhaku = 0;
				    break;
				}
				period(ichbn,left,rght,right_num,
				       ex_depth,common_1);
				node = 0;
				kuhaku = 0;
				break;
			    case '-':
				right_num=0;
				if(*inv==0) one_wrd=0;
				if((queried[node]==0||replied[line]==1)
				   &&(one_wrd!=1||replied[line]==1)){
				    skip_line=1;
				    break;
				}
				else{
				    replied[line]=1;
				    exist_read_line=1;
				}
				left=hihn(common,chld,
					  chld_num,lft_bnk,lft_hstry,ichbn);
				if(one_wrd==1){				
				    if(*inv==2){
					goal=leaf[node];
					uppr[goal]=1.0;
					lwr[goal]=1.0;
					is_goal[goal]=1;
				    }	      
				    else if(*inv==1) {
					inc=leaf[node];
					uppr[inc]=0.0;
					lwr[inc]=0.0;
					is_inc[inc]=1;
				    }
				}  
				one_wrd=0;
				node=0;
				break;
			    case ',':
				queried[node]=1;
				collon(common,common_1,left,rght);
				node=0;
				one_wrd=0;   		
				break;
			    default:
				*inv=0;  
				found=search(nd_br,c,inv);
				if(found==0){
				    queried[node]=0;
				    replied[node]=0;
				}
				common=queried[node];
				one_wrd++;
			    }
			}
		    }
	    fclose(fp);
	}  
								
	/*** Below, those nodes appeared in the left sides before are treated as 'lft_bnk' **/					
	printf("2[2]=%d,srnd_num %d\n",srnd[2*CIRCUM+2],srnd_num[2]);

	for(i=1;i<=bnk;i++)
	  if(is_inc[lft_bnk[i]]==0){
		and_chlds[lft_bnk[i]]=0;
		or=new_slack(chld_num[lft_bnk[i]]+1,0.0,-100.0);
		bound[ttl_node]=2;
                relative(or,lft_bnk[i],1,(++srnd_num[lft_bnk[i]]),-1.0);
	printf("1*2[2]=%d,srnd_num %d\n",srnd[2*CIRCUM+2],srnd_num[2]);
		papa[or*CIRCUM+(papa_num[or]=1)]=srnd[or*CIRCUM+1];
	/***** Above 4 lines refers to   OR slack.VS. the left bank ***/   
		for(j=1;j<=chld_num[lft_bnk[i]];j++){
			ch=chld[lft_bnk[i]*CIRCUM+j];
			new_slack(2,100.0,0.0);
			bound[ttl_node]=0;
	/**** Above, child nodes and completeness nodes are defined ***/
			relative(lft_bnk[i],ttl_node,
				 ++srnd_num[lft_bnk[i]],1,1.0);
	 /***** Above 4 lines refers to   completeness slack.VS. left banks ***/   
			relative(ch,or,++srnd_num[ch],j+1,-1.0);
			papa[ch*CIRCUM+(++papa_num[ch])]=or;
	/***** Above 4 lines refers to   OR slack.VS. children ***/   
			relative(ch,ttl_node,++srnd_num[ch],2,-1.0);
			papa[ttl_node*CIRCUM+(papa_num[ttl_node]=1)]=lft_bnk[i];
			papa[ch*CIRCUM+(++papa_num[ch])]=ttl_node;	
	 /***** Above 4 lines referpps to   completeness slack.VS. children ***/ 
	 /** OR's constraints are y>=any x, y<=sum of all x. **/
  		
		}
	}


	for(i=1;i<=slk_num;i++)	slkth[slack[i]]=i;
	
	for(i=1;i<=str_num;i++)	strth[strctr[i]]=i;
	for(i=1;i<=str_num;i++)	{
            atr[strctr[i]]=1;
            if(is_inc[strctr[i]]==0&&is_goal[strctr[i]]==0){
		uppr[strctr[i]]=1.0;
		lwr[strctr[i]]=0.0;
            }
	}
	for(i=1;i<=slk_num;i++)
		atr[slack[i]]=0;
	 for(i=1;i<=str_num;i++)
		 bound[strctr[i]]=1;
/**R**lwr, uppr[node+pointed]=0 or 1****/
       
	free(replied);
	free(c);
	free(queried);
	free(inv);
	free(nd_br);
	free(rght);
	free(lft_hstry);
	free(ichbn);
	free(common_1);
	return;
}


void relative(a,b,b_of_a,a_of_b,rateab)
int a,b,b_of_a,a_of_b;
double rateab;
 {
     
	double rateba;
	rateba=-1.0/rateab;
 	srnd[a*CIRCUM+b_of_a]=b;
	rel[a*CIRCUM+b_of_a]=rateab;
	srnd[b*CIRCUM+a_of_b]=a;
	rel[b*CIRCUM+a_of_b]=rateba;
	link[a*CIRCUM+b_of_a]
       =link[b*CIRCUM+a_of_b]
       =++link_num;
/*	if(a==3 || b==3) printf("[%d and %d connected by %dth]\n",a,b,b_of_a);*/
	return;
}

int new_strctr(neighbors)
int neighbors;
{
	int added;
        added=strctr[(++str_num)]
	      =++ttl_node;
	rght_sonae[added]=0;

	/*printf("newly %d (str)\n",added);*/
	cost[added]=1.0;
	uppr[added]=1.0;
	lwr[added]=0.0;
	atr[added]=1;
	srnd_num[added]=neighbors;
	is_inc[added]=0;
	is_goal[added]=0;
	printf("(%d)",added);
	return(added);
}

int new_slack(neighbors,up,lw)
int neighbors;
double up,lw;
{
	int added;
        added=slack[(++slk_num)]
	      =++ttl_node;
	/*printf("newly %d (slk)\n",added);*/
	uppr[added]=up;
	lwr[added]=lw;
	atr[added]=0;
	srnd_num[added]=neighbors;
	papa_num[added]=chld_num[added]=and_chlds[added]=stt[added]=0;
	printf("[%d]",added);
        return(added);

}

void period(ichbn,left,rght,right_num,ex_depth,common_1)
int *ichbn,left,*rght,right_num,*common_1;
double ex_depth;
{
	int j,and,ch;

	if(right_num==1&&*common_1==0){
		and_chlds[left]=0;
		leaf[node_1]=left;
		and_left[++and_num]=left;
	}
	else{
		and=new_slack(right_num+1,100.0,1.0-(double)right_num);
		and_chlds[left]=right_num;
		bound[and]=0;
		and_left[++and_num]=left;
		if(ichbn[left]==0)
			 /* ichbn is the first sita neighbor of the left */
			ichbn[left]=slack[slk_num];
		relative(left,and,++srnd_num[left],1,1.0);
		papa[and*CIRCUM+(papa_num[and]=1)]=srnd[and*CIRCUM+1];
		/***** Above 4 lines refers to   AND slack.VS. the left  ***/   
		for(j=1;j<=right_num;j++){
	 		ch=rght[j];
			cost[ch]=cost[left]/right_num;
			  /* For slack cost def. after input()*/
			and_ch[left*CIRCUM+j]=new_slack(2,0.0,-100.0);
			bound[ttl_node]=2;		        
			 /*  childs and completenesses  ***/
			relative(left,ttl_node,++srnd_num[left],1,1.0);  
			/* completeness.VS. left */   
			relative(ch,and,++srnd_num[ch],j+1,-1.0);
			papa[ch*CIRCUM+(++papa_num[ch])]=and;		
			/*  AND slack.VS. children */   
			relative(ch,ttl_node,++srnd_num[ch],2,-1.0);
			papa[ttl_node*CIRCUM+(++papa_num[ttl_node])]=left;
			papa[ch*CIRCUM+(++papa_num[ch])]=ttl_node;	
			/*completenes.VS. children */   
		}
	}
	return;
}		

int hihn(common,chld,chld_num,lft_bnk,lft_hstry,ichbn)
int common,*chld, *chld_num,*lft_bnk,*lft_hstry,*ichbn;
{  	
	int i,j,ch,trade,left,and;
	if(common==1){
	left=leaf[node];
		printf("and_chlds[%d]=%d\n",left,and_chlds[left]);

	if(lft_hstry[node]==1&&and_chlds[left]==0){
	}

	
	if(lft_hstry[node]==1&&is_inc[left]==0){
		if(chld_num[left]==0){
		/* so that this is the second app. as left*/
		/* chld_num is number of children of left as head of OR rule */
			lft_bnk[++(bnk)]=left;
			/*** the former node becomes the first child's papa ***/
			chld[left*CIRCUM+(++chld_num[left])]
			    =new_strctr(and_chlds[left]+(and_chlds[left]>0));
			/* ttl_node <-> left */

			leaf[rght_sonae[left]]=ttl_node;
			for(j=1;j<=srnd_num[left];j++){
				if(srnd[left*CIRCUM+j]==ichbn[left]){
					relative(ttl_node,ichbn[left],1,1,rel[left*CIRCUM+j]);
					papa[ichbn[left]*CIRCUM+1]=ttl_node;
					link_num-=1;
					link[ttl_node*CIRCUM+1]=link[ichbn[left]*CIRCUM+1]
					  =link[left*CIRCUM+j];
					break;
				}	
			}
	                /** and_ch  is slack node where chld are OR's structural children */
 			for(i=1;i<=and_chlds[left];i++){

				ch=and_ch[left*CIRCUM+i];
				srnd[ttl_node*CIRCUM+i+1]=ch;
				papa[ch*CIRCUM+1]=ttl_node;
				for(j=1;j<=srnd_num[left];j++){
 					if(srnd[left*CIRCUM+j]==ch){
						link[ttl_node*CIRCUM+i+1]=link[left*CIRCUM+j];
						rel[ttl_node*CIRCUM+i+1]=rel[left*CIRCUM+j];
						break;
					}	
				}	
				and_ch[ttl_node*CIRCUM+i]=ch;
				for(j=1;j<=srnd_num[ch];j++){
					if(srnd[ch*CIRCUM+j]==left){
						srnd[ch*CIRCUM+j]=ttl_node;
						break;
					}
				}	
			} 
			and_chlds[ttl_node]=and_chlds[left];
			for(i=1;i<=and_num;i++)	  if(and_left[i]==left) and_left[i]=ttl_node;
			bound[left]=0;				
			bound[ttl_node]=0;				
			trade=0;
			for(i=1;i<=srnd_num[left];i++){
				if(srnd[left*CIRCUM+i]==ichbn[left])
					trade=1;
				if(trade==1){	
					srnd[left*CIRCUM+i]=srnd[left*CIRCUM+i+1+and_chlds[left]];
					rel[left*CIRCUM+i]=rel[left*CIRCUM+i+1+and_chlds[left]];
					link[left*CIRCUM+i]=link[left*CIRCUM+i+1+and_chlds[left]];
				}
			}

			srnd_num[left]-=and_chlds[left]+(and_chlds[left]>0);


		}	
		   /*** the current node becomes the second or some-th child ***/
		chld[left*CIRCUM+(++chld_num[left])]=new_strctr(0);
		left=ttl_node;
	}
	else{	
		lft_hstry[node]=1;
		ichbn[left]=0;
	}
    }
    else{
	  left=new_strctr(0);
	  ichbn[left]=0;
	  lft_hstry[node]=1;
	  chld_num[left]=0;
	  leaf[node]=left;
    }

    return(left);
}			

void collon(common,common_1,left,rght)
int common,*common_1,left,*rght;
{				  
    
	switch(++right_num){
		case 1 :
			  if(common==1)	 rght[1]=leaf[node];
			  else{
			      rght_sonae[left]=node;
			      leaf[rght_sonae[left]]=left;
			  }
	                  *common_1=common;
		  	  node_1=node;
			  break;
		case 2 : 
		         rght_sonae[left]=0;
			 if(*common_1==0) leaf[node_1]=rght[1]=new_strctr(0);
		 	    if(common==0)    leaf[node]=rght[2]=new_strctr(0);
	                    else            rght[2]=leaf[node];
			  break;	
		default : 
			   if(common==1)	rght[right_num]=leaf[node];
			   else{
				 rght[right_num]=new_strctr(0);
				 leaf[node]=ttl_node;
			   }


	}
	return;
}



int search(nd_br,c,inv)
int	*nd_br,*c,*inv;
{
	int common,i;	
	*inv=0;
	common=0;
	printf("%d\n",br_num[node]);
       
	for(i=1;i<=br_num[node];i++){
	    if(lttr[nd_br[node*CIRCUM+i]]==*c){
			common=1;
			node=nd_br[node*CIRCUM+i];
			break;
		}
	}
				
	if(common==0){
		nd_br[node*CIRCUM+(++br_num[node])]=++nd_max;
		br_num[nd_max]=0;
		sugu_ue[nd_max]=node;
		node=nd_max;
		lttr[nd_max]=*c;
	}
	if(*c=='0') *inv=1;
	if(*c=='1') *inv=2;
	return(common);
}
	
/* In this function, reducive sy0mplex method is neccesary */
/*for many hyper plains cross together.*/
void symplex(strth,slkth)
int *strth,*slkth;
{
	int smp_cyc,i,j,n,piv_w,sri,tate,k,yoko,sl,str,slk,*white,piv_b,amr,ul,v,
	    feasible,geta,tp,*wht,*stay,arere,w,*virgin;
/*	int *are;  */
	double *tmp_cst,rg,elm,rt,*elmnt,max_opt,min,max,*rgh_end,elm1;
	stay=(int*)calloc(STRUCT, sizeof(int));
/*	are=(int*)malloc(ALL*ALL*sizeof(int));  */
	elmnt=(double*)malloc(ALL*ALL*sizeof(double));
	rgh_end=(double*)calloc(ALL, sizeof(double));
	white=(int*)calloc(ALL, sizeof(int));
	tmp_cst=(double*)calloc(ALL, sizeof(double));
	wht=(int*)calloc(ALL, sizeof(int));
	virgin=(int*)calloc(ALL, sizeof(int));

	/*** bound=2 when uppr, 0 when lower 1 when both ***/
	/*** element[x][y] is the [x]th collum, [y]th line  ***/
/****  initization  ******/
	tate=slk_num+and_num+1;
	yoko=slk_num+str_num+and_num+1;
	getrusage(RUSAGE_SELF,&rus);
	cputime=rus.ru_utime.tv_sec + rus.ru_utime.tv_usec*1.0e-6;
	/*printf("runtime symp.1=%9.2f[s]\n",cputime-cputime1);*/
	for(i=1;i<=yoko;i++){	  
	        stay[i]=0;
		for(j=1;j<=tate;j++){
		  elmnt[i*ALL+j]=0.0;
		}            
	}
	for(slk=1;slk<=slk_num;slk++){
		sl=slack[slk];
		if(bound[sl]==2) rgh_end[slk]=uppr[sl];
		if(bound[sl]==0) rgh_end[slk]=lwr[sl];			
		for(i=1;i<=srnd_num[sl];i++){
			sri=srnd[sl*CIRCUM+i];
/**R**/			if(is_inc[sri]==1) rgh_end[slk]+=-1.0/rel[sl*CIRCUM+i];
			elmnt[(slk_num+strth[sri])*ALL+slk]=1.0/rel[sl*CIRCUM+i];
			wht[slk_num+strth[sri]]=0;
			rgh_end[slk]-=-1.0/rel[sl*CIRCUM+i];
		}
		elmnt[slk*ALL+slk]=bound[sl]-1.0;
		white[slk]=slk;
		wht[slk]=1;
	}
	for(i=1;i<=and_num;i++){
		str=strth[and_left[i]];
		elmnt[(slk_num+str)*ALL+slk_num+i]=1.0;
		elmnt[(slk_num+str_num+i)*ALL+slk_num+i]=1.0;
		if(is_inc[and_left[i]]==1||is_goal[and_left[i]]==1){
		  stay[slk_num+str_num+i]=stay[slk_num+str]=1;
		  rgh_end[slk_num+i]=0.0;
	        }
		else rgh_end[slk_num+i]=1.0;
		white[slk_num+i]=slk_num+str_num+i;
		wht[slk_num+str_num+i]=1;
	}

/**R**stay[node_ponited]=1;/ 
	/*** Special statements for the goal *********/
	str=strth[goal];
	printf("goal %d,str %d\n",goal,str);
	elmnt[(slk_num+str)*ALL+slk_num+and_num+1]=1.0;
	elmnt[(slk_num+str_num+and_num+1)*ALL+slk_num+and_num+1]=1.0;
	stay[slk_num+str_num+and_num+1]=stay[slk_num+str]=1;
	rgh_end[slk_num+and_num+1]=0.0;
	white[slk_num+and_num+1]=slk_num+str_num+and_num+1;
	wht[slk_num+str_num+and_num+1]=1;
	
	bst_cst=0;

	for(i=1;i<=slk_num;i++)	tmp_cst[i]=0;
	for(i=1;i<=str_num;i++)	bst_cst+=tmp_cst[slk_num+i]=-cost[strctr[i]];

/*          THE SYMPLEX TABLAU                                            */
/*________________________________________________________________________*/
/* up?		*  *			if up uppr-1.0/rel(sl to str)-..  */
/*   up?	*   * *			if lwr lwr			  */
/*     up?	  *   *							  */
/*       *	  * *    *						  */
/*         *	*  *   *						  */
/*           *	 *   *  *						  */
/*	      	1.0	    1		if and_left=goal or inc 0.0	  */
/*		    1.0	      1		else 1.0			  */
/* 		  1		1					  */
/*		     1            1					  */
/*____________|_____________|________|					  */
/* slk_num      str_num   	   and_num                                */
/*              uppr-x         x-lwr                                       */

/** shows elements is supposed to be here **/
	getrusage(RUSAGE_SELF,&rus);
	cputime=rus.ru_utime.tv_sec + rus.ru_utime.tv_usec*1.0e-6;
	/*printf("runtime symp.2=%9.2f[s]\n",cputime-cputime1);*/

/****  symplex method  ******/

	feasible=smpl_cycle(tate,yoko,stay,tmp_cst,elmnt,rgh_end,white,wht,virgin);	
	printf("feasible=%d\n",feasible);
	if(feasible==0){
	     feasible=smpl_cycle2(tate,yoko,stay,tmp_cst,elmnt,rgh_end,white,wht,virgin);	
	printf("feasible2=%d\n",feasible);
	     feasible=smpl_cycle(tate,yoko,stay,tmp_cst,elmnt,rgh_end,white,wht,virgin);
	printf("feasible3=%d\n",feasible);			
	}

	else flg_out=0;
	getrusage(RUSAGE_SELF,&rus);
	cputime=rus.ru_utime.tv_sec + rus.ru_utime.tv_usec*1.0e-6;
/*	printf("runtime symp.3=%9.2f[s]\n",cputime-cputime1);*/

/**************END of SYMPLEX ******/
	/*****  at a critical point, the situation is 1, else 0. *****/
	for(i=1;i<=yoko;i++)	stt[i]=0;
	for(i=1;i<=yoko;i++)	wht[i]=0;
	for(j=1;j<=tate;j++)		    wht[white[j]]=1;;
	for(i=1;i<=slk_num;i++) 
		if(wht[i]==1)			stt[slack[i]]++;

	for(i=slk_num+1;i<=slk_num+str_num;i++)	{
		if(wht[i]==1)			stt[strctr[i-slk_num]]++;
	}	

	 for(i=1;i<=and_num;i++) 
	        if(wht[i+slk_num+str_num]==0)	stt[and_left[i]]-=1;
        if(wht[and_num+1+slk_num+str_num]==0)	stt[goal]-=1;

	for(i=1;i<=ttl_node;i++)   		stt[i]=(stt[i]==0||stt[i]==-1);
	for(i=1;i<=chld_num[inc];i++)           stt[chld[inc*CIRCUM+i]]=1;
/**R** stt[ponted==1]*/
/**  value desicion **/
	for(j=1;j<=tate;j++){
		if(white[j]<=slk_num){
			if(bound[slack[white[j]]]==2) 
				value[slack[white[j]]]
				=uppr[slack[white[j]]]
				 -rgh_end[j]/elmnt[white[j]*ALL+j];
			if(bound[slack[white[j]]]==0) 
				value[slack[white[j]]]
				=lwr[slack[white[j]]]
				 +rgh_end[j]/elmnt[white[j]*ALL+j];
                }

		else if(white[j]<=slk_num+str_num){
				value[strctr[white[j]-slk_num]]
				=uppr[strctr[white[j]-slk_num]]
				 -rgh_end[j]/elmnt[white[j]*ALL+j];
			}
                  	 else if(white[j]<=slk_num+str_num+and_num)
				   value[and_left[white[j]-str_num-slk_num]]
				   =lwr[and_left[white[j]-str_num-slk_num]]
				    +rgh_end[j]/elmnt[white[j]*ALL+j];
			      else  
				   value[goal]
				   =lwr[goal]
				    +rgh_end[j]/elmnt[white[j]*ALL+j];

        }

	for(n=1;n<=yoko;n++){
		if(wht[n]==0){
			if(n<=slk_num){
				if(bound[slack[n]]==2)	
					value[slack[n]]=uppr[slack[n]];
			        if(bound[slack[n]]==0)	
					value[slack[n]]=lwr[slack[n]];
			}	
			else	 if(n<=slk_num+str_num)  
				        value[strctr[n-slk_num]]
					 =uppr[strctr[n-slk_num]];
				else	value[and_left[n-slk_num-str_num]]
					 =lwr[and_left[n-slk_num-str_num]];
		}
	}

	getrusage(RUSAGE_SELF,&rus);
	cputime=rus.ru_utime.tv_sec + rus.ru_utime.tv_usec*1.0e-6;
/*	printf("runtime symp.4=%9.2f[s]\n",cputime-cputime1);*/
/*	printf("void symplex");
	Tcl_Eval(interp, "bind .e {puts state 1}");
	Tcl_Eval(interp, "button .f -text test -command exit");
	Tcl_Eval(interp, "pack .f");
	Tk_MainLoop();   */
/*	free(are);  */
	free(elmnt);
	free(rgh_end);
	free(white);
	free(tmp_cst);
	free(wht);
	free(stay);
	free(virgin);
	return;
}



int smpl_cycle(tate,yoko,stay,tmp_cst,elmnt,rgh_end,white,wht,virgin)
int tate,yoko,*stay,*white,*wht,*virgin;
double *tmp_cst,*elmnt,*rgh_end;
{
    int i,j,n,ok,ok1,jdg_stp,piv_b,piv_w,feasible;
    double max_opt,min,elm,elm1,rg,rt,*warizan;
	warizan=(double*)calloc(ALL, sizeof(double));
    jdg_stp=0;
    while(jdg_stp==0){
        ok=0;
        ok1=0;
	max_opt=0.0;
	for(i=1;i<=yoko;i++)	
       	if((stay[i]==0||i<=slk_num+str_num)
	   &&flt(tmp_cst[i])<0.0&&tmp_cst[i]<max_opt){
			ok1=1;
			max_opt=tmp_cst[i];
			piv_b=i;
	}
	virgin[piv_b]=0;
        min=10000000.0;
	if(ok1==1) 
	  for(n=1;n<=tate;n++){
              if(flt(elmnt[white[n]*ALL+n]*(elm=elmnt[piv_b*ALL+n]))>0.0
		&&flt(rg=(rgh_end[n]/elm))>=0.0
		&&flt(rg-min)<=0.0){
		 min=rg;
		 piv_w=n;
		 ok=1;
	     }
        }

       if(ok==0) break;


	wht[piv_b]=1;
	wht[white[piv_w]]=0;
	white[piv_w]=piv_b;

       if(flt(elm=elmnt[piv_b*ALL+piv_w])!=0.0){
	  for(j=1;j<=tate;j++) warizan[j]=elmnt[piv_b*ALL+j]/elm;

	  for(i=1;i<=yoko;i++){
	    if(flt(elm1=elmnt[i*ALL+piv_w])!=0.0){
	      for(j=1;j<=tate;j++)
		if(j!=piv_w){
			rt=warizan[j];
			if(flt(rt)!=0.0)  {
				elmnt[i*ALL+j]-=elm1*rt;
			}
	       }
            }
          }

	  if(flt(elm1=rgh_end[piv_w])!=0.0)
	      for(j=1;j<=tate;j++)
		if(j!=piv_w){
			rt=warizan[j];
			if(flt(rt)!=0.0)    rgh_end[j]-=elm1*rt;
		}
       }

		/** thisingle line is assurance of 0 a1s 0 **/
       if(flt(elm)!=0.0){
	  rt=tmp_cst[piv_b]/elm;
	  for(i=1;i<=yoko;i++){
		  tmp_cst[i]-=elmnt[i*ALL+piv_w]*rt;
		  if(flt(tmp_cst[i])<0.0&&(1==wht[i])){
			  printf("crime is %d,whose cost is %f\n",i,tmp_cst[i]);
		    }
			    /*printf("%d%d,",(tmp_cst[i]<0.0),1-wht[i]);*/
	  }
        }

	tmp_cst[piv_b]=0.0;


	 jdg_stp=1;
	 for(i=1;i<=yoko;i++)	if(flt(tmp_cst[i])<0.0) jdg_stp=0;

       }
        feasible=1;
        for(i=1;i<=tate;i++){
		if(flt(rgh_end[i]/elmnt[white[i]*ALL+i])<0.0){
		  feasible=0;
		  break;
	        }
	}
    free(warizan);
    return(feasible);
}

int smpl_cycle2(tate,yoko,stay,tmp_cst,elmnt,rgh_end,white,wht,virgin)
int tate,yoko,*stay,*white,*wht,*virgin;
double *tmp_cst,*elmnt,*rgh_end;
{
    int i,j,n,ok,jdg_stp,piv_b,piv_w,feasible,*new_partner;
    double max_opt,min,elm,elm1,rg,rt,*warizan;
	warizan=(double*)calloc(ALL, sizeof(double));
	new_partner=(int*)malloc(ALL*ALL*sizeof(int));
    feasible=0;
    for(i=1;i<=tate;i++) warizan[i]=0.0;
    for(i=1;i<=yoko;i++)for(j=1;j<=tate;j++) new_partner[i*ALL+j]=1;
    while(feasible==0){
        ok=0;
	max_opt=0.0;
	for(i=1;i<=yoko;i++){	
	       	if((stay[i]==0||i<=slk_num+str_num)&&wht[i]==0){
			piv_b=i;
			virgin[i]=0;
		        min=10000000.0;
		     for(n=1;n<=tate;n++){
	              if(flt(elmnt[white[n]*ALL+n]*(elm=elmnt[piv_b*ALL+n]))>0.0
			&&flt(rg=(rgh_end[n]/elm))>=0.0
			&&flt(rg-min)<=0.0
			&&new_partner[piv_b*ALL+n]){
				 min=rg;
				 piv_w=n;
				 ok=1;
		     	}
		      }
	         }
	       if(ok==1) break;
	}
	new_partner[piv_b*ALL+piv_w]=0;

       if(ok==0) break;
	wht[piv_b]=1;
	wht[white[piv_w]]=0;
	white[piv_w]=piv_b;
       if(flt(elm=elmnt[piv_b*ALL+piv_w])!=0.0){
	  for(j=1;j<=tate;j++) warizan[j]=elmnt[piv_b*ALL+j]/elm;
	  for(i=1;i<=yoko;i++){
	    if(flt(elm1=elmnt[i*ALL+piv_w])!=0.0){
	      for(j=1;j<=tate;j++)
		if(j!=piv_w){
			rt=warizan[j];
			if(flt(rt)!=0.0)  {
				elmnt[i*ALL+j]-=elm1*rt;
			}
	       }
            }
          }
	  if(flt(elm1=rgh_end[piv_w])!=0.0)
	      for(j=1;j<=tate;j++)
		if(j!=piv_w){
			rt=warizan[j];
			if(flt(rt)!=0.0)    rgh_end[j]-=elm1*rt;
		}
       }

		/** thisingle line is assurance of 0 a1s 0 **/


       if(flt(elm)!=0.0){
	  rt=tmp_cst[piv_b]/elm;
	  for(i=1;i<=yoko;i++){
		  tmp_cst[i]-=elmnt[i*ALL+piv_w]*rt;
		  if(flt(tmp_cst[i])<0.0&&(1==wht[i])){
			  printf("crime is %d,whose cost is %f\n",i,tmp_cst[i]);
		    }
			    /*printf("%d%d,",(tmp_cst[i]<0.0),1-wht[i]);*/
	  }
        }

	tmp_cst[piv_b]=0.0;
        feasible=1;
        for(i=1;i<=tate;i++){
		if(flt(rgh_end[i]/elmnt[white[i]*ALL+i])<0.0)  feasible=0;

	}
       }
	if(ok==0){
		printf("NO SOLUTION\n");
		shows_graph(Tk_Width(tkwin)*3/5, 100+offset);
		printf("int smpl_cycle2()");
	        getchar();
/*		exit(1);   */
	}
        /*printf("ok=%d,ok1=%d\n",ok,ok1);*/
	free(warizan);
	free(new_partner);
	return(feasible);
}


double flt(x)
double x;
{
	double y;
	if(x<0.000001&&x>-0.000001)
	{
		y=0.0;
	}
	else y=x;
			return(y);
}

void outputs()
{
	int this,nd,i,j,*moji;
	moji=(int*)calloc(10, sizeof(int));  
 	       printf("SOLUTION SET\n");
	  for(this=1;this<=ttl_node;this++){
	      if(atr[this]==1&&flt(value[this]-1.0)==0.0){
	      if(this==99||this==100) printf("is %d, %d\n",leaf[56],br_num[56]);

		 for(nd=1;nd<=nd_max;nd++){
                    if(leaf[nd]==this&&br_num[nd]==0){
	      if(this==99||this==100) printf("*\n");
			    moji[i=1]=nd;
			    if(i==1){
				    while(moji[i]!=0){
					    moji[++i]=sugu_ue[moji[i-1]];
				    }
			    	for(j=1;j<=i;j++) printf("%c",lttr[moji[i+1-j]]);
			    	printf(",");
		            }

		    }
		}
	     }
	 }
	printf("\n");
	free(moji);  
	return;
    }

void shows_step(x)
int x;
{  
    int i;

    sprintf(num, "%d", x);
    XDrawString(d, w, gc, 50, 50, "Step ==> ", strlen("Step ==> "));
    XDrawString(d, w, gc, 260, 50, "|", strlen("|"));
    for(i=0; i<(step+1); i++) {
	XDrawString(d, w, gc, 180+10*i, 50, "|", strlen("|"));
    }
}
