% Copyright (C) 1996  Katsumi Inoue 
%
%%% pr2mgtp.pl %%%
%
%
%  translator
%        translation of Abductive Extended Disjunctive programs
%
%
% disjunction transter
% program form check
%   head cycle check
% schema1, schema2
% no schema
%

% $@1i;;;RDj5A(J
:- current_op(X,Y,(:-)),op(X,xfx,(<-)),op(X,fy,(<-)).
:- current_op(X,Y,(-)),op(X,fy,'not').


% <<<< translator >>>>
pr2mgtp :- !,
	pr2mgtp(_,_).

pr2mgtp(Mname) :- !,
	pr2mgtp(Mname,_).

pr2mgtp(Mname,Pname) :-
	var(Mname),!,
	repeat,
	printf('file name >> '),
	read(Mname),
	(Mname = exit;
	    pr2mgtp(Mname,Pname),fail).

pr2mgtp(Mname,Pname) :-
	var(Pname),!,
	filename_to_name_ext(Mname,Pname,_),
	pr2mgtp(Mname,Pname).

pr2mgtp(Mname,Pname) :-
	/* filename check */
	can_file_open_msg(read,Mname,[pr],MF),
	can_file_open_msg(write,Pname,[mgtp],PF),
	pr2mgtp_initialize,
	printf(['reading ',MF,' file',{nl}]),
	pr2mgtp_in(MF),
	printf(['transformation of Disjunction']),
	('clause'(yes) -> pr2mgtp_disjunction(1,_);true),
	/* make clause list */
	pr2mgtp_clause_list(1),
	printf([' ... ok !!',{nl}]),
	pr2mgtp_out(PF),
%	printf(['[ translate program saved in "',PF,'". ]',{nl}]),
	!.


% <<<< initialize >>>>
pr2mgtp_initialize :-
	pr2mgtp_initialize_data(Pred,Arity),
	abolish(Pred,Arity),
	fail.
pr2mgtp_initialize :- !,
	counter(init,clause),
	assertz('clause'(no)),
	assertz('form'(nodis)).

pr2mgtp_initialize_data('Predicate',1).   /* Prolog $@=R8l(J */
pr2mgtp_initialize_data('head',1).        /* $@%X%C%I%j%9%H(J */
pr2mgtp_initialize_data('dis',1).         /* Disjunct $@%j%9%H(J */
pr2mgtp_initialize_data('cl',1).          /* $@A4@a%G!<%?(J */
pr2mgtp_initialize_data('form',1).        /* Disjunction $@$NM-L5(J */
pr2mgtp_initialize_data('Clause',3).      /* natural clause $@%G!<%?(J */
pr2mgtp_initialize_data('clause',1).      /* natural clause $@$NM-L5(J */
pr2mgtp_initialize_data('Negative',1).    /* negative clause $@%G!<%?(J */
pr2mgtp_initialize_data('Assume',1).      /* $@2>@b(J $@%j%9%H(J */
pr2mgtp_initialize_data('Observation',1). /* $@4QB,(J $@%j%9%H(J */


% <<<< format read date >>>>
pr2mgtp_in(File) :-
	see(File),
	repeat,
	read(In),
%	numbervars(In,0,_),
	pr2mgtp_in_loop(In),
	seen,!.


pr2mgtp_in_loop('end_of_file') :- !.
pr2mgtp_in_loop(P) :-
	pr2mgtp_in_case(P),
	fail.


/* $@Ii@a(J */
pr2mgtp_in_case(('<-' Ant)) :- !,
	pr2mgtp_in_clause(fail,Ant),!.

/* $@3NDj@a(J */
pr2mgtp_in_case((Suc '<-' Ant)) :- !,
	pr2mgtp_in_clause(Suc,Ant),!.

/* $@@5@a(J,$@2>@b(J,$@4QB,(J */
pr2mgtp_in_case(Pre) :- !,
	pr2mgtp_in_predicate(Pre),!.


/* Pre $@$,@5@a(J,$@2>@b(J,$@4QB,$N$I$N>pJs$r;}$D$+$r%A%'%C%/$9$k(J */
pr2mgtp_in_predicate(Pre) :-
	(pr2mgtp_in_check_assume(Pre,AbdList)->assertz('Assume'(AbdList));
	    (pr2mgtp_in_check_observe(Pre,Ob)->assertz('Observation'(Ob));
		(pr2mgtp_in_check_predicate(Pre,NP)->assertz('Predicate'(NP));
		    pr2mgtp_in_clause(Pre,true)))).

%
% pr2mgtp_in_check_assume(Pre,AbdList)
%   Pre : $@%k!<%k(J
%   AbdList : $@2>@b$N%j%9%H(J
%
/* $@2>@b$rI=8=$7$F$$$k$+%A%'%C%/(J */
pr2mgtp_in_check_assume(Pre,AbdList) :-
	(Pre =.. [Pred|Rem] -> 
	 Pred = 'assume',
	 (retract('Assume'(X)) -> true;X = []),
	 append(X,Rem,List),
	 pr2mgtp_in_check_element(List,AbdList);
	    fail).

%
% pr2mgtp_in_check_observe(Pre,Ob)
%   Pre : $@%k!<%k(J
%   Ob : $@4QB,$5$l$?$b$N(J
%
/* $@4QB,$rI=8=$7$F$$$k$+%A%'%C%/(J */
pr2mgtp_in_check_observe(Pre,Ob) :-
	(Pre =.. [Pred|Rem] ->
	 Pred = 'observation', Ob = Rem).

%
% pr2mgtp_in_check_element(X,Y)
%   X : $@%j%9%H(J
%   Y : $@F1$8MWAG$r;}$?$J$$%j%9%H(J
%
/* $@F1$8MWAG$r;}$D$+%A%'%C%/(J*/
pr2mgtp_in_check_element([],[]).
pr2mgtp_in_check_element([X|L1],[X|L]) :-
	(member(X,L1) ->
	 delete_list(strong,X,L1,L2), pr2mgtp_in_check_element(L2,L);
	    pr2mgtp_in_check_element(L1,L)).
%
% pr2mgtp_in_check_predicate(Pre,NewPre)
%   Pre : $@@a%G!<%?(J
%   NewPre : Prolog$@$N=R8l%j%9%H(J
% Prolog $@$N=R8l(J $@%j%9%H$N:n@.(J
%
pr2mgtp_in_check_predicate(Pre,NewPre) :-
	Pre =.. [X|_],
	X = ':-',
	numbervars(Pre,0,_),
	(retract('Predicate'(P)) -> append(P,[Pre],NewPre);
	    NewPre = [Pre]).

%
% pr2mgtp_in_clause(Suc,Ant)
%   Suc : $@@a$N8e7o(J
%   Ant : $@@a$NA07o(J
%
/* $@@a%G!<%?$N:n@.(J */
pr2mgtp_in_clause(Suc,Ant) :-
	pr2mgtp_in_SucList(Suc,SucList),
	/* Disjunctive literal $@$N%j%9%H$N:n@.(J */
	(SucList = [_,_|_] ->
	 (retract('dis'(Dis)) ->
	  asserta('dis'([SucList|Dis]));asserta('dis'([SucList])));
	    true),
	pr2mgtp_in_AntList(Ant,AntList),
	/* $@%\%G%#$r(J Objective literal $@$H(J Negative literal $@$KJ,$1$k(J */
	pr2mgtp_in_inclause(AntList,ONlist),
	/* $@@a%G!<%?$NJ]B8(J */
	pr2mgtp_in_clause_assert(SucList,ONlist).


%
% pr2mgtp_in_SucList(Suc,SucList)
%   Suc : $@8e7o(J
%   SucList : $@8e7o$N%j%9%H(J
% SucList $@$O%j%9%H$N%j%9%H(J
% a,b,c;d,e;f  -->  [[a,b,c],[d,e],[f]]
%
/* $@8e7o$N%j%9%H$r:n@.(J */
pr2mgtp_in_SucList(Suc,SucList) :-
	(Suc = fail ->
	 SucList = [];to_OrList(Suc,SucList)),
	pr2mgtp_in_head_list(SucList).

%
% pr2mgtp_in_head_list(X)
%   X : $@8e7o$N%j%9%H!J%W%m%0%i%`A4BN!K(J
% 
/* $@%W%m%0%i%`A4BN$N8e7o$N%j%9%H$N:n@.(J */
pr2mgtp_in_head_list([]).
pr2mgtp_in_head_list([Head|L]) :-
	(retract(head(X)) ->
	 append(Head,X,H),assertz(head(H));
	    assertz(head(Head))),
	pr2mgtp_in_head_list(L).

%
% pr2mgtp_in_AntList(Ant,AntList)
%   Ant : $@A07o(J
%   AntList : $@A07o$N%j%9%H(J
% AntList $@$N9=@.(J
%   <- a,b,not c;d,not e;not f  -->  [[[a,b],[c]],[[d],[e]],[[],[f]]]
%
/* $@A07o$N$j$9$H$r:n@.(J */
pr2mgtp_in_AntList(Ant,AntList) :-
	(Ant = true ->
	 AntList = [];to_OrList(Ant,AntList)).

%
% pr2mgtp_in_clause_assert(Head,Body)
%   Head : $@8e7o$N%G!<%?(J
%   body : $@A07o$N%G!<%?(J
% $@@a%G!<%?$NJ]B8(J
%
/* $@Ii@a(J $@!J(JNAF $@$r4^$^$J$$>l9g!K(J*/
pr2mgtp_in_clause_assert([],ONlist) :-
	/* NAF $@$r4^$`$+%A%'%C%/(J */
	pr2mgtp_in_clause_assert1(ONlist),
	assertz('Negative'(ONlist)).
/* $@8e7o$N%j%F%i%k$,(J Negative literal $@$K4^$^$l$k>l9g(J */
pr2mgtp_in_clause_assert([H],[[Obj,Neg]]) :-
	copy_term([H,Obj,Neg],[H1,Obj1,Neg1]),
	numbervars([H1,Obj1,Neg1],0,_),
	/* $@>r7o$r<h$j=P$9(J */
	pr2mgtp_in_take_condition(Obj1,Con),
	/* $@4^$^$l$k$+%A%'%C%/(J */
	pr2mgtp_in_check_negation(H1,Neg1,Con),
	counter(get,clause,C),
	assertz('Clause'(C,[],[[Obj,Neg]])).
/* $@$=$l0J30(J */
pr2mgtp_in_clause_assert(Suc,ONlist) :-
	counter(get,clause,C),
	('clause'(no) -> retract('clause'(no)),assertz('clause'(yes));true),
	assertz('Clause'(C,Suc,ONlist)).

%
% pr2mgtp_in_clause_assert1(X)
%   X : $@8e7o$N%G!<%?(J
% NAF $@$r4^$^$J$1$l$P(J,$@@.8y(J
%
/* NAF $@$r4^$`$+%A%'%C%/(J */
pr2mgtp_in_clause_assert1([]).
pr2mgtp_in_clause_assert1([[_,[]]|L]) :-
	pr2mgtp_in_clause_assert1(L).

%
% pr2mgtp_in_take_condition(Obj,Con)
%   Obj : Objective literal list
%   Con : condition list
%
/* $@%\%G%#$+$i>r7o$r<h$j=P$9(J */
pr2mgtp_in_take_condition([],[]).
pr2mgtp_in_take_condition([{X}|O],[{X}|C]) :- !,
	pr2mgtp_in_take_condition(O,C).
pr2mgtp_in_take_condition([_|O],C) :- !,
	pr2mgtp_in_take_condition(O,C).

%
% pr2mgtp_in_check_negation(Head,Neg,Con)
%   Head : $@8e7o$N(J list
%   Neg : negative literal list
%   Con : condition list
% $@8e7o$N%j%F%i%k$,(J Negative literal $@$K4^$^$l$k$+%A%'%C%/(J
% $@4^$^$l$F$$$l$P(J,$@@.8y(J
%
pr2mgtp_in_check_negation([],_,_).
pr2mgtp_in_check_negation([Head|H],Neg,Con) :- !,
	/* $@$"$k8e7o$N%j%F%i%k$K$D$$$F%A%'%C%/(J */
	pr2mgtp_in_check_negation1(Head,Neg,Con),!,
	pr2mgtp_in_check_negation(H,Neg,Con).

%
% pr2mgtp_in_check_negation1(Head,Neg,Con)
%   Head : $@8e7o$N(J literal
%   Neg : negative literal list
%   Con : condition list
% $@$"$k8e7o$N%j%F%i%k$K$D$$$F%A%'%C%/(J
% $@4^$^$l$F$$$l$P(J,$@@.8y(J
%
pr2mgtp_in_check_negation1(H,[H|_],_).
pr2mgtp_in_check_negation1(H,[N|_],Con) :-
	H =.. [F1|P1],N =.. [F2|P2],
	F1 == F2,
	(in_var_hold(H);in_var_hold(N)),!,
	/* $@=R8lL>$N%A%'%C%/(J */
	(pr2mgtp_in_check_condition(H,N,Con) -> true;
	    /* $@!J=R8lL>$,F1$8>l9g!K0z?t$N%A%'%C%/(J */
	    pr2mgtp_in_check_negation_para(P1,P2,Con)).
pr2mgtp_in_check_negation1(H,[_|L],Con) :-
	pr2mgtp_in_check_negation1(H,L,Con).

%
% pr2mgtp_in_check_negation_para(P1,P2,Con)
%   P1 : $@0z?t#1(J
%   P2 : $@0z?t#2(J
%   Con : condition list
% $@0z?t$N%A%'%C%/(J
%   $@0z?t$,F1$8$J$i$P(J,$@@.8y(J
%
pr2mgtp_in_check_negation_para([],[],_).
pr2mgtp_in_check_negation_para(X,X,_).
pr2mgtp_in_check_negation_para([P1|_],[P2|_],Con) :-
	/* $@JQ?t$,4^$^$l$k$+%A%'%C%/(J */
	(in_var_hold(P1);in_var_hold(P2)),!,
	/* $@$=$N0z?t$K$D$$$F$5$i$KD4$Y$k(J */
	pr2mgtp_in_check_negation_para_variable(P1,P2,Con).
pr2mgtp_in_check_negation_para([P1|L1],[P2|L2],Con) :- !,
	/* $@JQ?t$,$U$/$^$l$:(J,$@$=$N0z?t$,F1$8$J$i$P(J,$@<!$N0z?t$X(J */
	P1 = P2,
	pr2mgtp_in_check_negation_para(L1,L2,Con).

/* $@0z?t$,F1$8$+$N%A%'%C%/(J */
%pr2mgtp_in_check_negation_para_variable(_,_,[]).
pr2mgtp_in_check_negation_para_variable(X,Y,Con) :-
	/* $@JQ?t$I$&$7$J$i(J,$@>r7o$r%A%'%C%/(J */
	(var_original(X);var_original(Y)),!,
	 pr2mgtp_in_check_condition(X,Y,Con).
/* $@$=$&$G$J$$$J$i$P(J,$@$5$i$K=R8lL>$N%A%'%C%/(J */
pr2mgtp_in_check_negation_para_variable(X,Y,Con) :-
	X =.. [F1|P1],Y =.. [F2|P2],
	F1 == F2,!,
	pr2mgtp_in_check_negation_para(P1,P2,Con).

/* $@>r7o%A%'%C%/(J */
pr2mgtp_in_check_condition(_,_,[]).
pr2mgtp_in_check_condition(X,Y,[Con|_]) :-
	(Con = {X == Y};Con = {Y == X};Con = {X = Y};Con = {Y = X}).
pr2mgtp_in_check_condition(X,Y,[Con|_]) :-
	(Con = {X \== Y};Con = {Y \== X}),!,fail.
pr2mgtp_in_check_condition(X,Y,[_|Con]) :-
	\+(Con = []),
	pr2mgtp_in_check_condition(X,Y,Con).

%
% pr2mgtp_in_inclause(Body,BodyList)
%   Body : $@A07o$N%G!<%?(J
%   BodyList : $@J,$1$i$l$?A07o$N%G!<%?(J
% $@A07o$r(J Negative literal $@$H(J Objective literal $@$KJ,$1$k(J
%
pr2mgtp_in_inclause([],[[[],[]]]).
pr2mgtp_in_inclause([X],[[O1,N1]]) :-
	pr2mgtp_in_inclause1(X,O1,N1).
pr2mgtp_in_inclause([X|Y],[[O1,N1]|L]) :-
	pr2mgtp_in_inclause1(X,O1,N1),
	pr2mgtp_in_inclause(Y,L).

pr2mgtp_in_inclause1([],[],[]).
pr2mgtp_in_inclause1([not P],[],[P]).
pr2mgtp_in_inclause1([P],[P],[]).
pr2mgtp_in_inclause1([not P|L],T,[P|L1]) :- pr2mgtp_in_inclause1(L,T,L1).
pr2mgtp_in_inclause1([P|L],[P|L1],N) :- pr2mgtp_in_inclause1(L,L1,N).


%
% <<<< check Disjunction >>>>
%   Disjunction $@$rMQ$$$FI=8=2DG=$J@a$,$"$l$PJQ49(J
%
pr2mgtp_disjunction(Int,C_num) :-
	'Clause'(Int,[_],[[P,_]]),
	Next is Int +1,
	/* $@$"$k@a$HF1$8(J Objective literal $@$r;}$D@a$NC5:w(J */
	pr2mgtp_check_positive([Int],Next,P,C_num),
	/* $@8e7o$H(J Negative literal $@$r(J append $@$9$k(J */
	pr2mgtp_head_append_negative(C_num,[],HN_list),
	/* Disjunction $@$KJQ492DG=$+%A%'%C%/(J */
	pr2mgtp_test_disjunction(HN_list),
	pr2mgtp_disjunction(Next,_).
/* $@B>$K@a$,B8:_$9$k$+%A%'%C%/(J */
pr2mgtp_disjunction(Int,C_num) :-
	'COUNT'(clause,N),
	Int < N,
	Nint is Int + 1,
	pr2mgtp_disjunction(Nint,C_num).
pr2mgtp_disjunction(_,[]).

%
% pr2mgtp_check_positive(C,Num,P,C_num)
%   C : work variable
%   Num : $@:G=i$KC5:w$9$k@aHV9f(J
%   P : objective literal
%   C_num : P $@$r(J objective literal $@$K;}$D@a$N@aHV9f(J
% P $@$r(J objective literal $@$K$b$D@a$NC5:w(J
%
pr2mgtp_check_positive(C,Num,Pd,C_num) :-
	'Clause'(Num,[_],[[P,_]]),
	Next is Num +1,!,
	/* $@F1$8(J objective literal $@$r;}$D$+%A%'%C%/(J */
	(each_holds_equal_list(Pd,P) ->
	 pr2mgtp_check_positive([Num|C],Next,Pd,C_num);
	    pr2mgtp_check_positive(C,Next,Pd,C_num)).
pr2mgtp_check_positive(C,Num,Pd,C_num) :-
	'COUNT'(clause,N),
	Num < N,
	N1 is Num +1,!,
	pr2mgtp_check_positive(C,N1,Pd,C_num).
pr2mgtp_check_positive(C,_,_,C).

%
% pr2mgtp_head_append_negative(N,X,List)
%   N : $@@aHV9f(J
%   X : work variable
%   List : append $@$7$?%j%9%H$H@aHV9f$r;}$D%j%9%H(J
% $@8e7o$H(Jnegative literal $@$r(J append $@$7$?%j%9%H$N:n@.(J
%
pr2mgtp_head_append_negative([],X,X).
pr2mgtp_head_append_negative([Num|C],D,HN_list) :-
	'Clause'(Num,[H],[[P,N]]),
	append(H,N,HN),
	pr2mgtp_check_variable(HN),!,
	pr2mgtp_head_append_negative(C,[[Num,P,HN]|D],HN_list).
pr2mgtp_head_append_negative([Num|C],D,HN_list) :-
	'Clause'(Num,[H],[[P,N]]),
	append(H,N,HN),
	pr2mgtp_check_literal(HN),!,
	pr2mgtp_head_append_negative(C,[[Num,P,HN]|D],HN_list).
pr2mgtp_head_append_negative([_|C],D,HN_list) :- !,
	pr2mgtp_head_append_negative(C,D,HN_list).

%
% pr2mgtp_test_disjunction(List)
%   List : $@8e7o$H(J Negative literal $@$r(J append $@$7$?$b$N$H@aHV9f$r;}$D%j%9%H(J
% Disjunction $@$GI=8=2DG=$+%A%'%C%/(J
%
pr2mgtp_test_disjunction([]).
pr2mgtp_test_disjunction([[Num,P,HN]|L]) :-
	/* append $@$7$?%j%9%H$,F1$8@a$rC5:w(J */
	pr2mgtp_eq_HN(HN,L,[Num],Nlist),
	pr2mgtp_check_disjunction(HN,Nlist,S,Hlist),
%	(pr2mgtp_check_variable(Hlist) -> true;pr2mgtp_check_literal(Hlist)),
	(S = yes -> pr2mgtp_make_disjunction(Nlist,P,HN,Hlist);true).

%
% pr2mgtp_eq_HN(L,List,N,Nlist)
%   L : $@4p=`$H$J$k%j%9%H(J
%   List : $@@a$N%G!<%?(J
%   N : work variable
%   Nlist : $@F1$8(J append $@$7$?%j%9%H$r;}$D@aHV9f$N%j%9%H(J
% $@$"$k(J append $@$7$?%j%9%H$HF1$8%j%9%H$r;}$D@a$rC5:w(J
%
pr2mgtp_eq_HN(_,[],N,N).
pr2mgtp_eq_HN(HNd,[[Num,_,HN]|L],N,Nlist) :-
	equal_list(HNd,HN),
	pr2mgtp_eq_HN(HNd,L,[Num|N],Nlist).
pr2mgtp_eq_HN(HNd,[_|L],N,Nlist) :-
	pr2mgtp_eq_HN(HNd,L,N,Nlist).

%
% pr2mgtp_check_disjunction(L,Nlist,S,Hlist)
%   L : append $@$7$?%j%9%H(J
%   Nlist : $@@aHV9f$N%j%9%H(J
%   S : $@I=8=2DG=$+$NH=Dj7k2L!J(Jyes,no$@!K(J
%   Hlist : $@8e7o$K$"$k%j%F%i%k$N%j%9%H(J
% Disjunction $@$GI=8=2DG=$+%A%'%C%/(J
pr2mgtp_check_disjunction(_,[_],no,_).
pr2mgtp_check_disjunction(HN,Nlist,S,Hlist) :-
	/* $@@a$N?t$r%A%'%C%/(J */
	length(Nlist,N1),length(HN,N2),
	N1 =< N2,
	pr2mgtp_check_disjunction1(Nlist,HN,[],Hlist),
	pr2mgtp_check_head(Hlist),
	S = yes.
pr2mgtp_check_disjunction(_,_,no,_).

/* $@8e7o$K$"$k%j%F%i%k$N%j%9%H$r:n@.(J */
pr2mgtp_check_disjunction1([],_,H,H) :- !.
pr2mgtp_check_disjunction1([Num|N],HN,H,Hlist) :-
	'Clause'(Num,[[Head]],_),
	pr2mgtp_check_disjunction1(N,HN,[Head|H],Hlist).

/* Disjunct $@$K=EJ#$,$J$$$+%A%'%C%/(J */
pr2mgtp_check_head(Hlist) :-
	'head'(H),
	pr2mgtp_out_check_head2(Hlist,H).

%
% pr2mgtp_check_variable(List)
%   List : append $@$5$l$?%j%9%H(J
% $@%j%9%H$NMWAG$KJQ?t$,4^$^$l$F$$$k$+$N%A%'%C%/(J
pr2mgtp_check_variable([]).
pr2mgtp_check_variable([X|_]) :-
	in_var(X),!,fail.
pr2mgtp_check_variable([_|L]) :- !,
	pr2mgtp_check_variable(L).

%
% pr2mgtp_check_literal(List)
%   List : append $@$5$l$?%j%9%H(J
% List $@$NMWAG$N=R8lL>$,$9$Y$F$3$H$J$j(J,$@JQ?t$bF1$8$b$N$J$i$P(J,$@@.8y(J
%
pr2mgtp_check_literal([X|List]) :-
	copy_term([X|List],L),copy_term(X,X1),
	numbervars(L,0,N),numbervars(X1,0,N1),!,
	N1 >= N,
	pr2mgtp_check_literal1(List).

pr2mgtp_check_literal1([]).
pr2mgtp_check_literal1([X|L]) :-
	/* X $@$r4p=`$H$9$k(J */
	X =.. [F|_],
	copy_term(X,X1),numbervars(X1,0,An),!,
	pr2mgtp_check_predicate1(F,An,L),
	pr2mgtp_check_literal1(L).

pr2mgtp_check_predicate1(_,_,[]).
pr2mgtp_check_predicate1(F,N,[X|L]) :-
	/* $@=R8lL>$HJQ?t$N%A%'%C%/(J */
	X =.. [F1|_],
	\+(F = F1),
	copy_term(X,X1),!,numbervars(X1,0,N),
	pr2mgtp_check_predicate1(F,N,L).

%
% pr2mgtp_make_disjunction
% Disjunction $@$N:n@.(J
%
pr2mgtp_make_disjunction([Num],P,HN,Hlist) :-
	retract('Clause'(Num,_,_)),
	subtraction(HN,Hlist,NewN),
	pr2mgtp_disjunction_head(Hlist,Head),
	counter(get,clause,C),
	assertz('Clause'(C,Head,[[P,NewN]])),
	(retract('dis'(X)) -> asserta('dis'([Head|X]));
	    asserta('dis'([Head]))).
pr2mgtp_make_disjunction([Num|L],P,HN,Hlist) :-
	retract('Clause'(Num,_,_)),
	pr2mgtp_make_disjunction(L,P,HN,Hlist).

pr2mgtp_disjunction_head([],[]).
pr2mgtp_disjunction_head([H|L],[[H]|L1]) :-
	pr2mgtp_disjunction_head(L,L1).

%
% pr2mgtp_clause_list
% $@%W%m%0%i%`A4BN$N@a%j%9%H$r:n@.(J
%
pr2mgtp_clause_list(Int) :-
	pr2mgtp_clause_list1(Int,CL),
	assertz('cl'(CL)).

pr2mgtp_clause_list1(N,[[Head,Body]|CL]) :-
	'Clause'(N,Head,Body),
	((Head = [_,_|_],form(nodis)) -> pr2mgtp_out_check_disjunct(Head,Body);
	    true),
	N1 is N +1,
	pr2mgtp_clause_list1(N1,CL).
pr2mgtp_clause_list1(N,CL) :-
	'COUNT'(clause,Num),
	N < Num,
	N1 is N +1,
	pr2mgtp_clause_list1(N1,CL).
pr2mgtp_clause_list1(_,_).

%
% pr2mgtp_out_check_disjunct(D,Body)
%   D : Disjunct
%   Body : $@@a$NA07o(J
% Disjunct $@$KF1$8JQ?t$,MQ$$$i$l$F$$$k$+%A%'%C%/$9$k(J
%
pr2mgtp_out_check_disjunct(D,Body) :-
	pr2mgtp_out_take_condition1(Body,[],Con),
	pr2mgtp_check_disjunct_variable(D,Con).
pr2mgtp_out_check_disjunct(_,_) :- assertz('form'(dis)).

% take up condition from clause's body
pr2mgtp_out_take_condition1([],X,X) :- !.
pr2mgtp_out_take_condition1([[Obj,_]|L],X,Con) :-
	pr2mgtp_in_take_condition(Obj,C1),
	append(X,C1,Y),
	pr2mgtp_out_take_condition1(L,Y,Con).

% check variable of disjunct
pr2mgtp_check_disjunct_variable(D,Con) :-
	copy_term(D,D1),numbervars(D1,0,X),
	\+(X = 0),
	pr2mgtp_take_variable(D1,V),!,
	pr2mgtp_check_condition(V,Con).
pr2mgtp_check_disjunct_variable(_,_).

% make a variable list from Disjunction
pr2mgtp_take_variable([],_).
pr2mgtp_take_variable([D|L],V) :-
	pr2mgtp_take_variable1(D,[],X),
	(X = [] -> true;pr2mgtp_var_list(X,V)),
	pr2mgtp_take_variable(L,V).

% make a variable from each Disjunct
pr2mgtp_take_variable1([],X,Y) :- remove_same_element(X,Y).
pr2mgtp_take_variable1([L|R],X,Y) :-
	in_var_take(L,V),
	append(X,V,Z),
	pr2mgtp_take_variable1(R,Z,Y).

% variable list
pr2mgtp_var_list(New,[M1|M2]) :-
	(var(M1) -> M1 = New;
	    holds_equal_list(M1,New) ->true;pr2mgtp_var_list(New,M2)).

pr2mgtp_check_condition(V,Con) :-
	\+length(V,1),
	pr2mgtp_list_append(V,[],V1),!,
	pr2mgtp_check_condition1(V1,Con).
pr2mgtp_check_condition(_,_).

% append of list's element
pr2mgtp_list_append([],X,Y) :- remove_same_element(X,Y),!.
pr2mgtp_list_append([X|L],Y,Z) :-
	append(X,Y,A),
	pr2mgtp_list_append(L,A,Z).

% condition check
pr2mgtp_check_condition1(V,Con) :-
	length(V,N),
	pr2mgtp_count_equal(Con,0,Ceq),!,
	pr2mgtp_count_notequal(Con,0,0),
	Ceq >= N-1.

% return number of equal condition
pr2mgtp_count_equal([],N,N) :- !.
pr2mgtp_count_equal([X|L],N,Num) :-
	((X = {_ = _};X = {_ == _}) -> N1 is N +1;N1 = N),
	pr2mgtp_count_equal(L,N1,Num).

% return number of not equal condition
pr2mgtp_count_notequal([],N,N) :- !.
pr2mgtp_count_notequal([X|L],N,Num) :-
	(X = {_ \== _} -> N1 is N +1;N1 = N),
	pr2mgtp_count_notequal(L,N1,Num).

%
% <<<< write to a file >>>>
%
pr2mgtp_out(File) :-
	% there is a Abducible ?
	printf(['check programs form ... ']),
	tell(File),
	/* check program form */
	(retract('Assume'(AbdList)) -> pr2mgtp_out_program_form(AbdList);
	    pr2mgtp_out_program_form([]),AbdList=[]),
	print(user,'ok !!'),nl(user),
	print(user,'generating negative clause by Negation as Failure ... '),
	pr2mgtp_out_generate_nclause(AbdList,S1,S2),
	/* $@3F(Jnegative clause $@$N=PNO(J */
	pr2mgtp_out_each_nclause(S1,S2),
	print(user,'ok !!'),nl(user),
	print(user,'saving program in '),print(user,File),
	print(user,' ... '),
	/* $@@a$N=PNO(J */
	pr2mgtp_out_clause(AbdList),
	/* $@Ii@a$N=PNO(J */
	pr2mgtp_out_negative(AbdList),
	/* $@4QB,$N=PNO(J */
	pr2mgtp_out_observation,
	/* Prolog $@7A<0$N=PNO(J*/
	pr2mgtp_out_predicate,
	told,
	printf(['done !!',{nl}]),
	!.

%
% pr2mgtp_out_program_form(Abd)
%   Abd : abducible list
% check program form
%
pr2mgtp_out_program_form([]) :-
	pr2mgtp_out_check_disjunction(Loop),
	(('form'(dis);Loop = yes) -> printf(['program(edp).',{nl}]);
	    printf(['program(nredp).',{nl}])).
pr2mgtp_out_program_form([]) :-
	printf(['program(elp).',{nl}]).
pr2mgtp_out_program_form(_) :-
	pr2mgtp_out_check_disjunction(Loop),
	(('form'(dis);Loop = yes) -> printf(['program(aedp).',{nl}]);
	    printf(['program(nralp).',{nl}])).
pr2mgtp_out_program_form(_) :-
	printf(['program(aelp).',{nl}]).

%
% pr2mgtp_out_check_disjunction(Loop)
%   Loop :
% head cycle $@$,B8:_$9$k$+%A%'%C%/(J
%
pr2mgtp_out_check_disjunction(Loop) :-
	retract('head'(H)),
	retract('dis'(Dis)),
	/* disjunctive $@$KF1$8%j%F%i%k$,B8:_$9$k$+%A%'%C%/(J */
	(pr2mgtp_out_check_head(Dis,H) -> true;Loop = yes).

%
% pr2mgtp_out_check_head(Dis,Head)
%   Dis : Disjunct $@$N%j%9%H(J
%   Head : Head $@$K$"$k%j%F%i%k$N%j%9%H(J
% Disjunct $@$rF3$/%k!<%k$,J#?tB8:_$9$k$+(J
%   $@B8:_$9$k$J$i$P(J,$@@.8y(J
%
pr2mgtp_out_check_head([],_).
pr2mgtp_out_check_head([Dis|L],H) :- !,
	pr2mgtp_out_check_head1(Dis,H),
	pr2mgtp_out_check_head(L,H).

pr2mgtp_out_check_head1([],_).
pr2mgtp_out_check_head1([Dis|L],H) :- !,
	pr2mgtp_out_check_head2(Dis,H),
	pr2mgtp_out_check_head1(L,H).

pr2mgtp_out_check_head2([],_).
pr2mgtp_out_check_head2([Dis|L],H) :- !,
	pr2mgtp_out_mem2(Dis,H,0),
	pr2mgtp_out_check_head2(L,H).

pr2mgtp_out_mem2(_,[],_).
pr2mgtp_out_mem2(X,[X|_],1) :- !,fail.
pr2mgtp_out_mem2(X,[X|L],0) :- !,
	pr2mgtp_out_mem2(X,L,1).
pr2mgtp_out_mem2(X,[_|L],S) :- !,
	pr2mgtp_out_mem2(X,L,S).


%
% pr2mgtp_out_check_loop(Dis,CL)
%   Dis : Disjunctive list
%   CL : $@%W%m%0%i%`A4BN$N@a%G!<%?(J
% head cycle $@$,B8:_$9$k$+%A%'%C%/(J
%   $@B8:_$7$J$$$J$i$P(J,$@@.8y(J
%
pr2mgtp_out_check_loop([],_).
pr2mgtp_out_check_loop([Dish|L],CL) :-
	pr2mgtp_out_check_loop1(Dish,Dish,CL),!,
	pr2mgtp_out_check_loop(L,CL).

% take up disjunction
pr2mgtp_out_check_loop1([],_,_).
pr2mgtp_out_check_loop1([Dis|L],Dish,CL) :-
	pr2mgtp_out_check_loop2(Dis,Dish,CL),!,
	pr2mgtp_out_check_loop1(L,Dish,CL).

% take up conjunction
pr2mgtp_out_check_loop2([],_,_).
pr2mgtp_out_check_loop2([Con|L],Dish,CL) :-
	pr2mgtp_out_loop(Con,Dish,CL,[Con]),!,
	pr2mgtp_out_check_loop2(L,Dish,CL).

pr2mgtp_out_loop(Con,Dish,CL,His) :-
	pr2mgtp_out_match_body(Con,CL,Head),!,
	pr2mgtp_out_loop1(Dish,CL,Head,His).
pr2mgtp_out_loop(_,_,_,_).

pr2mgtp_out_loop1(Dish,CL,[Head|L],His) :-
	\+(Head = []),!,
	pr2mgtp_out_loop2(Dish,CL,Head,His),
	pr2mgtp_out_loop1(Dish,CL,L,His).
pr2mgtp_out_loop1(_,_,_,_).

pr2mgtp_out_loop2(_,_,[],_).
pr2mgtp_out_loop2(Dish,CL,[H|L],His) :-
	\+(member(H,His)),!,
	pr2mgtp_out_disjunction_literal(H,Dish,His),
	pr2mgtp_out_loop(H,Dish,CL,[H|His]),
	pr2mgtp_out_loop(Dish,CL,L,His).

%
% pr2mgtp_out_match_body(Con,CL,Head)
%   Con : literal
%   CL : $@@a%G!<%?(J
%   Head : $@%^%C%A%s%0$7$?@a$N8e7o(J
% Con $@$H%\%G%#$N%^%C%A%s%0(J
%   $@%^%C%A%s%0$7$?@a$N8e7o$rJV$9(J
%
pr2mgtp_out_match_body(_,[],_).
pr2mgtp_out_match_body(Con,[[Head,[[Obj,_]|_]]|_],Head) :-
	subsume_list(Con,Obj);subsume1_list(Con,Obj).
pr2mgtp_out_match_body(Con,[[Head,[_|L]]|CL],H) :-
	\+(L = []),
	pr2mgtp_out_match_body(Con,[[Head,L]|CL],H).
pr2mgtp_out_match_body(Con,[_|L],H) :-
	pr2mgtp_out_match_body(Con,L,H).

%
% pr2mgtp_out_disjunction_literal(Con,Dis,His)
%   Con : literal
%   Dis : disjunctive list
%   His : history
% Con $@$,(J $@4p=`$N(Jdisjunctive $@0J30$N(J disjunctive $@$+%A%'%C%/(J
%
pr2mgtp_out_disjunction_literal(Con1,Dish,His) :-
	last_list(His,D),
	pr2mgtp_out_other_disjunction(Dish,D,Disl),!,
	pr2mgtp_out_not_member_literal(Con1,Disl).

%
% pr2mgtp_out_other_disjunction(Dis,D,Disj)
%   Dis : disjunctive list
%   D : $@4p=`$N(Jdisjunctive
%   Disj : D $@$r=|$$$?(Jdisjunctive list
% D $@$r=|$$$?(J disjunctive list $@$N:n@.(J
%
pr2mgtp_out_other_disjunction([Dis|L],D,L) :- member(D,Dis).
pr2mgtp_out_other_disjunction([Dis|L],D,[Dis|L1]) :-
	pr2mgtp_out_other_disjunction(L,D,L1).

pr2mgtp_out_not_member_literal(_,[]).
pr2mgtp_out_not_member_literal(Con,[Dis|_]) :-
	subsume_list(Con,Dis),
	!,fail.
pr2mgtp_out_not_member_literal(Con,[_|L]) :-
	pr2mgtp_out_not_member_literal(Con,L).


%
% generate negative clause from program
%
pr2mgtp_out_generate_nclause(Abd,S1,S2) :-
	pr2mgtp_out_generate_nclause1(Abd,1,X),
	pr2mgtp_out_check_nclause1(X,S1),
	pr2mgtp_out_generate_nclause2(Abd,1,S1,Y),
	pr2mgtp_out_check_nclause2(S1,Y,S2).

%
% pr2mgtp_out_generate_nclause1(Abd,Int,S)
%   Abd : $@2>@b$N=89g(J
%   Int : $@@aHV9f(J
%   S : negative clause1 $@8uJd(J
% NAF $@$r(J negative clause1 $@$N8uJd$H$7$F%j%9%H$r:n@.(J
%
pr2mgtp_out_generate_nclause1(Abd,Int,S) :-
	'Clause'(Int,_,Body),
	pr2mgtp_out_nclause1_list(Abd,Body,S),
	Next is Int +1,
	pr2mgtp_out_generate_nclause1(Abd,Next,S).
pr2mgtp_out_generate_nclause1(Abd,Int,S) :-
	'COUNT'(clause,N),
	Int < N,
	Next is Int +1,
	pr2mgtp_out_generate_nclause1(Abd,Next,S).
pr2mgtp_out_generate_nclause1(_,_,_).

/* $@%\%G%#$+$i(J NAF $@$r<h$j=P$9(J */
pr2mgtp_out_nclause1_list(_,[],_).
pr2mgtp_out_nclause1_list(Abd,[[_,Neg]|L],S) :-
	pr2mgtp_out_nclause1_list1(Abd,Neg,S),
	pr2mgtp_out_nclause1_list(Abd,L,S).

/* NAF $@%j%9%H$N:n@.(J */
pr2mgtp_out_nclause1_list1(_,[],_).
pr2mgtp_out_nclause1_list1(Abd,[Neg|L],S) :-
	/* Neg $@$,2>@b$KJq@a$5$l$J$$$J$i$P(J,$@8uJd$H$9$k(J */
	(subsume_list(Neg,Abd) -> pr2mgtp_out_nclause1_list1(Abd,L,S);
	    nclause1_list(Neg,S),
	    pr2mgtp_out_nclause1_list1(Abd,L,S)).

%
% check generated schema1
%
pr2mgtp_out_check_nclause1(S,S1) :-
	pr2mgtp_out_check_naf(S,X),
	pr2mgtp_out_check_same_nclause1(X,S1).

%
% pr2mgtp_out_check_naf(X,Y)
%   X : negative clause $@8uJd(J
%   Y : negative clause
% resolution check of each Negative literal
%
pr2mgtp_out_check_naf([],[]).
pr2mgtp_out_check_naf([S|L],S1) :-
	pr2mgtp_out_check_trans(S,[],[], nbk),
	pr2mgtp_out_check_naf(L,S1).
pr2mgtp_out_check_naf([S|L],[S|L1]) :-
	pr2mgtp_out_check_naf(L,L1).

%
% pr2mgtp_out_check_trans(S, His,N, Mode)
%   S : $@F3=P$r;n$_$k(J literal
%   His : history
%   N : negative literal
%   Mode : backtrack$@$"$j(J,$@$J$7!J(Jbk,nbk$@!K(J
% resolution check
%
/* $@>r7o$N>l9g(J */
pr2mgtp_out_check_trans({X}, _,_, _) :- !,X.
/* $@%k!<%W$K$J$k>l9g(J */
pr2mgtp_out_check_trans(S, His,_, _) :- hold_member(S,His),!.
%pr2mgtp_out_check_trans(S, His,_, _) :- subsume_list(S,His),!.
pr2mgtp_out_check_trans(S, His,N, Mode) :-
	pr2mgtp_out_head_matching(1,S,His,N,Mode).

%
% pr2mgtp_out_head_matching(N,S,B)
%   N : $@@aHV9f(J
%   S : literal
%   B : literal $@$,%^%C%A$9$k@a$N%\%G%#(J
% Head matching
%
pr2mgtp_out_head_matching(N,S,His,Neg,Mode) :-
	'Clause'(N,H,B),
	pr2mgtp_out_head_matching1(H,B,S,Body),
	pr2mgtp_out_check_body(Body,[S|His],Neg, Mode).
pr2mgtp_out_head_matching(N,S,His,Neg,Mode) :-
	'COUNT'(clause,Num),
	Num > N,
	N1 is N +1,!,
	pr2mgtp_out_head_matching(N1,S,His,Neg,Mode).

/* $@3F@a$K$*$$$F%^%C%A%s%0(JA$@$r9T$J$&(J */
pr2mgtp_out_head_matching1([[S|_]|_],Body,S,Body).
%pr2mgtp_out_head_matching1([[H|_]|_],Body,S,Body) :-
%	subsume(S,H).
pr2mgtp_out_head_matching1([[_|L]|L1],B,S,Body) :- !,
	pr2mgtp_out_head_matching1([L|L1],B,S,Body).
pr2mgtp_out_head_matching1([[]|L],B,S,Body) :- !,
	pr2mgtp_out_head_matching1(L,B,S,Body).

%
% pr2mgtp_out_check_body(S,Body, His,N, Mode)
%   S : reasoning literal
%   Body : $@@a$NA07o%G!<%?(J
%   His : history
%   N : negative literal
%   Mode : backtrack mode
% check body
%
/* $@F3=P$5$l$k(J */
pr2mgtp_out_check_body([[[],[]]|_],_,_, _) :- !.
/* $@F3=P$r$3$3$m$_$k(Jliteral$@$,(JNAF$@$KB8:_$9$k(J */
pr2mgtp_out_check_body([[_,Neg]|L],His,N, Mode) :-
	hold_intersection(N,Neg,In),
	\+(In = []),!,
	\+(L = []),
	 pr2mgtp_out_check_body(L,His,N, Mode).
pr2mgtp_out_check_body([[Obj,Neg]|_],His,N, nbk) :-
	pr2mgtp_out_check_obj(Obj,His,N, nbk),
	pr2mgtp_out_check_neg(Neg,N).
pr2mgtp_out_check_body([[Obj,Neg]|_],His,N, bk) :-
	pr2mgtp_out_check_obj(Obj,His,N, bk),
	pr2mgtp_out_check_neg(Neg,N).
pr2mgtp_out_check_body([_|L],His,N, Mode) :- !,
	\+(L = []),
	pr2mgtp_out_check_body(L,His,N, Mode).

% resolusion of objective literal
pr2mgtp_out_check_obj([],_,_, _).
pr2mgtp_out_check_obj([_|L],His,N, Mode) :-
	(last_list(His,X),component_check(X);
	    His = [X|_],component_check(X)),!,
	pr2mgtp_out_check_obj(L,His,N, Mode).
pr2mgtp_out_check_obj([Obj|L],His,N, Mode) :-
	pr2mgtp_out_check_trans(Obj,His,N, Mode),
	hold_intersection(N,L,In),
	In = [],
	pr2mgtp_out_check_obj(L,His,[Obj|N], Mode).

% head matching of negative literal
pr2mgtp_out_check_neg([],_).
pr2mgtp_out_check_neg(Neg,N) :-
	hold_intersection(Neg,N,In),
	\+(In = []),!,fail.
pr2mgtp_out_check_neg([Neg|L],N) :-
	\+pr2mgtp_out_check_fact(1,Neg),
	pr2mgtp_out_check_neg(L,N).

%
% pr2mgtp_out_check_fact(N,X)
%   N : $@@aHV9f(J
%   X : $@%j%F%i%k(J
% X$@$,;v<B$+D4$Y$k(J
% 
pr2mgtp_out_check_fact(N,X) :-
	'Clause'(N,H,B),
	pr2mgtp_out_head_matching1(H,B,X,Body),
	member([[],[]],Body).
pr2mgtp_out_check_fact(N,X) :-
	'COUNT'(clause,Num),
	Num > N,
	N1 is N +1,!,
	pr2mgtp_out_check_fact(N1,X).


% delete same negative clause1
pr2mgtp_out_check_same_nclause1([],[]).
pr2mgtp_out_check_same_nclause1([X|L],L1) :-
	member(X,L),
	pr2mgtp_out_check_same_nclause1(L,L1).
pr2mgtp_out_check_same_nclause1([X|L],[X|L1]) :-
	pr2mgtp_out_check_same_nclause1(L,L1).


%
% generate Negative clause2
%    These are Negative clause2 by Head and Negation as Failure
%
pr2mgtp_out_generate_nclause2(Abd,Int,S1,S) :-
	'Clause'(Int,Head,Body),
	pr2mgtp_out_nclause2_list(Abd,Head,Body,S1,S),
	Next is Int +1,
	pr2mgtp_out_generate_nclause2(Abd,Next,S1,S).
pr2mgtp_out_generate_nclause2(Abd,Int,S1,S) :-
	'COUNT'(clause,N),
	Int < N,
	Next is Int +1,
	pr2mgtp_out_generate_nclause2(Abd,Next,S1,S).
pr2mgtp_out_generate_nclause2(_,_,_,_).

%
% pr2mgtp_out_nclause2_list(Abd,Head,Body,S1,S)
%   Abd : $@2>@b=89g(J
%   Head : $@$"$k@a$N8e7o(J
%   Body : $@$"$k@a$NA07o(J
%   S1 : negative clause1 list
%   S : negative clause2 $@8uJd(J
% $@$"$k@a$K$*$$$F8e7o$H(JNAF$@$N%Z%"%j%9%H$r:n@.(J
%
pr2mgtp_out_nclause2_list(_,[],_,_,_).
pr2mgtp_out_nclause2_list(Abd,[Head|H],Body,S1,S) :-
	pr2mgtp_out_nclause2_list1(Abd,Head,Body,S1,S),
	pr2mgtp_out_nclause2_list(Abd,H,Body,S1,S).

% make negative clause2 by Head and Negation as Failure
pr2mgtp_out_nclause2_list1(_,_,[],_,_).
pr2mgtp_out_nclause2_list1(Abd,Head,[[_,[]]|B],S1,S) :-
	pr2mgtp_out_nclause2_list1(Abd,Head,B,S1,S).
pr2mgtp_out_nclause2_list1(Abd,Head,[[_,Neg]|B],S1,S) :-
	pr2mgtp_out_nclause2_list2(Abd,Head,Neg,S1,S),
	pr2mgtp_out_nclause2_list1(Abd,Head,B,S1,S).

pr2mgtp_out_nclause2_list2(_,[],_,_,_).
pr2mgtp_out_nclause2_list2(Abd,[X|L],Neg,S1,S) :-
	pr2mgtp_out_nclause2_list3(Abd,X,Neg,S1,S),
	pr2mgtp_out_nclause2_list2(Abd,L,Neg,S1,S).

/* $@%Z%"$N%j%9%H$K$O(J,negative clause1 $@%j%9%H$NMWAG$r4^$^$J$$(J */
pr2mgtp_out_nclause2_list3(_,_,[],_,_).
pr2mgtp_out_nclause2_list3(Abd,X,[Y|L],S1,S) :-
	X == Y,
	pr2mgtp_out_nclause2_list3(Abd,X,L,S1,S).
pr2mgtp_out_nclause2_list3(Abd,Head,[Neg|L],S1,S) :-
	\+member(Neg,S1),
	\+subsume_list(Neg,Abd),
	nclause2_list([Neg,Head],S),
	pr2mgtp_out_nclause2_list3(Abd,Head,L,S1,S).
pr2mgtp_out_nclause2_list3(Abd,Head,[_|L],S1,S) :-
	pr2mgtp_out_nclause2_list3(Abd,Head,L,S1,S).

%
% check generated Negative clause2
%
pr2mgtp_out_check_nclause2(S1,S,S2) :-
	pr2mgtp_out_check_td(S,N,S1),
	pr2mgtp_out_check_same_nclause2(N,S2).

%
% pr2mgtp_out_check_td(S,S2,S1)
%   S : negative clause2 $@8uJd(J
%   S2 : negative clause2
%   S1 : negative clause1
% transfer check of each schema2
%
pr2mgtp_out_check_td([],[],_).
pr2mgtp_out_check_td([[_,H]|L],X,S1) :-
	subsume_list(H,S1),
	pr2mgtp_out_check_td(L,X,S1).
pr2mgtp_out_check_td([[N,H]|L],X,S1) :-
	copy_term([N,H],[N1,H1]),
	N1 =.. [Nf|_],H1 =.. [Hf|_],
	((Nf == Hf,(in_var(N1);in_var(H1))) ->
	  pr2mgtp_out_check_trans(H1,[],[], bk),
	  pr2mgtp_out_check_trans(N1,[],[H1], bk),
	  \+(H1 = N1);
	    pr2mgtp_out_check_trans(H1,[],[N1], nbk),
	    pr2mgtp_out_check_trans(N,[],[H1], nbk)),
	pr2mgtp_out_check_td(L,X,S1).
pr2mgtp_out_check_td([[N,H]|L],[[N,H]|X],S1) :-
	pr2mgtp_out_check_td(L,X,S1).

%
% pr2mgtp_out_check_same_nclause2(X,Y)
%   X : negative clause2
%   Y : $@F1$8%Z%"$r4^$^$J$$(J negative clause2
% check same schema2
%
pr2mgtp_out_check_same_nclause2([],[]).
pr2mgtp_out_check_same_nclause2([X|L],[X|N]) :-
	pr2mgtp_out_check_same_nclause22(X,L),!,
	pr2mgtp_out_check_same_nclause2(L,N).
pr2mgtp_out_check_same_nclause2([_|L],N) :- !,
	pr2mgtp_out_check_same_nclause2(L,N).

pr2mgtp_out_check_same_nclause22(_,[]).
pr2mgtp_out_check_same_nclause22(X,[Y|L]) :-
	\+equal_list(X,Y),
	pr2mgtp_out_check_same_nclause22(X,L).


%
% Positive clauses and Negative clauses containing Negation As Failure
%
% <<<< take up clause date>>>>
%
pr2mgtp_out_clause(AbdList) :-
	retract('Clause'(_,Suc,ONlist)),
	pr2mgtp_out_clause1(AbdList,Suc,ONlist),
	pr2mgtp_out_clause(AbdList).
pr2mgtp_out_clause(_).

%
% clause contained abducition is skiped or skiped and original work
%
pr2mgtp_out_clause1(AL,Suc,[[O,N]]) :-
	/* skip$@=hM}$N$_$+$N%A%'%C%/(J */
	check_not_only_skip(AL,O,N,Skip),
	set_product(Skip,S2),
	pr2mgtp_out_clause2(AL,Suc,[[O,N]],S2).
pr2mgtp_out_clause1(AL,Suc,ONlist) :-
	pr2mgtp_out_clause2(AL,Suc,ONlist,[]).

pr2mgtp_out_clause2(AL,Suc,ONlist,[]) :-
	copy_term(AL,AL1),
	/* $@A07o$N%j%F%i%k$r2>@b$H$=$&$G$J$$$b$N$KJ,$1$k(J */
	pr2mgtp_out_divide_abducible(AL1,ONlist,Plist),
	/* $@@a$N=PNO(J */
	pr2mgtp_out_mgtp_rule(AL1,Suc,Plist).
pr2mgtp_out_clause2(AL,Suc,ONlist,[Skip|Rem]) :-
	copy_term(AL,AL1),
	copy_term(AL,AL2),
	/* $@4pDlMQ$N@a$KJQ49(J */
	pr2mgtp_out_change_literal(Skip,Suc,ONlist,S1,Clist),
	/* $@A07o$N%j%F%i%k$r2>@b$H$=$&$G$J$$$b$N$KJ,$1$k(J */
	pr2mgtp_out_divide_abducible(AL1,Clist,Plist),
	/* $@@a$N=PNO(J */
	pr2mgtp_out_mgtp_rule(AL2,S1,Plist),
	pr2mgtp_out_clause2(AL,Suc,ONlist,Rem).


%
% pr2mgtp_out_change_literal(L,S,B,S1,B1)
%   L : $@4pDl$N=89g(J
%   S : $@85$N8e7o(J
%   B : $@85$NA07o(J
%   S1 : $@JQ498e$N8e7o(J
%   B1 : $@JQ498e$NA07o(J
% original work
%
pr2mgtp_out_change_literal(L,S,[[O,N]],S1,[[O1,N1]]) :-
	append(S,O,X),append(X,N,Y),
	copy_term(Y,Y1),
	pr2mgtp_out_hold_literal(L,Y1),
	divide(Y1,S,S1,Y2),
	divide(Y2,O,O1,Y3),
	divide(Y3,N,N1,_).

pr2mgtp_out_hold_literal([],_).
pr2mgtp_out_hold_literal([L|R],Y1) :-
	member2(L,Y1),
	pr2mgtp_out_hold_literal(R,Y1).

%
% pr2mgtp_out_divide_abducible(AL,O,N,Obj,Abd,Nge,NgeAbd)
% divide abducible for each Objective Literal and Negative Literal
%
pr2mgtp_out_divide_abducible(_,[],[]).
pr2mgtp_out_divide_abducible(AL,[[O,N]|L],[[Obj,Abd,Neg,NA]|L1]) :-
	pr2mgtp_out_divide_abducible1(AL,O,N,Obj,Abd,Neg,NA),
	pr2mgtp_out_divide_abducible(AL,L,L1).

pr2mgtp_out_divide_abducible1(AL,O,N,Obj,Abd,Neg,NegAbd) :-
% intersection of AbdList and O is Objective Abducible
	intersection(O,AL,Abd),
% subtraction Abducible from O is Objective Literal
	subtraction(O,Abd,Obj),
% intersection of AbdList and N is Negative Abducible
	intersection(N,AL,NegAbd),
% subtraction Negative Abducible from N is Negative Literal
	subtraction(N,NegAbd,Neg).


% <<<< make a MGTP rule >>>>
pr2mgtp_out_mgtp_rule(AL,Suc,Plist) :-
	hold_numbervars(Suc,Plist,S,Holdlist),
	pr2mgtp_out_mgtp_antecedent(Holdlist),
	printf(' --> '),
	pr2mgtp_out_mgtp_consequent(AL,S,Holdlist),
	printf(['.',{nl}]).

%
% hold numbervars to all parameter
%
hold_numbervars(_,[],_,[]).
hold_numbervars(Suc,[[Obj,Abd,Neg,NegAbd]|L],S,[[O,A,N,NA]|R]) :-
	append(Suc,Obj,X1),append(X1,Abd,X2),
	append(X2,Neg,X3),append(X3,NegAbd,X),
	numbervars(X,0,_),
	divide(X,Suc,S,Y1),divide(Y1,Obj,O,Y2),divide(Y2,Abd,A,Y3),
	divide(Y3,Neg,N,Y4),divide(Y4,NegAbd,NA,_),
	hold_numbervars(Suc,L,S,R).


%
% pr2mgtp_out_mgtp_antecedent(X)
%   X : $@A07o$N%j%9%H(J
% print antecedent of clause on output file
%
pr2mgtp_out_mgtp_antecedent([]) :- printf('true').
pr2mgtp_out_mgtp_antecedent([[[],_,_,_]|R]) :-
	pr2mgtp_out_mgtp_antecedent(R).

% a part of Disjunction
pr2mgtp_out_mgtp_antecedent([[Con,_,_,_]]) :-
	pr2mgtp_out_antecedent(Con).
pr2mgtp_out_mgtp_antecedent([[Con,_,_,_]|L]) :-
	pr2mgtp_out_antecedent(Con),
	printf(' ; '),
	pr2mgtp_out_mgtp_antecedent(L).

% a part of Conjunction
pr2mgtp_out_antecedent([{Obj}]) :- printf(['{',Obj,'}']).
pr2mgtp_out_antecedent([Obj]) :- printf(Obj).

pr2mgtp_out_antecedent([{Obj}|Rem]) :-
	printf(['{',Obj,'}, ']),
	pr2mgtp_out_antecedent(Rem).
pr2mgtp_out_antecedent([Obj|Rem]) :-
	printf([Obj,', ']),
	pr2mgtp_out_antecedent(Rem).

%
% pr2mgtp_out_mgtp_consequent(Abd,S,Body)
%   Abd : $@2>@b$N=89g(J
%   S,Body : $@8e7o$N%G!<%?%j%9%H(J
% print consequent of clause on output file
%
pr2mgtp_out_mgtp_consequent(_,[],[]).
pr2mgtp_out_mgtp_consequent(_,[],[_,[],[],[]]) :-
	printf([' --> false.',{nl}]).
pr2mgtp_out_mgtp_consequent(AL,[],[[_,[],[],[]]|R]) :-
	pr2mgtp_out_mgtp_consequent(AL,[],R).
pr2mgtp_out_mgtp_consequent(_,_,[]).
pr2mgtp_out_mgtp_consequent(AL,Suc,[[_,[],[],[]]]) :-
	pr2mgtp_out_consequent_disjunction(AL,Suc,[],[],[]).
pr2mgtp_out_mgtp_consequent(AL,Suc,[[_,[],[],[]]|R]) :-
	pr2mgtp_out_mgtp_consequent(AL,Suc,R).
pr2mgtp_out_mgtp_consequent(AL,Suc,[[_,Abd,Neg,NegAbd]|R]) :- 
	pr2mgtp_out_consequent_disjunction(AL,Suc,Abd,Neg,NegAbd),
	pr2mgtp_out_not_abducible(Abd),
	pr2mgtp_out_connect_or(Abd,[Neg,NegAbd]),
	pr2mgtp_out_k_literal(Neg),
	pr2mgtp_out_connect_or(Neg,[NegAbd]),
	pr2mgtp_out_abducible(NegAbd),
	pr2mgtp_out_mgtp_consequent(AL,Suc,R).

%
% pr2mgtp_out_consequent_disjunction(Abd,B1,B2,B3,B4)
%   Abd : $@2>@b$N=89g(J
%   B1,B2,B3,B4 : $@8e7o$N%G!<%?%j%9%H(J
% print conjuction of consequent
pr2mgtp_out_consequent_disjunction(_,[],_,_,_).
pr2mgtp_out_consequent_disjunction(AL,[Suc|Rem],Abd,Neg,NegAbd) :-
	pr2mgtp_out_objective_literal(AL,Suc),
	  pr2mgtp_out_connect_and(Suc,[Abd,Neg,NegAbd]),
	pr2mgtp_out_abducible_disjunction(Abd),
	  pr2mgtp_out_connect_and(Abd,[Neg,NegAbd]),
	pr2mgtp_out_not_k_literal_disjunction(Neg),
	  pr2mgtp_out_connect_and(Neg,[NegAbd]),
	pr2mgtp_out_not_abducible_disjunction(NegAbd),
	  pr2mgtp_out_connect_or([Rem,Abd,Neg,NegAbd]),
	pr2mgtp_out_consequent_disjunction(AL,Rem,Abd,Neg,NegAbd).


% print K-Literal as Classical Negation at disjunction
pr2mgtp_out_not_k_literal_disjunction([]).
pr2mgtp_out_not_k_literal_disjunction([X]) :-
	printf(['-k(',X,')']).
pr2mgtp_out_not_k_literal_disjunction([X|L]) :-
	printf(['-k(',X,'), ']),
	pr2mgtp_out_not_k_literal_disjunction(L).


% print Abducible Literal at disjunction
pr2mgtp_out_abducible_disjunction([]).
pr2mgtp_out_abducible_disjunction([X]) :-
	printf(['h(',X,')']).
pr2mgtp_out_abducible_disjunction([X|L]) :-
	printf(['h(',X,'), ']),
	pr2mgtp_out_abducible_disjunction(L).


% print Abducible Literal as Classical Negation at disjunction
pr2mgtp_out_not_abducible_disjunction([]).
pr2mgtp_out_not_abducible_disjunction([X]) :-
	printf(['-h(',X,')']).
pr2mgtp_out_not_abducible_disjunction([X|L]) :-
	printf(['-h(',X,'), ']),
	pr2mgtp_out_not_abducible_disjunction(L).


% print Objective Literal
pr2mgtp_out_objective_literal(_,[]).
pr2mgtp_out_objective_literal(AL,[X]) :-
	copy_term(AL,AL1),
	(member(X,AL1) -> printf(['h(',X,')']);
	    printf(X)).
pr2mgtp_out_objective_literal(AL,[X|L]) :-
	copy_term(AL,AL1),
	(member(X,AL1) -> printf(['h(',X,'), ']);
	    printf([X,', '])),
	pr2mgtp_out_objective_literal(AL,L).


% print K-Literal
pr2mgtp_out_k_literal([]).
pr2mgtp_out_k_literal([X]) :-
	printf(['k(',X,')']).
pr2mgtp_out_k_literal([X|L]) :-
	printf(['k(',X,') ; ']),
	pr2mgtp_out_k_literal(L).


% print K-Literal as Classical Negation
pr2mgtp_out_not_k_literal([]).
pr2mgtp_out_not_k_literal([X]) :-
	printf(['-k(',X,')']).
pr2mgtp_out_not_k_literal([X|L]) :-
	printf(['-k(',X,') ; ']),
	pr2mgtp_out_not_k_literal(L).


% print Abducible Literal
pr2mgtp_out_abducible([]).
pr2mgtp_out_abducible([X]) :-
	printf(['h(',X,')']).
pr2mgtp_out_abducible([X|L]) :-
	printf(['h(',X,') ; ']),
	pr2mgtp_out_abducible(L).


% print Abducible Literal as Classical Negation
pr2mgtp_out_not_abducible([]).
pr2mgtp_out_not_abducible([X]) :-
	printf(['-h(',X,')']).
pr2mgtp_out_not_abducible([X|L]) :-
	printf(['-h(',X,') ; ']),
	pr2mgtp_out_not_abducible(L).


%
% pr2mgtp_out_negative(AL)
%   AL : $@2>@b$N=89g(J
% Negative clause without containing Negation As Failure
%
pr2mgtp_out_negative(AL) :-
	retract('Negative'([[Obj,_]])),
	numbervars(Obj,0,_),
	pr2mgtp_out_negative_clause_objective(AL,Obj),
	printf(' --> false'),
	printf(['.',{nl}]),
	pr2mgtp_out_negative(AL).
pr2mgtp_out_negative(_).

% print Objective Literal of Negative clause
pr2mgtp_out_negative_clause_objective(_,[]).
pr2mgtp_out_negative_clause_objective(_,[{X}]) :- printf(['{',X,'}']).
pr2mgtp_out_negative_clause_objective(AL,[X]) :-
	copy_term(AL,AL1),
	(member(X,AL1) -> printf(['h(',X,')']);
	    printf(X)).
pr2mgtp_out_negative_clause_objective(AL,[X|L]) :-
	copy_term(AL,AL1),
	(member(X,AL1) -> printf(['h(',X,'), ']);
	    printf([X,', '])),
	pr2mgtp_out_negative_clause_objective(AL,L).
pr2mgtp_out_negative_clause_objective(AL,[{X}|L]) :-
	printf(['{',X,'}, ']),
	pr2mgtp_out_negative_clause_objective(AL,L).

%
% pr2mgtp_out_each_nclause(S1,S2)
%   S1 : Negative clause1 list
%   S2 : Negative clause2 list
% print each Negative clause
%
pr2mgtp_out_each_nclause(S1,S2) :-
	pr2mgtp_out_nclause1(S1),
	pr2mgtp_out_nclause2(S2),
	pr2mgtp_out_schema.

% print Negative clause1
pr2mgtp_out_nclause1([]).
pr2mgtp_out_nclause1([S|L]) :-
	pr2mgtp_out_take_head(1,S,S1),
	numbervars(S,0,N),
	(\+(N = 0) -> pr2mgtp_out_check_subsume(S1,S2);true),
	printf(['k(',S,')']),
	pr2mgtp_out_condition(S,S2,N),
	printf([' --> false.',{nl}]),
	pr2mgtp_out_nclause1(L).

pr2mgtp_out_take_head(N,X,Y) :-
	'Clause'(N,Head,_),
	pr2mgtp_out_take_head1(Head,X,Y),
	N1 is N+1,
	pr2mgtp_out_take_head(N1,X,Y).
pr2mgtp_out_take_head(N,X,Y) :-
	'COUNT'(clause,Num),
	N < Num,
	N1 is N +1,
	pr2mgtp_out_take_head(N1,X,Y).
pr2mgtp_out_take_head(_,_,_).

pr2mgtp_out_take_head1([],_,_).
pr2mgtp_out_take_head1([[H|L]|L1],S,R) :-
	copy_term(S,S1),
	H = S1,
	pr2mgtp_out_head(S1,R),
	pr2mgtp_out_take_head1([L|L1],S,R).
pr2mgtp_out_take_head1([[_|L]|L1],S,R) :- !,
	pr2mgtp_out_take_head1([L|L1],S,R).
pr2mgtp_out_take_head1([[]|L],S,R) :- !,
	pr2mgtp_out_take_head1(L,S,R).

pr2mgtp_out_head(S1,[X|Y]) :-
	(var(X) -> X = S1;
	    (subsume(S1,X) -> true;pr2mgtp_out_head(S1,Y))).

% subsume check of list
pr2mgtp_out_check_subsume([],[]).
pr2mgtp_out_check_subsume([X|L],[X|L1]) :-
	pr2mgtp_out_check_subsume1(X,L),
	pr2mgtp_out_check_subsume(L,L1).
pr2mgtp_out_check_subsume([_|L],L1) :-
	pr2mgtp_out_check_subsume(L,L1).

pr2mgtp_out_check_subsume1(_,[]).
pr2mgtp_out_check_subsume1(X,[Y|L]) :- !,
	\+subsume(X,Y),
	pr2mgtp_out_check_subsume1(X,L).

pr2mgtp_out_condition(_,_,0).
pr2mgtp_out_condition(_,[],_).
pr2mgtp_out_condition(S,[S1|L],N) :-
	numbervars(S1,0,N1),
	\+var(S1),
	(N =< N1 -> true;
	    printf([', {',S,' \== ',S1,'}'])),
	pr2mgtp_out_condition(S,L,N).
pr2mgtp_out_condition(S,[_|L],N) :-
	pr2mgtp_out_condition(S,L,N).

% print Negative clause2
pr2mgtp_out_nclause2([]).
pr2mgtp_out_nclause2([[X,Y]|L]) :-
	copy_term([X,Y],[A,B]),
	numbervars([A,B],0,_),
	printf(['k(',A,'), k(',B,')']),
	pr2mgtp_out_print_nclause2([X,Y]),
	numbervars(A,0,Nx),
	pr2mgtp_out_check_condition(X,Nx),
	numbervars(B,0,Ny),
	pr2mgtp_out_check_condition(X,Ny),
	printf([' --> false.',{nl}]),
	pr2mgtp_out_nclause2(L).

pr2mgtp_out_print_nclause2([X,Y]) :-
	X =.. [X1|P1],
	Y =.. [Y1|P2],
	X1 == Y1,
	length(P1,N),length(P2,N),
	((in_var_hold(X);in_var_hold(Y)) ->
	  printf([', {',X,' \== ',Y,'}']);true).
pr2mgtp_out_print_nclause2([_,_]).

pr2mgtp_out_check_condition(_,0).
pr2mgtp_out_check_condition(X,_) :-
	copy_term(X,Y),
	pr2mgtp_out_take_head(1,X,X1),
	numbervars(X,0,Nx),
	(\+(Nx = 0) ->
	 pr2mgtp_out_check_subsume(X1,X2),
	 pr2mgtp_out_condition(Y,X2,Nx);
	    true).

% print scheme
pr2mgtp_out_schema :-
	printf(['-(A), (A) --> false.',{nl}]),
	printf(['-k(A), (A) --> false.',{nl}]),
	printf(['-h(A), (A) --> false.',{nl(2)}]).


% print Observation
pr2mgtp_out_observation :-
	(retract('Observation'([Observation])) ->
	 numbervars(Observation,0,_),
	 printf(['true --> k(',Observation,').',{nl}]),
	 pr2mgtp_out_observation;
	    true).

% print Prolog predicate	
pr2mgtp_out_predicate :-
	retract('Predicate'(Predicate)),!,
	printf({nl}),
	pr2mgtp_out_predicate_loop(Predicate).
pr2mgtp_out_predicate :- !.

pr2mgtp_out_predicate_loop([]) :- !.
pr2mgtp_out_predicate_loop([One|Rem]) :-
	pr2mgtp_out_predicate_one(One),!,
	pr2mgtp_out_predicate_loop(Rem).

pr2mgtp_out_predicate_one((Head :- Body)) :- !,
	printf([{quote(Head)},' :- ']),
	pr2mgtp_out_predicate_body(Body,''),
	printf(['.',{nl}]).
pr2mgtp_out_predicate_one(Head) :-
	printf([{quote(Head)},'.',{nl}]).

pr2mgtp_out_predicate_body('!',C) :- !,
	printf([C,'!']).
pr2mgtp_out_predicate_body((One,Rem),C) :- !,
	pr2mgtp_out_predicate_body(One,C),
	pr2mgtp_out_predicate_body(Rem,',').
pr2mgtp_out_predicate_body((O1;O2),C) :- !,
	printf([C,{nl},{tab},'(',{quote(O1)},';',{quote(O2)},')']).
pr2mgtp_out_predicate_body(One,C) :- !,
	printf([C,{nl},{tab},{quote(One)}]).

% <<<< connect symbol or ,and >>>>
pr2mgtp_out_connect_and([],_).
pr2mgtp_out_connect_and(_,[]).
pr2mgtp_out_connect_and(X,[L|R]) :-
	L = [_|_] -> printf(', ');pr2mgtp_out_connect_and(X,R).

pr2mgtp_out_connect_or([]).
pr2mgtp_out_connect_or([X|L]) :-
	X = [_|_] -> printf(' ; ');pr2mgtp_out_connect_or(L).

pr2mgtp_out_connect_or([],_).
pr2mgtp_out_connect_or(_,[]).
pr2mgtp_out_connect_or(X,[L|R]) :-
	L = [_|_] -> printf(' ; ');pr2mgtp_out_connect_or(X,R).
