% Copyright (C) 1996  Katsumi Inoue 
%
%%% model3.pl %%%
%
% (C)1992 Institute for New Generation Computer Technology
% (Read COPYRIGHT for detailed information.)

do(Md) :- do(Md,default).
do1(Md) :- do(Md,one).
doall(Md) :- do(Md,all).

do(Md,default) :- model(M), flis(FLIS), lis(LIS), disjU(DisjU), disjO(DisjO),
	append(M,DisjU, MD),
%	M1 = [MD,[],[],[],[]],
	do(MD, DisjU, FLIS,LIS, DisjO, Md,default) -> Md='unsat';Md='sat'.
do(Md,one) :- model(M), flis(FLIS), lis(LIS), disjU(DisjU), disjO(DisjO),
	append(M,DisjU, MD),
%	M1 = [MD,[],[],[],[]],
	do(MD, DisjU, FLIS,LIS, DisjO, Md1,one),
	do_result(Md1),
	result(Md1,Md).
do(Md,all) :- model(M), flis(FLIS), lis(LIS), disjU(DisjU), disjO(DisjO),
	append(M,DisjU, MD),
%	M1 = [MD,[],[],[],[]],
	do(MD, DisjU, FLIS,LIS, DisjO, Md,all),
	do_result(Md).

result(X,Y) :- X = [_,Y].
%result([],'No model').
result([],'No more models').

% delete variable of list (fainally mgtp result)
do_result([]).
do_result([_|L]) :- do_result(L).

% List of models
add_model_list(_,_,default) :- !,false.
add_model_list(New,[one,New],one).
add_model_list(New,Md,all) :-
	(New=[] -> true;model_list(New,Md)).

model_list(New,[M1|M2]) :-
	(var(M1) -> M1 = New;
	    equal_list(M1,New) ->true;model_list(New,M2)).


do(M,[], _,_, [], Md,one) :-
	add_model_list(M,Md,one).
do(_, [], _,_, [], _,one).
do(M,[], _,_, [], Md,N) :- !,
	add_model_list(M,Md,N).
do(M,[], FLIS,LIS, [Dis|Disj], Md,N) :- !,
	(checkConsq(Dis,NDis, M) -> expand(NDis, M, FLIS,LIS, Disj, Md,N);
	    do(M,[], FLIS,LIS, Disj, Md,N)).
do(M,DM, FLIS,LIS, Disj, Md,N) :- !,
%	DM = [_|_],
	satisfyClauses(M,DM, FLIS,NFLIS, [],DisjU, _,_),
	doDecide(DisjU, M,DM, LIS,NFLIS, Disj, Md,N).

doDecide([], M,DM, LIS,FLIS, Disj, Md,N) :- !,
	satisfyClauses(M,DM, LIS,NLIS, [],DisjU, Disj,NDisj),
	do1(DisjU, M, FLIS,NLIS, NDisj, Md,N).
doDecide(_, _,_, _,_, _, _,_).

do1(DisjU, M, FLIS,LIS, Disj, Md,N) :- do1(DisjU, M,[], FLIS,LIS, Disj, Md,N).

do1([], M,DM, FLIS,LIS, Disj, Md,N) :- do(M,DM, FLIS,LIS, Disj, Md,N).
do1([P|DisjU], M,DM, FLIS,LIS, Disj, Md,N) :- 
	member(P,M),
	do1(DisjU, M,DM, FLIS,LIS, Disj, Md,N).
do1([P|DisjU], M,DM, FLIS,LIS, Disj, Md,N) :-
	do1(DisjU, [P|M],[P|DM], FLIS,LIS, Disj, Md,N).

expand(_, _, _,_, _, Md,one) :- \+var(Md),Md = [one|_],!.
expand([], _, _,_, _, _,_).
expand([P|Ps], M, FLIS,LIS, Disj, Md,N) :- 
	append(P,M, PM),
	do(PM,P, FLIS,LIS, Disj, Md,N),
	expand(Ps, M, FLIS,LIS, Disj, Md,N).


satisfyClauses(M,DM, [lis(I,LiS)|LIS],[lis(I,NLiS)|NLIS1], Si,So, Di,Do) :- !,
    satisfyClause(I,LiS,NLiS, M,DM, Si,Sm, Di,Dm),
    satisfyClauses(M,DM, LIS,NLIS1, Sm,So, Dm,Do).
satisfyClauses(_,_, [],[], Si,Si, Di,Di).

%satisfyClause(ID,LiS,NLiS, M,DM, Si,So, Di,Do) :- DM = [PAT], pc(ID,PAT), !,
%   satisfyAnte(ID,LiS,NLiS, M,DM, [[]],[], Si,So, Di,Do).
%satisfyClause(ID,LiS,LiS, M,DM, Si,Si, Di,Di).

satisfyClause(ID,LiS,NLiS, M,[PAT|DM], Si,So, Di,Do) :- !,
	satisfyClause1(ID,LiS,LiS1, M,PAT, Si,Sm, Di,Dm),
	satisfyClause(ID,LiS1,NLiS, M,DM, Sm,So, Dm,Do).
satisfyClause(ID,LiS,LiS, M,[], Si,Si, Di,Di).

satisfyClause1(ID,LiS,NLiS, M,PAT, Si,So, Di,Do) :- pc(ID,PAT), !,
	satisfyAnte(ID,LiS,NLiS, M,[PAT], [[]],[], Si,So, Di,Do).
satisfyClause1(ID,LiS,LiS, M,PAT, Si,Si, Di,Di).

satisfyAnte(ID,[],[], M,DM, Stack,DStack, Si,So, Di,Do) :- !,
    satisfyLiteral(ID, M,DM, Stack,DStack, Si,So, Di,Do).
satisfyAnte(ID,[S|LiS],[NS|NLiS1], M,DM, Stack,DStack, Si,So, Di,Do) :- 
    satisfyLiteral(ID, M,DM, Stack,DStack, S,NS, [],DS),
    satisfyAnte(ID,LiS,NLiS1, M,DM, S,DS, Si,So, Di,Do).

%
%   satisfyLiteral(+ClauseID, +WholeModel,+DifferentialOfModel,
%           +PreviousStack,+DifferentialOfPreviousStack,
%           +CurrentStack,-CurrentStack,
%           +DifferentialOfCurrentStack,-DifferentialOfCurrentStack)
%
satisfyLiteral(ID, M,DM, Stack,[S|DStack], Si,So, Di,Do) :- !,
    satisfyLiteral(ID, M,S, Si,Sm, Di,Dm),
    satisfyLiteral(ID, M,DM, Stack,DStack, Sm,So, Dm,Do).
satisfyLiteral(ID, M,DM, [S|Stack],DStack, Si,So, Di,Do) :- !,
    satisfyLiteral(ID, DM,S, Si,Sm, Di,Dm),
    satisfyLiteral(ID, M,DM, Stack,DStack, Sm,So, Dm,Do).
satisfyLiteral(_, _,_, [],[], Si,Si, Di,Di).

satisfyLiteral(ID, [P|Ps],S, Si,So, Di,Do) :- !,
    c(ID, [P|S], Si,Sm, Di,Dm),
    satisfyLiteral(ID, Ps,S, Sm,So, Dm,Do).
satisfyLiteral(_, [],_, Si,Si, Di,Di).

%
%   Library
%
checkConsq([],[], _).
checkConsq([X|Xs],Ys, M) :- checkConsq1(X,M, 0,Y,Y, Xs,Ys).

checkConsq1([],M, 1,H,[], Xs,[H|Ys]) :- checkConsq(Xs,Ys, M).
checkConsq1([A|X],M, S,H,T, Xs,Ys) :- 
	(member(A,M) -> checkConsq1(X,M, S,H,T, Xs,Ys);
	    T = [A|T1],	checkConsq1(X,M, 1,H,T1, Xs,Ys)).
