% Copyright (C) 1996  Katsumi Inoue 
%
%%% model2.pl %%%
%
% (C)1992 Institute for New Generation Computer Technology
% (Read COPYRIGHT for detailed information.)

do(Md) :- do(Md,default).
do1(Md) :- do(Md,one).
doall(Md) :- do(Md,all).
do(Md,default) :- model(M), flis(FLIS), lis(LIS), disjU(DisjU), disjO(DisjO),
	do(M, FLIS,LIS, DisjU,DisjO, _,Md,default) -> Md='unsat';Md='sat'.
do(Md,one) :- model(M), flis(FLIS), lis(LIS), disjU(DisjU), disjO(DisjO),
	do(M, FLIS,LIS, DisjU,DisjO, _,MD,one),
	do_result(MD),
	result(MD,Md).
do(Md,all) :- model(M), flis(FLIS), lis(LIS), disjU(DisjU), disjO(DisjO),
	do(M, FLIS,LIS, DisjU,DisjO, _,Md,all),
	do_result(Md).

result(MD,Md) :- MD = [_,Md].
%result([],'No model').
result([],'No more models').

% delete variable of list (fainally mgtp result)
do_result([]).
do_result([_|L]) :- do_result(L).

% List of models
add_model_list(_,_,default) :- !,false.
add_model_list(New,[one,New],one).	
add_model_list(New,Md,all) :-
	(var(New) -> true;model_list(New,Md)).

model_list(New,[M1|M2]) :-
	(var(M1) -> M1 = New;
	    equal_list(M1,New) ->true;model_list(New,M2)).


%
%   do(+CurrentModel,
%        +LiteralInstanceStacksForFalseClauses,+LiteralInstanceStacksForOthers,
%        +DisjunctivesUnique,+DisjunctivesOther)
%
do(_,_,_,[],[], NewMd,Md,one) :-
	add_model_list(NewMd,Md,one).
do(_,_,_,[],[], _,_,one).
do(_,_,_,[],[], NewMd,Md,N) :- !,
	add_model_list(NewMd,Md,N).
do(M, FLIS,LIS, DisjU,DisjO, _,Md,N) :-
	do(M, FLIS,LIS, DisjU,DisjO, Md,N).

do(M, FLIS,LIS, [P|DisjU],DisjO, Md,N) :- !,
    (member(P,M) -> do(M, FLIS,LIS, DisjU,DisjO, M,Md,N);
	do1(M,P, FLIS,LIS, DisjU,DisjO, Md,N)).
do(M, FLIS,LIS, [],[Dis|DisjO],  Md,N) :-  !,
    (checkConsq(Dis,NDis, M) -> expand(NDis, M, FLIS,LIS, DisjO, Md,N);
	do(M, FLIS,LIS, [],DisjO, M,Md,N)).

do1(M,P, FLIS,LIS, DisjU,DisjO, Md,N) :-
	do0([P|M],[P], FLIS,LIS, DisjU,DisjO, Md,N).

do0(M,DM, FLIS,LIS, DisjU,DisjO, Md,N) :-
    satisfyClauses(M,DM, FLIS,NFLIS, [],False, _,_),
    do0Decide(False, M,DM, NFLIS,LIS, DisjU,DisjO, Md,N).

do0Decide([], M,DM, FLIS,LIS, DisjU,DisjO, Md,N) :- !,
    satisfyClauses(M,DM, LIS,NLIS, DisjU,NDisjU, DisjO,NDisjO),
    do(M, FLIS,NLIS, NDisjU,NDisjO, M,Md,N).
do0Decide(False, _,_, _,_, _,_, _,_). % False \= []

do2(M,P, FLIS,LIS, DisjU,DisjO, Md,N) :- 
	append(P,M, PM),
	do0(PM,P, FLIS,LIS, DisjU,DisjO, Md,N).

expand(_, _, _,_, _, Md,one) :- \+var(Md),Md = [one|_],!.
expand([], _, _,_, _, _,_) :- !.
expand([P|Ps], M, FLIS,LIS, DisjO, Md,N) :-
    do2(M,P, FLIS,LIS, [],DisjO, Md,N),
    expand(Ps, M, FLIS,LIS, DisjO ,Md,N).


satisfyClauses(M,DM, [lis(I,LiS)|LIS],[lis(I,NLiS)|NLIS1], Si,So, Di,Do) :- !,
    satisfyClause(I,LiS,NLiS, M,DM, Si,Sm, Di,Dm),
    satisfyClauses(M,DM, LIS,NLIS1, Sm,So, Dm,Do).
satisfyClauses(_,_, [],[], Si,Si, Di,Di).

%satisfyClause(ID,LiS,NLiS, M,DM, Si,So, Di,Do) :- DM = [PAT], pc(ID,PAT), !,
%   satisfyAnte(ID,LiS,NLiS, M,DM, [[]],[], Si,So, Di,Do).
%satisfyClause(ID,LiS,LiS, M,DM, Si,Si, Di,Di).

satisfyClause(ID,LiS,NLiS, M,[PAT|DM], Si,So, Di,Do) :- !,
	satisfyClause1(ID,LiS,LiS1, M,PAT, Si,Sm, Di,Dm),
	satisfyClause(ID,LiS1,NLiS, M,DM, Sm,So, Dm,Do).
satisfyClause(ID,LiS,LiS, M,[], Si,Si, Di,Di).

satisfyClause1(ID,LiS,NLiS, M,PAT, Si,So, Di,Do) :- pc(ID,PAT), !,
	satisfyAnte(ID,LiS,NLiS, M,[PAT], [[]],[], Si,So, Di,Do).
satisfyClause1(ID,LiS,LiS, M,PAT, Si,Si, Di,Di).

satisfyAnte(ID,[],[], M,DM, Stack,DStack, Si,So, Di,Do) :- !,
    satisfyLiteral(ID, M,DM, Stack,DStack, Si,So, Di,Do).
satisfyAnte(ID,[S|LiS],[NS|NLiS1], M,DM, Stack,DStack, Si,So, Di,Do) :- 
    satisfyLiteral(ID, M,DM, Stack,DStack, S,NS, [],DS),
    satisfyAnte(ID,LiS,NLiS1, M,DM, S,DS, Si,So, Di,Do).

%
%   satisfyLiteral(+ClauseID, +WholeModel,+DifferentialOfModel,
%           +PreviousStack,+DifferentialOfPreviousStack,
%           +CurrentStack,-CurrentStack,
%           +DifferentialOfCurrentStack,-DifferentialOfCurrentStack)
%
satisfyLiteral(ID, M,DM, Stack,[S|DStack], Si,So, Di,Do) :- !,
    satisfyLiteral(ID, M,S, Si,Sm, Di,Dm),
    satisfyLiteral(ID, M,DM, Stack,DStack, Sm,So, Dm,Do).
satisfyLiteral(ID, M,DM, [S|Stack],DStack, Si,So, Di,Do) :- !,
    satisfyLiteral(ID, DM,S, Si,Sm, Di,Dm),
    satisfyLiteral(ID, M,DM, Stack,DStack, Sm,So, Dm,Do).
satisfyLiteral(_, _,_, [],[], Si,Si, Di,Di).

satisfyLiteral(ID, [P|Ps],S, Si,So, Di,Do) :- !,
    c(ID, [P|S], Si,Sm, Di,Dm),
    satisfyLiteral(ID, Ps,S, Sm,So, Dm,Do).
satisfyLiteral(_, [],_, Si,Si, Di,Di).

%
%   Library
%
checkConsq([],[], _).
checkConsq([X|Xs],Ys, M) :- checkConsq1(X,M, 0,Y,Y, Xs,Ys).

checkConsq1([],M, 1,H,[], Xs,[H|Ys]) :- checkConsq(Xs,Ys, M).
checkConsq1([A|X],M, S,H,T, Xs,Ys) :- 
	(member(A,M) -> checkConsq1(X,M, S,H,T, Xs,Ys);
	    T = [A|T1],	checkConsq1(X,M, 1,H,T1, Xs,Ys)).
