% SEARCH.pl
% Copyright (C) 1996 Kouichi Furukawa 
%                    (Read README.ps for detailed information.)


%%%%% ----- search(MSC,Pex,Nex,BK,Pathset,Set,Result) ----- %%%%%
:- dynamic positive/2.
:- dynamic negative/2.
:- dynamic set/2.

%del_covered_positive(Result,Pex,NewPex,U,U).
del_covered_positive([],[P|Pex],Pex,[P|U],U):-
	nl,write('no compression'),nl,
	write(P),write('.'),nl,nl.

del_covered_positive([Cls,Pos],P,NewP,[Cls1|U],U):-
	nl,write('Result of Search is  '),nl,
	unflattening(Cls,Cls1),
	numbervars(Cls1,0,_),write('['),
	write(Cls1),write('.'),write(']'),nl,nl,
%	\+(\+((numbervars(Cls1,0,_),write(Cls1),write('.'),nl))),
	del_pos(0,Pos,P,NewP).

del_pos(_,[],P,P).
del_pos(N,[N|T],[_|PT],NewP):-
	N1 is N+1,
	del_pos(N1,T,PT,NewP).
del_pos(N,M,[P|PT],[P|NPT]):-
	N1 is N+1,
	del_pos(N1,M,PT,NPT).

search((_:-B),Pex,Nex,BK,Pathset,[SetH,SetC,Noise],Result):-
	abolish(positive,2),
	abolish(negative,2),
	assert_ex(positive,Pex,0,P),
	assert_ex(negative,Nex,0,N),
	conj_length(B,Len),
	set_Sets([SetH,SetC,Noise],Len),
	append(Pex,BK,NewBK),!,
	expand(h([],_,[],0,Pathset,P,N),NewBK,0,[_|List],NewB),!,
	qsort_H(List,[Best|Sorted],[]),
	search([Best|Sorted],Best,NewBK,NewB,Result).
%search(_,_,_,_,_,_,[]).

%%% --- search(OpenList,BestClosed,BK,BestPass,Result).
search([],h(Cls,Cost,_,_,_,P,_),_,_,[Cls,P]):- rpass(Cost).
search([],_,_,_,[]).

search([BOpen|Open],BClosed,BK,BestPass,Result):- prune(BOpen),
	rbetter(BOpen,BClosed,Better),
	terminated(BClosed,Better,Open,NewOpen),
	search(NewOpen,Better,BK,BestPass,Result).

search([BOpen|Open],BClosed,BK,BestPass,Result):- !,
	expand(BOpen,BK,BestPass,Expand,NewBestPass),
	qsort_H(Expand,Expand1,[]),
	merge_H(Open,Expand1,TOpen),
	rbetter(BOpen,BClosed,Better),
	terminated(BClosed,Better,TOpen,NewOpen),!,
	search(NewOpen,Better,BK,NewBestPass,Result).

assert_ex(_,[],_,[]).
assert_ex(F,[H|T],N,[N|R]):-
	EX =..[F,N,H],
	assert(EX),
	M is N+1,
	assert_ex(F,T,M,R).

conj_length((_,B),N):- conj_length(B,M),N is M+1.
conj_length((_),1):-!.

set_Sets([SetH,SetC,Noise],Len):-
	abolish(set,2),
	(var(SetH) -> assert(set(h,10)),SetH = 10;
	    assert(set(h,SetH))),
        (var(Noise) -> assert(set(n,0)),Noise = 0;
	    assert(set(n,Noise))),
        (var(SetC) -> assert(set(c,Len));
	    (SetC < Len -> assert(set(c,SetC));
		assert(set(c,Len)))).

%%% sort list predicates.
qsort_H([],X,X).
qsort_H([F|Rest],H,T):- divide_H(F,Rest,High,Low),
    qsort_H(High,H,[F|X]),qsort_H(Low,X,T).

divide_H(_,[],[],[]).
divide_H(h(C,[G|Cost],T,K,Pa,P,N),
	[h(C1,[G1|Cost1],T1,K1,Pa1,P1,N1)|More],
	[h(C1,[G1|Cost1],T1,K1,Pa1,P1,N1)|High],Low):- G1 >= G,
	divide_H(h(C,[G|Cost],T,K,Pa,P,N),More,High,Low).
divide_H(X,[Y|More],High,[Y|Low]):- divide_H(X,More,High,Low).

merge_H([],X,X).
merge_H(X,[],X).
merge_H([h(Cls,[G|Cost],T,K,Pa,P,N)|More],
	[h(Cls1,[G1|Cost1],T1,K1,Pa1,P1,N1)|More1],
	[h(Cls,[G|Cost],T,K,Pa,P,N)|MoreR]):- G >= G1,
	merge_H(More,[h(Cls1,[G1|Cost1],T1,K1,Pa1,P1,N1)|More1],MoreR).
merge_H(X,[Y|More1],[Y|MoreR]):- merge_H(X,More1,MoreR).

%%% --- prune --- %%%
prune(h(_,[_,_,_,0,_,_],_,_,_,_,_)).
prune(h(_,[G,_,_,_,_,_],_,_,_,_,_)):- G < 0.
prune(h(_,[_,_,_,_,_,C],_,_,_,_,_)):- set(c,C1),C > C1.

%%% --- rpass --- %%%
rpass([_,F,P,N,0,_]):-
	F > 0,set(n,Noise),
	(P+N)*Noise >= 100*N.

%%%--- rbetter --- %%%
rbetter(Open,Closed,Better):-
	rpass(Open,X1,F1),
	rpass(Closed,X2,F2),
	rbetter(X1,X2,F1,F2,Open,Closed,Better).

rpass(h(_,[G,F,P,N,H,C],_,_,_,_,_),1,F):-
	rpass([G,F,P,N,H,C]).
rpass(h(_,[_,F,_,_,_,_],_,_,_,_,_),0,F).

rbetter(0,1,_,_,_,Closed,Closed).
rbetter(1,0,_,_,Open,_,Open).
rbetter(_,_,Fo,Fc,Open,_,Open):- Fo > Fc.
rbetter(_,_,_,_,_,Closed,Closed).

%%% --- terminated --- %%%
terminated(BClosed,Better,Open,Open):- BClosed == Better.
terminated(_,h(_,Cost,_,_,_,_,_),Open,Open):- \+ rpass(Cost).
terminated(_,h(_,[_,F|_],_,_,_,_,_),Open,NewOpen):-
	terminated(F,Open,NewOpen).

terminated(_,[],[]).
terminated(F,[h(Cls,[G|Cost],T,K,Pa,P,N)|More],
	     [h(Cls,[G|Cost],T,K,Pa,P,N)|MoreR]):- G > F,
	     terminated(F,More,MoreR).
terminated(F,[_|More],MoreR):-
	terminated(F,More,MoreR).

%%% --- expand --- %%%
expand(h(Cls,Cost,Theta,K,Path,Pex,Nex),BK,BPass,
	[h(Cls,Cost,Theta,K1,Path,Pex,Nex)|Result],NewB):-
	bottom(K,Bot), 
	refine(Bot,Theta,List,NT),!, 
	K1 is K+1,
	calc_h(K,Path,H,NewPath),
	length(Cls,C), 
	expand_loop(List,NT,Cls,K1,H,C,NewPath,Pex,Nex,BK,BPass,Result,NewB).

expand(h(Clause,Cost,Theta,K,Path,Pex,Nex),BK,BPass,Result,NewB):-
	K1 is K+1,set(c,C),K1 =< C,
	expand(h(Clause,Cost,Theta,K1,Path,Pex,Nex),BK,BPass,Result,NewB).
expand(_,_,BPass,[],BPass).

expand_loop([],[],_,_,_,_,_,_,_,_,BPass,[],BPass).
expand_loop([Cl|CT],[T|TT],Cls,K,H,C,Path,Pex,Nex,BK,BPass,
	[h([Cl|Cls],[G,F,P,N,H,C],T,K,Path,NP,NN)|TR],NewB):-
	calc_costs([Cl|Cls],Pex,Nex,BK,H,C,BPass,TBPass,NP,NN,F,G,P,N),
	expand_loop(CT,TT,Cls,K,H,C,Path,Pex,Nex,BK,TBPass,TR,NewB).

expand_loop([_|CT],[_|TT],Cls,K,H,C,Path,Pex,Nex,BK,BPass,TR,NewB):-
	expand_loop(CT,TT,Cls,K,H,C,Path,Pex,Nex,BK,BPass,TR,NewB).

calc_costs(Clause,Pex,Nex,BK,H,C,BP,NBP,NP,NN,F,G,P,N):-
	make_h(Clause,Hypothesis),
	reduce_example(p,Hypothesis,BK,Pex,NP), length(NP,P),
	G is P-C-H,!,
	G > BP,
	reduce_example(n,Hypothesis,BK,Nex,NN), length(NN,N),	
	F is G - N,
	write_costs(Hypothesis,F,P,N,H),
	((F > BP,rpass([G,F,P,N,H,C]),NBP = F);
	    NBP = BP).

write_costs(Cls,F,P,N,H):-
	write('[C:'),write(' '),write(F),write(','),write(P),write(','),
	write(N),write(','),write(H),write(' '),
	\+(\+((numbervars(Cls,0,_),write(Cls)))),
	write('.]'),nl.

%%% --- refine --- %%%
refine(X,Theta,X1,Y1):- refine(X,Theta,X1,[],Y1,[]).

refine(var(Var,+),Theta,XL,U,TL,V):- !,
	refine_mem(Theta,Var,Theta,XL,U,TL,V,0).
refine(var(Var,-),Theta,[NV|XL],U,[[NV/Var|Theta]|TL],V):- var(NV),
	refine_mem(Theta,Var,Theta,XL,U,TL,V,0).
refine(var(Var,-),Theta,[NV|U],U,[[NV/Var|Theta]|V],V):- var(NV),!.
refine(var(Var,hplus),Theta,[NV|XL],U,[[NV/Var|Theta]|TL],V):- var(NV),
	refine_mem(Theta,Var,Theta,XL,U,TL,V,0).
refine(var(Var,hplus),Theta,[NV|U],U,[[NV/Var|Theta]|V],V):- var(NV),!.

refine(var(Var,#),Theta,[Var|U],U,[Theta|V],V):- !.


refine([],Theta,[[]|U],U,[Theta|V],V):-!.
refine([H|T],Theta,XU,U,XV,V):- !,
	refine(H,Theta,X,[],Y,[]),
	refineL(T,X,Y,XU,U,XV,V).

refineL(_,[],[],U,U,V,V).
refineL(T,[Var|X],[Theta|Y],XU,U,XV,V):-
	refine(T,Theta,A,[],B,[]),
	refineL1(Var,A,B,XU,XU1,XV,XV1),
	refineL(T,X,Y,XU1,U,XV1,V).

refineL1(_,[],[],U,U,V,V).
refineL1(Var,[H|T],[H1|T1],[[Var|H]|U1],U,[H1|V1],V):-
	refineL1(Var,T,T1,U1,U,V1,V).

refine(X,Theta,UU,U,VV,V):- !,
	X =..[F|Arg],
	refine(Arg,Theta,XX,[],VV,V),
	refineF(F,XX,UU,U).

refineF(_,[],U,U).
refineF(F,[XX|T],[X|U1],U):-
	X =..[F|XX],
	refineF(F,T,U1,U).

refine_mem(_,_,[],U,U,V,V,1).
refine_mem(K,V,[RArg/Arg|Theta],[RArg|UU1],UU,[K|VV1],VV,_):- V == Arg,!,
	refine_mem(K,V,Theta,UU1,UU,VV1,VV,1).
refine_mem(K,V,[_|Theta],UU,U1,VV,V1,F):- 
	refine_mem(K,V,Theta,UU,U1,VV,V1,F).

%%% --- calc_h --- %%%
calc_h(K,[Path|T],H,[NewPath|Rest]):- 
	calc_h(K,Path,NewPath),length(NewPath,Len),
	calc_h(K,T,Len,H,Rest).
calc_h(_,[],H,H,[]).
calc_h(K,[Path|T],TH,H,[NPath|NT]):-
	calc_h(K,Path,NPath),length(NPath,L),!,
	(L < TH -> calc_h(K,T,L,H,NT);
	    calc_h(K,T,TH,H,NT)).

calc_h(_,[],[]).
calc_h(K,[K|T],TR):- calc_h(K,T,TR).
calc_h(K,[Y|T],[Y|TR]):- calc_h(K,T,TR).

%%% --- make_h --- %%%
make_h([H],H).
make_h([B|H],X):- make_h(H,B,X).
make_h([H],B,(H:-B)).
make_h([H|B],T,X):- make_h(B,(H,T),X).

%reduce_example(Hypothesis,BK,Pex,NP).
reduce_example(F,Cls,BK,Pex,NP):- set(h,H),
	reduce_example(F,Cls,BK,Pex,NP,H).
reduce_example(_,_,_,[],[],_).
reduce_example(F,Cls,BK,[P|Pex],[P|T],H):-
	get_pn_example(F,P,Pos),
	meta_prolog(Pos,Pos,[Cls|BK],H),
	reduce_example(F,Cls,BK,Pex,T,H).
reduce_example(F,Cls,BK,[_|Pex],T,H):-
	reduce_example(F,Cls,BK,Pex,T,H).

get_pn_example(p,P,Pos):- positive(P,Pos).
get_pn_example(n,P,Pos):- negative(P,Pos).

%%% --- meta_prolog --- %%%
meta_prolog(P,Clause,BK,H):-
	copy_term(Clause,Clause1),
	meta_prolog(P,Clause1,BK,0,_,H).

%meta_prolog(_,_,U,_,H):- U > H,!,false.
meta_prolog(_,true,_,U,U,_):- !.
meta_prolog(A,(P:-Q),BK,U,U1,H):- !,
	meta_prolog(A,P,BK,U,U2,H),
	meta_prolog(A,Q,BK,U2,U1,H).

meta_prolog(A,(P,Q),BK,U,U1,H):- !,
	meta_prolog(A,P,BK,U,U2,H),
	meta_prolog(A,Q,BK,U2,U1,H).
meta_prolog(A,(P;Q),BK,U,U1,H):- !,
	(meta_prolog(A,P,BK,U,U1,H);
	 meta_prolog(A,Q,BK,U,U1,H)).

meta_prolog(_,(X=Y),_,U,U1,_):- !,
%	unify(X,Y),
	X = Y,
	U1 is U+1.

meta_prolog(A,Clause,BK,U,U1,H):- U =< H,
	select_clause(A,Clause,BK,Body),
	U2 is U+1,
	meta_prolog(A,Body,BK,U2,U1,H).

select_clause(A,Clause,[(X:-Y)|_],Body):-
	A \== X,
	\+(\+(X = Clause)),
	copy_term((X:-Y),(X1:-Body)),
	X1 = Clause.

select_clause(A,Clause,[(X)|_],true):-
	A \== X,
	\+(\+(X = Clause)),
	copy_term(X,Y),
	Clause = Y.

select_clause(A,Clause,[_|BK],Body):-
	select_clause(A,Clause,BK,Body).

%%% --- unflattening --- %%%
unflattening(X,Result):- 
	reverse(X,[Head|Body]),
	unflattening(Head,Body,HR,BR),
	unflat_list2conj(HR,BR,Result).

unflattening(X,X).

unflat_list2conj(H,[],H):-!.
unflat_list2conj(H,X,(H:-B)):-list2conj(X,B).

unflattening(Head,Body,HR,BR):-
    divide_body(Body,Equal,Else),
    unflattening(Head,Else,Equal,HR,BR),!.

divide_body([],[],[]).
divide_body([H|T],[H|X],Y):- H = (_=_), 
    divide_body(T,X,Y).
divide_body([H|T],X,[H|Y]):- 
    divide_body(T,X,Y).

unflattening(Head,Body,[],Head,Body).
unflattening(Head,Body,[H|T],HR,BR):-
    unflat(Head,H,Head1),
    unflat(Body,H,Body1),
    unflat(T,H,T1),
    unflattening(Head1,Body1,T1,HR,BR).

unflat(X,(W=H),Y):- X == W,Y = H.
unflat(H,_,H):- var(H).
unflat(H,_,H):- integer(H).

unflat([H|T],X,[H1|T1]):-
    unflat(H,X,H1),
    unflat(T,X,T1).
unflat(H,X,R):-
    functor(H,F,N),N > 0,
    functor(R,F,N),
    unflat(N,H,R,X).
unflat(X,_,X).

unflat(0,_,_,_).
unflat(N,A,B,X):- arg(N,A,A1),
    unflat(A1,X,B1),
    arg(N,B,B1),
    N1 is N-1,
    unflat(N1,A,B,X).

reverse(X,Y):- reverse(X,[],Y).
reverse([],X,X).
reverse([W|X],Y,Z):- reverse(X,[W|Y],Z).
