% PROGOL.pl
% Copyright (C) 1996 Kouichi Furukawa 
%                    (Read README.ps for detailed information.)

:- compile([magic,m2pl,bot,search]).
:- op(100,fx,(#)).
:- dynamic bottom/2.
:- dynamic table/5.

member(X,[X|_]).
member(X,[_|Y]):- member(X,Y).
%append([],Y,Y).
%append([W|X],Y,[W|Z]):- append(X,Y,Z).

%%%%% ----- progol([F]) ----- %%%%%
progol([F]):-
	load_pgl_file(F,Mode,Type,BK,Pex,Nex,Set),
	cover_set(F,Mode,Type,BK,Pex,Nex,Set,Result,[]),
	show_result(0,Result).

%%%%% ----- cover_set(F,Mode,Type,BK,Pex,Nex,Set,Result) ----- %%%%%
cover_set(_,_,_,_,[],_,_,U,U).
cover_set(F,Mode,Type,BK,[P|Pex],Nex,Set,U,V):-
	write_magic(F,Mode,Type,BK,[P|Pex]),
	do_m2pl(F),
	make_bottom(F,Bot),
	make_htable(Mode), %assert table
	hash(Bot,MSC,MSC_T),
	write('[Generalising  '),write(P),period,write(']'),nl,
	write('[Most Specific Clause is ]'),nl,
	\+(\+((numbervars(MSC,0,_),write(MSC),write('.'),nl))),

	trans(MSC,MSC_T,PathData), %assert bottom
	pathset(PathData,Path),
	search(MSC,[P|Pex],Nex,BK,Path,Set,SearchResult),!,
	del_covered_positive(SearchResult,[P|Pex],NewPex,U,U1),
	cover_set(F,Mode,Type,BK,NewPex,Nex,Set,U1,V).

%%% --- show_result --- %%%
show_result(N,[]):- 
	write('[Total number of clauses = '),write(N),write(']'),nl.
show_result(N,[H|T]):- 
	\+(\+((numbervars(H,0,_),write(H),write('.'),nl))),
	N1 is N+1,
	show_result(N1,T).
	
%fileerrors.
%nofileerrors.

%%%%% ----- write_magic(F,Mode,Type,BK,Pex,Nex) ----- %%%%%
write_magic(F,Mode,Type,BK,[P|Pex]):-
	nofileerrors,
	name_concat([F,'.m'],OutF), tell(OutF),
	outputHead(OutF),
	tr_modes(Mode),
	tr_clauses(P,Type),
	for_builtin_types,
	(type(any(_))-> for_any_types;true),
	tr_clauses(P,BK),
	tr_clauses(P,Pex),
	tr_positive_ex(P),
	told.
%	write('[Generalising  '),write(P),period,write(']'),nl.
%%%%% ----- do_m2pl(F) ----- %%%%%
init_m2pl :-
	abolish(mgtp_option,2),
	asserta(mgtp_option(delta_duplication,yes)).

do_m2pl(Name):-
	init_m2pl,
	init1,
	nofileerrors,
	name_concat([Name,'.m'],InF),
	name_concat([Name,'.mgtp'],OutF),
	tell(OutF),
	outputBanner(OutF),
	see(InF), fileerrors,
	readCls(InF,Pcls,Tcls,Gcls),!,
	explosion_check(Gcls,Gcls0,[]),
	multi_entries(Tcls,Tcls1,[]),
	multi_entries(Gcls0,Gcls1,[]),
	multi_entries(Pcls,Pcls1,[]),
	remove_taut(Gcls1,Gcls2),
	review(Pcls1,Tcls1,Gcls2),
	newpage,
	outputHead,
	outputTM,
	newpage,
	firing_atoms(Pcls1,Pcls2,Tcls1,Gcls2),
	firing_atoms(Gcls2,Gcls3,Tcls1,Gcls2),
	output_firing_cls(Gcls2),
	nl,
	outputPcalls(Pcls2),
	newpage,
	outputCls(Tcls1),
	outputCls(Gcls3),
	outputCls(Pcls2),
	nl,
	copyVerbatim,
	outputFoot(OutF),
	told.

%%%%% ----- make_bottom(F,Bot) ----- %%%%%
make_bottom(File,BOT) :-
	init_bot,
	nofileerrors,
	name_concat([File,'.mgtp'],InF),compile(InF),
	fileerrors,
	abolish(status,1),assert(status(unsat)),
	tm_new(TM),
	init_buf(A_Buf0),
	init_buf(B_Buf0),
	fire_generators(positive_Horn,(true,0,TM),Us),
	add_buf(Us,(A_Buf0,B_Buf0),(B_Buf1,A_Buf1)),
	mgtp_option(h,H),
	main_loop((A_Buf1,B_Buf1),[],0,TM,Bot-[],H,1),
	fix_var_level,
	( mgtp_option(basic,on) -> Bot=BOT;
	    extract_bot(Bot,BOT,_) ). % _ is Level
init_bot :-
	abolish(vset,2), asserta(vset('DUMMY',[])),
	abolish(stored,2), asserta(stored('DUMMY','X0')),
	abolish(counter,1), asserta(counter(0)),
	abolish(mgtp_option,2),
	asserta(mgtp_option(h,500)),
	asserta(mgtp_option(r,20)),
	asserta(mgtp_option(i,3)),
	asserta(mgtp_option(basic,off)),
	asserta(mgtp_option(dup,yes)),
	asserta(mgtp_option(buffer,queue)).

%%%%% ----- make_htable(Mode) ----- %%%%%
make_htable(Mode):-
	abolish(table,5),
	tr_modes_htable(Mode).

tr_modes_htable([]).
tr_modes_htable([modeh(_,Pat)|MM]) :-
	tr_mode_htable(head,Pat),!,
	tr_modes_htable(MM).
tr_modes_htable([modeb(_,Pat)|MM]) :-
	tr_mode_htable(body,Pat),!,
	tr_modes_htable(MM).

tr_mode_htable(HB,Pat) :-
	tr_pat_htable(Pat,APat,BPat,CPat,Table,[]),
	X =..[table,HB,APat,BPat,CPat,Table],
	copy_term(X,Y),
	assert(Y).

tr_pat_htable(Pat,APat,BPat,CPat,Table,Tz) :-
	Pat=..[HeadP|Args],
	tr_args_htable(Args,AArgs,BArgs,CArgs,Table,Tz),
	APat=..[HeadP|AArgs],
	BPat=..[HeadP|BArgs],
	CPat=..[HeadP|CArgs].

tr_args_htable([],[],[],[],T,T).
tr_args_htable([Arg|Args],[A|As],[B|Bs],[C|Cs],Table,Tz) :-
	tr_arg_htable(Arg,A,B,C,Table,Tm),
	tr_args_htable(Args,As,Bs,Cs,Tm,Tz).

tr_arg_htable(+_,U,V,+,[(U->V)|Tz],Tz) :- !.
tr_arg_htable(-_,U,V,-,[(U->V)|Tz],Tz) :- !.
tr_arg_htable(#_,#U,U,#,T,T) :- !.
tr_arg_htable(Term,A,B,C,Table,Tz) :-
	Term=..[Funct|Args],
	tr_args_htable(Args,AArgs,BArgs,CArgs,Table,Tz),
	A=..[Funct|AArgs],
	B=..[Funct|BArgs],
	C=..[Funct|CArgs].

%%%%% ----- hash(Bot,MSC,MSC_Type) ----- %%%%%
hash((H:-B),(MH:-MB),(TH:-TB)):-
	table(head,H,MH,TH,HTable),
	body_tables(B,MB,TB,BTables,[]),
	hash_tables([HTable|BTables],[],_),
	numbervars((MH:-MB),0,_).

body_tables((A,B),(MA,MB),(TA,TB),Table,Tz):- !,
	body_tables(A,MA,TA,Table,Tm),
	body_tables(B,MB,TB,Tm,Tz).
body_tables(B,MB,TB,[Table|Tz],Tz):-
	table(body,B,MB,TB,Table).

hash_tables([T1|Ts],GTi,GTo) :-
	hash_table1(T1,GTi,GTm),
	hash_tables(Ts,GTm,GTo).
hash_tables([],GT,GT).

hash_table1([Item|Items],GTi,GTo) :-
	hash_one(Item,GTi,GTm),
	hash_table1(Items,GTm,GTo).
hash_table1([],GT,GT).

hash_one(Item,[],[Item]).
hash_one(Item,GlobalTable,GlobalTable) :-
	GlobalTable=[Item|_],!.
hash_one(Item,[X|GlobalTable],[X|NewGlobalTable]) :-
	hash_one(Item,GlobalTable,NewGlobalTable).

%%%%% ----- trans(MSC,Type,Path) ----- %%%%%
trans((H:-B),(TH:-TB),[Model,Goal,Literal,N]):-
	abolish(bottom,2),
	trans_head(H,TH,Model,Goal),
	trans_body(1,Goal,B,TB,Literal,[],0,N).

trans_head(H,TH,Model,Goal):-
	trans1(hplus,H,TH,Bottom,Plus,[],Goal,[]),
	trans_plus_to_model(Plus,Model),
%	assert(bottom(head,Bottom)).
	assert(bottom(0,Bottom)).

trans_body(N,Goal,(B,BT),(TB,TBT),Lit,TLit,No,No1):-
	trans1(+,B,TB,Bottom,Plus,[],Minus,[]),
	trans_pm_to_lit(N,Goal,Plus,Minus,Lit,LitT,No,No2),
	assert(bottom(N,Bottom)),
	N1 is N+1,
	trans_body(N1,Goal,BT,TBT,LitT,TLit,No2,No1).

trans_body(N,Goal,B,TB,Lit,LitT,No,No1):-
	trans1(+,B,TB,Bottom,Plus,[],Minus,[]),
	assert(bottom(N,Bottom)),
	trans_pm_to_lit(N,Goal,Plus,Minus,Lit,LitT,No,No1).

trans1(_,[],[],[],P,P,M,M).
trans1(T,X,+,var(X,T),[X|P],P,M,M).
trans1(_,X,-,var(X,-),P,P,[X|M],M).
trans1(_,X,#,var(X,#),P,P,M,M).
%trans1(_,X,#,X,P,P,M,M).

trans1(T,[H|HT],[TH|THT],[B|BT],P,PT,M,MT):-
	trans1(T,H,TH,B,P,PPT,M,MMT),
	trans1(T,HT,THT,BT,PPT,PT,MMT,MT).
trans1(T,H,TH,B,P,PT,M,MT):-
	H  =..[F|Arg],
	TH =..[F|TArg],
	trans1(T,Arg,TArg,BArg,P,PT,M,MT),
	B  =..[F|BArg].

trans_plus_to_model([],[]).
trans_plus_to_model([H|T],[var(H,[])|TR]):-
	trans_plus_to_model(T,TR).

trans_pm_to_lit(_,_,_,[],LitT,LitT,No,No). %Minus = [].
trans_pm_to_lit(N,Goal,Plus,Minus,[lit(N,Plus,Minus,T)|LitT],LitT,No,No1):-
	check_union(Goal,Minus,T,No,No1).

check_union([],_,0,No,No).
check_union([X|_],Y,1,No,No1):-
	member(X,Y),No1 is No+1.
check_union([_|X],Y,N,No,No1):-
	check_union(X,Y,N,No,No1).

%%%%% ----- pathset(Lit,Path) ----- %%%%%
pathset([InitModel,Dest,Literal,N],Result):-
	pset_loop(N,Literal,InitModel,Model),
	pset_require(Model,Dest,[[]],Result).

%pset_loop(N,Literal,Model,NewModel).
pset_loop(0,_,Model,Model).
pset_loop(N,Literal,Model,NewModel):-
	literal_loop(N,Literal,Model,NewN,NewLiteral,Model,NewModel1),
	pset_loop(NewN,NewLiteral,NewModel1,NewModel).

%% literal_loop(N,Literal,Model,NewN,NewLiteral,NewModel).
literal_loop(N,[],_,N,[],NewModel,NewModel). % _ is Model
literal_loop(N,[lit(LNo,Require,Generate,Flag)|Tail],Model,
	NewN,NewLiteral,Tmp,NewModel):-
	pset_require(Model,Require,[[]],Pair),
	pset_generate(LNo,Pair,Generate,Tmp,TmpModel),
	TmpN is N-Flag,
	literal_loop(TmpN,Tail,Model,NewN,NewLiteral,TmpModel,NewModel).

literal_loop(N,[X|Tail],Model,NewN,[X|NewLiteral],Tmp,NewModel):-
	literal_loop(N,Tail,Model,NewN,NewLiteral,Tmp,NewModel).

%%pset_require(Model,Require,TmpPair,Pair)
pset_require(_,[],Pair,Pair):- !.
pset_require(Model,[X|Tail],TmpPair,Pair):-
	pset_require(Model,X,Mem),!,Mem \== [],
	make_pair(TmpPair,Mem,[],TPair),
	pset_require(Model,Tail,TPair,Pair).

pset_require([],_,[]).
pset_require([var(No,Path)|Tail],No,[Path|TailR]):-
	pset_require(Tail,No,TailR).
pset_require([_|Tail],No,TailR):-
	pset_require(Tail,No,TailR).

make_pair([],_,X,X).
make_pair([X|Y],Mem,Pair,Result):-
	make_pair1(X,Mem,Pair,Pair1),
	make_pair(Y,Mem,Pair1,Result).
make_pair1(_,[],X,X).
make_pair1(X,[Y|Tail],Pair,Result):-
	make_or(X,Y,Z),
	make_pair1(X,Tail,[Z|Pair],Result).

make_or([],X,X).
make_or(X,[],X).
make_or([X|XT],[X|YT],[X|T]):-
	make_or(XT,YT,T).
make_or([X|XT],[Y|YT],[X|T]):- X > Y,
	make_or(XT,[Y|YT],T).
make_or([X|XT],[Y|YT],[Y|T]):- X < Y,
	make_or([X|XT],YT,T).

%%pset_generate(Lno,Pair,Generate,Tmp,Model).
pset_generate(_,[],_,Model,Model).
pset_generate(Lno,[Path|Pair],Generate,Tmp,Model):-
	pset_generate1(Lno,Path,Generate,Tmp,Tmp1),
	pset_generate(Lno,Pair,Generate,Tmp1,Model).

pset_generate1(_,_,[],Model,Model).
pset_generate1(Lno,Path,[X|Tail],Tmp,Model):-
	pset_insert(Lno,Path,Path1),
	pset_generate1(Lno,Path,Tail,[var(X,Path1)|Tmp],Model).

pset_insert(X,[],[X]).
pset_insert(X,[Y|T],[X,Y|T]):- X > Y.
pset_insert(X,[Y|T],[Y|TR]):- pset_insert(X,T,TR).

%%%%% ----- load_pgl_file(file,mode,type,b-knowlegth,p-ex,n-ex,parameter).%%%%%
load_pgl_file(F,Mode,Type,BK,Pex,Nex,Set):-
    nofileerrors,
    name_concat([F,'.pgl'],InF),
    see(InF),fileerrors,
    read_Clause(InF,Mode,Type,BK,Pex,Nex,Set),!.

%%%read_Clause(Inf,Mode,Type,BK,Pex,Nex,Set)
read_Clause(InF,Mode,Type,BK,Pex,Nex,Set):- % [InF] for ap/3.
    read(X) -> scan_cls(X,type,[InF],Mode,Type,BK,Pex,Nex,Set).

scan_cls(end_of_file,_,[_],[],[],[],[],[],_):- seen. % end of scan_cls.
scan_cls(end_of_file,Flag,[_,File|InF],Mode,Type,BK,Pex,Nex,Set):-
    seen, % close file1.
    see(File), %Open file2.
    read(X) -> scan_cls(X,Flag,[File|InF],Mode,Type,BK,Pex,Nex,Set).

scan_cls(X,Flag,InF,Mode,Type,BK,Pex,Nex,Set):- X=(:-see(File)), % include.
    see(File), %Open Newfile.
    read(NX) -> scan_cls(NX,Flag,[File|InF],Mode,Type,BK,Pex,Nex,Set).

scan_cls((:-type),_,InF,Mode,Type,BK,Pex,Nex,Set):- %type definition.
    read(X) -> scan_cls(X,type,InF,Mode,Type,BK,Pex,Nex,Set).

scan_cls((:-background),_,InF,Mode,Type,BK,Pex,Nex,Set):- %B-knowledge.
    read(X) -> scan_cls(X,background,InF,Mode,Type,BK,Pex,Nex,Set).

scan_cls((:-positive_ex),_,InF,Mode,Type,BK,Pex,Nex,Set):- %positive ex
    read(X) -> scan_cls(X,positive_ex,InF,Mode,Type,BK,Pex,Nex,Set).

scan_cls((:-negative_ex),_,InF,Mode,Type,BK,Pex,Nex,Set):- %negative ex
    read(X) -> scan_cls(X,negative_ex,InF,Mode,Type,BK,Pex,Nex,Set).

%input set.
scan_cls(set(c,C),Flag,InF,Mode,Type,BK,Pex,Nex,[C,Noise,H]):- 
    read(X) -> scan_cls(X,Flag,InF,Mode,Type,BK,Pex,Nex,[C,Noise,H]).

scan_cls(set(noise,N),Flag,InF,Mode,Type,BK,Pex,Nex,[C,N,H]):-
    read(X) -> scan_cls(X,Flag,InF,Mode,Type,BK,Pex,Nex,[C,N,H]).

scan_cls(set(h,H),Flag,InF,Mode,Type,BK,Pex,Nex,[C,Noise,H]):-
    read(X) -> scan_cls(X,Flag,InF,Mode,Type,BK,Pex,Nex,[C,Noise,H]).

%input set error recover.
scan_cls(set(_,_),Flag,InF,Mode,Type,BK,Pex,Nex,Set):-
    read(X) -> scan_cls(X,Flag,InF,Mode,Type,BK,Pex,Nex,Set).

scan_cls(X,Flag,InF,[M|Mode],Type,BK,Pex,Nex,Set):- %input Mode 
    X=(:-M),(M=..[modeh|_];M=..[modeb|_]),
    read(NX) -> scan_cls(NX,Flag,InF,Mode,Type,BK,Pex,Nex,Set).

scan_cls(X,type,InF,Mode,[X|Type],BK,Pex,Nex,Set):- %input type.
    read(NX) -> scan_cls(NX,type,InF,Mode,Type,BK,Pex,Nex,Set).

scan_cls(X,background,InF,Mode,Type,[X|BK],Pex,Nex,Set):- %input B-knowledge.
    read(NX) -> scan_cls(NX,background,InF,Mode,Type,BK,Pex,Nex,Set).

scan_cls(X,positive_ex,InF,Mode,Type,BK,[X|Pex],Nex,Set):- %input Pex.
    read(NX) -> scan_cls(NX,positive_ex,InF,Mode,Type,BK,Pex,Nex,Set).

scan_cls((:-X),negative_ex,InF,Mode,Type,BK,Pex,[X|Nex],Set):- %input Nex.
    read(NX) -> scan_cls(NX,negative_ex,InF,Mode,Type,BK,Pex,Nex,Set).

scan_cls(_,Flag,InF,Mode,Type,BK,Pex,Nex,Set):- %otherwise.
    read(NX) -> scan_cls(NX,Flag,InF,Mode,Type,BK,Pex,Nex,Set).
