% MAGIC.pl
% Copyright (C) 1996 Kouichi Furukawa 
%                    (Read README.ps for detailed information.)

magic_version(
'magic  v0.9.1  fujita@sys.crl.melco.co.jp  ''95-02-07').

builtin_p(_=_).
builtin_p(_=<_).

builtin_type(int(X),integer(X)).

%%

:- op(100, fx, (#)).

:- dynamic magic_option/2.

%init :-	abolish(magic_option,2).

set_options2(_).

tr_modes([]).
tr_modes([modeh(_,Pat)|MM]) :-
	tr_modeh(Pat),
	tr_modes(MM).
tr_modes([modeb(_,Pat)|MM]) :-
	tr_modeb(Pat),
	tr_modes(MM).

tr_modeh(Pat) :-
	tr_head_pat(Pat,APat,HeadPat,Types,InTypes,MagicTypes),
	list2conj(Types,CjTypes),
	mk_conj(-APat,CjTypes,Ante),
	list2conj(InTypes,CjInTypes),
	mk_conj(head(HeadPat),CjInTypes,Cnsq),
	output_clause((Ante-->Cnsq)),
	list2conj(MagicTypes,CjMagicTypes),
	mk_conj(CjMagicTypes,true,Cnsq2),
	output_clause((-APat-->Cnsq2)).

tr_modeb(Pat) :-
	builtin_p(Pat),!,
	tr_body_pat(Pat,APat,BodyPat,PTypes,NTypes,InTypes,
		MagicTypes,_,builtin),
	list2conj(PTypes,CjPTypes),
	list2conj(NTypes,CjNTypes),
	mk_conj(CjPTypes,{{APat}},Ante0),
	mk_conj(Ante0,CjNTypes,Ante),
	list2conj(InTypes,CjInTypes),
	mk_conj(body(BodyPat),CjInTypes,Cnsq),
	output_clause((Ante-->Cnsq)),
	list2conj(MagicTypes,CjMagicTypes),
	mk_conj(CjMagicTypes,true,Cnsq2),
	output_clause((Ante0-->Cnsq2)).

tr_modeb(Pat) :-
	tr_body_pat(Pat,APat,BodyPat,PTypes,NTypes,InTypes,
		MagicTypes,MagicBody,user),
	list2conj(NTypes,CjNTypes),
	mk_conj(APat,CjNTypes,Ante),
	list2conj(InTypes,CjInTypes),
	mk_conj(body(BodyPat),CjInTypes,Cnsq),
	output_clause((Ante-->Cnsq)),
	list2conj(PTypes,CjPTypes),
	mk_conj(CjPTypes,true,Ante2),
	output_clause((Ante2-->MagicBody)),
	list2conj(MagicTypes,CjMagicTypes),
	mk_conj(CjMagicTypes,true,Cnsq2),
	output_clause((APat-->Cnsq2)).

tr_head_pat(Pat,APat,HeadPat,Types,InTypes,MagicTypes) :-
	Pat=..[HeadP|Args],
	tr_head_args0(Args,NewAs,NewArgs,Types,InTypes,MagicTypes),
	APat=..[HeadP|NewAs],
	HeadPat=..[HeadP|NewArgs].

tr_head_args0([],[],[],[],[],[]).
tr_head_args0([Arg|Args],[A|As],[NewArg|NewArgs],
		[Type1|Types],[InType1|InTypes],[MagicType1|MagicTypes]) :-
	tr_head_arg(Arg,A,NewArg,Type1,InType1,MagicType1),
	tr_head_args0(Args,As,NewArgs,Types,InTypes,MagicTypes).

tr_head_args([],[],[],true,true,true).
tr_head_args([Arg|Args],[A|As],[NewArg|NewArgs],Types,InTypes,MagicTypes) :-
	tr_head_arg(Arg,A,NewArg,Type1,InType1,MagicType1),
	tr_head_args(Args,As,NewArgs,TypesS,InTypesS,MagicTypesS),
	mk_conj(Type1,TypesS,Types),
	mk_conj(InType1,InTypesS,InTypes),
	mk_conj(MagicType1,MagicTypesS,MagicTypes).

tr_head_arg(+Type,V,V,Type1,InType1,MagicType1) :-
	Type1=..[Type,V],
	store_type(Type1),
	name_concat(['magic_',Type],MagicType),
	MagicType1=..[MagicType,V],
	store_magic(Type1,MagicType1),
	name_concat(['in_',Type],InType),
	InType1=..[InType,V].
tr_head_arg(-Type,V,V,Type1,true,MagicType1) :-
	Type1=..[Type,V],
	store_type(Type1),
	name_concat(['magic_',Type],MagicType),
	MagicType1=..[MagicType,V],
	store_magic(Type1,MagicType1).
tr_head_arg(#Type,V,#V,Type1,true,MagicType1) :-
	Type1=..[Type,V],
	store_type(Type1),
	name_concat(['magic_',Type],MagicType),
	MagicType1=..[MagicType,V],
	store_magic(Type1,MagicType1).
tr_head_arg(Term,NewT,NewTerm,Types,InTypes,MagicTypes) :-
	Term=..[Funct|Args],
	tr_head_args(Args,NewAs,NewArgs,Types,InTypes,MagicTypes),
	NewT=..[Funct|NewAs],
	NewTerm=..[Funct|NewArgs].

tr_body_pat(Pat,APat,BodyPat,PTypes,NTypes,InTypes,MagicTypes,MagicBody,BU) :-
	Pat=..[BodyP|Args],
	tr_body_args0(Args,NewAs,NewArgs,PTypes,NTypes,InTypes,
		MagicTypes,MagicAs),
	APat=..[BodyP|NewAs],
	BodyPat=..[BodyP|NewArgs],
	name_concat(['magic_',BodyP],MagicBodyP),
	magic_args(NewArgs,MagicAs,MagicArgs),
	MagicBody=..[MagicBodyP|MagicArgs],
	( BU=user -> store_magic(BodyPat,MagicBody) ; true ).

magic_args([],[],[]).
magic_args([NewArg|NewArgs],[X|MagicAs],[NewArg|MagicArgs]) :-
	var(X),!,
	magic_args(NewArgs,MagicAs,MagicArgs).
magic_args([_|NewArgs],[_|MagicAs],MagicArgs) :-
	magic_args(NewArgs,MagicAs,MagicArgs).

tr_body_args0([],[],[],[],[],[],[],[]).
tr_body_args0([Arg|Args],[A|As],[NewArg|NewArgs],
		[PType1|PTypes],[NType1|NTypes],[InType1|InTypes],
		[MagicType1|MagicTypes],[MagicA1|MagicAs]) :-
	tr_body_arg(Arg,A,NewArg,PType1,NType1,InType1,MagicType1,MagicA1),
	tr_body_args0(Args,As,NewArgs,PTypes,NTypes,InTypes,
		MagicTypes,MagicAs).

tr_body_args([],[],[],true,true,true,true,_).
tr_body_args([Arg|Args],[A|As],[NewArg|NewArgs],
		PTypes,NTypes,InTypes,MagicTypes,MagicA) :-
	tr_body_arg(Arg,A,NewArg,PType1,NType1,InType1,MagicType1,MagicA),
	tr_body_args(Args,As,NewArgs,PTypesS,NTypesS,InTypesS,
		MagicTypesS,MagicA),
	mk_conj(PType1,PTypesS,PTypes),
	mk_conj(NType1,NTypesS,NTypes),
	mk_conj(InType1,InTypesS,InTypes),
	mk_conj(MagicType1,MagicTypesS,MagicTypes).

tr_body_arg(+Type,V,V,PType1,true,true,true,_) :-
	Type1=..[Type,V],
	store_type(Type1),
	name_concat(['in_',Type],InType),
	PType1=..[InType,V].
tr_body_arg(-Type,V,V,true,NType1,InType1,MagicType1,output_arg) :-
	NType1=..[Type,V],
	store_type(NType1),
	name_concat(['magic_',Type],MagicType),
	MagicType1=..[MagicType,V],
	store_magic(NType1,MagicType1),
	name_concat(['in_',Type],InType),
	InType1=..[InType,V].
tr_body_arg(#Type,V,#V,PType1,true,true,true,_) :-
	Type1=..[Type,V],
	store_type(Type1),
	name_concat(['in_',Type],InType),
	PType1=..[InType,V].
tr_body_arg(Term,NewT,NewTerm,PTypes,NTypes,InTypes,MagicTypes,MagicA) :-
	Term=..[Funct|Args],
	tr_body_args(Args,NewAs,NewArgs,PTypes,NTypes,InTypes,
		MagicTypes,MagicA),
	NewT=..[Funct|NewAs],
	NewTerm=..[Funct|NewArgs].

mk_conj(true,A,A) :- !.
mk_conj(A,true,A) :- !.
mk_conj((A,B),C,(A,B,C)):-!.
mk_conj(A,B,(A,B)).

list2conj([],true).
list2conj([A],A) :- !.
list2conj([true|R],C) :- !,list2conj(R,C).
list2conj([A|R],C) :- list2conj(R,D), mk_conj(A,D,C).

:- dynamic magic/2.

store_magic(P,MagicP) :-
	magic(Q,MagicQ),
	variant((P,MagicP),(Q,MagicQ)).
store_magic(P,MagicP) :-
	asserta(magic(P,MagicP)).

:- dynamic type/1.

store_type(Type) :-
	type(X),
	variant(Type,X).
store_type(Type) :-
	asserta(type(Type)).

%%

for_builtin_types :-
	type(Type),
	builtin_type(Type,BuiltinType),
	output_builtin_type(Type,BuiltinType),
	fail.
for_builtin_types.

output_builtin_type(Type,BuiltinType) :-
	Type=..[T|Args],
	name_concat(['magic_',T],MagicT),
	MagicType=..[MagicT|Args],
	output_clause((MagicType,{{BuiltinType}}-->Type)),!.

for_any_types :-
	type(Type),
	output_any_type(Type),
	fail.
for_any_types.

output_any_type(Type) :-
	Type=..[T,Arg], \+(T=any),
	name_concat(['in_',T],InT),
	InType=..[InT,Arg],
	output_clause((InType-->in_any(Arg))),!.

%%

tr_clauses(_,[]).
tr_clauses(P,[Cl|CC]) :-
	tr_clause(P,Cl),
	tr_clauses(P,CC).

tr_clause(P,X):- P == X,!.
tr_clause(_,(Head:-Body)) :-
	magic(Head,Magic_Head),
	output_clause((Magic_Head,Body-->Head)),
	magic_body(Magic_Head,Body).
tr_clause(_,(Head:-Body)) :- !,
	output_clause((Body-->Head)).
tr_clause(_,Head) :-
	magic(Head,Magic_Head),
	output_clause((Magic_Head-->Head)).
tr_clause(_,Head) :-
	output_clause((true-->Head)).

magic_body(Magic_Head,(A,B)) :- !,
	magic_body(Magic_Head,A),
	magic_body(Magic_Head,B).
magic_body(Magic_Head,P) :-
	magic(P,MagicP),
	output_clause((Magic_Head-->MagicP)).
magic_body(_,_).

%%

output_clause((_-->true)).
output_clause(Clause) :-
	range_restricted(Clause) ->
	\+(\+((numbervars(Clause,0,_),
	       write(Clause),period,nl))) ;
	\+(\+((numbervars(Clause,0,_),
	       write(user_output,'*** NOT RANGE-RESTRICTED ***'(Clause)),
	       write(user_output,'.'),ttynl,
	       write('*** NOT RANGE-RESTRICTED ***'(Clause)),period,nl))).

range_restricted((Ante-->Cnsq)) :-
	vars_in(Ante,[],VA),
	vars_in(Cnsq,[],VC),
	subset_vars(VC,VA).

%%

tr_positive_ex(PP) :- !,
    Clause =(true --> -PP),
    \+(\+((numbervars(Clause,0,_),
	   write(Clause),period,nl))).

outputHead(OutF) :-
	magic_version(Version),
        nl,write('%%  '),write(OutF),write('  Magic clauses'),
	nl,write('%%  '),write(Version),nl.

%outputFoot(OutF) :-
%        nl,write('%%  '),write(OutF),write('  EOF'),nl.

%vars_in(V,Vi,Vo) :- var(V),!, add_v(V,Vi,Vo).
%vars_in([A|B],Vi,Vo) :- vars_in(A,Vi,Vm), vars_in(B,Vm,Vo).
%vars_in([],Vi,Vi).
%vars_in(Atom,Vi,Vi) :- atom(Atom),!.
%vars_in(Int,Vi,Vi) :- integer(Int),!.
%vars_in(Term,Vi,Vo) :- functor(Term,_,Arity),
%        vars_in_args(1,Arity,Term,Vi,Vo).

%vars_in_args(Jth,Last,Term,Vi,Vo) :-
%        Jth<Last,
%        arg(Jth,Term,Arg),
%        vars_in(Arg,Vi,Vm),
%        J1th is Jth+1,
%        vars_in_args(J1th,Last,Term,Vm,Vo).
%vars_in_args(Last,Last,Term,Vi,Vo) :-
%        arg(Last,Term,Arg),
%        vars_in(Arg,Vi,Vo).
%
%add_v(V,[V1|Vi],[V1|Vi]) :- V==V1,!.
%add_v(V,[V1|Vi],[V1|Vo]) :- add_v(V,Vi,Vo).
%add_v(V,[],[V]).

%makeConj(true,true,true) :- !.
%makeConj(P,true,P) :- !.
%makeConj(true,Q,Q) :- !.
%makeConj(P,Q,(P,Q)) :- !.

%variant(X,Y) :-
%        \+(\+(( numbervars(X,0,_), numbervars(Y,0,_), X=Y ))).

%member_var(V,[U|_]) :- V==U,!.
%member_var(V,[_|W]) :- member_var(V,W).

%subset_vars([V|Vs1],Vs2) :- member_var(V,Vs2),!,
%        subset_vars(Vs1,Vs2).
%subset_vars([],_).

%union_vars(Vs1,[],Vs1) :- !.
%union_vars([],Vs2,Vs2) :- !.
%union_vars([V|Vs1],Vs2,UVs) :- member_var(V,Vs2),!,
%        union_vars(Vs1,Vs2,UVs).
%union_vars([V|Vs1],Vs2,[V|UVs]) :- union_vars(Vs1,Vs2,UVs).

%intersection_vars(_,[],[]) :- !.
%intersection_vars([],_,[]) :- !.
%intersection_vars([V|Vs1],Vs2,[V|IVs]) :- member_var(V,Vs2),!,
%         intersection_vars(Vs1,Vs2,IVs).
%intersection_vars([_|Vs1],Vs2,IVs) :- intersection_vars(Vs1,Vs2,IVs).
